import { Arguments } from '@kui-shell/core';
import { KubeOptions } from '../../controller/kubectl/options';
export interface TypedEntityName {
    type: string;
    fqn: string;
    actionName?: string;
    packageName?: string;
}
export declare const maybeAsDate: (str: any) => any;
export declare const isDirectory: (filepath: string) => Promise<boolean>;
export declare const toOpenWhiskFQN: ({ kind, spec, metadata }: {
    kind: any;
    spec: any;
    metadata: any;
}) => TypedEntityName;
export declare class StatusError extends Error {
}
export declare class TryLaterError extends StatusError {
}
export declare class NotFoundError extends StatusError {
    code: any;
    constructor(message: string, code?: any);
}
export declare const getCommandFromArgs: (args: {
    argvNoOptions: string[];
}) => string;
export declare const commandWithoutResource: (args: Arguments<KubeOptions>) => boolean;
