import { Table, Row, Arguments, MixedResponse } from '@kui-shell/core';
import KubeOptions from '../../controller/kubectl/options';
import { RawResponse } from '../../controller/kubectl/response';
export interface Pair {
    key: string;
    value: string;
}
export declare const preprocessTable: (raw: string[]) => Pair[][][];
export declare const formatTable: <O extends KubeOptions>(command: string, verb: string, entityTypeFromCommandLine: string, options: O, preTable: Pair[][]) => Table<Row>;
export declare type KubeTableResponse = Table | MixedResponse | string;
export declare function isKubeTableResponse(response: KubeTableResponse | RawResponse): response is KubeTableResponse;
export declare const stringToTable: <O extends KubeOptions>(decodedResult: string, stderr: string, args: Arguments<O>, command?: string, verb?: string, entityType?: string) => KubeTableResponse;
