var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, waitForRed, createNS, waitTillNone } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
const ns1 = createNS();
const ns2 = createNS();
const synonyms = ['kubectl'];
describe(`kubectl namespace ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    synonyms.forEach(kubectl => {
        const getText = () => {
            return this.app.client
                .execute(() => {
                return document.querySelector('.monaco-editor-wrapper')['editor'].getValue();
            })
                .then(res => res.value);
        };
        const expectDescribeText = (name) => () => {
            return this.app.client.waitUntil(() => __awaiter(this, void 0, void 0, function* () {
                const actualText = yield getText();
                return new RegExp(`NAME:\\s+${name}`).test(actualText);
            }));
        };
        const deleteIt = (name, errOk = false) => {
            it(`should delete the namespace ${name} via ${kubectl}`, () => {
                return CLI.command(`${kubectl} delete namespace ${name}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(name) }))
                    .then(selector => waitForRed(this.app, selector))
                    .then(() => waitTillNone('namespace', undefined, name))
                    .catch(err => {
                    if (!errOk) {
                        return Common.oops(this)(err);
                    }
                });
            });
        };
        const createIt = (name) => {
            it(`should create namespace ${name} via ${kubectl}`, () => {
                return CLI.command(`${kubectl} create namespace ${name}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME(name) }))
                    .then(selector => waitForGreen(this.app, selector))
                    .catch(Common.oops(this));
            });
        };
        const switchToDefault = () => {
            it('should switch back to default via command', () => {
                return CLI.command(`namespace switch default`, this.app)
                    .then(ReplExpect.okWithAny)
                    .catch(Common.oops(this, true));
            });
            it('should show default as current namespace', () => {
                return CLI.command(`namespace current`, this.app)
                    .then(ReplExpect.okWithString('default'))
                    .catch(Common.oops(this, true));
            });
        };
        const listIt = (ns1) => {
            it('should show default as current namespace', () => {
                return CLI.command(`namespace current`, this.app)
                    .then(ReplExpect.okWithString('default'))
                    .catch(Common.oops(this, true));
            });
            it(`should list the namespace default`, () => {
                return CLI.command(`${kubectl} get ns`, this.app)
                    .then(ReplExpect.okWith('default'))
                    .catch(Common.oops(this, true));
            });
            it(`should list the namespace ${ns1}`, () => {
                return CLI.command(`${kubectl} get ns`, this.app)
                    .then(ReplExpect.okWith(ns1))
                    .catch(Common.oops(this, true));
            });
            it(`should initiate namespace switch via click`, () => {
                return CLI.command(`${kubectl} get ns ${ns1}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: `${Selectors.BY_NAME('')} .selected-entity.clickable` }))
                    .then(selector => this.app.client.click(selector))
                    .catch(Common.oops(this));
            });
            it(`should show ${ns1} as current namespace`, () => {
                return CLI.command(`namespace current`, this.app)
                    .then(ReplExpect.okWithString(ns1))
                    .catch(Common.oops(this, true));
            });
            switchToDefault();
        };
        const listItViaStatusStripe = () => {
            it('should list namespaces by clicking on status stripe widget', () => __awaiter(this, void 0, void 0, function* () {
                const res = yield CLI.command('echo hi', this.app);
                yield ReplExpect.okWithString('hi')(res);
                yield this.app.client.click('#kui--status-stripe .kui--plugin-kubeui--current-namespace .clickable');
                yield ReplExpect.okWith('default')({ app: this.app, count: res.count + 1 });
            }));
        };
        const describeIt = (name) => {
            it(`should describe that namespace ${name} via ${kubectl}`, () => {
                return CLI.command(`${kubectl} describe namespace ${name}`, this.app)
                    .then(ReplExpect.justOK)
                    .then(SidecarExpect.open)
                    .then(SidecarExpect.showing(name))
                    .then(SidecarExpect.mode('summary'))
                    .then(expectDescribeText(name))
                    .catch(Common.oops(this));
            });
        };
        const createPod = (ns) => {
            it(`should create sample pod in namespace ${ns} from URL via ${kubectl}`, () => {
                return CLI.command(`${kubectl} create -f https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod -n ${ns}`, this.app)
                    .then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }))
                    .then(selector => waitForGreen(this.app, selector))
                    .catch(Common.oops(this));
            });
            it(`should show the sample pod in namespace ${ns} in sidecar via ${kubectl}`, () => {
                return CLI.command(`${kubectl} get pod nginx -n ${ns} -o yaml`, this.app)
                    .then(ReplExpect.justOK)
                    .then(SidecarExpect.open)
                    .then(SidecarExpect.showing('nginx', undefined, undefined, ns))
                    .catch(Common.oops(this));
            });
        };
        const deleteViaButton = (ns) => {
            it('should delete the namespace via clicking deletion button in the sidecar', () => {
                return CLI.command(`${kubectl} get ns ${ns} -o yaml`, this.app)
                    .then((res) => __awaiter(this, void 0, void 0, function* () {
                    yield ReplExpect.justOK(res);
                    yield SidecarExpect.open(this.app);
                    const deletionButton = Selectors.SIDECAR_MODE_BUTTON('delete');
                    yield this.app.client.waitForExist(deletionButton);
                    yield this.app.client.click(deletionButton);
                    yield this.app.client.waitForExist('#confirm-dialog');
                    yield this.app.client.click('#confirm-dialog .bx--btn--danger');
                    const deletionEntitySelector = yield ReplExpect.okWithCustom({
                        selector: Selectors.BY_NAME(ns)
                    })({ app: this.app, count: res.count + 1 });
                    return waitForRed(this.app, deletionEntitySelector);
                }))
                    .catch(Common.oops(this));
            });
        };
        switchToDefault();
        createIt(ns1);
        listItViaStatusStripe();
        listIt(ns1);
        describeIt(ns1);
        createIt(ns2);
        describeIt(ns2);
        createPod(ns1);
        createPod(ns2);
        deleteIt(ns1);
        deleteViaButton(ns2);
    });
});
//# sourceMappingURL=namespace.js.map