var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Common, CLI, ReplExpect, SidecarExpect, Selectors } from '@kui-shell/test';
import { waitForGreen, defaultModeForGet, createNS, allocateNS, deleteNS } from '@kui-shell/plugin-kubeui/tests/lib/k8s/utils';
const synonyms = ['kubectl'];
describe(`kubectl top pod ${process.env.MOCHA_RUN_TARGET || ''}`, function () {
    before(Common.before(this));
    after(Common.after(this));
    synonyms.forEach(kubectl => {
        const ns = createNS();
        const inNamespace = `-n ${ns}`;
        allocateNS(this, ns);
        xit('should create a pod', () => __awaiter(this, void 0, void 0, function* () {
            try {
                const selector = yield CLI.command(`${kubectl} create -f https://raw.githubusercontent.com/kubernetes/examples/master/staging/pod ${inNamespace}`, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }));
                yield waitForGreen(this.app, selector);
            }
            catch (err) {
                return Common.oops(this, true)(err);
            }
        }));
        const top1 = `${kubectl} top pod ${inNamespace}`;
        xit(`should show that pod in a list via ${top1}`, () => {
            return CLI.command(top1, this.app)
                .then(ReplExpect.okWith('nginx'))
                .catch(Common.oops(this, true));
        });
        const top2 = `${kubectl} top ${inNamespace} pod`;
        xit(`should show that pod in a list via ${top2}`, () => {
            return CLI.command(top1, this.app)
                .then(ReplExpect.okWith('nginx'))
                .catch(Common.oops(this, true));
        });
        xit(`should click on top row and show pod in sidecar using ${top1}`, () => __awaiter(this, void 0, void 0, function* () {
            try {
                const selector = yield CLI.command(top1, this.app).then(ReplExpect.okWithCustom({ selector: Selectors.BY_NAME('nginx') }));
                yield this.app.client.click(`${selector} .clickable`);
                yield SidecarExpect.open(this.app)
                    .then(SidecarExpect.mode(defaultModeForGet))
                    .then(SidecarExpect.showing('nginx'));
            }
            catch (err) {
                return Common.oops(this, true)(err);
            }
        }));
        deleteNS(this, ns);
    });
});
//# sourceMappingURL=top.js.map