"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const catchall_1 = require("@kui-shell/plugin-bash-like/dist/lib/cmds/catchall");
const Debug = require("debug");
const debug = Debug('plugins/addons');
const bashLikeRoutes = ['/git/status', '/git/diff', '/lls'];
const k8sRoutes = ['/istio/install', '/istio/uninstall', '/istio/ingress', '/istio/status',
    '/bookinfo/install', '/bookinfo/uninstall', '/bookinfo/create',
    '/kiali/install', '/kiali/delete', '/kiali/console', '/kiali/graph',
    '/k8s/kedit', '/k8s/kdebug'];
const coreSupportRoutes = ['/run', '/window', '/window/bigger', '/window/smaller', '/window/max', '/window/unmax', '/window/close', '/quit'];
const blockKUICommand = (route, commandTree) => __awaiter(void 0, void 0, void 0, function* () {
    commandTree.listen(route, () => {
        return Promise.reject('Command is disabled');
    }, { noAuthOk: true, inBrowserOk: true });
    yield commandTree.find(route);
    commandTree.listen(route, () => {
        return Promise.reject('Command is disabled');
    }, { noAuthOk: true, inBrowserOk: true });
});
const rewriteLSCommand = (commandTree) => __awaiter(void 0, void 0, void 0, function* () {
    const route = '/ls';
    commandTree.listen(route, () => {
        return Promise.reject('Command is disabled');
    }, { noAuthOk: true, inBrowserOk: true });
    yield commandTree.find(route);
    commandTree.listen(route, (opts) => {
        debug('ls dispatch to shell');
        return catchall_1.dispatchToShell(opts);
    }, { noAuthOk: true, inBrowserOk: true });
});
const rewriteExecCommand = (commandTree) => __awaiter(void 0, void 0, void 0, function* () {
    const route = '/!';
    commandTree.listen(route, () => {
        return Promise.reject('Command is disabled');
    }, { noAuthOk: true, inBrowserOk: true });
    yield commandTree.find(route);
    commandTree.listen(route, (opts) => {
        debug('! dispatch to shell');
        return catchall_1.dispatchToShell(opts);
    }, { noAuthOk: true, inBrowserOk: true });
});
const redirectHelp = (commandTree) => __awaiter(void 0, void 0, void 0, function* () {
    commandTree.listen('/help', () => {
        return Promise.reject('Command is disabled');
    }, { noAuthOk: true, inBrowserOk: true });
    yield commandTree.find('/help');
    commandTree.listen('/help', ({ REPL }) => {
        return REPL.qexec('getting started');
    }, { noAuthOk: true, inBrowserOk: true });
});
exports.default = (commandTree) => __awaiter(void 0, void 0, void 0, function* () {
    const allRoutes = [...bashLikeRoutes, ...k8sRoutes, ...coreSupportRoutes];
    return Promise.all([redirectHelp(commandTree), rewriteExecCommand(commandTree), rewriteLSCommand(commandTree), rewriteLSCommand(commandTree), ...allRoutes.map((route) => blockKUICommand(route, commandTree))]);
});
//# sourceMappingURL=plugin.js.map