"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const core_1 = require("@kui-shell/core");
const debug = debug_1.default('plugin-logui/formats/json');
const strings = core_1.i18n('plugin-kubeui');
exports.default = {
    entry: (line) => {
        try {
            const record = JSON.parse(line);
            const base = {
                level: record.level.toUpperCase(),
                timestamp: new Date(1000 * parseFloat(record.ts)).toLocaleString(),
                detail1: record.logger,
                detail1Key: strings('Logger'),
                message: record.msg
            };
            const rest = Object.assign({}, record);
            delete rest.level;
            delete rest.logger;
            delete rest.msg;
            delete rest.ts;
            if (Object.keys(rest).length > 0) {
                return Object.assign(base, {
                    messageDetail: rest
                });
            }
            else {
                return base;
            }
        }
        catch (err) {
            debug('error parsing json', line, err);
            return undefined;
        }
    }
};
//# sourceMappingURL=json.js.map