"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const plugin_kubeui_1 = require("@kui-shell/plugin-kubeui");
const strings = core_1.i18n('plugin-logui');
function deploymentLogs(tab, resource, args) {
    return `${plugin_kubeui_1.getCommandFromArgs(args)} logs deployment/${resource.metadata.name} -n ${resource.metadata.namespace} --all-containers --tail 20`;
}
function jobLogs(tab, resource, args) {
    return `${plugin_kubeui_1.getCommandFromArgs(args)} logs job/${resource.metadata.name} -n ${resource.metadata.namespace} --tail 20`;
}
function podLogs(tab, resource, args) {
    return `${plugin_kubeui_1.getCommandFromArgs(args)} logs ${resource.metadata.name} -n ${resource.metadata.namespace} --all-containers --tail 20`;
}
function hasLogs(resource) {
    return plugin_kubeui_1.isPod(resource) || plugin_kubeui_1.isDeployment(resource) || plugin_kubeui_1.isJob(resource);
}
const renderLogs = (tab, resource, args) => {
    if (plugin_kubeui_1.isDeployment(resource)) {
        return deploymentLogs(tab, resource, args);
    }
    else if (plugin_kubeui_1.isPod(resource)) {
        return podLogs(tab, resource, args);
    }
    else if (plugin_kubeui_1.isJob(resource)) {
        return jobLogs(tab, resource, args);
    }
    else {
        return '';
    }
};
exports.default = {
    when: hasLogs,
    mode: {
        mode: 'logs',
        label: strings('Show Logs'),
        command: renderLogs,
        kind: 'drilldown'
    }
};
//# sourceMappingURL=show-logs.js.map