"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@kui-shell/core");
const resource_1 = require("../models/resource");
const strings = core_1.i18n('plugin-logui');
function hasStackTrace(resource) {
    return (resource_1.isLogEntryResource(resource) &&
        resource.spec.entry.messageDetail !== undefined &&
        resource.spec.entry.messageDetail.stacktrace !== undefined);
}
function renderStackTrace(tab, resource) {
    const rows = document.createElement('div');
    rows.classList.add('padding-content', 'smaller-text');
    const traceLines = resource.spec.entry.messageDetail.stacktrace.split(/\n/);
    for (let idx = 0; idx < traceLines.length; idx += 2) {
        const l1 = document.createElement('pre');
        const l2 = document.createElement('pre');
        l1.innerText = traceLines[idx];
        l2.innerText = traceLines[idx + 1];
        rows.appendChild(l1);
        rows.appendChild(l2);
        l2.classList.add('sub-text', 'smaller-text');
    }
    return rows;
}
exports.default = {
    when: hasStackTrace,
    mode: {
        mode: 'stack-trace',
        label: strings('Stack Trace'),
        content: renderStackTrace
    }
};
//# sourceMappingURL=stack-trace.js.map