var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import apiVersion from '../controller/kubectl/apiVersion';
export { apiVersion };
export const kind = 'LogEntry';
export function isLogEntryResource(resource) {
    return resource.apiVersion === apiVersion && resource.kind === kind;
}
export function resourceFromLogEntry(logLine, { involvedObject }) {
    return __awaiter(this, void 0, void 0, function* () {
        const { safeDump } = yield import('js-yaml');
        return {
            apiVersion,
            kind,
            isSimulacrum: true,
            originatingCommand: undefined,
            metadata: {
                name: involvedObject.name,
                namespace: involvedObject.namespace
            },
            spec: {
                entry: logLine
            },
            involvedObject,
            data: safeDump(logLine),
            summary: {
                content: logLine.message
            }
        };
    });
}
//# sourceMappingURL=resource.js.map