import { i18n } from '@kui-shell/core';
import { isLogEntryResource } from '../models/resource';
const strings = i18n('plugin-logui');
function hasStackTrace(resource) {
    return (isLogEntryResource(resource) &&
        resource.spec.entry.messageDetail !== undefined &&
        resource.spec.entry.messageDetail.stacktrace !== undefined);
}
function renderStackTrace(tab, resource) {
    const rows = document.createElement('div');
    rows.classList.add('padding-content', 'smaller-text');
    const traceLines = resource.spec.entry.messageDetail.stacktrace.split(/\n/);
    for (let idx = 0; idx < traceLines.length; idx += 2) {
        const l1 = document.createElement('pre');
        const l2 = document.createElement('pre');
        l1.innerText = traceLines[idx];
        l2.innerText = traceLines[idx + 1];
        rows.appendChild(l1);
        rows.appendChild(l2);
        l2.classList.add('sub-text', 'smaller-text');
    }
    return rows;
}
export default {
    when: hasStackTrace,
    mode: {
        mode: 'stack-trace',
        label: strings('Stack Trace'),
        content: renderStackTrace
    }
};
//# sourceMappingURL=stack-trace.js.map