(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react'), require('@carbon/icon-helpers'), require('prop-types')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react', '@carbon/icon-helpers', 'prop-types'], factory) :
  (global = global || self, factory(global.CarbonIconsReact = {}, global.React, global.CarbonIconHelpers, global.PropTypes));
}(this, (function (exports, React, iconHelpers, PropTypes) { 'use strict';

  React = React && React.hasOwnProperty('default') ? React['default'] : React;
  PropTypes = PropTypes && PropTypes.hasOwnProperty('default') ? PropTypes['default'] : PropTypes;

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _extends() {
    _extends = Object.assign || function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];

        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }

      return target;
    };

    return _extends.apply(this, arguments);
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);

    if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);
      if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });
      keys.push.apply(keys, symbols);
    }

    return keys;
  }

  function _objectSpread2(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};

      if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }

    return target;
  }

  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;

    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }

    return target;
  }

  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};

    var target = _objectWithoutPropertiesLoose(source, excluded);

    var key, i;

    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }

    return target;
  }

  var Icon = React.forwardRef(function Icon(_ref, ref) {
    var className = _ref.className,
        children = _ref.children,
        tabIndex = _ref.tabIndex,
        rest = _objectWithoutProperties(_ref, ["className", "children", "tabIndex"]);

    var _getAttributes = iconHelpers.getAttributes(_objectSpread2({}, rest, {
      tabindex: tabIndex
    })),
        tabindex = _getAttributes.tabindex,
        props = _objectWithoutProperties(_getAttributes, ["tabindex"]);

    if (className) {
      props.className = className;
    }

    if (tabindex !== undefined && tabindex !== null) {
      props.tabIndex = tabindex;
    }

    if (ref) {
      props.ref = ref;
    }

    return React.createElement('svg', props, children);
  });
  Icon.displayName = 'Icon';
  Icon.propTypes = {
    'aria-hidden': PropTypes.string,
    'aria-label': PropTypes.string,
    'aria-labelledby': PropTypes.string,
    className: PropTypes.string,
    children: PropTypes.node,
    height: PropTypes.number,
    preserveAspectRatio: PropTypes.string,
    tabIndex: PropTypes.string,
    viewBox: PropTypes.string,
    width: PropTypes.number,
    xmlns: PropTypes.string
  };
  Icon.defaultProps = {
    xmlns: 'http://www.w3.org/2000/svg',
    preserveAspectRatio: 'xMidYMid meet'
  };

  var Apps16=/*#__PURE__*/React.forwardRef(function Apps16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M4 2v2H2V2h2zm1-1H1v4h4V1zM9 2v2H7V2h2zm1-1H6v4h4V1zM14 2v2h-2V2h2zm1-1h-4v4h4V1zM4 7v2H2V7h2zm1-1H1v4h4V6zM9 7v2H7V7h2zm1-1H6v4h4V6zM14 7v2h-2V7h2zm1-1h-4v4h4V6zM4 12v2H2v-2h2zm1-1H1v4h4v-4zM9 12v2H7v-2h2zm1-1H6v4h4v-4zM14 12v2h-2v-2h2zm1-1h-4v4h4v-4z"}),props.children);});var ArrowDown16=/*#__PURE__*/React.forwardRef(function ArrowDown16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"12.3,9.3 8.5,13.1 8.5,1 7.5,1 7.5,13.1 3.7,9.3 3,10 8,15 13,10"}),props.children);});var ArrowLeft16=/*#__PURE__*/React.forwardRef(function ArrowLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"6.7,12.3 2.9,8.5 15,8.5 15,7.5 2.9,7.5 6.7,3.7 6,3 1,8 6,13"}),props.children);});var ArrowRight16=/*#__PURE__*/React.forwardRef(function ArrowRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"9.3,3.7 13.1,7.5 1,7.5 1,8.5 13.1,8.5 9.3,12.3 10,13 15,8 10,3"}),props.children);});var ArrowUp16=/*#__PURE__*/React.forwardRef(function ArrowUp16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"3.7,6.7 7.5,2.9 7.5,15 8.5,15 8.5,2.9 12.3,6.7 13,6 8,1 3,6"}),props.children);});var Asleep16=/*#__PURE__*/React.forwardRef(function Asleep16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M7.2,2.3c-1,4.4,1.7,8.7,6.1,9.8c0.1,0,0.1,0,0.2,0c-1.1,1.2-2.7,1.8-4.3,1.8c-0.1,0-0.2,0-0.2,0C5.6,13.8,3,11,3.2,7.7\tC3.2,5.3,4.8,3.1,7.2,2.3 M8,1L8,1C4.1,1.6,1.5,5.3,2.1,9.1c0.6,3.3,3.4,5.8,6.8,5.9c0.1,0,0.2,0,0.3,0c2.3,0,4.4-1.1,5.8-3\tc0.2-0.2,0.1-0.6-0.1-0.7c-0.1-0.1-0.2-0.1-0.3-0.1c-3.9-0.3-6.7-3.8-6.4-7.6C8.3,3,8.4,2.4,8.6,1.8c0.1-0.3,0-0.6-0.3-0.7\tC8.1,1,8.1,1,8,1z"}),props.children);});var Awake16=/*#__PURE__*/React.forwardRef(function Awake16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("rect",{width:"1",height:"2.5",x:"7.5",y:"1"}),React.createElement("rect",{width:"2.5",height:"1",x:"10.8",y:"3.4",transform:"rotate(-45.001 12.074 3.922)"}),React.createElement("rect",{width:"2.5",height:"1",x:"12.5",y:"7.5"}),React.createElement("rect",{width:"1",height:"2.5",x:"11.6",y:"10.8",transform:"rotate(-45.001 12.077 12.075)"}),React.createElement("rect",{width:"1",height:"2.5",x:"7.5",y:"12.5"}),React.createElement("rect",{width:"2.5",height:"1",x:"2.7",y:"11.6",transform:"rotate(-45.001 3.929 12.078)"}),React.createElement("rect",{width:"2.5",height:"1",x:"1",y:"7.5"}),React.createElement("rect",{width:"1",height:"2.5",x:"3.4",y:"2.7",transform:"rotate(-45.001 3.926 3.925)"}),React.createElement("path",{d:"M8,6c1.1,0,2,0.9,2,2s-0.9,2-2,2S6,9.1,6,8S6.9,6,8,6 M8,5C6.3,5,5,6.3,5,8s1.3,3,3,3s3-1.3,3-3S9.7,5,8,5z"}),props.children);});var CheckmarkFilled16=/*#__PURE__*/React.forwardRef(function CheckmarkFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8c0,3.9,3.1,7,7,7s7-3.1,7-7C15,4.1,11.9,1,8,1z M7,11L4.3,8.3l0.9-0.8L7,9.3l4-3.9l0.9,0.8L7,11z"}),React.createElement("path",{d:"M7,11L4.3,8.3l0.9-0.8L7,9.3l4-3.9l0.9,0.8L7,11z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var ChevronDown16=/*#__PURE__*/React.forwardRef(function ChevronDown16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"8,11 3,6 3.7,5.3 8,9.6 12.3,5.3 13,6"}),props.children);});var ChevronLeft16=/*#__PURE__*/React.forwardRef(function ChevronLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"5,8 10,3 10.7,3.7 6.4,8 10.7,12.3 10,13"}),props.children);});var ChevronMini16=/*#__PURE__*/React.forwardRef(function ChevronMini16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"15,9 15,15 9,15"}),props.children);});var ChevronRight16=/*#__PURE__*/React.forwardRef(function ChevronRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"11,8 6,13 5.3,12.3 9.6,8 5.3,3.7 6,3"}),props.children);});var ChevronSortDown16=/*#__PURE__*/React.forwardRef(function ChevronSortDown16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"8,14 4.5,10.5 5.2,9.8 8,12.6 10.8,9.8 11.5,10.5"}),props.children);});var ChevronSortUp16=/*#__PURE__*/React.forwardRef(function ChevronSortUp16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"8,2 11.5,5.5 10.8,6.2 8,3.4 5.2,6.2 4.5,5.5"}),props.children);});var ChevronSort16=/*#__PURE__*/React.forwardRef(function ChevronSort16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"8,14 4.5,10.5 5.2,9.8 8,12.6 10.8,9.8 11.5,10.5"}),React.createElement("polygon",{points:"8,2 11.5,5.5 10.8,6.2 8,3.4 5.2,6.2 4.5,5.5"}),props.children);});var ChevronUp16=/*#__PURE__*/React.forwardRef(function ChevronUp16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"8,5 13,10 12.3,10.7 8,6.4 3.7,10.7 3,10"}),props.children);});var CloseFilled16=/*#__PURE__*/React.forwardRef(function CloseFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M10.7,11.5L8,8.8l-2.7,2.7l-0.8-0.8L7.2,8L4.5,5.3l0.8-0.8L8,7.2\tl2.7-2.7l0.8,0.8L8.8,8l2.7,2.7L10.7,11.5z"}),props.children);});var Download16=/*#__PURE__*/React.forwardRef(function Download16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"13,7 12.3,6.3 8.5,10.1 8.5,1 7.5,1 7.5,10.1 3.7,6.3 3,7 8,12"}),React.createElement("path",{d:"M13,12v2H3v-2H2v2l0,0c0,0.6,0.4,1,1,1h10c0.6,0,1-0.4,1-1l0,0v-2H13z"}),props.children);});var ErrorFilled16=/*#__PURE__*/React.forwardRef(function ErrorFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M10.7,11.5L4.5,5.3l0.8-0.8l6.2,6.2L10.7,11.5z"}),React.createElement("path",{fill:"none",d:"M10.7,11.5L4.5,5.3l0.8-0.8l6.2,6.2L10.7,11.5z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var ErrorOutline16=/*#__PURE__*/React.forwardRef(function ErrorOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M8,14c-3.3,0-6-2.7-6-6s2.7-6,6-6s6,2.7,6,6S11.3,14,8,14z"}),React.createElement("rect",{width:"1.1",height:"8.8",x:"7.4",y:"3.6",transform:"rotate(-45.001 8 8)"}),props.children);});var Export16=/*#__PURE__*/React.forwardRef(function Export16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13,12v2H3v-2H2v2l0,0c0,0.6,0.4,1,1,1h10c0.6,0,1-0.4,1-1l0,0v-2H13z"}),React.createElement("polygon",{points:"3,6 3.7,6.7 7.5,2.9 7.5,12 8.5,12 8.5,2.9 12.3,6.7 13,6 8,1"}),props.children);});var Fade16=/*#__PURE__*/React.forwardRef(function Fade16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M4.1,12.6l-0.6,0.8c0.6,0.5,1.3,0.9,2.1,1.2l0.3-0.9C5.3,13.4,4.7,13,4.1,12.6z"}),React.createElement("path",{d:"M2.1,9l-1,0.2c0.1,0.8,0.4,1.6,0.8,2.3L2.8,11C2.4,10.4,2.2,9.7,2.1,9z"}),React.createElement("path",{d:"M5.9,2.4L5.6,1.4C4.8,1.7,4.1,2.1,3.5,2.7l0.6,0.8C4.7,3,5.3,2.6,5.9,2.4z"}),React.createElement("path",{d:"M2.8,5L1.9,4.5C1.5,5.2,1.3,6,1.1,6.8l1,0.2C2.2,6.3,2.5,5.6,2.8,5z"}),React.createElement("path",{d:"M8,1v1c3.3,0,6,2.7,6,6s-2.7,6-6,6v1c3.9,0,7-3.1,7-7S11.9,1,8,1z"}),props.children);});var HelpFilled16=/*#__PURE__*/React.forwardRef(function HelpFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M8,12.5c-0.4,0-0.8-0.3-0.8-0.8S7.6,11,8,11c0.4,0,0.8,0.3,0.8,0.8\tS8.4,12.5,8,12.5z M8.6,8.6v1.2H7.4V7.5h1.1c0.7,0,1.2-0.6,1.1-1.3c0-0.6-0.5-1.1-1.1-1.1H7.8c-0.7,0-1.2,0.5-1.2,1.2v0.3H5.4V6.3\tC5.4,5,6.5,4,7.8,4h0.7c1.3,0,2.3,1.1,2.2,2.4C10.7,7.6,9.8,8.6,8.6,8.6L8.6,8.6z"}),props.children);});var Help16=/*#__PURE__*/React.forwardRef(function Help16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M8,14c-3.3,0-6-2.7-6-6s2.7-6,6-6s6,2.7,6,6S11.3,14,8,14z"}),React.createElement("circle",{cx:"8",cy:"11.8",r:".8"}),React.createElement("path",{d:"M8.5,4H7.8C6.5,4,5.5,5,5.5,6.2c0,0,0,0,0,0v0.2h1V6.2C6.5,5.6,7.1,5,7.8,5h0.8c0.7,0,1.2,0.6,1.2,1.2S9.2,7.5,8.5,7.5h-1\tv2.2h1V8.5c1.2,0,2.2-1,2.2-2.2S9.7,4,8.5,4z"}),props.children);});var InformationFilled16=/*#__PURE__*/React.forwardRef(function InformationFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M8,3.5c0.4,0,0.8,0.3,0.8,0.8S8.4,5,8,5C7.6,5,7.2,4.7,7.2,4.2\tS7.6,3.5,8,3.5z M10,12.1H6v-1.1h1.4V7.6H6.5V6.4h2.1v4.5H10V12.1z"}),props.children);});var Information16=/*#__PURE__*/React.forwardRef(function Information16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"8.5,11 8.5,6.5 6.5,6.5 6.5,7.5 7.5,7.5 7.5,11 6,11 6,12 10,12 10,11"}),React.createElement("path",{d:"M8,3.5c-0.4,0-0.8,0.3-0.8,0.8S7.6,5,8,5c0.4,0,0.8-0.3,0.8-0.8S8.4,3.5,8,3.5z"}),React.createElement("path",{d:"M8,15c-3.9,0-7-3.1-7-7s3.1-7,7-7s7,3.1,7,7S11.9,15,8,15z M8,2C4.7,2,2,4.7,2,8s2.7,6,6,6s6-2.7,6-6S11.3,2,8,2z"}),props.children);});var Interactions16=/*#__PURE__*/React.forwardRef(function Interactions16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{fillRule:"evenodd",d:"M11,7 L11,9 L13,9 C13.5522847,9 14,9.44771525 14,10 L14,10 L14,13 C14,13.5522847 13.5522847,14 13,14 L13,14 L10,14 L10,7 L11,7 Z M5,9 C5.55228475,9 6,9.44771525 6,10 L6,10 L6,14 L3,14 C2.44771525,14 2,13.5522847 2,13 L2,13 L2,12 C2,11.4477153 2.44771525,11 3,11 L3,11 L5,11 L5,10 L2.5,10 L2.5,9 Z M13,10 L11,10 L11,13 L13,13 L13,10 Z M5,12 L3,12 L3,13 L5,13 L5,12 Z M7.912,2 L7.834,3.911 L9.628,3.248 L9.914,4.119 L8.068,4.626 L9.251,6.134 L8.523,6.667 L7.457,5.068 L6.391,6.667 L5.663,6.134 L6.846,4.626 L5,4.119 L5.286,3.248 L7.08,3.911 L7.002,2 L7.912,2 Z"}),props.children);});var Launch16=/*#__PURE__*/React.forwardRef(function Launch16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13,14H3c-0.6,0-1-0.4-1-1V3c0-0.6,0.4-1,1-1h5v1H3v10h10V8h1v5C14,13.6,13.6,14,13,14z"}),React.createElement("polygon",{points:"10,1 10,2 13.3,2 9,6.3 9.7,7 14,2.7 14,6 15,6 15,1"}),props.children);});var Light16=/*#__PURE__*/React.forwardRef(function Light16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("rect",{width:"1",height:"2.5",x:"7.5",y:"1"}),React.createElement("rect",{width:"2.5",height:"1",x:"10.8",y:"3.4",transform:"rotate(-45.001 12.041 3.923)"}),React.createElement("rect",{width:"2.5",height:"1",x:"12.5",y:"7.5"}),React.createElement("rect",{width:"1",height:"2.5",x:"11.6",y:"10.8",transform:"rotate(-45.001 12.075 12.041)"}),React.createElement("rect",{width:"1",height:"2.5",x:"7.5",y:"12.5"}),React.createElement("rect",{width:"2.5",height:"1",x:"2.7",y:"11.6",transform:"rotate(-45.001 3.96 12.079)"}),React.createElement("rect",{width:"2.5",height:"1",x:"1",y:"7.5"}),React.createElement("rect",{width:"1",height:"2.5",x:"3.4",y:"2.7",transform:"rotate(-45.001 3.925 3.961)"}),React.createElement("path",{d:"M8,6c1.1,0,2,0.9,2,2s-0.9,2-2,2S6,9.1,6,8S6.9,6,8,6 M8,5C6.3,5,5,6.3,5,8s1.3,3,3,3s3-1.3,3-3S9.7,5,8,5z"}),props.children);});var ListBulleted16=/*#__PURE__*/React.forwardRef(function ListBulleted16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("circle",{cx:"3.5",cy:"4.5",r:"1.5"}),React.createElement("circle",{cx:"3.5",cy:"11.5",r:"1.5"}),React.createElement("rect",{width:"7",height:"1",x:"8",y:"11"}),React.createElement("rect",{width:"7",height:"1",x:"8",y:"4"}),props.children);});var Maximize16=/*#__PURE__*/React.forwardRef(function Maximize16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"6,15 6,14 2.7,14 7,9.7 6.3,9 2,13.3 2,10 1,10 1,15"}),React.createElement("polygon",{points:"10,1 10,2 13.3,2 9,6.3 9.7,7 14,2.7 14,6 15,6 15,1"}),props.children);});var Menu16=/*#__PURE__*/React.forwardRef(function Menu16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("rect",{width:"12",height:"1",x:"2",y:"12"}),React.createElement("rect",{width:"12",height:"1",x:"2",y:"9"}),React.createElement("rect",{width:"12",height:"1",x:"2",y:"6"}),React.createElement("rect",{width:"12",height:"1",x:"2",y:"3"}),props.children);});var Minimize16=/*#__PURE__*/React.forwardRef(function Minimize16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"2,9 2,10 5.3,10 1,14.3 1.7,15 6,10.7 6,14 7,14 7,9"}),React.createElement("polygon",{points:"14,7 14,6 10.7,6 15,1.7 14.3,1 10,5.3 10,2 9,2 9,7"}),props.children);});var MisuseOutline16=/*#__PURE__*/React.forwardRef(function MisuseOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M8,14c-3.3,0-6-2.7-6-6s2.7-6,6-6s6,2.7,6,6S11.3,14,8,14z"}),React.createElement("polygon",{points:"10.7,11.5 8,8.8 5.3,11.5 4.5,10.7 7.2,8 4.5,5.3 5.3,4.5 8,7.2 10.7,4.5 11.5,5.3 8.8,8 11.5,10.7"}),props.children);});var Misuse16=/*#__PURE__*/React.forwardRef(function Misuse16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M10.7,11.5L8,8.8l-2.7,2.7l-0.8-0.8L7.2,8L4.5,5.3l0.8-0.8L8,7.2\tl2.7-2.7l0.8,0.8L8.8,8l2.7,2.7L10.7,11.5z"}),React.createElement("path",{d:"M10.7,11.5L8,8.8l-2.7,2.7l-0.8-0.8L7.2,8L4.5,5.3l0.8-0.8L8,7.2l2.7-2.7l0.8,0.8L8.8,8\tl2.7,2.7L10.7,11.5z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var NewTab16=/*#__PURE__*/React.forwardRef(function NewTab16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13,13H3V3h5V2H3C2.4,2,2,2.4,2,3v10c0,0.6,0.4,1,1,1h10c0.6,0,1-0.4,1-1V8h-1V13z"}),React.createElement("polygon",{points:"13,3 13,1 12,1 12,3 10,3 10,4 12,4 12,6 13,6 13,4 15,4 15,3"}),props.children);});var Nominal16=/*#__PURE__*/React.forwardRef(function Nominal16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12,8 C13.6568542,8 15,9.34314575 15,11 C15,12.6568542 13.6568542,14 12,14 C10.3431458,14 9,12.6568542 9,11 C9,9.34314575 10.3431458,8 12,8 Z M4,8 C5.65685425,8 7,9.34314575 7,11 C7,12.6568542 5.65685425,14 4,14 C2.34314575,14 1,12.6568542 1,11 C1,9.34314575 2.34314575,8 4,8 Z M12,9 C10.8954305,9 10,9.8954305 10,11 C10,12.1045695 10.8954305,13 12,13 C13.1045695,13 14,12.1045695 14,11 C14,9.8954305 13.1045695,9 12,9 Z M4,9 C2.8954305,9 2,9.8954305 2,11 C2,12.1045695 2.8954305,13 4,13 C5.1045695,13 6,12.1045695 6,11 C6,9.8954305 5.1045695,9 4,9 Z M8,2 C9.65685425,2 11,3.34314575 11,5 C11,6.65685425 9.65685425,8 8,8 C6.34314575,8 5,6.65685425 5,5 C5,3.34314575 6.34314575,2 8,2 Z M8,3 C6.8954305,3 6,3.8954305 6,5 C6,6.1045695 6.8954305,7 8,7 C9.1045695,7 10,6.1045695 10,5 C10,3.8954305 9.1045695,3 8,3 Z"}),props.children);});var NotificationOff16=/*#__PURE__*/React.forwardRef(function NotificationOff16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M2.5,11.5v-0.8l1.3-1.4C3.9,9.3,4,9.1,4,9V6.5c0-2.2,1.8-4,4-4c0.9,0,1.8,0.3,2.5,0.9l0.7-0.7C10.5,2,9.5,1.6,8.5,1.5v-1h-1\tv1C5,1.8,3,3.9,3,6.5v2.3l-1.4,1.3c-0.1,0.1-0.2,0.2-0.1,0.4v1H2.5z"}),React.createElement("path",{d:"M13,8.8V6.5c0-0.8-0.2-1.6-0.5-2.2L15,1.7L14.3,1L1,14.3L1.7,15l2.5-2.5h1.3C5.5,13.9,6.6,15,8,15s2.5-1.1,2.5-2.5H14\tc0.3,0,0.5-0.2,0.5-0.4c0,0,0,0,0-0.1v-1.5c0-0.1-0.1-0.3-0.1-0.4L13,8.8z M8,14c-0.8,0-1.5-0.7-1.5-1.5h3C9.5,13.3,8.8,14,8,14z M13.5,11.5H5.2L11.7,5C11.9,5.5,12,6,12,6.5V9c0,0.1,0.1,0.3,0.1,0.4l1.4,1.3V11.5z"}),props.children);});var Notification16=/*#__PURE__*/React.forwardRef(function Notification16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M14.4,10.1L13,8.8V6.5c0-2.6-1.9-4.7-4.5-5v-1h-1v1C5,1.8,3,3.9,3,6.5v2.3l-1.4,1.3c-0.1,0.1-0.2,0.2-0.1,0.4V12\tc0,0.3,0.2,0.5,0.4,0.5c0,0,0,0,0.1,0h3.5C5.5,13.9,6.6,15,8,15s2.5-1.1,2.5-2.5H14c0.3,0,0.5-0.2,0.5-0.4c0,0,0,0,0-0.1v-1.5\tC14.5,10.4,14.4,10.2,14.4,10.1z M8,14c-0.8,0-1.5-0.7-1.5-1.5h3C9.5,13.3,8.8,14,8,14z M13.5,11.5h-11v-0.8l1.3-1.4\tC3.9,9.3,4,9.1,4,9V6.5c0-2.2,1.8-4,4-4s4,1.8,4,4V9c0,0.1,0.1,0.3,0.1,0.4l1.4,1.3V11.5z"}),props.children);});var Ordinal16=/*#__PURE__*/React.forwardRef(function Ordinal16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M1,13 L1,12 L3,12 L3,9 L5.999,9 L6,6 L9,6 L9,3 L13,3 L13,12 L15,12 L15,13 L1,13 Z M5.999,10 L4,10 L4,12 L5.999,12 L5.999,10 Z M8.999,7 L6.999,7 L6.999,9 L7,9 L7,12 L8.999,12 L8.999,7 Z M12,4 L10,4 L10,12 L12,12 L12,4 Z"}),props.children);});var PauseOutlineFilled16=/*#__PURE__*/React.forwardRef(function PauseOutlineFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M7,11H6V5h1V11z M10,11H9V5h1V11z"}),props.children);});var PauseOutline16=/*#__PURE__*/React.forwardRef(function PauseOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"7,5 6,5 6,11 7,11 7,5"}),React.createElement("polygon",{points:"10,5 9,5 9,11 10,11 10,5"}),React.createElement("path",{d:"M8,2c3.3,0,6,2.7,6,6s-2.7,6-6,6s-6-2.7-6-6S4.7,2,8,2 M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z"}),props.children);});var Pause16=/*#__PURE__*/React.forwardRef(function Pause16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M6,4v8H4V4H6 M6,3H4C3.4,3,3,3.4,3,4v8c0,0.6,0.4,1,1,1h2c0.6,0,1-0.4,1-1V4C7,3.4,6.6,3,6,3z"}),React.createElement("path",{d:"M12,4v8h-2V4H12 M12,3h-2C9.4,3,9,3.4,9,4v8c0,0.6,0.4,1,1,1h2c0.6,0,1-0.4,1-1V4C13,3.4,12.6,3,12,3z"}),props.children);});var PlayFilled16=/*#__PURE__*/React.forwardRef(function PlayFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M11.7,8.4l-5.5,3c-0.2,0.1-0.3,0.1-0.5,0c-0.2-0.1-0.2-0.3-0.2-0.4V5\tc0-0.2,0.1-0.3,0.2-0.4c0.2-0.1,0.3-0.1,0.5,0l5.5,3C12,7.7,12.1,8,11.9,8.2C11.9,8.3,11.8,8.4,11.7,8.4L11.7,8.4z"}),props.children);});var PlayOutlineFilled16=/*#__PURE__*/React.forwardRef(function PlayOutlineFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M11.7,8.4l-5.5,3c-0.2,0.1-0.3,0.1-0.5,0c-0.2-0.1-0.2-0.3-0.2-0.4V5\tc0-0.2,0.1-0.3,0.2-0.4c0.2-0.1,0.3-0.1,0.5,0l5.5,3C12,7.7,12.1,8,11.9,8.2C11.9,8.3,11.8,8.4,11.7,8.4L11.7,8.4z"}),React.createElement("polygon",{points:"6.5,10.2 10.5,8 6.5,5.8"}),props.children);});var PlayOutline16=/*#__PURE__*/React.forwardRef(function PlayOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,2c3.3,0,6,2.7,6,6s-2.7,6-6,6s-6-2.7-6-6S4.7,2,8,2 M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z"}),React.createElement("path",{d:"M6,11.5c-0.1,0-0.2,0-0.3-0.1c-0.2-0.1-0.2-0.3-0.2-0.4V5c0-0.2,0.1-0.3,0.2-0.4c0.2-0.1,0.3-0.1,0.5,0l5.5,3\tC12,7.7,12.1,8,11.9,8.2c0,0.1-0.1,0.2-0.2,0.2l-5.5,3C6.2,11.5,6.1,11.5,6,11.5z M6.5,5.8v4.3l4-2.2L6.5,5.8z"}),props.children);});var Play16=/*#__PURE__*/React.forwardRef(function Play16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M3.5,14C3.2,14,3,13.8,3,13.5v-11c0-0.2,0.1-0.3,0.2-0.4C3.4,2,3.6,2,3.8,2.1l9.5,5.5c0.2,0.1,0.3,0.4,0.2,0.7\tc0,0.1-0.1,0.1-0.2,0.2l-9.5,5.5C3.7,14,3.6,14,3.5,14z M4,3.4v9.3L12,8L4,3.4z"}),props.children);});var Power16=/*#__PURE__*/React.forwardRef(function Power16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M11.2,2.9l-0.5,0.9c2.6,1.5,3.5,4.9,2,7.5s-4.9,3.5-7.5,2s-3.5-4.9-2-7.5c0.5-0.8,1.2-1.5,2-2L4.8,2.9\tc-3.1,1.8-4.2,5.8-2.4,8.9s5.8,4.2,8.9,2.4s4.2-5.8,2.4-8.9C13.1,4.3,12.2,3.4,11.2,2.9z"}),React.createElement("rect",{width:"1",height:"7",x:"7.5",y:"1"}),props.children);});var Redo16=/*#__PURE__*/React.forwardRef(function Redo16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M4,8c-1.2,0-2,0.8-2,2c0,1.2,0.8,2,2,2h3v1H4c-1.7,0-3-1.2-3-3c0-1.7,1.3-3,3-3l9.1,0l-2-2l0.7-0.7\tL15,7.5l-3.2,3.2L11.1,10l2-2L4,8z"}),props.children);});var Restart16=/*#__PURE__*/React.forwardRef(function Restart16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13,9c0,2.8-2.2,5-5,5s-5-2.2-5-5s2.2-5,5-5h3.1L9.3,5.8L10,6.5l3-3l-3-3L9.3,1.2L11.1,3H8C4.7,3,2,5.7,2,9s2.7,6,6,6\ts6-2.7,6-6H13z"}),props.children);});var Save16=/*#__PURE__*/React.forwardRef(function Save16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13.9,4.6l-2.5-2.5C11.3,2.1,11.1,2,11,2H3C2.4,2,2,2.4,2,3v10c0,0.6,0.4,1,1,1h10c0.6,0,1-0.4,1-1V5\tC14,4.9,13.9,4.7,13.9,4.6z M6,3h4v2H6V3z M10,13H6V9h4V13z M11,13V9c0-0.6-0.4-1-1-1H6C5.4,8,5,8.4,5,9v4H3V3h2v2c0,0.6,0.4,1,1,1\th4c0.6,0,1-0.4,1-1V3.2l2,2V13H11z"}),props.children);});var Search16=/*#__PURE__*/React.forwardRef(function Search16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M15,14.3L10.7,10c1.9-2.3,1.6-5.8-0.7-7.7S4.2,0.7,2.3,3S0.7,8.8,3,10.7c2,1.7,5,1.7,7,0l4.3,4.3L15,14.3z M2,6.5\tC2,4,4,2,6.5,2S11,4,11,6.5S9,11,6.5,11S2,9,2,6.5z"}),props.children);});var Settings16=/*#__PURE__*/React.forwardRef(function Settings16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M13.5,8.4c0-0.1,0-0.3,0-0.4c0-0.1,0-0.3,0-0.4l1-0.8c0.4-0.3,0.4-0.9,0.2-1.3l-1.2-2C13.3,3.2,13,3,12.6,3\tc-0.1,0-0.2,0-0.3,0.1l-1.2,0.4c-0.2-0.1-0.4-0.3-0.7-0.4l-0.3-1.3C10.1,1.3,9.7,1,9.2,1H6.8c-0.5,0-0.9,0.3-1,0.8L5.6,3.1\tC5.3,3.2,5.1,3.3,4.9,3.4L3.7,3C3.6,3,3.5,3,3.4,3C3,3,2.7,3.2,2.5,3.5l-1.2,2C1.1,5.9,1.2,6.4,1.6,6.8l0.9,0.9c0,0.1,0,0.3,0,0.4\tc0,0.1,0,0.3,0,0.4L1.6,9.2c-0.4,0.3-0.5,0.9-0.2,1.3l1.2,2C2.7,12.8,3,13,3.4,13c0.1,0,0.2,0,0.3-0.1l1.2-0.4\tc0.2,0.1,0.4,0.3,0.7,0.4l0.3,1.3c0.1,0.5,0.5,0.8,1,0.8h2.4c0.5,0,0.9-0.3,1-0.8l0.3-1.3c0.2-0.1,0.4-0.2,0.7-0.4l1.2,0.4\tc0.1,0,0.2,0.1,0.3,0.1c0.4,0,0.7-0.2,0.9-0.5l1.1-2c0.2-0.4,0.2-0.9-0.2-1.3L13.5,8.4z M12.6,12l-1.7-0.6c-0.4,0.3-0.9,0.6-1.4,0.8\tL9.2,14H6.8l-0.4-1.8c-0.5-0.2-0.9-0.5-1.4-0.8L3.4,12l-1.2-2l1.4-1.2c-0.1-0.5-0.1-1.1,0-1.6L2.2,6l1.2-2l1.7,0.6\tC5.5,4.2,6,4,6.5,3.8L6.8,2h2.4l0.4,1.8c0.5,0.2,0.9,0.5,1.4,0.8L12.6,4l1.2,2l-1.4,1.2c0.1,0.5,0.1,1.1,0,1.6l1.4,1.2L12.6,12z"}),React.createElement("path",{d:"M8,11c-1.7,0-3-1.3-3-3s1.3-3,3-3s3,1.3,3,3C11,9.6,9.7,11,8,11C8,11,8,11,8,11z M8,6C6.9,6,6,6.8,6,7.9C6,7.9,6,8,6,8\tc0,1.1,0.8,2,1.9,2c0,0,0.1,0,0.1,0c1.1,0,2-0.8,2-1.9c0,0,0-0.1,0-0.1C10,6.9,9.2,6,8,6C8.1,6,8,6,8,6z"}),props.children);});var StarFilled16=/*#__PURE__*/React.forwardRef(function StarFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1L5.7,5.6L0.6,6.3l3.7,3.6L3.5,15L8,12.6l4.6,2.4l-0.9-5.1l3.7-3.6l-5.1-0.7L8,1z"}),props.children);});var StarHalf16=/*#__PURE__*/React.forwardRef(function StarHalf16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"5.7,5.6 0.6,6.3 4.3,9.9 3.5,15 8,12.6 8,1"}),props.children);});var Star16=/*#__PURE__*/React.forwardRef(function Star16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,3.3l1.4,2.8l0.2,0.5l0.5,0.1l3.1,0.4L11,9.2l-0.4,0.4l0.1,0.5l0.5,3.1l-2.8-1.4L8,11.5l-0.5,0.2l-2.8,1.4l0.5-3.1\tl0.1-0.5L5,9.2L2.8,7l3.1-0.4l0.5-0.1L6.6,6L8,3.3 M8,1L5.7,5.6L0.6,6.3l3.7,3.6L3.5,15L8,12.6l4.6,2.4l-0.9-5.1l3.7-3.6l-5.1-0.7\tL8,1z"}),props.children);});var StopFilled16=/*#__PURE__*/React.forwardRef(function StopFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M11,10c0,0.6-0.4,1-1,1H6c-0.6,0-1-0.4-1-1V6c0-0.6,0.4-1,1-1h4\tc0.6,0,1,0.4,1,1V10z"}),props.children);});var StopOutlineFilled16=/*#__PURE__*/React.forwardRef(function StopOutlineFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M11,10c0,0.6-0.4,1-1,1H6c-0.6,0-1-0.4-1-1V6c0-0.6,0.4-1,1-1h4\tc0.6,0,1,0.4,1,1V10z"}),React.createElement("rect",{width:"4",height:"4",x:"6",y:"6"}),props.children);});var StopOutline16=/*#__PURE__*/React.forwardRef(function StopOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,2c3.3,0,6,2.7,6,6s-2.7,6-6,6s-6-2.7-6-6S4.7,2,8,2 M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z"}),React.createElement("path",{d:"M10,6v4H6V6H10 M10,5H6C5.4,5,5,5.4,5,6v4c0,0.6,0.4,1,1,1h4c0.6,0,1-0.4,1-1V6C11,5.4,10.6,5,10,5z"}),props.children);});var Stop16=/*#__PURE__*/React.forwardRef(function Stop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12,4v8H4V4H12 M12,3H4C3.4,3,3,3.4,3,4v8c0,0.6,0.4,1,1,1h8c0.6,0,1-0.4,1-1V4C13,3.4,12.6,3,12,3z"}),props.children);});var Undo16=/*#__PURE__*/React.forwardRef(function Undo16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12,8c1.2,0,2,0.8,2,2c0,1.2-0.8,2-2,2H9v1h3c1.7,0,3-1.2,3-3c0-1.7-1.3-3-3-3L2.9,7l2-2L4.2,4.3L1,7.5\tl3.2,3.2L4.9,10l-2-2L12,8z"}),props.children);});var Unlocked16=/*#__PURE__*/React.forwardRef(function Unlocked16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M12,7H6V4c0-1.1,0.9-2,2-2s2,0.9,2,2h1c0-1.7-1.3-3-3-3S5,2.3,5,4v3H4C3.4,7,3,7.4,3,8v6c0,0.6,0.4,1,1,1h8c0.6,0,1-0.4,1-1\tV8C13,7.4,12.6,7,12,7z M12,14H4V8h8V14z"}),props.children);});var Upload16=/*#__PURE__*/React.forwardRef(function Upload16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"3,9 3.7,9.7 7.5,5.9 7.5,15 8.5,15 8.5,5.9 12.3,9.7 13,9 8,4"}),React.createElement("path",{d:"M3,4V2h10v2h1V2c0-0.6-0.4-1-1-1H3C2.4,1,2,1.4,2,2v2H3z"}),props.children);});var UserAvatar16=/*#__PURE__*/React.forwardRef(function UserAvatar16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M5,13.2v-1.5c0-0.9,0.6-1.6,1.5-1.7h3c0.9,0.1,1.5,0.8,1.5,1.7v1.5\tC9.1,14.3,6.9,14.3,5,13.2L5,13.2z M12,12l0-0.8c0-0.9-1.1-2.1-2.5-2.2h-3C5.1,9.1,4,10.3,4,11.7l0,0.5v0.3c-2.5-2.2-2.7-6-0.5-8.5\ts6-2.7,8.5-0.5s2.7,6,0.5,8.5c-0.1,0.2-0.3,0.3-0.5,0.5V12z"}),React.createElement("path",{d:"M8,3C6.6,3,5.5,4.1,5.5,5.5S6.6,8,8,8s2.5-1.1,2.5-2.5S9.4,3,8,3z M8,7C7.2,7,6.5,6.3,6.5,5.5S7.2,4,8,4s1.5,0.7,1.5,1.5\tS8.8,7,8,7z"}),props.children);});var User16=/*#__PURE__*/React.forwardRef(function User16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,2c1.4,0,2.5,1.1,2.5,2.5S9.4,7,8,7S5.5,5.9,5.5,4.5S6.6,2,8,2 M8,1C6.1,1,4.5,2.6,4.5,4.5S6.1,8,8,8s3.5-1.6,3.5-3.5\tS9.9,1,8,1z"}),React.createElement("path",{d:"M13,15h-1v-2.5c0-1.4-1.1-2.5-2.5-2.5h-3C5.1,10,4,11.1,4,12.5V15H3v-2.5C3,10.6,4.6,9,6.5,9h3c1.9,0,3.5,1.6,3.5,3.5V15z"}),props.children);});var ViewOff16=/*#__PURE__*/React.forwardRef(function ViewOff16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M2.6,11.3l0.7-0.7C2.6,9.8,1.9,9,1.5,8c1-2.5,3.8-4.5,6.5-4.5c0.7,0,1.4,0.1,2,0.4l0.8-0.8C9.9,2.7,9,2.5,8,2.5\tC4.7,2.6,1.7,4.7,0.5,7.8c0,0.1,0,0.2,0,0.3C1,9.3,1.7,10.4,2.6,11.3z"}),React.createElement("path",{d:"M6,7.9c0.1-1,0.9-1.8,1.8-1.8l0.9-0.9C7.2,4.7,5.5,5.6,5.1,7.2C5,7.7,5,8.3,5.1,8.8L6,7.9z"}),React.createElement("path",{d:"M15.5,7.8c-0.6-1.5-1.6-2.8-2.9-3.7L15,1.7L14.3,1L1,14.3L1.7,15l2.6-2.6c1.1,0.7,2.4,1,3.7,1.1c3.3-0.1,6.3-2.2,7.5-5.3\tC15.5,8.1,15.5,7.9,15.5,7.8z M10,8c0,1.1-0.9,2-2,2c-0.3,0-0.7-0.1-1-0.3L9.7,7C9.9,7.3,10,7.6,10,8z M8,12.5c-1,0-2.1-0.3-3-0.8\tl1.3-1.3c1.4,0.9,3.2,0.6,4.2-0.8c0.7-1,0.7-2.4,0-3.4l1.4-1.4c1.1,0.8,2,1.9,2.6,3.2C13.4,10.5,10.6,12.5,8,12.5z"}),props.children);});var View16=/*#__PURE__*/React.forwardRef(function View16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M15.5,7.8C14.3,4.7,11.3,2.6,8,2.5C4.7,2.6,1.7,4.7,0.5,7.8c0,0.1,0,0.2,0,0.3c1.2,3.1,4.1,5.2,7.5,5.3\tc3.3-0.1,6.3-2.2,7.5-5.3C15.5,8.1,15.5,7.9,15.5,7.8z M8,12.5c-2.7,0-5.4-2-6.5-4.5c1-2.5,3.8-4.5,6.5-4.5s5.4,2,6.5,4.5\tC13.4,10.5,10.6,12.5,8,12.5z"}),React.createElement("path",{d:"M8,5C6.3,5,5,6.3,5,8s1.3,3,3,3s3-1.3,3-3S9.7,5,8,5z M8,10c-1.1,0-2-0.9-2-2s0.9-2,2-2s2,0.9,2,2S9.1,10,8,10z"}),props.children);});var WarningAltFilled16=/*#__PURE__*/React.forwardRef(function WarningAltFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M14.9,13.3l-6.5-12C8.3,1,8,0.9,7.8,1.1c-0.1,0-0.2,0.1-0.2,0.2l-6.5,12c-0.1,0.2-0.1,0.3,0,0.5C1.2,13.9,1.3,14,1.5,14h13\tc0.2,0,0.3-0.1,0.4-0.2C15,13.6,15,13.4,14.9,13.3z M7.4,5.5h1.1v4H7.4V5.5z M8,12.2c-0.4,0-0.8-0.3-0.8-0.8s0.3-0.8,0.8-0.8\tc0.4,0,0.8,0.3,0.8,0.8S8.4,12.2,8,12.2z"}),props.children);});var WarningAlt16=/*#__PURE__*/React.forwardRef(function WarningAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M14.5,14h-13c-0.2,0-0.3-0.1-0.4-0.2c-0.1-0.2-0.1-0.3,0-0.5l6.5-12C7.7,1,8,0.9,8.2,1.1c0.1,0,0.2,0.1,0.2,0.2l6.5,12\tc0.1,0.2,0.1,0.3,0,0.5C14.9,13.9,14.7,14,14.5,14z M2.3,13h11.3L8,2.5L2.3,13z"}),React.createElement("rect",{width:"1",height:"3.5",x:"7.5",y:"6"}),React.createElement("path",{d:"M8,10.8c-0.4,0-0.8,0.3-0.8,0.8s0.3,0.8,0.8,0.8c0.4,0,0.8-0.3,0.8-0.8S8.4,10.8,8,10.8z"}),props.children);});var WarningFilled16=/*#__PURE__*/React.forwardRef(function WarningFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.2,1,1,4.2,1,8s3.2,7,7,7s7-3.1,7-7S11.9,1,8,1z M7.5,4h1v5h-1C7.5,9,7.5,4,7.5,4z M8,12.2\tc-0.4,0-0.8-0.4-0.8-0.8s0.3-0.8,0.8-0.8c0.4,0,0.8,0.4,0.8,0.8S8.4,12.2,8,12.2z"}),React.createElement("path",{d:"M7.5,4h1v5h-1C7.5,9,7.5,4,7.5,4z M8,12.2c-0.4,0-0.8-0.4-0.8-0.8s0.3-0.8,0.8-0.8\tc0.4,0,0.8,0.4,0.8,0.8S8.4,12.2,8,12.2z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Warning16=/*#__PURE__*/React.forwardRef(function Warning16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("path",{d:"M8,1C4.1,1,1,4.1,1,8s3.1,7,7,7s7-3.1,7-7S11.9,1,8,1z M8,14c-3.3,0-6-2.7-6-6s2.7-6,6-6s6,2.7,6,6S11.3,14,8,14z"}),React.createElement("rect",{width:"1",height:"5",x:"7.5",y:"4"}),React.createElement("path",{d:"M8,10.2c-0.4,0-0.8,0.3-0.8,0.8s0.3,0.8,0.8,0.8c0.4,0,0.8-0.3,0.8-0.8S8.4,10.2,8,10.2z"}),props.children);});var ZoomIn16=/*#__PURE__*/React.forwardRef(function ZoomIn16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("polygon",{points:"9,6 7,6 7,4 6,4 6,6 4,6 4,7 6,7 6,9 7,9 7,7 9,7"}),React.createElement("path",{d:"M10.7,10C11.5,9,12,7.8,12,6.5C12,3.5,9.5,1,6.5,1S1,3.5,1,6.5S3.5,12,6.5,12c1.3,0,2.5-0.5,3.5-1.3l3.8,3.8l0.7-0.7\tL10.7,10z M6.5,11C4,11,2,9,2,6.5S4,2,6.5,2S11,4,11,6.5S9,11,6.5,11L6.5,11z"}),props.children);});var ZoomOut16=/*#__PURE__*/React.forwardRef(function ZoomOut16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 16 16",ref:ref},props),React.createElement("rect",{width:"5",height:"1",x:"4",y:"6"}),React.createElement("path",{d:"M10.7,10C11.5,9,12,7.8,12,6.5C12,3.5,9.5,1,6.5,1S1,3.5,1,6.5S3.5,12,6.5,12c1.3,0,2.5-0.5,3.5-1.3l3.8,3.8l0.7-0.7\tL10.7,10z M6.5,11C4,11,2,9,2,6.5S4,2,6.5,2S11,4,11,6.5S9,11,6.5,11L6.5,11z"}),props.children);});var ArrowRight20=/*#__PURE__*/React.forwardRef(function ArrowRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("polygon",{points:"11.8,2.8 10.8,3.8 16.2,9.3 1,9.3 1,10.7 16.2,10.7 10.8,16.2 11.8,17.2 19,10"}),props.children);});var CheckmarkFilled20=/*#__PURE__*/React.forwardRef(function CheckmarkFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M10,1c-4.9,0-9,4.1-9,9s4.1,9,9,9s9-4,9-9S15,1,10,1z M8.7,13.5l-3.2-3.2l1-1l2.2,2.2l4.8-4.8l1,1L8.7,13.5z"}),React.createElement("path",{fill:"none",d:"M8.7,13.5l-3.2-3.2l1-1l2.2,2.2l4.8-4.8l1,1L8.7,13.5z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Checkmark20=/*#__PURE__*/React.forwardRef(function Checkmark20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("polygon",{points:"8,13.2 3.6,8.8 2.7,9.7 7.1,14.1 8,15 16.5,6.5 15.6,5.6"}),React.createElement("polygon",{points:"15.6,5.6 8,13.2 3.6,8.8 2.7,9.7 7.1,14.1 8,15 16.5,6.5 15.6,5.6"}),props.children);});var ErrorFilled20=/*#__PURE__*/React.forwardRef(function ErrorFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M10,1c-5,0-9,4-9,9s4,9,9,9s9-4,9-9S15,1,10,1z M13.5,14.5l-8-8l1-1l8,8L13.5,14.5z"}),React.createElement("path",{d:"M13.5,14.5l-8-8l1-1l8,8L13.5,14.5z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Menu20=/*#__PURE__*/React.forwardRef(function Menu20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("rect",{width:"16",height:"1.2",x:"2",y:"14.8"}),React.createElement("rect",{width:"16",height:"1.2",x:"2",y:"11.2"}),React.createElement("rect",{width:"16",height:"1.2",x:"2",y:"7.6"}),React.createElement("rect",{width:"16",height:"1.2",x:"2",y:"4"}),props.children);});var Misuse20=/*#__PURE__*/React.forwardRef(function Misuse20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M10,1c-4.9,0-9,4.1-9,9s4.1,9,9,9s9-4,9-9S15,1,10,1z M13.5,14.5L10,11l-3.5,3.5l-1-1L9,10L5.5,6.5l1-1L10,9l3.5-3.5l1,1\tL11,10l3.5,3.5L13.5,14.5z"}),React.createElement("path",{fill:"none",d:"M13.5,14.5L10,11l-3.5,3.5l-1-1L9,10L5.5,6.5l1-1L10,9l3.5-3.5l1,1L11,10l3.5,3.5L13.5,14.5z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Redo20=/*#__PURE__*/React.forwardRef(function Redo20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M5,9.3c-1.5,0-2.8,1.3-2.8,2.7c0,1.5,1.3,2.7,2.8,2.7h4V16H5c-2.3,0-4-1.7-4-4c0-2.2,1.8-4,4-4h11.6\tl-2.5-2.5L15,4.6l4,4l-4,4l-0.9-0.9l2.5-2.5H5z"}),props.children);});var Save20=/*#__PURE__*/React.forwardRef(function Save20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M17.8,5.5l-3.3-3.3C14.3,2.1,14.2,2,14,2H3.3C2.6,2,2,2.6,2,3.3v13.3C2,17.4,2.6,18,3.3,18h13.3c0.7,0,1.4-0.5,1.4-1.2V6.1\tC18,5.7,17.9,5.7,17.8,5.5z M7.3,3.3h5.3v3.3H7.3V3.3z M12.7,16.7H7.3v-5.3h5.3L12.7,16.7L12.7,16.7z M14,16.7v-5.3\tc0-0.7-0.6-1.3-1.3-1.3H7.3C6.6,10,6,10.6,6,11.3v5.3H3.3V3.3H6v3.3C6,7.4,6.6,8,7.3,8h5.3C13.4,8,14,7.4,14,6.7v-3l2.7,2.7v10.4\tL14,16.7L14,16.7z"}),props.children);});var Time20=/*#__PURE__*/React.forwardRef(function Time20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M10,19c-5,0-9-4-9-9s4-9,9-9s9,4,9,9S15,19,10,19z M10,2.3c-4.3,0-7.7,3.5-7.7,7.7s3.5,7.7,7.7,7.7s7.7-3.5,7.7-7.7\tS14.3,2.3,10,2.3z"}),React.createElement("polygon",{points:"13,13.9 9.4,10.3 9.4,4 10.6,4 10.6,9.7 13.9,13"}),props.children);});var Undo20=/*#__PURE__*/React.forwardRef(function Undo20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M15,9.3c1.5,0,2.8,1.3,2.8,2.7c0,1.5-1.3,2.7-2.8,2.7h-4V16h4c2.3,0,4-1.7,4-4c0-2.2-1.8-4-4-4H3.4\tl2.5-2.5L5,4.6l-4,4l4,4l0.9-0.9L3.4,9.3H15z"}),props.children);});var WarningFilled20=/*#__PURE__*/React.forwardRef(function WarningFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 20 20",ref:ref},props),React.createElement("path",{d:"M10,1c-5,0-9,4-9,9s4,9,9,9s9-4,9-9S15,1,10,1z M9.2,5h1.5v7H9.2V5z M10,16c-0.6,0-1-0.4-1-1s0.4-1,1-1\ts1,0.4,1,1S10.6,16,10,16z"}),React.createElement("path",{d:"M9.2,5h1.5v7H9.2V5z M10,16c-0.6,0-1-0.4-1-1s0.4-1,1-1s1,0.4,1,1S10.6,16,10,16z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var ArrowRight24=/*#__PURE__*/React.forwardRef(function ArrowRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("polygon",{points:"14,4 12.9,5.1 18.9,11.2 2,11.2 2,12.8 18.9,12.8 12.9,18.9 14,20 22,12"}),props.children);});var CheckmarkFilled24=/*#__PURE__*/React.forwardRef(function CheckmarkFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M12,1C6,1,1,6,1,12s5,11,11,11s11-4.9,11-11S18.1,1,12,1z M10.4,16.3l-3.9-3.9l1.3-1.2l2.7,2.7l5.8-5.8l1.3,1.3L10.4,16.3z"}),React.createElement("path",{fill:"none",d:"M10.4,16.3l-3.9-3.9l1.3-1.2l2.7,2.7l5.8-5.8l1.3,1.3L10.4,16.3z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Checkmark24=/*#__PURE__*/React.forwardRef(function Checkmark24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("polygon",{points:"10,15.9 4.7,10.6 3.6,11.6 8.9,16.9 10,18 20.6,7.4 19.5,6.3"}),props.children);});var ErrorFilled24=/*#__PURE__*/React.forwardRef(function ErrorFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M12,1C5.9,1,1,5.9,1,12s4.9,11,11,11s11-4.9,11-11S18.1,1,12,1z M16.3,17.5L6.5,7.7l1.2-1.2l9.8,9.8L16.3,17.5z"}),React.createElement("path",{fill:"none",d:"M16.3,17.5L6.5,7.7l1.2-1.2l9.8,9.8L16.3,17.5z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Menu24=/*#__PURE__*/React.forwardRef(function Menu24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("rect",{width:"18",height:"1.5",x:"3",y:"18"}),React.createElement("rect",{width:"18",height:"1.5",x:"3",y:"13.5"}),React.createElement("rect",{width:"18",height:"1.5",x:"3",y:"9"}),React.createElement("rect",{width:"18",height:"1.5",x:"3",y:"4.5"}),props.children);});var Misuse24=/*#__PURE__*/React.forwardRef(function Misuse24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M12,1C6,1,1,6,1,12s5,11,11,11s11-4.9,11-11S18.1,1,12,1z M16.2,17.5L12,13.3l-4.2,4.2l-1.3-1.3l4.2-4.2L6.5,7.8l1.3-1.3\tl4.2,4.2l4.2-4.2l1.3,1.3L13.3,12l4.2,4.2L16.2,17.5z"}),React.createElement("path",{fill:"none",d:"M16.2,17.5L12,13.3l-4.2,4.2l-1.3-1.3l4.2-4.2L6.5,7.8l1.3-1.3l4.2,4.2l4.2-4.2l1.3,1.3\tL13.3,12l4.2,4.2L16.2,17.5z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var Redo24=/*#__PURE__*/React.forwardRef(function Redo24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M6.8,11.2c-1.8,0-3.2,1.7-3.2,3.3c0,1.5,1.5,3.2,3.2,3.2H10v1.5H6.8C4.6,19.2,2,17,2,14.5s2-4.8,4.8-4.8\th12.4l-3-3l1.1-1.1l4.8,4.8l-4.8,4.8l-1.1-1.1l3-3H6.8z"}),props.children);});var Save24=/*#__PURE__*/React.forwardRef(function Save24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M20.8,7L17,3.2C16.9,3.1,16.7,3,16.5,3h-12C3.7,3,3,3.7,3,4.5v15C3,20.3,3.7,21,4.5,21h15c0.8,0,1.5-0.7,1.5-1.5v-12\tC21,7.3,20.9,7.1,20.8,7z M9,4.5h6v3H9V4.5z M15,19.5H9v-6h6V19.5z M16.5,19.5v-6c0-0.8-0.7-1.5-1.5-1.5H9c-0.8,0-1.5,0.7-1.5,1.5v6\th-3v-15h3v3C7.5,8.3,8.2,9,9,9h6c0.8,0,1.5-0.7,1.5-1.5V4.8l3,3v11.7H16.5z"}),props.children);});var Undo24=/*#__PURE__*/React.forwardRef(function Undo24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M17.2,11.2c1.8,0,3.2,1.7,3.2,3.3c0,1.5-1.5,3.2-3.2,3.2H14v1.5h3.2c2.2,0,4.8-2.3,4.8-4.8s-2-4.8-4.8-4.8\tH4.8l3-3L6.8,5.7L2,10.5l4.8,4.8l1.1-1.1l-3-3H17.2z"}),props.children);});var WarningFilled24=/*#__PURE__*/React.forwardRef(function WarningFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 24 24",ref:ref},props),React.createElement("path",{d:"M12,1C5.9,1,1,5.9,1,12s4.9,11,11,11s11-4.9,11-11C23,5.9,18.1,1,12,1z M11.1,6h1.8v8h-1.8V6z M12,19.2\tc-0.7,0-1.2-0.6-1.2-1.2s0.6-1.2,1.2-1.2s1.2,0.6,1.2,1.2S12.7,19.2,12,19.2z"}),React.createElement("path",{fill:"none",d:"M13.2,18c0,0.7-0.6,1.2-1.2,1.2s-1.2-0.6-1.2-1.2s0.6-1.2,1.2-1.2S13.2,17.3,13.2,18z M12.9,6\th-1.8v8h1.8V6z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var _4KFilled32=/*#__PURE__*/React.forwardRef(function _4KFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM14,21H12V17H8V11h2v4h2V11h2Zm10.19,0H22l-2.09-4.06L19,18.27V21H17V11h2v4.39L22,11h2.19l-3,4.38Z"}),props.children);});var _4KFilled24=/*#__PURE__*/React.forwardRef(function _4KFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM14,21H12V17H8V11h2v4h2V11h2Zm10.19,0H22l-2.09-4.06L19,18.27V21H17V11h2v4.39L22,11h2.19l-3,4.38Z"}),props.children);});var _4KFilled20=/*#__PURE__*/React.forwardRef(function _4KFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM14,21H12V17H8V11h2v4h2V11h2Zm10.19,0H22l-2.09-4.06L19,18.27V21H17V11h2v4.39L22,11h2.19l-3,4.38Z"}),props.children);});var _4KFilled16=/*#__PURE__*/React.forwardRef(function _4KFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM14,21H12V17H8V11h2v4h2V11h2Zm10.19,0H22l-2.09-4.06L19,18.27V21H17V11h2v4.39L22,11h2.19l-3,4.38Z"}),props.children);});var _4K32=/*#__PURE__*/React.forwardRef(function _4K32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12 11.03 12 15.03 10 15.03 10 11.03 8 11.03 8 17.03 12 17.03 12 21.03 14 21.03 14 11.03 12 11.03"}),React.createElement("polygon",{points:"24.19 11.03 22 11.03 19 15.42 19 11.03 17 11.03 17 21.03 19 21.03 19 18.3 19.91 16.97 22 21.03 24.19 21.03 21.2 15.41 24.19 11.03"}),React.createElement("path",{d:"M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"}),props.children);});var _4K24=/*#__PURE__*/React.forwardRef(function _4K24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12 11.03 12 15.03 10 15.03 10 11.03 8 11.03 8 17.03 12 17.03 12 21.03 14 21.03 14 11.03 12 11.03"}),React.createElement("polygon",{points:"24.19 11.03 22 11.03 19 15.42 19 11.03 17 11.03 17 21.03 19 21.03 19 18.3 19.91 16.97 22 21.03 24.19 21.03 21.2 15.41 24.19 11.03"}),React.createElement("path",{d:"M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"}),props.children);});var _4K20=/*#__PURE__*/React.forwardRef(function _4K20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12 11.03 12 15.03 10 15.03 10 11.03 8 11.03 8 17.03 12 17.03 12 21.03 14 21.03 14 11.03 12 11.03"}),React.createElement("polygon",{points:"24.19 11.03 22 11.03 19 15.42 19 11.03 17 11.03 17 21.03 19 21.03 19 18.3 19.91 16.97 22 21.03 24.19 21.03 21.2 15.41 24.19 11.03"}),React.createElement("path",{d:"M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"}),props.children);});var _4K16=/*#__PURE__*/React.forwardRef(function _4K16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12 11.03 12 15.03 10 15.03 10 11.03 8 11.03 8 17.03 12 17.03 12 21.03 14 21.03 14 11.03 12 11.03"}),React.createElement("polygon",{points:"24.19 11.03 22 11.03 19 15.42 19 11.03 17 11.03 17 21.03 19 21.03 19 18.3 19.91 16.97 22 21.03 24.19 21.03 21.2 15.41 24.19 11.03"}),React.createElement("path",{d:"M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"}),props.children);});var Api_132=/*#__PURE__*/React.forwardRef(function Api_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,9H4a2,2,0,0,0-2,2V23H4V18H8v5h2V11A2,2,0,0,0,8,9ZM4,16V11H8v5Z"}),React.createElement("polygon",{points:"22 11 25 11 25 21 22 21 22 23 30 23 30 21 27 21 27 11 30 11 30 9 22 9 22 11"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),props.children);});var Api_124=/*#__PURE__*/React.forwardRef(function Api_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,9H4a2,2,0,0,0-2,2V23H4V18H8v5h2V11A2,2,0,0,0,8,9ZM4,16V11H8v5Z"}),React.createElement("polygon",{points:"22 11 25 11 25 21 22 21 22 23 30 23 30 21 27 21 27 11 30 11 30 9 22 9 22 11"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),props.children);});var Api_120=/*#__PURE__*/React.forwardRef(function Api_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,9H4a2,2,0,0,0-2,2V23H4V18H8v5h2V11A2,2,0,0,0,8,9ZM4,16V11H8v5Z"}),React.createElement("polygon",{points:"22 11 25 11 25 21 22 21 22 23 30 23 30 21 27 21 27 11 30 11 30 9 22 9 22 11"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),props.children);});var Api_116=/*#__PURE__*/React.forwardRef(function Api_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,9H4a2,2,0,0,0-2,2V23H4V18H8v5h2V11A2,2,0,0,0,8,9ZM4,16V11H8v5Z"}),React.createElement("polygon",{points:"22 11 25 11 25 21 22 21 22 23 30 23 30 21 27 21 27 11 30 11 30 9 22 9 22 11"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),props.children);});var Cad32=/*#__PURE__*/React.forwardRef(function Cad32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,9H14a2,2,0,0,0-2,2V23h2V18h4v5h2V11A2,2,0,0,0,18,9Zm-4,7V11h4v5Z"}),React.createElement("path",{d:"M26,23H22V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,26,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H24Z"}),React.createElement("path",{d:"M10,23H4a2,2,0,0,1-2-2V11A2,2,0,0,1,4,9h6v2H4V21h6Z"}),props.children);});var Cad24=/*#__PURE__*/React.forwardRef(function Cad24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,9H14a2,2,0,0,0-2,2V23h2V18h4v5h2V11A2,2,0,0,0,18,9Zm-4,7V11h4v5Z"}),React.createElement("path",{d:"M26,23H22V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,26,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H24Z"}),React.createElement("path",{d:"M10,23H4a2,2,0,0,1-2-2V11A2,2,0,0,1,4,9h6v2H4V21h6Z"}),props.children);});var Cad20=/*#__PURE__*/React.forwardRef(function Cad20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,9H14a2,2,0,0,0-2,2V23h2V18h4v5h2V11A2,2,0,0,0,18,9Zm-4,7V11h4v5Z"}),React.createElement("path",{d:"M26,23H22V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,26,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H24Z"}),React.createElement("path",{d:"M10,23H4a2,2,0,0,1-2-2V11A2,2,0,0,1,4,9h6v2H4V21h6Z"}),props.children);});var Cad16=/*#__PURE__*/React.forwardRef(function Cad16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,9H14a2,2,0,0,0-2,2V23h2V18h4v5h2V11A2,2,0,0,0,18,9Zm-4,7V11h4v5Z"}),React.createElement("path",{d:"M26,23H22V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,26,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H24Z"}),React.createElement("path",{d:"M10,23H4a2,2,0,0,1-2-2V11A2,2,0,0,1,4,9h6v2H4V21h6Z"}),props.children);});var Cda32=/*#__PURE__*/React.forwardRef(function Cda32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H24a2.002,2.002,0,0,0-2,2V23h2V18h4v5h2V11A2.0023,2.0023,0,0,0,28,9Zm-4,7V11h4v5Z"}),React.createElement("path",{d:"M16,23H12V9h4a4.0042,4.0042,0,0,1,4,4v6A4.0039,4.0039,0,0,1,16,23Zm-2-2h2a2.0027,2.0027,0,0,0,2-2V13a2.0023,2.0023,0,0,0-2-2H14Z"}),React.createElement("path",{d:"M10,23H4a2.0023,2.0023,0,0,1-2-2V11A2.002,2.002,0,0,1,4,9h6v2H4V21h6Z"}),props.children);});var Cda24=/*#__PURE__*/React.forwardRef(function Cda24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H24a2.002,2.002,0,0,0-2,2V23h2V18h4v5h2V11A2.0023,2.0023,0,0,0,28,9Zm-4,7V11h4v5Z"}),React.createElement("path",{d:"M16,23H12V9h4a4.0042,4.0042,0,0,1,4,4v6A4.0039,4.0039,0,0,1,16,23Zm-2-2h2a2.0027,2.0027,0,0,0,2-2V13a2.0023,2.0023,0,0,0-2-2H14Z"}),React.createElement("path",{d:"M10,23H4a2.0023,2.0023,0,0,1-2-2V11A2.002,2.002,0,0,1,4,9h6v2H4V21h6Z"}),props.children);});var Cda20=/*#__PURE__*/React.forwardRef(function Cda20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H24a2.002,2.002,0,0,0-2,2V23h2V18h4v5h2V11A2.0023,2.0023,0,0,0,28,9Zm-4,7V11h4v5Z"}),React.createElement("path",{d:"M16,23H12V9h4a4.0042,4.0042,0,0,1,4,4v6A4.0039,4.0039,0,0,1,16,23Zm-2-2h2a2.0027,2.0027,0,0,0,2-2V13a2.0023,2.0023,0,0,0-2-2H14Z"}),React.createElement("path",{d:"M10,23H4a2.0023,2.0023,0,0,1-2-2V11A2.002,2.002,0,0,1,4,9h6v2H4V21h6Z"}),props.children);});var Cda16=/*#__PURE__*/React.forwardRef(function Cda16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H24a2.002,2.002,0,0,0-2,2V23h2V18h4v5h2V11A2.0023,2.0023,0,0,0,28,9Zm-4,7V11h4v5Z"}),React.createElement("path",{d:"M16,23H12V9h4a4.0042,4.0042,0,0,1,4,4v6A4.0039,4.0039,0,0,1,16,23Zm-2-2h2a2.0027,2.0027,0,0,0,2-2V13a2.0023,2.0023,0,0,0-2-2H14Z"}),React.createElement("path",{d:"M10,23H4a2.0023,2.0023,0,0,1-2-2V11A2.002,2.002,0,0,1,4,9h6v2H4V21h6Z"}),props.children);});var Csv32=/*#__PURE__*/React.forwardRef(function Csv32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 9 26 22 24 9 22 9 24.516 23 27.484 23 30 9 28 9"}),React.createElement("path",{d:"M18,23H12V21h6V17H14a2.002,2.002,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H14v4h4a2.002,2.002,0,0,1,2,2v4A2.002,2.002,0,0,1,18,23Z"}),React.createElement("path",{d:"M10,23H4a2.0023,2.0023,0,0,1-2-2V11A2.002,2.002,0,0,1,4,9h6v2H4V21h6Z"}),props.children);});var Csv24=/*#__PURE__*/React.forwardRef(function Csv24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 9 26 22 24 9 22 9 24.516 23 27.484 23 30 9 28 9"}),React.createElement("path",{d:"M18,23H12V21h6V17H14a2.002,2.002,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H14v4h4a2.002,2.002,0,0,1,2,2v4A2.002,2.002,0,0,1,18,23Z"}),React.createElement("path",{d:"M10,23H4a2.0023,2.0023,0,0,1-2-2V11A2.002,2.002,0,0,1,4,9h6v2H4V21h6Z"}),props.children);});var Csv20=/*#__PURE__*/React.forwardRef(function Csv20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 9 26 22 24 9 22 9 24.516 23 27.484 23 30 9 28 9"}),React.createElement("path",{d:"M18,23H12V21h6V17H14a2.002,2.002,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H14v4h4a2.002,2.002,0,0,1,2,2v4A2.002,2.002,0,0,1,18,23Z"}),React.createElement("path",{d:"M10,23H4a2.0023,2.0023,0,0,1-2-2V11A2.002,2.002,0,0,1,4,9h6v2H4V21h6Z"}),props.children);});var Csv16=/*#__PURE__*/React.forwardRef(function Csv16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 9 26 22 24 9 22 9 24.516 23 27.484 23 30 9 28 9"}),React.createElement("path",{d:"M18,23H12V21h6V17H14a2.002,2.002,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H14v4h4a2.002,2.002,0,0,1,2,2v4A2.002,2.002,0,0,1,18,23Z"}),React.createElement("path",{d:"M10,23H4a2.0023,2.0023,0,0,1-2-2V11A2.002,2.002,0,0,1,4,9h6v2H4V21h6Z"}),props.children);});var Doc32=/*#__PURE__*/React.forwardRef(function Doc32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2.0023,2.0023,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H24V21h6Z"}),React.createElement("path",{d:"M18,23H14a2.0023,2.0023,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h4a2.002,2.002,0,0,1,2,2V21A2.0023,2.0023,0,0,1,18,23ZM14,11V21h4V11Z"}),React.createElement("path",{d:"M6,23H2V9H6a4.0045,4.0045,0,0,1,4,4v6A4.0045,4.0045,0,0,1,6,23ZM4,21H6a2.002,2.002,0,0,0,2-2V13a2.002,2.002,0,0,0-2-2H4Z"}),props.children);});var Doc24=/*#__PURE__*/React.forwardRef(function Doc24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2.0023,2.0023,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H24V21h6Z"}),React.createElement("path",{d:"M18,23H14a2.0023,2.0023,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h4a2.002,2.002,0,0,1,2,2V21A2.0023,2.0023,0,0,1,18,23ZM14,11V21h4V11Z"}),React.createElement("path",{d:"M6,23H2V9H6a4.0045,4.0045,0,0,1,4,4v6A4.0045,4.0045,0,0,1,6,23ZM4,21H6a2.002,2.002,0,0,0,2-2V13a2.002,2.002,0,0,0-2-2H4Z"}),props.children);});var Doc20=/*#__PURE__*/React.forwardRef(function Doc20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2.0023,2.0023,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H24V21h6Z"}),React.createElement("path",{d:"M18,23H14a2.0023,2.0023,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h4a2.002,2.002,0,0,1,2,2V21A2.0023,2.0023,0,0,1,18,23ZM14,11V21h4V11Z"}),React.createElement("path",{d:"M6,23H2V9H6a4.0045,4.0045,0,0,1,4,4v6A4.0045,4.0045,0,0,1,6,23ZM4,21H6a2.002,2.002,0,0,0,2-2V13a2.002,2.002,0,0,0-2-2H4Z"}),props.children);});var Doc16=/*#__PURE__*/React.forwardRef(function Doc16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2.0023,2.0023,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H24V21h6Z"}),React.createElement("path",{d:"M18,23H14a2.0023,2.0023,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h4a2.002,2.002,0,0,1,2,2V21A2.0023,2.0023,0,0,1,18,23ZM14,11V21h4V11Z"}),React.createElement("path",{d:"M6,23H2V9H6a4.0045,4.0045,0,0,1,4,4v6A4.0045,4.0045,0,0,1,6,23ZM4,21H6a2.002,2.002,0,0,0,2-2V13a2.002,2.002,0,0,0-2-2H4Z"}),props.children);});var Dvr32=/*#__PURE__*/React.forwardRef(function Dvr32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15V11a2,2,0,0,0-2-2H22V23h2V17h1.48l2.34,6H30l-2.33-6H28A2,2,0,0,0,30,15Zm-6-4h4v4H24Z"}),React.createElement("polygon",{points:"18 9 16 22 14 9 12 9 14.52 23 17.48 23 20 9 18 9"}),React.createElement("path",{d:"M6,23H2V9H6a4,4,0,0,1,4,4v6A4,4,0,0,1,6,23ZM4,21H6a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H4Z"}),props.children);});var Dvr24=/*#__PURE__*/React.forwardRef(function Dvr24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15V11a2,2,0,0,0-2-2H22V23h2V17h1.48l2.34,6H30l-2.33-6H28A2,2,0,0,0,30,15Zm-6-4h4v4H24Z"}),React.createElement("polygon",{points:"18 9 16 22 14 9 12 9 14.52 23 17.48 23 20 9 18 9"}),React.createElement("path",{d:"M6,23H2V9H6a4,4,0,0,1,4,4v6A4,4,0,0,1,6,23ZM4,21H6a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H4Z"}),props.children);});var Dvr20=/*#__PURE__*/React.forwardRef(function Dvr20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15V11a2,2,0,0,0-2-2H22V23h2V17h1.48l2.34,6H30l-2.33-6H28A2,2,0,0,0,30,15Zm-6-4h4v4H24Z"}),React.createElement("polygon",{points:"18 9 16 22 14 9 12 9 14.52 23 17.48 23 20 9 18 9"}),React.createElement("path",{d:"M6,23H2V9H6a4,4,0,0,1,4,4v6A4,4,0,0,1,6,23ZM4,21H6a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H4Z"}),props.children);});var Dvr16=/*#__PURE__*/React.forwardRef(function Dvr16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15V11a2,2,0,0,0-2-2H22V23h2V17h1.48l2.34,6H30l-2.33-6H28A2,2,0,0,0,30,15Zm-6-4h4v4H24Z"}),React.createElement("polygon",{points:"18 9 16 22 14 9 12 9 14.52 23 17.48 23 20 9 18 9"}),React.createElement("path",{d:"M6,23H2V9H6a4,4,0,0,1,4,4v6A4,4,0,0,1,6,23ZM4,21H6a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H4Z"}),props.children);});var Gif32=/*#__PURE__*/React.forwardRef(function Gif32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2,12v8a3,3,0,0,0,3,3h5V15H6v2H8v4H5a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1h5V9H5A3,3,0,0,0,2,12Z"}),React.createElement("polygon",{points:"30 11 30 9 22 9 22 23 24 23 24 17 29 17 29 15 24 15 24 11 30 11"}),React.createElement("polygon",{points:"12 9 12 11 15 11 15 21 12 21 12 23 20 23 20 21 17 21 17 11 20 11 20 9 12 9"}),props.children);});var Gif24=/*#__PURE__*/React.forwardRef(function Gif24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2,12v8a3,3,0,0,0,3,3h5V15H6v2H8v4H5a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1h5V9H5A3,3,0,0,0,2,12Z"}),React.createElement("polygon",{points:"30 11 30 9 22 9 22 23 24 23 24 17 29 17 29 15 24 15 24 11 30 11"}),React.createElement("polygon",{points:"12 9 12 11 15 11 15 21 12 21 12 23 20 23 20 21 17 21 17 11 20 11 20 9 12 9"}),props.children);});var Gif20=/*#__PURE__*/React.forwardRef(function Gif20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2,12v8a3,3,0,0,0,3,3h5V15H6v2H8v4H5a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1h5V9H5A3,3,0,0,0,2,12Z"}),React.createElement("polygon",{points:"30 11 30 9 22 9 22 23 24 23 24 17 29 17 29 15 24 15 24 11 30 11"}),React.createElement("polygon",{points:"12 9 12 11 15 11 15 21 12 21 12 23 20 23 20 21 17 21 17 11 20 11 20 9 12 9"}),props.children);});var Gif16=/*#__PURE__*/React.forwardRef(function Gif16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2,12v8a3,3,0,0,0,3,3h5V15H6v2H8v4H5a1,1,0,0,1-1-1V12a1,1,0,0,1,1-1h5V9H5A3,3,0,0,0,2,12Z"}),React.createElement("polygon",{points:"30 11 30 9 22 9 22 23 24 23 24 17 29 17 29 15 24 15 24 11 30 11"}),React.createElement("polygon",{points:"12 9 12 11 15 11 15 21 12 21 12 23 20 23 20 21 17 21 17 11 20 11 20 9 12 9"}),props.children);});var HdFilled32=/*#__PURE__*/React.forwardRef(function HdFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22,13H20v6h2a1,1,0,0,0,1-1V14A1,1,0,0,0,22,13Z"}),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM15,21H13V17H10v4H8V11h2v4h3V11h2Zm10-3a3,3,0,0,1-3,3H18V11h4a3,3,0,0,1,3,3Z"}),props.children);});var HdFilled24=/*#__PURE__*/React.forwardRef(function HdFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22,13H20v6h2a1,1,0,0,0,1-1V14A1,1,0,0,0,22,13Z"}),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM15,21H13V17H10v4H8V11h2v4h3V11h2Zm10-3a3,3,0,0,1-3,3H18V11h4a3,3,0,0,1,3,3Z"}),props.children);});var HdFilled20=/*#__PURE__*/React.forwardRef(function HdFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22,13H20v6h2a1,1,0,0,0,1-1V14A1,1,0,0,0,22,13Z"}),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM15,21H13V17H10v4H8V11h2v4h3V11h2Zm10-3a3,3,0,0,1-3,3H18V11h4a3,3,0,0,1,3,3Z"}),props.children);});var HdFilled16=/*#__PURE__*/React.forwardRef(function HdFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22,13H20v6h2a1,1,0,0,0,1-1V14A1,1,0,0,0,22,13Z"}),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM15,21H13V17H10v4H8V11h2v4h3V11h2Zm10-3a3,3,0,0,1-3,3H18V11h4a3,3,0,0,1,3,3Z"}),props.children);});var Hd32=/*#__PURE__*/React.forwardRef(function Hd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM4,24V8H28V24Z"}),React.createElement("path",{d:"M22,11H18V21h4a3,3,0,0,0,3-3V14A3,3,0,0,0,22,11Zm1,7a1,1,0,0,1-1,1H20V13h2a1,1,0,0,1,1,1Z"}),React.createElement("polygon",{points:"13 11 13 15 10 15 10 11 8 11 8 21 10 21 10 17 13 17 13 21 15 21 15 11 13 11"}),props.children);});var Hd24=/*#__PURE__*/React.forwardRef(function Hd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM4,24V8H28V24Z"}),React.createElement("path",{d:"M22,11H18V21h4a3,3,0,0,0,3-3V14A3,3,0,0,0,22,11Zm1,7a1,1,0,0,1-1,1H20V13h2a1,1,0,0,1,1,1Z"}),React.createElement("polygon",{points:"13 11 13 15 10 15 10 11 8 11 8 21 10 21 10 17 13 17 13 21 15 21 15 11 13 11"}),props.children);});var Hd20=/*#__PURE__*/React.forwardRef(function Hd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM4,24V8H28V24Z"}),React.createElement("path",{d:"M22,11H18V21h4a3,3,0,0,0,3-3V14A3,3,0,0,0,22,11Zm1,7a1,1,0,0,1-1,1H20V13h2a1,1,0,0,1,1,1Z"}),React.createElement("polygon",{points:"13 11 13 15 10 15 10 11 8 11 8 21 10 21 10 17 13 17 13 21 15 21 15 11 13 11"}),props.children);});var Hd16=/*#__PURE__*/React.forwardRef(function Hd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM4,24V8H28V24Z"}),React.createElement("path",{d:"M22,11H18V21h4a3,3,0,0,0,3-3V14A3,3,0,0,0,22,11Zm1,7a1,1,0,0,1-1,1H20V13h2a1,1,0,0,1,1,1Z"}),React.createElement("polygon",{points:"13 11 13 15 10 15 10 11 8 11 8 21 10 21 10 17 13 17 13 21 15 21 15 11 13 11"}),props.children);});var Hdr32=/*#__PURE__*/React.forwardRef(function Hdr32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15V11a2,2,0,0,0-2-2H22V23h2V17h1.48l2.34,6H30l-2.33-6H28A2,2,0,0,0,30,15Zm-6-4h4v4H24Z"}),React.createElement("path",{d:"M16,23H12V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,16,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H14Z"}),React.createElement("polygon",{points:"8 9 8 15 4 15 4 9 2 9 2 23 4 23 4 17 8 17 8 23 10 23 10 9 8 9"}),props.children);});var Hdr24=/*#__PURE__*/React.forwardRef(function Hdr24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15V11a2,2,0,0,0-2-2H22V23h2V17h1.48l2.34,6H30l-2.33-6H28A2,2,0,0,0,30,15Zm-6-4h4v4H24Z"}),React.createElement("path",{d:"M16,23H12V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,16,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H14Z"}),React.createElement("polygon",{points:"8 9 8 15 4 15 4 9 2 9 2 23 4 23 4 17 8 17 8 23 10 23 10 9 8 9"}),props.children);});var Hdr20=/*#__PURE__*/React.forwardRef(function Hdr20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15V11a2,2,0,0,0-2-2H22V23h2V17h1.48l2.34,6H30l-2.33-6H28A2,2,0,0,0,30,15Zm-6-4h4v4H24Z"}),React.createElement("path",{d:"M16,23H12V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,16,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H14Z"}),React.createElement("polygon",{points:"8 9 8 15 4 15 4 9 2 9 2 23 4 23 4 17 8 17 8 23 10 23 10 9 8 9"}),props.children);});var Hdr16=/*#__PURE__*/React.forwardRef(function Hdr16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15V11a2,2,0,0,0-2-2H22V23h2V17h1.48l2.34,6H30l-2.33-6H28A2,2,0,0,0,30,15Zm-6-4h4v4H24Z"}),React.createElement("path",{d:"M16,23H12V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,16,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H14Z"}),React.createElement("polygon",{points:"8 9 8 15 4 15 4 9 2 9 2 23 4 23 4 17 8 17 8 23 10 23 10 9 8 9"}),props.children);});var Http32=/*#__PURE__*/React.forwardRef(function Http32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,11H25V21h2V18h3a2.0027,2.0027,0,0,0,2-2V13A2.0023,2.0023,0,0,0,30,11Zm-3,5V13h3l.001,3Z"}),React.createElement("polygon",{points:"10 13 12 13 12 21 14 21 14 13 16 13 16 11 10 11 10 13"}),React.createElement("polygon",{points:"23 11 17 11 17 13 19 13 19 21 21 21 21 13 23 13 23 11"}),React.createElement("polygon",{points:"6 11 6 15 3 15 3 11 1 11 1 21 3 21 3 17 6 17 6 21 8 21 8 11 6 11"}),props.children);});var Http24=/*#__PURE__*/React.forwardRef(function Http24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,11H25V21h2V18h3a2.0027,2.0027,0,0,0,2-2V13A2.0023,2.0023,0,0,0,30,11Zm-3,5V13h3l.001,3Z"}),React.createElement("polygon",{points:"10 13 12 13 12 21 14 21 14 13 16 13 16 11 10 11 10 13"}),React.createElement("polygon",{points:"23 11 17 11 17 13 19 13 19 21 21 21 21 13 23 13 23 11"}),React.createElement("polygon",{points:"6 11 6 15 3 15 3 11 1 11 1 21 3 21 3 17 6 17 6 21 8 21 8 11 6 11"}),props.children);});var Http20=/*#__PURE__*/React.forwardRef(function Http20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,11H25V21h2V18h3a2.0027,2.0027,0,0,0,2-2V13A2.0023,2.0023,0,0,0,30,11Zm-3,5V13h3l.001,3Z"}),React.createElement("polygon",{points:"10 13 12 13 12 21 14 21 14 13 16 13 16 11 10 11 10 13"}),React.createElement("polygon",{points:"23 11 17 11 17 13 19 13 19 21 21 21 21 13 23 13 23 11"}),React.createElement("polygon",{points:"6 11 6 15 3 15 3 11 1 11 1 21 3 21 3 17 6 17 6 21 8 21 8 11 6 11"}),props.children);});var Http16=/*#__PURE__*/React.forwardRef(function Http16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,11H25V21h2V18h3a2.0027,2.0027,0,0,0,2-2V13A2.0023,2.0023,0,0,0,30,11Zm-3,5V13h3l.001,3Z"}),React.createElement("polygon",{points:"10 13 12 13 12 21 14 21 14 13 16 13 16 11 10 11 10 13"}),React.createElement("polygon",{points:"23 11 17 11 17 13 19 13 19 21 21 21 21 13 23 13 23 11"}),React.createElement("polygon",{points:"6 11 6 15 3 15 3 11 1 11 1 21 3 21 3 17 6 17 6 21 8 21 8 11 6 11"}),props.children);});var IsoFilled32=/*#__PURE__*/React.forwardRef(function IsoFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"3",height:"6",x:"21",y:"13"}),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM8,21H6V11H8Zm9-8H12v2h3a2,2,0,0,1,2,2v2a2,2,0,0,1-2,2H10V19h5V17H12a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5Zm9,6a2,2,0,0,1-2,2H21a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h3a2,2,0,0,1,2,2Z"}),props.children);});var IsoFilled24=/*#__PURE__*/React.forwardRef(function IsoFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"3",height:"6",x:"21",y:"13"}),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM8,21H6V11H8Zm9-8H12v2h3a2,2,0,0,1,2,2v2a2,2,0,0,1-2,2H10V19h5V17H12a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5Zm9,6a2,2,0,0,1-2,2H21a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h3a2,2,0,0,1,2,2Z"}),props.children);});var IsoFilled20=/*#__PURE__*/React.forwardRef(function IsoFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"3",height:"6",x:"21",y:"13"}),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM8,21H6V11H8Zm9-8H12v2h3a2,2,0,0,1,2,2v2a2,2,0,0,1-2,2H10V19h5V17H12a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5Zm9,6a2,2,0,0,1-2,2H21a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h3a2,2,0,0,1,2,2Z"}),props.children);});var IsoFilled16=/*#__PURE__*/React.forwardRef(function IsoFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"3",height:"6",x:"21",y:"13"}),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM8,21H6V11H8Zm9-8H12v2h3a2,2,0,0,1,2,2v2a2,2,0,0,1-2,2H10V19h5V17H12a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5Zm9,6a2,2,0,0,1-2,2H21a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h3a2,2,0,0,1,2,2Z"}),props.children);});var IsoOutline32=/*#__PURE__*/React.forwardRef(function IsoOutline32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,21H21a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h3a2,2,0,0,1,2,2v6A2,2,0,0,1,24,21Zm-3-8v6h3V13Z"}),React.createElement("path",{d:"M15,21H10V19h5V17H12a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5v2H12v2h3a2,2,0,0,1,2,2v2A2,2,0,0,1,15,21Z"}),React.createElement("rect",{width:"2",height:"10",x:"6",y:"11"}),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM4,24V8H28V24Z"}),props.children);});var IsoOutline24=/*#__PURE__*/React.forwardRef(function IsoOutline24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,21H21a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h3a2,2,0,0,1,2,2v6A2,2,0,0,1,24,21Zm-3-8v6h3V13Z"}),React.createElement("path",{d:"M15,21H10V19h5V17H12a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5v2H12v2h3a2,2,0,0,1,2,2v2A2,2,0,0,1,15,21Z"}),React.createElement("rect",{width:"2",height:"10",x:"6",y:"11"}),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM4,24V8H28V24Z"}),props.children);});var IsoOutline20=/*#__PURE__*/React.forwardRef(function IsoOutline20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,21H21a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h3a2,2,0,0,1,2,2v6A2,2,0,0,1,24,21Zm-3-8v6h3V13Z"}),React.createElement("path",{d:"M15,21H10V19h5V17H12a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5v2H12v2h3a2,2,0,0,1,2,2v2A2,2,0,0,1,15,21Z"}),React.createElement("rect",{width:"2",height:"10",x:"6",y:"11"}),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM4,24V8H28V24Z"}),props.children);});var IsoOutline16=/*#__PURE__*/React.forwardRef(function IsoOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,21H21a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h3a2,2,0,0,1,2,2v6A2,2,0,0,1,24,21Zm-3-8v6h3V13Z"}),React.createElement("path",{d:"M15,21H10V19h5V17H12a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5v2H12v2h3a2,2,0,0,1,2,2v2A2,2,0,0,1,15,21Z"}),React.createElement("rect",{width:"2",height:"10",x:"6",y:"11"}),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM4,24V8H28V24Z"}),props.children);});var Iso32=/*#__PURE__*/React.forwardRef(function Iso32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h4a2,2,0,0,1,2,2V21A2,2,0,0,1,28,23ZM24,11V21h4V11Z"}),React.createElement("path",{d:"M18,23H12V21h6V17H14a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H14v4h4a2,2,0,0,1,2,2v4A2,2,0,0,1,18,23Z"}),React.createElement("polygon",{points:"2 11 5 11 5 21 2 21 2 23 10 23 10 21 7 21 7 11 10 11 10 9 2 9 2 11"}),props.children);});var Iso24=/*#__PURE__*/React.forwardRef(function Iso24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h4a2,2,0,0,1,2,2V21A2,2,0,0,1,28,23ZM24,11V21h4V11Z"}),React.createElement("path",{d:"M18,23H12V21h6V17H14a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H14v4h4a2,2,0,0,1,2,2v4A2,2,0,0,1,18,23Z"}),React.createElement("polygon",{points:"2 11 5 11 5 21 2 21 2 23 10 23 10 21 7 21 7 11 10 11 10 9 2 9 2 11"}),props.children);});var Iso20=/*#__PURE__*/React.forwardRef(function Iso20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h4a2,2,0,0,1,2,2V21A2,2,0,0,1,28,23ZM24,11V21h4V11Z"}),React.createElement("path",{d:"M18,23H12V21h6V17H14a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H14v4h4a2,2,0,0,1,2,2v4A2,2,0,0,1,18,23Z"}),React.createElement("polygon",{points:"2 11 5 11 5 21 2 21 2 23 10 23 10 21 7 21 7 11 10 11 10 9 2 9 2 11"}),props.children);});var Iso16=/*#__PURE__*/React.forwardRef(function Iso16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h4a2,2,0,0,1,2,2V21A2,2,0,0,1,28,23ZM24,11V21h4V11Z"}),React.createElement("path",{d:"M18,23H12V21h6V17H14a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H14v4h4a2,2,0,0,1,2,2v4A2,2,0,0,1,18,23Z"}),React.createElement("polygon",{points:"2 11 5 11 5 21 2 21 2 23 10 23 10 21 7 21 7 11 10 11 10 9 2 9 2 11"}),props.children);});var Jpg32=/*#__PURE__*/React.forwardRef(function Jpg32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H24V21h4V17H26V15h4Z"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("path",{d:"M8,23H4a2,2,0,0,1-2-2V19H4v2H8V9h2V21A2,2,0,0,1,8,23Z"}),props.children);});var Jpg24=/*#__PURE__*/React.forwardRef(function Jpg24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H24V21h4V17H26V15h4Z"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("path",{d:"M8,23H4a2,2,0,0,1-2-2V19H4v2H8V9h2V21A2,2,0,0,1,8,23Z"}),props.children);});var Jpg20=/*#__PURE__*/React.forwardRef(function Jpg20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H24V21h4V17H26V15h4Z"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("path",{d:"M8,23H4a2,2,0,0,1-2-2V19H4v2H8V9h2V21A2,2,0,0,1,8,23Z"}),props.children);});var Jpg16=/*#__PURE__*/React.forwardRef(function Jpg16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H24V21h4V17H26V15h4Z"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("path",{d:"M8,23H4a2,2,0,0,1-2-2V19H4v2H8V9h2V21A2,2,0,0,1,8,23Z"}),props.children);});var Json32=/*#__PURE__*/React.forwardRef(function Json32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"31 11 31 21 29 21 27 15 27 21 25 21 25 11 27 11 29 17 29 11 31 11"}),React.createElement("path",{d:"M21.3335,21h-2.667A1.6684,1.6684,0,0,1,17,19.3335v-6.667A1.6684,1.6684,0,0,1,18.6665,11h2.667A1.6684,1.6684,0,0,1,23,12.6665v6.667A1.6684,1.6684,0,0,1,21.3335,21ZM19,19h2V13H19Z"}),React.createElement("path",{d:"M13.3335,21H9V19h4V17H11a2.002,2.002,0,0,1-2-2V12.6665A1.6684,1.6684,0,0,1,10.6665,11H15v2H11v2h2a2.002,2.002,0,0,1,2,2v2.3335A1.6684,1.6684,0,0,1,13.3335,21Z"}),React.createElement("path",{d:"M5.3335,21H2.6665A1.6684,1.6684,0,0,1,1,19.3335V17H3v2H5V11H7v8.3335A1.6684,1.6684,0,0,1,5.3335,21Z"}),props.children);});var Json24=/*#__PURE__*/React.forwardRef(function Json24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"31 11 31 21 29 21 27 15 27 21 25 21 25 11 27 11 29 17 29 11 31 11"}),React.createElement("path",{d:"M21.3335,21h-2.667A1.6684,1.6684,0,0,1,17,19.3335v-6.667A1.6684,1.6684,0,0,1,18.6665,11h2.667A1.6684,1.6684,0,0,1,23,12.6665v6.667A1.6684,1.6684,0,0,1,21.3335,21ZM19,19h2V13H19Z"}),React.createElement("path",{d:"M13.3335,21H9V19h4V17H11a2.002,2.002,0,0,1-2-2V12.6665A1.6684,1.6684,0,0,1,10.6665,11H15v2H11v2h2a2.002,2.002,0,0,1,2,2v2.3335A1.6684,1.6684,0,0,1,13.3335,21Z"}),React.createElement("path",{d:"M5.3335,21H2.6665A1.6684,1.6684,0,0,1,1,19.3335V17H3v2H5V11H7v8.3335A1.6684,1.6684,0,0,1,5.3335,21Z"}),props.children);});var Json20=/*#__PURE__*/React.forwardRef(function Json20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"31 11 31 21 29 21 27 15 27 21 25 21 25 11 27 11 29 17 29 11 31 11"}),React.createElement("path",{d:"M21.3335,21h-2.667A1.6684,1.6684,0,0,1,17,19.3335v-6.667A1.6684,1.6684,0,0,1,18.6665,11h2.667A1.6684,1.6684,0,0,1,23,12.6665v6.667A1.6684,1.6684,0,0,1,21.3335,21ZM19,19h2V13H19Z"}),React.createElement("path",{d:"M13.3335,21H9V19h4V17H11a2.002,2.002,0,0,1-2-2V12.6665A1.6684,1.6684,0,0,1,10.6665,11H15v2H11v2h2a2.002,2.002,0,0,1,2,2v2.3335A1.6684,1.6684,0,0,1,13.3335,21Z"}),React.createElement("path",{d:"M5.3335,21H2.6665A1.6684,1.6684,0,0,1,1,19.3335V17H3v2H5V11H7v8.3335A1.6684,1.6684,0,0,1,5.3335,21Z"}),props.children);});var Json16=/*#__PURE__*/React.forwardRef(function Json16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"31 11 31 21 29 21 27 15 27 21 25 21 25 11 27 11 29 17 29 11 31 11"}),React.createElement("path",{d:"M21.3335,21h-2.667A1.6684,1.6684,0,0,1,17,19.3335v-6.667A1.6684,1.6684,0,0,1,18.6665,11h2.667A1.6684,1.6684,0,0,1,23,12.6665v6.667A1.6684,1.6684,0,0,1,21.3335,21ZM19,19h2V13H19Z"}),React.createElement("path",{d:"M13.3335,21H9V19h4V17H11a2.002,2.002,0,0,1-2-2V12.6665A1.6684,1.6684,0,0,1,10.6665,11H15v2H11v2h2a2.002,2.002,0,0,1,2,2v2.3335A1.6684,1.6684,0,0,1,13.3335,21Z"}),React.createElement("path",{d:"M5.3335,21H2.6665A1.6684,1.6684,0,0,1,1,19.3335V17H3v2H5V11H7v8.3335A1.6684,1.6684,0,0,1,5.3335,21Z"}),props.children);});var Mov32=/*#__PURE__*/React.forwardRef(function Mov32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 9 26 22 24 9 22 9 24.52 23 27.48 23 30 9 28 9"}),React.createElement("path",{d:"M18,23H14a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h4a2,2,0,0,1,2,2V21A2,2,0,0,1,18,23ZM14,11V21h4V11Z"}),React.createElement("polygon",{points:"8 9 6.49 14 6 15.98 5.54 14 4 9 2 9 2 23 4 23 4 15 3.84 13 4.42 15 6 19.63 7.58 15 8.16 13 8 15 8 23 10 23 10 9 8 9"}),props.children);});var Mov24=/*#__PURE__*/React.forwardRef(function Mov24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 9 26 22 24 9 22 9 24.52 23 27.48 23 30 9 28 9"}),React.createElement("path",{d:"M18,23H14a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h4a2,2,0,0,1,2,2V21A2,2,0,0,1,18,23ZM14,11V21h4V11Z"}),React.createElement("polygon",{points:"8 9 6.49 14 6 15.98 5.54 14 4 9 2 9 2 23 4 23 4 15 3.84 13 4.42 15 6 19.63 7.58 15 8.16 13 8 15 8 23 10 23 10 9 8 9"}),props.children);});var Mov20=/*#__PURE__*/React.forwardRef(function Mov20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 9 26 22 24 9 22 9 24.52 23 27.48 23 30 9 28 9"}),React.createElement("path",{d:"M18,23H14a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h4a2,2,0,0,1,2,2V21A2,2,0,0,1,18,23ZM14,11V21h4V11Z"}),React.createElement("polygon",{points:"8 9 6.49 14 6 15.98 5.54 14 4 9 2 9 2 23 4 23 4 15 3.84 13 4.42 15 6 19.63 7.58 15 8.16 13 8 15 8 23 10 23 10 9 8 9"}),props.children);});var Mov16=/*#__PURE__*/React.forwardRef(function Mov16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 9 26 22 24 9 22 9 24.52 23 27.48 23 30 9 28 9"}),React.createElement("path",{d:"M18,23H14a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h4a2,2,0,0,1,2,2V21A2,2,0,0,1,18,23ZM14,11V21h4V11Z"}),React.createElement("polygon",{points:"8 9 6.49 14 6 15.98 5.54 14 4 9 2 9 2 23 4 23 4 15 3.84 13 4.42 15 6 19.63 7.58 15 8.16 13 8 15 8 23 10 23 10 9 8 9"}),props.children);});var Mp332=/*#__PURE__*/React.forwardRef(function Mp332(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H22v2h6v4H24v2h4v4H22v2h6a2,2,0,0,0,2-2V11A2,2,0,0,0,28,9Z"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("polygon",{points:"8 9 6.49 14 6 15.98 5.54 14 4 9 2 9 2 23 4 23 4 15 3.84 13 4.42 15 6 19.63 7.58 15 8.16 13 8 15 8 23 10 23 10 9 8 9"}),props.children);});var Mp324=/*#__PURE__*/React.forwardRef(function Mp324(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H22v2h6v4H24v2h4v4H22v2h6a2,2,0,0,0,2-2V11A2,2,0,0,0,28,9Z"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("polygon",{points:"8 9 6.49 14 6 15.98 5.54 14 4 9 2 9 2 23 4 23 4 15 3.84 13 4.42 15 6 19.63 7.58 15 8.16 13 8 15 8 23 10 23 10 9 8 9"}),props.children);});var Mp320=/*#__PURE__*/React.forwardRef(function Mp320(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H22v2h6v4H24v2h4v4H22v2h6a2,2,0,0,0,2-2V11A2,2,0,0,0,28,9Z"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("polygon",{points:"8 9 6.49 14 6 15.98 5.54 14 4 9 2 9 2 23 4 23 4 15 3.84 13 4.42 15 6 19.63 7.58 15 8.16 13 8 15 8 23 10 23 10 9 8 9"}),props.children);});var Mp316=/*#__PURE__*/React.forwardRef(function Mp316(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H22v2h6v4H24v2h4v4H22v2h6a2,2,0,0,0,2-2V11A2,2,0,0,0,28,9Z"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("polygon",{points:"8 9 6.49 14 6 15.98 5.54 14 4 9 2 9 2 23 4 23 4 15 3.84 13 4.42 15 6 19.63 7.58 15 8.16 13 8 15 8 23 10 23 10 9 8 9"}),props.children);});var Mp432=/*#__PURE__*/React.forwardRef(function Mp432(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,10v8h0V10m1-1H27v8H24V9H22V19h5v4h2V19h1V17H29V9Z"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("polygon",{points:"8 9 6.49 14 6 15.98 5.54 14 4 9 2 9 2 23 4 23 4 15 3.84 13 4.42 15 6 19.63 7.58 15 8.16 13 8 15 8 23 10 23 10 9 8 9"}),props.children);});var Mp424=/*#__PURE__*/React.forwardRef(function Mp424(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,10v8h0V10m1-1H27v8H24V9H22V19h5v4h2V19h1V17H29V9Z"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("polygon",{points:"8 9 6.49 14 6 15.98 5.54 14 4 9 2 9 2 23 4 23 4 15 3.84 13 4.42 15 6 19.63 7.58 15 8.16 13 8 15 8 23 10 23 10 9 8 9"}),props.children);});var Mp420=/*#__PURE__*/React.forwardRef(function Mp420(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,10v8h0V10m1-1H27v8H24V9H22V19h5v4h2V19h1V17H29V9Z"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("polygon",{points:"8 9 6.49 14 6 15.98 5.54 14 4 9 2 9 2 23 4 23 4 15 3.84 13 4.42 15 6 19.63 7.58 15 8.16 13 8 15 8 23 10 23 10 9 8 9"}),props.children);});var Mp416=/*#__PURE__*/React.forwardRef(function Mp416(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,10v8h0V10m1-1H27v8H24V9H22V19h5v4h2V19h1V17H29V9Z"}),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("polygon",{points:"8 9 6.49 14 6 15.98 5.54 14 4 9 2 9 2 23 4 23 4 15 3.84 13 4.42 15 6 19.63 7.58 15 8.16 13 8 15 8 23 10 23 10 9 8 9"}),props.children);});var Mpeg32=/*#__PURE__*/React.forwardRef(function Mpeg32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M32,21H28a2.0023,2.0023,0,0,1-2-2V13a2.002,2.002,0,0,1,2-2h4v2H28v6h2V17H29l0-2h3Z"}),React.createElement("polygon",{points:"24 13 24 11.024 18 11.024 18 21 24 21 24 19 20 19 20 17 22 17 22 15 20 15 20 13 24 13"}),React.createElement("path",{d:"M14,11H9V21h2V18h3a2.0027,2.0027,0,0,0,2-2V13A2.0023,2.0023,0,0,0,14,11Zm-3,5V13h3l.001,3Z"}),React.createElement("polygon",{points:"7 11 5 11 3.5 15 2 11 0 11 0 21 2 21 2 14 3.5 18 5 14 5 21 7 21 7 11"}),props.children);});var Mpeg24=/*#__PURE__*/React.forwardRef(function Mpeg24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M32,21H28a2.0023,2.0023,0,0,1-2-2V13a2.002,2.002,0,0,1,2-2h4v2H28v6h2V17H29l0-2h3Z"}),React.createElement("polygon",{points:"24 13 24 11.024 18 11.024 18 21 24 21 24 19 20 19 20 17 22 17 22 15 20 15 20 13 24 13"}),React.createElement("path",{d:"M14,11H9V21h2V18h3a2.0027,2.0027,0,0,0,2-2V13A2.0023,2.0023,0,0,0,14,11Zm-3,5V13h3l.001,3Z"}),React.createElement("polygon",{points:"7 11 5 11 3.5 15 2 11 0 11 0 21 2 21 2 14 3.5 18 5 14 5 21 7 21 7 11"}),props.children);});var Mpeg20=/*#__PURE__*/React.forwardRef(function Mpeg20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M32,21H28a2.0023,2.0023,0,0,1-2-2V13a2.002,2.002,0,0,1,2-2h4v2H28v6h2V17H29l0-2h3Z"}),React.createElement("polygon",{points:"24 13 24 11.024 18 11.024 18 21 24 21 24 19 20 19 20 17 22 17 22 15 20 15 20 13 24 13"}),React.createElement("path",{d:"M14,11H9V21h2V18h3a2.0027,2.0027,0,0,0,2-2V13A2.0023,2.0023,0,0,0,14,11Zm-3,5V13h3l.001,3Z"}),React.createElement("polygon",{points:"7 11 5 11 3.5 15 2 11 0 11 0 21 2 21 2 14 3.5 18 5 14 5 21 7 21 7 11"}),props.children);});var Mpeg16=/*#__PURE__*/React.forwardRef(function Mpeg16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M32,21H28a2.0023,2.0023,0,0,1-2-2V13a2.002,2.002,0,0,1,2-2h4v2H28v6h2V17H29l0-2h3Z"}),React.createElement("polygon",{points:"24 13 24 11.024 18 11.024 18 21 24 21 24 19 20 19 20 17 22 17 22 15 20 15 20 13 24 13"}),React.createElement("path",{d:"M14,11H9V21h2V18h3a2.0027,2.0027,0,0,0,2-2V13A2.0023,2.0023,0,0,0,14,11Zm-3,5V13h3l.001,3Z"}),React.createElement("polygon",{points:"7 11 5 11 3.5 15 2 11 0 11 0 21 2 21 2 14 3.5 18 5 14 5 21 7 21 7 11"}),props.children);});var Mpg232=/*#__PURE__*/React.forwardRef(function Mpg232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M32,21H26V17a2.002,2.002,0,0,1,2-2h2V13H26V11h4a2.0023,2.0023,0,0,1,2,2v2a2.0023,2.0023,0,0,1-2,2H28v2h4Z"}),React.createElement("path",{d:"M24,21H20a2.0023,2.0023,0,0,1-2-2V13a2.002,2.002,0,0,1,2-2h4v2H20v6h2V17H21l0-2h3Z"}),React.createElement("path",{d:"M14,11H9V21h2V18h3a2.0027,2.0027,0,0,0,2-2V13A2.0023,2.0023,0,0,0,14,11Zm-3,5V13h3l.001,3Z"}),React.createElement("polygon",{points:"7 11 5 11 3.5 15 2 11 0 11 0 21 2 21 2 14 3.5 18 5 14 5 21 7 21 7 11"}),props.children);});var Mpg224=/*#__PURE__*/React.forwardRef(function Mpg224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M32,21H26V17a2.002,2.002,0,0,1,2-2h2V13H26V11h4a2.0023,2.0023,0,0,1,2,2v2a2.0023,2.0023,0,0,1-2,2H28v2h4Z"}),React.createElement("path",{d:"M24,21H20a2.0023,2.0023,0,0,1-2-2V13a2.002,2.002,0,0,1,2-2h4v2H20v6h2V17H21l0-2h3Z"}),React.createElement("path",{d:"M14,11H9V21h2V18h3a2.0027,2.0027,0,0,0,2-2V13A2.0023,2.0023,0,0,0,14,11Zm-3,5V13h3l.001,3Z"}),React.createElement("polygon",{points:"7 11 5 11 3.5 15 2 11 0 11 0 21 2 21 2 14 3.5 18 5 14 5 21 7 21 7 11"}),props.children);});var Mpg220=/*#__PURE__*/React.forwardRef(function Mpg220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M32,21H26V17a2.002,2.002,0,0,1,2-2h2V13H26V11h4a2.0023,2.0023,0,0,1,2,2v2a2.0023,2.0023,0,0,1-2,2H28v2h4Z"}),React.createElement("path",{d:"M24,21H20a2.0023,2.0023,0,0,1-2-2V13a2.002,2.002,0,0,1,2-2h4v2H20v6h2V17H21l0-2h3Z"}),React.createElement("path",{d:"M14,11H9V21h2V18h3a2.0027,2.0027,0,0,0,2-2V13A2.0023,2.0023,0,0,0,14,11Zm-3,5V13h3l.001,3Z"}),React.createElement("polygon",{points:"7 11 5 11 3.5 15 2 11 0 11 0 21 2 21 2 14 3.5 18 5 14 5 21 7 21 7 11"}),props.children);});var Mpg216=/*#__PURE__*/React.forwardRef(function Mpg216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M32,21H26V17a2.002,2.002,0,0,1,2-2h2V13H26V11h4a2.0023,2.0023,0,0,1,2,2v2a2.0023,2.0023,0,0,1-2,2H28v2h4Z"}),React.createElement("path",{d:"M24,21H20a2.0023,2.0023,0,0,1-2-2V13a2.002,2.002,0,0,1,2-2h4v2H20v6h2V17H21l0-2h3Z"}),React.createElement("path",{d:"M14,11H9V21h2V18h3a2.0027,2.0027,0,0,0,2-2V13A2.0023,2.0023,0,0,0,14,11Zm-3,5V13h3l.001,3Z"}),React.createElement("polygon",{points:"7 11 5 11 3.5 15 2 11 0 11 0 21 2 21 2 14 3.5 18 5 14 5 21 7 21 7 11"}),props.children);});var Pdf32=/*#__PURE__*/React.forwardRef(function Pdf32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 11 30 9 22 9 22 23 24 23 24 17 29 17 29 15 24 15 24 11 30 11"}),React.createElement("path",{d:"M8,9H2V23H4V18H8a2,2,0,0,0,2-2V11A2,2,0,0,0,8,9Zm0,7H4V11H8Z"}),React.createElement("path",{d:"M16,23H12V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,16,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H14Z"}),props.children);});var Pdf24=/*#__PURE__*/React.forwardRef(function Pdf24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 11 30 9 22 9 22 23 24 23 24 17 29 17 29 15 24 15 24 11 30 11"}),React.createElement("path",{d:"M8,9H2V23H4V18H8a2,2,0,0,0,2-2V11A2,2,0,0,0,8,9Zm0,7H4V11H8Z"}),React.createElement("path",{d:"M16,23H12V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,16,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H14Z"}),props.children);});var Pdf20=/*#__PURE__*/React.forwardRef(function Pdf20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 11 30 9 22 9 22 23 24 23 24 17 29 17 29 15 24 15 24 11 30 11"}),React.createElement("path",{d:"M8,9H2V23H4V18H8a2,2,0,0,0,2-2V11A2,2,0,0,0,8,9Zm0,7H4V11H8Z"}),React.createElement("path",{d:"M16,23H12V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,16,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H14Z"}),props.children);});var Pdf16=/*#__PURE__*/React.forwardRef(function Pdf16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 11 30 9 22 9 22 23 24 23 24 17 29 17 29 15 24 15 24 11 30 11"}),React.createElement("path",{d:"M8,9H2V23H4V18H8a2,2,0,0,0,2-2V11A2,2,0,0,0,8,9Zm0,7H4V11H8Z"}),React.createElement("path",{d:"M16,23H12V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,16,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H14Z"}),props.children);});var Png32=/*#__PURE__*/React.forwardRef(function Png32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H24V21h4V17H26V15h4Z"}),React.createElement("polygon",{points:"18 19 14.32 9 12 9 12 23 14 23 14 13 17.68 23 20 23 20 9 18 9 18 19"}),React.createElement("path",{d:"M4,23H2V9H8a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H4Zm0-7H8V11H4Z"}),props.children);});var Png24=/*#__PURE__*/React.forwardRef(function Png24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H24V21h4V17H26V15h4Z"}),React.createElement("polygon",{points:"18 19 14.32 9 12 9 12 23 14 23 14 13 17.68 23 20 23 20 9 18 9 18 19"}),React.createElement("path",{d:"M4,23H2V9H8a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H4Zm0-7H8V11H4Z"}),props.children);});var Png20=/*#__PURE__*/React.forwardRef(function Png20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H24V21h4V17H26V15h4Z"}),React.createElement("polygon",{points:"18 19 14.32 9 12 9 12 23 14 23 14 13 17.68 23 20 23 20 9 18 9 18 19"}),React.createElement("path",{d:"M4,23H2V9H8a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H4Zm0-7H8V11H4Z"}),props.children);});var Png16=/*#__PURE__*/React.forwardRef(function Png16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H24V21h4V17H26V15h4Z"}),React.createElement("polygon",{points:"18 19 14.32 9 12 9 12 23 14 23 14 13 17.68 23 20 23 20 9 18 9 18 19"}),React.createElement("path",{d:"M4,23H2V9H8a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H4Zm0-7H8V11H4Z"}),props.children);});var Ppt32=/*#__PURE__*/React.forwardRef(function Ppt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 11 25 11 25 23 27 23 27 11 30 11 30 9 22 9 22 11"}),React.createElement("path",{d:"M14,23H12V9h6a2.002,2.002,0,0,1,2,2v5a2.002,2.002,0,0,1-2,2H14Zm0-7h4V10.9985H14Z"}),React.createElement("path",{d:"M4,23H2V9H8a2.002,2.002,0,0,1,2,2v5a2.002,2.002,0,0,1-2,2H4Zm0-7H8V10.9985H4Z"}),props.children);});var Ppt24=/*#__PURE__*/React.forwardRef(function Ppt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 11 25 11 25 23 27 23 27 11 30 11 30 9 22 9 22 11"}),React.createElement("path",{d:"M14,23H12V9h6a2.002,2.002,0,0,1,2,2v5a2.002,2.002,0,0,1-2,2H14Zm0-7h4V10.9985H14Z"}),React.createElement("path",{d:"M4,23H2V9H8a2.002,2.002,0,0,1,2,2v5a2.002,2.002,0,0,1-2,2H4Zm0-7H8V10.9985H4Z"}),props.children);});var Ppt20=/*#__PURE__*/React.forwardRef(function Ppt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 11 25 11 25 23 27 23 27 11 30 11 30 9 22 9 22 11"}),React.createElement("path",{d:"M14,23H12V9h6a2.002,2.002,0,0,1,2,2v5a2.002,2.002,0,0,1-2,2H14Zm0-7h4V10.9985H14Z"}),React.createElement("path",{d:"M4,23H2V9H8a2.002,2.002,0,0,1,2,2v5a2.002,2.002,0,0,1-2,2H4Zm0-7H8V10.9985H4Z"}),props.children);});var Ppt16=/*#__PURE__*/React.forwardRef(function Ppt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 11 25 11 25 23 27 23 27 11 30 11 30 9 22 9 22 11"}),React.createElement("path",{d:"M14,23H12V9h6a2.002,2.002,0,0,1,2,2v5a2.002,2.002,0,0,1-2,2H14Zm0-7h4V10.9985H14Z"}),React.createElement("path",{d:"M4,23H2V9H8a2.002,2.002,0,0,1,2,2v5a2.002,2.002,0,0,1-2,2H4Zm0-7H8V10.9985H4Z"}),props.children);});var QH32=/*#__PURE__*/React.forwardRef(function QH32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 9 18 15 14 15 14 9 12 9 12 23 14 23 14 17 18 17 18 23 20 23 20 9 18 9"}),props.children);});var QH24=/*#__PURE__*/React.forwardRef(function QH24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 9 18 15 14 15 14 9 12 9 12 23 14 23 14 17 18 17 18 23 20 23 20 9 18 9"}),props.children);});var QH20=/*#__PURE__*/React.forwardRef(function QH20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 9 18 15 14 15 14 9 12 9 12 23 14 23 14 17 18 17 18 23 20 23 20 9 18 9"}),props.children);});var QH16=/*#__PURE__*/React.forwardRef(function QH16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 9 18 15 14 15 14 9 12 9 12 23 14 23 14 17 18 17 18 23 20 23 20 9 18 9"}),props.children);});var QSAlt32=/*#__PURE__*/React.forwardRef(function QSAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 9 22 9 22 7 20 7 20 9 18 9 18 11 20 11 20 17 22 17 22 11 24 11 24 9"}),React.createElement("path",{d:"M14,23H8V21h6V17H10a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H10v4h4a2,2,0,0,1,2,2v4A2,2,0,0,1,14,23Z"}),props.children);});var QSAlt24=/*#__PURE__*/React.forwardRef(function QSAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 9 22 9 22 7 20 7 20 9 18 9 18 11 20 11 20 17 22 17 22 11 24 11 24 9"}),React.createElement("path",{d:"M14,23H8V21h6V17H10a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H10v4h4a2,2,0,0,1,2,2v4A2,2,0,0,1,14,23Z"}),props.children);});var QSAlt20=/*#__PURE__*/React.forwardRef(function QSAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 9 22 9 22 7 20 7 20 9 18 9 18 11 20 11 20 17 22 17 22 11 24 11 24 9"}),React.createElement("path",{d:"M14,23H8V21h6V17H10a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H10v4h4a2,2,0,0,1,2,2v4A2,2,0,0,1,14,23Z"}),props.children);});var QSAlt16=/*#__PURE__*/React.forwardRef(function QSAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 9 22 9 22 7 20 7 20 9 18 9 18 11 20 11 20 17 22 17 22 11 24 11 24 9"}),React.createElement("path",{d:"M14,23H8V21h6V17H10a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H10v4h4a2,2,0,0,1,2,2v4A2,2,0,0,1,14,23Z"}),props.children);});var QS32=/*#__PURE__*/React.forwardRef(function QS32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,23H12V21h6V17H14a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H14v4h4a2,2,0,0,1,2,2v4A2,2,0,0,1,18,23Z"}),props.children);});var QS24=/*#__PURE__*/React.forwardRef(function QS24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,23H12V21h6V17H14a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H14v4h4a2,2,0,0,1,2,2v4A2,2,0,0,1,18,23Z"}),props.children);});var QS20=/*#__PURE__*/React.forwardRef(function QS20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,23H12V21h6V17H14a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H14v4h4a2,2,0,0,1,2,2v4A2,2,0,0,1,18,23Z"}),props.children);});var QS16=/*#__PURE__*/React.forwardRef(function QS16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,23H12V21h6V17H14a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H14v4h4a2,2,0,0,1,2,2v4A2,2,0,0,1,18,23Z"}),props.children);});var QTAlt32=/*#__PURE__*/React.forwardRef(function QTAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"8 11 11 11 11 23 13 23 13 11 16 11 16 9 8 9 8 11"}),React.createElement("polygon",{points:"24 9 22 9 22 7 20 7 20 9 18 9 18 11 20 11 20 17 21 18 22 17 22 11 24 11 24 9"}),props.children);});var QTAlt24=/*#__PURE__*/React.forwardRef(function QTAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"8 11 11 11 11 23 13 23 13 11 16 11 16 9 8 9 8 11"}),React.createElement("polygon",{points:"24 9 22 9 22 7 20 7 20 9 18 9 18 11 20 11 20 17 21 18 22 17 22 11 24 11 24 9"}),props.children);});var QTAlt20=/*#__PURE__*/React.forwardRef(function QTAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"8 11 11 11 11 23 13 23 13 11 16 11 16 9 8 9 8 11"}),React.createElement("polygon",{points:"24 9 22 9 22 7 20 7 20 9 18 9 18 11 20 11 20 17 21 18 22 17 22 11 24 11 24 9"}),props.children);});var QTAlt16=/*#__PURE__*/React.forwardRef(function QTAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"8 11 11 11 11 23 13 23 13 11 16 11 16 9 8 9 8 11"}),React.createElement("polygon",{points:"24 9 22 9 22 7 20 7 20 9 18 9 18 11 20 11 20 17 21 18 22 17 22 11 24 11 24 9"}),props.children);});var QT32=/*#__PURE__*/React.forwardRef(function QT32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12 11 15 11 15 23 17 23 17 11 20 11 20 9 12 9 12 11"}),props.children);});var QT24=/*#__PURE__*/React.forwardRef(function QT24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12 11 15 11 15 23 17 23 17 11 20 11 20 9 12 9 12 11"}),props.children);});var QT20=/*#__PURE__*/React.forwardRef(function QT20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12 11 15 11 15 23 17 23 17 11 20 11 20 9 12 9 12 11"}),props.children);});var QT16=/*#__PURE__*/React.forwardRef(function QT16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12 11 15 11 15 23 17 23 17 11 20 11 20 9 12 9 12 11"}),props.children);});var QU132=/*#__PURE__*/React.forwardRef(function QU132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,23H9a2,2,0,0,1-2-2V9H9V21h4V9h2V21A2,2,0,0,1,13,23Z"}),React.createElement("polygon",{points:"22 21 22 9 17 9 17 11 20 11 20 21 17 21 17 23 25 23 25 21 22 21"}),props.children);});var QU124=/*#__PURE__*/React.forwardRef(function QU124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,23H9a2,2,0,0,1-2-2V9H9V21h4V9h2V21A2,2,0,0,1,13,23Z"}),React.createElement("polygon",{points:"22 21 22 9 17 9 17 11 20 11 20 21 17 21 17 23 25 23 25 21 22 21"}),props.children);});var QU120=/*#__PURE__*/React.forwardRef(function QU120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,23H9a2,2,0,0,1-2-2V9H9V21h4V9h2V21A2,2,0,0,1,13,23Z"}),React.createElement("polygon",{points:"22 21 22 9 17 9 17 11 20 11 20 21 17 21 17 23 25 23 25 21 22 21"}),props.children);});var QU116=/*#__PURE__*/React.forwardRef(function QU116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,23H9a2,2,0,0,1-2-2V9H9V21h4V9h2V21A2,2,0,0,1,13,23Z"}),React.createElement("polygon",{points:"22 21 22 9 17 9 17 11 20 11 20 21 17 21 17 23 25 23 25 21 22 21"}),props.children);});var QU232=/*#__PURE__*/React.forwardRef(function QU232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,23H9a2,2,0,0,1-2-2V9H9V21h4V9h2V21A2,2,0,0,1,13,23Z"}),React.createElement("path",{d:"M25,23H17V17a2,2,0,0,1,2-2h4V11H17V9h6a2,2,0,0,1,2,2v4a2,2,0,0,1-2,2H19v4h6Z"}),props.children);});var QU224=/*#__PURE__*/React.forwardRef(function QU224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,23H9a2,2,0,0,1-2-2V9H9V21h4V9h2V21A2,2,0,0,1,13,23Z"}),React.createElement("path",{d:"M25,23H17V17a2,2,0,0,1,2-2h4V11H17V9h6a2,2,0,0,1,2,2v4a2,2,0,0,1-2,2H19v4h6Z"}),props.children);});var QU220=/*#__PURE__*/React.forwardRef(function QU220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,23H9a2,2,0,0,1-2-2V9H9V21h4V9h2V21A2,2,0,0,1,13,23Z"}),React.createElement("path",{d:"M25,23H17V17a2,2,0,0,1,2-2h4V11H17V9h6a2,2,0,0,1,2,2v4a2,2,0,0,1-2,2H19v4h6Z"}),props.children);});var QU216=/*#__PURE__*/React.forwardRef(function QU216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,23H9a2,2,0,0,1-2-2V9H9V21h4V9h2V21A2,2,0,0,1,13,23Z"}),React.createElement("path",{d:"M25,23H17V17a2,2,0,0,1,2-2h4V11H17V9h6a2,2,0,0,1,2,2v4a2,2,0,0,1-2,2H19v4h6Z"}),props.children);});var QU332=/*#__PURE__*/React.forwardRef(function QU332(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,23H9a2,2,0,0,1-2-2V9H9V21h4V9h2V21A2,2,0,0,1,13,23Z"}),React.createElement("path",{d:"M23,9H17v2h6v4H18v2h5v4H17v2h6a2,2,0,0,0,2-2V11A2,2,0,0,0,23,9Z"}),props.children);});var QU324=/*#__PURE__*/React.forwardRef(function QU324(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,23H9a2,2,0,0,1-2-2V9H9V21h4V9h2V21A2,2,0,0,1,13,23Z"}),React.createElement("path",{d:"M23,9H17v2h6v4H18v2h5v4H17v2h6a2,2,0,0,0,2-2V11A2,2,0,0,0,23,9Z"}),props.children);});var QU320=/*#__PURE__*/React.forwardRef(function QU320(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,23H9a2,2,0,0,1-2-2V9H9V21h4V9h2V21A2,2,0,0,1,13,23Z"}),React.createElement("path",{d:"M23,9H17v2h6v4H18v2h5v4H17v2h6a2,2,0,0,0,2-2V11A2,2,0,0,0,23,9Z"}),props.children);});var QU316=/*#__PURE__*/React.forwardRef(function QU316(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,23H9a2,2,0,0,1-2-2V9H9V21h4V9h2V21A2,2,0,0,1,13,23Z"}),React.createElement("path",{d:"M23,9H17v2h6v4H18v2h5v4H17v2h6a2,2,0,0,0,2-2V11A2,2,0,0,0,23,9Z"}),props.children);});var QX32=/*#__PURE__*/React.forwardRef(function QX32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20 9 18 9 16 15 14 9 12 9 14.75 16 12 23 14 23 16 17 18 23 20 23 17.25 16 20 9"}),props.children);});var QX24=/*#__PURE__*/React.forwardRef(function QX24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20 9 18 9 16 15 14 9 12 9 14.75 16 12 23 14 23 16 17 18 23 20 23 17.25 16 20 9"}),props.children);});var QX20=/*#__PURE__*/React.forwardRef(function QX20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20 9 18 9 16 15 14 9 12 9 14.75 16 12 23 14 23 16 17 18 23 20 23 17.25 16 20 9"}),props.children);});var QX16=/*#__PURE__*/React.forwardRef(function QX16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20 9 18 9 16 15 14 9 12 9 14.75 16 12 23 14 23 16 17 18 23 20 23 17.25 16 20 9"}),props.children);});var QY32=/*#__PURE__*/React.forwardRef(function QY32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20 9 18 9 16 16 14 9 12 9 15 18 15 23 17 23 17 18 20 9"}),props.children);});var QY24=/*#__PURE__*/React.forwardRef(function QY24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20 9 18 9 16 16 14 9 12 9 15 18 15 23 17 23 17 18 20 9"}),props.children);});var QY20=/*#__PURE__*/React.forwardRef(function QY20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20 9 18 9 16 16 14 9 12 9 15 18 15 23 17 23 17 18 20 9"}),props.children);});var QY16=/*#__PURE__*/React.forwardRef(function QY16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20 9 18 9 16 16 14 9 12 9 15 18 15 23 17 23 17 18 20 9"}),props.children);});var QZ32=/*#__PURE__*/React.forwardRef(function QZ32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20 9 12 9 12 11 18 11 12 21 12 23 20 23 20 21 14 21 20 11 20 9"}),props.children);});var QZ24=/*#__PURE__*/React.forwardRef(function QZ24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20 9 12 9 12 11 18 11 12 21 12 23 20 23 20 21 14 21 20 11 20 9"}),props.children);});var QZ20=/*#__PURE__*/React.forwardRef(function QZ20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20 9 12 9 12 11 18 11 12 21 12 23 20 23 20 21 14 21 20 11 20 9"}),props.children);});var QZ16=/*#__PURE__*/React.forwardRef(function QZ16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20 9 12 9 12 11 18 11 12 21 12 23 20 23 20 21 14 21 20 11 20 9"}),props.children);});var QBarrier32=/*#__PURE__*/React.forwardRef(function QBarrier32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4",x:"15",y:"5"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"11"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"17"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"23"}),props.children);});var QBarrier24=/*#__PURE__*/React.forwardRef(function QBarrier24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4",x:"15",y:"5"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"11"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"17"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"23"}),props.children);});var QBarrier20=/*#__PURE__*/React.forwardRef(function QBarrier20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4",x:"15",y:"5"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"11"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"17"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"23"}),props.children);});var QBarrier16=/*#__PURE__*/React.forwardRef(function QBarrier16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4",x:"15",y:"5"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"11"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"17"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"23"}),props.children);});var QBlochSphere32=/*#__PURE__*/React.forwardRef(function QBlochSphere32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.87,7.84l-1.74-1L16,14h0a2,2,0,1,0,2,2,2,2,0,0,0-.27-1Z"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,11.17,7.65,25.69,25.69,0,0,0-3.69-1.5l-1,1.77a22.7,22.7,0,0,1,5.41,2.39,11.05,11.05,0,0,1,0,3.38A22.92,22.92,0,0,1,16,21,22.92,22.92,0,0,1,4.13,17.69a11.05,11.05,0,0,1,0-3.38A22.8,22.8,0,0,1,15,11V9a25,25,0,0,0-10.17,2.6A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4.83,20.35,24.88,24.88,0,0,0,16,23a24.88,24.88,0,0,0,11.17-2.65A12,12,0,0,1,16,28Z"}),props.children);});var QBlochSphere24=/*#__PURE__*/React.forwardRef(function QBlochSphere24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.87,7.84l-1.74-1L16,14h0a2,2,0,1,0,2,2,2,2,0,0,0-.27-1Z"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,11.17,7.65,25.69,25.69,0,0,0-3.69-1.5l-1,1.77a22.7,22.7,0,0,1,5.41,2.39,11.05,11.05,0,0,1,0,3.38A22.92,22.92,0,0,1,16,21,22.92,22.92,0,0,1,4.13,17.69a11.05,11.05,0,0,1,0-3.38A22.8,22.8,0,0,1,15,11V9a25,25,0,0,0-10.17,2.6A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4.83,20.35,24.88,24.88,0,0,0,16,23a24.88,24.88,0,0,0,11.17-2.65A12,12,0,0,1,16,28Z"}),props.children);});var QBlochSphere20=/*#__PURE__*/React.forwardRef(function QBlochSphere20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.87,7.84l-1.74-1L16,14h0a2,2,0,1,0,2,2,2,2,0,0,0-.27-1Z"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,11.17,7.65,25.69,25.69,0,0,0-3.69-1.5l-1,1.77a22.7,22.7,0,0,1,5.41,2.39,11.05,11.05,0,0,1,0,3.38A22.92,22.92,0,0,1,16,21,22.92,22.92,0,0,1,4.13,17.69a11.05,11.05,0,0,1,0-3.38A22.8,22.8,0,0,1,15,11V9a25,25,0,0,0-10.17,2.6A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4.83,20.35,24.88,24.88,0,0,0,16,23a24.88,24.88,0,0,0,11.17-2.65A12,12,0,0,1,16,28Z"}),props.children);});var QBlochSphere16=/*#__PURE__*/React.forwardRef(function QBlochSphere16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.87,7.84l-1.74-1L16,14h0a2,2,0,1,0,2,2,2,2,0,0,0-.27-1Z"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,11.17,7.65,25.69,25.69,0,0,0-3.69-1.5l-1,1.77a22.7,22.7,0,0,1,5.41,2.39,11.05,11.05,0,0,1,0,3.38A22.92,22.92,0,0,1,16,21,22.92,22.92,0,0,1,4.13,17.69a11.05,11.05,0,0,1,0-3.38A22.8,22.8,0,0,1,15,11V9a25,25,0,0,0-10.17,2.6A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4.83,20.35,24.88,24.88,0,0,0,16,23a24.88,24.88,0,0,0,11.17-2.65A12,12,0,0,1,16,28Z"}),props.children);});var QCU132=/*#__PURE__*/React.forwardRef(function QCU132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,23H5a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H5v6h5Z"}),React.createElement("path",{d:"M18,23H14a2,2,0,0,1-2-2V9h2V21h4V9h2V21A2,2,0,0,1,18,23Z"}),React.createElement("polygon",{points:"27 21 27 9.01 22 9.01 22 11.01 25 11.01 25 21 22 21 22 23 30 23 30 21 27 21"}),props.children);});var QCU124=/*#__PURE__*/React.forwardRef(function QCU124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,23H5a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H5v6h5Z"}),React.createElement("path",{d:"M18,23H14a2,2,0,0,1-2-2V9h2V21h4V9h2V21A2,2,0,0,1,18,23Z"}),React.createElement("polygon",{points:"27 21 27 9.01 22 9.01 22 11.01 25 11.01 25 21 22 21 22 23 30 23 30 21 27 21"}),props.children);});var QCU120=/*#__PURE__*/React.forwardRef(function QCU120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,23H5a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H5v6h5Z"}),React.createElement("path",{d:"M18,23H14a2,2,0,0,1-2-2V9h2V21h4V9h2V21A2,2,0,0,1,18,23Z"}),React.createElement("polygon",{points:"27 21 27 9.01 22 9.01 22 11.01 25 11.01 25 21 22 21 22 23 30 23 30 21 27 21"}),props.children);});var QCU116=/*#__PURE__*/React.forwardRef(function QCU116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,23H5a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H5v6h5Z"}),React.createElement("path",{d:"M18,23H14a2,2,0,0,1-2-2V9h2V21h4V9h2V21A2,2,0,0,1,18,23Z"}),React.createElement("polygon",{points:"27 21 27 9.01 22 9.01 22 11.01 25 11.01 25 21 22 21 22 23 30 23 30 21 27 21"}),props.children);});var QCU332=/*#__PURE__*/React.forwardRef(function QCU332(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,23H5a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H5v6h5Z"}),React.createElement("path",{d:"M18,23H14a2,2,0,0,1-2-2V9h2V21h4V9h2V21A2,2,0,0,1,18,23Z"}),React.createElement("path",{d:"M28,9H22v2h6v4H23v2h5v4H22v2h6a2,2,0,0,0,2-2V11A2,2,0,0,0,28,9Z"}),props.children);});var QCU324=/*#__PURE__*/React.forwardRef(function QCU324(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,23H5a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H5v6h5Z"}),React.createElement("path",{d:"M18,23H14a2,2,0,0,1-2-2V9h2V21h4V9h2V21A2,2,0,0,1,18,23Z"}),React.createElement("path",{d:"M28,9H22v2h6v4H23v2h5v4H22v2h6a2,2,0,0,0,2-2V11A2,2,0,0,0,28,9Z"}),props.children);});var QCU320=/*#__PURE__*/React.forwardRef(function QCU320(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,23H5a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H5v6h5Z"}),React.createElement("path",{d:"M18,23H14a2,2,0,0,1-2-2V9h2V21h4V9h2V21A2,2,0,0,1,18,23Z"}),React.createElement("path",{d:"M28,9H22v2h6v4H23v2h5v4H22v2h6a2,2,0,0,0,2-2V11A2,2,0,0,0,28,9Z"}),props.children);});var QCU316=/*#__PURE__*/React.forwardRef(function QCU316(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,23H5a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H5v6h5Z"}),React.createElement("path",{d:"M18,23H14a2,2,0,0,1-2-2V9h2V21h4V9h2V21A2,2,0,0,1,18,23Z"}),React.createElement("path",{d:"M28,9H22v2h6v4H23v2h5v4H22v2h6a2,2,0,0,0,2-2V11A2,2,0,0,0,28,9Z"}),props.children);});var QCY32=/*#__PURE__*/React.forwardRef(function QCY32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15,23H10a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H10v6h5Z"}),React.createElement("polygon",{points:"24 9 22 9 20 16 18 9 16 9 19 18 19 23 21 23 21 18 24 9"}),props.children);});var QCY24=/*#__PURE__*/React.forwardRef(function QCY24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15,23H10a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H10v6h5Z"}),React.createElement("polygon",{points:"24 9 22 9 20 16 18 9 16 9 19 18 19 23 21 23 21 18 24 9"}),props.children);});var QCY20=/*#__PURE__*/React.forwardRef(function QCY20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15,23H10a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H10v6h5Z"}),React.createElement("polygon",{points:"24 9 22 9 20 16 18 9 16 9 19 18 19 23 21 23 21 18 24 9"}),props.children);});var QCY16=/*#__PURE__*/React.forwardRef(function QCY16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15,23H10a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H10v6h5Z"}),React.createElement("polygon",{points:"24 9 22 9 20 16 18 9 16 9 19 18 19 23 21 23 21 18 24 9"}),props.children);});var QCZ32=/*#__PURE__*/React.forwardRef(function QCZ32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14,23H9a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H9v6h5Z"}),React.createElement("polygon",{points:"24 9 16 9 16 11 22 11 16 21 16 23 24 23 24 21 18 21 24 11 24 9"}),props.children);});var QCZ24=/*#__PURE__*/React.forwardRef(function QCZ24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14,23H9a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H9v6h5Z"}),React.createElement("polygon",{points:"24 9 16 9 16 11 22 11 16 21 16 23 24 23 24 21 18 21 24 11 24 9"}),props.children);});var QCZ20=/*#__PURE__*/React.forwardRef(function QCZ20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14,23H9a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H9v6h5Z"}),React.createElement("polygon",{points:"24 9 16 9 16 11 22 11 16 21 16 23 24 23 24 21 18 21 24 11 24 9"}),props.children);});var QCZ16=/*#__PURE__*/React.forwardRef(function QCZ16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14,23H9a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H9v6h5Z"}),React.createElement("polygon",{points:"24 9 16 9 16 11 22 11 16 21 16 23 24 23 24 21 18 21 24 11 24 9"}),props.children);});var QCcX32=/*#__PURE__*/React.forwardRef(function QCcX32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,23H5a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H5v6h5Z"}),React.createElement("path",{d:"M19,23H14a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H14v6h5Z"}),React.createElement("polygon",{points:"29 9 27 9 25 15 23 9 21 9 23.75 16 21 23 23 23 25 17 27 23 29 23 26.25 16 29 9"}),props.children);});var QCcX24=/*#__PURE__*/React.forwardRef(function QCcX24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,23H5a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H5v6h5Z"}),React.createElement("path",{d:"M19,23H14a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H14v6h5Z"}),React.createElement("polygon",{points:"29 9 27 9 25 15 23 9 21 9 23.75 16 21 23 23 23 25 17 27 23 29 23 26.25 16 29 9"}),props.children);});var QCcX20=/*#__PURE__*/React.forwardRef(function QCcX20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,23H5a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H5v6h5Z"}),React.createElement("path",{d:"M19,23H14a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H14v6h5Z"}),React.createElement("polygon",{points:"29 9 27 9 25 15 23 9 21 9 23.75 16 21 23 23 23 25 17 27 23 29 23 26.25 16 29 9"}),props.children);});var QCcX16=/*#__PURE__*/React.forwardRef(function QCcX16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,23H5a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H5v6h5Z"}),React.createElement("path",{d:"M19,23H14a2,2,0,0,1-2-2V15a2,2,0,0,1,2-2h5v2H14v6h5Z"}),React.createElement("polygon",{points:"29 9 27 9 25 15 23 9 21 9 23.75 16 21 23 23 23 25 17 27 23 29 23 26.25 16 29 9"}),props.children);});var QCircuitComposer32=/*#__PURE__*/React.forwardRef(function QCircuitComposer32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 9 18 15 14 15 14 9 12 9 12 23 14 23 14 17 18 17 18 23 20 23 20 9 18 9"}),React.createElement("path",{d:"M30,15H26V6a2,2,0,0,0-2-2H8A2,2,0,0,0,6,6v9H2v2H6v9a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V17h4ZM8,26V6H24V26Z"}),props.children);});var QCircuitComposer24=/*#__PURE__*/React.forwardRef(function QCircuitComposer24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 9 18 15 14 15 14 9 12 9 12 23 14 23 14 17 18 17 18 23 20 23 20 9 18 9"}),React.createElement("path",{d:"M30,15H26V6a2,2,0,0,0-2-2H8A2,2,0,0,0,6,6v9H2v2H6v9a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V17h4ZM8,26V6H24V26Z"}),props.children);});var QCircuitComposer20=/*#__PURE__*/React.forwardRef(function QCircuitComposer20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 9 18 15 14 15 14 9 12 9 12 23 14 23 14 17 18 17 18 23 20 23 20 9 18 9"}),React.createElement("path",{d:"M30,15H26V6a2,2,0,0,0-2-2H8A2,2,0,0,0,6,6v9H2v2H6v9a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V17h4ZM8,26V6H24V26Z"}),props.children);});var QCircuitComposer16=/*#__PURE__*/React.forwardRef(function QCircuitComposer16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 9 18 15 14 15 14 9 12 9 12 23 14 23 14 17 18 17 18 23 20 23 20 9 18 9"}),React.createElement("path",{d:"M30,15H26V6a2,2,0,0,0-2-2H8A2,2,0,0,0,6,6v9H2v2H6v9a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V17h4ZM8,26V6H24V26Z"}),props.children);});var QComposerEdit32=/*#__PURE__*/React.forwardRef(function QComposerEdit32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82,10H30V8H25.82a3,3,0,0,0-5.64,0H13V5H5V8H2v2H5v3h8V10h7.18A3,3,0,0,0,22,11.82v7.32A4,4,0,0,0,19.14,22H2v2H19.14a4,4,0,0,0,7.72,0H30V22H26.86A4,4,0,0,0,24,19.14V11.82A3,3,0,0,0,25.82,10ZM11,11H7V7h4ZM25,23a2,2,0,1,1-2-2A2,2,0,0,1,25,23Z"}),props.children);});var QComposerEdit24=/*#__PURE__*/React.forwardRef(function QComposerEdit24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82,10H30V8H25.82a3,3,0,0,0-5.64,0H13V5H5V8H2v2H5v3h8V10h7.18A3,3,0,0,0,22,11.82v7.32A4,4,0,0,0,19.14,22H2v2H19.14a4,4,0,0,0,7.72,0H30V22H26.86A4,4,0,0,0,24,19.14V11.82A3,3,0,0,0,25.82,10ZM11,11H7V7h4ZM25,23a2,2,0,1,1-2-2A2,2,0,0,1,25,23Z"}),props.children);});var QComposerEdit20=/*#__PURE__*/React.forwardRef(function QComposerEdit20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82,10H30V8H25.82a3,3,0,0,0-5.64,0H13V5H5V8H2v2H5v3h8V10h7.18A3,3,0,0,0,22,11.82v7.32A4,4,0,0,0,19.14,22H2v2H19.14a4,4,0,0,0,7.72,0H30V22H26.86A4,4,0,0,0,24,19.14V11.82A3,3,0,0,0,25.82,10ZM11,11H7V7h4ZM25,23a2,2,0,1,1-2-2A2,2,0,0,1,25,23Z"}),props.children);});var QComposerEdit16=/*#__PURE__*/React.forwardRef(function QComposerEdit16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82,10H30V8H25.82a3,3,0,0,0-5.64,0H13V5H5V8H2v2H5v3h8V10h7.18A3,3,0,0,0,22,11.82v7.32A4,4,0,0,0,19.14,22H2v2H19.14a4,4,0,0,0,7.72,0H30V22H26.86A4,4,0,0,0,24,19.14V11.82A3,3,0,0,0,25.82,10ZM11,11H7V7h4ZM25,23a2,2,0,1,1-2-2A2,2,0,0,1,25,23Z"}),props.children);});var QHintonPlot32=/*#__PURE__*/React.forwardRef(function QHintonPlot32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"4",x:"2",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"2",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"2",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"2",y:"26"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"26"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"26"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"26"}),props.children);});var QHintonPlot24=/*#__PURE__*/React.forwardRef(function QHintonPlot24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"4",x:"2",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"2",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"2",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"2",y:"26"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"26"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"26"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"26"}),props.children);});var QHintonPlot20=/*#__PURE__*/React.forwardRef(function QHintonPlot20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"4",x:"2",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"2",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"2",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"2",y:"26"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"26"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"26"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"26"}),props.children);});var QHintonPlot16=/*#__PURE__*/React.forwardRef(function QHintonPlot16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"4",x:"2",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"2"}),React.createElement("rect",{width:"4",height:"4",x:"2",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"10"}),React.createElement("rect",{width:"4",height:"4",x:"2",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"18"}),React.createElement("rect",{width:"4",height:"4",x:"2",y:"26"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"26"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"26"}),React.createElement("rect",{width:"4",height:"4",x:"26",y:"26"}),props.children);});var QID32=/*#__PURE__*/React.forwardRef(function QID32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"2",x:"10",y:"9"}),React.createElement("path",{d:"M18,23H14V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,18,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H16Z"}),React.createElement("rect",{width:"2",height:"10",x:"10",y:"13"}),props.children);});var QID24=/*#__PURE__*/React.forwardRef(function QID24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"2",x:"10",y:"9"}),React.createElement("path",{d:"M18,23H14V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,18,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H16Z"}),React.createElement("rect",{width:"2",height:"10",x:"10",y:"13"}),props.children);});var QID20=/*#__PURE__*/React.forwardRef(function QID20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"2",x:"10",y:"9"}),React.createElement("path",{d:"M18,23H14V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,18,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H16Z"}),React.createElement("rect",{width:"2",height:"10",x:"10",y:"13"}),props.children);});var QID16=/*#__PURE__*/React.forwardRef(function QID16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"2",x:"10",y:"9"}),React.createElement("path",{d:"M18,23H14V9h4a4,4,0,0,1,4,4v6A4,4,0,0,1,18,23Zm-2-2h2a2,2,0,0,0,2-2V13a2,2,0,0,0-2-2H16Z"}),React.createElement("rect",{width:"2",height:"10",x:"10",y:"13"}),props.children);});var QMatrix32=/*#__PURE__*/React.forwardRef(function QMatrix32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 13 18 4 16 4 16 6 13 6 13 8 16 8 16 13 13 13 13 15 21 15 21 13 18 13"}),React.createElement("path",{d:"M16.5,20A3.5,3.5,0,1,1,13,23.5,3.5,3.5,0,0,1,16.5,20m0-2A5.5,5.5,0,1,0,22,23.5,5.5,5.5,0,0,0,16.5,18Z"}),React.createElement("polygon",{points:"8 30 2 30 2 2 8 2 8 4 4 4 4 28 8 28 8 30"}),React.createElement("polygon",{points:"30 30 24 30 24 28 28 28 28 4 24 4 24 2 30 2 30 30"}),props.children);});var QMatrix24=/*#__PURE__*/React.forwardRef(function QMatrix24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 13 18 4 16 4 16 6 13 6 13 8 16 8 16 13 13 13 13 15 21 15 21 13 18 13"}),React.createElement("path",{d:"M16.5,20A3.5,3.5,0,1,1,13,23.5,3.5,3.5,0,0,1,16.5,20m0-2A5.5,5.5,0,1,0,22,23.5,5.5,5.5,0,0,0,16.5,18Z"}),React.createElement("polygon",{points:"8 30 2 30 2 2 8 2 8 4 4 4 4 28 8 28 8 30"}),React.createElement("polygon",{points:"30 30 24 30 24 28 28 28 28 4 24 4 24 2 30 2 30 30"}),props.children);});var QMatrix20=/*#__PURE__*/React.forwardRef(function QMatrix20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 13 18 4 16 4 16 6 13 6 13 8 16 8 16 13 13 13 13 15 21 15 21 13 18 13"}),React.createElement("path",{d:"M16.5,20A3.5,3.5,0,1,1,13,23.5,3.5,3.5,0,0,1,16.5,20m0-2A5.5,5.5,0,1,0,22,23.5,5.5,5.5,0,0,0,16.5,18Z"}),React.createElement("polygon",{points:"8 30 2 30 2 2 8 2 8 4 4 4 4 28 8 28 8 30"}),React.createElement("polygon",{points:"30 30 24 30 24 28 28 28 28 4 24 4 24 2 30 2 30 30"}),props.children);});var QMatrix16=/*#__PURE__*/React.forwardRef(function QMatrix16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 13 18 4 16 4 16 6 13 6 13 8 16 8 16 13 13 13 13 15 21 15 21 13 18 13"}),React.createElement("path",{d:"M16.5,20A3.5,3.5,0,1,1,13,23.5,3.5,3.5,0,0,1,16.5,20m0-2A5.5,5.5,0,1,0,22,23.5,5.5,5.5,0,0,0,16.5,18Z"}),React.createElement("polygon",{points:"8 30 2 30 2 2 8 2 8 4 4 4 4 28 8 28 8 30"}),React.createElement("polygon",{points:"30 30 24 30 24 28 28 28 28 4 24 4 24 2 30 2 30 30"}),props.children);});var QOperationGauge32=/*#__PURE__*/React.forwardRef(function QOperationGauge32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 4 24 4 24 6 27.75 6 24 10 24 12 30 12 30 10 26.38 10 30 6 30 4"}),React.createElement("path",{d:"M20,17.62,22.08,14l-1.73-1-2.18,3.76A12,12,0,0,0,2,28H4a10,10,0,0,1,13.16-9.48L14,24a2,2,0,1,0,2,2,2,2,0,0,0-.27-1L19,19.35A10,10,0,0,1,24,28h2A12,12,0,0,0,20,17.62Z"}),props.children);});var QOperationGauge24=/*#__PURE__*/React.forwardRef(function QOperationGauge24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 4 24 4 24 6 27.75 6 24 10 24 12 30 12 30 10 26.38 10 30 6 30 4"}),React.createElement("path",{d:"M20,17.62,22.08,14l-1.73-1-2.18,3.76A12,12,0,0,0,2,28H4a10,10,0,0,1,13.16-9.48L14,24a2,2,0,1,0,2,2,2,2,0,0,0-.27-1L19,19.35A10,10,0,0,1,24,28h2A12,12,0,0,0,20,17.62Z"}),props.children);});var QOperationGauge20=/*#__PURE__*/React.forwardRef(function QOperationGauge20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 4 24 4 24 6 27.75 6 24 10 24 12 30 12 30 10 26.38 10 30 6 30 4"}),React.createElement("path",{d:"M20,17.62,22.08,14l-1.73-1-2.18,3.76A12,12,0,0,0,2,28H4a10,10,0,0,1,13.16-9.48L14,24a2,2,0,1,0,2,2,2,2,0,0,0-.27-1L19,19.35A10,10,0,0,1,24,28h2A12,12,0,0,0,20,17.62Z"}),props.children);});var QOperationGauge16=/*#__PURE__*/React.forwardRef(function QOperationGauge16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 4 24 4 24 6 27.75 6 24 10 24 12 30 12 30 10 26.38 10 30 6 30 4"}),React.createElement("path",{d:"M20,17.62,22.08,14l-1.73-1-2.18,3.76A12,12,0,0,0,2,28H4a10,10,0,0,1,13.16-9.48L14,24a2,2,0,1,0,2,2,2,2,0,0,0-.27-1L19,19.35A10,10,0,0,1,24,28h2A12,12,0,0,0,20,17.62Z"}),props.children);});var QOperationIf32=/*#__PURE__*/React.forwardRef(function QOperationIf32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"10",x:"12",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"12",y:"9"}),React.createElement("path",{d:"M23,11V9H20a2,2,0,0,0-2,2v2H16v2h2v8h2V15h3V13H20V11Z"}),props.children);});var QOperationIf24=/*#__PURE__*/React.forwardRef(function QOperationIf24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"10",x:"12",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"12",y:"9"}),React.createElement("path",{d:"M23,11V9H20a2,2,0,0,0-2,2v2H16v2h2v8h2V15h3V13H20V11Z"}),props.children);});var QOperationIf20=/*#__PURE__*/React.forwardRef(function QOperationIf20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"10",x:"12",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"12",y:"9"}),React.createElement("path",{d:"M23,11V9H20a2,2,0,0,0-2,2v2H16v2h2v8h2V15h3V13H20V11Z"}),props.children);});var QOperationIf16=/*#__PURE__*/React.forwardRef(function QOperationIf16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"10",x:"12",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"12",y:"9"}),React.createElement("path",{d:"M23,11V9H20a2,2,0,0,0-2,2v2H16v2h2v8h2V15h3V13H20V11Z"}),props.children);});var QOperation32=/*#__PURE__*/React.forwardRef(function QOperation32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 26 21 26 26 16 21 6 23 6 28 16 23 26"}),React.createElement("rect",{width:"2",height:"20",x:"4",y:"6"}),React.createElement("path",{d:"M16,9H12a2,2,0,0,0-2,2V21a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V11A2,2,0,0,0,16,9Zm0,12H12V11h4Z"}),React.createElement("rect",{width:"2",height:"2",x:"13",y:"15"}),props.children);});var QOperation24=/*#__PURE__*/React.forwardRef(function QOperation24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 26 21 26 26 16 21 6 23 6 28 16 23 26"}),React.createElement("rect",{width:"2",height:"20",x:"4",y:"6"}),React.createElement("path",{d:"M16,9H12a2,2,0,0,0-2,2V21a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V11A2,2,0,0,0,16,9Zm0,12H12V11h4Z"}),React.createElement("rect",{width:"2",height:"2",x:"13",y:"15"}),props.children);});var QOperation20=/*#__PURE__*/React.forwardRef(function QOperation20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 26 21 26 26 16 21 6 23 6 28 16 23 26"}),React.createElement("rect",{width:"2",height:"20",x:"4",y:"6"}),React.createElement("path",{d:"M16,9H12a2,2,0,0,0-2,2V21a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V11A2,2,0,0,0,16,9Zm0,12H12V11h4Z"}),React.createElement("rect",{width:"2",height:"2",x:"13",y:"15"}),props.children);});var QOperation16=/*#__PURE__*/React.forwardRef(function QOperation16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 26 21 26 26 16 21 6 23 6 28 16 23 26"}),React.createElement("rect",{width:"2",height:"20",x:"4",y:"6"}),React.createElement("path",{d:"M16,9H12a2,2,0,0,0-2,2V21a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V11A2,2,0,0,0,16,9Zm0,12H12V11h4Z"}),React.createElement("rect",{width:"2",height:"2",x:"13",y:"15"}),props.children);});var Raw32=/*#__PURE__*/React.forwardRef(function Raw32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"29.2 9 28.86 17 28.6 21.54 28.19 18 27.51 12.54 25.49 12.54 24.81 18 24.4 21.54 24.14 17 23.8 9 22 9 23 23 25.27 23 26.03 18.07 26.49 14 26.5 13.97 26.51 14 26.97 18.07 27.73 23 30 23 31 9 29.2 9"}),React.createElement("path",{d:"M18,9H14a2,2,0,0,0-2,2V23h2V18h4v5h2V11A2,2,0,0,0,18,9Zm-4,7V11h4v5Z"}),React.createElement("path",{d:"M10,15V11A2,2,0,0,0,8,9H2V23H4V17H5.48l2.34,6H10L7.63,17H8A2,2,0,0,0,10,15ZM4,11H8v4H4Z"}),props.children);});var Raw24=/*#__PURE__*/React.forwardRef(function Raw24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"29.2 9 28.86 17 28.6 21.54 28.19 18 27.51 12.54 25.49 12.54 24.81 18 24.4 21.54 24.14 17 23.8 9 22 9 23 23 25.27 23 26.03 18.07 26.49 14 26.5 13.97 26.51 14 26.97 18.07 27.73 23 30 23 31 9 29.2 9"}),React.createElement("path",{d:"M18,9H14a2,2,0,0,0-2,2V23h2V18h4v5h2V11A2,2,0,0,0,18,9Zm-4,7V11h4v5Z"}),React.createElement("path",{d:"M10,15V11A2,2,0,0,0,8,9H2V23H4V17H5.48l2.34,6H10L7.63,17H8A2,2,0,0,0,10,15ZM4,11H8v4H4Z"}),props.children);});var Raw20=/*#__PURE__*/React.forwardRef(function Raw20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"29.2 9 28.86 17 28.6 21.54 28.19 18 27.51 12.54 25.49 12.54 24.81 18 24.4 21.54 24.14 17 23.8 9 22 9 23 23 25.27 23 26.03 18.07 26.49 14 26.5 13.97 26.51 14 26.97 18.07 27.73 23 30 23 31 9 29.2 9"}),React.createElement("path",{d:"M18,9H14a2,2,0,0,0-2,2V23h2V18h4v5h2V11A2,2,0,0,0,18,9Zm-4,7V11h4v5Z"}),React.createElement("path",{d:"M10,15V11A2,2,0,0,0,8,9H2V23H4V17H5.48l2.34,6H10L7.63,17H8A2,2,0,0,0,10,15ZM4,11H8v4H4Z"}),props.children);});var Raw16=/*#__PURE__*/React.forwardRef(function Raw16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"29.2 9 28.86 17 28.6 21.54 28.19 18 27.51 12.54 25.49 12.54 24.81 18 24.4 21.54 24.14 17 23.8 9 22 9 23 23 25.27 23 26.03 18.07 26.49 14 26.5 13.97 26.51 14 26.97 18.07 27.73 23 30 23 31 9 29.2 9"}),React.createElement("path",{d:"M18,9H14a2,2,0,0,0-2,2V23h2V18h4v5h2V11A2,2,0,0,0,18,9Zm-4,7V11h4v5Z"}),React.createElement("path",{d:"M10,15V11A2,2,0,0,0,8,9H2V23H4V17H5.48l2.34,6H10L7.63,17H8A2,2,0,0,0,10,15ZM4,11H8v4H4Z"}),props.children);});var Sdk32=/*#__PURE__*/React.forwardRef(function Sdk32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 9 27.9 9 24 15.6 24 9 22 9 22 23 24 23 24 18.7 24.9 17.2 27.9 23 30 23 26.1 15.4 30 9"}),React.createElement("path",{d:"M16,23H12V9h4a4.0118,4.0118,0,0,1,4,4v6A4.0118,4.0118,0,0,1,16,23Zm-2-2h2a2.0059,2.0059,0,0,0,2-2V13a2.0059,2.0059,0,0,0-2-2H14Z"}),React.createElement("path",{d:"M8,23H2V21H8V17H4a2.0059,2.0059,0,0,1-2-2V11A2.0059,2.0059,0,0,1,4,9h6v2H4v4H8a2.0059,2.0059,0,0,1,2,2v4A2.0059,2.0059,0,0,1,8,23Z"}),props.children);});var Sdk24=/*#__PURE__*/React.forwardRef(function Sdk24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 9 27.9 9 24 15.6 24 9 22 9 22 23 24 23 24 18.7 24.9 17.2 27.9 23 30 23 26.1 15.4 30 9"}),React.createElement("path",{d:"M16,23H12V9h4a4.0118,4.0118,0,0,1,4,4v6A4.0118,4.0118,0,0,1,16,23Zm-2-2h2a2.0059,2.0059,0,0,0,2-2V13a2.0059,2.0059,0,0,0-2-2H14Z"}),React.createElement("path",{d:"M8,23H2V21H8V17H4a2.0059,2.0059,0,0,1-2-2V11A2.0059,2.0059,0,0,1,4,9h6v2H4v4H8a2.0059,2.0059,0,0,1,2,2v4A2.0059,2.0059,0,0,1,8,23Z"}),props.children);});var Sdk20=/*#__PURE__*/React.forwardRef(function Sdk20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 9 27.9 9 24 15.6 24 9 22 9 22 23 24 23 24 18.7 24.9 17.2 27.9 23 30 23 26.1 15.4 30 9"}),React.createElement("path",{d:"M16,23H12V9h4a4.0118,4.0118,0,0,1,4,4v6A4.0118,4.0118,0,0,1,16,23Zm-2-2h2a2.0059,2.0059,0,0,0,2-2V13a2.0059,2.0059,0,0,0-2-2H14Z"}),React.createElement("path",{d:"M8,23H2V21H8V17H4a2.0059,2.0059,0,0,1-2-2V11A2.0059,2.0059,0,0,1,4,9h6v2H4v4H8a2.0059,2.0059,0,0,1,2,2v4A2.0059,2.0059,0,0,1,8,23Z"}),props.children);});var Sdk16=/*#__PURE__*/React.forwardRef(function Sdk16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 9 27.9 9 24 15.6 24 9 22 9 22 23 24 23 24 18.7 24.9 17.2 27.9 23 30 23 26.1 15.4 30 9"}),React.createElement("path",{d:"M16,23H12V9h4a4.0118,4.0118,0,0,1,4,4v6A4.0118,4.0118,0,0,1,16,23Zm-2-2h2a2.0059,2.0059,0,0,0,2-2V13a2.0059,2.0059,0,0,0-2-2H14Z"}),React.createElement("path",{d:"M8,23H2V21H8V17H4a2.0059,2.0059,0,0,1-2-2V11A2.0059,2.0059,0,0,1,4,9h6v2H4v4H8a2.0059,2.0059,0,0,1,2,2v4A2.0059,2.0059,0,0,1,8,23Z"}),props.children);});var Sql32=/*#__PURE__*/React.forwardRef(function Sql32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 21 24 9 22 9 22 23 30 23 30 21 24 21"}),React.createElement("path",{d:"M18,9H14a2,2,0,0,0-2,2V21a2,2,0,0,0,2,2h1v2a2,2,0,0,0,2,2h2V25H17V23h1a2,2,0,0,0,2-2V11A2,2,0,0,0,18,9ZM14,21V11h4V21Z"}),React.createElement("path",{d:"M8,23H2V21H8V17H4a2,2,0,0,1-2-2V11A2,2,0,0,1,4,9h6v2H4v4H8a2,2,0,0,1,2,2v4A2,2,0,0,1,8,23Z"}),props.children);});var Sql24=/*#__PURE__*/React.forwardRef(function Sql24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 21 24 9 22 9 22 23 30 23 30 21 24 21"}),React.createElement("path",{d:"M18,9H14a2,2,0,0,0-2,2V21a2,2,0,0,0,2,2h1v2a2,2,0,0,0,2,2h2V25H17V23h1a2,2,0,0,0,2-2V11A2,2,0,0,0,18,9ZM14,21V11h4V21Z"}),React.createElement("path",{d:"M8,23H2V21H8V17H4a2,2,0,0,1-2-2V11A2,2,0,0,1,4,9h6v2H4v4H8a2,2,0,0,1,2,2v4A2,2,0,0,1,8,23Z"}),props.children);});var Sql20=/*#__PURE__*/React.forwardRef(function Sql20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 21 24 9 22 9 22 23 30 23 30 21 24 21"}),React.createElement("path",{d:"M18,9H14a2,2,0,0,0-2,2V21a2,2,0,0,0,2,2h1v2a2,2,0,0,0,2,2h2V25H17V23h1a2,2,0,0,0,2-2V11A2,2,0,0,0,18,9ZM14,21V11h4V21Z"}),React.createElement("path",{d:"M8,23H2V21H8V17H4a2,2,0,0,1-2-2V11A2,2,0,0,1,4,9h6v2H4v4H8a2,2,0,0,1,2,2v4A2,2,0,0,1,8,23Z"}),props.children);});var Sql16=/*#__PURE__*/React.forwardRef(function Sql16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 21 24 9 22 9 22 23 30 23 30 21 24 21"}),React.createElement("path",{d:"M18,9H14a2,2,0,0,0-2,2V21a2,2,0,0,0,2,2h1v2a2,2,0,0,0,2,2h2V25H17V23h1a2,2,0,0,0,2-2V11A2,2,0,0,0,18,9ZM14,21V11h4V21Z"}),React.createElement("path",{d:"M8,23H2V21H8V17H4a2,2,0,0,1-2-2V11A2,2,0,0,1,4,9h6v2H4v4H8a2,2,0,0,1,2,2v4A2,2,0,0,1,8,23Z"}),props.children);});var Svg32=/*#__PURE__*/React.forwardRef(function Svg32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H24V21h4V17H26V15h4Z"}),React.createElement("polygon",{points:"18 9 16 22 14 9 12 9 14.52 23 17.48 23 20 9 18 9"}),React.createElement("path",{d:"M8,23H2V21H8V17H4a2,2,0,0,1-2-2V11A2,2,0,0,1,4,9h6v2H4v4H8a2,2,0,0,1,2,2v4A2,2,0,0,1,8,23Z"}),props.children);});var Svg24=/*#__PURE__*/React.forwardRef(function Svg24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H24V21h4V17H26V15h4Z"}),React.createElement("polygon",{points:"18 9 16 22 14 9 12 9 14.52 23 17.48 23 20 9 18 9"}),React.createElement("path",{d:"M8,23H2V21H8V17H4a2,2,0,0,1-2-2V11A2,2,0,0,1,4,9h6v2H4v4H8a2,2,0,0,1,2,2v4A2,2,0,0,1,8,23Z"}),props.children);});var Svg20=/*#__PURE__*/React.forwardRef(function Svg20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H24V21h4V17H26V15h4Z"}),React.createElement("polygon",{points:"18 9 16 22 14 9 12 9 14.52 23 17.48 23 20 9 18 9"}),React.createElement("path",{d:"M8,23H2V21H8V17H4a2,2,0,0,1-2-2V11A2,2,0,0,1,4,9h6v2H4v4H8a2,2,0,0,1,2,2v4A2,2,0,0,1,8,23Z"}),props.children);});var Svg16=/*#__PURE__*/React.forwardRef(function Svg16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,23H24a2,2,0,0,1-2-2V11a2,2,0,0,1,2-2h6v2H24V21h4V17H26V15h4Z"}),React.createElement("polygon",{points:"18 9 16 22 14 9 12 9 14.52 23 17.48 23 20 9 18 9"}),React.createElement("path",{d:"M8,23H2V21H8V17H4a2,2,0,0,1-2-2V11A2,2,0,0,1,4,9h6v2H4v4H8a2,2,0,0,1,2,2v4A2,2,0,0,1,8,23Z"}),props.children);});var Tif32=/*#__PURE__*/React.forwardRef(function Tif32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 11 30 9 22 9 22 23 24 23 24 17 29 17 29 15 24 15 24 11 30 11"}),React.createElement("polygon",{points:"12 11 15 11 15 21 12 21 12 23 20 23 20 21 17 21 17 11 20 11 20 9 12 9 12 11"}),React.createElement("polygon",{points:"2 11 5 11 5 23 7 23 7 11 10 11 10 9 2 9 2 11"}),props.children);});var Tif24=/*#__PURE__*/React.forwardRef(function Tif24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 11 30 9 22 9 22 23 24 23 24 17 29 17 29 15 24 15 24 11 30 11"}),React.createElement("polygon",{points:"12 11 15 11 15 21 12 21 12 23 20 23 20 21 17 21 17 11 20 11 20 9 12 9 12 11"}),React.createElement("polygon",{points:"2 11 5 11 5 23 7 23 7 11 10 11 10 9 2 9 2 11"}),props.children);});var Tif20=/*#__PURE__*/React.forwardRef(function Tif20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 11 30 9 22 9 22 23 24 23 24 17 29 17 29 15 24 15 24 11 30 11"}),React.createElement("polygon",{points:"12 11 15 11 15 21 12 21 12 23 20 23 20 21 17 21 17 11 20 11 20 9 12 9 12 11"}),React.createElement("polygon",{points:"2 11 5 11 5 23 7 23 7 11 10 11 10 9 2 9 2 11"}),props.children);});var Tif16=/*#__PURE__*/React.forwardRef(function Tif16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 11 30 9 22 9 22 23 24 23 24 17 29 17 29 15 24 15 24 11 30 11"}),React.createElement("polygon",{points:"12 11 15 11 15 21 12 21 12 23 20 23 20 21 17 21 17 11 20 11 20 9 12 9 12 11"}),React.createElement("polygon",{points:"2 11 5 11 5 23 7 23 7 11 10 11 10 9 2 9 2 11"}),props.children);});var Tsv32=/*#__PURE__*/React.forwardRef(function Tsv32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 9 26 22 24 9 22 9 24.516 23 27.484 23 30 9 28 9"}),React.createElement("path",{d:"M18,23H12V21h6V17H14a2.002,2.002,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H14v4h4a2.002,2.002,0,0,1,2,2v4A2.002,2.002,0,0,1,18,23Z"}),React.createElement("polygon",{points:"2 11 5 11 5 23 7 23 7 11 10 11 10 9 2 9 2 11"}),props.children);});var Tsv24=/*#__PURE__*/React.forwardRef(function Tsv24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 9 26 22 24 9 22 9 24.516 23 27.484 23 30 9 28 9"}),React.createElement("path",{d:"M18,23H12V21h6V17H14a2.002,2.002,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H14v4h4a2.002,2.002,0,0,1,2,2v4A2.002,2.002,0,0,1,18,23Z"}),React.createElement("polygon",{points:"2 11 5 11 5 23 7 23 7 11 10 11 10 9 2 9 2 11"}),props.children);});var Tsv20=/*#__PURE__*/React.forwardRef(function Tsv20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 9 26 22 24 9 22 9 24.516 23 27.484 23 30 9 28 9"}),React.createElement("path",{d:"M18,23H12V21h6V17H14a2.002,2.002,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H14v4h4a2.002,2.002,0,0,1,2,2v4A2.002,2.002,0,0,1,18,23Z"}),React.createElement("polygon",{points:"2 11 5 11 5 23 7 23 7 11 10 11 10 9 2 9 2 11"}),props.children);});var Tsv16=/*#__PURE__*/React.forwardRef(function Tsv16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 9 26 22 24 9 22 9 24.516 23 27.484 23 30 9 28 9"}),React.createElement("path",{d:"M18,23H12V21h6V17H14a2.002,2.002,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H14v4h4a2.002,2.002,0,0,1,2,2v4A2.002,2.002,0,0,1,18,23Z"}),React.createElement("polygon",{points:"2 11 5 11 5 23 7 23 7 11 10 11 10 9 2 9 2 11"}),props.children);});var Txt32=/*#__PURE__*/React.forwardRef(function Txt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"21 11 24 11 24 23 26 23 26 11 29 11 29 9 21 9 21 11"}),React.createElement("polygon",{points:"20 9 18 9 16 15 14 9 12 9 14.75 16 12 23 14 23 16 17 18 23 20 23 17.25 16 20 9"}),React.createElement("polygon",{points:"3 11 6 11 6 23 8 23 8 11 11 11 11 9 3 9 3 11"}),props.children);});var Txt24=/*#__PURE__*/React.forwardRef(function Txt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"21 11 24 11 24 23 26 23 26 11 29 11 29 9 21 9 21 11"}),React.createElement("polygon",{points:"20 9 18 9 16 15 14 9 12 9 14.75 16 12 23 14 23 16 17 18 23 20 23 17.25 16 20 9"}),React.createElement("polygon",{points:"3 11 6 11 6 23 8 23 8 11 11 11 11 9 3 9 3 11"}),props.children);});var Txt20=/*#__PURE__*/React.forwardRef(function Txt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"21 11 24 11 24 23 26 23 26 11 29 11 29 9 21 9 21 11"}),React.createElement("polygon",{points:"20 9 18 9 16 15 14 9 12 9 14.75 16 12 23 14 23 16 17 18 23 20 23 17.25 16 20 9"}),React.createElement("polygon",{points:"3 11 6 11 6 23 8 23 8 11 11 11 11 9 3 9 3 11"}),props.children);});var Txt16=/*#__PURE__*/React.forwardRef(function Txt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"21 11 24 11 24 23 26 23 26 11 29 11 29 9 21 9 21 11"}),React.createElement("polygon",{points:"20 9 18 9 16 15 14 9 12 9 14.75 16 12 23 14 23 16 17 18 23 20 23 17.25 16 20 9"}),React.createElement("polygon",{points:"3 11 6 11 6 23 8 23 8 11 11 11 11 9 3 9 3 11"}),props.children);});var Usb32=/*#__PURE__*/React.forwardRef(function Usb32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,15V6a2,2,0,0,0-2-2H10A2,2,0,0,0,8,6v9a2,2,0,0,0-2,2V28H8V17H24V28h2V17A2,2,0,0,0,24,15ZM10,6H22v9H10Z"}),React.createElement("rect",{width:"3",height:"2",x:"12",y:"10"}),React.createElement("rect",{width:"3",height:"2",x:"17",y:"10"}),props.children);});var Usb24=/*#__PURE__*/React.forwardRef(function Usb24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,15V6a2,2,0,0,0-2-2H10A2,2,0,0,0,8,6v9a2,2,0,0,0-2,2V28H8V17H24V28h2V17A2,2,0,0,0,24,15ZM10,6H22v9H10Z"}),React.createElement("rect",{width:"3",height:"2",x:"12",y:"10"}),React.createElement("rect",{width:"3",height:"2",x:"17",y:"10"}),props.children);});var Usb20=/*#__PURE__*/React.forwardRef(function Usb20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,15V6a2,2,0,0,0-2-2H10A2,2,0,0,0,8,6v9a2,2,0,0,0-2,2V28H8V17H24V28h2V17A2,2,0,0,0,24,15ZM10,6H22v9H10Z"}),React.createElement("rect",{width:"3",height:"2",x:"12",y:"10"}),React.createElement("rect",{width:"3",height:"2",x:"17",y:"10"}),props.children);});var Usb16=/*#__PURE__*/React.forwardRef(function Usb16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,15V6a2,2,0,0,0-2-2H10A2,2,0,0,0,8,6v9a2,2,0,0,0-2,2V28H8V17H24V28h2V17A2,2,0,0,0,24,15ZM10,6H22v9H10Z"}),React.createElement("rect",{width:"3",height:"2",x:"12",y:"10"}),React.createElement("rect",{width:"3",height:"2",x:"17",y:"10"}),props.children);});var Vpn32=/*#__PURE__*/React.forwardRef(function Vpn32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("polygon",{points:"28 19 24.32 9 22 9 22 23 24 23 24 13 27.68 23 30 23 30 9 28 9 28 19"}),React.createElement("polygon",{points:"8 9 6 22 4 9 2 9 4.52 23 7.48 23 10 9 8 9"}),props.children);});var Vpn24=/*#__PURE__*/React.forwardRef(function Vpn24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("polygon",{points:"28 19 24.32 9 22 9 22 23 24 23 24 13 27.68 23 30 23 30 9 28 9 28 19"}),React.createElement("polygon",{points:"8 9 6 22 4 9 2 9 4.52 23 7.48 23 10 9 8 9"}),props.children);});var Vpn20=/*#__PURE__*/React.forwardRef(function Vpn20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("polygon",{points:"28 19 24.32 9 22 9 22 23 24 23 24 13 27.68 23 30 23 30 9 28 9 28 19"}),React.createElement("polygon",{points:"8 9 6 22 4 9 2 9 4.52 23 7.48 23 10 9 8 9"}),props.children);});var Vpn16=/*#__PURE__*/React.forwardRef(function Vpn16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14,23H12V9h6a2,2,0,0,1,2,2v5a2,2,0,0,1-2,2H14Zm0-7h4V11H14Z"}),React.createElement("polygon",{points:"28 19 24.32 9 22 9 22 23 24 23 24 13 27.68 23 30 23 30 9 28 9 28 19"}),React.createElement("polygon",{points:"8 9 6 22 4 9 2 9 4.52 23 7.48 23 10 9 8 9"}),props.children);});var Wmv32=/*#__PURE__*/React.forwardRef(function Wmv32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"29 9 27 22 25 9 23 9 25.52 23 28.48 23 31 9 29 9"}),React.createElement("polygon",{points:"19 9 17.48 14 17 15.98 16.54 14 15 9 13 9 13 23 15 23 15 15 14.84 13 15.42 15 17 19.63 18.58 15 19.16 13 19 15 19 23 21 23 21 9 19 9"}),React.createElement("polygon",{points:"9.2 9 8.86 17 8.6 21.54 8.19 18 7.51 12.54 5.49 12.54 4.81 18 4.4 21.54 4.14 17 3.8 9 2 9 3 23 5.27 23 6.03 18.07 6.49 14 6.5 13.97 6.51 14 6.97 18.07 7.73 23 10 23 11 9 9.2 9"}),props.children);});var Wmv24=/*#__PURE__*/React.forwardRef(function Wmv24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"29 9 27 22 25 9 23 9 25.52 23 28.48 23 31 9 29 9"}),React.createElement("polygon",{points:"19 9 17.48 14 17 15.98 16.54 14 15 9 13 9 13 23 15 23 15 15 14.84 13 15.42 15 17 19.63 18.58 15 19.16 13 19 15 19 23 21 23 21 9 19 9"}),React.createElement("polygon",{points:"9.2 9 8.86 17 8.6 21.54 8.19 18 7.51 12.54 5.49 12.54 4.81 18 4.4 21.54 4.14 17 3.8 9 2 9 3 23 5.27 23 6.03 18.07 6.49 14 6.5 13.97 6.51 14 6.97 18.07 7.73 23 10 23 11 9 9.2 9"}),props.children);});var Wmv20=/*#__PURE__*/React.forwardRef(function Wmv20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"29 9 27 22 25 9 23 9 25.52 23 28.48 23 31 9 29 9"}),React.createElement("polygon",{points:"19 9 17.48 14 17 15.98 16.54 14 15 9 13 9 13 23 15 23 15 15 14.84 13 15.42 15 17 19.63 18.58 15 19.16 13 19 15 19 23 21 23 21 9 19 9"}),React.createElement("polygon",{points:"9.2 9 8.86 17 8.6 21.54 8.19 18 7.51 12.54 5.49 12.54 4.81 18 4.4 21.54 4.14 17 3.8 9 2 9 3 23 5.27 23 6.03 18.07 6.49 14 6.5 13.97 6.51 14 6.97 18.07 7.73 23 10 23 11 9 9.2 9"}),props.children);});var Wmv16=/*#__PURE__*/React.forwardRef(function Wmv16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"29 9 27 22 25 9 23 9 25.52 23 28.48 23 31 9 29 9"}),React.createElement("polygon",{points:"19 9 17.48 14 17 15.98 16.54 14 15 9 13 9 13 23 15 23 15 15 14.84 13 15.42 15 17 19.63 18.58 15 19.16 13 19 15 19 23 21 23 21 9 19 9"}),React.createElement("polygon",{points:"9.2 9 8.86 17 8.6 21.54 8.19 18 7.51 12.54 5.49 12.54 4.81 18 4.4 21.54 4.14 17 3.8 9 2 9 3 23 5.27 23 6.03 18.07 6.49 14 6.5 13.97 6.51 14 6.97 18.07 7.73 23 10 23 11 9 9.2 9"}),props.children);});var Xls32=/*#__PURE__*/React.forwardRef(function Xls32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,23H22V21h6V17H24a2.002,2.002,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H24v4h4a2.002,2.002,0,0,1,2,2v4A2.0023,2.0023,0,0,1,28,23Z"}),React.createElement("polygon",{points:"14 21 14 9 12 9 12 23 20 23 20 21 14 21"}),React.createElement("polygon",{points:"10 9 8 9 6 15 4 9 2 9 4.752 16 2 23 4 23 6 17 8 23 10 23 7.245 16 10 9"}),props.children);});var Xls24=/*#__PURE__*/React.forwardRef(function Xls24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,23H22V21h6V17H24a2.002,2.002,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H24v4h4a2.002,2.002,0,0,1,2,2v4A2.0023,2.0023,0,0,1,28,23Z"}),React.createElement("polygon",{points:"14 21 14 9 12 9 12 23 20 23 20 21 14 21"}),React.createElement("polygon",{points:"10 9 8 9 6 15 4 9 2 9 4.752 16 2 23 4 23 6 17 8 23 10 23 7.245 16 10 9"}),props.children);});var Xls20=/*#__PURE__*/React.forwardRef(function Xls20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,23H22V21h6V17H24a2.002,2.002,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H24v4h4a2.002,2.002,0,0,1,2,2v4A2.0023,2.0023,0,0,1,28,23Z"}),React.createElement("polygon",{points:"14 21 14 9 12 9 12 23 20 23 20 21 14 21"}),React.createElement("polygon",{points:"10 9 8 9 6 15 4 9 2 9 4.752 16 2 23 4 23 6 17 8 23 10 23 7.245 16 10 9"}),props.children);});var Xls16=/*#__PURE__*/React.forwardRef(function Xls16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,23H22V21h6V17H24a2.002,2.002,0,0,1-2-2V11a2.002,2.002,0,0,1,2-2h6v2H24v4h4a2.002,2.002,0,0,1,2,2v4A2.0023,2.0023,0,0,1,28,23Z"}),React.createElement("polygon",{points:"14 21 14 9 12 9 12 23 20 23 20 21 14 21"}),React.createElement("polygon",{points:"10 9 8 9 6 15 4 9 2 9 4.752 16 2 23 4 23 6 17 8 23 10 23 7.245 16 10 9"}),props.children);});var Xml32=/*#__PURE__*/React.forwardRef(function Xml32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 21 24 9 22 9 22 23 30 23 30 21 24 21"}),React.createElement("polygon",{points:"18 9 16.48 14 16 15.98 15.54 14 14 9 12 9 12 23 14 23 14 15 13.84 13 14.42 15 16 19.63 17.58 15 18.16 13 18 15 18 23 20 23 20 9 18 9"}),React.createElement("polygon",{points:"10 9 8 9 6 15 4 9 2 9 4.75 16 2 23 4 23 6 17 8 23 10 23 7.25 16 10 9"}),props.children);});var Xml24=/*#__PURE__*/React.forwardRef(function Xml24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 21 24 9 22 9 22 23 30 23 30 21 24 21"}),React.createElement("polygon",{points:"18 9 16.48 14 16 15.98 15.54 14 14 9 12 9 12 23 14 23 14 15 13.84 13 14.42 15 16 19.63 17.58 15 18.16 13 18 15 18 23 20 23 20 9 18 9"}),React.createElement("polygon",{points:"10 9 8 9 6 15 4 9 2 9 4.75 16 2 23 4 23 6 17 8 23 10 23 7.25 16 10 9"}),props.children);});var Xml20=/*#__PURE__*/React.forwardRef(function Xml20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 21 24 9 22 9 22 23 30 23 30 21 24 21"}),React.createElement("polygon",{points:"18 9 16.48 14 16 15.98 15.54 14 14 9 12 9 12 23 14 23 14 15 13.84 13 14.42 15 16 19.63 17.58 15 18.16 13 18 15 18 23 20 23 20 9 18 9"}),React.createElement("polygon",{points:"10 9 8 9 6 15 4 9 2 9 4.75 16 2 23 4 23 6 17 8 23 10 23 7.25 16 10 9"}),props.children);});var Xml16=/*#__PURE__*/React.forwardRef(function Xml16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 21 24 9 22 9 22 23 30 23 30 21 24 21"}),React.createElement("polygon",{points:"18 9 16.48 14 16 15.98 15.54 14 14 9 12 9 12 23 14 23 14 15 13.84 13 14.42 15 16 19.63 17.58 15 18.16 13 18 15 18 23 20 23 20 9 18 9"}),React.createElement("polygon",{points:"10 9 8 9 6 15 4 9 2 9 4.75 16 2 23 4 23 6 17 8 23 10 23 7.25 16 10 9"}),props.children);});var Zip32=/*#__PURE__*/React.forwardRef(function Zip32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H22V23h2V18h4a2,2,0,0,0,2-2V11A2,2,0,0,0,28,9Zm0,7H24V11h4Z"}),React.createElement("polygon",{points:"12 9 12 11 15 11 15 21 12 21 12 23 20 23 20 21 17 21 17 11 20 11 20 9 12 9"}),React.createElement("polygon",{points:"10 9 2 9 2 11 8 11 2 21 2 23 10 23 10 21 4 21 10 11 10 9"}),props.children);});var Zip24=/*#__PURE__*/React.forwardRef(function Zip24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H22V23h2V18h4a2,2,0,0,0,2-2V11A2,2,0,0,0,28,9Zm0,7H24V11h4Z"}),React.createElement("polygon",{points:"12 9 12 11 15 11 15 21 12 21 12 23 20 23 20 21 17 21 17 11 20 11 20 9 12 9"}),React.createElement("polygon",{points:"10 9 2 9 2 11 8 11 2 21 2 23 10 23 10 21 4 21 10 11 10 9"}),props.children);});var Zip20=/*#__PURE__*/React.forwardRef(function Zip20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H22V23h2V18h4a2,2,0,0,0,2-2V11A2,2,0,0,0,28,9Zm0,7H24V11h4Z"}),React.createElement("polygon",{points:"12 9 12 11 15 11 15 21 12 21 12 23 20 23 20 21 17 21 17 11 20 11 20 9 12 9"}),React.createElement("polygon",{points:"10 9 2 9 2 11 8 11 2 21 2 23 10 23 10 21 4 21 10 11 10 9"}),props.children);});var Zip16=/*#__PURE__*/React.forwardRef(function Zip16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H22V23h2V18h4a2,2,0,0,0,2-2V11A2,2,0,0,0,28,9Zm0,7H24V11h4Z"}),React.createElement("polygon",{points:"12 9 12 11 15 11 15 21 12 21 12 23 20 23 20 21 17 21 17 11 20 11 20 9 12 9"}),React.createElement("polygon",{points:"10 9 2 9 2 11 8 11 2 21 2 23 10 23 10 21 4 21 10 11 10 9"}),props.children);});var AccessibilityAlt32=/*#__PURE__*/React.forwardRef(function AccessibilityAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 14 23 12 9 12 9 14 14 14 14 16.734 10.132 23.504 11.868 24.496 15.58 18 16.42 18 20.132 24.496 21.868 23.504 18 16.734 18 14 23 14"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("path",{d:"M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"}),props.children);});var AccessibilityAlt24=/*#__PURE__*/React.forwardRef(function AccessibilityAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 14 23 12 9 12 9 14 14 14 14 16.734 10.132 23.504 11.868 24.496 15.58 18 16.42 18 20.132 24.496 21.868 23.504 18 16.734 18 14 23 14"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("path",{d:"M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"}),props.children);});var AccessibilityAlt20=/*#__PURE__*/React.forwardRef(function AccessibilityAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 14 23 12 9 12 9 14 14 14 14 16.734 10.132 23.504 11.868 24.496 15.58 18 16.42 18 20.132 24.496 21.868 23.504 18 16.734 18 14 23 14"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("path",{d:"M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"}),props.children);});var AccessibilityAlt16=/*#__PURE__*/React.forwardRef(function AccessibilityAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 14 23 12 9 12 9 14 14 14 14 16.734 10.132 23.504 11.868 24.496 15.58 18 16.42 18 20.132 24.496 21.868 23.504 18 16.734 18 14 23 14"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("path",{d:"M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"}),props.children);});var AccessibilityColorFilled32=/*#__PURE__*/React.forwardRef(function AccessibilityColorFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,10a8.5975,8.5975,0,0,0-7.9648,6A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10Zm0,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Z"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,22a10.6543,10.6543,0,0,1-9.97-7.7578L5.9692,16l.0606-.2422A10.6543,10.6543,0,0,1,16,8a10.6543,10.6543,0,0,1,9.97,7.7578L26.0308,16l-.0606.2422A10.6543,10.6543,0,0,1,16,24Z"}),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("path",{fill:"none",d:"M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"}),React.createElement("path",{fill:"none",d:"M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"}),props.children);});var AccessibilityColorFilled24=/*#__PURE__*/React.forwardRef(function AccessibilityColorFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,10a8.5975,8.5975,0,0,0-7.9648,6A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10Zm0,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Z"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,22a10.6543,10.6543,0,0,1-9.97-7.7578L5.9692,16l.0606-.2422A10.6543,10.6543,0,0,1,16,8a10.6543,10.6543,0,0,1,9.97,7.7578L26.0308,16l-.0606.2422A10.6543,10.6543,0,0,1,16,24Z"}),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("path",{fill:"none",d:"M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"}),React.createElement("path",{fill:"none",d:"M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"}),props.children);});var AccessibilityColorFilled20=/*#__PURE__*/React.forwardRef(function AccessibilityColorFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,10a8.5975,8.5975,0,0,0-7.9648,6A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10Zm0,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Z"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,22a10.6543,10.6543,0,0,1-9.97-7.7578L5.9692,16l.0606-.2422A10.6543,10.6543,0,0,1,16,8a10.6543,10.6543,0,0,1,9.97,7.7578L26.0308,16l-.0606.2422A10.6543,10.6543,0,0,1,16,24Z"}),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("path",{fill:"none",d:"M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"}),React.createElement("path",{fill:"none",d:"M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"}),props.children);});var AccessibilityColorFilled16=/*#__PURE__*/React.forwardRef(function AccessibilityColorFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,10a8.5975,8.5975,0,0,0-7.9648,6A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10Zm0,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Z"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,22a10.6543,10.6543,0,0,1-9.97-7.7578L5.9692,16l.0606-.2422A10.6543,10.6543,0,0,1,16,8a10.6543,10.6543,0,0,1,9.97,7.7578L26.0308,16l-.0606.2422A10.6543,10.6543,0,0,1,16,24Z"}),React.createElement("circle",{cx:"16",cy:"16",r:"2"}),React.createElement("path",{fill:"none",d:"M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"}),React.createElement("path",{fill:"none",d:"M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"}),props.children);});var AccessibilityColor32=/*#__PURE__*/React.forwardRef(function AccessibilityColor32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"}),React.createElement("path",{d:"M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"}),React.createElement("path",{d:"M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"}),props.children);});var AccessibilityColor24=/*#__PURE__*/React.forwardRef(function AccessibilityColor24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"}),React.createElement("path",{d:"M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"}),React.createElement("path",{d:"M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"}),props.children);});var AccessibilityColor20=/*#__PURE__*/React.forwardRef(function AccessibilityColor20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"}),React.createElement("path",{d:"M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"}),React.createElement("path",{d:"M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"}),props.children);});var AccessibilityColor16=/*#__PURE__*/React.forwardRef(function AccessibilityColor16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,20a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,16,20Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,16,14Z"}),React.createElement("path",{d:"M16,24a10.6547,10.6547,0,0,1-9.97-7.7576L5.9692,16l.0606-.2424A10.6547,10.6547,0,0,1,16,8a10.6547,10.6547,0,0,1,9.97,7.7576L26.0308,16l-.0606.2424A10.6547,10.6547,0,0,1,16,24ZM8.0352,16A8.5975,8.5975,0,0,0,16,22a8.5975,8.5975,0,0,0,7.9648-6A8.5975,8.5975,0,0,0,16,10,8.5975,8.5975,0,0,0,8.0352,16Z"}),React.createElement("path",{d:"M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"}),props.children);});var Accessibility32=/*#__PURE__*/React.forwardRef(function Accessibility32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.55,26.11,26.5,27.63,23.66,21H15a2,2,0,0,1-2-2V13a2,2,0,0,1,4,0v4h7V15H19V13a4,4,0,0,0-8,0v1a9,9,0,1,0,8.77,11H17.71A7,7,0,1,1,11,16v3a4,4,0,0,0,4,4h7.34l3.16,7.37,4.95-2.48Z"}),React.createElement("path",{d:"M15.5,8A3.5,3.5,0,1,1,19,4.5,3.5,3.5,0,0,1,15.5,8Zm0-5A1.5,1.5,0,1,0,17,4.5,1.5,1.5,0,0,0,15.5,3Z"}),props.children);});var Accessibility24=/*#__PURE__*/React.forwardRef(function Accessibility24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.55,26.11,26.5,27.63,23.66,21H15a2,2,0,0,1-2-2V13a2,2,0,0,1,4,0v4h7V15H19V13a4,4,0,0,0-8,0v1a9,9,0,1,0,8.77,11H17.71A7,7,0,1,1,11,16v3a4,4,0,0,0,4,4h7.34l3.16,7.37,4.95-2.48Z"}),React.createElement("path",{d:"M15.5,8A3.5,3.5,0,1,1,19,4.5,3.5,3.5,0,0,1,15.5,8Zm0-5A1.5,1.5,0,1,0,17,4.5,1.5,1.5,0,0,0,15.5,3Z"}),props.children);});var Accessibility20=/*#__PURE__*/React.forwardRef(function Accessibility20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.55,26.11,26.5,27.63,23.66,21H15a2,2,0,0,1-2-2V13a2,2,0,0,1,4,0v4h7V15H19V13a4,4,0,0,0-8,0v1a9,9,0,1,0,8.77,11H17.71A7,7,0,1,1,11,16v3a4,4,0,0,0,4,4h7.34l3.16,7.37,4.95-2.48Z"}),React.createElement("path",{d:"M15.5,8A3.5,3.5,0,1,1,19,4.5,3.5,3.5,0,0,1,15.5,8Zm0-5A1.5,1.5,0,1,0,17,4.5,1.5,1.5,0,0,0,15.5,3Z"}),props.children);});var Accessibility16=/*#__PURE__*/React.forwardRef(function Accessibility16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.55,26.11,26.5,27.63,23.66,21H15a2,2,0,0,1-2-2V13a2,2,0,0,1,4,0v4h7V15H19V13a4,4,0,0,0-8,0v1a9,9,0,1,0,8.77,11H17.71A7,7,0,1,1,11,16v3a4,4,0,0,0,4,4h7.34l3.16,7.37,4.95-2.48Z"}),React.createElement("path",{d:"M15.5,8A3.5,3.5,0,1,1,19,4.5,3.5,3.5,0,0,1,15.5,8Zm0-5A1.5,1.5,0,1,0,17,4.5,1.5,1.5,0,0,0,15.5,3Z"}),props.children);});var Account32=/*#__PURE__*/React.forwardRef(function Account32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,14H19v2H8Zm0,5H21v2H8Z"}),React.createElement("path",{d:"M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,2V8H4V6ZM4,26V10H28V26Z"}),props.children);});var Account24=/*#__PURE__*/React.forwardRef(function Account24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,14H19v2H8Zm0,5H21v2H8Z"}),React.createElement("path",{d:"M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,2V8H4V6ZM4,26V10H28V26Z"}),props.children);});var Account20=/*#__PURE__*/React.forwardRef(function Account20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,14H19v2H8Zm0,5H21v2H8Z"}),React.createElement("path",{d:"M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,2V8H4V6ZM4,26V10H28V26Z"}),props.children);});var Account16=/*#__PURE__*/React.forwardRef(function Account16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,14H19v2H8Zm0,5H21v2H8Z"}),React.createElement("path",{d:"M28,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Zm0,2V8H4V6ZM4,26V10H28V26Z"}),props.children);});var Activity32=/*#__PURE__*/React.forwardRef(function Activity32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,29a1,1,0,0,1-.92-.62L6.33,17H2V15H7a1,1,0,0,1,.92.62L12,25.28,20.06,3.65A1,1,0,0,1,21,3a1,1,0,0,1,.93.68L25.72,15H30v2H25a1,1,0,0,1-.95-.68L21,7,12.94,28.35A1,1,0,0,1,12,29Z"}),props.children);});var Activity24=/*#__PURE__*/React.forwardRef(function Activity24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,29a1,1,0,0,1-.92-.62L6.33,17H2V15H7a1,1,0,0,1,.92.62L12,25.28,20.06,3.65A1,1,0,0,1,21,3a1,1,0,0,1,.93.68L25.72,15H30v2H25a1,1,0,0,1-.95-.68L21,7,12.94,28.35A1,1,0,0,1,12,29Z"}),props.children);});var Activity20=/*#__PURE__*/React.forwardRef(function Activity20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,29a1,1,0,0,1-.92-.62L6.33,17H2V15H7a1,1,0,0,1,.92.62L12,25.28,20.06,3.65A1,1,0,0,1,21,3a1,1,0,0,1,.93.68L25.72,15H30v2H25a1,1,0,0,1-.95-.68L21,7,12.94,28.35A1,1,0,0,1,12,29Z"}),props.children);});var Activity16=/*#__PURE__*/React.forwardRef(function Activity16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,29a1,1,0,0,1-.92-.62L6.33,17H2V15H7a1,1,0,0,1,.92.62L12,25.28,20.06,3.65A1,1,0,0,1,21,3a1,1,0,0,1,.93.68L25.72,15H30v2H25a1,1,0,0,1-.95-.68L21,7,12.94,28.35A1,1,0,0,1,12,29Z"}),props.children);});var AddAlt32=/*#__PURE__*/React.forwardRef(function AddAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,4c6.6,0,12,5.4,12,12s-5.4,12-12,12S4,22.6,4,16S9.4,4,16,4 M16,2C8.3,2,2,8.3,2,16s6.3,14,14,14s14-6.3,14-14\tS23.7,2,16,2z"}),React.createElement("polygon",{points:"24,15 17,15 17,8 15,8 15,15 8,15 8,17 15,17 15,24 17,24 17,17 24,17"}),props.children);});var AddAlt24=/*#__PURE__*/React.forwardRef(function AddAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,4c6.6,0,12,5.4,12,12s-5.4,12-12,12S4,22.6,4,16S9.4,4,16,4 M16,2C8.3,2,2,8.3,2,16s6.3,14,14,14s14-6.3,14-14\tS23.7,2,16,2z"}),React.createElement("polygon",{points:"24,15 17,15 17,8 15,8 15,15 8,15 8,17 15,17 15,24 17,24 17,17 24,17"}),props.children);});var AddAlt20=/*#__PURE__*/React.forwardRef(function AddAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,4c6.6,0,12,5.4,12,12s-5.4,12-12,12S4,22.6,4,16S9.4,4,16,4 M16,2C8.3,2,2,8.3,2,16s6.3,14,14,14s14-6.3,14-14\tS23.7,2,16,2z"}),React.createElement("polygon",{points:"24,15 17,15 17,8 15,8 15,15 8,15 8,17 15,17 15,24 17,24 17,17 24,17"}),props.children);});var AddAlt16=/*#__PURE__*/React.forwardRef(function AddAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,4c6.6,0,12,5.4,12,12s-5.4,12-12,12S4,22.6,4,16S9.4,4,16,4 M16,2C8.3,2,2,8.3,2,16s6.3,14,14,14s14-6.3,14-14\tS23.7,2,16,2z"}),React.createElement("polygon",{points:"24,15 17,15 17,8 15,8 15,15 8,15 8,17 15,17 15,24 17,24 17,17 24,17"}),props.children);});var AddFilled32=/*#__PURE__*/React.forwardRef(function AddFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.4,2,2,8.4,2,16s6.4,14,14,14s14-6.4,14-14S23.6,2,16,2z M24,17h-7v7h-2v-7H8v-2h7V8h2v7h7V17z"}),React.createElement("polygon",{fill:"none",points:"24,17 17,17 17,24 15,24 15,17 8,17 8,15 15,15 15,8 17,8 17,15 24,15","data-icon-path":"inner-path"}),props.children);});var AddFilled24=/*#__PURE__*/React.forwardRef(function AddFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.4,2,2,8.4,2,16s6.4,14,14,14s14-6.4,14-14S23.6,2,16,2z M24,17h-7v7h-2v-7H8v-2h7V8h2v7h7V17z"}),React.createElement("polygon",{fill:"none",points:"24,17 17,17 17,24 15,24 15,17 8,17 8,15 15,15 15,8 17,8 17,15 24,15","data-icon-path":"inner-path"}),props.children);});var AddFilled20=/*#__PURE__*/React.forwardRef(function AddFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.4,2,2,8.4,2,16s6.4,14,14,14s14-6.4,14-14S23.6,2,16,2z M24,17h-7v7h-2v-7H8v-2h7V8h2v7h7V17z"}),React.createElement("polygon",{fill:"none",points:"24,17 17,17 17,24 15,24 15,17 8,17 8,15 15,15 15,8 17,8 17,15 24,15","data-icon-path":"inner-path"}),props.children);});var AddFilled16=/*#__PURE__*/React.forwardRef(function AddFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.4,2,2,8.4,2,16s6.4,14,14,14s14-6.4,14-14S23.6,2,16,2z M24,17h-7v7h-2v-7H8v-2h7V8h2v7h7V17z"}),React.createElement("polygon",{fill:"none",points:"24,17 17,17 17,24 15,24 15,17 8,17 8,15 15,15 15,8 17,8 17,15 24,15","data-icon-path":"inner-path"}),props.children);});var AddComment32=/*#__PURE__*/React.forwardRef(function AddComment32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"}),React.createElement("polygon",{points:"17 9 15 9 15 13 11 13 11 15 15 15 15 19 17 19 17 15 21 15 21 13 17 13 17 9"}),props.children);});var AddComment24=/*#__PURE__*/React.forwardRef(function AddComment24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"}),React.createElement("polygon",{points:"17 9 15 9 15 13 11 13 11 15 15 15 15 19 17 19 17 15 21 15 21 13 17 13 17 9"}),props.children);});var AddComment20=/*#__PURE__*/React.forwardRef(function AddComment20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"}),React.createElement("polygon",{points:"17 9 15 9 15 13 11 13 11 15 15 15 15 19 17 19 17 15 21 15 21 13 17 13 17 9"}),props.children);});var AddComment16=/*#__PURE__*/React.forwardRef(function AddComment16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"}),React.createElement("polygon",{points:"17 9 15 9 15 13 11 13 11 15 15 15 15 19 17 19 17 15 21 15 21 13 17 13 17 9"}),props.children);});var Add32=/*#__PURE__*/React.forwardRef(function Add32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"17,15 17,8 15,8 15,15 8,15 8,17 15,17 15,24 17,24 17,17 24,17 24,15"}),props.children);});var Add24=/*#__PURE__*/React.forwardRef(function Add24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"17,15 17,8 15,8 15,15 8,15 8,17 15,17 15,24 17,24 17,17 24,17 24,15"}),props.children);});var Add20=/*#__PURE__*/React.forwardRef(function Add20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"17,15 17,8 15,8 15,15 8,15 8,17 15,17 15,24 17,24 17,17 24,17 24,15"}),props.children);});var Add16=/*#__PURE__*/React.forwardRef(function Add16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"17,15 17,8 15,8 15,15 8,15 8,17 15,17 15,24 17,24 17,17 24,17 24,15"}),props.children);});var AlarmAdd32=/*#__PURE__*/React.forwardRef(function AlarmAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"}),React.createElement("rect",{width:"5.07",height:"2",x:"3.96",y:"5.5",transform:"rotate(-45.06 6.502 6.497)"}),React.createElement("rect",{width:"2",height:"5.07",x:"24.5",y:"3.96",transform:"rotate(-44.94 25.5 6.498)"}),React.createElement("polygon",{points:"21 16 17 16 17 12 15 12 15 16 11 16 11 18 15 18 15 22 17 22 17 18 21 18 21 16"}),props.children);});var AlarmAdd24=/*#__PURE__*/React.forwardRef(function AlarmAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"}),React.createElement("rect",{width:"5.07",height:"2",x:"3.96",y:"5.5",transform:"rotate(-45.06 6.502 6.497)"}),React.createElement("rect",{width:"2",height:"5.07",x:"24.5",y:"3.96",transform:"rotate(-44.94 25.5 6.498)"}),React.createElement("polygon",{points:"21 16 17 16 17 12 15 12 15 16 11 16 11 18 15 18 15 22 17 22 17 18 21 18 21 16"}),props.children);});var AlarmAdd20=/*#__PURE__*/React.forwardRef(function AlarmAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"}),React.createElement("rect",{width:"5.07",height:"2",x:"3.96",y:"5.5",transform:"rotate(-45.06 6.502 6.497)"}),React.createElement("rect",{width:"2",height:"5.07",x:"24.5",y:"3.96",transform:"rotate(-44.94 25.5 6.498)"}),React.createElement("polygon",{points:"21 16 17 16 17 12 15 12 15 16 11 16 11 18 15 18 15 22 17 22 17 18 21 18 21 16"}),props.children);});var AlarmAdd16=/*#__PURE__*/React.forwardRef(function AlarmAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"}),React.createElement("rect",{width:"5.07",height:"2",x:"3.96",y:"5.5",transform:"rotate(-45.06 6.502 6.497)"}),React.createElement("rect",{width:"2",height:"5.07",x:"24.5",y:"3.96",transform:"rotate(-44.94 25.5 6.498)"}),React.createElement("polygon",{points:"21 16 17 16 17 12 15 12 15 16 11 16 11 18 15 18 15 22 17 22 17 18 21 18 21 16"}),props.children);});var AlarmSubtract32=/*#__PURE__*/React.forwardRef(function AlarmSubtract32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"}),React.createElement("rect",{width:"5.07",height:"2",x:"3.96",y:"5.5",transform:"rotate(-45.06 6.502 6.497)"}),React.createElement("rect",{width:"2",height:"5.07",x:"24.5",y:"3.96",transform:"rotate(-44.94 25.5 6.498)"}),React.createElement("rect",{width:"10",height:"2",x:"11",y:"16"}),props.children);});var AlarmSubtract24=/*#__PURE__*/React.forwardRef(function AlarmSubtract24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"}),React.createElement("rect",{width:"5.07",height:"2",x:"3.96",y:"5.5",transform:"rotate(-45.06 6.502 6.497)"}),React.createElement("rect",{width:"2",height:"5.07",x:"24.5",y:"3.96",transform:"rotate(-44.94 25.5 6.498)"}),React.createElement("rect",{width:"10",height:"2",x:"11",y:"16"}),props.children);});var AlarmSubtract20=/*#__PURE__*/React.forwardRef(function AlarmSubtract20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"}),React.createElement("rect",{width:"5.07",height:"2",x:"3.96",y:"5.5",transform:"rotate(-45.06 6.502 6.497)"}),React.createElement("rect",{width:"2",height:"5.07",x:"24.5",y:"3.96",transform:"rotate(-44.94 25.5 6.498)"}),React.createElement("rect",{width:"10",height:"2",x:"11",y:"16"}),props.children);});var AlarmSubtract16=/*#__PURE__*/React.forwardRef(function AlarmSubtract16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"}),React.createElement("rect",{width:"5.07",height:"2",x:"3.96",y:"5.5",transform:"rotate(-45.06 6.502 6.497)"}),React.createElement("rect",{width:"2",height:"5.07",x:"24.5",y:"3.96",transform:"rotate(-44.94 25.5 6.498)"}),React.createElement("rect",{width:"10",height:"2",x:"11",y:"16"}),props.children);});var Alarm32=/*#__PURE__*/React.forwardRef(function Alarm32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"}),React.createElement("polygon",{points:"18.59 21 15 17.41 15 11 17 11 17 16.58 20 19.59 18.59 21"}),React.createElement("rect",{width:"5.07",height:"2",x:"3.96",y:"5.5",transform:"rotate(-45.06 6.502 6.497)"}),React.createElement("rect",{width:"2",height:"5.07",x:"24.5",y:"3.96",transform:"rotate(-44.94 25.5 6.498)"}),props.children);});var Alarm24=/*#__PURE__*/React.forwardRef(function Alarm24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"}),React.createElement("polygon",{points:"18.59 21 15 17.41 15 11 17 11 17 16.58 20 19.59 18.59 21"}),React.createElement("rect",{width:"5.07",height:"2",x:"3.96",y:"5.5",transform:"rotate(-45.06 6.502 6.497)"}),React.createElement("rect",{width:"2",height:"5.07",x:"24.5",y:"3.96",transform:"rotate(-44.94 25.5 6.498)"}),props.children);});var Alarm20=/*#__PURE__*/React.forwardRef(function Alarm20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"}),React.createElement("polygon",{points:"18.59 21 15 17.41 15 11 17 11 17 16.58 20 19.59 18.59 21"}),React.createElement("rect",{width:"5.07",height:"2",x:"3.96",y:"5.5",transform:"rotate(-45.06 6.502 6.497)"}),React.createElement("rect",{width:"2",height:"5.07",x:"24.5",y:"3.96",transform:"rotate(-44.94 25.5 6.498)"}),props.children);});var Alarm16=/*#__PURE__*/React.forwardRef(function Alarm16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,28A11,11,0,1,1,27,17,11,11,0,0,1,16,28ZM16,8a9,9,0,1,0,9,9A9,9,0,0,0,16,8Z"}),React.createElement("polygon",{points:"18.59 21 15 17.41 15 11 17 11 17 16.58 20 19.59 18.59 21"}),React.createElement("rect",{width:"5.07",height:"2",x:"3.96",y:"5.5",transform:"rotate(-45.06 6.502 6.497)"}),React.createElement("rect",{width:"2",height:"5.07",x:"24.5",y:"3.96",transform:"rotate(-44.94 25.5 6.498)"}),props.children);});var AlignHorizontalCenter32=/*#__PURE__*/React.forwardRef(function AlignHorizontalCenter32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,18H17V14h3a2.0025,2.0025,0,0,0,2-2V8a2.0025,2.0025,0,0,0-2-2H17V2H15V6H12a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h3v4H8a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h7v4h2V26h7a2.0025,2.0025,0,0,0,2-2V20A2.0025,2.0025,0,0,0,24,18ZM12,8h8v4H12ZM24,24H8V20H24Z"}),props.children);});var AlignHorizontalCenter24=/*#__PURE__*/React.forwardRef(function AlignHorizontalCenter24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,18H17V14h3a2.0025,2.0025,0,0,0,2-2V8a2.0025,2.0025,0,0,0-2-2H17V2H15V6H12a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h3v4H8a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h7v4h2V26h7a2.0025,2.0025,0,0,0,2-2V20A2.0025,2.0025,0,0,0,24,18ZM12,8h8v4H12ZM24,24H8V20H24Z"}),props.children);});var AlignHorizontalCenter20=/*#__PURE__*/React.forwardRef(function AlignHorizontalCenter20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,18H17V14h3a2.0025,2.0025,0,0,0,2-2V8a2.0025,2.0025,0,0,0-2-2H17V2H15V6H12a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h3v4H8a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h7v4h2V26h7a2.0025,2.0025,0,0,0,2-2V20A2.0025,2.0025,0,0,0,24,18ZM12,8h8v4H12ZM24,24H8V20H24Z"}),props.children);});var AlignHorizontalCenter16=/*#__PURE__*/React.forwardRef(function AlignHorizontalCenter16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,18H17V14h3a2.0025,2.0025,0,0,0,2-2V8a2.0025,2.0025,0,0,0-2-2H17V2H15V6H12a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h3v4H8a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2h7v4h2V26h7a2.0025,2.0025,0,0,0,2-2V20A2.0025,2.0025,0,0,0,24,18ZM12,8h8v4H12ZM24,24H8V20H24Z"}),props.children);});var AlignHorizontalLeft32=/*#__PURE__*/React.forwardRef(function AlignHorizontalLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,26H11a2.0023,2.0023,0,0,1-2-2V20a2.0023,2.0023,0,0,1,2-2H26a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,26,26Zm0-6.0012L11,20v4H26Z"}),React.createElement("path",{d:"M18,14H11a2.0023,2.0023,0,0,1-2-2V8a2.0023,2.0023,0,0,1,2-2h7a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,18,14Zm0-6.0012L11,8v4h7Z"}),React.createElement("rect",{width:"2",height:"28",x:"4",y:"2"}),props.children);});var AlignHorizontalLeft24=/*#__PURE__*/React.forwardRef(function AlignHorizontalLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,26H11a2.0023,2.0023,0,0,1-2-2V20a2.0023,2.0023,0,0,1,2-2H26a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,26,26Zm0-6.0012L11,20v4H26Z"}),React.createElement("path",{d:"M18,14H11a2.0023,2.0023,0,0,1-2-2V8a2.0023,2.0023,0,0,1,2-2h7a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,18,14Zm0-6.0012L11,8v4h7Z"}),React.createElement("rect",{width:"2",height:"28",x:"4",y:"2"}),props.children);});var AlignHorizontalLeft20=/*#__PURE__*/React.forwardRef(function AlignHorizontalLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,26H11a2.0023,2.0023,0,0,1-2-2V20a2.0023,2.0023,0,0,1,2-2H26a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,26,26Zm0-6.0012L11,20v4H26Z"}),React.createElement("path",{d:"M18,14H11a2.0023,2.0023,0,0,1-2-2V8a2.0023,2.0023,0,0,1,2-2h7a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,18,14Zm0-6.0012L11,8v4h7Z"}),React.createElement("rect",{width:"2",height:"28",x:"4",y:"2"}),props.children);});var AlignHorizontalLeft16=/*#__PURE__*/React.forwardRef(function AlignHorizontalLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,26H11a2.0023,2.0023,0,0,1-2-2V20a2.0023,2.0023,0,0,1,2-2H26a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,26,26Zm0-6.0012L11,20v4H26Z"}),React.createElement("path",{d:"M18,14H11a2.0023,2.0023,0,0,1-2-2V8a2.0023,2.0023,0,0,1,2-2h7a2.0023,2.0023,0,0,1,2,2v4A2.0023,2.0023,0,0,1,18,14Zm0-6.0012L11,8v4h7Z"}),React.createElement("rect",{width:"2",height:"28",x:"4",y:"2"}),props.children);});var AlignHorizontalRight32=/*#__PURE__*/React.forwardRef(function AlignHorizontalRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4,24V20a2.0023,2.0023,0,0,1,2-2H21a2.0023,2.0023,0,0,1,2,2v4a2.0023,2.0023,0,0,1-2,2H6A2.0023,2.0023,0,0,1,4,24Zm2,0H21V20L6,19.9988Z"}),React.createElement("path",{d:"M12,12V8a2.0023,2.0023,0,0,1,2-2h7a2.0023,2.0023,0,0,1,2,2v4a2.0023,2.0023,0,0,1-2,2H14A2.0023,2.0023,0,0,1,12,12Zm2,0h7V8l-7-.0012Z"}),React.createElement("rect",{width:"2",height:"28",x:"26",y:"2",transform:"rotate(-180 27 16)"}),props.children);});var AlignHorizontalRight24=/*#__PURE__*/React.forwardRef(function AlignHorizontalRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4,24V20a2.0023,2.0023,0,0,1,2-2H21a2.0023,2.0023,0,0,1,2,2v4a2.0023,2.0023,0,0,1-2,2H6A2.0023,2.0023,0,0,1,4,24Zm2,0H21V20L6,19.9988Z"}),React.createElement("path",{d:"M12,12V8a2.0023,2.0023,0,0,1,2-2h7a2.0023,2.0023,0,0,1,2,2v4a2.0023,2.0023,0,0,1-2,2H14A2.0023,2.0023,0,0,1,12,12Zm2,0h7V8l-7-.0012Z"}),React.createElement("rect",{width:"2",height:"28",x:"26",y:"2",transform:"rotate(-180 27 16)"}),props.children);});var AlignHorizontalRight20=/*#__PURE__*/React.forwardRef(function AlignHorizontalRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4,24V20a2.0023,2.0023,0,0,1,2-2H21a2.0023,2.0023,0,0,1,2,2v4a2.0023,2.0023,0,0,1-2,2H6A2.0023,2.0023,0,0,1,4,24Zm2,0H21V20L6,19.9988Z"}),React.createElement("path",{d:"M12,12V8a2.0023,2.0023,0,0,1,2-2h7a2.0023,2.0023,0,0,1,2,2v4a2.0023,2.0023,0,0,1-2,2H14A2.0023,2.0023,0,0,1,12,12Zm2,0h7V8l-7-.0012Z"}),React.createElement("rect",{width:"2",height:"28",x:"26",y:"2",transform:"rotate(-180 27 16)"}),props.children);});var AlignHorizontalRight16=/*#__PURE__*/React.forwardRef(function AlignHorizontalRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4,24V20a2.0023,2.0023,0,0,1,2-2H21a2.0023,2.0023,0,0,1,2,2v4a2.0023,2.0023,0,0,1-2,2H6A2.0023,2.0023,0,0,1,4,24Zm2,0H21V20L6,19.9988Z"}),React.createElement("path",{d:"M12,12V8a2.0023,2.0023,0,0,1,2-2h7a2.0023,2.0023,0,0,1,2,2v4a2.0023,2.0023,0,0,1-2,2H14A2.0023,2.0023,0,0,1,12,12Zm2,0h7V8l-7-.0012Z"}),React.createElement("rect",{width:"2",height:"28",x:"26",y:"2",transform:"rotate(-180 27 16)"}),props.children);});var AlignVerticalBottom32=/*#__PURE__*/React.forwardRef(function AlignVerticalBottom32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"26"}),React.createElement("path",{d:"M24,23H20a2.0023,2.0023,0,0,1-2-2V14a2.0023,2.0023,0,0,1,2-2h4a2.0023,2.0023,0,0,1,2,2v7A2.0023,2.0023,0,0,1,24,23Zm-4-9v7h4.0012L24,14Z"}),React.createElement("path",{d:"M12,23H8a2.0023,2.0023,0,0,1-2-2V6A2.0023,2.0023,0,0,1,8,4h4a2.0023,2.0023,0,0,1,2,2V21A2.0023,2.0023,0,0,1,12,23ZM8,6V21h4.0012L12,6Z"}),props.children);});var AlignVerticalBottom24=/*#__PURE__*/React.forwardRef(function AlignVerticalBottom24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"26"}),React.createElement("path",{d:"M24,23H20a2.0023,2.0023,0,0,1-2-2V14a2.0023,2.0023,0,0,1,2-2h4a2.0023,2.0023,0,0,1,2,2v7A2.0023,2.0023,0,0,1,24,23Zm-4-9v7h4.0012L24,14Z"}),React.createElement("path",{d:"M12,23H8a2.0023,2.0023,0,0,1-2-2V6A2.0023,2.0023,0,0,1,8,4h4a2.0023,2.0023,0,0,1,2,2V21A2.0023,2.0023,0,0,1,12,23ZM8,6V21h4.0012L12,6Z"}),props.children);});var AlignVerticalBottom20=/*#__PURE__*/React.forwardRef(function AlignVerticalBottom20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"26"}),React.createElement("path",{d:"M24,23H20a2.0023,2.0023,0,0,1-2-2V14a2.0023,2.0023,0,0,1,2-2h4a2.0023,2.0023,0,0,1,2,2v7A2.0023,2.0023,0,0,1,24,23Zm-4-9v7h4.0012L24,14Z"}),React.createElement("path",{d:"M12,23H8a2.0023,2.0023,0,0,1-2-2V6A2.0023,2.0023,0,0,1,8,4h4a2.0023,2.0023,0,0,1,2,2V21A2.0023,2.0023,0,0,1,12,23ZM8,6V21h4.0012L12,6Z"}),props.children);});var AlignVerticalBottom16=/*#__PURE__*/React.forwardRef(function AlignVerticalBottom16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"26"}),React.createElement("path",{d:"M24,23H20a2.0023,2.0023,0,0,1-2-2V14a2.0023,2.0023,0,0,1,2-2h4a2.0023,2.0023,0,0,1,2,2v7A2.0023,2.0023,0,0,1,24,23Zm-4-9v7h4.0012L24,14Z"}),React.createElement("path",{d:"M12,23H8a2.0023,2.0023,0,0,1-2-2V6A2.0023,2.0023,0,0,1,8,4h4a2.0023,2.0023,0,0,1,2,2V21A2.0023,2.0023,0,0,1,12,23ZM8,6V21h4.0012L12,6Z"}),props.children);});var AlignVerticalCenter32=/*#__PURE__*/React.forwardRef(function AlignVerticalCenter32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15H26V12a2.0025,2.0025,0,0,0-2-2H20a2.0025,2.0025,0,0,0-2,2v3H14V8a2.0025,2.0025,0,0,0-2-2H8A2.0025,2.0025,0,0,0,6,8v7H2v2H6v7a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4v3a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4ZM8,24V8h4l.0012,16Zm12-4V12h4l.0012,8Z"}),props.children);});var AlignVerticalCenter24=/*#__PURE__*/React.forwardRef(function AlignVerticalCenter24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15H26V12a2.0025,2.0025,0,0,0-2-2H20a2.0025,2.0025,0,0,0-2,2v3H14V8a2.0025,2.0025,0,0,0-2-2H8A2.0025,2.0025,0,0,0,6,8v7H2v2H6v7a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4v3a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4ZM8,24V8h4l.0012,16Zm12-4V12h4l.0012,8Z"}),props.children);});var AlignVerticalCenter20=/*#__PURE__*/React.forwardRef(function AlignVerticalCenter20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15H26V12a2.0025,2.0025,0,0,0-2-2H20a2.0025,2.0025,0,0,0-2,2v3H14V8a2.0025,2.0025,0,0,0-2-2H8A2.0025,2.0025,0,0,0,6,8v7H2v2H6v7a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4v3a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4ZM8,24V8h4l.0012,16Zm12-4V12h4l.0012,8Z"}),props.children);});var AlignVerticalCenter16=/*#__PURE__*/React.forwardRef(function AlignVerticalCenter16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15H26V12a2.0025,2.0025,0,0,0-2-2H20a2.0025,2.0025,0,0,0-2,2v3H14V8a2.0025,2.0025,0,0,0-2-2H8A2.0025,2.0025,0,0,0,6,8v7H2v2H6v7a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4v3a2.0025,2.0025,0,0,0,2,2h4a2.0025,2.0025,0,0,0,2-2V17h4ZM8,24V8h4l.0012,16Zm12-4V12h4l.0012,8Z"}),props.children);});var AlignVerticalTop32=/*#__PURE__*/React.forwardRef(function AlignVerticalTop32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,20H20a2.0023,2.0023,0,0,1-2-2V11a2.0023,2.0023,0,0,1,2-2h4a2.0023,2.0023,0,0,1,2,2v7A2.0023,2.0023,0,0,1,24,20Zm-4-9v7h4.0012L24,11Z"}),React.createElement("path",{d:"M12,28H8a2.0023,2.0023,0,0,1-2-2V11A2.0023,2.0023,0,0,1,8,9h4a2.0023,2.0023,0,0,1,2,2V26A2.0023,2.0023,0,0,1,12,28ZM8,11V26h4.0012L12,11Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"4"}),props.children);});var AlignVerticalTop24=/*#__PURE__*/React.forwardRef(function AlignVerticalTop24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,20H20a2.0023,2.0023,0,0,1-2-2V11a2.0023,2.0023,0,0,1,2-2h4a2.0023,2.0023,0,0,1,2,2v7A2.0023,2.0023,0,0,1,24,20Zm-4-9v7h4.0012L24,11Z"}),React.createElement("path",{d:"M12,28H8a2.0023,2.0023,0,0,1-2-2V11A2.0023,2.0023,0,0,1,8,9h4a2.0023,2.0023,0,0,1,2,2V26A2.0023,2.0023,0,0,1,12,28ZM8,11V26h4.0012L12,11Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"4"}),props.children);});var AlignVerticalTop20=/*#__PURE__*/React.forwardRef(function AlignVerticalTop20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,20H20a2.0023,2.0023,0,0,1-2-2V11a2.0023,2.0023,0,0,1,2-2h4a2.0023,2.0023,0,0,1,2,2v7A2.0023,2.0023,0,0,1,24,20Zm-4-9v7h4.0012L24,11Z"}),React.createElement("path",{d:"M12,28H8a2.0023,2.0023,0,0,1-2-2V11A2.0023,2.0023,0,0,1,8,9h4a2.0023,2.0023,0,0,1,2,2V26A2.0023,2.0023,0,0,1,12,28ZM8,11V26h4.0012L12,11Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"4"}),props.children);});var AlignVerticalTop16=/*#__PURE__*/React.forwardRef(function AlignVerticalTop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,20H20a2.0023,2.0023,0,0,1-2-2V11a2.0023,2.0023,0,0,1,2-2h4a2.0023,2.0023,0,0,1,2,2v7A2.0023,2.0023,0,0,1,24,20Zm-4-9v7h4.0012L24,11Z"}),React.createElement("path",{d:"M12,28H8a2.0023,2.0023,0,0,1-2-2V11A2.0023,2.0023,0,0,1,8,9h4a2.0023,2.0023,0,0,1,2,2V26A2.0023,2.0023,0,0,1,12,28ZM8,11V26h4.0012L12,11Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"4"}),props.children);});var Analytics32=/*#__PURE__*/React.forwardRef(function Analytics32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4,2H2V28a2,2,0,0,0,2,2H30V28H4Z"}),React.createElement("path",{d:"M30,9H23v2h3.59L19,18.59l-4.29-4.3a1,1,0,0,0-1.42,0L6,21.59,7.41,23,14,16.41l4.29,4.3a1,1,0,0,0,1.42,0L28,12.41V16h2Z"}),props.children);});var Analytics24=/*#__PURE__*/React.forwardRef(function Analytics24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4,2H2V28a2,2,0,0,0,2,2H30V28H4Z"}),React.createElement("path",{d:"M30,9H23v2h3.59L19,18.59l-4.29-4.3a1,1,0,0,0-1.42,0L6,21.59,7.41,23,14,16.41l4.29,4.3a1,1,0,0,0,1.42,0L28,12.41V16h2Z"}),props.children);});var Analytics20=/*#__PURE__*/React.forwardRef(function Analytics20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4,2H2V28a2,2,0,0,0,2,2H30V28H4Z"}),React.createElement("path",{d:"M30,9H23v2h3.59L19,18.59l-4.29-4.3a1,1,0,0,0-1.42,0L6,21.59,7.41,23,14,16.41l4.29,4.3a1,1,0,0,0,1.42,0L28,12.41V16h2Z"}),props.children);});var Analytics16=/*#__PURE__*/React.forwardRef(function Analytics16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4,2H2V28a2,2,0,0,0,2,2H30V28H4Z"}),React.createElement("path",{d:"M30,9H23v2h3.59L19,18.59l-4.29-4.3a1,1,0,0,0-1.42,0L6,21.59,7.41,23,14,16.41l4.29,4.3a1,1,0,0,0,1.42,0L28,12.41V16h2Z"}),props.children);});var Aperture32=/*#__PURE__*/React.forwardRef(function Aperture32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM27.84,14.14,22,17.52V5.62A12,12,0,0,1,27.84,14.14ZM12,18.68V13.32L16,11l4,2.31v5.36L16,21Zm8-14V11L10.34,5.42A11.9,11.9,0,0,1,20,4.7Zm-11.52,2L14,9.85,4,15.62A12,12,0,0,1,8.48,6.66ZM4.16,17.85,10,14.47V26.38A12,12,0,0,1,4.16,17.85ZM12,27.3V21l9.67,5.58A11.92,11.92,0,0,1,16,28,12.05,12.05,0,0,1,12,27.3Zm11.52-2L18,22.14l10-5.77A12,12,0,0,1,23.52,25.34Z"}),props.children);});var Aperture24=/*#__PURE__*/React.forwardRef(function Aperture24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM27.84,14.14,22,17.52V5.62A12,12,0,0,1,27.84,14.14ZM12,18.68V13.32L16,11l4,2.31v5.36L16,21Zm8-14V11L10.34,5.42A11.9,11.9,0,0,1,20,4.7Zm-11.52,2L14,9.85,4,15.62A12,12,0,0,1,8.48,6.66ZM4.16,17.85,10,14.47V26.38A12,12,0,0,1,4.16,17.85ZM12,27.3V21l9.67,5.58A11.92,11.92,0,0,1,16,28,12.05,12.05,0,0,1,12,27.3Zm11.52-2L18,22.14l10-5.77A12,12,0,0,1,23.52,25.34Z"}),props.children);});var Aperture20=/*#__PURE__*/React.forwardRef(function Aperture20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM27.84,14.14,22,17.52V5.62A12,12,0,0,1,27.84,14.14ZM12,18.68V13.32L16,11l4,2.31v5.36L16,21Zm8-14V11L10.34,5.42A11.9,11.9,0,0,1,20,4.7Zm-11.52,2L14,9.85,4,15.62A12,12,0,0,1,8.48,6.66ZM4.16,17.85,10,14.47V26.38A12,12,0,0,1,4.16,17.85ZM12,27.3V21l9.67,5.58A11.92,11.92,0,0,1,16,28,12.05,12.05,0,0,1,12,27.3Zm11.52-2L18,22.14l10-5.77A12,12,0,0,1,23.52,25.34Z"}),props.children);});var Aperture16=/*#__PURE__*/React.forwardRef(function Aperture16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM27.84,14.14,22,17.52V5.62A12,12,0,0,1,27.84,14.14ZM12,18.68V13.32L16,11l4,2.31v5.36L16,21Zm8-14V11L10.34,5.42A11.9,11.9,0,0,1,20,4.7Zm-11.52,2L14,9.85,4,15.62A12,12,0,0,1,8.48,6.66ZM4.16,17.85,10,14.47V26.38A12,12,0,0,1,4.16,17.85ZM12,27.3V21l9.67,5.58A11.92,11.92,0,0,1,16,28,12.05,12.05,0,0,1,12,27.3Zm11.52-2L18,22.14l10-5.77A12,12,0,0,1,23.52,25.34Z"}),props.children);});var Api32=/*#__PURE__*/React.forwardRef(function Api32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM26,4a2,2,0,1,1-2,2A2,2,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2,2,0,0,1,6,28Zm10-8a4,4,0,1,1,4-4A4,4,0,0,1,16,20Zm10,8a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var Api24=/*#__PURE__*/React.forwardRef(function Api24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM26,4a2,2,0,1,1-2,2A2,2,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2,2,0,0,1,6,28Zm10-8a4,4,0,1,1,4-4A4,4,0,0,1,16,20Zm10,8a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var Api20=/*#__PURE__*/React.forwardRef(function Api20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM26,4a2,2,0,1,1-2,2A2,2,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2,2,0,0,1,6,28Zm10-8a4,4,0,1,1,4-4A4,4,0,0,1,16,20Zm10,8a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var Api16=/*#__PURE__*/React.forwardRef(function Api16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,22a3.86,3.86,0,0,0-2,.57l-3.09-3.1a6,6,0,0,0,0-6.94L24,9.43A3.86,3.86,0,0,0,26,10a4,4,0,1,0-4-4,3.86,3.86,0,0,0,.57,2l-3.1,3.09a6,6,0,0,0-6.94,0L9.43,8A3.86,3.86,0,0,0,10,6a4,4,0,1,0-4,4,3.86,3.86,0,0,0,2-.57l3.09,3.1a6,6,0,0,0,0,6.94L8,22.57A3.86,3.86,0,0,0,6,22a4,4,0,1,0,4,4,3.86,3.86,0,0,0-.57-2l3.1-3.09a6,6,0,0,0,6.94,0L22.57,24A3.86,3.86,0,0,0,22,26a4,4,0,1,0,4-4ZM26,4a2,2,0,1,1-2,2A2,2,0,0,1,26,4ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2,2,0,0,1,6,28Zm10-8a4,4,0,1,1,4-4A4,4,0,0,1,16,20Zm10,8a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var AppSwitcher32=/*#__PURE__*/React.forwardRef(function AppSwitcher32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"4",x:"14",y:"4"}),React.createElement("rect",{width:"4",height:"4",x:"4",y:"4"}),React.createElement("rect",{width:"4",height:"4",x:"24",y:"4"}),React.createElement("rect",{width:"4",height:"4",x:"14",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"4",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"24",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"14",y:"24"}),React.createElement("rect",{width:"4",height:"4",x:"4",y:"24"}),React.createElement("rect",{width:"4",height:"4",x:"24",y:"24"}),props.children);});var AppSwitcher24=/*#__PURE__*/React.forwardRef(function AppSwitcher24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"4",x:"14",y:"4"}),React.createElement("rect",{width:"4",height:"4",x:"4",y:"4"}),React.createElement("rect",{width:"4",height:"4",x:"24",y:"4"}),React.createElement("rect",{width:"4",height:"4",x:"14",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"4",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"24",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"14",y:"24"}),React.createElement("rect",{width:"4",height:"4",x:"4",y:"24"}),React.createElement("rect",{width:"4",height:"4",x:"24",y:"24"}),props.children);});var AppSwitcher20=/*#__PURE__*/React.forwardRef(function AppSwitcher20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"4",x:"14",y:"4"}),React.createElement("rect",{width:"4",height:"4",x:"4",y:"4"}),React.createElement("rect",{width:"4",height:"4",x:"24",y:"4"}),React.createElement("rect",{width:"4",height:"4",x:"14",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"4",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"24",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"14",y:"24"}),React.createElement("rect",{width:"4",height:"4",x:"4",y:"24"}),React.createElement("rect",{width:"4",height:"4",x:"24",y:"24"}),props.children);});var AppSwitcher16=/*#__PURE__*/React.forwardRef(function AppSwitcher16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"4",x:"14",y:"4"}),React.createElement("rect",{width:"4",height:"4",x:"4",y:"4"}),React.createElement("rect",{width:"4",height:"4",x:"24",y:"4"}),React.createElement("rect",{width:"4",height:"4",x:"14",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"4",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"24",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"14",y:"24"}),React.createElement("rect",{width:"4",height:"4",x:"4",y:"24"}),React.createElement("rect",{width:"4",height:"4",x:"24",y:"24"}),props.children);});var App32=/*#__PURE__*/React.forwardRef(function App32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,10H22V24h2V20h4a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,28,10Zm-4,8V12h4v6Z"}),React.createElement("path",{d:"M18,10H12V24h2V20h4a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,18,10Zm-4,8V12h4v6Z"}),React.createElement("path",{d:"M8,10H3v2H8v2H4a2,2,0,0,0-2,2v2a2,2,0,0,0,2,2h6V12A2.0023,2.0023,0,0,0,8,10Zm0,8H4V16H8Z"}),props.children);});var App24=/*#__PURE__*/React.forwardRef(function App24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,10H22V24h2V20h4a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,28,10Zm-4,8V12h4v6Z"}),React.createElement("path",{d:"M18,10H12V24h2V20h4a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,18,10Zm-4,8V12h4v6Z"}),React.createElement("path",{d:"M8,10H3v2H8v2H4a2,2,0,0,0-2,2v2a2,2,0,0,0,2,2h6V12A2.0023,2.0023,0,0,0,8,10Zm0,8H4V16H8Z"}),props.children);});var App20=/*#__PURE__*/React.forwardRef(function App20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,10H22V24h2V20h4a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,28,10Zm-4,8V12h4v6Z"}),React.createElement("path",{d:"M18,10H12V24h2V20h4a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,18,10Zm-4,8V12h4v6Z"}),React.createElement("path",{d:"M8,10H3v2H8v2H4a2,2,0,0,0-2,2v2a2,2,0,0,0,2,2h6V12A2.0023,2.0023,0,0,0,8,10Zm0,8H4V16H8Z"}),props.children);});var App16=/*#__PURE__*/React.forwardRef(function App16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,10H22V24h2V20h4a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,28,10Zm-4,8V12h4v6Z"}),React.createElement("path",{d:"M18,10H12V24h2V20h4a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,18,10Zm-4,8V12h4v6Z"}),React.createElement("path",{d:"M8,10H3v2H8v2H4a2,2,0,0,0-2,2v2a2,2,0,0,0,2,2h6V12A2.0023,2.0023,0,0,0,8,10Zm0,8H4V16H8Z"}),props.children);});var Apple32=/*#__PURE__*/React.forwardRef(function Apple32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.7788,8a11.4843,11.4843,0,0,0-3.0547.5342,14.5665,14.5665,0,0,1-1.8225.4126A6.0054,6.0054,0,0,0,11,4V6a3.9933,3.9933,0,0,1,3.8267,2.9c-.5181-.0879-1.0569-.2207-1.6172-.3648A12.89,12.89,0,0,0,10.0317,8C6.311,8,4,11.0652,4,16c0,7.51,4.0679,11.999,8.0005,12h.0015a7.1576,7.1576,0,0,0,2.49-.59A5.0128,5.0128,0,0,1,16,27a5.0266,5.0266,0,0,1,1.5112.41A7.15,7.15,0,0,0,20,28h0c3.9307-.001,8-4.49,8-12C28,12.3094,26.3706,8,21.7788,8ZM20,26h0a5.5038,5.5038,0,0,1-1.7905-.4639A6.4168,6.4168,0,0,0,16,25a6.4043,6.4043,0,0,0-2.2061.5361A5.5343,5.5343,0,0,1,12,26h.0015C9.0513,25.9988,6,22.2586,6,16c0-1.8037.3931-6,4.0317-6a11.2363,11.2363,0,0,1,2.6807.4726A12.9819,12.9819,0,0,0,15.7612,11h.4922a11.7955,11.7955,0,0,0,2.9956-.5361A9.8483,9.8483,0,0,1,21.7788,10C25.7964,10,26,14.9978,26,16,26,22.2586,22.9482,25.9988,20,26Z"}),React.createElement("path",{d:"M18,7H17V6a2.0021,2.0021,0,0,1,2-2h1V5A2.0021,2.0021,0,0,1,18,7Z"}),props.children);});var Apple24=/*#__PURE__*/React.forwardRef(function Apple24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.7788,8a11.4843,11.4843,0,0,0-3.0547.5342,14.5665,14.5665,0,0,1-1.8225.4126A6.0054,6.0054,0,0,0,11,4V6a3.9933,3.9933,0,0,1,3.8267,2.9c-.5181-.0879-1.0569-.2207-1.6172-.3648A12.89,12.89,0,0,0,10.0317,8C6.311,8,4,11.0652,4,16c0,7.51,4.0679,11.999,8.0005,12h.0015a7.1576,7.1576,0,0,0,2.49-.59A5.0128,5.0128,0,0,1,16,27a5.0266,5.0266,0,0,1,1.5112.41A7.15,7.15,0,0,0,20,28h0c3.9307-.001,8-4.49,8-12C28,12.3094,26.3706,8,21.7788,8ZM20,26h0a5.5038,5.5038,0,0,1-1.7905-.4639A6.4168,6.4168,0,0,0,16,25a6.4043,6.4043,0,0,0-2.2061.5361A5.5343,5.5343,0,0,1,12,26h.0015C9.0513,25.9988,6,22.2586,6,16c0-1.8037.3931-6,4.0317-6a11.2363,11.2363,0,0,1,2.6807.4726A12.9819,12.9819,0,0,0,15.7612,11h.4922a11.7955,11.7955,0,0,0,2.9956-.5361A9.8483,9.8483,0,0,1,21.7788,10C25.7964,10,26,14.9978,26,16,26,22.2586,22.9482,25.9988,20,26Z"}),React.createElement("path",{d:"M18,7H17V6a2.0021,2.0021,0,0,1,2-2h1V5A2.0021,2.0021,0,0,1,18,7Z"}),props.children);});var Apple20=/*#__PURE__*/React.forwardRef(function Apple20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.7788,8a11.4843,11.4843,0,0,0-3.0547.5342,14.5665,14.5665,0,0,1-1.8225.4126A6.0054,6.0054,0,0,0,11,4V6a3.9933,3.9933,0,0,1,3.8267,2.9c-.5181-.0879-1.0569-.2207-1.6172-.3648A12.89,12.89,0,0,0,10.0317,8C6.311,8,4,11.0652,4,16c0,7.51,4.0679,11.999,8.0005,12h.0015a7.1576,7.1576,0,0,0,2.49-.59A5.0128,5.0128,0,0,1,16,27a5.0266,5.0266,0,0,1,1.5112.41A7.15,7.15,0,0,0,20,28h0c3.9307-.001,8-4.49,8-12C28,12.3094,26.3706,8,21.7788,8ZM20,26h0a5.5038,5.5038,0,0,1-1.7905-.4639A6.4168,6.4168,0,0,0,16,25a6.4043,6.4043,0,0,0-2.2061.5361A5.5343,5.5343,0,0,1,12,26h.0015C9.0513,25.9988,6,22.2586,6,16c0-1.8037.3931-6,4.0317-6a11.2363,11.2363,0,0,1,2.6807.4726A12.9819,12.9819,0,0,0,15.7612,11h.4922a11.7955,11.7955,0,0,0,2.9956-.5361A9.8483,9.8483,0,0,1,21.7788,10C25.7964,10,26,14.9978,26,16,26,22.2586,22.9482,25.9988,20,26Z"}),React.createElement("path",{d:"M18,7H17V6a2.0021,2.0021,0,0,1,2-2h1V5A2.0021,2.0021,0,0,1,18,7Z"}),props.children);});var Apple16=/*#__PURE__*/React.forwardRef(function Apple16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21.7788,8a11.4843,11.4843,0,0,0-3.0547.5342,14.5665,14.5665,0,0,1-1.8225.4126A6.0054,6.0054,0,0,0,11,4V6a3.9933,3.9933,0,0,1,3.8267,2.9c-.5181-.0879-1.0569-.2207-1.6172-.3648A12.89,12.89,0,0,0,10.0317,8C6.311,8,4,11.0652,4,16c0,7.51,4.0679,11.999,8.0005,12h.0015a7.1576,7.1576,0,0,0,2.49-.59A5.0128,5.0128,0,0,1,16,27a5.0266,5.0266,0,0,1,1.5112.41A7.15,7.15,0,0,0,20,28h0c3.9307-.001,8-4.49,8-12C28,12.3094,26.3706,8,21.7788,8ZM20,26h0a5.5038,5.5038,0,0,1-1.7905-.4639A6.4168,6.4168,0,0,0,16,25a6.4043,6.4043,0,0,0-2.2061.5361A5.5343,5.5343,0,0,1,12,26h.0015C9.0513,25.9988,6,22.2586,6,16c0-1.8037.3931-6,4.0317-6a11.2363,11.2363,0,0,1,2.6807.4726A12.9819,12.9819,0,0,0,15.7612,11h.4922a11.7955,11.7955,0,0,0,2.9956-.5361A9.8483,9.8483,0,0,1,21.7788,10C25.7964,10,26,14.9978,26,16,26,22.2586,22.9482,25.9988,20,26Z"}),React.createElement("path",{d:"M18,7H17V6a2.0021,2.0021,0,0,1,2-2h1V5A2.0021,2.0021,0,0,1,18,7Z"}),props.children);});var Application32=/*#__PURE__*/React.forwardRef(function Application32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,18H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H16a2,2,0,0,1,2,2V16A2,2,0,0,1,16,18ZM6,6V16H16V6Z"}),React.createElement("path",{d:"M26,12v4H22V12h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z"}),React.createElement("path",{d:"M26,22v4H22V22h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"}),React.createElement("path",{d:"M16,22v4H12V22h4m0-2H12a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"}),props.children);});var Application24=/*#__PURE__*/React.forwardRef(function Application24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,18H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H16a2,2,0,0,1,2,2V16A2,2,0,0,1,16,18ZM6,6V16H16V6Z"}),React.createElement("path",{d:"M26,12v4H22V12h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z"}),React.createElement("path",{d:"M26,22v4H22V22h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"}),React.createElement("path",{d:"M16,22v4H12V22h4m0-2H12a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"}),props.children);});var Application20=/*#__PURE__*/React.forwardRef(function Application20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,18H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H16a2,2,0,0,1,2,2V16A2,2,0,0,1,16,18ZM6,6V16H16V6Z"}),React.createElement("path",{d:"M26,12v4H22V12h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z"}),React.createElement("path",{d:"M26,22v4H22V22h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"}),React.createElement("path",{d:"M16,22v4H12V22h4m0-2H12a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"}),props.children);});var Application16=/*#__PURE__*/React.forwardRef(function Application16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,18H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H16a2,2,0,0,1,2,2V16A2,2,0,0,1,16,18ZM6,6V16H16V6Z"}),React.createElement("path",{d:"M26,12v4H22V12h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z"}),React.createElement("path",{d:"M26,22v4H22V22h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"}),React.createElement("path",{d:"M16,22v4H12V22h4m0-2H12a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"}),props.children);});var Apps32=/*#__PURE__*/React.forwardRef(function Apps32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,4v4H4V4H8z M10,2H2v8h8V2z M18,4v4h-4V4H18z M20,2h-8v8h8V2z M28,4v4h-4V4H28z M30,2h-8v8h8V2z M8,14v4H4v-4H8z M10,12H2\tv8h8V12z M18,14v4h-4v-4H18z M20,12h-8v8h8V12z M28,14v4h-4v-4H28z M30,12h-8v8h8V12z M8,24v4H4v-4H8z M10,22H2v8h8V22z M18,24v4h-4\tv-4H18z M20,22h-8v8h8V22z M28,24v4h-4v-4H28z M30,22h-8v8h8V22z"}),props.children);});var Apps24=/*#__PURE__*/React.forwardRef(function Apps24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,4v4H4V4H8z M10,2H2v8h8V2z M18,4v4h-4V4H18z M20,2h-8v8h8V2z M28,4v4h-4V4H28z M30,2h-8v8h8V2z M8,14v4H4v-4H8z M10,12H2\tv8h8V12z M18,14v4h-4v-4H18z M20,12h-8v8h8V12z M28,14v4h-4v-4H28z M30,12h-8v8h8V12z M8,24v4H4v-4H8z M10,22H2v8h8V22z M18,24v4h-4\tv-4H18z M20,22h-8v8h8V22z M28,24v4h-4v-4H28z M30,22h-8v8h8V22z"}),props.children);});var Apps20=/*#__PURE__*/React.forwardRef(function Apps20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,4v4H4V4H8z M10,2H2v8h8V2z M18,4v4h-4V4H18z M20,2h-8v8h8V2z M28,4v4h-4V4H28z M30,2h-8v8h8V2z M8,14v4H4v-4H8z M10,12H2\tv8h8V12z M18,14v4h-4v-4H18z M20,12h-8v8h8V12z M28,14v4h-4v-4H28z M30,12h-8v8h8V12z M8,24v4H4v-4H8z M10,22H2v8h8V22z M18,24v4h-4\tv-4H18z M20,22h-8v8h8V22z M28,24v4h-4v-4H28z M30,22h-8v8h8V22z"}),props.children);});var Archive32=/*#__PURE__*/React.forwardRef(function Archive32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"2",x:"14",y:"19"}),React.createElement("path",{d:"M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z"}),props.children);});var Archive24=/*#__PURE__*/React.forwardRef(function Archive24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"2",x:"14",y:"19"}),React.createElement("path",{d:"M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z"}),props.children);});var Archive20=/*#__PURE__*/React.forwardRef(function Archive20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"2",x:"14",y:"19"}),React.createElement("path",{d:"M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z"}),props.children);});var Archive16=/*#__PURE__*/React.forwardRef(function Archive16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"2",x:"14",y:"19"}),React.createElement("path",{d:"M6,2V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V2ZM24,28H8V16H24Zm0-14H8V10H24ZM8,8V4H24V8Z"}),props.children);});var Arrival32=/*#__PURE__*/React.forwardRef(function Arrival32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M17.21,5.23l1.39.38,1,11.29,5.87,1.57A2,2,0,0,1,27,20.62a1.88,1.88,0,0,1-1.37,1.52,2,2,0,0,1-1,0l-18.7-5a1.89,1.89,0,0,1-1.33-2.3L6.35,8.34l1.44.38L8.4,13.9l6,1.62L17.21,5.23m-1-2.2a1,1,0,0,0-.68.69L13,13.07l-2.81-.75L9.69,7.79A1,1,0,0,0,9,7L5.87,6.14a.94.94,0,0,0-.5,0,1,1,0,0,0-.68.68l-2,7.49a3.87,3.87,0,0,0,2.74,4.74l18.71,5A3.87,3.87,0,0,0,29,21a4,4,0,0,0-3-4.42l-4.52-1.21L20.53,4.71a1,1,0,0,0-.72-.85L16.73,3a1.06,1.06,0,0,0-.5,0Z"}),props.children);});var Arrival24=/*#__PURE__*/React.forwardRef(function Arrival24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M17.21,5.23l1.39.38,1,11.29,5.87,1.57A2,2,0,0,1,27,20.62a1.88,1.88,0,0,1-1.37,1.52,2,2,0,0,1-1,0l-18.7-5a1.89,1.89,0,0,1-1.33-2.3L6.35,8.34l1.44.38L8.4,13.9l6,1.62L17.21,5.23m-1-2.2a1,1,0,0,0-.68.69L13,13.07l-2.81-.75L9.69,7.79A1,1,0,0,0,9,7L5.87,6.14a.94.94,0,0,0-.5,0,1,1,0,0,0-.68.68l-2,7.49a3.87,3.87,0,0,0,2.74,4.74l18.71,5A3.87,3.87,0,0,0,29,21a4,4,0,0,0-3-4.42l-4.52-1.21L20.53,4.71a1,1,0,0,0-.72-.85L16.73,3a1.06,1.06,0,0,0-.5,0Z"}),props.children);});var Arrival20=/*#__PURE__*/React.forwardRef(function Arrival20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M17.21,5.23l1.39.38,1,11.29,5.87,1.57A2,2,0,0,1,27,20.62a1.88,1.88,0,0,1-1.37,1.52,2,2,0,0,1-1,0l-18.7-5a1.89,1.89,0,0,1-1.33-2.3L6.35,8.34l1.44.38L8.4,13.9l6,1.62L17.21,5.23m-1-2.2a1,1,0,0,0-.68.69L13,13.07l-2.81-.75L9.69,7.79A1,1,0,0,0,9,7L5.87,6.14a.94.94,0,0,0-.5,0,1,1,0,0,0-.68.68l-2,7.49a3.87,3.87,0,0,0,2.74,4.74l18.71,5A3.87,3.87,0,0,0,29,21a4,4,0,0,0-3-4.42l-4.52-1.21L20.53,4.71a1,1,0,0,0-.72-.85L16.73,3a1.06,1.06,0,0,0-.5,0Z"}),props.children);});var Arrival16=/*#__PURE__*/React.forwardRef(function Arrival16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M17.21,5.23l1.39.38,1,11.29,5.87,1.57A2,2,0,0,1,27,20.62a1.88,1.88,0,0,1-1.37,1.52,2,2,0,0,1-1,0l-18.7-5a1.89,1.89,0,0,1-1.33-2.3L6.35,8.34l1.44.38L8.4,13.9l6,1.62L17.21,5.23m-1-2.2a1,1,0,0,0-.68.69L13,13.07l-2.81-.75L9.69,7.79A1,1,0,0,0,9,7L5.87,6.14a.94.94,0,0,0-.5,0,1,1,0,0,0-.68.68l-2,7.49a3.87,3.87,0,0,0,2.74,4.74l18.71,5A3.87,3.87,0,0,0,29,21a4,4,0,0,0-3-4.42l-4.52-1.21L20.53,4.71a1,1,0,0,0-.72-.85L16.73,3a1.06,1.06,0,0,0-.5,0Z"}),props.children);});var ArrowDownLeft32=/*#__PURE__*/React.forwardRef(function ArrowDownLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 26 22 24 9.41 24 26 7.41 24.59 6 8 22.59 8 10 6 10 6 26 22 26"}),props.children);});var ArrowDownLeft24=/*#__PURE__*/React.forwardRef(function ArrowDownLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 26 22 24 9.41 24 26 7.41 24.59 6 8 22.59 8 10 6 10 6 26 22 26"}),props.children);});var ArrowDownLeft20=/*#__PURE__*/React.forwardRef(function ArrowDownLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 26 22 24 9.41 24 26 7.41 24.59 6 8 22.59 8 10 6 10 6 26 22 26"}),props.children);});var ArrowDownLeft16=/*#__PURE__*/React.forwardRef(function ArrowDownLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 26 22 24 9.41 24 26 7.41 24.59 6 8 22.59 8 10 6 10 6 26 22 26"}),props.children);});var ArrowDownRight32=/*#__PURE__*/React.forwardRef(function ArrowDownRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"10 26 10 24 22.59 24 6 7.41 7.41 6 24 22.59 24 10 26 10 26 26 10 26"}),props.children);});var ArrowDownRight24=/*#__PURE__*/React.forwardRef(function ArrowDownRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"10 26 10 24 22.59 24 6 7.41 7.41 6 24 22.59 24 10 26 10 26 26 10 26"}),props.children);});var ArrowDownRight20=/*#__PURE__*/React.forwardRef(function ArrowDownRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"10 26 10 24 22.59 24 6 7.41 7.41 6 24 22.59 24 10 26 10 26 26 10 26"}),props.children);});var ArrowDownRight16=/*#__PURE__*/React.forwardRef(function ArrowDownRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"10 26 10 24 22.59 24 6 7.41 7.41 6 24 22.59 24 10 26 10 26 26 10 26"}),props.children);});var ArrowDown32=/*#__PURE__*/React.forwardRef(function ArrowDown32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24.59 16.59 17 24.17 17 2 15 2 15 24.17 7.41 16.59 6 18 16 28 26 18 24.59 16.59"}),props.children);});var ArrowDown24=/*#__PURE__*/React.forwardRef(function ArrowDown24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24.59 16.59 17 24.17 17 2 15 2 15 24.17 7.41 16.59 6 18 16 28 26 18 24.59 16.59"}),props.children);});var ArrowDown20=/*#__PURE__*/React.forwardRef(function ArrowDown20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24.59 16.59 17 24.17 17 2 15 2 15 24.17 7.41 16.59 6 18 16 28 26 18 24.59 16.59"}),props.children);});var ArrowLeft32=/*#__PURE__*/React.forwardRef(function ArrowLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"13 26 14.41 24.59 6.83 17 29 17 29 15 6.83 15 14.41 7.41 13 6 3 16 13 26"}),props.children);});var ArrowLeft24=/*#__PURE__*/React.forwardRef(function ArrowLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"13 26 14.41 24.59 6.83 17 29 17 29 15 6.83 15 14.41 7.41 13 6 3 16 13 26"}),props.children);});var ArrowLeft20=/*#__PURE__*/React.forwardRef(function ArrowLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"13 26 14.41 24.59 6.83 17 29 17 29 15 6.83 15 14.41 7.41 13 6 3 16 13 26"}),props.children);});var ArrowRight32=/*#__PURE__*/React.forwardRef(function ArrowRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18,6 16.6,7.4 24.1,15 3,15 3,17 24.1,17 16.6,24.6 18,26 28,16"}),props.children);});var ArrowUpLeft32=/*#__PURE__*/React.forwardRef(function ArrowUpLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 6 22 8 9.41 8 26 24.59 24.59 26 8 9.41 8 22 6 22 6 6 22 6"}),props.children);});var ArrowUpLeft24=/*#__PURE__*/React.forwardRef(function ArrowUpLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 6 22 8 9.41 8 26 24.59 24.59 26 8 9.41 8 22 6 22 6 6 22 6"}),props.children);});var ArrowUpLeft20=/*#__PURE__*/React.forwardRef(function ArrowUpLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 6 22 8 9.41 8 26 24.59 24.59 26 8 9.41 8 22 6 22 6 6 22 6"}),props.children);});var ArrowUpLeft16=/*#__PURE__*/React.forwardRef(function ArrowUpLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 6 22 8 9.41 8 26 24.59 24.59 26 8 9.41 8 22 6 22 6 6 22 6"}),props.children);});var ArrowUpRight32=/*#__PURE__*/React.forwardRef(function ArrowUpRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"10 6 10 8 22.59 8 6 24.59 7.41 26 24 9.41 24 22 26 22 26 6 10 6"}),props.children);});var ArrowUpRight24=/*#__PURE__*/React.forwardRef(function ArrowUpRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"10 6 10 8 22.59 8 6 24.59 7.41 26 24 9.41 24 22 26 22 26 6 10 6"}),props.children);});var ArrowUpRight20=/*#__PURE__*/React.forwardRef(function ArrowUpRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"10 6 10 8 22.59 8 6 24.59 7.41 26 24 9.41 24 22 26 22 26 6 10 6"}),props.children);});var ArrowUpRight16=/*#__PURE__*/React.forwardRef(function ArrowUpRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"10 6 10 8 22.59 8 6 24.59 7.41 26 24 9.41 24 22 26 22 26 6 10 6"}),props.children);});var ArrowUp32=/*#__PURE__*/React.forwardRef(function ArrowUp32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16 4 6 14 7.41 15.41 15 7.83 15 30 17 30 17 7.83 24.59 15.41 26 14 16 4"}),props.children);});var ArrowUp24=/*#__PURE__*/React.forwardRef(function ArrowUp24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16 4 6 14 7.41 15.41 15 7.83 15 30 17 30 17 7.83 24.59 15.41 26 14 16 4"}),props.children);});var ArrowUp20=/*#__PURE__*/React.forwardRef(function ArrowUp20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16 4 6 14 7.41 15.41 15 7.83 15 30 17 30 17 7.83 24.59 15.41 26 14 16 4"}),props.children);});var ArrowShiftDown32=/*#__PURE__*/React.forwardRef(function ArrowShiftDown32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,6V16h5a1,1,0,0,1,.707,1.707l-12,12a.9994.9994,0,0,1-1.414,0l-12-12A1,1,0,0,1,4,16H9V6a2.0023,2.0023,0,0,1,2-2H21A2.0027,2.0027,0,0,1,23,6ZM16,27.5859,25.5859,18H22a1,1,0,0,1-1-1V6H11V17a1,1,0,0,1-1,1H6.4141Z"}),props.children);});var ArrowShiftDown24=/*#__PURE__*/React.forwardRef(function ArrowShiftDown24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,6V16h5a1,1,0,0,1,.707,1.707l-12,12a.9994.9994,0,0,1-1.414,0l-12-12A1,1,0,0,1,4,16H9V6a2.0023,2.0023,0,0,1,2-2H21A2.0027,2.0027,0,0,1,23,6ZM16,27.5859,25.5859,18H22a1,1,0,0,1-1-1V6H11V17a1,1,0,0,1-1,1H6.4141Z"}),props.children);});var ArrowShiftDown20=/*#__PURE__*/React.forwardRef(function ArrowShiftDown20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,6V16h5a1,1,0,0,1,.707,1.707l-12,12a.9994.9994,0,0,1-1.414,0l-12-12A1,1,0,0,1,4,16H9V6a2.0023,2.0023,0,0,1,2-2H21A2.0027,2.0027,0,0,1,23,6ZM16,27.5859,25.5859,18H22a1,1,0,0,1-1-1V6H11V17a1,1,0,0,1-1,1H6.4141Z"}),props.children);});var ArrowShiftDown16=/*#__PURE__*/React.forwardRef(function ArrowShiftDown16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,6V16h5a1,1,0,0,1,.707,1.707l-12,12a.9994.9994,0,0,1-1.414,0l-12-12A1,1,0,0,1,4,16H9V6a2.0023,2.0023,0,0,1,2-2H21A2.0027,2.0027,0,0,1,23,6ZM16,27.5859,25.5859,18H22a1,1,0,0,1-1-1V6H11V17a1,1,0,0,1-1,1H6.4141Z"}),props.children);});var ArrowsHorizontal32=/*#__PURE__*/React.forwardRef(function ArrowsHorizontal32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"11.41 26.59 7.83 23 28 23 28 21 7.83 21 11.41 17.41 10 16 4 22 10 28 11.41 26.59"}),React.createElement("polygon",{points:"28 10 22 4 20.59 5.41 24.17 9 4 9 4 11 24.17 11 20.59 14.59 22 16 28 10"}),props.children);});var ArrowsHorizontal24=/*#__PURE__*/React.forwardRef(function ArrowsHorizontal24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"11.41 26.59 7.83 23 28 23 28 21 7.83 21 11.41 17.41 10 16 4 22 10 28 11.41 26.59"}),React.createElement("polygon",{points:"28 10 22 4 20.59 5.41 24.17 9 4 9 4 11 24.17 11 20.59 14.59 22 16 28 10"}),props.children);});var ArrowsHorizontal20=/*#__PURE__*/React.forwardRef(function ArrowsHorizontal20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"11.41 26.59 7.83 23 28 23 28 21 7.83 21 11.41 17.41 10 16 4 22 10 28 11.41 26.59"}),React.createElement("polygon",{points:"28 10 22 4 20.59 5.41 24.17 9 4 9 4 11 24.17 11 20.59 14.59 22 16 28 10"}),props.children);});var ArrowsHorizontal16=/*#__PURE__*/React.forwardRef(function ArrowsHorizontal16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"11.41 26.59 7.83 23 28 23 28 21 7.83 21 11.41 17.41 10 16 4 22 10 28 11.41 26.59"}),React.createElement("polygon",{points:"28 10 22 4 20.59 5.41 24.17 9 4 9 4 11 24.17 11 20.59 14.59 22 16 28 10"}),props.children);});var ArrowsVertical32=/*#__PURE__*/React.forwardRef(function ArrowsVertical32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"27.6,20.6 24,24.2 24,4 22,4 22,24.2 18.4,20.6 17,22 23,28 29,22"}),React.createElement("polygon",{points:"9,4 3,10 4.4,11.4 8,7.8 8,28 10,28 10,7.8 13.6,11.4 15,10"}),props.children);});var ArrowsVertical24=/*#__PURE__*/React.forwardRef(function ArrowsVertical24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"27.6,20.6 24,24.2 24,4 22,4 22,24.2 18.4,20.6 17,22 23,28 29,22"}),React.createElement("polygon",{points:"9,4 3,10 4.4,11.4 8,7.8 8,28 10,28 10,7.8 13.6,11.4 15,10"}),props.children);});var ArrowsVertical20=/*#__PURE__*/React.forwardRef(function ArrowsVertical20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"27.6,20.6 24,24.2 24,4 22,4 22,24.2 18.4,20.6 17,22 23,28 29,22"}),React.createElement("polygon",{points:"9,4 3,10 4.4,11.4 8,7.8 8,28 10,28 10,7.8 13.6,11.4 15,10"}),props.children);});var ArrowsVertical16=/*#__PURE__*/React.forwardRef(function ArrowsVertical16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"27.6,20.6 24,24.2 24,4 22,4 22,24.2 18.4,20.6 17,22 23,28 29,22"}),React.createElement("polygon",{points:"9,4 3,10 4.4,11.4 8,7.8 8,28 10,28 10,7.8 13.6,11.4 15,10"}),props.children);});var Arrows32=/*#__PURE__*/React.forwardRef(function Arrows32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"27.6,20.6 24,24.2 24,4 22,4 22,24.2 18.4,20.6 17,22 23,28 29,22"}),React.createElement("polygon",{points:"9,4 3,10 4.4,11.4 8,7.8 8,28 10,28 10,7.8 13.6,11.4 15,10"}),props.children);});var Arrows24=/*#__PURE__*/React.forwardRef(function Arrows24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"27.6,20.6 24,24.2 24,4 22,4 22,24.2 18.4,20.6 17,22 23,28 29,22"}),React.createElement("polygon",{points:"9,4 3,10 4.4,11.4 8,7.8 8,28 10,28 10,7.8 13.6,11.4 15,10"}),props.children);});var Arrows20=/*#__PURE__*/React.forwardRef(function Arrows20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"27.6,20.6 24,24.2 24,4 22,4 22,24.2 18.4,20.6 17,22 23,28 29,22"}),React.createElement("polygon",{points:"9,4 3,10 4.4,11.4 8,7.8 8,28 10,28 10,7.8 13.6,11.4 15,10"}),props.children);});var Arrows16=/*#__PURE__*/React.forwardRef(function Arrows16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"27.6,20.6 24,24.2 24,4 22,4 22,24.2 18.4,20.6 17,22 23,28 29,22"}),React.createElement("polygon",{points:"9,4 3,10 4.4,11.4 8,7.8 8,28 10,28 10,7.8 13.6,11.4 15,10"}),props.children);});var AsleepFilled32=/*#__PURE__*/React.forwardRef(function AsleepFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"}),props.children);});var AsleepFilled24=/*#__PURE__*/React.forwardRef(function AsleepFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"}),props.children);});var AsleepFilled20=/*#__PURE__*/React.forwardRef(function AsleepFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"}),props.children);});var AsleepFilled16=/*#__PURE__*/React.forwardRef(function AsleepFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"}),props.children);});var Asleep32=/*#__PURE__*/React.forwardRef(function Asleep32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.5025,5.4136A15.0755,15.0755,0,0,0,25.096,23.6082a11.1134,11.1134,0,0,1-7.9749,3.3893c-.1385,0-.2782.0051-.4178,0A11.0944,11.0944,0,0,1,13.5025,5.4136M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"}),props.children);});var Asleep24=/*#__PURE__*/React.forwardRef(function Asleep24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.5025,5.4136A15.0755,15.0755,0,0,0,25.096,23.6082a11.1134,11.1134,0,0,1-7.9749,3.3893c-.1385,0-.2782.0051-.4178,0A11.0944,11.0944,0,0,1,13.5025,5.4136M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"}),props.children);});var Asleep20=/*#__PURE__*/React.forwardRef(function Asleep20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.5025,5.4136A15.0755,15.0755,0,0,0,25.096,23.6082a11.1134,11.1134,0,0,1-7.9749,3.3893c-.1385,0-.2782.0051-.4178,0A11.0944,11.0944,0,0,1,13.5025,5.4136M14.98,3a1.0024,1.0024,0,0,0-.1746.0156A13.0959,13.0959,0,0,0,16.63,28.9973c.1641.006.3282,0,.4909,0a13.0724,13.0724,0,0,0,10.702-5.5556,1.0094,1.0094,0,0,0-.7833-1.5644A13.08,13.08,0,0,1,15.8892,4.38,1.0149,1.0149,0,0,0,14.98,3Z"}),props.children);});var Asset32=/*#__PURE__*/React.forwardRef(function Asset32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12.0752,24a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,12.0752,24Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,12.0752,18Z"}),React.createElement("path",{d:"M30,6a4.0042,4.0042,0,0,0-4-4,3.949,3.949,0,0,0-1.8537.4768L7.7571,10.9579A9.9921,9.9921,0,1,0,21.066,24.1929l8.49-16.3994A3.9491,3.9491,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM22.0194,5.8083C22.0163,5.8732,22,5.9343,22,6a4.0042,4.0042,0,0,0,4,4c.0645,0,.1245-.016.1882-.019l-4.3318,8.3617a10.0168,10.0168,0,0,0-8.2158-8.1962ZM12,28a8,8,0,1,1,8-8A8.0092,8.0092,0,0,1,12,28Z"}),props.children);});var Asset24=/*#__PURE__*/React.forwardRef(function Asset24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12.0752,24a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,12.0752,24Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,12.0752,18Z"}),React.createElement("path",{d:"M30,6a4.0042,4.0042,0,0,0-4-4,3.949,3.949,0,0,0-1.8537.4768L7.7571,10.9579A9.9921,9.9921,0,1,0,21.066,24.1929l8.49-16.3994A3.9491,3.9491,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM22.0194,5.8083C22.0163,5.8732,22,5.9343,22,6a4.0042,4.0042,0,0,0,4,4c.0645,0,.1245-.016.1882-.019l-4.3318,8.3617a10.0168,10.0168,0,0,0-8.2158-8.1962ZM12,28a8,8,0,1,1,8-8A8.0092,8.0092,0,0,1,12,28Z"}),props.children);});var Asset20=/*#__PURE__*/React.forwardRef(function Asset20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12.0752,24a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,12.0752,24Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,12.0752,18Z"}),React.createElement("path",{d:"M30,6a4.0042,4.0042,0,0,0-4-4,3.949,3.949,0,0,0-1.8537.4768L7.7571,10.9579A9.9921,9.9921,0,1,0,21.066,24.1929l8.49-16.3994A3.9491,3.9491,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM22.0194,5.8083C22.0163,5.8732,22,5.9343,22,6a4.0042,4.0042,0,0,0,4,4c.0645,0,.1245-.016.1882-.019l-4.3318,8.3617a10.0168,10.0168,0,0,0-8.2158-8.1962ZM12,28a8,8,0,1,1,8-8A8.0092,8.0092,0,0,1,12,28Z"}),props.children);});var Asset16=/*#__PURE__*/React.forwardRef(function Asset16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12.0752,24a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,12.0752,24Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,12.0752,18Z"}),React.createElement("path",{d:"M30,6a4.0042,4.0042,0,0,0-4-4,3.949,3.949,0,0,0-1.8537.4768L7.7571,10.9579A9.9921,9.9921,0,1,0,21.066,24.1929l8.49-16.3994A3.9491,3.9491,0,0,0,30,6ZM26,4a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,4ZM22.0194,5.8083C22.0163,5.8732,22,5.9343,22,6a4.0042,4.0042,0,0,0,4,4c.0645,0,.1245-.016.1882-.019l-4.3318,8.3617a10.0168,10.0168,0,0,0-8.2158-8.1962ZM12,28a8,8,0,1,1,8-8A8.0092,8.0092,0,0,1,12,28Z"}),props.children);});var At32=/*#__PURE__*/React.forwardRef(function At32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,3A12.92,12.92,0,0,0,3,16v1A13,13,0,0,0,16,30h7V28H16A11,11,0,0,1,5,17V16A10.94,10.94,0,0,1,16,5,10.64,10.64,0,0,1,27,16c0,3.59-1.4,5-3.66,5C21.76,21,21,19.71,21,18V10H19v1.94A3.84,3.84,0,0,0,15.5,10,5.48,5.48,0,0,0,10,15.44v2.12A5.48,5.48,0,0,0,15.5,23a4.28,4.28,0,0,0,4-2.46A4.35,4.35,0,0,0,23.41,23C26.48,23,29,21,29,16A12.72,12.72,0,0,0,16,3Zm3,14.56a3.5,3.5,0,0,1-7,0V15.44a3.5,3.5,0,0,1,7,0Z"}),props.children);});var At24=/*#__PURE__*/React.forwardRef(function At24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,3A12.92,12.92,0,0,0,3,16v1A13,13,0,0,0,16,30h7V28H16A11,11,0,0,1,5,17V16A10.94,10.94,0,0,1,16,5,10.64,10.64,0,0,1,27,16c0,3.59-1.4,5-3.66,5C21.76,21,21,19.71,21,18V10H19v1.94A3.84,3.84,0,0,0,15.5,10,5.48,5.48,0,0,0,10,15.44v2.12A5.48,5.48,0,0,0,15.5,23a4.28,4.28,0,0,0,4-2.46A4.35,4.35,0,0,0,23.41,23C26.48,23,29,21,29,16A12.72,12.72,0,0,0,16,3Zm3,14.56a3.5,3.5,0,0,1-7,0V15.44a3.5,3.5,0,0,1,7,0Z"}),props.children);});var At20=/*#__PURE__*/React.forwardRef(function At20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,3A12.92,12.92,0,0,0,3,16v1A13,13,0,0,0,16,30h7V28H16A11,11,0,0,1,5,17V16A10.94,10.94,0,0,1,16,5,10.64,10.64,0,0,1,27,16c0,3.59-1.4,5-3.66,5C21.76,21,21,19.71,21,18V10H19v1.94A3.84,3.84,0,0,0,15.5,10,5.48,5.48,0,0,0,10,15.44v2.12A5.48,5.48,0,0,0,15.5,23a4.28,4.28,0,0,0,4-2.46A4.35,4.35,0,0,0,23.41,23C26.48,23,29,21,29,16A12.72,12.72,0,0,0,16,3Zm3,14.56a3.5,3.5,0,0,1-7,0V15.44a3.5,3.5,0,0,1,7,0Z"}),props.children);});var At16=/*#__PURE__*/React.forwardRef(function At16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,3A12.92,12.92,0,0,0,3,16v1A13,13,0,0,0,16,30h7V28H16A11,11,0,0,1,5,17V16A10.94,10.94,0,0,1,16,5,10.64,10.64,0,0,1,27,16c0,3.59-1.4,5-3.66,5C21.76,21,21,19.71,21,18V10H19v1.94A3.84,3.84,0,0,0,15.5,10,5.48,5.48,0,0,0,10,15.44v2.12A5.48,5.48,0,0,0,15.5,23a4.28,4.28,0,0,0,4-2.46A4.35,4.35,0,0,0,23.41,23C26.48,23,29,21,29,16A12.72,12.72,0,0,0,16,3Zm3,14.56a3.5,3.5,0,0,1-7,0V15.44a3.5,3.5,0,0,1,7,0Z"}),props.children);});var Attachment32=/*#__PURE__*/React.forwardRef(function Attachment32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.1,18.9L13.1,3.9c-2.5-2.6-6.6-2.6-9.2-0.1S1.3,10.5,3.9,13c0,0,0.1,0.1,0.1,0.1L6.8,16l1.4-1.4l-2.9-2.9\tC3.6,10,3.6,7.1,5.3,5.4s4.6-1.8,6.3-0.1c0,0,0,0,0.1,0.1l14.9,14.9c1.8,1.7,1.8,4.6,0.1,6.3c-1.7,1.8-4.6,1.8-6.3,0.1\tc0,0,0,0-0.1-0.1l-7.4-7.4c-1-1-0.9-2.6,0-3.5c1-0.9,2.5-0.9,3.5,0l4.1,4.1l1.4-1.4c0,0-4.2-4.2-4.2-4.2c-1.8-1.7-4.6-1.6-6.3,0.2\tc-1.6,1.7-1.6,4.4,0,6.2l7.5,7.5c2.5,2.6,6.6,2.6,9.2,0.1S30.7,21.5,28.1,18.9C28.1,19,28.1,18.9,28.1,18.9L28.1,18.9z"}),props.children);});var Attachment24=/*#__PURE__*/React.forwardRef(function Attachment24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.1,18.9L13.1,3.9c-2.5-2.6-6.6-2.6-9.2-0.1S1.3,10.5,3.9,13c0,0,0.1,0.1,0.1,0.1L6.8,16l1.4-1.4l-2.9-2.9\tC3.6,10,3.6,7.1,5.3,5.4s4.6-1.8,6.3-0.1c0,0,0,0,0.1,0.1l14.9,14.9c1.8,1.7,1.8,4.6,0.1,6.3c-1.7,1.8-4.6,1.8-6.3,0.1\tc0,0,0,0-0.1-0.1l-7.4-7.4c-1-1-0.9-2.6,0-3.5c1-0.9,2.5-0.9,3.5,0l4.1,4.1l1.4-1.4c0,0-4.2-4.2-4.2-4.2c-1.8-1.7-4.6-1.6-6.3,0.2\tc-1.6,1.7-1.6,4.4,0,6.2l7.5,7.5c2.5,2.6,6.6,2.6,9.2,0.1S30.7,21.5,28.1,18.9C28.1,19,28.1,18.9,28.1,18.9L28.1,18.9z"}),props.children);});var Attachment20=/*#__PURE__*/React.forwardRef(function Attachment20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.1,18.9L13.1,3.9c-2.5-2.6-6.6-2.6-9.2-0.1S1.3,10.5,3.9,13c0,0,0.1,0.1,0.1,0.1L6.8,16l1.4-1.4l-2.9-2.9\tC3.6,10,3.6,7.1,5.3,5.4s4.6-1.8,6.3-0.1c0,0,0,0,0.1,0.1l14.9,14.9c1.8,1.7,1.8,4.6,0.1,6.3c-1.7,1.8-4.6,1.8-6.3,0.1\tc0,0,0,0-0.1-0.1l-7.4-7.4c-1-1-0.9-2.6,0-3.5c1-0.9,2.5-0.9,3.5,0l4.1,4.1l1.4-1.4c0,0-4.2-4.2-4.2-4.2c-1.8-1.7-4.6-1.6-6.3,0.2\tc-1.6,1.7-1.6,4.4,0,6.2l7.5,7.5c2.5,2.6,6.6,2.6,9.2,0.1S30.7,21.5,28.1,18.9C28.1,19,28.1,18.9,28.1,18.9L28.1,18.9z"}),props.children);});var Attachment16=/*#__PURE__*/React.forwardRef(function Attachment16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.1,18.9L13.1,3.9c-2.5-2.6-6.6-2.6-9.2-0.1S1.3,10.5,3.9,13c0,0,0.1,0.1,0.1,0.1L6.8,16l1.4-1.4l-2.9-2.9\tC3.6,10,3.6,7.1,5.3,5.4s4.6-1.8,6.3-0.1c0,0,0,0,0.1,0.1l14.9,14.9c1.8,1.7,1.8,4.6,0.1,6.3c-1.7,1.8-4.6,1.8-6.3,0.1\tc0,0,0,0-0.1-0.1l-7.4-7.4c-1-1-0.9-2.6,0-3.5c1-0.9,2.5-0.9,3.5,0l4.1,4.1l1.4-1.4c0,0-4.2-4.2-4.2-4.2c-1.8-1.7-4.6-1.6-6.3,0.2\tc-1.6,1.7-1.6,4.4,0,6.2l7.5,7.5c2.5,2.6,6.6,2.6,9.2,0.1S30.7,21.5,28.1,18.9C28.1,19,28.1,18.9,28.1,18.9L28.1,18.9z"}),props.children);});var AudioConsole32=/*#__PURE__*/React.forwardRef(function AudioConsole32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,20H29V2H27V20H26a2.0027,2.0027,0,0,0-2,2v2a2.0027,2.0027,0,0,0,2,2h1v4h2V26h1a2.0027,2.0027,0,0,0,2-2V22A2.0027,2.0027,0,0,0,30,20Zm0,4H26V22h4Z",transform:"translate(0 .005)"}),React.createElement("path",{d:"M22,14H21V2H19V14H18a2.002,2.002,0,0,0-2,2v2a2.0023,2.0023,0,0,0,2,2h1V30h2V20h1a2.0027,2.0027,0,0,0,2-2V16A2.0023,2.0023,0,0,0,22,14Zm0,4H18V16h4Z",transform:"translate(0 .005)"}),React.createElement("path",{d:"M14,7H13V2H11V7H10A2.002,2.002,0,0,0,8,9v2a2.002,2.002,0,0,0,2,2h1V30h2V13h1a2.002,2.002,0,0,0,2-2V9A2.002,2.002,0,0,0,14,7Zm0,4H10V9h4Z",transform:"translate(0 .005)"}),React.createElement("path",{d:"M6,21H5V2H3V21H2a2.0023,2.0023,0,0,0-2,2v2a2.0023,2.0023,0,0,0,2,2H3v3H5V27H6a2.0023,2.0023,0,0,0,2-2V23A2.0023,2.0023,0,0,0,6,21Zm0,4H2V23l4-.001Z",transform:"translate(0 .005)"}),props.children);});var AudioConsole24=/*#__PURE__*/React.forwardRef(function AudioConsole24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,20H29V2H27V20H26a2.0027,2.0027,0,0,0-2,2v2a2.0027,2.0027,0,0,0,2,2h1v4h2V26h1a2.0027,2.0027,0,0,0,2-2V22A2.0027,2.0027,0,0,0,30,20Zm0,4H26V22h4Z",transform:"translate(0 .005)"}),React.createElement("path",{d:"M22,14H21V2H19V14H18a2.002,2.002,0,0,0-2,2v2a2.0023,2.0023,0,0,0,2,2h1V30h2V20h1a2.0027,2.0027,0,0,0,2-2V16A2.0023,2.0023,0,0,0,22,14Zm0,4H18V16h4Z",transform:"translate(0 .005)"}),React.createElement("path",{d:"M14,7H13V2H11V7H10A2.002,2.002,0,0,0,8,9v2a2.002,2.002,0,0,0,2,2h1V30h2V13h1a2.002,2.002,0,0,0,2-2V9A2.002,2.002,0,0,0,14,7Zm0,4H10V9h4Z",transform:"translate(0 .005)"}),React.createElement("path",{d:"M6,21H5V2H3V21H2a2.0023,2.0023,0,0,0-2,2v2a2.0023,2.0023,0,0,0,2,2H3v3H5V27H6a2.0023,2.0023,0,0,0,2-2V23A2.0023,2.0023,0,0,0,6,21Zm0,4H2V23l4-.001Z",transform:"translate(0 .005)"}),props.children);});var AudioConsole20=/*#__PURE__*/React.forwardRef(function AudioConsole20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,20H29V2H27V20H26a2.0027,2.0027,0,0,0-2,2v2a2.0027,2.0027,0,0,0,2,2h1v4h2V26h1a2.0027,2.0027,0,0,0,2-2V22A2.0027,2.0027,0,0,0,30,20Zm0,4H26V22h4Z",transform:"translate(0 .005)"}),React.createElement("path",{d:"M22,14H21V2H19V14H18a2.002,2.002,0,0,0-2,2v2a2.0023,2.0023,0,0,0,2,2h1V30h2V20h1a2.0027,2.0027,0,0,0,2-2V16A2.0023,2.0023,0,0,0,22,14Zm0,4H18V16h4Z",transform:"translate(0 .005)"}),React.createElement("path",{d:"M14,7H13V2H11V7H10A2.002,2.002,0,0,0,8,9v2a2.002,2.002,0,0,0,2,2h1V30h2V13h1a2.002,2.002,0,0,0,2-2V9A2.002,2.002,0,0,0,14,7Zm0,4H10V9h4Z",transform:"translate(0 .005)"}),React.createElement("path",{d:"M6,21H5V2H3V21H2a2.0023,2.0023,0,0,0-2,2v2a2.0023,2.0023,0,0,0,2,2H3v3H5V27H6a2.0023,2.0023,0,0,0,2-2V23A2.0023,2.0023,0,0,0,6,21Zm0,4H2V23l4-.001Z",transform:"translate(0 .005)"}),props.children);});var AudioConsole16=/*#__PURE__*/React.forwardRef(function AudioConsole16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,20H29V2H27V20H26a2.0027,2.0027,0,0,0-2,2v2a2.0027,2.0027,0,0,0,2,2h1v4h2V26h1a2.0027,2.0027,0,0,0,2-2V22A2.0027,2.0027,0,0,0,30,20Zm0,4H26V22h4Z",transform:"translate(0 .005)"}),React.createElement("path",{d:"M22,14H21V2H19V14H18a2.002,2.002,0,0,0-2,2v2a2.0023,2.0023,0,0,0,2,2h1V30h2V20h1a2.0027,2.0027,0,0,0,2-2V16A2.0023,2.0023,0,0,0,22,14Zm0,4H18V16h4Z",transform:"translate(0 .005)"}),React.createElement("path",{d:"M14,7H13V2H11V7H10A2.002,2.002,0,0,0,8,9v2a2.002,2.002,0,0,0,2,2h1V30h2V13h1a2.002,2.002,0,0,0,2-2V9A2.002,2.002,0,0,0,14,7Zm0,4H10V9h4Z",transform:"translate(0 .005)"}),React.createElement("path",{d:"M6,21H5V2H3V21H2a2.0023,2.0023,0,0,0-2,2v2a2.0023,2.0023,0,0,0,2,2H3v3H5V27H6a2.0023,2.0023,0,0,0,2-2V23A2.0023,2.0023,0,0,0,6,21Zm0,4H2V23l4-.001Z",transform:"translate(0 .005)"}),props.children);});var AugmentedReality32=/*#__PURE__*/React.forwardRef(function AugmentedReality32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.4473,9.1055l-6-3a1.0008,1.0008,0,0,0-.8946,0l-6,3A1,1,0,0,0,14,10v7a1,1,0,0,0,.5527.8945l6,3a1.001,1.001,0,0,0,.8946,0l6-3A1,1,0,0,0,28,17V10A1,1,0,0,0,27.4473,9.1055ZM21,8.1182,24.7637,10,21,11.8818,17.2363,10Zm-5,3.5,4,2v4.7636l-4-2Zm6,6.7636V13.6182l4-2v4.7636Z"}),React.createElement("circle",{cx:"13.5",cy:"24.5",r:"1.5"}),React.createElement("path",{d:"M20,30H7a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,7,2H20V4H7V28H20V24h2v4A2.0023,2.0023,0,0,1,20,30Z"}),props.children);});var AugmentedReality24=/*#__PURE__*/React.forwardRef(function AugmentedReality24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.4473,9.1055l-6-3a1.0008,1.0008,0,0,0-.8946,0l-6,3A1,1,0,0,0,14,10v7a1,1,0,0,0,.5527.8945l6,3a1.001,1.001,0,0,0,.8946,0l6-3A1,1,0,0,0,28,17V10A1,1,0,0,0,27.4473,9.1055ZM21,8.1182,24.7637,10,21,11.8818,17.2363,10Zm-5,3.5,4,2v4.7636l-4-2Zm6,6.7636V13.6182l4-2v4.7636Z"}),React.createElement("circle",{cx:"13.5",cy:"24.5",r:"1.5"}),React.createElement("path",{d:"M20,30H7a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,7,2H20V4H7V28H20V24h2v4A2.0023,2.0023,0,0,1,20,30Z"}),props.children);});var AugmentedReality20=/*#__PURE__*/React.forwardRef(function AugmentedReality20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.4473,9.1055l-6-3a1.0008,1.0008,0,0,0-.8946,0l-6,3A1,1,0,0,0,14,10v7a1,1,0,0,0,.5527.8945l6,3a1.001,1.001,0,0,0,.8946,0l6-3A1,1,0,0,0,28,17V10A1,1,0,0,0,27.4473,9.1055ZM21,8.1182,24.7637,10,21,11.8818,17.2363,10Zm-5,3.5,4,2v4.7636l-4-2Zm6,6.7636V13.6182l4-2v4.7636Z"}),React.createElement("circle",{cx:"13.5",cy:"24.5",r:"1.5"}),React.createElement("path",{d:"M20,30H7a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,7,2H20V4H7V28H20V24h2v4A2.0023,2.0023,0,0,1,20,30Z"}),props.children);});var AugmentedReality16=/*#__PURE__*/React.forwardRef(function AugmentedReality16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.4473,9.1055l-6-3a1.0008,1.0008,0,0,0-.8946,0l-6,3A1,1,0,0,0,14,10v7a1,1,0,0,0,.5527.8945l6,3a1.001,1.001,0,0,0,.8946,0l6-3A1,1,0,0,0,28,17V10A1,1,0,0,0,27.4473,9.1055ZM21,8.1182,24.7637,10,21,11.8818,17.2363,10Zm-5,3.5,4,2v4.7636l-4-2Zm6,6.7636V13.6182l4-2v4.7636Z"}),React.createElement("circle",{cx:"13.5",cy:"24.5",r:"1.5"}),React.createElement("path",{d:"M20,30H7a2.0023,2.0023,0,0,1-2-2V4A2.0023,2.0023,0,0,1,7,2H20V4H7V28H20V24h2v4A2.0023,2.0023,0,0,1,20,30Z"}),props.children);});var Awake32=/*#__PURE__*/React.forwardRef(function Awake32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4.96",x:"15",y:"2"}),React.createElement("rect",{width:"4.96",height:"2",x:"21.67",y:"6.85",transform:"rotate(-45 24.142 7.85)"}),React.createElement("rect",{width:"4.96",height:"2",x:"25.04",y:"15"}),React.createElement("rect",{width:"2",height:"4.96",x:"23.15",y:"21.67",transform:"rotate(-45 24.152 24.146)"}),React.createElement("rect",{width:"2",height:"4.96",x:"15",y:"25.04"}),React.createElement("rect",{width:"4.96",height:"2",x:"5.37",y:"23.15",transform:"rotate(-45 7.86 24.144)"}),React.createElement("rect",{width:"4.96",height:"2",x:"2",y:"15"}),React.createElement("rect",{width:"2",height:"4.96",x:"6.85",y:"5.37",transform:"rotate(-45 7.85 7.848)"}),React.createElement("path",{d:"M16,12a4,4,0,1,1-4,4,4,4,0,0,1,4-4m0-2a6,6,0,1,0,6,6,6,6,0,0,0-6-6Z"}),props.children);});var Awake24=/*#__PURE__*/React.forwardRef(function Awake24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4.96",x:"15",y:"2"}),React.createElement("rect",{width:"4.96",height:"2",x:"21.67",y:"6.85",transform:"rotate(-45 24.142 7.85)"}),React.createElement("rect",{width:"4.96",height:"2",x:"25.04",y:"15"}),React.createElement("rect",{width:"2",height:"4.96",x:"23.15",y:"21.67",transform:"rotate(-45 24.152 24.146)"}),React.createElement("rect",{width:"2",height:"4.96",x:"15",y:"25.04"}),React.createElement("rect",{width:"4.96",height:"2",x:"5.37",y:"23.15",transform:"rotate(-45 7.86 24.144)"}),React.createElement("rect",{width:"4.96",height:"2",x:"2",y:"15"}),React.createElement("rect",{width:"2",height:"4.96",x:"6.85",y:"5.37",transform:"rotate(-45 7.85 7.848)"}),React.createElement("path",{d:"M16,12a4,4,0,1,1-4,4,4,4,0,0,1,4-4m0-2a6,6,0,1,0,6,6,6,6,0,0,0-6-6Z"}),props.children);});var Awake20=/*#__PURE__*/React.forwardRef(function Awake20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4.96",x:"15",y:"2"}),React.createElement("rect",{width:"4.96",height:"2",x:"21.67",y:"6.85",transform:"rotate(-45 24.142 7.85)"}),React.createElement("rect",{width:"4.96",height:"2",x:"25.04",y:"15"}),React.createElement("rect",{width:"2",height:"4.96",x:"23.15",y:"21.67",transform:"rotate(-45 24.152 24.146)"}),React.createElement("rect",{width:"2",height:"4.96",x:"15",y:"25.04"}),React.createElement("rect",{width:"4.96",height:"2",x:"5.37",y:"23.15",transform:"rotate(-45 7.86 24.144)"}),React.createElement("rect",{width:"4.96",height:"2",x:"2",y:"15"}),React.createElement("rect",{width:"2",height:"4.96",x:"6.85",y:"5.37",transform:"rotate(-45 7.85 7.848)"}),React.createElement("path",{d:"M16,12a4,4,0,1,1-4,4,4,4,0,0,1,4-4m0-2a6,6,0,1,0,6,6,6,6,0,0,0-6-6Z"}),props.children);});var BackToTop32=/*#__PURE__*/React.forwardRef(function BackToTop32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,14 6,24 7.4,25.4 16,16.8 24.6,25.4 26,24"}),React.createElement("rect",{width:"24",height:"2",x:"4",y:"8"}),props.children);});var BackToTop24=/*#__PURE__*/React.forwardRef(function BackToTop24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,14 6,24 7.4,25.4 16,16.8 24.6,25.4 26,24"}),React.createElement("rect",{width:"24",height:"2",x:"4",y:"8"}),props.children);});var BackToTop20=/*#__PURE__*/React.forwardRef(function BackToTop20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,14 6,24 7.4,25.4 16,16.8 24.6,25.4 26,24"}),React.createElement("rect",{width:"24",height:"2",x:"4",y:"8"}),props.children);});var BackToTop16=/*#__PURE__*/React.forwardRef(function BackToTop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,14 6,24 7.4,25.4 16,16.8 24.6,25.4 26,24"}),React.createElement("rect",{width:"24",height:"2",x:"4",y:"8"}),props.children);});var Badge32=/*#__PURE__*/React.forwardRef(function Badge32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 2 24.593 5 28 5.414 25.5 7.667 26 11 23 9.125 20 11 20.5 7.667 18 5.414 21.5 5 23 2"}),React.createElement("path",{d:"M22.7168,13.249l-1.9375-.498A6.9942,6.9942,0,1,1,15.7505,4.22l.499-1.9365A8.99,8.99,0,0,0,8,17.689V30l6-4,6,4V17.7078A8.9627,8.9627,0,0,0,22.7168,13.249ZM18,26.2627l-4-2.6665-4,2.6665V19.05a8.9238,8.9238,0,0,0,8,.0062Z"}),props.children);});var Badge24=/*#__PURE__*/React.forwardRef(function Badge24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 2 24.593 5 28 5.414 25.5 7.667 26 11 23 9.125 20 11 20.5 7.667 18 5.414 21.5 5 23 2"}),React.createElement("path",{d:"M22.7168,13.249l-1.9375-.498A6.9942,6.9942,0,1,1,15.7505,4.22l.499-1.9365A8.99,8.99,0,0,0,8,17.689V30l6-4,6,4V17.7078A8.9627,8.9627,0,0,0,22.7168,13.249ZM18,26.2627l-4-2.6665-4,2.6665V19.05a8.9238,8.9238,0,0,0,8,.0062Z"}),props.children);});var Badge20=/*#__PURE__*/React.forwardRef(function Badge20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 2 24.593 5 28 5.414 25.5 7.667 26 11 23 9.125 20 11 20.5 7.667 18 5.414 21.5 5 23 2"}),React.createElement("path",{d:"M22.7168,13.249l-1.9375-.498A6.9942,6.9942,0,1,1,15.7505,4.22l.499-1.9365A8.99,8.99,0,0,0,8,17.689V30l6-4,6,4V17.7078A8.9627,8.9627,0,0,0,22.7168,13.249ZM18,26.2627l-4-2.6665-4,2.6665V19.05a8.9238,8.9238,0,0,0,8,.0062Z"}),props.children);});var Badge16=/*#__PURE__*/React.forwardRef(function Badge16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 2 24.593 5 28 5.414 25.5 7.667 26 11 23 9.125 20 11 20.5 7.667 18 5.414 21.5 5 23 2"}),React.createElement("path",{d:"M22.7168,13.249l-1.9375-.498A6.9942,6.9942,0,1,1,15.7505,4.22l.499-1.9365A8.99,8.99,0,0,0,8,17.689V30l6-4,6,4V17.7078A8.9627,8.9627,0,0,0,22.7168,13.249ZM18,26.2627l-4-2.6665-4,2.6665V19.05a8.9238,8.9238,0,0,0,8,.0062Z"}),props.children);});var Bar32=/*#__PURE__*/React.forwardRef(function Bar32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,11H15a1,1,0,0,0-1,1v4a6.0046,6.0046,0,0,0,5,5.91V28H16v2h8V28H21V21.91A6.0046,6.0046,0,0,0,26,16V12A1,1,0,0,0,25,11Zm-1,5a4,4,0,0,1-8,0V13h8Z"}),React.createElement("path",{d:"M15,1H10A1,1,0,0,0,9,2V9.3706A6.09,6.09,0,0,0,6,15V29a1,1,0,0,0,1,1h5V28H8V15c0-3.1875,2.231-4.02,2.3164-4.0513L11,10.7207V3h3V8h2V2A1,1,0,0,0,15,1Z"}),props.children);});var Bar24=/*#__PURE__*/React.forwardRef(function Bar24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,11H15a1,1,0,0,0-1,1v4a6.0046,6.0046,0,0,0,5,5.91V28H16v2h8V28H21V21.91A6.0046,6.0046,0,0,0,26,16V12A1,1,0,0,0,25,11Zm-1,5a4,4,0,0,1-8,0V13h8Z"}),React.createElement("path",{d:"M15,1H10A1,1,0,0,0,9,2V9.3706A6.09,6.09,0,0,0,6,15V29a1,1,0,0,0,1,1h5V28H8V15c0-3.1875,2.231-4.02,2.3164-4.0513L11,10.7207V3h3V8h2V2A1,1,0,0,0,15,1Z"}),props.children);});var Bar20=/*#__PURE__*/React.forwardRef(function Bar20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,11H15a1,1,0,0,0-1,1v4a6.0046,6.0046,0,0,0,5,5.91V28H16v2h8V28H21V21.91A6.0046,6.0046,0,0,0,26,16V12A1,1,0,0,0,25,11Zm-1,5a4,4,0,0,1-8,0V13h8Z"}),React.createElement("path",{d:"M15,1H10A1,1,0,0,0,9,2V9.3706A6.09,6.09,0,0,0,6,15V29a1,1,0,0,0,1,1h5V28H8V15c0-3.1875,2.231-4.02,2.3164-4.0513L11,10.7207V3h3V8h2V2A1,1,0,0,0,15,1Z"}),props.children);});var Bar16=/*#__PURE__*/React.forwardRef(function Bar16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,11H15a1,1,0,0,0-1,1v4a6.0046,6.0046,0,0,0,5,5.91V28H16v2h8V28H21V21.91A6.0046,6.0046,0,0,0,26,16V12A1,1,0,0,0,25,11Zm-1,5a4,4,0,0,1-8,0V13h8Z"}),React.createElement("path",{d:"M15,1H10A1,1,0,0,0,9,2V9.3706A6.09,6.09,0,0,0,6,15V29a1,1,0,0,0,1,1h5V28H8V15c0-3.1875,2.231-4.02,2.3164-4.0513L11,10.7207V3h3V8h2V2A1,1,0,0,0,15,1Z"}),props.children);});var Basketball32=/*#__PURE__*/React.forwardRef(function Basketball32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9492,15H22.041a14.4088,14.4088,0,0,1,2.7383-7.1533A11.9392,11.9392,0,0,1,27.9492,15ZM17,15V4.0508a11.9181,11.9181,0,0,1,6.2874,2.4375A16.2646,16.2646,0,0,0,20.04,15Zm-2,0H11.96A16.2646,16.2646,0,0,0,8.7126,6.4883,11.9181,11.9181,0,0,1,15,4.0508Zm0,2V27.9492a11.9181,11.9181,0,0,1-6.2874-2.4375A16.2646,16.2646,0,0,0,11.96,17Zm2,0h3.04a16.2646,16.2646,0,0,0,3.2476,8.5117A11.9181,11.9181,0,0,1,17,27.9492ZM7.2207,7.8467A14.4088,14.4088,0,0,1,9.959,15H4.0508A11.9392,11.9392,0,0,1,7.2207,7.8467ZM4.0508,17H9.959a14.4088,14.4088,0,0,1-2.7383,7.1533A11.9392,11.9392,0,0,1,4.0508,17Zm20.7285,7.1533A14.4088,14.4088,0,0,1,22.041,17h5.9082A11.9392,11.9392,0,0,1,24.7793,24.1533Z"}),props.children);});var Basketball24=/*#__PURE__*/React.forwardRef(function Basketball24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9492,15H22.041a14.4088,14.4088,0,0,1,2.7383-7.1533A11.9392,11.9392,0,0,1,27.9492,15ZM17,15V4.0508a11.9181,11.9181,0,0,1,6.2874,2.4375A16.2646,16.2646,0,0,0,20.04,15Zm-2,0H11.96A16.2646,16.2646,0,0,0,8.7126,6.4883,11.9181,11.9181,0,0,1,15,4.0508Zm0,2V27.9492a11.9181,11.9181,0,0,1-6.2874-2.4375A16.2646,16.2646,0,0,0,11.96,17Zm2,0h3.04a16.2646,16.2646,0,0,0,3.2476,8.5117A11.9181,11.9181,0,0,1,17,27.9492ZM7.2207,7.8467A14.4088,14.4088,0,0,1,9.959,15H4.0508A11.9392,11.9392,0,0,1,7.2207,7.8467ZM4.0508,17H9.959a14.4088,14.4088,0,0,1-2.7383,7.1533A11.9392,11.9392,0,0,1,4.0508,17Zm20.7285,7.1533A14.4088,14.4088,0,0,1,22.041,17h5.9082A11.9392,11.9392,0,0,1,24.7793,24.1533Z"}),props.children);});var Basketball20=/*#__PURE__*/React.forwardRef(function Basketball20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9492,15H22.041a14.4088,14.4088,0,0,1,2.7383-7.1533A11.9392,11.9392,0,0,1,27.9492,15ZM17,15V4.0508a11.9181,11.9181,0,0,1,6.2874,2.4375A16.2646,16.2646,0,0,0,20.04,15Zm-2,0H11.96A16.2646,16.2646,0,0,0,8.7126,6.4883,11.9181,11.9181,0,0,1,15,4.0508Zm0,2V27.9492a11.9181,11.9181,0,0,1-6.2874-2.4375A16.2646,16.2646,0,0,0,11.96,17Zm2,0h3.04a16.2646,16.2646,0,0,0,3.2476,8.5117A11.9181,11.9181,0,0,1,17,27.9492ZM7.2207,7.8467A14.4088,14.4088,0,0,1,9.959,15H4.0508A11.9392,11.9392,0,0,1,7.2207,7.8467ZM4.0508,17H9.959a14.4088,14.4088,0,0,1-2.7383,7.1533A11.9392,11.9392,0,0,1,4.0508,17Zm20.7285,7.1533A14.4088,14.4088,0,0,1,22.041,17h5.9082A11.9392,11.9392,0,0,1,24.7793,24.1533Z"}),props.children);});var Basketball16=/*#__PURE__*/React.forwardRef(function Basketball16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM27.9492,15H22.041a14.4088,14.4088,0,0,1,2.7383-7.1533A11.9392,11.9392,0,0,1,27.9492,15ZM17,15V4.0508a11.9181,11.9181,0,0,1,6.2874,2.4375A16.2646,16.2646,0,0,0,20.04,15Zm-2,0H11.96A16.2646,16.2646,0,0,0,8.7126,6.4883,11.9181,11.9181,0,0,1,15,4.0508Zm0,2V27.9492a11.9181,11.9181,0,0,1-6.2874-2.4375A16.2646,16.2646,0,0,0,11.96,17Zm2,0h3.04a16.2646,16.2646,0,0,0,3.2476,8.5117A11.9181,11.9181,0,0,1,17,27.9492ZM7.2207,7.8467A14.4088,14.4088,0,0,1,9.959,15H4.0508A11.9392,11.9392,0,0,1,7.2207,7.8467ZM4.0508,17H9.959a14.4088,14.4088,0,0,1-2.7383,7.1533A11.9392,11.9392,0,0,1,4.0508,17Zm20.7285,7.1533A14.4088,14.4088,0,0,1,22.041,17h5.9082A11.9392,11.9392,0,0,1,24.7793,24.1533Z"}),props.children);});var BatteryCharging32=/*#__PURE__*/React.forwardRef(function BatteryCharging32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,11H26V10a2,2,0,0,0-2-2H20v2h4v3h3v6H24v3H19v2h5a2,2,0,0,0,2-2V21h1a2,2,0,0,0,2-2V13A2,2,0,0,0,27,11Z"}),React.createElement("path",{d:"M11,22H6V10h6V8H6a2,2,0,0,0-2,2V22a2,2,0,0,0,2,2h5Z"}),React.createElement("polygon",{points:"14.81 23.58 13.19 22.42 17.06 17 9.37 17 16.22 8.38 17.78 9.62 13.51 15 20.94 15 14.81 23.58"}),props.children);});var BatteryCharging24=/*#__PURE__*/React.forwardRef(function BatteryCharging24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,11H26V10a2,2,0,0,0-2-2H20v2h4v3h3v6H24v3H19v2h5a2,2,0,0,0,2-2V21h1a2,2,0,0,0,2-2V13A2,2,0,0,0,27,11Z"}),React.createElement("path",{d:"M11,22H6V10h6V8H6a2,2,0,0,0-2,2V22a2,2,0,0,0,2,2h5Z"}),React.createElement("polygon",{points:"14.81 23.58 13.19 22.42 17.06 17 9.37 17 16.22 8.38 17.78 9.62 13.51 15 20.94 15 14.81 23.58"}),props.children);});var BatteryCharging20=/*#__PURE__*/React.forwardRef(function BatteryCharging20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,11H26V10a2,2,0,0,0-2-2H20v2h4v3h3v6H24v3H19v2h5a2,2,0,0,0,2-2V21h1a2,2,0,0,0,2-2V13A2,2,0,0,0,27,11Z"}),React.createElement("path",{d:"M11,22H6V10h6V8H6a2,2,0,0,0-2,2V22a2,2,0,0,0,2,2h5Z"}),React.createElement("polygon",{points:"14.81 23.58 13.19 22.42 17.06 17 9.37 17 16.22 8.38 17.78 9.62 13.51 15 20.94 15 14.81 23.58"}),props.children);});var BatteryCharging16=/*#__PURE__*/React.forwardRef(function BatteryCharging16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,11H26V10a2,2,0,0,0-2-2H20v2h4v3h3v6H24v3H19v2h5a2,2,0,0,0,2-2V21h1a2,2,0,0,0,2-2V13A2,2,0,0,0,27,11Z"}),React.createElement("path",{d:"M11,22H6V10h6V8H6a2,2,0,0,0-2,2V22a2,2,0,0,0,2,2h5Z"}),React.createElement("polygon",{points:"14.81 23.58 13.19 22.42 17.06 17 9.37 17 16.22 8.38 17.78 9.62 13.51 15 20.94 15 14.81 23.58"}),props.children);});var BatteryEmpty32=/*#__PURE__*/React.forwardRef(function BatteryEmpty32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),props.children);});var BatteryEmpty24=/*#__PURE__*/React.forwardRef(function BatteryEmpty24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),props.children);});var BatteryEmpty20=/*#__PURE__*/React.forwardRef(function BatteryEmpty20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),props.children);});var BatteryEmpty16=/*#__PURE__*/React.forwardRef(function BatteryEmpty16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),props.children);});var BatteryFull32=/*#__PURE__*/React.forwardRef(function BatteryFull32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"14",x:"11",y:"9",transform:"rotate(90 15 16)"}),props.children);});var BatteryFull24=/*#__PURE__*/React.forwardRef(function BatteryFull24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"14",x:"11",y:"9",transform:"rotate(90 15 16)"}),props.children);});var BatteryFull20=/*#__PURE__*/React.forwardRef(function BatteryFull20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"14",x:"11",y:"9",transform:"rotate(90 15 16)"}),props.children);});var BatteryFull16=/*#__PURE__*/React.forwardRef(function BatteryFull16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"14",x:"11",y:"9",transform:"rotate(90 15 16)"}),props.children);});var BatteryHalf32=/*#__PURE__*/React.forwardRef(function BatteryHalf32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"8",x:"8",y:"12",transform:"rotate(90 12 16)"}),props.children);});var BatteryHalf24=/*#__PURE__*/React.forwardRef(function BatteryHalf24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"8",x:"8",y:"12",transform:"rotate(90 12 16)"}),props.children);});var BatteryHalf20=/*#__PURE__*/React.forwardRef(function BatteryHalf20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"8",x:"8",y:"12",transform:"rotate(90 12 16)"}),props.children);});var BatteryHalf16=/*#__PURE__*/React.forwardRef(function BatteryHalf16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2,2,0,0,1-2-2V10A2,2,0,0,1,6,8H24a2,2,0,0,1,2,2v1h1a2,2,0,0,1,2,2v6a2,2,0,0,1-2,2H26v1A2,2,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"8",x:"8",y:"12",transform:"rotate(90 12 16)"}),props.children);});var BatteryLow32=/*#__PURE__*/React.forwardRef(function BatteryLow32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"2",x:"5",y:"15",transform:"rotate(90 9 16)"}),props.children);});var BatteryLow24=/*#__PURE__*/React.forwardRef(function BatteryLow24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"2",x:"5",y:"15",transform:"rotate(90 9 16)"}),props.children);});var BatteryLow20=/*#__PURE__*/React.forwardRef(function BatteryLow20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"2",x:"5",y:"15",transform:"rotate(90 9 16)"}),props.children);});var BatteryLow16=/*#__PURE__*/React.forwardRef(function BatteryLow16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"2",x:"5",y:"15",transform:"rotate(90 9 16)"}),props.children);});var BatteryQuarter32=/*#__PURE__*/React.forwardRef(function BatteryQuarter32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"4",x:"6",y:"14",transform:"rotate(90 10 16)"}),props.children);});var BatteryQuarter24=/*#__PURE__*/React.forwardRef(function BatteryQuarter24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"4",x:"6",y:"14",transform:"rotate(90 10 16)"}),props.children);});var BatteryQuarter20=/*#__PURE__*/React.forwardRef(function BatteryQuarter20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"4",x:"6",y:"14",transform:"rotate(90 10 16)"}),props.children);});var BatteryQuarter16=/*#__PURE__*/React.forwardRef(function BatteryQuarter16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24H6a2.0023,2.0023,0,0,1-2-2V10A2.002,2.002,0,0,1,6,8H24a2.0023,2.0023,0,0,1,2,2v1h1a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H26v1A2.0027,2.0027,0,0,1,24,24ZM6,10V22H24V19h3V13H24V10Z"}),React.createElement("rect",{width:"8",height:"4",x:"6",y:"14",transform:"rotate(90 10 16)"}),props.children);});var Bee32=/*#__PURE__*/React.forwardRef(function Bee32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,10a6,6,0,0,0-6,6v8a6,6,0,0,0,12,0V16A6,6,0,0,0,16,10Zm-4.25,7.87h8.5v4.25h-8.5ZM16,28.25A4.27,4.27,0,0,1,11.75,24v-.13h8.5V24A4.27,4.27,0,0,1,16,28.25Zm4.25-12.13h-8.5V16a4.25,4.25,0,0,1,8.5,0Z"}),React.createElement("path",{d:"M30.66,19.21,24,13v9.1a4,4,0,0,0,8,0A3.83,3.83,0,0,0,30.66,19.21ZM28,24.35a2.25,2.25,0,0,1-2.25-2.25V17l3.72,3.47h0A2.05,2.05,0,0,1,30.2,22,2.25,2.25,0,0,1,28,24.35Z"}),React.createElement("path",{d:"M0,22.1a4,4,0,0,0,8,0V13L1.34,19.21A3.88,3.88,0,0,0,0,22.1Zm2.48-1.56h0L6.25,17v5.1a2.25,2.25,0,0,1-4.5,0A2.05,2.05,0,0,1,2.48,20.54Z"}),React.createElement("path",{d:"M15,5.5A3.5,3.5,0,1,0,11.5,9,3.5,3.5,0,0,0,15,5.5Zm-5.25,0A1.75,1.75,0,1,1,11.5,7.25,1.77,1.77,0,0,1,9.75,5.5Z"}),React.createElement("path",{d:"M20.5,2A3.5,3.5,0,1,0,24,5.5,3.5,3.5,0,0,0,20.5,2Zm0,5.25A1.75,1.75,0,1,1,22.25,5.5,1.77,1.77,0,0,1,20.5,7.25Z"}),props.children);});var Bee24=/*#__PURE__*/React.forwardRef(function Bee24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,10a6,6,0,0,0-6,6v8a6,6,0,0,0,12,0V16A6,6,0,0,0,16,10Zm-4.25,7.87h8.5v4.25h-8.5ZM16,28.25A4.27,4.27,0,0,1,11.75,24v-.13h8.5V24A4.27,4.27,0,0,1,16,28.25Zm4.25-12.13h-8.5V16a4.25,4.25,0,0,1,8.5,0Z"}),React.createElement("path",{d:"M30.66,19.21,24,13v9.1a4,4,0,0,0,8,0A3.83,3.83,0,0,0,30.66,19.21ZM28,24.35a2.25,2.25,0,0,1-2.25-2.25V17l3.72,3.47h0A2.05,2.05,0,0,1,30.2,22,2.25,2.25,0,0,1,28,24.35Z"}),React.createElement("path",{d:"M0,22.1a4,4,0,0,0,8,0V13L1.34,19.21A3.88,3.88,0,0,0,0,22.1Zm2.48-1.56h0L6.25,17v5.1a2.25,2.25,0,0,1-4.5,0A2.05,2.05,0,0,1,2.48,20.54Z"}),React.createElement("path",{d:"M15,5.5A3.5,3.5,0,1,0,11.5,9,3.5,3.5,0,0,0,15,5.5Zm-5.25,0A1.75,1.75,0,1,1,11.5,7.25,1.77,1.77,0,0,1,9.75,5.5Z"}),React.createElement("path",{d:"M20.5,2A3.5,3.5,0,1,0,24,5.5,3.5,3.5,0,0,0,20.5,2Zm0,5.25A1.75,1.75,0,1,1,22.25,5.5,1.77,1.77,0,0,1,20.5,7.25Z"}),props.children);});var Bee20=/*#__PURE__*/React.forwardRef(function Bee20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,10a6,6,0,0,0-6,6v8a6,6,0,0,0,12,0V16A6,6,0,0,0,16,10Zm-4.25,7.87h8.5v4.25h-8.5ZM16,28.25A4.27,4.27,0,0,1,11.75,24v-.13h8.5V24A4.27,4.27,0,0,1,16,28.25Zm4.25-12.13h-8.5V16a4.25,4.25,0,0,1,8.5,0Z"}),React.createElement("path",{d:"M30.66,19.21,24,13v9.1a4,4,0,0,0,8,0A3.83,3.83,0,0,0,30.66,19.21ZM28,24.35a2.25,2.25,0,0,1-2.25-2.25V17l3.72,3.47h0A2.05,2.05,0,0,1,30.2,22,2.25,2.25,0,0,1,28,24.35Z"}),React.createElement("path",{d:"M0,22.1a4,4,0,0,0,8,0V13L1.34,19.21A3.88,3.88,0,0,0,0,22.1Zm2.48-1.56h0L6.25,17v5.1a2.25,2.25,0,0,1-4.5,0A2.05,2.05,0,0,1,2.48,20.54Z"}),React.createElement("path",{d:"M15,5.5A3.5,3.5,0,1,0,11.5,9,3.5,3.5,0,0,0,15,5.5Zm-5.25,0A1.75,1.75,0,1,1,11.5,7.25,1.77,1.77,0,0,1,9.75,5.5Z"}),React.createElement("path",{d:"M20.5,2A3.5,3.5,0,1,0,24,5.5,3.5,3.5,0,0,0,20.5,2Zm0,5.25A1.75,1.75,0,1,1,22.25,5.5,1.77,1.77,0,0,1,20.5,7.25Z"}),props.children);});var Bee16=/*#__PURE__*/React.forwardRef(function Bee16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,10a6,6,0,0,0-6,6v8a6,6,0,0,0,12,0V16A6,6,0,0,0,16,10Zm-4.25,7.87h8.5v4.25h-8.5ZM16,28.25A4.27,4.27,0,0,1,11.75,24v-.13h8.5V24A4.27,4.27,0,0,1,16,28.25Zm4.25-12.13h-8.5V16a4.25,4.25,0,0,1,8.5,0Z"}),React.createElement("path",{d:"M30.66,19.21,24,13v9.1a4,4,0,0,0,8,0A3.83,3.83,0,0,0,30.66,19.21ZM28,24.35a2.25,2.25,0,0,1-2.25-2.25V17l3.72,3.47h0A2.05,2.05,0,0,1,30.2,22,2.25,2.25,0,0,1,28,24.35Z"}),React.createElement("path",{d:"M0,22.1a4,4,0,0,0,8,0V13L1.34,19.21A3.88,3.88,0,0,0,0,22.1Zm2.48-1.56h0L6.25,17v5.1a2.25,2.25,0,0,1-4.5,0A2.05,2.05,0,0,1,2.48,20.54Z"}),React.createElement("path",{d:"M15,5.5A3.5,3.5,0,1,0,11.5,9,3.5,3.5,0,0,0,15,5.5Zm-5.25,0A1.75,1.75,0,1,1,11.5,7.25,1.77,1.77,0,0,1,9.75,5.5Z"}),React.createElement("path",{d:"M20.5,2A3.5,3.5,0,1,0,24,5.5,3.5,3.5,0,0,0,20.5,2Zm0,5.25A1.75,1.75,0,1,1,22.25,5.5,1.77,1.77,0,0,1,20.5,7.25Z"}),props.children);});var Bicycle32=/*#__PURE__*/React.forwardRef(function Bicycle32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,16c-.0879,0-.1731.0093-.26.0132L24.2368,9H28V7H23a1,1,0,0,0-.978,1.21L22.62,11H12.3872l-1-3H14V6H7V8H9.28l1.0411,3.123-2.57,5.1392A6,6,0,1,0,11.91,23h2.61a1.991,1.991,0,0,0,1.5616-.75L23.14,13.4258l.6436,3.0039A5.9891,5.9891,0,1,0,26,16ZM6,26a4,4,0,1,1,.8364-7.9092L5.1055,21.5527l.009.0044A.9834.9834,0,0,0,5,22a.9931.9931,0,0,0,1.8853.4429l.0092.0044L8.6182,19A3.9835,3.9835,0,0,1,6,26Zm5.91-5a5.9986,5.9986,0,0,0-2.3733-3.8364l1.6787-3.3574L13.613,21Zm3.4577-1.06L13.054,13h7.8654ZM26,26a3.9882,3.9882,0,0,1-1.7859-7.56l.8079,3.77.02-.0044A.9859.9859,0,0,0,26,23a1,1,0,0,0,1-1,.9456.9456,0,0,0-.0415-.2056l.02-.0044-.8086-3.7729A3.9931,3.9931,0,0,1,26,26Z"}),props.children);});var Bicycle24=/*#__PURE__*/React.forwardRef(function Bicycle24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,16c-.0879,0-.1731.0093-.26.0132L24.2368,9H28V7H23a1,1,0,0,0-.978,1.21L22.62,11H12.3872l-1-3H14V6H7V8H9.28l1.0411,3.123-2.57,5.1392A6,6,0,1,0,11.91,23h2.61a1.991,1.991,0,0,0,1.5616-.75L23.14,13.4258l.6436,3.0039A5.9891,5.9891,0,1,0,26,16ZM6,26a4,4,0,1,1,.8364-7.9092L5.1055,21.5527l.009.0044A.9834.9834,0,0,0,5,22a.9931.9931,0,0,0,1.8853.4429l.0092.0044L8.6182,19A3.9835,3.9835,0,0,1,6,26Zm5.91-5a5.9986,5.9986,0,0,0-2.3733-3.8364l1.6787-3.3574L13.613,21Zm3.4577-1.06L13.054,13h7.8654ZM26,26a3.9882,3.9882,0,0,1-1.7859-7.56l.8079,3.77.02-.0044A.9859.9859,0,0,0,26,23a1,1,0,0,0,1-1,.9456.9456,0,0,0-.0415-.2056l.02-.0044-.8086-3.7729A3.9931,3.9931,0,0,1,26,26Z"}),props.children);});var Bicycle20=/*#__PURE__*/React.forwardRef(function Bicycle20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,16c-.0879,0-.1731.0093-.26.0132L24.2368,9H28V7H23a1,1,0,0,0-.978,1.21L22.62,11H12.3872l-1-3H14V6H7V8H9.28l1.0411,3.123-2.57,5.1392A6,6,0,1,0,11.91,23h2.61a1.991,1.991,0,0,0,1.5616-.75L23.14,13.4258l.6436,3.0039A5.9891,5.9891,0,1,0,26,16ZM6,26a4,4,0,1,1,.8364-7.9092L5.1055,21.5527l.009.0044A.9834.9834,0,0,0,5,22a.9931.9931,0,0,0,1.8853.4429l.0092.0044L8.6182,19A3.9835,3.9835,0,0,1,6,26Zm5.91-5a5.9986,5.9986,0,0,0-2.3733-3.8364l1.6787-3.3574L13.613,21Zm3.4577-1.06L13.054,13h7.8654ZM26,26a3.9882,3.9882,0,0,1-1.7859-7.56l.8079,3.77.02-.0044A.9859.9859,0,0,0,26,23a1,1,0,0,0,1-1,.9456.9456,0,0,0-.0415-.2056l.02-.0044-.8086-3.7729A3.9931,3.9931,0,0,1,26,26Z"}),props.children);});var Bicycle16=/*#__PURE__*/React.forwardRef(function Bicycle16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,16c-.0879,0-.1731.0093-.26.0132L24.2368,9H28V7H23a1,1,0,0,0-.978,1.21L22.62,11H12.3872l-1-3H14V6H7V8H9.28l1.0411,3.123-2.57,5.1392A6,6,0,1,0,11.91,23h2.61a1.991,1.991,0,0,0,1.5616-.75L23.14,13.4258l.6436,3.0039A5.9891,5.9891,0,1,0,26,16ZM6,26a4,4,0,1,1,.8364-7.9092L5.1055,21.5527l.009.0044A.9834.9834,0,0,0,5,22a.9931.9931,0,0,0,1.8853.4429l.0092.0044L8.6182,19A3.9835,3.9835,0,0,1,6,26Zm5.91-5a5.9986,5.9986,0,0,0-2.3733-3.8364l1.6787-3.3574L13.613,21Zm3.4577-1.06L13.054,13h7.8654ZM26,26a3.9882,3.9882,0,0,1-1.7859-7.56l.8079,3.77.02-.0044A.9859.9859,0,0,0,26,23a1,1,0,0,0,1-1,.9456.9456,0,0,0-.0415-.2056l.02-.0044-.8086-3.7729A3.9931,3.9931,0,0,1,26,26Z"}),props.children);});var Binoculars32=/*#__PURE__*/React.forwardRef(function Binoculars32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,8V5a1,1,0,0,0-1-1H21a1,1,0,0,0-1,1V8a2,2,0,0,0-2,2v2H14V10a2,2,0,0,0-2-2V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V8a2,2,0,0,0-2,2V22a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,14,22V20h4v2a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,30,22V10A2,2,0,0,0,28,8ZM11,26H5V24h6Zm1-4H4V10H6V6h4v4h2Zm2-4V14h4v4Zm13,8H21V24h6Zm1-4H20V10h2V6h4v4h2Z"}),props.children);});var Binoculars24=/*#__PURE__*/React.forwardRef(function Binoculars24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,8V5a1,1,0,0,0-1-1H21a1,1,0,0,0-1,1V8a2,2,0,0,0-2,2v2H14V10a2,2,0,0,0-2-2V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V8a2,2,0,0,0-2,2V22a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,14,22V20h4v2a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,30,22V10A2,2,0,0,0,28,8ZM11,26H5V24h6Zm1-4H4V10H6V6h4v4h2Zm2-4V14h4v4Zm13,8H21V24h6Zm1-4H20V10h2V6h4v4h2Z"}),props.children);});var Binoculars20=/*#__PURE__*/React.forwardRef(function Binoculars20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,8V5a1,1,0,0,0-1-1H21a1,1,0,0,0-1,1V8a2,2,0,0,0-2,2v2H14V10a2,2,0,0,0-2-2V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V8a2,2,0,0,0-2,2V22a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,14,22V20h4v2a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,30,22V10A2,2,0,0,0,28,8ZM11,26H5V24h6Zm1-4H4V10H6V6h4v4h2Zm2-4V14h4v4Zm13,8H21V24h6Zm1-4H20V10h2V6h4v4h2Z"}),props.children);});var Binoculars16=/*#__PURE__*/React.forwardRef(function Binoculars16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,8V5a1,1,0,0,0-1-1H21a1,1,0,0,0-1,1V8a2,2,0,0,0-2,2v2H14V10a2,2,0,0,0-2-2V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V8a2,2,0,0,0-2,2V22a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,14,22V20h4v2a2,2,0,0,0,1,1.72V27a1,1,0,0,0,1,1h8a1,1,0,0,0,1-1V23.72A2,2,0,0,0,30,22V10A2,2,0,0,0,28,8ZM11,26H5V24h6Zm1-4H4V10H6V6h4v4h2Zm2-4V14h4v4Zm13,8H21V24h6Zm1-4H20V10h2V6h4v4h2Z"}),props.children);});var Blockchain32=/*#__PURE__*/React.forwardRef(function Blockchain32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,24H4V8H6ZM28,8H26V24h2ZM24,6V4H8V6Zm0,22V26H8v2Z"}),props.children);});var Blockchain24=/*#__PURE__*/React.forwardRef(function Blockchain24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,24H4V8H6ZM28,8H26V24h2ZM24,6V4H8V6Zm0,22V26H8v2Z"}),props.children);});var Blockchain20=/*#__PURE__*/React.forwardRef(function Blockchain20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,24H4V8H6ZM28,8H26V24h2ZM24,6V4H8V6Zm0,22V26H8v2Z"}),props.children);});var Blockchain16=/*#__PURE__*/React.forwardRef(function Blockchain16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,24H4V8H6ZM28,8H26V24h2ZM24,6V4H8V6Zm0,22V26H8v2Z"}),props.children);});var Blog32=/*#__PURE__*/React.forwardRef(function Blog32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"10",height:"2",x:"4",y:"24"}),React.createElement("rect",{width:"10",height:"2",x:"4",y:"18"}),React.createElement("path",{d:"M26,14H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H26a2,2,0,0,1,2,2v6A2,2,0,0,1,26,14ZM6,6v6H26V6Z"}),React.createElement("path",{d:"M26,28H20a2,2,0,0,1-2-2V20a2,2,0,0,1,2-2h6a2,2,0,0,1,2,2v6A2,2,0,0,1,26,28Zm-6-8v6h6V20Z"}),props.children);});var Blog24=/*#__PURE__*/React.forwardRef(function Blog24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"10",height:"2",x:"4",y:"24"}),React.createElement("rect",{width:"10",height:"2",x:"4",y:"18"}),React.createElement("path",{d:"M26,14H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H26a2,2,0,0,1,2,2v6A2,2,0,0,1,26,14ZM6,6v6H26V6Z"}),React.createElement("path",{d:"M26,28H20a2,2,0,0,1-2-2V20a2,2,0,0,1,2-2h6a2,2,0,0,1,2,2v6A2,2,0,0,1,26,28Zm-6-8v6h6V20Z"}),props.children);});var Blog20=/*#__PURE__*/React.forwardRef(function Blog20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"10",height:"2",x:"4",y:"24"}),React.createElement("rect",{width:"10",height:"2",x:"4",y:"18"}),React.createElement("path",{d:"M26,14H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H26a2,2,0,0,1,2,2v6A2,2,0,0,1,26,14ZM6,6v6H26V6Z"}),React.createElement("path",{d:"M26,28H20a2,2,0,0,1-2-2V20a2,2,0,0,1,2-2h6a2,2,0,0,1,2,2v6A2,2,0,0,1,26,28Zm-6-8v6h6V20Z"}),props.children);});var Blog16=/*#__PURE__*/React.forwardRef(function Blog16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"10",height:"2",x:"4",y:"24"}),React.createElement("rect",{width:"10",height:"2",x:"4",y:"18"}),React.createElement("path",{d:"M26,14H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H26a2,2,0,0,1,2,2v6A2,2,0,0,1,26,14ZM6,6v6H26V6Z"}),React.createElement("path",{d:"M26,28H20a2,2,0,0,1-2-2V20a2,2,0,0,1,2-2h6a2,2,0,0,1,2,2v6A2,2,0,0,1,26,28Zm-6-8v6h6V20Z"}),props.children);});var BluetoothOff32=/*#__PURE__*/React.forwardRef(function BluetoothOff32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,26.59,5.41,4,4,5.41,14.59,16,7,23.59,8.41,25,15,18.41V29a1,1,0,0,0,.58.91A1.06,1.06,0,0,0,16,30a1,1,0,0,0,.65-.24l6.3-5.4L26.59,28Zm-11,.24V18.41l4.53,4.53Z"}),React.createElement("path",{d:"M17,12.75V5.17l4.53,3.89-4.11,4.11,1.41,1.41,4.88-4.87A1,1,0,0,0,24,9a1,1,0,0,0-.35-.72l-7-6a1,1,0,0,0-1.07-.15A1,1,0,0,0,15,3v7.75Z"}),props.children);});var BluetoothOff24=/*#__PURE__*/React.forwardRef(function BluetoothOff24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,26.59,5.41,4,4,5.41,14.59,16,7,23.59,8.41,25,15,18.41V29a1,1,0,0,0,.58.91A1.06,1.06,0,0,0,16,30a1,1,0,0,0,.65-.24l6.3-5.4L26.59,28Zm-11,.24V18.41l4.53,4.53Z"}),React.createElement("path",{d:"M17,12.75V5.17l4.53,3.89-4.11,4.11,1.41,1.41,4.88-4.87A1,1,0,0,0,24,9a1,1,0,0,0-.35-.72l-7-6a1,1,0,0,0-1.07-.15A1,1,0,0,0,15,3v7.75Z"}),props.children);});var BluetoothOff20=/*#__PURE__*/React.forwardRef(function BluetoothOff20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,26.59,5.41,4,4,5.41,14.59,16,7,23.59,8.41,25,15,18.41V29a1,1,0,0,0,.58.91A1.06,1.06,0,0,0,16,30a1,1,0,0,0,.65-.24l6.3-5.4L26.59,28Zm-11,.24V18.41l4.53,4.53Z"}),React.createElement("path",{d:"M17,12.75V5.17l4.53,3.89-4.11,4.11,1.41,1.41,4.88-4.87A1,1,0,0,0,24,9a1,1,0,0,0-.35-.72l-7-6a1,1,0,0,0-1.07-.15A1,1,0,0,0,15,3v7.75Z"}),props.children);});var BluetoothOff16=/*#__PURE__*/React.forwardRef(function BluetoothOff16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,26.59,5.41,4,4,5.41,14.59,16,7,23.59,8.41,25,15,18.41V29a1,1,0,0,0,.58.91A1.06,1.06,0,0,0,16,30a1,1,0,0,0,.65-.24l6.3-5.4L26.59,28Zm-11,.24V18.41l4.53,4.53Z"}),React.createElement("path",{d:"M17,12.75V5.17l4.53,3.89-4.11,4.11,1.41,1.41,4.88-4.87A1,1,0,0,0,24,9a1,1,0,0,0-.35-.72l-7-6a1,1,0,0,0-1.07-.15A1,1,0,0,0,15,3v7.75Z"}),props.children);});var Bluetooth32=/*#__PURE__*/React.forwardRef(function Bluetooth32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,30a1.06,1.06,0,0,1-.42-.09A1,1,0,0,1,15,29V18.41L8.41,25,7,23.59,14.59,16,7,8.41,8.41,7,15,13.59V3a1,1,0,0,1,.58-.91,1,1,0,0,1,1.07.15l7,6A1,1,0,0,1,24,9a1,1,0,0,1-.29.75L17.41,16l6.3,6.29A1,1,0,0,1,24,23a1,1,0,0,1-.35.72l-7,6A1,1,0,0,1,16,30Zm1-11.59v8.42l4.53-3.89ZM17,5.17v8.42l4.53-4.53Z"}),props.children);});var Bluetooth24=/*#__PURE__*/React.forwardRef(function Bluetooth24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,30a1.06,1.06,0,0,1-.42-.09A1,1,0,0,1,15,29V18.41L8.41,25,7,23.59,14.59,16,7,8.41,8.41,7,15,13.59V3a1,1,0,0,1,.58-.91,1,1,0,0,1,1.07.15l7,6A1,1,0,0,1,24,9a1,1,0,0,1-.29.75L17.41,16l6.3,6.29A1,1,0,0,1,24,23a1,1,0,0,1-.35.72l-7,6A1,1,0,0,1,16,30Zm1-11.59v8.42l4.53-3.89ZM17,5.17v8.42l4.53-4.53Z"}),props.children);});var Bluetooth20=/*#__PURE__*/React.forwardRef(function Bluetooth20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,30a1.06,1.06,0,0,1-.42-.09A1,1,0,0,1,15,29V18.41L8.41,25,7,23.59,14.59,16,7,8.41,8.41,7,15,13.59V3a1,1,0,0,1,.58-.91,1,1,0,0,1,1.07.15l7,6A1,1,0,0,1,24,9a1,1,0,0,1-.29.75L17.41,16l6.3,6.29A1,1,0,0,1,24,23a1,1,0,0,1-.35.72l-7,6A1,1,0,0,1,16,30Zm1-11.59v8.42l4.53-3.89ZM17,5.17v8.42l4.53-4.53Z"}),props.children);});var Bluetooth16=/*#__PURE__*/React.forwardRef(function Bluetooth16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,30a1.06,1.06,0,0,1-.42-.09A1,1,0,0,1,15,29V18.41L8.41,25,7,23.59,14.59,16,7,8.41,8.41,7,15,13.59V3a1,1,0,0,1,.58-.91,1,1,0,0,1,1.07.15l7,6A1,1,0,0,1,24,9a1,1,0,0,1-.29.75L17.41,16l6.3,6.29A1,1,0,0,1,24,23a1,1,0,0,1-.35.72l-7,6A1,1,0,0,1,16,30Zm1-11.59v8.42l4.53-3.89ZM17,5.17v8.42l4.53-4.53Z"}),props.children);});var Bookmark32=/*#__PURE__*/React.forwardRef(function Bookmark32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,4V26.75l-7.1-3.59-.9-.45-.9.45L8,26.75V4H24m0-2H8A2,2,0,0,0,6,4V30L16,25,26,30V4A2,2,0,0,0,24,2Z"}),props.children);});var Bookmark24=/*#__PURE__*/React.forwardRef(function Bookmark24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,4V26.75l-7.1-3.59-.9-.45-.9.45L8,26.75V4H24m0-2H8A2,2,0,0,0,6,4V30L16,25,26,30V4A2,2,0,0,0,24,2Z"}),props.children);});var Bookmark20=/*#__PURE__*/React.forwardRef(function Bookmark20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,4V26.75l-7.1-3.59-.9-.45-.9.45L8,26.75V4H24m0-2H8A2,2,0,0,0,6,4V30L16,25,26,30V4A2,2,0,0,0,24,2Z"}),props.children);});var Bookmark16=/*#__PURE__*/React.forwardRef(function Bookmark16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,4V26.75l-7.1-3.59-.9-.45-.9.45L8,26.75V4H24m0-2H8A2,2,0,0,0,6,4V30L16,25,26,30V4A2,2,0,0,0,24,2Z"}),props.children);});var Box32=/*#__PURE__*/React.forwardRef(function Box32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,21H12a2,2,0,0,1-2-2V17a2,2,0,0,1,2-2h8a2,2,0,0,1,2,2v2A2,2,0,0,1,20,21Zm-8-4v2h8V17Z"}),React.createElement("path",{d:"M28,4H4A2,2,0,0,0,2,6v4a2,2,0,0,0,2,2V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V12a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4ZM26,28H6V12H26Zm2-18H4V6H28v4Z"}),props.children);});var Box24=/*#__PURE__*/React.forwardRef(function Box24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,21H12a2,2,0,0,1-2-2V17a2,2,0,0,1,2-2h8a2,2,0,0,1,2,2v2A2,2,0,0,1,20,21Zm-8-4v2h8V17Z"}),React.createElement("path",{d:"M28,4H4A2,2,0,0,0,2,6v4a2,2,0,0,0,2,2V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V12a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4ZM26,28H6V12H26Zm2-18H4V6H28v4Z"}),props.children);});var Box20=/*#__PURE__*/React.forwardRef(function Box20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,21H12a2,2,0,0,1-2-2V17a2,2,0,0,1,2-2h8a2,2,0,0,1,2,2v2A2,2,0,0,1,20,21Zm-8-4v2h8V17Z"}),React.createElement("path",{d:"M28,4H4A2,2,0,0,0,2,6v4a2,2,0,0,0,2,2V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V12a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4ZM26,28H6V12H26Zm2-18H4V6H28v4Z"}),props.children);});var Box16=/*#__PURE__*/React.forwardRef(function Box16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,21H12a2,2,0,0,1-2-2V17a2,2,0,0,1,2-2h8a2,2,0,0,1,2,2v2A2,2,0,0,1,20,21Zm-8-4v2h8V17Z"}),React.createElement("path",{d:"M28,4H4A2,2,0,0,0,2,6v4a2,2,0,0,0,2,2V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V12a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4ZM26,28H6V12H26Zm2-18H4V6H28v4Z"}),props.children);});var Branch32=/*#__PURE__*/React.forwardRef(function Branch32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18a3.9955,3.9955,0,0,0-3.858,3H18a3.0033,3.0033,0,0,1-3-3V14a4.9514,4.9514,0,0,0-1.0256-3H22.142a4,4,0,1,0,0-2H9.858a4,4,0,1,0,0,2H10a3.0033,3.0033,0,0,1,3,3v4a5.0059,5.0059,0,0,0,5,5h4.142A3.9935,3.9935,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,8ZM6,12a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,12ZM26,24a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,24Z"}),props.children);});var Branch24=/*#__PURE__*/React.forwardRef(function Branch24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18a3.9955,3.9955,0,0,0-3.858,3H18a3.0033,3.0033,0,0,1-3-3V14a4.9514,4.9514,0,0,0-1.0256-3H22.142a4,4,0,1,0,0-2H9.858a4,4,0,1,0,0,2H10a3.0033,3.0033,0,0,1,3,3v4a5.0059,5.0059,0,0,0,5,5h4.142A3.9935,3.9935,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,8ZM6,12a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,12ZM26,24a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,24Z"}),props.children);});var Branch20=/*#__PURE__*/React.forwardRef(function Branch20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18a3.9955,3.9955,0,0,0-3.858,3H18a3.0033,3.0033,0,0,1-3-3V14a4.9514,4.9514,0,0,0-1.0256-3H22.142a4,4,0,1,0,0-2H9.858a4,4,0,1,0,0,2H10a3.0033,3.0033,0,0,1,3,3v4a5.0059,5.0059,0,0,0,5,5h4.142A3.9935,3.9935,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,8ZM6,12a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,12ZM26,24a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,24Z"}),props.children);});var Branch16=/*#__PURE__*/React.forwardRef(function Branch16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18a3.9955,3.9955,0,0,0-3.858,3H18a3.0033,3.0033,0,0,1-3-3V14a4.9514,4.9514,0,0,0-1.0256-3H22.142a4,4,0,1,0,0-2H9.858a4,4,0,1,0,0,2H10a3.0033,3.0033,0,0,1,3,3v4a5.0059,5.0059,0,0,0,5,5h4.142A3.9935,3.9935,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.0023,2.0023,0,0,1,26,8ZM6,12a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,12ZM26,24a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,24Z"}),props.children);});var BrightnessContrast32=/*#__PURE__*/React.forwardRef(function BrightnessContrast32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"3",x:"15",y:"2"}),React.createElement("rect",{width:"3",height:"2",x:"27",y:"15"}),React.createElement("rect",{width:"2",height:"3",x:"15",y:"27"}),React.createElement("rect",{width:"3",height:"2",x:"2",y:"15"}),React.createElement("rect",{width:"2",height:"3",x:"6.22",y:"5.73",transform:"rotate(-45 7.227 7.236)"}),React.createElement("rect",{width:"3",height:"2",x:"23.27",y:"6.23",transform:"rotate(-45 24.766 7.232)"}),React.createElement("rect",{width:"2",height:"3",x:"23.77",y:"23.27",transform:"rotate(-45 24.77 24.77)"}),React.createElement("polygon",{points:"5.47 25.13 7.59 23 9 24.42 6.88 26.54 5.47 25.13"}),React.createElement("path",{d:"M16,8a8,8,0,1,0,8,8A8,8,0,0,0,16,8Zm0,14a6,6,0,0,1,0-12Z"}),props.children);});var BrightnessContrast24=/*#__PURE__*/React.forwardRef(function BrightnessContrast24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"3",x:"15",y:"2"}),React.createElement("rect",{width:"3",height:"2",x:"27",y:"15"}),React.createElement("rect",{width:"2",height:"3",x:"15",y:"27"}),React.createElement("rect",{width:"3",height:"2",x:"2",y:"15"}),React.createElement("rect",{width:"2",height:"3",x:"6.22",y:"5.73",transform:"rotate(-45 7.227 7.236)"}),React.createElement("rect",{width:"3",height:"2",x:"23.27",y:"6.23",transform:"rotate(-45 24.766 7.232)"}),React.createElement("rect",{width:"2",height:"3",x:"23.77",y:"23.27",transform:"rotate(-45 24.77 24.77)"}),React.createElement("polygon",{points:"5.47 25.13 7.59 23 9 24.42 6.88 26.54 5.47 25.13"}),React.createElement("path",{d:"M16,8a8,8,0,1,0,8,8A8,8,0,0,0,16,8Zm0,14a6,6,0,0,1,0-12Z"}),props.children);});var BrightnessContrast20=/*#__PURE__*/React.forwardRef(function BrightnessContrast20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"3",x:"15",y:"2"}),React.createElement("rect",{width:"3",height:"2",x:"27",y:"15"}),React.createElement("rect",{width:"2",height:"3",x:"15",y:"27"}),React.createElement("rect",{width:"3",height:"2",x:"2",y:"15"}),React.createElement("rect",{width:"2",height:"3",x:"6.22",y:"5.73",transform:"rotate(-45 7.227 7.236)"}),React.createElement("rect",{width:"3",height:"2",x:"23.27",y:"6.23",transform:"rotate(-45 24.766 7.232)"}),React.createElement("rect",{width:"2",height:"3",x:"23.77",y:"23.27",transform:"rotate(-45 24.77 24.77)"}),React.createElement("polygon",{points:"5.47 25.13 7.59 23 9 24.42 6.88 26.54 5.47 25.13"}),React.createElement("path",{d:"M16,8a8,8,0,1,0,8,8A8,8,0,0,0,16,8Zm0,14a6,6,0,0,1,0-12Z"}),props.children);});var BrightnessContrast16=/*#__PURE__*/React.forwardRef(function BrightnessContrast16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"3",x:"15",y:"2"}),React.createElement("rect",{width:"3",height:"2",x:"27",y:"15"}),React.createElement("rect",{width:"2",height:"3",x:"15",y:"27"}),React.createElement("rect",{width:"3",height:"2",x:"2",y:"15"}),React.createElement("rect",{width:"2",height:"3",x:"6.22",y:"5.73",transform:"rotate(-45 7.227 7.236)"}),React.createElement("rect",{width:"3",height:"2",x:"23.27",y:"6.23",transform:"rotate(-45 24.766 7.232)"}),React.createElement("rect",{width:"2",height:"3",x:"23.77",y:"23.27",transform:"rotate(-45 24.77 24.77)"}),React.createElement("polygon",{points:"5.47 25.13 7.59 23 9 24.42 6.88 26.54 5.47 25.13"}),React.createElement("path",{d:"M16,8a8,8,0,1,0,8,8A8,8,0,0,0,16,8Zm0,14a6,6,0,0,1,0-12Z"}),props.children);});var BuildingInsights_132=/*#__PURE__*/React.forwardRef(function BuildingInsights_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),React.createElement("path",{d:"M9,12H7a5.0059,5.0059,0,0,1,5-5V9A3.0033,3.0033,0,0,0,9,12Z"}),React.createElement("path",{d:"M4,12H2A10.0114,10.0114,0,0,1,12,2V4A8.0092,8.0092,0,0,0,4,12Z"}),props.children);});var BuildingInsights_124=/*#__PURE__*/React.forwardRef(function BuildingInsights_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),React.createElement("path",{d:"M9,12H7a5.0059,5.0059,0,0,1,5-5V9A3.0033,3.0033,0,0,0,9,12Z"}),React.createElement("path",{d:"M4,12H2A10.0114,10.0114,0,0,1,12,2V4A8.0092,8.0092,0,0,0,4,12Z"}),props.children);});var BuildingInsights_120=/*#__PURE__*/React.forwardRef(function BuildingInsights_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),React.createElement("path",{d:"M9,12H7a5.0059,5.0059,0,0,1,5-5V9A3.0033,3.0033,0,0,0,9,12Z"}),React.createElement("path",{d:"M4,12H2A10.0114,10.0114,0,0,1,12,2V4A8.0092,8.0092,0,0,0,4,12Z"}),props.children);});var BuildingInsights_116=/*#__PURE__*/React.forwardRef(function BuildingInsights_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),React.createElement("path",{d:"M9,12H7a5.0059,5.0059,0,0,1,5-5V9A3.0033,3.0033,0,0,0,9,12Z"}),React.createElement("path",{d:"M4,12H2A10.0114,10.0114,0,0,1,12,2V4A8.0092,8.0092,0,0,0,4,12Z"}),props.children);});var BuildingInsights_232=/*#__PURE__*/React.forwardRef(function BuildingInsights_232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),React.createElement("path",{d:"M5.5,12a3.5,3.5,0,0,1,0-7h.627A4.0062,4.0062,0,0,1,10,2h2V4L10,4A2.0023,2.0023,0,0,0,8,6V7H5.5a1.5,1.5,0,0,0,0,3H12v2Z"}),props.children);});var BuildingInsights_224=/*#__PURE__*/React.forwardRef(function BuildingInsights_224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),React.createElement("path",{d:"M5.5,12a3.5,3.5,0,0,1,0-7h.627A4.0062,4.0062,0,0,1,10,2h2V4L10,4A2.0023,2.0023,0,0,0,8,6V7H5.5a1.5,1.5,0,0,0,0,3H12v2Z"}),props.children);});var BuildingInsights_220=/*#__PURE__*/React.forwardRef(function BuildingInsights_220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),React.createElement("path",{d:"M5.5,12a3.5,3.5,0,0,1,0-7h.627A4.0062,4.0062,0,0,1,10,2h2V4L10,4A2.0023,2.0023,0,0,0,8,6V7H5.5a1.5,1.5,0,0,0,0,3H12v2Z"}),props.children);});var BuildingInsights_216=/*#__PURE__*/React.forwardRef(function BuildingInsights_216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),React.createElement("path",{d:"M5.5,12a3.5,3.5,0,0,1,0-7h.627A4.0062,4.0062,0,0,1,10,2h2V4L10,4A2.0023,2.0023,0,0,0,8,6V7H5.5a1.5,1.5,0,0,0,0,3H12v2Z"}),props.children);});var BuildingInsights_332=/*#__PURE__*/React.forwardRef(function BuildingInsights_332(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),React.createElement("rect",{width:"5",height:"2",x:"2",y:"10"}),React.createElement("rect",{width:"2",height:"5",x:"10",y:"2"}),React.createElement("rect",{width:"2",height:"5.071",x:"5.5",y:"3.964",transform:"rotate(-45 6.5 6.5)"}),props.children);});var BuildingInsights_324=/*#__PURE__*/React.forwardRef(function BuildingInsights_324(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),React.createElement("rect",{width:"5",height:"2",x:"2",y:"10"}),React.createElement("rect",{width:"2",height:"5",x:"10",y:"2"}),React.createElement("rect",{width:"2",height:"5.071",x:"5.5",y:"3.964",transform:"rotate(-45 6.5 6.5)"}),props.children);});var BuildingInsights_320=/*#__PURE__*/React.forwardRef(function BuildingInsights_320(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),React.createElement("rect",{width:"5",height:"2",x:"2",y:"10"}),React.createElement("rect",{width:"2",height:"5",x:"10",y:"2"}),React.createElement("rect",{width:"2",height:"5.071",x:"5.5",y:"3.964",transform:"rotate(-45 6.5 6.5)"}),props.children);});var BuildingInsights_316=/*#__PURE__*/React.forwardRef(function BuildingInsights_316(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),React.createElement("rect",{width:"5",height:"2",x:"2",y:"10"}),React.createElement("rect",{width:"2",height:"5",x:"10",y:"2"}),React.createElement("rect",{width:"2",height:"5.071",x:"5.5",y:"3.964",transform:"rotate(-45 6.5 6.5)"}),props.children);});var Building32=/*#__PURE__*/React.forwardRef(function Building32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),props.children);});var Building24=/*#__PURE__*/React.forwardRef(function Building24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),props.children);});var Building20=/*#__PURE__*/React.forwardRef(function Building20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),props.children);});var Building16=/*#__PURE__*/React.forwardRef(function Building16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H16a2.002,2.002,0,0,0-2,2V14H4a2.002,2.002,0,0,0-2,2V30H30V4A2.0023,2.0023,0,0,0,28,2ZM9,28V21h4v7Zm19,0H15V20a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1v8H4V16H16V4H28Z"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"8"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"14"}),React.createElement("rect",{width:"2",height:"2",x:"18",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"24",y:"20"}),props.children);});var Bullhorn32=/*#__PURE__*/React.forwardRef(function Bullhorn32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,6V8.17L5.64,11.87a2,2,0,0,0-1.64,2v4.34a2,2,0,0,0,1.64,2L8,20.56V24a2,2,0,0,0,2,2h8a2,2,0,0,0,2-2V22.74l6,1.09V26h2V6ZM18,24H10V20.93l8,1.45ZM6,18.17V13.83L26,10.2V21.8Z"}),props.children);});var Bullhorn24=/*#__PURE__*/React.forwardRef(function Bullhorn24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,6V8.17L5.64,11.87a2,2,0,0,0-1.64,2v4.34a2,2,0,0,0,1.64,2L8,20.56V24a2,2,0,0,0,2,2h8a2,2,0,0,0,2-2V22.74l6,1.09V26h2V6ZM18,24H10V20.93l8,1.45ZM6,18.17V13.83L26,10.2V21.8Z"}),props.children);});var Bullhorn20=/*#__PURE__*/React.forwardRef(function Bullhorn20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,6V8.17L5.64,11.87a2,2,0,0,0-1.64,2v4.34a2,2,0,0,0,1.64,2L8,20.56V24a2,2,0,0,0,2,2h8a2,2,0,0,0,2-2V22.74l6,1.09V26h2V6ZM18,24H10V20.93l8,1.45ZM6,18.17V13.83L26,10.2V21.8Z"}),props.children);});var Bullhorn16=/*#__PURE__*/React.forwardRef(function Bullhorn16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,6V8.17L5.64,11.87a2,2,0,0,0-1.64,2v4.34a2,2,0,0,0,1.64,2L8,20.56V24a2,2,0,0,0,2,2h8a2,2,0,0,0,2-2V22.74l6,1.09V26h2V6ZM18,24H10V20.93l8,1.45ZM6,18.17V13.83L26,10.2V21.8Z"}),props.children);});var Bus32=/*#__PURE__*/React.forwardRef(function Bus32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4",x:"27",y:"11"}),React.createElement("rect",{width:"2",height:"4",x:"3",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"20",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"10",y:"20"}),React.createElement("path",{d:"M21,4H11A5.0059,5.0059,0,0,0,6,9V23a2.0023,2.0023,0,0,0,2,2v3h2V25H22v3h2V25a2.0027,2.0027,0,0,0,2-2V9A5.0059,5.0059,0,0,0,21,4Zm3,6,.0009,6H8V10ZM11,6H21a2.995,2.995,0,0,1,2.8157,2H8.1843A2.995,2.995,0,0,1,11,6ZM8,23V18H24.0012l.0008,5Z"}),props.children);});var Bus24=/*#__PURE__*/React.forwardRef(function Bus24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4",x:"27",y:"11"}),React.createElement("rect",{width:"2",height:"4",x:"3",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"20",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"10",y:"20"}),React.createElement("path",{d:"M21,4H11A5.0059,5.0059,0,0,0,6,9V23a2.0023,2.0023,0,0,0,2,2v3h2V25H22v3h2V25a2.0027,2.0027,0,0,0,2-2V9A5.0059,5.0059,0,0,0,21,4Zm3,6,.0009,6H8V10ZM11,6H21a2.995,2.995,0,0,1,2.8157,2H8.1843A2.995,2.995,0,0,1,11,6ZM8,23V18H24.0012l.0008,5Z"}),props.children);});var Bus20=/*#__PURE__*/React.forwardRef(function Bus20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4",x:"27",y:"11"}),React.createElement("rect",{width:"2",height:"4",x:"3",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"20",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"10",y:"20"}),React.createElement("path",{d:"M21,4H11A5.0059,5.0059,0,0,0,6,9V23a2.0023,2.0023,0,0,0,2,2v3h2V25H22v3h2V25a2.0027,2.0027,0,0,0,2-2V9A5.0059,5.0059,0,0,0,21,4Zm3,6,.0009,6H8V10ZM11,6H21a2.995,2.995,0,0,1,2.8157,2H8.1843A2.995,2.995,0,0,1,11,6ZM8,23V18H24.0012l.0008,5Z"}),props.children);});var Bus16=/*#__PURE__*/React.forwardRef(function Bus16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4",x:"27",y:"11"}),React.createElement("rect",{width:"2",height:"4",x:"3",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"20",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"10",y:"20"}),React.createElement("path",{d:"M21,4H11A5.0059,5.0059,0,0,0,6,9V23a2.0023,2.0023,0,0,0,2,2v3h2V25H22v3h2V25a2.0027,2.0027,0,0,0,2-2V9A5.0059,5.0059,0,0,0,21,4Zm3,6,.0009,6H8V10ZM11,6H21a2.995,2.995,0,0,1,2.8157,2H8.1843A2.995,2.995,0,0,1,11,6ZM8,23V18H24.0012l.0008,5Z"}),props.children);});var Cafe32=/*#__PURE__*/React.forwardRef(function Cafe32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M24.5,11H8a2.002,2.002,0,0,0-2,2v8a5.0059,5.0059,0,0,0,5,5h8a5.0059,5.0059,0,0,0,5-5V20h.5a4.5,4.5,0,0,0,0-9ZM22,21a3.0033,3.0033,0,0,1-3,3H11a3.0033,3.0033,0,0,1-3-3V13H22Zm2.5-3H24V13h.5a2.5,2.5,0,0,1,0,5Z"}),React.createElement("path",{d:"M19,9H17V8.854a1.9883,1.9883,0,0,0-1.1055-1.7886L13.2109,5.7236A3.9788,3.9788,0,0,1,11,2.146V1h2V2.146a1.9892,1.9892,0,0,0,1.1055,1.7886l2.6836,1.3418A3.9792,3.9792,0,0,1,19,8.854Z"}),props.children);});var Cafe24=/*#__PURE__*/React.forwardRef(function Cafe24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M24.5,11H8a2.002,2.002,0,0,0-2,2v8a5.0059,5.0059,0,0,0,5,5h8a5.0059,5.0059,0,0,0,5-5V20h.5a4.5,4.5,0,0,0,0-9ZM22,21a3.0033,3.0033,0,0,1-3,3H11a3.0033,3.0033,0,0,1-3-3V13H22Zm2.5-3H24V13h.5a2.5,2.5,0,0,1,0,5Z"}),React.createElement("path",{d:"M19,9H17V8.854a1.9883,1.9883,0,0,0-1.1055-1.7886L13.2109,5.7236A3.9788,3.9788,0,0,1,11,2.146V1h2V2.146a1.9892,1.9892,0,0,0,1.1055,1.7886l2.6836,1.3418A3.9792,3.9792,0,0,1,19,8.854Z"}),props.children);});var Cafe20=/*#__PURE__*/React.forwardRef(function Cafe20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M24.5,11H8a2.002,2.002,0,0,0-2,2v8a5.0059,5.0059,0,0,0,5,5h8a5.0059,5.0059,0,0,0,5-5V20h.5a4.5,4.5,0,0,0,0-9ZM22,21a3.0033,3.0033,0,0,1-3,3H11a3.0033,3.0033,0,0,1-3-3V13H22Zm2.5-3H24V13h.5a2.5,2.5,0,0,1,0,5Z"}),React.createElement("path",{d:"M19,9H17V8.854a1.9883,1.9883,0,0,0-1.1055-1.7886L13.2109,5.7236A3.9788,3.9788,0,0,1,11,2.146V1h2V2.146a1.9892,1.9892,0,0,0,1.1055,1.7886l2.6836,1.3418A3.9792,3.9792,0,0,1,19,8.854Z"}),props.children);});var Cafe16=/*#__PURE__*/React.forwardRef(function Cafe16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M24.5,11H8a2.002,2.002,0,0,0-2,2v8a5.0059,5.0059,0,0,0,5,5h8a5.0059,5.0059,0,0,0,5-5V20h.5a4.5,4.5,0,0,0,0-9ZM22,21a3.0033,3.0033,0,0,1-3,3H11a3.0033,3.0033,0,0,1-3-3V13H22Zm2.5-3H24V13h.5a2.5,2.5,0,0,1,0,5Z"}),React.createElement("path",{d:"M19,9H17V8.854a1.9883,1.9883,0,0,0-1.1055-1.7886L13.2109,5.7236A3.9788,3.9788,0,0,1,11,2.146V1h2V2.146a1.9892,1.9892,0,0,0,1.1055,1.7886l2.6836,1.3418A3.9792,3.9792,0,0,1,19,8.854Z"}),props.children);});var CalculatorCheck32=/*#__PURE__*/React.forwardRef(function CalculatorCheck32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 26.59 21.41 24 20 25.41 24 29.41 31 22.41 29.59 21 24 26.59"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"13"}),React.createElement("rect",{width:"14",height:"3",x:"9",y:"7"}),React.createElement("path",{d:"M17,30H6.0046A2.007,2.007,0,0,1,4,27.9951V3.9961A1.9984,1.9984,0,0,1,5.9961,2H26.0037A1.9985,1.9985,0,0,1,28,3.9961V18H26V4H6V28H17Z"}),props.children);});var CalculatorCheck24=/*#__PURE__*/React.forwardRef(function CalculatorCheck24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 26.59 21.41 24 20 25.41 24 29.41 31 22.41 29.59 21 24 26.59"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"13"}),React.createElement("rect",{width:"14",height:"3",x:"9",y:"7"}),React.createElement("path",{d:"M17,30H6.0046A2.007,2.007,0,0,1,4,27.9951V3.9961A1.9984,1.9984,0,0,1,5.9961,2H26.0037A1.9985,1.9985,0,0,1,28,3.9961V18H26V4H6V28H17Z"}),props.children);});var CalculatorCheck20=/*#__PURE__*/React.forwardRef(function CalculatorCheck20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 26.59 21.41 24 20 25.41 24 29.41 31 22.41 29.59 21 24 26.59"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"13"}),React.createElement("rect",{width:"14",height:"3",x:"9",y:"7"}),React.createElement("path",{d:"M17,30H6.0046A2.007,2.007,0,0,1,4,27.9951V3.9961A1.9984,1.9984,0,0,1,5.9961,2H26.0037A1.9985,1.9985,0,0,1,28,3.9961V18H26V4H6V28H17Z"}),props.children);});var CalculatorCheck16=/*#__PURE__*/React.forwardRef(function CalculatorCheck16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 26.59 21.41 24 20 25.41 24 29.41 31 22.41 29.59 21 24 26.59"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"13"}),React.createElement("rect",{width:"14",height:"3",x:"9",y:"7"}),React.createElement("path",{d:"M17,30H6.0046A2.007,2.007,0,0,1,4,27.9951V3.9961A1.9984,1.9984,0,0,1,5.9961,2H26.0037A1.9985,1.9985,0,0,1,28,3.9961V18H26V4H6V28H17Z"}),props.children);});var Calculator32=/*#__PURE__*/React.forwardRef(function Calculator32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4V28H6V4H26m0-2H6A2,2,0,0,0,4,4V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Z"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"13"}),React.createElement("rect",{width:"14",height:"3",x:"9",y:"7"}),props.children);});var Calculator24=/*#__PURE__*/React.forwardRef(function Calculator24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4V28H6V4H26m0-2H6A2,2,0,0,0,4,4V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Z"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"13"}),React.createElement("rect",{width:"14",height:"3",x:"9",y:"7"}),props.children);});var Calculator20=/*#__PURE__*/React.forwardRef(function Calculator20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4V28H6V4H26m0-2H6A2,2,0,0,0,4,4V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Z"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"13"}),React.createElement("rect",{width:"14",height:"3",x:"9",y:"7"}),props.children);});var Calculator16=/*#__PURE__*/React.forwardRef(function Calculator16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4V28H6V4H26m0-2H6A2,2,0,0,0,4,4V28a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Z"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"9",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"18"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"13"}),React.createElement("rect",{width:"2",height:"2",x:"21",y:"13"}),React.createElement("rect",{width:"14",height:"3",x:"9",y:"7"}),props.children);});var Calendar32=/*#__PURE__*/React.forwardRef(function Calendar32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h20c1.1,0,2-0.9,2-2V6C28,4.9,27.1,4,26,4z M26,26H6V12h20\tV26z M26,10H6V6h4v2h2V6h8v2h2V6h4V10z"}),props.children);});var Calendar24=/*#__PURE__*/React.forwardRef(function Calendar24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h20c1.1,0,2-0.9,2-2V6C28,4.9,27.1,4,26,4z M26,26H6V12h20\tV26z M26,10H6V6h4v2h2V6h8v2h2V6h4V10z"}),props.children);});var Calendar20=/*#__PURE__*/React.forwardRef(function Calendar20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h20c1.1,0,2-0.9,2-2V6C28,4.9,27.1,4,26,4z M26,26H6V12h20\tV26z M26,10H6V6h4v2h2V6h8v2h2V6h4V10z"}),props.children);});var Calendar16=/*#__PURE__*/React.forwardRef(function Calendar16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4h-4V2h-2v2h-8V2h-2v2H6C4.9,4,4,4.9,4,6v20c0,1.1,0.9,2,2,2h20c1.1,0,2-0.9,2-2V6C28,4.9,27.1,4,26,4z M26,26H6V12h20\tV26z M26,10H6V6h4v2h2V6h8v2h2V6h4V10z"}),props.children);});var Calibrate32=/*#__PURE__*/React.forwardRef(function Calibrate32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.83,21.17,25,17.37l.67-.67a1,1,0,0,0,0-1.41l-6-6a1,1,0,0,0-1.41,0h0l-.79.79L10.71,3.29a1,1,0,0,0-1.41,0h0l-4,4-.12.15-4,6a1,1,0,0,0,.12,1.26l3,3a1,1,0,0,0,1.42,0L10,13.41l2.09,2.09-4.8,4.79a1,1,0,0,0,0,1.41l2,2A1,1,0,0,0,10,24a1,1,0,0,0,.52-.15l4.33-2.6,2.44,2.45a1,1,0,0,0,1.41,0h0l.67-.7,3.79,3.83a4,4,0,0,0,5.66-5.66ZM10,10.58l-5,5L3.29,13.87,6.78,8.63,10,5.41l6.09,6.09L13.5,14.08Zm8,11-2.84-2.84-5,3L9.42,21,19,11.41,23.59,16Zm9.42,3.83a2,2,0,0,1-2.83,0h0l-3.8-3.79,2.83-2.83,3.8,3.79a2,2,0,0,1,0,2.83Z"}),props.children);});var Calibrate24=/*#__PURE__*/React.forwardRef(function Calibrate24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.83,21.17,25,17.37l.67-.67a1,1,0,0,0,0-1.41l-6-6a1,1,0,0,0-1.41,0h0l-.79.79L10.71,3.29a1,1,0,0,0-1.41,0h0l-4,4-.12.15-4,6a1,1,0,0,0,.12,1.26l3,3a1,1,0,0,0,1.42,0L10,13.41l2.09,2.09-4.8,4.79a1,1,0,0,0,0,1.41l2,2A1,1,0,0,0,10,24a1,1,0,0,0,.52-.15l4.33-2.6,2.44,2.45a1,1,0,0,0,1.41,0h0l.67-.7,3.79,3.83a4,4,0,0,0,5.66-5.66ZM10,10.58l-5,5L3.29,13.87,6.78,8.63,10,5.41l6.09,6.09L13.5,14.08Zm8,11-2.84-2.84-5,3L9.42,21,19,11.41,23.59,16Zm9.42,3.83a2,2,0,0,1-2.83,0h0l-3.8-3.79,2.83-2.83,3.8,3.79a2,2,0,0,1,0,2.83Z"}),props.children);});var Calibrate20=/*#__PURE__*/React.forwardRef(function Calibrate20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.83,21.17,25,17.37l.67-.67a1,1,0,0,0,0-1.41l-6-6a1,1,0,0,0-1.41,0h0l-.79.79L10.71,3.29a1,1,0,0,0-1.41,0h0l-4,4-.12.15-4,6a1,1,0,0,0,.12,1.26l3,3a1,1,0,0,0,1.42,0L10,13.41l2.09,2.09-4.8,4.79a1,1,0,0,0,0,1.41l2,2A1,1,0,0,0,10,24a1,1,0,0,0,.52-.15l4.33-2.6,2.44,2.45a1,1,0,0,0,1.41,0h0l.67-.7,3.79,3.83a4,4,0,0,0,5.66-5.66ZM10,10.58l-5,5L3.29,13.87,6.78,8.63,10,5.41l6.09,6.09L13.5,14.08Zm8,11-2.84-2.84-5,3L9.42,21,19,11.41,23.59,16Zm9.42,3.83a2,2,0,0,1-2.83,0h0l-3.8-3.79,2.83-2.83,3.8,3.79a2,2,0,0,1,0,2.83Z"}),props.children);});var Calibrate16=/*#__PURE__*/React.forwardRef(function Calibrate16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28.83,21.17,25,17.37l.67-.67a1,1,0,0,0,0-1.41l-6-6a1,1,0,0,0-1.41,0h0l-.79.79L10.71,3.29a1,1,0,0,0-1.41,0h0l-4,4-.12.15-4,6a1,1,0,0,0,.12,1.26l3,3a1,1,0,0,0,1.42,0L10,13.41l2.09,2.09-4.8,4.79a1,1,0,0,0,0,1.41l2,2A1,1,0,0,0,10,24a1,1,0,0,0,.52-.15l4.33-2.6,2.44,2.45a1,1,0,0,0,1.41,0h0l.67-.7,3.79,3.83a4,4,0,0,0,5.66-5.66ZM10,10.58l-5,5L3.29,13.87,6.78,8.63,10,5.41l6.09,6.09L13.5,14.08Zm8,11-2.84-2.84-5,3L9.42,21,19,11.41,23.59,16Zm9.42,3.83a2,2,0,0,1-2.83,0h0l-3.8-3.79,2.83-2.83,3.8,3.79a2,2,0,0,1,0,2.83Z"}),props.children);});var CameraAction32=/*#__PURE__*/React.forwardRef(function CameraAction32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,23a6,6,0,1,1,6-6A6,6,0,0,1,12,23Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,12,13Z"}),React.createElement("path",{d:"M29,27H3a1,1,0,0,1-1-1V6A1,1,0,0,1,3,5H29a1,1,0,0,1,1,1V26A1,1,0,0,1,29,27ZM4,25H28V7H4Z"}),React.createElement("rect",{width:"7",height:"2",x:"19",y:"9"}),React.createElement("circle",{cx:"12",cy:"17",r:"1"}),props.children);});var CameraAction24=/*#__PURE__*/React.forwardRef(function CameraAction24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,23a6,6,0,1,1,6-6A6,6,0,0,1,12,23Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,12,13Z"}),React.createElement("path",{d:"M29,27H3a1,1,0,0,1-1-1V6A1,1,0,0,1,3,5H29a1,1,0,0,1,1,1V26A1,1,0,0,1,29,27ZM4,25H28V7H4Z"}),React.createElement("rect",{width:"7",height:"2",x:"19",y:"9"}),React.createElement("circle",{cx:"12",cy:"17",r:"1"}),props.children);});var CameraAction20=/*#__PURE__*/React.forwardRef(function CameraAction20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,23a6,6,0,1,1,6-6A6,6,0,0,1,12,23Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,12,13Z"}),React.createElement("path",{d:"M29,27H3a1,1,0,0,1-1-1V6A1,1,0,0,1,3,5H29a1,1,0,0,1,1,1V26A1,1,0,0,1,29,27ZM4,25H28V7H4Z"}),React.createElement("rect",{width:"7",height:"2",x:"19",y:"9"}),React.createElement("circle",{cx:"12",cy:"17",r:"1"}),props.children);});var CameraAction16=/*#__PURE__*/React.forwardRef(function CameraAction16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,23a6,6,0,1,1,6-6A6,6,0,0,1,12,23Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,12,13Z"}),React.createElement("path",{d:"M29,27H3a1,1,0,0,1-1-1V6A1,1,0,0,1,3,5H29a1,1,0,0,1,1,1V26A1,1,0,0,1,29,27ZM4,25H28V7H4Z"}),React.createElement("rect",{width:"7",height:"2",x:"19",y:"9"}),React.createElement("circle",{cx:"12",cy:"17",r:"1"}),props.children);});var Camera32=/*#__PURE__*/React.forwardRef(function Camera32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,26H3a1,1,0,0,1-1-1V8A1,1,0,0,1,3,7H9.46l1.71-2.55A1,1,0,0,1,12,4h8a1,1,0,0,1,.83.45L22.54,7H29a1,1,0,0,1,1,1V25A1,1,0,0,1,29,26ZM4,24H28V9H22a1,1,0,0,1-.83-.45L19.46,6H12.54L10.83,8.55A1,1,0,0,1,10,9H4Z"}),React.createElement("path",{d:"M16,22a6,6,0,1,1,6-6A6,6,0,0,1,16,22Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,16,12Z"}),props.children);});var Camera24=/*#__PURE__*/React.forwardRef(function Camera24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,26H3a1,1,0,0,1-1-1V8A1,1,0,0,1,3,7H9.46l1.71-2.55A1,1,0,0,1,12,4h8a1,1,0,0,1,.83.45L22.54,7H29a1,1,0,0,1,1,1V25A1,1,0,0,1,29,26ZM4,24H28V9H22a1,1,0,0,1-.83-.45L19.46,6H12.54L10.83,8.55A1,1,0,0,1,10,9H4Z"}),React.createElement("path",{d:"M16,22a6,6,0,1,1,6-6A6,6,0,0,1,16,22Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,16,12Z"}),props.children);});var Camera20=/*#__PURE__*/React.forwardRef(function Camera20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,26H3a1,1,0,0,1-1-1V8A1,1,0,0,1,3,7H9.46l1.71-2.55A1,1,0,0,1,12,4h8a1,1,0,0,1,.83.45L22.54,7H29a1,1,0,0,1,1,1V25A1,1,0,0,1,29,26ZM4,24H28V9H22a1,1,0,0,1-.83-.45L19.46,6H12.54L10.83,8.55A1,1,0,0,1,10,9H4Z"}),React.createElement("path",{d:"M16,22a6,6,0,1,1,6-6A6,6,0,0,1,16,22Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,16,12Z"}),props.children);});var Camera16=/*#__PURE__*/React.forwardRef(function Camera16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,26H3a1,1,0,0,1-1-1V8A1,1,0,0,1,3,7H9.46l1.71-2.55A1,1,0,0,1,12,4h8a1,1,0,0,1,.83.45L22.54,7H29a1,1,0,0,1,1,1V25A1,1,0,0,1,29,26ZM4,24H28V9H22a1,1,0,0,1-.83-.45L19.46,6H12.54L10.83,8.55A1,1,0,0,1,10,9H4Z"}),React.createElement("path",{d:"M16,22a6,6,0,1,1,6-6A6,6,0,0,1,16,22Zm0-10a4,4,0,1,0,4,4A4,4,0,0,0,16,12Z"}),props.children);});var CarFront32=/*#__PURE__*/React.forwardRef(function CarFront32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"13",y:"19"}),React.createElement("path",{d:"M25.4409,14,24.1687,9.45A2.009,2.009,0,0,0,22.2456,8H9.7544A2.0089,2.0089,0,0,0,7.8313,9.4507L6.5315,14H4v2H6.0371L6,23a2.0025,2.0025,0,0,0,2,2v3h2V25H22v3h2V25a2.0025,2.0025,0,0,0,2-2V16h2V14ZM9.7544,10H22.2458l1.4285,5H8.3257ZM24,21v2H8V21h2V19H8V17H24v2H22v2Z"}),props.children);});var CarFront24=/*#__PURE__*/React.forwardRef(function CarFront24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"13",y:"19"}),React.createElement("path",{d:"M25.4409,14,24.1687,9.45A2.009,2.009,0,0,0,22.2456,8H9.7544A2.0089,2.0089,0,0,0,7.8313,9.4507L6.5315,14H4v2H6.0371L6,23a2.0025,2.0025,0,0,0,2,2v3h2V25H22v3h2V25a2.0025,2.0025,0,0,0,2-2V16h2V14ZM9.7544,10H22.2458l1.4285,5H8.3257ZM24,21v2H8V21h2V19H8V17H24v2H22v2Z"}),props.children);});var CarFront20=/*#__PURE__*/React.forwardRef(function CarFront20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"13",y:"19"}),React.createElement("path",{d:"M25.4409,14,24.1687,9.45A2.009,2.009,0,0,0,22.2456,8H9.7544A2.0089,2.0089,0,0,0,7.8313,9.4507L6.5315,14H4v2H6.0371L6,23a2.0025,2.0025,0,0,0,2,2v3h2V25H22v3h2V25a2.0025,2.0025,0,0,0,2-2V16h2V14ZM9.7544,10H22.2458l1.4285,5H8.3257ZM24,21v2H8V21h2V19H8V17H24v2H22v2Z"}),props.children);});var CarFront16=/*#__PURE__*/React.forwardRef(function CarFront16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"13",y:"19"}),React.createElement("path",{d:"M25.4409,14,24.1687,9.45A2.009,2.009,0,0,0,22.2456,8H9.7544A2.0089,2.0089,0,0,0,7.8313,9.4507L6.5315,14H4v2H6.0371L6,23a2.0025,2.0025,0,0,0,2,2v3h2V25H22v3h2V25a2.0025,2.0025,0,0,0,2-2V16h2V14ZM9.7544,10H22.2458l1.4285,5H8.3257ZM24,21v2H8V21h2V19H8V17H24v2H22v2Z"}),props.children);});var Car32=/*#__PURE__*/React.forwardRef(function Car32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.34,15.94l-7.73-2.78L18.37,9.1A3,3,0,0,0,16.05,8h-8A3,3,0,0,0,5.58,9.32l-2.71,4A5,5,0,0,0,2,16.11V24a1,1,0,0,0,1,1H5.14a4,4,0,0,0,7.72,0h6.28a4,4,0,0,0,7.72,0H29a1,1,0,0,0,1-1V16.88A1,1,0,0,0,29.34,15.94ZM9,26a2,2,0,1,1,2-2A2,2,0,0,1,9,26Zm14,0a2,2,0,1,1,2-2A2,2,0,0,1,23,26Zm5-3H26.86a4,4,0,0,0-7.72,0H12.86a4,4,0,0,0-7.72,0H4V16.11a3,3,0,0,1,.52-1.69l2.71-4A1,1,0,0,1,8.06,10h8a1,1,0,0,1,.77.36l3.4,4.27a1.09,1.09,0,0,0,.44.32L28,17.58Z"}),props.children);});var Car24=/*#__PURE__*/React.forwardRef(function Car24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.34,15.94l-7.73-2.78L18.37,9.1A3,3,0,0,0,16.05,8h-8A3,3,0,0,0,5.58,9.32l-2.71,4A5,5,0,0,0,2,16.11V24a1,1,0,0,0,1,1H5.14a4,4,0,0,0,7.72,0h6.28a4,4,0,0,0,7.72,0H29a1,1,0,0,0,1-1V16.88A1,1,0,0,0,29.34,15.94ZM9,26a2,2,0,1,1,2-2A2,2,0,0,1,9,26Zm14,0a2,2,0,1,1,2-2A2,2,0,0,1,23,26Zm5-3H26.86a4,4,0,0,0-7.72,0H12.86a4,4,0,0,0-7.72,0H4V16.11a3,3,0,0,1,.52-1.69l2.71-4A1,1,0,0,1,8.06,10h8a1,1,0,0,1,.77.36l3.4,4.27a1.09,1.09,0,0,0,.44.32L28,17.58Z"}),props.children);});var Car20=/*#__PURE__*/React.forwardRef(function Car20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.34,15.94l-7.73-2.78L18.37,9.1A3,3,0,0,0,16.05,8h-8A3,3,0,0,0,5.58,9.32l-2.71,4A5,5,0,0,0,2,16.11V24a1,1,0,0,0,1,1H5.14a4,4,0,0,0,7.72,0h6.28a4,4,0,0,0,7.72,0H29a1,1,0,0,0,1-1V16.88A1,1,0,0,0,29.34,15.94ZM9,26a2,2,0,1,1,2-2A2,2,0,0,1,9,26Zm14,0a2,2,0,1,1,2-2A2,2,0,0,1,23,26Zm5-3H26.86a4,4,0,0,0-7.72,0H12.86a4,4,0,0,0-7.72,0H4V16.11a3,3,0,0,1,.52-1.69l2.71-4A1,1,0,0,1,8.06,10h8a1,1,0,0,1,.77.36l3.4,4.27a1.09,1.09,0,0,0,.44.32L28,17.58Z"}),props.children);});var Car16=/*#__PURE__*/React.forwardRef(function Car16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.34,15.94l-7.73-2.78L18.37,9.1A3,3,0,0,0,16.05,8h-8A3,3,0,0,0,5.58,9.32l-2.71,4A5,5,0,0,0,2,16.11V24a1,1,0,0,0,1,1H5.14a4,4,0,0,0,7.72,0h6.28a4,4,0,0,0,7.72,0H29a1,1,0,0,0,1-1V16.88A1,1,0,0,0,29.34,15.94ZM9,26a2,2,0,1,1,2-2A2,2,0,0,1,9,26Zm14,0a2,2,0,1,1,2-2A2,2,0,0,1,23,26Zm5-3H26.86a4,4,0,0,0-7.72,0H12.86a4,4,0,0,0-7.72,0H4V16.11a3,3,0,0,1,.52-1.69l2.71-4A1,1,0,0,1,8.06,10h8a1,1,0,0,1,.77.36l3.4,4.27a1.09,1.09,0,0,0,.44.32L28,17.58Z"}),props.children);});var Carbon32=/*#__PURE__*/React.forwardRef(function Carbon32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.5,30.8149a1.0011,1.0011,0,0,1-.4927-.13l-8.5-4.815A1,1,0,0,1,4,25V15a1,1,0,0,1,.5073-.87l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,23,15V25a1,1,0,0,1-.5073.87l-8.5,4.815A1.0011,1.0011,0,0,1,13.5,30.8149ZM6,24.417l7.5,4.2485L21,24.417V15.583l-7.5-4.2485L6,15.583Z"}),React.createElement("path",{d:"M28,17H26V7.583L18.5,3.3345,10.4927,7.87,9.5073,6.13l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,28,7Z"}),props.children);});var Carbon24=/*#__PURE__*/React.forwardRef(function Carbon24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.5,30.8149a1.0011,1.0011,0,0,1-.4927-.13l-8.5-4.815A1,1,0,0,1,4,25V15a1,1,0,0,1,.5073-.87l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,23,15V25a1,1,0,0,1-.5073.87l-8.5,4.815A1.0011,1.0011,0,0,1,13.5,30.8149ZM6,24.417l7.5,4.2485L21,24.417V15.583l-7.5-4.2485L6,15.583Z"}),React.createElement("path",{d:"M28,17H26V7.583L18.5,3.3345,10.4927,7.87,9.5073,6.13l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,28,7Z"}),props.children);});var Carbon20=/*#__PURE__*/React.forwardRef(function Carbon20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.5,30.8149a1.0011,1.0011,0,0,1-.4927-.13l-8.5-4.815A1,1,0,0,1,4,25V15a1,1,0,0,1,.5073-.87l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,23,15V25a1,1,0,0,1-.5073.87l-8.5,4.815A1.0011,1.0011,0,0,1,13.5,30.8149ZM6,24.417l7.5,4.2485L21,24.417V15.583l-7.5-4.2485L6,15.583Z"}),React.createElement("path",{d:"M28,17H26V7.583L18.5,3.3345,10.4927,7.87,9.5073,6.13l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,28,7Z"}),props.children);});var Carbon16=/*#__PURE__*/React.forwardRef(function Carbon16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13.5,30.8149a1.0011,1.0011,0,0,1-.4927-.13l-8.5-4.815A1,1,0,0,1,4,25V15a1,1,0,0,1,.5073-.87l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,23,15V25a1,1,0,0,1-.5073.87l-8.5,4.815A1.0011,1.0011,0,0,1,13.5,30.8149ZM6,24.417l7.5,4.2485L21,24.417V15.583l-7.5-4.2485L6,15.583Z"}),React.createElement("path",{d:"M28,17H26V7.583L18.5,3.3345,10.4927,7.87,9.5073,6.13l8.5-4.815a1.0013,1.0013,0,0,1,.9854,0l8.5,4.815A1,1,0,0,1,28,7Z"}),props.children);});var CaretDown32=/*#__PURE__*/React.forwardRef(function CaretDown32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24,12 16,22 8,12"}),props.children);});var CaretDown24=/*#__PURE__*/React.forwardRef(function CaretDown24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24,12 16,22 8,12"}),props.children);});var CaretDown20=/*#__PURE__*/React.forwardRef(function CaretDown20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24,12 16,22 8,12"}),props.children);});var CaretDown16=/*#__PURE__*/React.forwardRef(function CaretDown16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24,12 16,22 8,12"}),props.children);});var CaretLeft32=/*#__PURE__*/React.forwardRef(function CaretLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20,24 10,16 20,8"}),props.children);});var CaretLeft24=/*#__PURE__*/React.forwardRef(function CaretLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20,24 10,16 20,8"}),props.children);});var CaretLeft20=/*#__PURE__*/React.forwardRef(function CaretLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20,24 10,16 20,8"}),props.children);});var CaretLeft16=/*#__PURE__*/React.forwardRef(function CaretLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"20,24 10,16 20,8"}),props.children);});var CaretRight32=/*#__PURE__*/React.forwardRef(function CaretRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12,8 22,16 12,24"}),props.children);});var CaretRight24=/*#__PURE__*/React.forwardRef(function CaretRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12,8 22,16 12,24"}),props.children);});var CaretRight20=/*#__PURE__*/React.forwardRef(function CaretRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12,8 22,16 12,24"}),props.children);});var CaretRight16=/*#__PURE__*/React.forwardRef(function CaretRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12,8 22,16 12,24"}),props.children);});var CaretSortDown32=/*#__PURE__*/React.forwardRef(function CaretSortDown32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24,24 16,32 8,24"}),props.children);});var CaretSortDown24=/*#__PURE__*/React.forwardRef(function CaretSortDown24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24,24 16,32 8,24"}),props.children);});var CaretSortDown20=/*#__PURE__*/React.forwardRef(function CaretSortDown20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24,24 16,32 8,24"}),props.children);});var CaretSortDown16=/*#__PURE__*/React.forwardRef(function CaretSortDown16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24,24 16,32 8,24"}),props.children);});var CaretSortUp32=/*#__PURE__*/React.forwardRef(function CaretSortUp32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"8,8 16,0 24,8"}),props.children);});var CaretSortUp24=/*#__PURE__*/React.forwardRef(function CaretSortUp24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"8,8 16,0 24,8"}),props.children);});var CaretSortUp20=/*#__PURE__*/React.forwardRef(function CaretSortUp20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"8,8 16,0 24,8"}),props.children);});var CaretSortUp16=/*#__PURE__*/React.forwardRef(function CaretSortUp16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"8,8 16,0 24,8"}),props.children);});var CaretSort32=/*#__PURE__*/React.forwardRef(function CaretSort32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24,24 16,32 8,24"}),React.createElement("polygon",{points:"8,8 16,0 24,8"}),props.children);});var CaretSort24=/*#__PURE__*/React.forwardRef(function CaretSort24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24,24 16,32 8,24"}),React.createElement("polygon",{points:"8,8 16,0 24,8"}),props.children);});var CaretSort20=/*#__PURE__*/React.forwardRef(function CaretSort20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24,24 16,32 8,24"}),React.createElement("polygon",{points:"8,8 16,0 24,8"}),props.children);});var CaretSort16=/*#__PURE__*/React.forwardRef(function CaretSort16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24,24 16,32 8,24"}),React.createElement("polygon",{points:"8,8 16,0 24,8"}),props.children);});var CaretUp32=/*#__PURE__*/React.forwardRef(function CaretUp32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"8,20 16,10 24,20"}),props.children);});var CaretUp24=/*#__PURE__*/React.forwardRef(function CaretUp24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"8,20 16,10 24,20"}),props.children);});var CaretUp20=/*#__PURE__*/React.forwardRef(function CaretUp20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"8,20 16,10 24,20"}),props.children);});var CaretUp16=/*#__PURE__*/React.forwardRef(function CaretUp16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"8,20 16,10 24,20"}),props.children);});var CarouselHorizontal32=/*#__PURE__*/React.forwardRef(function CarouselHorizontal32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22,26H10a2,2,0,0,1-2-2V8a2,2,0,0,1,2-2H22a2,2,0,0,1,2,2V24A2,2,0,0,1,22,26ZM10,8V24H22V8Z"}),React.createElement("path",{d:"M4,24H0V22H4V10H0V8H4a2,2,0,0,1,2,2V22A2,2,0,0,1,4,24Z"}),React.createElement("path",{d:"M32,24H28a2,2,0,0,1-2-2V10a2,2,0,0,1,2-2h4v2H28V22h4Z"}),props.children);});var CarouselHorizontal24=/*#__PURE__*/React.forwardRef(function CarouselHorizontal24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22,26H10a2,2,0,0,1-2-2V8a2,2,0,0,1,2-2H22a2,2,0,0,1,2,2V24A2,2,0,0,1,22,26ZM10,8V24H22V8Z"}),React.createElement("path",{d:"M4,24H0V22H4V10H0V8H4a2,2,0,0,1,2,2V22A2,2,0,0,1,4,24Z"}),React.createElement("path",{d:"M32,24H28a2,2,0,0,1-2-2V10a2,2,0,0,1,2-2h4v2H28V22h4Z"}),props.children);});var CarouselHorizontal20=/*#__PURE__*/React.forwardRef(function CarouselHorizontal20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22,26H10a2,2,0,0,1-2-2V8a2,2,0,0,1,2-2H22a2,2,0,0,1,2,2V24A2,2,0,0,1,22,26ZM10,8V24H22V8Z"}),React.createElement("path",{d:"M4,24H0V22H4V10H0V8H4a2,2,0,0,1,2,2V22A2,2,0,0,1,4,24Z"}),React.createElement("path",{d:"M32,24H28a2,2,0,0,1-2-2V10a2,2,0,0,1,2-2h4v2H28V22h4Z"}),props.children);});var CarouselHorizontal16=/*#__PURE__*/React.forwardRef(function CarouselHorizontal16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22,26H10a2,2,0,0,1-2-2V8a2,2,0,0,1,2-2H22a2,2,0,0,1,2,2V24A2,2,0,0,1,22,26ZM10,8V24H22V8Z"}),React.createElement("path",{d:"M4,24H0V22H4V10H0V8H4a2,2,0,0,1,2,2V22A2,2,0,0,1,4,24Z"}),React.createElement("path",{d:"M32,24H28a2,2,0,0,1-2-2V10a2,2,0,0,1,2-2h4v2H28V22h4Z"}),props.children);});var CarouselVertical32=/*#__PURE__*/React.forwardRef(function CarouselVertical32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,10V22a2,2,0,0,1-2,2H8a2,2,0,0,1-2-2V10A2,2,0,0,1,8,8H24A2,2,0,0,1,26,10ZM8,22H24V10H8Z"}),React.createElement("path",{d:"M24,28v4H22V28H10v4H8V28a2,2,0,0,1,2-2H22A2,2,0,0,1,24,28Z"}),React.createElement("path",{d:"M24,0V4a2,2,0,0,1-2,2H10A2,2,0,0,1,8,4V0h2V4H22V0Z"}),props.children);});var CarouselVertical24=/*#__PURE__*/React.forwardRef(function CarouselVertical24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,10V22a2,2,0,0,1-2,2H8a2,2,0,0,1-2-2V10A2,2,0,0,1,8,8H24A2,2,0,0,1,26,10ZM8,22H24V10H8Z"}),React.createElement("path",{d:"M24,28v4H22V28H10v4H8V28a2,2,0,0,1,2-2H22A2,2,0,0,1,24,28Z"}),React.createElement("path",{d:"M24,0V4a2,2,0,0,1-2,2H10A2,2,0,0,1,8,4V0h2V4H22V0Z"}),props.children);});var CarouselVertical20=/*#__PURE__*/React.forwardRef(function CarouselVertical20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,10V22a2,2,0,0,1-2,2H8a2,2,0,0,1-2-2V10A2,2,0,0,1,8,8H24A2,2,0,0,1,26,10ZM8,22H24V10H8Z"}),React.createElement("path",{d:"M24,28v4H22V28H10v4H8V28a2,2,0,0,1,2-2H22A2,2,0,0,1,24,28Z"}),React.createElement("path",{d:"M24,0V4a2,2,0,0,1-2,2H10A2,2,0,0,1,8,4V0h2V4H22V0Z"}),props.children);});var CarouselVertical16=/*#__PURE__*/React.forwardRef(function CarouselVertical16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,10V22a2,2,0,0,1-2,2H8a2,2,0,0,1-2-2V10A2,2,0,0,1,8,8H24A2,2,0,0,1,26,10ZM8,22H24V10H8Z"}),React.createElement("path",{d:"M24,28v4H22V28H10v4H8V28a2,2,0,0,1,2-2H22A2,2,0,0,1,24,28Z"}),React.createElement("path",{d:"M24,0V4a2,2,0,0,1-2,2H10A2,2,0,0,1,8,4V0h2V4H22V0Z"}),props.children);});var Catalog32=/*#__PURE__*/React.forwardRef(function Catalog32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,2H8A2,2,0,0,0,6,4V8H4v2H6v5H4v2H6v5H4v2H6v4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Zm0,26H8V24h2V22H8V17h2V15H8V10h2V8H8V4H26Z"}),React.createElement("rect",{width:"8",height:"2",x:"14",y:"8"}),React.createElement("rect",{width:"8",height:"2",x:"14",y:"15"}),React.createElement("rect",{width:"8",height:"2",x:"14",y:"22"}),props.children);});var Catalog24=/*#__PURE__*/React.forwardRef(function Catalog24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,2H8A2,2,0,0,0,6,4V8H4v2H6v5H4v2H6v5H4v2H6v4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Zm0,26H8V24h2V22H8V17h2V15H8V10h2V8H8V4H26Z"}),React.createElement("rect",{width:"8",height:"2",x:"14",y:"8"}),React.createElement("rect",{width:"8",height:"2",x:"14",y:"15"}),React.createElement("rect",{width:"8",height:"2",x:"14",y:"22"}),props.children);});var Catalog20=/*#__PURE__*/React.forwardRef(function Catalog20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,2H8A2,2,0,0,0,6,4V8H4v2H6v5H4v2H6v5H4v2H6v4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Zm0,26H8V24h2V22H8V17h2V15H8V10h2V8H8V4H26Z"}),React.createElement("rect",{width:"8",height:"2",x:"14",y:"8"}),React.createElement("rect",{width:"8",height:"2",x:"14",y:"15"}),React.createElement("rect",{width:"8",height:"2",x:"14",y:"22"}),props.children);});var Catalog16=/*#__PURE__*/React.forwardRef(function Catalog16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,2H8A2,2,0,0,0,6,4V8H4v2H6v5H4v2H6v5H4v2H6v4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V4A2,2,0,0,0,26,2Zm0,26H8V24h2V22H8V17h2V15H8V10h2V8H8V4H26Z"}),React.createElement("rect",{width:"8",height:"2",x:"14",y:"8"}),React.createElement("rect",{width:"8",height:"2",x:"14",y:"15"}),React.createElement("rect",{width:"8",height:"2",x:"14",y:"22"}),props.children);});var Categories32=/*#__PURE__*/React.forwardRef(function Categories32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6.76,6l.45.89L7.76,8H12v5H4V6H6.76m.62-2H3A1,1,0,0,0,2,5v9a1,1,0,0,0,1,1H13a1,1,0,0,0,1-1V7a1,1,0,0,0-1-1H9L8.28,4.55A1,1,0,0,0,7.38,4Z"}),React.createElement("path",{d:"M22.76,6l.45.89L23.76,8H28v5H20V6h2.76m.62-2H19a1,1,0,0,0-1,1v9a1,1,0,0,0,1,1H29a1,1,0,0,0,1-1V7a1,1,0,0,0-1-1H25l-.72-1.45a1,1,0,0,0-.9-.55Z"}),React.createElement("path",{d:"M6.76,19l.45.89L7.76,21H12v5H4V19H6.76m.62-2H3a1,1,0,0,0-1,1v9a1,1,0,0,0,1,1H13a1,1,0,0,0,1-1V20a1,1,0,0,0-1-1H9l-.72-1.45a1,1,0,0,0-.9-.55Z"}),React.createElement("path",{d:"M22.76,19l.45.89L23.76,21H28v5H20V19h2.76m.62-2H19a1,1,0,0,0-1,1v9a1,1,0,0,0,1,1H29a1,1,0,0,0,1-1V20a1,1,0,0,0-1-1H25l-.72-1.45a1,1,0,0,0-.9-.55Z"}),props.children);});var Categories24=/*#__PURE__*/React.forwardRef(function Categories24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6.76,6l.45.89L7.76,8H12v5H4V6H6.76m.62-2H3A1,1,0,0,0,2,5v9a1,1,0,0,0,1,1H13a1,1,0,0,0,1-1V7a1,1,0,0,0-1-1H9L8.28,4.55A1,1,0,0,0,7.38,4Z"}),React.createElement("path",{d:"M22.76,6l.45.89L23.76,8H28v5H20V6h2.76m.62-2H19a1,1,0,0,0-1,1v9a1,1,0,0,0,1,1H29a1,1,0,0,0,1-1V7a1,1,0,0,0-1-1H25l-.72-1.45a1,1,0,0,0-.9-.55Z"}),React.createElement("path",{d:"M6.76,19l.45.89L7.76,21H12v5H4V19H6.76m.62-2H3a1,1,0,0,0-1,1v9a1,1,0,0,0,1,1H13a1,1,0,0,0,1-1V20a1,1,0,0,0-1-1H9l-.72-1.45a1,1,0,0,0-.9-.55Z"}),React.createElement("path",{d:"M22.76,19l.45.89L23.76,21H28v5H20V19h2.76m.62-2H19a1,1,0,0,0-1,1v9a1,1,0,0,0,1,1H29a1,1,0,0,0,1-1V20a1,1,0,0,0-1-1H25l-.72-1.45a1,1,0,0,0-.9-.55Z"}),props.children);});var Categories20=/*#__PURE__*/React.forwardRef(function Categories20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6.76,6l.45.89L7.76,8H12v5H4V6H6.76m.62-2H3A1,1,0,0,0,2,5v9a1,1,0,0,0,1,1H13a1,1,0,0,0,1-1V7a1,1,0,0,0-1-1H9L8.28,4.55A1,1,0,0,0,7.38,4Z"}),React.createElement("path",{d:"M22.76,6l.45.89L23.76,8H28v5H20V6h2.76m.62-2H19a1,1,0,0,0-1,1v9a1,1,0,0,0,1,1H29a1,1,0,0,0,1-1V7a1,1,0,0,0-1-1H25l-.72-1.45a1,1,0,0,0-.9-.55Z"}),React.createElement("path",{d:"M6.76,19l.45.89L7.76,21H12v5H4V19H6.76m.62-2H3a1,1,0,0,0-1,1v9a1,1,0,0,0,1,1H13a1,1,0,0,0,1-1V20a1,1,0,0,0-1-1H9l-.72-1.45a1,1,0,0,0-.9-.55Z"}),React.createElement("path",{d:"M22.76,19l.45.89L23.76,21H28v5H20V19h2.76m.62-2H19a1,1,0,0,0-1,1v9a1,1,0,0,0,1,1H29a1,1,0,0,0,1-1V20a1,1,0,0,0-1-1H25l-.72-1.45a1,1,0,0,0-.9-.55Z"}),props.children);});var Categories16=/*#__PURE__*/React.forwardRef(function Categories16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6.76,6l.45.89L7.76,8H12v5H4V6H6.76m.62-2H3A1,1,0,0,0,2,5v9a1,1,0,0,0,1,1H13a1,1,0,0,0,1-1V7a1,1,0,0,0-1-1H9L8.28,4.55A1,1,0,0,0,7.38,4Z"}),React.createElement("path",{d:"M22.76,6l.45.89L23.76,8H28v5H20V6h2.76m.62-2H19a1,1,0,0,0-1,1v9a1,1,0,0,0,1,1H29a1,1,0,0,0,1-1V7a1,1,0,0,0-1-1H25l-.72-1.45a1,1,0,0,0-.9-.55Z"}),React.createElement("path",{d:"M6.76,19l.45.89L7.76,21H12v5H4V19H6.76m.62-2H3a1,1,0,0,0-1,1v9a1,1,0,0,0,1,1H13a1,1,0,0,0,1-1V20a1,1,0,0,0-1-1H9l-.72-1.45a1,1,0,0,0-.9-.55Z"}),React.createElement("path",{d:"M22.76,19l.45.89L23.76,21H28v5H20V19h2.76m.62-2H19a1,1,0,0,0-1,1v9a1,1,0,0,0,1,1H29a1,1,0,0,0,1-1V20a1,1,0,0,0-1-1H25l-.72-1.45a1,1,0,0,0-.9-.55Z"}),props.children);});var CategoryAdd32=/*#__PURE__*/React.forwardRef(function CategoryAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"15 6 13.59 7.41 17.17 11 13.59 14.59 15 16 20 11 15 6"}),React.createElement("path",{d:"M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"}),props.children);});var CategoryAdd24=/*#__PURE__*/React.forwardRef(function CategoryAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"15 6 13.59 7.41 17.17 11 13.59 14.59 15 16 20 11 15 6"}),React.createElement("path",{d:"M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"}),props.children);});var CategoryAdd20=/*#__PURE__*/React.forwardRef(function CategoryAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"15 6 13.59 7.41 17.17 11 13.59 14.59 15 16 20 11 15 6"}),React.createElement("path",{d:"M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"}),props.children);});var CategoryAdd16=/*#__PURE__*/React.forwardRef(function CategoryAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"15 6 13.59 7.41 17.17 11 13.59 14.59 15 16 20 11 15 6"}),React.createElement("path",{d:"M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"}),props.children);});var CategoryAnd32=/*#__PURE__*/React.forwardRef(function CategoryAnd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4,30V26H15v4h2V26H28v4h2V26a2,2,0,0,0-2-2H17V19H15v5H4a2,2,0,0,0-2,2v4Z"}),React.createElement("path",{d:"M20.6953,13.9858A10.08,10.08,0,0,0,21.9463,10H23V8H20V9a9.2634,9.2634,0,0,1-.6641,3.2705L16.6511,8.8816a5.1261,5.1261,0,0,0,2.1436-2.3694A3.2522,3.2522,0,0,0,18.6062,3.81a3.38,3.38,0,0,0-2.2391-1.7056,3.4688,3.4688,0,0,0-4.2223,2.1186c-.5044,1.5518.4406,3.1158,1.2612,4.1077A4.7255,4.7255,0,0,0,11.06,13.1587,4.4526,4.4526,0,0,0,15.4268,17h.0058a5.7844,5.7844,0,0,0,3.9717-1.4233L20.532,17h2.5519ZM14.047,4.8413A1.3224,1.3224,0,0,1,15.4141,4a2.41,2.41,0,0,1,.5214.0581,1.4018,1.4018,0,0,1,.9111.7022,1.2493,1.2493,0,0,1,.0791,1.042A3.6871,3.6871,0,0,1,15.2441,7.395C14.5831,6.6816,13.8087,5.5732,14.047,4.8413ZM15.4316,15h-.0039a2.4432,2.4432,0,0,1-2.3916-2.1509,2.8261,2.8261,0,0,1,1.81-3.0249l3.3115,4.1787A3.8853,3.8853,0,0,1,15.4316,15Z"}),props.children);});var CategoryAnd24=/*#__PURE__*/React.forwardRef(function CategoryAnd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4,30V26H15v4h2V26H28v4h2V26a2,2,0,0,0-2-2H17V19H15v5H4a2,2,0,0,0-2,2v4Z"}),React.createElement("path",{d:"M20.6953,13.9858A10.08,10.08,0,0,0,21.9463,10H23V8H20V9a9.2634,9.2634,0,0,1-.6641,3.2705L16.6511,8.8816a5.1261,5.1261,0,0,0,2.1436-2.3694A3.2522,3.2522,0,0,0,18.6062,3.81a3.38,3.38,0,0,0-2.2391-1.7056,3.4688,3.4688,0,0,0-4.2223,2.1186c-.5044,1.5518.4406,3.1158,1.2612,4.1077A4.7255,4.7255,0,0,0,11.06,13.1587,4.4526,4.4526,0,0,0,15.4268,17h.0058a5.7844,5.7844,0,0,0,3.9717-1.4233L20.532,17h2.5519ZM14.047,4.8413A1.3224,1.3224,0,0,1,15.4141,4a2.41,2.41,0,0,1,.5214.0581,1.4018,1.4018,0,0,1,.9111.7022,1.2493,1.2493,0,0,1,.0791,1.042A3.6871,3.6871,0,0,1,15.2441,7.395C14.5831,6.6816,13.8087,5.5732,14.047,4.8413ZM15.4316,15h-.0039a2.4432,2.4432,0,0,1-2.3916-2.1509,2.8261,2.8261,0,0,1,1.81-3.0249l3.3115,4.1787A3.8853,3.8853,0,0,1,15.4316,15Z"}),props.children);});var CategoryAnd20=/*#__PURE__*/React.forwardRef(function CategoryAnd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4,30V26H15v4h2V26H28v4h2V26a2,2,0,0,0-2-2H17V19H15v5H4a2,2,0,0,0-2,2v4Z"}),React.createElement("path",{d:"M20.6953,13.9858A10.08,10.08,0,0,0,21.9463,10H23V8H20V9a9.2634,9.2634,0,0,1-.6641,3.2705L16.6511,8.8816a5.1261,5.1261,0,0,0,2.1436-2.3694A3.2522,3.2522,0,0,0,18.6062,3.81a3.38,3.38,0,0,0-2.2391-1.7056,3.4688,3.4688,0,0,0-4.2223,2.1186c-.5044,1.5518.4406,3.1158,1.2612,4.1077A4.7255,4.7255,0,0,0,11.06,13.1587,4.4526,4.4526,0,0,0,15.4268,17h.0058a5.7844,5.7844,0,0,0,3.9717-1.4233L20.532,17h2.5519ZM14.047,4.8413A1.3224,1.3224,0,0,1,15.4141,4a2.41,2.41,0,0,1,.5214.0581,1.4018,1.4018,0,0,1,.9111.7022,1.2493,1.2493,0,0,1,.0791,1.042A3.6871,3.6871,0,0,1,15.2441,7.395C14.5831,6.6816,13.8087,5.5732,14.047,4.8413ZM15.4316,15h-.0039a2.4432,2.4432,0,0,1-2.3916-2.1509,2.8261,2.8261,0,0,1,1.81-3.0249l3.3115,4.1787A3.8853,3.8853,0,0,1,15.4316,15Z"}),props.children);});var CategoryAnd16=/*#__PURE__*/React.forwardRef(function CategoryAnd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4,30V26H15v4h2V26H28v4h2V26a2,2,0,0,0-2-2H17V19H15v5H4a2,2,0,0,0-2,2v4Z"}),React.createElement("path",{d:"M20.6953,13.9858A10.08,10.08,0,0,0,21.9463,10H23V8H20V9a9.2634,9.2634,0,0,1-.6641,3.2705L16.6511,8.8816a5.1261,5.1261,0,0,0,2.1436-2.3694A3.2522,3.2522,0,0,0,18.6062,3.81a3.38,3.38,0,0,0-2.2391-1.7056,3.4688,3.4688,0,0,0-4.2223,2.1186c-.5044,1.5518.4406,3.1158,1.2612,4.1077A4.7255,4.7255,0,0,0,11.06,13.1587,4.4526,4.4526,0,0,0,15.4268,17h.0058a5.7844,5.7844,0,0,0,3.9717-1.4233L20.532,17h2.5519ZM14.047,4.8413A1.3224,1.3224,0,0,1,15.4141,4a2.41,2.41,0,0,1,.5214.0581,1.4018,1.4018,0,0,1,.9111.7022,1.2493,1.2493,0,0,1,.0791,1.042A3.6871,3.6871,0,0,1,15.2441,7.395C14.5831,6.6816,13.8087,5.5732,14.047,4.8413ZM15.4316,15h-.0039a2.4432,2.4432,0,0,1-2.3916-2.1509,2.8261,2.8261,0,0,1,1.81-3.0249l3.3115,4.1787A3.8853,3.8853,0,0,1,15.4316,15Z"}),props.children);});var CategoryNewEach32=/*#__PURE__*/React.forwardRef(function CategoryNewEach32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,10H24v2h5v6H22v2h3v2.142a4,4,0,1,0,2,0V20h2a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,29,10ZM28,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,28,26Z"}),React.createElement("path",{d:"M19,6H14V8h5v6H12v2h3v6.142a4,4,0,1,0,2,0V16h2a2.0023,2.0023,0,0,0,2-2V8A2.0023,2.0023,0,0,0,19,6ZM18,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Z"}),React.createElement("path",{d:"M9,2H3A2.002,2.002,0,0,0,1,4v6a2.002,2.002,0,0,0,2,2H5V22.142a4,4,0,1,0,2,0V12H9a2.002,2.002,0,0,0,2-2V4A2.002,2.002,0,0,0,9,2ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26ZM3,10V4H9l.0015,6Z"}),props.children);});var CategoryNewEach24=/*#__PURE__*/React.forwardRef(function CategoryNewEach24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,10H24v2h5v6H22v2h3v2.142a4,4,0,1,0,2,0V20h2a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,29,10ZM28,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,28,26Z"}),React.createElement("path",{d:"M19,6H14V8h5v6H12v2h3v6.142a4,4,0,1,0,2,0V16h2a2.0023,2.0023,0,0,0,2-2V8A2.0023,2.0023,0,0,0,19,6ZM18,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Z"}),React.createElement("path",{d:"M9,2H3A2.002,2.002,0,0,0,1,4v6a2.002,2.002,0,0,0,2,2H5V22.142a4,4,0,1,0,2,0V12H9a2.002,2.002,0,0,0,2-2V4A2.002,2.002,0,0,0,9,2ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26ZM3,10V4H9l.0015,6Z"}),props.children);});var CategoryNewEach20=/*#__PURE__*/React.forwardRef(function CategoryNewEach20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,10H24v2h5v6H22v2h3v2.142a4,4,0,1,0,2,0V20h2a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,29,10ZM28,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,28,26Z"}),React.createElement("path",{d:"M19,6H14V8h5v6H12v2h3v6.142a4,4,0,1,0,2,0V16h2a2.0023,2.0023,0,0,0,2-2V8A2.0023,2.0023,0,0,0,19,6ZM18,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Z"}),React.createElement("path",{d:"M9,2H3A2.002,2.002,0,0,0,1,4v6a2.002,2.002,0,0,0,2,2H5V22.142a4,4,0,1,0,2,0V12H9a2.002,2.002,0,0,0,2-2V4A2.002,2.002,0,0,0,9,2ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26ZM3,10V4H9l.0015,6Z"}),props.children);});var CategoryNewEach16=/*#__PURE__*/React.forwardRef(function CategoryNewEach16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,10H24v2h5v6H22v2h3v2.142a4,4,0,1,0,2,0V20h2a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,29,10ZM28,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,28,26Z"}),React.createElement("path",{d:"M19,6H14V8h5v6H12v2h3v6.142a4,4,0,1,0,2,0V16h2a2.0023,2.0023,0,0,0,2-2V8A2.0023,2.0023,0,0,0,19,6ZM18,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Z"}),React.createElement("path",{d:"M9,2H3A2.002,2.002,0,0,0,1,4v6a2.002,2.002,0,0,0,2,2H5V22.142a4,4,0,1,0,2,0V12H9a2.002,2.002,0,0,0,2-2V4A2.002,2.002,0,0,0,9,2ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26ZM3,10V4H9l.0015,6Z"}),props.children);});var CategoryNew32=/*#__PURE__*/React.forwardRef(function CategoryNew32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"21 10 17 10 17 6 15 6 15 10 11 10 11 12 15 12 15 16 17 16 17 12 21 12 21 10"}),React.createElement("path",{d:"M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"}),props.children);});var CategoryNew24=/*#__PURE__*/React.forwardRef(function CategoryNew24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"21 10 17 10 17 6 15 6 15 10 11 10 11 12 15 12 15 16 17 16 17 12 21 12 21 10"}),React.createElement("path",{d:"M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"}),props.children);});var CategoryNew20=/*#__PURE__*/React.forwardRef(function CategoryNew20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"21 10 17 10 17 6 15 6 15 10 11 10 11 12 15 12 15 16 17 16 17 12 21 12 21 10"}),React.createElement("path",{d:"M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"}),props.children);});var CategoryNew16=/*#__PURE__*/React.forwardRef(function CategoryNew16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"21 10 17 10 17 6 15 6 15 10 11 10 11 12 15 12 15 16 17 16 17 12 21 12 21 10"}),React.createElement("path",{d:"M28,24H17V20h6a2.0027,2.0027,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H9A2.002,2.002,0,0,0,7,4V18a2.0023,2.0023,0,0,0,2,2h6v4H4a2,2,0,0,0-2,2v4H4V26H15v4h2V26H28v4h2V26A2,2,0,0,0,28,24ZM9,4H23l.002,14H9Z"}),props.children);});var Category32=/*#__PURE__*/React.forwardRef(function Category32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,22.1414V18a2,2,0,0,0-2-2H17V12h2a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H13a2.002,2.002,0,0,0-2,2v6a2.002,2.002,0,0,0,2,2h2v4H7a2,2,0,0,0-2,2v4.1421a4,4,0,1,0,2,0V18h8v4.142a4,4,0,1,0,2,0V18h8v4.1414a4,4,0,1,0,2,0ZM13,4h6l.001,6H13ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26Zm10,0a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Zm8,2a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,28Z"}),props.children);});var Category24=/*#__PURE__*/React.forwardRef(function Category24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,22.1414V18a2,2,0,0,0-2-2H17V12h2a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H13a2.002,2.002,0,0,0-2,2v6a2.002,2.002,0,0,0,2,2h2v4H7a2,2,0,0,0-2,2v4.1421a4,4,0,1,0,2,0V18h8v4.142a4,4,0,1,0,2,0V18h8v4.1414a4,4,0,1,0,2,0ZM13,4h6l.001,6H13ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26Zm10,0a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Zm8,2a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,28Z"}),props.children);});var Category20=/*#__PURE__*/React.forwardRef(function Category20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,22.1414V18a2,2,0,0,0-2-2H17V12h2a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H13a2.002,2.002,0,0,0-2,2v6a2.002,2.002,0,0,0,2,2h2v4H7a2,2,0,0,0-2,2v4.1421a4,4,0,1,0,2,0V18h8v4.142a4,4,0,1,0,2,0V18h8v4.1414a4,4,0,1,0,2,0ZM13,4h6l.001,6H13ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26Zm10,0a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Zm8,2a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,28Z"}),props.children);});var Category16=/*#__PURE__*/React.forwardRef(function Category16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,22.1414V18a2,2,0,0,0-2-2H17V12h2a2.0023,2.0023,0,0,0,2-2V4a2.0023,2.0023,0,0,0-2-2H13a2.002,2.002,0,0,0-2,2v6a2.002,2.002,0,0,0,2,2h2v4H7a2,2,0,0,0-2,2v4.1421a4,4,0,1,0,2,0V18h8v4.142a4,4,0,1,0,2,0V18h8v4.1414a4,4,0,1,0,2,0ZM13,4h6l.001,6H13ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26Zm10,0a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Zm8,2a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,28Z"}),props.children);});var CenterCircle32=/*#__PURE__*/React.forwardRef(function CenterCircle32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15H27.9492A12.0071,12.0071,0,0,0,17,4.0508V2H15V4.0508A12.0071,12.0071,0,0,0,4.0508,15H2v2H4.0508A12.0071,12.0071,0,0,0,15,27.9492V30h2V27.9492A12.0071,12.0071,0,0,0,27.9492,17H30ZM17,25.9492V22H15v3.9492A10.0166,10.0166,0,0,1,6.0508,17H10V15H6.0508A10.0166,10.0166,0,0,1,15,6.0508V10h2V6.0508A10.0166,10.0166,0,0,1,25.9492,15H22v2h3.9492A10.0166,10.0166,0,0,1,17,25.9492Z"}),props.children);});var CenterCircle24=/*#__PURE__*/React.forwardRef(function CenterCircle24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15H27.9492A12.0071,12.0071,0,0,0,17,4.0508V2H15V4.0508A12.0071,12.0071,0,0,0,4.0508,15H2v2H4.0508A12.0071,12.0071,0,0,0,15,27.9492V30h2V27.9492A12.0071,12.0071,0,0,0,27.9492,17H30ZM17,25.9492V22H15v3.9492A10.0166,10.0166,0,0,1,6.0508,17H10V15H6.0508A10.0166,10.0166,0,0,1,15,6.0508V10h2V6.0508A10.0166,10.0166,0,0,1,25.9492,15H22v2h3.9492A10.0166,10.0166,0,0,1,17,25.9492Z"}),props.children);});var CenterCircle20=/*#__PURE__*/React.forwardRef(function CenterCircle20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15H27.9492A12.0071,12.0071,0,0,0,17,4.0508V2H15V4.0508A12.0071,12.0071,0,0,0,4.0508,15H2v2H4.0508A12.0071,12.0071,0,0,0,15,27.9492V30h2V27.9492A12.0071,12.0071,0,0,0,27.9492,17H30ZM17,25.9492V22H15v3.9492A10.0166,10.0166,0,0,1,6.0508,17H10V15H6.0508A10.0166,10.0166,0,0,1,15,6.0508V10h2V6.0508A10.0166,10.0166,0,0,1,25.9492,15H22v2h3.9492A10.0166,10.0166,0,0,1,17,25.9492Z"}),props.children);});var CenterCircle16=/*#__PURE__*/React.forwardRef(function CenterCircle16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15H27.9492A12.0071,12.0071,0,0,0,17,4.0508V2H15V4.0508A12.0071,12.0071,0,0,0,4.0508,15H2v2H4.0508A12.0071,12.0071,0,0,0,15,27.9492V30h2V27.9492A12.0071,12.0071,0,0,0,27.9492,17H30ZM17,25.9492V22H15v3.9492A10.0166,10.0166,0,0,1,6.0508,17H10V15H6.0508A10.0166,10.0166,0,0,1,15,6.0508V10h2V6.0508A10.0166,10.0166,0,0,1,25.9492,15H22v2h3.9492A10.0166,10.0166,0,0,1,17,25.9492Z"}),props.children);});var CenterSquare32=/*#__PURE__*/React.forwardRef(function CenterSquare32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"6 12 4 12 4 4 12 4 12 6 6 6 6 12"}),React.createElement("polygon",{points:"28 12 26 12 26 6 20 6 20 4 28 4 28 12"}),React.createElement("polygon",{points:"12 28 4 28 4 20 6 20 6 26 12 26 12 28"}),React.createElement("polygon",{points:"28 28 20 28 20 26 26 26 26 20 28 20 28 28"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"10"}),React.createElement("rect",{width:"4",height:"2",x:"10",y:"15"}),React.createElement("rect",{width:"4",height:"2",x:"18",y:"15"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"18"}),props.children);});var CenterSquare24=/*#__PURE__*/React.forwardRef(function CenterSquare24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"6 12 4 12 4 4 12 4 12 6 6 6 6 12"}),React.createElement("polygon",{points:"28 12 26 12 26 6 20 6 20 4 28 4 28 12"}),React.createElement("polygon",{points:"12 28 4 28 4 20 6 20 6 26 12 26 12 28"}),React.createElement("polygon",{points:"28 28 20 28 20 26 26 26 26 20 28 20 28 28"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"10"}),React.createElement("rect",{width:"4",height:"2",x:"10",y:"15"}),React.createElement("rect",{width:"4",height:"2",x:"18",y:"15"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"18"}),props.children);});var CenterSquare20=/*#__PURE__*/React.forwardRef(function CenterSquare20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"6 12 4 12 4 4 12 4 12 6 6 6 6 12"}),React.createElement("polygon",{points:"28 12 26 12 26 6 20 6 20 4 28 4 28 12"}),React.createElement("polygon",{points:"12 28 4 28 4 20 6 20 6 26 12 26 12 28"}),React.createElement("polygon",{points:"28 28 20 28 20 26 26 26 26 20 28 20 28 28"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"10"}),React.createElement("rect",{width:"4",height:"2",x:"10",y:"15"}),React.createElement("rect",{width:"4",height:"2",x:"18",y:"15"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"18"}),props.children);});var CenterSquare16=/*#__PURE__*/React.forwardRef(function CenterSquare16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"6 12 4 12 4 4 12 4 12 6 6 6 6 12"}),React.createElement("polygon",{points:"28 12 26 12 26 6 20 6 20 4 28 4 28 12"}),React.createElement("polygon",{points:"12 28 4 28 4 20 6 20 6 26 12 26 12 28"}),React.createElement("polygon",{points:"28 28 20 28 20 26 26 26 26 20 28 20 28 28"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"10"}),React.createElement("rect",{width:"4",height:"2",x:"10",y:"15"}),React.createElement("rect",{width:"4",height:"2",x:"18",y:"15"}),React.createElement("rect",{width:"2",height:"4",x:"15",y:"18"}),props.children);});var CertificateCheck32=/*#__PURE__*/React.forwardRef(function CertificateCheck32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"6",y:"16"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"12"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"8"}),React.createElement("path",{d:"M14,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H14Z"}),React.createElement("polygon",{points:"22 25.59 19.41 23 18 24.41 22 28.41 30 20.41 28.59 19 22 25.59"}),props.children);});var CertificateCheck24=/*#__PURE__*/React.forwardRef(function CertificateCheck24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"6",y:"16"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"12"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"8"}),React.createElement("path",{d:"M14,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H14Z"}),React.createElement("polygon",{points:"22 25.59 19.41 23 18 24.41 22 28.41 30 20.41 28.59 19 22 25.59"}),props.children);});var CertificateCheck20=/*#__PURE__*/React.forwardRef(function CertificateCheck20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"6",y:"16"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"12"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"8"}),React.createElement("path",{d:"M14,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H14Z"}),React.createElement("polygon",{points:"22 25.59 19.41 23 18 24.41 22 28.41 30 20.41 28.59 19 22 25.59"}),props.children);});var CertificateCheck16=/*#__PURE__*/React.forwardRef(function CertificateCheck16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"6",y:"16"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"12"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"8"}),React.createElement("path",{d:"M14,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H14Z"}),React.createElement("polygon",{points:"22 25.59 19.41 23 18 24.41 22 28.41 30 20.41 28.59 19 22 25.59"}),props.children);});var Certificate32=/*#__PURE__*/React.forwardRef(function Certificate32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 17 25.912 20.703 30 21.297 27 24 27.771 28 24 25.75 20.229 28 21 24 18 21.297 22.2 20.703 24 17"}),React.createElement("rect",{width:"6",height:"2",x:"6",y:"16"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"12"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"8"}),React.createElement("path",{d:"M16,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H16Z"}),props.children);});var Certificate24=/*#__PURE__*/React.forwardRef(function Certificate24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 17 25.912 20.703 30 21.297 27 24 27.771 28 24 25.75 20.229 28 21 24 18 21.297 22.2 20.703 24 17"}),React.createElement("rect",{width:"6",height:"2",x:"6",y:"16"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"12"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"8"}),React.createElement("path",{d:"M16,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H16Z"}),props.children);});var Certificate20=/*#__PURE__*/React.forwardRef(function Certificate20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 17 25.912 20.703 30 21.297 27 24 27.771 28 24 25.75 20.229 28 21 24 18 21.297 22.2 20.703 24 17"}),React.createElement("rect",{width:"6",height:"2",x:"6",y:"16"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"12"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"8"}),React.createElement("path",{d:"M16,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H16Z"}),props.children);});var Certificate16=/*#__PURE__*/React.forwardRef(function Certificate16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 17 25.912 20.703 30 21.297 27 24 27.771 28 24 25.75 20.229 28 21 24 18 21.297 22.2 20.703 24 17"}),React.createElement("rect",{width:"6",height:"2",x:"6",y:"16"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"12"}),React.createElement("rect",{width:"10",height:"2",x:"6",y:"8"}),React.createElement("path",{d:"M16,26H4V6H28V16h2V6a2,2,0,0,0-2-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H16Z"}),props.children);});var ChangeCatalog32=/*#__PURE__*/React.forwardRef(function ChangeCatalog32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24v2h2.4592A5.94,5.94,0,0,1,22,28a6.0066,6.0066,0,0,1-6-6H14a7.9841,7.9841,0,0,0,14,5.2651V30h2V24Z"}),React.createElement("path",{d:"M22,14a8.04,8.04,0,0,0-6,2.7349V14H14v6h6V18H17.5408A5.94,5.94,0,0,1,22,16a6.0066,6.0066,0,0,1,6,6h2A8.0092,8.0092,0,0,0,22,14Z"}),React.createElement("path",{d:"M12,28H6V24H8V22H6V17H8V15H6V10H8V8H6V4H24v8h2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4V8H2v2H4v5H2v2H4v5H2v2H4v4a2,2,0,0,0,2,2h6Z"}),props.children);});var ChangeCatalog24=/*#__PURE__*/React.forwardRef(function ChangeCatalog24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24v2h2.4592A5.94,5.94,0,0,1,22,28a6.0066,6.0066,0,0,1-6-6H14a7.9841,7.9841,0,0,0,14,5.2651V30h2V24Z"}),React.createElement("path",{d:"M22,14a8.04,8.04,0,0,0-6,2.7349V14H14v6h6V18H17.5408A5.94,5.94,0,0,1,22,16a6.0066,6.0066,0,0,1,6,6h2A8.0092,8.0092,0,0,0,22,14Z"}),React.createElement("path",{d:"M12,28H6V24H8V22H6V17H8V15H6V10H8V8H6V4H24v8h2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4V8H2v2H4v5H2v2H4v5H2v2H4v4a2,2,0,0,0,2,2h6Z"}),props.children);});var ChangeCatalog20=/*#__PURE__*/React.forwardRef(function ChangeCatalog20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24v2h2.4592A5.94,5.94,0,0,1,22,28a6.0066,6.0066,0,0,1-6-6H14a7.9841,7.9841,0,0,0,14,5.2651V30h2V24Z"}),React.createElement("path",{d:"M22,14a8.04,8.04,0,0,0-6,2.7349V14H14v6h6V18H17.5408A5.94,5.94,0,0,1,22,16a6.0066,6.0066,0,0,1,6,6h2A8.0092,8.0092,0,0,0,22,14Z"}),React.createElement("path",{d:"M12,28H6V24H8V22H6V17H8V15H6V10H8V8H6V4H24v8h2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4V8H2v2H4v5H2v2H4v5H2v2H4v4a2,2,0,0,0,2,2h6Z"}),props.children);});var ChangeCatalog16=/*#__PURE__*/React.forwardRef(function ChangeCatalog16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24v2h2.4592A5.94,5.94,0,0,1,22,28a6.0066,6.0066,0,0,1-6-6H14a7.9841,7.9841,0,0,0,14,5.2651V30h2V24Z"}),React.createElement("path",{d:"M22,14a8.04,8.04,0,0,0-6,2.7349V14H14v6h6V18H17.5408A5.94,5.94,0,0,1,22,16a6.0066,6.0066,0,0,1,6,6h2A8.0092,8.0092,0,0,0,22,14Z"}),React.createElement("path",{d:"M12,28H6V24H8V22H6V17H8V15H6V10H8V8H6V4H24v8h2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4V8H2v2H4v5H2v2H4v5H2v2H4v4a2,2,0,0,0,2,2h6Z"}),props.children);});var CharacterPatterns32=/*#__PURE__*/React.forwardRef(function CharacterPatterns32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,26V17.8281l-3.5859,3.586L1,20l6-6,6,6-1.4141,1.4141L8,17.8281V26H18v2H8A2.0024,2.0024,0,0,1,6,26Z"}),React.createElement("polygon",{points:"30 22 30 20 22 20 22 22 27.5 22 22 28 22 30 30 30 30 28 24.507 28 30 22"}),React.createElement("path",{d:"M26,6v8.1719l3.5859-3.586L31,12l-6,6-6-6,1.4141-1.4141L24,14.1719V6H14V4H24A2.0024,2.0024,0,0,1,26,6Z"}),React.createElement("path",{d:"M8,2H3V4H8V6H4A2,2,0,0,0,2,8v2a2,2,0,0,0,2,2h6V4A2.0023,2.0023,0,0,0,8,2Zm0,8H4V8H8Z"}),props.children);});var CharacterPatterns24=/*#__PURE__*/React.forwardRef(function CharacterPatterns24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,26V17.8281l-3.5859,3.586L1,20l6-6,6,6-1.4141,1.4141L8,17.8281V26H18v2H8A2.0024,2.0024,0,0,1,6,26Z"}),React.createElement("polygon",{points:"30 22 30 20 22 20 22 22 27.5 22 22 28 22 30 30 30 30 28 24.507 28 30 22"}),React.createElement("path",{d:"M26,6v8.1719l3.5859-3.586L31,12l-6,6-6-6,1.4141-1.4141L24,14.1719V6H14V4H24A2.0024,2.0024,0,0,1,26,6Z"}),React.createElement("path",{d:"M8,2H3V4H8V6H4A2,2,0,0,0,2,8v2a2,2,0,0,0,2,2h6V4A2.0023,2.0023,0,0,0,8,2Zm0,8H4V8H8Z"}),props.children);});var CharacterPatterns20=/*#__PURE__*/React.forwardRef(function CharacterPatterns20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,26V17.8281l-3.5859,3.586L1,20l6-6,6,6-1.4141,1.4141L8,17.8281V26H18v2H8A2.0024,2.0024,0,0,1,6,26Z"}),React.createElement("polygon",{points:"30 22 30 20 22 20 22 22 27.5 22 22 28 22 30 30 30 30 28 24.507 28 30 22"}),React.createElement("path",{d:"M26,6v8.1719l3.5859-3.586L31,12l-6,6-6-6,1.4141-1.4141L24,14.1719V6H14V4H24A2.0024,2.0024,0,0,1,26,6Z"}),React.createElement("path",{d:"M8,2H3V4H8V6H4A2,2,0,0,0,2,8v2a2,2,0,0,0,2,2h6V4A2.0023,2.0023,0,0,0,8,2Zm0,8H4V8H8Z"}),props.children);});var CharacterPatterns16=/*#__PURE__*/React.forwardRef(function CharacterPatterns16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,26V17.8281l-3.5859,3.586L1,20l6-6,6,6-1.4141,1.4141L8,17.8281V26H18v2H8A2.0024,2.0024,0,0,1,6,26Z"}),React.createElement("polygon",{points:"30 22 30 20 22 20 22 22 27.5 22 22 28 22 30 30 30 30 28 24.507 28 30 22"}),React.createElement("path",{d:"M26,6v8.1719l3.5859-3.586L31,12l-6,6-6-6,1.4141-1.4141L24,14.1719V6H14V4H24A2.0024,2.0024,0,0,1,26,6Z"}),React.createElement("path",{d:"M8,2H3V4H8V6H4A2,2,0,0,0,2,8v2a2,2,0,0,0,2,2h6V4A2.0023,2.0023,0,0,0,8,2Zm0,8H4V8H8Z"}),props.children);});var ChargingStationFilled32=/*#__PURE__*/React.forwardRef(function ChargingStationFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,7V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1V7ZM11.8574,21.5146l-1.7148-1.0292L12.2339,17h-5l3.9087-6.5146,1.7148,1.0292L10.7661,15h5Z"}),React.createElement("polygon",{fill:"none",points:"11.857 21.514 10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514","data-icon-path":"inner-path"}),props.children);});var ChargingStationFilled24=/*#__PURE__*/React.forwardRef(function ChargingStationFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,7V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1V7ZM11.8574,21.5146l-1.7148-1.0292L12.2339,17h-5l3.9087-6.5146,1.7148,1.0292L10.7661,15h5Z"}),React.createElement("polygon",{fill:"none",points:"11.857 21.514 10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514","data-icon-path":"inner-path"}),props.children);});var ChargingStationFilled20=/*#__PURE__*/React.forwardRef(function ChargingStationFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,7V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1V7ZM11.8574,21.5146l-1.7148-1.0292L12.2339,17h-5l3.9087-6.5146,1.7148,1.0292L10.7661,15h5Z"}),React.createElement("polygon",{fill:"none",points:"11.857 21.514 10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514","data-icon-path":"inner-path"}),props.children);});var ChargingStationFilled16=/*#__PURE__*/React.forwardRef(function ChargingStationFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,7V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1V7ZM11.8574,21.5146l-1.7148-1.0292L12.2339,17h-5l3.9087-6.5146,1.7148,1.0292L10.7661,15h5Z"}),React.createElement("polygon",{fill:"none",points:"11.857 21.514 10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514","data-icon-path":"inner-path"}),props.children);});var ChargingStation32=/*#__PURE__*/React.forwardRef(function ChargingStation32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"11.857 21.514 10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514"}),React.createElement("path",{d:"M30,7H29V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1ZM17,26H6V6H17Z"}),props.children);});var ChargingStation24=/*#__PURE__*/React.forwardRef(function ChargingStation24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"11.857 21.514 10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514"}),React.createElement("path",{d:"M30,7H29V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1ZM17,26H6V6H17Z"}),props.children);});var ChargingStation20=/*#__PURE__*/React.forwardRef(function ChargingStation20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"11.857 21.514 10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514"}),React.createElement("path",{d:"M30,7H29V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1ZM17,26H6V6H17Z"}),props.children);});var ChargingStation16=/*#__PURE__*/React.forwardRef(function ChargingStation16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"11.857 21.514 10.143 20.486 12.234 17 7.234 17 11.143 10.486 12.857 11.514 10.766 15 15.766 15 11.857 21.514"}),React.createElement("path",{d:"M30,7H29V4H27V7H26v6h1V24.5a1.5,1.5,0,0,1-3,0V16a1,1,0,0,0-1-1H19V5a1,1,0,0,0-1-1H5A1,1,0,0,0,4,5V26H2v2H21V26H19V17h3v7.5a3.5,3.5,0,0,0,7,0V13h1ZM17,26H6V6H17Z"}),props.children);});var ChartBar32=/*#__PURE__*/React.forwardRef(function ChartBar32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,28V6H19V28H15V14H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V16h4Zm12,0H21V8h4Z"}),props.children);});var ChartBar24=/*#__PURE__*/React.forwardRef(function ChartBar24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,28V6H19V28H15V14H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V16h4Zm12,0H21V8h4Z"}),props.children);});var ChartBar20=/*#__PURE__*/React.forwardRef(function ChartBar20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,28V6H19V28H15V14H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V16h4Zm12,0H21V8h4Z"}),props.children);});var ChartBar16=/*#__PURE__*/React.forwardRef(function ChartBar16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,28V6H19V28H15V14H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V16h4Zm12,0H21V8h4Z"}),props.children);});var ChartBubble32=/*#__PURE__*/React.forwardRef(function ChartBubble32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"}),React.createElement("path",{d:"M10,16a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4,4,4,0,0,0-4-4Z"}),React.createElement("path",{d:"M21,6a4,4,0,1,1-4,4,4,4,0,0,1,4-4m0-2a6,6,0,1,0,6,6,6,6,0,0,0-6-6Z"}),React.createElement("path",{d:"M24.5,21A1.5,1.5,0,1,1,23,22.5,1.5,1.5,0,0,1,24.5,21m0-2A3.5,3.5,0,1,0,28,22.5,3.5,3.5,0,0,0,24.5,19Z"}),props.children);});var ChartBubble24=/*#__PURE__*/React.forwardRef(function ChartBubble24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"}),React.createElement("path",{d:"M10,16a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4,4,4,0,0,0-4-4Z"}),React.createElement("path",{d:"M21,6a4,4,0,1,1-4,4,4,4,0,0,1,4-4m0-2a6,6,0,1,0,6,6,6,6,0,0,0-6-6Z"}),React.createElement("path",{d:"M24.5,21A1.5,1.5,0,1,1,23,22.5,1.5,1.5,0,0,1,24.5,21m0-2A3.5,3.5,0,1,0,28,22.5,3.5,3.5,0,0,0,24.5,19Z"}),props.children);});var ChartBubble20=/*#__PURE__*/React.forwardRef(function ChartBubble20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"}),React.createElement("path",{d:"M10,16a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4,4,4,0,0,0-4-4Z"}),React.createElement("path",{d:"M21,6a4,4,0,1,1-4,4,4,4,0,0,1,4-4m0-2a6,6,0,1,0,6,6,6,6,0,0,0-6-6Z"}),React.createElement("path",{d:"M24.5,21A1.5,1.5,0,1,1,23,22.5,1.5,1.5,0,0,1,24.5,21m0-2A3.5,3.5,0,1,0,28,22.5,3.5,3.5,0,0,0,24.5,19Z"}),props.children);});var ChartBubble16=/*#__PURE__*/React.forwardRef(function ChartBubble16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"}),React.createElement("path",{d:"M10,16a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4,4,4,0,0,0-4-4Z"}),React.createElement("path",{d:"M21,6a4,4,0,1,1-4,4,4,4,0,0,1,4-4m0-2a6,6,0,1,0,6,6,6,6,0,0,0-6-6Z"}),React.createElement("path",{d:"M24.5,21A1.5,1.5,0,1,1,23,22.5,1.5,1.5,0,0,1,24.5,21m0-2A3.5,3.5,0,1,0,28,22.5,3.5,3.5,0,0,0,24.5,19Z"}),props.children);});var ChartLineData32=/*#__PURE__*/React.forwardRef(function ChartLineData32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10.06,17.88A4.25,4.25,0,0,0,11,18a4,4,0,0,0,2.23-.68l3.22,2.87a3.88,3.88,0,0,0-.2,3.17A4,4,0,1,0,22.62,19l2.54-5.09a3.78,3.78,0,0,0,2.91-.53A4,4,0,1,0,23.38,13l-2.54,5.09A3.86,3.86,0,0,0,20,18a4,4,0,0,0-2.23.68l-3.22-2.87a3.88,3.88,0,0,0,.2-3.17A4,4,0,1,0,8.3,16.93L4,25V2H2V28a2,2,0,0,0,2,2H30V28H4.67ZM26,8a2,2,0,1,1-2,2A2,2,0,0,1,26,8ZM22,22a2,2,0,1,1-2-2A2,2,0,0,1,22,22ZM11,12a2,2,0,1,1-2,2A2,2,0,0,1,11,12Z"}),props.children);});var ChartLineData24=/*#__PURE__*/React.forwardRef(function ChartLineData24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10.06,17.88A4.25,4.25,0,0,0,11,18a4,4,0,0,0,2.23-.68l3.22,2.87a3.88,3.88,0,0,0-.2,3.17A4,4,0,1,0,22.62,19l2.54-5.09a3.78,3.78,0,0,0,2.91-.53A4,4,0,1,0,23.38,13l-2.54,5.09A3.86,3.86,0,0,0,20,18a4,4,0,0,0-2.23.68l-3.22-2.87a3.88,3.88,0,0,0,.2-3.17A4,4,0,1,0,8.3,16.93L4,25V2H2V28a2,2,0,0,0,2,2H30V28H4.67ZM26,8a2,2,0,1,1-2,2A2,2,0,0,1,26,8ZM22,22a2,2,0,1,1-2-2A2,2,0,0,1,22,22ZM11,12a2,2,0,1,1-2,2A2,2,0,0,1,11,12Z"}),props.children);});var ChartLineData20=/*#__PURE__*/React.forwardRef(function ChartLineData20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10.06,17.88A4.25,4.25,0,0,0,11,18a4,4,0,0,0,2.23-.68l3.22,2.87a3.88,3.88,0,0,0-.2,3.17A4,4,0,1,0,22.62,19l2.54-5.09a3.78,3.78,0,0,0,2.91-.53A4,4,0,1,0,23.38,13l-2.54,5.09A3.86,3.86,0,0,0,20,18a4,4,0,0,0-2.23.68l-3.22-2.87a3.88,3.88,0,0,0,.2-3.17A4,4,0,1,0,8.3,16.93L4,25V2H2V28a2,2,0,0,0,2,2H30V28H4.67ZM26,8a2,2,0,1,1-2,2A2,2,0,0,1,26,8ZM22,22a2,2,0,1,1-2-2A2,2,0,0,1,22,22ZM11,12a2,2,0,1,1-2,2A2,2,0,0,1,11,12Z"}),props.children);});var ChartLineData16=/*#__PURE__*/React.forwardRef(function ChartLineData16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10.06,17.88A4.25,4.25,0,0,0,11,18a4,4,0,0,0,2.23-.68l3.22,2.87a3.88,3.88,0,0,0-.2,3.17A4,4,0,1,0,22.62,19l2.54-5.09a3.78,3.78,0,0,0,2.91-.53A4,4,0,1,0,23.38,13l-2.54,5.09A3.86,3.86,0,0,0,20,18a4,4,0,0,0-2.23.68l-3.22-2.87a3.88,3.88,0,0,0,.2-3.17A4,4,0,1,0,8.3,16.93L4,25V2H2V28a2,2,0,0,0,2,2H30V28H4.67ZM26,8a2,2,0,1,1-2,2A2,2,0,0,1,26,8ZM22,22a2,2,0,1,1-2-2A2,2,0,0,1,22,22ZM11,12a2,2,0,1,1-2,2A2,2,0,0,1,11,12Z"}),props.children);});var ChartLine32=/*#__PURE__*/React.forwardRef(function ChartLine32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4.67,28l6.39-12,7.3,6.49a2,2,0,0,0,1.7.47,2,2,0,0,0,1.42-1.07L27,10.9,25.18,10,19.69,21l-7.3-6.49A2,2,0,0,0,10.71,14a2,2,0,0,0-1.42,1L4,25V2H2V28a2,2,0,0,0,2,2H30V28Z"}),props.children);});var ChartLine24=/*#__PURE__*/React.forwardRef(function ChartLine24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4.67,28l6.39-12,7.3,6.49a2,2,0,0,0,1.7.47,2,2,0,0,0,1.42-1.07L27,10.9,25.18,10,19.69,21l-7.3-6.49A2,2,0,0,0,10.71,14a2,2,0,0,0-1.42,1L4,25V2H2V28a2,2,0,0,0,2,2H30V28Z"}),props.children);});var ChartLine20=/*#__PURE__*/React.forwardRef(function ChartLine20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4.67,28l6.39-12,7.3,6.49a2,2,0,0,0,1.7.47,2,2,0,0,0,1.42-1.07L27,10.9,25.18,10,19.69,21l-7.3-6.49A2,2,0,0,0,10.71,14a2,2,0,0,0-1.42,1L4,25V2H2V28a2,2,0,0,0,2,2H30V28Z"}),props.children);});var ChartLine16=/*#__PURE__*/React.forwardRef(function ChartLine16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M4.67,28l6.39-12,7.3,6.49a2,2,0,0,0,1.7.47,2,2,0,0,0,1.42-1.07L27,10.9,25.18,10,19.69,21l-7.3-6.49A2,2,0,0,0,10.71,14a2,2,0,0,0-1.42,1L4,25V2H2V28a2,2,0,0,0,2,2H30V28Z"}),props.children);});var ChartNetwork32=/*#__PURE__*/React.forwardRef(function ChartNetwork32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,14a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h2v4.1A5,5,0,0,0,18.1,22H14V20a2,2,0,0,0-2-2H10V13.9a5,5,0,1,0-2,0V18H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V24h4.1A5,5,0,1,0,24,18.1V14ZM6,9a3,3,0,1,1,3,3A3,3,0,0,1,6,9Zm6,17H6V20h6Zm14-3a3,3,0,1,1-3-3A3,3,0,0,1,26,23ZM20,6h6v6H20Z"}),props.children);});var ChartNetwork24=/*#__PURE__*/React.forwardRef(function ChartNetwork24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,14a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h2v4.1A5,5,0,0,0,18.1,22H14V20a2,2,0,0,0-2-2H10V13.9a5,5,0,1,0-2,0V18H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V24h4.1A5,5,0,1,0,24,18.1V14ZM6,9a3,3,0,1,1,3,3A3,3,0,0,1,6,9Zm6,17H6V20h6Zm14-3a3,3,0,1,1-3-3A3,3,0,0,1,26,23ZM20,6h6v6H20Z"}),props.children);});var ChartNetwork20=/*#__PURE__*/React.forwardRef(function ChartNetwork20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,14a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h2v4.1A5,5,0,0,0,18.1,22H14V20a2,2,0,0,0-2-2H10V13.9a5,5,0,1,0-2,0V18H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V24h4.1A5,5,0,1,0,24,18.1V14ZM6,9a3,3,0,1,1,3,3A3,3,0,0,1,6,9Zm6,17H6V20h6Zm14-3a3,3,0,1,1-3-3A3,3,0,0,1,26,23ZM20,6h6v6H20Z"}),props.children);});var ChartNetwork16=/*#__PURE__*/React.forwardRef(function ChartNetwork16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,14a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h2v4.1A5,5,0,0,0,18.1,22H14V20a2,2,0,0,0-2-2H10V13.9a5,5,0,1,0-2,0V18H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V24h4.1A5,5,0,1,0,24,18.1V14ZM6,9a3,3,0,1,1,3,3A3,3,0,0,1,6,9Zm6,17H6V20h6Zm14-3a3,3,0,1,1-3-3A3,3,0,0,1,26,23ZM20,6h6v6H20Z"}),props.children);});var ChartPie32=/*#__PURE__*/React.forwardRef(function ChartPie32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,4A12,12,0,1,0,28,16,12,12,0,0,0,16,4ZM26,15H17V6.05A10,10,0,0,1,26,15ZM15.42,26A10,10,0,0,1,15,6.05v9a2,2,0,0,0,2,2h9A10,10,0,0,1,15.42,26Z"}),props.children);});var ChartPie24=/*#__PURE__*/React.forwardRef(function ChartPie24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,4A12,12,0,1,0,28,16,12,12,0,0,0,16,4ZM26,15H17V6.05A10,10,0,0,1,26,15ZM15.42,26A10,10,0,0,1,15,6.05v9a2,2,0,0,0,2,2h9A10,10,0,0,1,15.42,26Z"}),props.children);});var ChartPie20=/*#__PURE__*/React.forwardRef(function ChartPie20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,4A12,12,0,1,0,28,16,12,12,0,0,0,16,4ZM26,15H17V6.05A10,10,0,0,1,26,15ZM15.42,26A10,10,0,0,1,15,6.05v9a2,2,0,0,0,2,2h9A10,10,0,0,1,15.42,26Z"}),props.children);});var ChartPie16=/*#__PURE__*/React.forwardRef(function ChartPie16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,4A12,12,0,1,0,28,16,12,12,0,0,0,16,4ZM26,15H17V6.05A10,10,0,0,1,26,15ZM15.42,26A10,10,0,0,1,15,6.05v9a2,2,0,0,0,2,2h9A10,10,0,0,1,15.42,26Z"}),props.children);});var ChartScatter32=/*#__PURE__*/React.forwardRef(function ChartScatter32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"}),React.createElement("circle",{cx:"10",cy:"22",r:"2"}),React.createElement("circle",{cx:"14",cy:"15",r:"2"}),React.createElement("circle",{cx:"22",cy:"15",r:"2"}),React.createElement("circle",{cx:"26",cy:"6",r:"2"}),React.createElement("circle",{cx:"14",cy:"8",r:"2"}),props.children);});var ChartScatter24=/*#__PURE__*/React.forwardRef(function ChartScatter24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"}),React.createElement("circle",{cx:"10",cy:"22",r:"2"}),React.createElement("circle",{cx:"14",cy:"15",r:"2"}),React.createElement("circle",{cx:"22",cy:"15",r:"2"}),React.createElement("circle",{cx:"26",cy:"6",r:"2"}),React.createElement("circle",{cx:"14",cy:"8",r:"2"}),props.children);});var ChartScatter20=/*#__PURE__*/React.forwardRef(function ChartScatter20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"}),React.createElement("circle",{cx:"10",cy:"22",r:"2"}),React.createElement("circle",{cx:"14",cy:"15",r:"2"}),React.createElement("circle",{cx:"22",cy:"15",r:"2"}),React.createElement("circle",{cx:"26",cy:"6",r:"2"}),React.createElement("circle",{cx:"14",cy:"8",r:"2"}),props.children);});var ChartScatter16=/*#__PURE__*/React.forwardRef(function ChartScatter16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,30H4a2,2,0,0,1-2-2V2H4V28H30Z"}),React.createElement("circle",{cx:"10",cy:"22",r:"2"}),React.createElement("circle",{cx:"14",cy:"15",r:"2"}),React.createElement("circle",{cx:"22",cy:"15",r:"2"}),React.createElement("circle",{cx:"26",cy:"6",r:"2"}),React.createElement("circle",{cx:"14",cy:"8",r:"2"}),props.children);});var ChartVennDiagram32=/*#__PURE__*/React.forwardRef(function ChartVennDiagram32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,6a9.92,9.92,0,0,0-4,.84A9.92,9.92,0,0,0,12,6a10,10,0,0,0,0,20,9.92,9.92,0,0,0,4-.84A9.92,9.92,0,0,0,20,26,10,10,0,0,0,20,6ZM12,24A8,8,0,0,1,12,8a7.91,7.91,0,0,1,1.76.2,10,10,0,0,0,0,15.6A7.91,7.91,0,0,1,12,24Zm8-8a8,8,0,0,1-4,6.92A8,8,0,0,1,16,9.08,8,8,0,0,1,20,16Zm0,8a7.91,7.91,0,0,1-1.76-.2,10,10,0,0,0,0-15.6A7.91,7.91,0,0,1,20,8a8,8,0,0,1,0,16Z"}),props.children);});var ChartVennDiagram24=/*#__PURE__*/React.forwardRef(function ChartVennDiagram24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,6a9.92,9.92,0,0,0-4,.84A9.92,9.92,0,0,0,12,6a10,10,0,0,0,0,20,9.92,9.92,0,0,0,4-.84A9.92,9.92,0,0,0,20,26,10,10,0,0,0,20,6ZM12,24A8,8,0,0,1,12,8a7.91,7.91,0,0,1,1.76.2,10,10,0,0,0,0,15.6A7.91,7.91,0,0,1,12,24Zm8-8a8,8,0,0,1-4,6.92A8,8,0,0,1,16,9.08,8,8,0,0,1,20,16Zm0,8a7.91,7.91,0,0,1-1.76-.2,10,10,0,0,0,0-15.6A7.91,7.91,0,0,1,20,8a8,8,0,0,1,0,16Z"}),props.children);});var ChartVennDiagram20=/*#__PURE__*/React.forwardRef(function ChartVennDiagram20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,6a9.92,9.92,0,0,0-4,.84A9.92,9.92,0,0,0,12,6a10,10,0,0,0,0,20,9.92,9.92,0,0,0,4-.84A9.92,9.92,0,0,0,20,26,10,10,0,0,0,20,6ZM12,24A8,8,0,0,1,12,8a7.91,7.91,0,0,1,1.76.2,10,10,0,0,0,0,15.6A7.91,7.91,0,0,1,12,24Zm8-8a8,8,0,0,1-4,6.92A8,8,0,0,1,16,9.08,8,8,0,0,1,20,16Zm0,8a7.91,7.91,0,0,1-1.76-.2,10,10,0,0,0,0-15.6A7.91,7.91,0,0,1,20,8a8,8,0,0,1,0,16Z"}),props.children);});var ChartVennDiagram16=/*#__PURE__*/React.forwardRef(function ChartVennDiagram16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,6a9.92,9.92,0,0,0-4,.84A9.92,9.92,0,0,0,12,6a10,10,0,0,0,0,20,9.92,9.92,0,0,0,4-.84A9.92,9.92,0,0,0,20,26,10,10,0,0,0,20,6ZM12,24A8,8,0,0,1,12,8a7.91,7.91,0,0,1,1.76.2,10,10,0,0,0,0,15.6A7.91,7.91,0,0,1,12,24Zm8-8a8,8,0,0,1-4,6.92A8,8,0,0,1,16,9.08,8,8,0,0,1,20,16Zm0,8a7.91,7.91,0,0,1-1.76-.2,10,10,0,0,0,0-15.6A7.91,7.91,0,0,1,20,8a8,8,0,0,1,0,16Z"}),props.children);});var ChatBot32=/*#__PURE__*/React.forwardRef(function ChatBot32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,19a6.9908,6.9908,0,0,1-5.833-3.1287l1.666-1.1074a5.0007,5.0007,0,0,0,8.334,0l1.666,1.1074A6.9908,6.9908,0,0,1,16,19Z"}),React.createElement("path",{d:"M20,8a2,2,0,1,0,2,2A1.9806,1.9806,0,0,0,20,8Z"}),React.createElement("path",{d:"M12,8a2,2,0,1,0,2,2A1.9806,1.9806,0,0,0,12,8Z"}),React.createElement("path",{d:"M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V6a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,6V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V6A3.9988,3.9988,0,0,1,6,2H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"}),props.children);});var ChatBot24=/*#__PURE__*/React.forwardRef(function ChatBot24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,19a6.9908,6.9908,0,0,1-5.833-3.1287l1.666-1.1074a5.0007,5.0007,0,0,0,8.334,0l1.666,1.1074A6.9908,6.9908,0,0,1,16,19Z"}),React.createElement("path",{d:"M20,8a2,2,0,1,0,2,2A1.9806,1.9806,0,0,0,20,8Z"}),React.createElement("path",{d:"M12,8a2,2,0,1,0,2,2A1.9806,1.9806,0,0,0,12,8Z"}),React.createElement("path",{d:"M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V6a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,6V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V6A3.9988,3.9988,0,0,1,6,2H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"}),props.children);});var ChatBot20=/*#__PURE__*/React.forwardRef(function ChatBot20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,19a6.9908,6.9908,0,0,1-5.833-3.1287l1.666-1.1074a5.0007,5.0007,0,0,0,8.334,0l1.666,1.1074A6.9908,6.9908,0,0,1,16,19Z"}),React.createElement("path",{d:"M20,8a2,2,0,1,0,2,2A1.9806,1.9806,0,0,0,20,8Z"}),React.createElement("path",{d:"M12,8a2,2,0,1,0,2,2A1.9806,1.9806,0,0,0,12,8Z"}),React.createElement("path",{d:"M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V6a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,6V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V6A3.9988,3.9988,0,0,1,6,2H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"}),props.children);});var ChatBot16=/*#__PURE__*/React.forwardRef(function ChatBot16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,19a6.9908,6.9908,0,0,1-5.833-3.1287l1.666-1.1074a5.0007,5.0007,0,0,0,8.334,0l1.666,1.1074A6.9908,6.9908,0,0,1,16,19Z"}),React.createElement("path",{d:"M20,8a2,2,0,1,0,2,2A1.9806,1.9806,0,0,0,20,8Z"}),React.createElement("path",{d:"M12,8a2,2,0,1,0,2,2A1.9806,1.9806,0,0,0,12,8Z"}),React.createElement("path",{d:"M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V6a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,6V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V6A3.9988,3.9988,0,0,1,6,2H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"}),props.children);});var Chat32=/*#__PURE__*/React.forwardRef(function Chat32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"}),React.createElement("rect",{width:"16",height:"2",x:"8",y:"10"}),React.createElement("rect",{width:"10",height:"2",x:"8",y:"16"}),props.children);});var Chat24=/*#__PURE__*/React.forwardRef(function Chat24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"}),React.createElement("rect",{width:"16",height:"2",x:"8",y:"10"}),React.createElement("rect",{width:"10",height:"2",x:"8",y:"16"}),props.children);});var Chat20=/*#__PURE__*/React.forwardRef(function Chat20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"}),React.createElement("rect",{width:"16",height:"2",x:"8",y:"10"}),React.createElement("rect",{width:"10",height:"2",x:"8",y:"16"}),props.children);});var Chat16=/*#__PURE__*/React.forwardRef(function Chat16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17.74,30,16,29l4-7h6a2,2,0,0,0,2-2V8a2,2,0,0,0-2-2H6A2,2,0,0,0,4,8V20a2,2,0,0,0,2,2h9v2H6a4,4,0,0,1-4-4V8A4,4,0,0,1,6,4H26a4,4,0,0,1,4,4V20a4,4,0,0,1-4,4H21.16Z"}),React.createElement("rect",{width:"16",height:"2",x:"8",y:"10"}),React.createElement("rect",{width:"10",height:"2",x:"8",y:"16"}),props.children);});var CheckboxCheckedFilled32=/*#__PURE__*/React.forwardRef(function CheckboxCheckedFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM14,21.5l-5-5L10.59,15,14,18.35,21.41,11,23,12.58Z"}),props.children);});var CheckboxCheckedFilled24=/*#__PURE__*/React.forwardRef(function CheckboxCheckedFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM14,21.5l-5-5L10.59,15,14,18.35,21.41,11,23,12.58Z"}),props.children);});var CheckboxCheckedFilled20=/*#__PURE__*/React.forwardRef(function CheckboxCheckedFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM14,21.5l-5-5L10.59,15,14,18.35,21.41,11,23,12.58Z"}),props.children);});var CheckboxCheckedFilled16=/*#__PURE__*/React.forwardRef(function CheckboxCheckedFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM14,21.5l-5-5L10.59,15,14,18.35,21.41,11,23,12.58Z"}),props.children);});var CheckboxChecked32=/*#__PURE__*/React.forwardRef(function CheckboxChecked32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),React.createElement("polygon",{points:"14 21.5 9 16.54 10.59 15 14 18.35 21.41 11 23 12.58 14 21.5"}),props.children);});var CheckboxChecked24=/*#__PURE__*/React.forwardRef(function CheckboxChecked24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),React.createElement("polygon",{points:"14 21.5 9 16.54 10.59 15 14 18.35 21.41 11 23 12.58 14 21.5"}),props.children);});var CheckboxChecked20=/*#__PURE__*/React.forwardRef(function CheckboxChecked20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),React.createElement("polygon",{points:"14 21.5 9 16.54 10.59 15 14 18.35 21.41 11 23 12.58 14 21.5"}),props.children);});var CheckboxChecked16=/*#__PURE__*/React.forwardRef(function CheckboxChecked16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),React.createElement("polygon",{points:"14 21.5 9 16.54 10.59 15 14 18.35 21.41 11 23 12.58 14 21.5"}),props.children);});var CheckboxIndeterminateFilled32=/*#__PURE__*/React.forwardRef(function CheckboxIndeterminateFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM22,18H10V14H22Z"}),props.children);});var CheckboxIndeterminateFilled24=/*#__PURE__*/React.forwardRef(function CheckboxIndeterminateFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM22,18H10V14H22Z"}),props.children);});var CheckboxIndeterminateFilled20=/*#__PURE__*/React.forwardRef(function CheckboxIndeterminateFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM22,18H10V14H22Z"}),props.children);});var CheckboxIndeterminateFilled16=/*#__PURE__*/React.forwardRef(function CheckboxIndeterminateFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM22,18H10V14H22Z"}),props.children);});var CheckboxIndeterminate32=/*#__PURE__*/React.forwardRef(function CheckboxIndeterminate32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"12",height:"4",x:"10",y:"14"}),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),props.children);});var CheckboxIndeterminate24=/*#__PURE__*/React.forwardRef(function CheckboxIndeterminate24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"12",height:"4",x:"10",y:"14"}),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),props.children);});var CheckboxIndeterminate20=/*#__PURE__*/React.forwardRef(function CheckboxIndeterminate20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"12",height:"4",x:"10",y:"14"}),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),props.children);});var CheckboxIndeterminate16=/*#__PURE__*/React.forwardRef(function CheckboxIndeterminate16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"12",height:"4",x:"10",y:"14"}),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),props.children);});var CheckboxUndeterminateFilled32=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminateFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM22,18H10V14H22Z"}),props.children);});var CheckboxUndeterminateFilled24=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminateFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM22,18H10V14H22Z"}),props.children);});var CheckboxUndeterminateFilled20=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminateFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM22,18H10V14H22Z"}),props.children);});var CheckboxUndeterminateFilled16=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminateFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM22,18H10V14H22Z"}),props.children);});var CheckboxUndeterminate32=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminate32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"12",height:"4",x:"10",y:"14"}),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),props.children);});var CheckboxUndeterminate24=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminate24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"12",height:"4",x:"10",y:"14"}),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),props.children);});var CheckboxUndeterminate20=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminate20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"12",height:"4",x:"10",y:"14"}),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),props.children);});var CheckboxUndeterminate16=/*#__PURE__*/React.forwardRef(function CheckboxUndeterminate16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"12",height:"4",x:"10",y:"14"}),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),props.children);});var Checkbox32=/*#__PURE__*/React.forwardRef(function Checkbox32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),props.children);});var Checkbox24=/*#__PURE__*/React.forwardRef(function Checkbox24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),props.children);});var Checkbox20=/*#__PURE__*/React.forwardRef(function Checkbox20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),props.children);});var Checkbox16=/*#__PURE__*/React.forwardRef(function Checkbox16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4ZM6,26V6H26V26Z"}),props.children);});var CheckmarkFilled32=/*#__PURE__*/React.forwardRef(function CheckmarkFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.3,2,2,8.3,2,16s6.3,14,14,14s14-6.3,14-14S23.7,2,16,2z M14,21.5l-5-5l1.6-1.5l3.4,3.4l7.4-7.4l1.6,1.6L14,21.5z"}),React.createElement("path",{d:"M14,21.5l-5-5l1.6-1.5l3.4,3.4l7.4-7.4l1.6,1.6L14,21.5z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var CheckmarkOutline32=/*#__PURE__*/React.forwardRef(function CheckmarkOutline32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("polygon",{points:"14 21.5 9 16.54 10.59 14.97 14 18.35 21.41 11 23 12.58 14 21.5"}),props.children);});var CheckmarkOutline24=/*#__PURE__*/React.forwardRef(function CheckmarkOutline24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("polygon",{points:"14 21.5 9 16.54 10.59 14.97 14 18.35 21.41 11 23 12.58 14 21.5"}),props.children);});var CheckmarkOutline20=/*#__PURE__*/React.forwardRef(function CheckmarkOutline20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("polygon",{points:"14 21.5 9 16.54 10.59 14.97 14 18.35 21.41 11 23 12.58 14 21.5"}),props.children);});var CheckmarkOutline16=/*#__PURE__*/React.forwardRef(function CheckmarkOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("polygon",{points:"14 21.5 9 16.54 10.59 14.97 14 18.35 21.41 11 23 12.58 14 21.5"}),props.children);});var Checkmark32=/*#__PURE__*/React.forwardRef(function Checkmark32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12,21.2 4.9,14.1 3.5,15.5 10.6,22.6 12,24 26.1,9.9 24.7,8.4"}),props.children);});var Checkmark16=/*#__PURE__*/React.forwardRef(function Checkmark16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12,21.2 4.9,14.1 3.5,15.5 10.6,22.6 12,24 26.1,9.9 24.7,8.4"}),props.children);});var Chemistry32=/*#__PURE__*/React.forwardRef(function Chemistry32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.2314,23.6182,20,13.6748V4h2V2H10V4h2v9.6748L4.7686,23.6182A4.0183,4.0183,0,0,0,8.0186,30H23.9814a4.0183,4.0183,0,0,0,3.25-6.3818ZM14,14.3252V4h4V14.3252L20.6728,18H11.3272ZM23.9814,28H8.0186a2.0192,2.0192,0,0,1-1.6329-3.2061L9.8726,20H22.1274l3.4869,4.7939A2.0192,2.0192,0,0,1,23.9814,28Z"}),props.children);});var Chemistry24=/*#__PURE__*/React.forwardRef(function Chemistry24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.2314,23.6182,20,13.6748V4h2V2H10V4h2v9.6748L4.7686,23.6182A4.0183,4.0183,0,0,0,8.0186,30H23.9814a4.0183,4.0183,0,0,0,3.25-6.3818ZM14,14.3252V4h4V14.3252L20.6728,18H11.3272ZM23.9814,28H8.0186a2.0192,2.0192,0,0,1-1.6329-3.2061L9.8726,20H22.1274l3.4869,4.7939A2.0192,2.0192,0,0,1,23.9814,28Z"}),props.children);});var Chemistry20=/*#__PURE__*/React.forwardRef(function Chemistry20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.2314,23.6182,20,13.6748V4h2V2H10V4h2v9.6748L4.7686,23.6182A4.0183,4.0183,0,0,0,8.0186,30H23.9814a4.0183,4.0183,0,0,0,3.25-6.3818ZM14,14.3252V4h4V14.3252L20.6728,18H11.3272ZM23.9814,28H8.0186a2.0192,2.0192,0,0,1-1.6329-3.2061L9.8726,20H22.1274l3.4869,4.7939A2.0192,2.0192,0,0,1,23.9814,28Z"}),props.children);});var Chemistry16=/*#__PURE__*/React.forwardRef(function Chemistry16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.2314,23.6182,20,13.6748V4h2V2H10V4h2v9.6748L4.7686,23.6182A4.0183,4.0183,0,0,0,8.0186,30H23.9814a4.0183,4.0183,0,0,0,3.25-6.3818ZM14,14.3252V4h4V14.3252L20.6728,18H11.3272ZM23.9814,28H8.0186a2.0192,2.0192,0,0,1-1.6329-3.2061L9.8726,20H22.1274l3.4869,4.7939A2.0192,2.0192,0,0,1,23.9814,28Z"}),props.children);});var ChevronDown32=/*#__PURE__*/React.forwardRef(function ChevronDown32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,22 6,12 7.4,10.6 16,19.2 24.6,10.6 26,12"}),props.children);});var ChevronDown24=/*#__PURE__*/React.forwardRef(function ChevronDown24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,22 6,12 7.4,10.6 16,19.2 24.6,10.6 26,12"}),props.children);});var ChevronDown20=/*#__PURE__*/React.forwardRef(function ChevronDown20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,22 6,12 7.4,10.6 16,19.2 24.6,10.6 26,12"}),props.children);});var ChevronLeft32=/*#__PURE__*/React.forwardRef(function ChevronLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"10,16 20,6 21.4,7.4 12.8,16 21.4,24.6 20,26"}),props.children);});var ChevronLeft24=/*#__PURE__*/React.forwardRef(function ChevronLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"10,16 20,6 21.4,7.4 12.8,16 21.4,24.6 20,26"}),props.children);});var ChevronLeft20=/*#__PURE__*/React.forwardRef(function ChevronLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"10,16 20,6 21.4,7.4 12.8,16 21.4,24.6 20,26"}),props.children);});var ChevronMini32=/*#__PURE__*/React.forwardRef(function ChevronMini32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"31,19 31,31 19,31"}),props.children);});var ChevronMini24=/*#__PURE__*/React.forwardRef(function ChevronMini24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"31,19 31,31 19,31"}),props.children);});var ChevronMini20=/*#__PURE__*/React.forwardRef(function ChevronMini20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"31,19 31,31 19,31"}),props.children);});var ChevronRight32=/*#__PURE__*/React.forwardRef(function ChevronRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22,16 12,26 10.6,24.6 19.2,16 10.6,7.4 12,6"}),props.children);});var ChevronRight24=/*#__PURE__*/React.forwardRef(function ChevronRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22,16 12,26 10.6,24.6 19.2,16 10.6,7.4 12,6"}),props.children);});var ChevronRight20=/*#__PURE__*/React.forwardRef(function ChevronRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22,16 12,26 10.6,24.6 19.2,16 10.6,7.4 12,6"}),props.children);});var ChevronSortDown32=/*#__PURE__*/React.forwardRef(function ChevronSortDown32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,28 9,21 10.4,19.6 16,25.2 21.6,19.6 23,21"}),props.children);});var ChevronSortDown24=/*#__PURE__*/React.forwardRef(function ChevronSortDown24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,28 9,21 10.4,19.6 16,25.2 21.6,19.6 23,21"}),props.children);});var ChevronSortDown20=/*#__PURE__*/React.forwardRef(function ChevronSortDown20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,28 9,21 10.4,19.6 16,25.2 21.6,19.6 23,21"}),props.children);});var ChevronSortUp32=/*#__PURE__*/React.forwardRef(function ChevronSortUp32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,4 23,11 21.6,12.4 16,6.8 10.4,12.4 9,11"}),props.children);});var ChevronSortUp24=/*#__PURE__*/React.forwardRef(function ChevronSortUp24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,4 23,11 21.6,12.4 16,6.8 10.4,12.4 9,11"}),props.children);});var ChevronSortUp20=/*#__PURE__*/React.forwardRef(function ChevronSortUp20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,4 23,11 21.6,12.4 16,6.8 10.4,12.4 9,11"}),props.children);});var ChevronSort32=/*#__PURE__*/React.forwardRef(function ChevronSort32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16 28 9 21 10.41 19.59 16 25.17 21.59 19.59 23 21 16 28"}),React.createElement("polygon",{points:"16 4 23 11 21.59 12.41 16 6.83 10.41 12.41 9 11 16 4"}),props.children);});var ChevronSort24=/*#__PURE__*/React.forwardRef(function ChevronSort24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16 28 9 21 10.41 19.59 16 25.17 21.59 19.59 23 21 16 28"}),React.createElement("polygon",{points:"16 4 23 11 21.59 12.41 16 6.83 10.41 12.41 9 11 16 4"}),props.children);});var ChevronSort20=/*#__PURE__*/React.forwardRef(function ChevronSort20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16 28 9 21 10.41 19.59 16 25.17 21.59 19.59 23 21 16 28"}),React.createElement("polygon",{points:"16 4 23 11 21.59 12.41 16 6.83 10.41 12.41 9 11 16 4"}),props.children);});var ChevronUp32=/*#__PURE__*/React.forwardRef(function ChevronUp32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,10 26,20 24.6,21.4 16,12.8 7.4,21.4 6,20"}),props.children);});var ChevronUp24=/*#__PURE__*/React.forwardRef(function ChevronUp24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,10 26,20 24.6,21.4 16,12.8 7.4,21.4 6,20"}),props.children);});var ChevronUp20=/*#__PURE__*/React.forwardRef(function ChevronUp20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,10 26,20 24.6,21.4 16,12.8 7.4,21.4 6,20"}),props.children);});var Chip32=/*#__PURE__*/React.forwardRef(function Chip32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11,11V21H21V11Zm8,8H13V13h6Z"}),React.createElement("path",{d:"M30,13V11H26V8a2,2,0,0,0-2-2H21V2H19V6H13V2H11V6H8A2,2,0,0,0,6,8v3H2v2H6v6H2v2H6v3a2,2,0,0,0,2,2h3v4h2V26h6v4h2V26h3a2,2,0,0,0,2-2V21h4V19H26V13ZM24,24H8V8H24Z"}),props.children);});var Chip24=/*#__PURE__*/React.forwardRef(function Chip24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11,11V21H21V11Zm8,8H13V13h6Z"}),React.createElement("path",{d:"M30,13V11H26V8a2,2,0,0,0-2-2H21V2H19V6H13V2H11V6H8A2,2,0,0,0,6,8v3H2v2H6v6H2v2H6v3a2,2,0,0,0,2,2h3v4h2V26h6v4h2V26h3a2,2,0,0,0,2-2V21h4V19H26V13ZM24,24H8V8H24Z"}),props.children);});var Chip20=/*#__PURE__*/React.forwardRef(function Chip20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11,11V21H21V11Zm8,8H13V13h6Z"}),React.createElement("path",{d:"M30,13V11H26V8a2,2,0,0,0-2-2H21V2H19V6H13V2H11V6H8A2,2,0,0,0,6,8v3H2v2H6v6H2v2H6v3a2,2,0,0,0,2,2h3v4h2V26h6v4h2V26h3a2,2,0,0,0,2-2V21h4V19H26V13ZM24,24H8V8H24Z"}),props.children);});var Chip16=/*#__PURE__*/React.forwardRef(function Chip16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11,11V21H21V11Zm8,8H13V13h6Z"}),React.createElement("path",{d:"M30,13V11H26V8a2,2,0,0,0-2-2H21V2H19V6H13V2H11V6H8A2,2,0,0,0,6,8v3H2v2H6v6H2v2H6v3a2,2,0,0,0,2,2h3v4h2V26h6v4h2V26h3a2,2,0,0,0,2-2V21h4V19H26V13ZM24,24H8V8H24Z"}),props.children);});var Choices32=/*#__PURE__*/React.forwardRef(function Choices32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"21 4 21 6 24.586 6 16 14.586 7.414 6 11 6 11 4 4 4 4 11 6 11 6 7.414 15 16.414 15 28 17 28 17 16.414 26 7.414 26 11 28 11 28 4 21 4"}),props.children);});var Choices24=/*#__PURE__*/React.forwardRef(function Choices24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"21 4 21 6 24.586 6 16 14.586 7.414 6 11 6 11 4 4 4 4 11 6 11 6 7.414 15 16.414 15 28 17 28 17 16.414 26 7.414 26 11 28 11 28 4 21 4"}),props.children);});var Choices20=/*#__PURE__*/React.forwardRef(function Choices20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"21 4 21 6 24.586 6 16 14.586 7.414 6 11 6 11 4 4 4 4 11 6 11 6 7.414 15 16.414 15 28 17 28 17 16.414 26 7.414 26 11 28 11 28 4 21 4"}),props.children);});var Choices16=/*#__PURE__*/React.forwardRef(function Choices16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"21 4 21 6 24.586 6 16 14.586 7.414 6 11 6 11 4 4 4 4 11 6 11 6 7.414 15 16.414 15 28 17 28 17 16.414 26 7.414 26 11 28 11 28 4 21 4"}),props.children);});var CircleFilled32=/*#__PURE__*/React.forwardRef(function CircleFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"16",r:"10"}),React.createElement("path",{d:"M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"}),props.children);});var CircleFilled24=/*#__PURE__*/React.forwardRef(function CircleFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"16",r:"10"}),React.createElement("path",{d:"M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"}),props.children);});var CircleFilled20=/*#__PURE__*/React.forwardRef(function CircleFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"16",r:"10"}),React.createElement("path",{d:"M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"}),props.children);});var CircleFilled16=/*#__PURE__*/React.forwardRef(function CircleFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"16",r:"10"}),React.createElement("path",{d:"M16,30A14,14,0,1,1,30,16,14.0158,14.0158,0,0,1,16,30ZM16,4A12,12,0,1,0,28,16,12.0137,12.0137,0,0,0,16,4Z"}),props.children);});var CircleDash32=/*#__PURE__*/React.forwardRef(function CircleDash32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.7,4.7a14.7,14.7,0,0,0-3,3.1L6.3,9A13.26,13.26,0,0,1,8.9,6.3Z"}),React.createElement("path",{d:"M4.6,12.3l-1.9-.6A12.51,12.51,0,0,0,2,16H4A11.48,11.48,0,0,1,4.6,12.3Z"}),React.createElement("path",{d:"M2.7,20.4a14.4,14.4,0,0,0,2,3.9l1.6-1.2a12.89,12.89,0,0,1-1.7-3.3Z"}),React.createElement("path",{d:"M7.8,27.3a14.4,14.4,0,0,0,3.9,2l.6-1.9A12.89,12.89,0,0,1,9,25.7Z"}),React.createElement("path",{d:"M11.7,2.7l.6,1.9A11.48,11.48,0,0,1,16,4V2A12.51,12.51,0,0,0,11.7,2.7Z"}),React.createElement("path",{d:"M24.2,27.3a15.18,15.18,0,0,0,3.1-3.1L25.7,23A11.53,11.53,0,0,1,23,25.7Z"}),React.createElement("path",{d:"M27.4,19.7l1.9.6A15.47,15.47,0,0,0,30,16H28A11.48,11.48,0,0,1,27.4,19.7Z"}),React.createElement("path",{d:"M29.2,11.6a14.4,14.4,0,0,0-2-3.9L25.6,8.9a12.89,12.89,0,0,1,1.7,3.3Z"}),React.createElement("path",{d:"M24.1,4.6a14.4,14.4,0,0,0-3.9-2l-.6,1.9a12.89,12.89,0,0,1,3.3,1.7Z"}),React.createElement("path",{d:"M20.3,29.3l-.6-1.9A11.48,11.48,0,0,1,16,28v2A21.42,21.42,0,0,0,20.3,29.3Z"}),props.children);});var CircleDash24=/*#__PURE__*/React.forwardRef(function CircleDash24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.7,4.7a14.7,14.7,0,0,0-3,3.1L6.3,9A13.26,13.26,0,0,1,8.9,6.3Z"}),React.createElement("path",{d:"M4.6,12.3l-1.9-.6A12.51,12.51,0,0,0,2,16H4A11.48,11.48,0,0,1,4.6,12.3Z"}),React.createElement("path",{d:"M2.7,20.4a14.4,14.4,0,0,0,2,3.9l1.6-1.2a12.89,12.89,0,0,1-1.7-3.3Z"}),React.createElement("path",{d:"M7.8,27.3a14.4,14.4,0,0,0,3.9,2l.6-1.9A12.89,12.89,0,0,1,9,25.7Z"}),React.createElement("path",{d:"M11.7,2.7l.6,1.9A11.48,11.48,0,0,1,16,4V2A12.51,12.51,0,0,0,11.7,2.7Z"}),React.createElement("path",{d:"M24.2,27.3a15.18,15.18,0,0,0,3.1-3.1L25.7,23A11.53,11.53,0,0,1,23,25.7Z"}),React.createElement("path",{d:"M27.4,19.7l1.9.6A15.47,15.47,0,0,0,30,16H28A11.48,11.48,0,0,1,27.4,19.7Z"}),React.createElement("path",{d:"M29.2,11.6a14.4,14.4,0,0,0-2-3.9L25.6,8.9a12.89,12.89,0,0,1,1.7,3.3Z"}),React.createElement("path",{d:"M24.1,4.6a14.4,14.4,0,0,0-3.9-2l-.6,1.9a12.89,12.89,0,0,1,3.3,1.7Z"}),React.createElement("path",{d:"M20.3,29.3l-.6-1.9A11.48,11.48,0,0,1,16,28v2A21.42,21.42,0,0,0,20.3,29.3Z"}),props.children);});var CircleDash20=/*#__PURE__*/React.forwardRef(function CircleDash20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.7,4.7a14.7,14.7,0,0,0-3,3.1L6.3,9A13.26,13.26,0,0,1,8.9,6.3Z"}),React.createElement("path",{d:"M4.6,12.3l-1.9-.6A12.51,12.51,0,0,0,2,16H4A11.48,11.48,0,0,1,4.6,12.3Z"}),React.createElement("path",{d:"M2.7,20.4a14.4,14.4,0,0,0,2,3.9l1.6-1.2a12.89,12.89,0,0,1-1.7-3.3Z"}),React.createElement("path",{d:"M7.8,27.3a14.4,14.4,0,0,0,3.9,2l.6-1.9A12.89,12.89,0,0,1,9,25.7Z"}),React.createElement("path",{d:"M11.7,2.7l.6,1.9A11.48,11.48,0,0,1,16,4V2A12.51,12.51,0,0,0,11.7,2.7Z"}),React.createElement("path",{d:"M24.2,27.3a15.18,15.18,0,0,0,3.1-3.1L25.7,23A11.53,11.53,0,0,1,23,25.7Z"}),React.createElement("path",{d:"M27.4,19.7l1.9.6A15.47,15.47,0,0,0,30,16H28A11.48,11.48,0,0,1,27.4,19.7Z"}),React.createElement("path",{d:"M29.2,11.6a14.4,14.4,0,0,0-2-3.9L25.6,8.9a12.89,12.89,0,0,1,1.7,3.3Z"}),React.createElement("path",{d:"M24.1,4.6a14.4,14.4,0,0,0-3.9-2l-.6,1.9a12.89,12.89,0,0,1,3.3,1.7Z"}),React.createElement("path",{d:"M20.3,29.3l-.6-1.9A11.48,11.48,0,0,1,16,28v2A21.42,21.42,0,0,0,20.3,29.3Z"}),props.children);});var CircleDash16=/*#__PURE__*/React.forwardRef(function CircleDash16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.7,4.7a14.7,14.7,0,0,0-3,3.1L6.3,9A13.26,13.26,0,0,1,8.9,6.3Z"}),React.createElement("path",{d:"M4.6,12.3l-1.9-.6A12.51,12.51,0,0,0,2,16H4A11.48,11.48,0,0,1,4.6,12.3Z"}),React.createElement("path",{d:"M2.7,20.4a14.4,14.4,0,0,0,2,3.9l1.6-1.2a12.89,12.89,0,0,1-1.7-3.3Z"}),React.createElement("path",{d:"M7.8,27.3a14.4,14.4,0,0,0,3.9,2l.6-1.9A12.89,12.89,0,0,1,9,25.7Z"}),React.createElement("path",{d:"M11.7,2.7l.6,1.9A11.48,11.48,0,0,1,16,4V2A12.51,12.51,0,0,0,11.7,2.7Z"}),React.createElement("path",{d:"M24.2,27.3a15.18,15.18,0,0,0,3.1-3.1L25.7,23A11.53,11.53,0,0,1,23,25.7Z"}),React.createElement("path",{d:"M27.4,19.7l1.9.6A15.47,15.47,0,0,0,30,16H28A11.48,11.48,0,0,1,27.4,19.7Z"}),React.createElement("path",{d:"M29.2,11.6a14.4,14.4,0,0,0-2-3.9L25.6,8.9a12.89,12.89,0,0,1,1.7,3.3Z"}),React.createElement("path",{d:"M24.1,4.6a14.4,14.4,0,0,0-3.9-2l-.6,1.9a12.89,12.89,0,0,1,3.3,1.7Z"}),React.createElement("path",{d:"M20.3,29.3l-.6-1.9A11.48,11.48,0,0,1,16,28v2A21.42,21.42,0,0,0,20.3,29.3Z"}),props.children);});var Classification32=/*#__PURE__*/React.forwardRef(function Classification32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"15",cy:"19",r:"1"}),React.createElement("path",{d:"M27.7,9.3l-7-7A.9087.9087,0,0,0,20,2H10A2.0058,2.0058,0,0,0,8,4V14H6a2.0023,2.0023,0,0,0-2,2v6a2.0023,2.0023,0,0,0,2,2H8v4a2.0058,2.0058,0,0,0,2,2H26a2.0058,2.0058,0,0,0,2-2V10A.9092.9092,0,0,0,27.7,9.3ZM20,4.4,25.6,10H20ZM6,16h9.5972L19,19l-3.3926,3H6ZM26,28H10V24h5.6089a2.0076,2.0076,0,0,0,1.3135-.4927l3.3833-2.9917a2.0015,2.0015,0,0,0,.01-3.0229l-3.4033-3.0083A1.9961,1.9961,0,0,0,15.6089,14H10V4h8v6a2.0058,2.0058,0,0,0,2,2h6Z"}),props.children);});var Classification24=/*#__PURE__*/React.forwardRef(function Classification24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"15",cy:"19",r:"1"}),React.createElement("path",{d:"M27.7,9.3l-7-7A.9087.9087,0,0,0,20,2H10A2.0058,2.0058,0,0,0,8,4V14H6a2.0023,2.0023,0,0,0-2,2v6a2.0023,2.0023,0,0,0,2,2H8v4a2.0058,2.0058,0,0,0,2,2H26a2.0058,2.0058,0,0,0,2-2V10A.9092.9092,0,0,0,27.7,9.3ZM20,4.4,25.6,10H20ZM6,16h9.5972L19,19l-3.3926,3H6ZM26,28H10V24h5.6089a2.0076,2.0076,0,0,0,1.3135-.4927l3.3833-2.9917a2.0015,2.0015,0,0,0,.01-3.0229l-3.4033-3.0083A1.9961,1.9961,0,0,0,15.6089,14H10V4h8v6a2.0058,2.0058,0,0,0,2,2h6Z"}),props.children);});var Classification20=/*#__PURE__*/React.forwardRef(function Classification20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"15",cy:"19",r:"1"}),React.createElement("path",{d:"M27.7,9.3l-7-7A.9087.9087,0,0,0,20,2H10A2.0058,2.0058,0,0,0,8,4V14H6a2.0023,2.0023,0,0,0-2,2v6a2.0023,2.0023,0,0,0,2,2H8v4a2.0058,2.0058,0,0,0,2,2H26a2.0058,2.0058,0,0,0,2-2V10A.9092.9092,0,0,0,27.7,9.3ZM20,4.4,25.6,10H20ZM6,16h9.5972L19,19l-3.3926,3H6ZM26,28H10V24h5.6089a2.0076,2.0076,0,0,0,1.3135-.4927l3.3833-2.9917a2.0015,2.0015,0,0,0,.01-3.0229l-3.4033-3.0083A1.9961,1.9961,0,0,0,15.6089,14H10V4h8v6a2.0058,2.0058,0,0,0,2,2h6Z"}),props.children);});var Classification16=/*#__PURE__*/React.forwardRef(function Classification16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"15",cy:"19",r:"1"}),React.createElement("path",{d:"M27.7,9.3l-7-7A.9087.9087,0,0,0,20,2H10A2.0058,2.0058,0,0,0,8,4V14H6a2.0023,2.0023,0,0,0-2,2v6a2.0023,2.0023,0,0,0,2,2H8v4a2.0058,2.0058,0,0,0,2,2H26a2.0058,2.0058,0,0,0,2-2V10A.9092.9092,0,0,0,27.7,9.3ZM20,4.4,25.6,10H20ZM6,16h9.5972L19,19l-3.3926,3H6ZM26,28H10V24h5.6089a2.0076,2.0076,0,0,0,1.3135-.4927l3.3833-2.9917a2.0015,2.0015,0,0,0,.01-3.0229l-3.4033-3.0083A1.9961,1.9961,0,0,0,15.6089,14H10V4h8v6a2.0058,2.0058,0,0,0,2,2h6Z"}),props.children);});var ClassifierLanguage32=/*#__PURE__*/React.forwardRef(function ClassifierLanguage32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,10V2H22v8h3v4H23v2h7V14H27V10ZM24,4h4V8H24Z"}),React.createElement("polygon",{points:"20 23.41 18.59 22 16 24.59 13.41 22 12 23.41 14.59 26 12 28.59 13.41 30 16 27.41 18.59 30 20 28.59 17.41 26 20 23.41"}),React.createElement("polygon",{points:"20 14 12 14 12 16 15 16 15 21 17 21 17 16 20 16 20 14"}),React.createElement("path",{d:"M7,9.86a4,4,0,1,0-2,0V14H2v2H9V14H7ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6Z"}),props.children);});var ClassifierLanguage24=/*#__PURE__*/React.forwardRef(function ClassifierLanguage24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,10V2H22v8h3v4H23v2h7V14H27V10ZM24,4h4V8H24Z"}),React.createElement("polygon",{points:"20 23.41 18.59 22 16 24.59 13.41 22 12 23.41 14.59 26 12 28.59 13.41 30 16 27.41 18.59 30 20 28.59 17.41 26 20 23.41"}),React.createElement("polygon",{points:"20 14 12 14 12 16 15 16 15 21 17 21 17 16 20 16 20 14"}),React.createElement("path",{d:"M7,9.86a4,4,0,1,0-2,0V14H2v2H9V14H7ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6Z"}),props.children);});var ClassifierLanguage20=/*#__PURE__*/React.forwardRef(function ClassifierLanguage20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,10V2H22v8h3v4H23v2h7V14H27V10ZM24,4h4V8H24Z"}),React.createElement("polygon",{points:"20 23.41 18.59 22 16 24.59 13.41 22 12 23.41 14.59 26 12 28.59 13.41 30 16 27.41 18.59 30 20 28.59 17.41 26 20 23.41"}),React.createElement("polygon",{points:"20 14 12 14 12 16 15 16 15 21 17 21 17 16 20 16 20 14"}),React.createElement("path",{d:"M7,9.86a4,4,0,1,0-2,0V14H2v2H9V14H7ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6Z"}),props.children);});var ClassifierLanguage16=/*#__PURE__*/React.forwardRef(function ClassifierLanguage16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,10V2H22v8h3v4H23v2h7V14H27V10ZM24,4h4V8H24Z"}),React.createElement("polygon",{points:"20 23.41 18.59 22 16 24.59 13.41 22 12 23.41 14.59 26 12 28.59 13.41 30 16 27.41 18.59 30 20 28.59 17.41 26 20 23.41"}),React.createElement("polygon",{points:"20 14 12 14 12 16 15 16 15 21 17 21 17 16 20 16 20 14"}),React.createElement("path",{d:"M7,9.86a4,4,0,1,0-2,0V14H2v2H9V14H7ZM4,6A2,2,0,1,1,6,8,2,2,0,0,1,4,6Z"}),props.children);});var CloseFilled32=/*#__PURE__*/React.forwardRef(function CloseFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.2,2,2,8.2,2,16s6.2,14,14,14s14-6.2,14-14S23.8,2,16,2z M21.4,23L16,17.6L10.6,23L9,21.4l5.4-5.4L9,10.6L10.6,9\tl5.4,5.4L21.4,9l1.6,1.6L17.6,16l5.4,5.4L21.4,23z"}),React.createElement("polyline",{points:"14.4,16 9,10.6 10.6,9 16,14.4 21.4,9 23,10.6 17.6,16 23,21.4 21.4,23 16,17.6 10.6,23 9,21.4 14.4,16","data-icon-path":"inner-path",opacity:"0"}),props.children);});var CloseFilled24=/*#__PURE__*/React.forwardRef(function CloseFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.2,2,2,8.2,2,16s6.2,14,14,14s14-6.2,14-14S23.8,2,16,2z M21.4,23L16,17.6L10.6,23L9,21.4l5.4-5.4L9,10.6L10.6,9\tl5.4,5.4L21.4,9l1.6,1.6L17.6,16l5.4,5.4L21.4,23z"}),React.createElement("polyline",{points:"14.4,16 9,10.6 10.6,9 16,14.4 21.4,9 23,10.6 17.6,16 23,21.4 21.4,23 16,17.6 10.6,23 9,21.4 14.4,16","data-icon-path":"inner-path",opacity:"0"}),props.children);});var CloseFilled20=/*#__PURE__*/React.forwardRef(function CloseFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.2,2,2,8.2,2,16s6.2,14,14,14s14-6.2,14-14S23.8,2,16,2z M21.4,23L16,17.6L10.6,23L9,21.4l5.4-5.4L9,10.6L10.6,9\tl5.4,5.4L21.4,9l1.6,1.6L17.6,16l5.4,5.4L21.4,23z"}),React.createElement("polyline",{points:"14.4,16 9,10.6 10.6,9 16,14.4 21.4,9 23,10.6 17.6,16 23,21.4 21.4,23 16,17.6 10.6,23 9,21.4 14.4,16","data-icon-path":"inner-path",opacity:"0"}),props.children);});var CloseOutline32=/*#__PURE__*/React.forwardRef(function CloseOutline32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.2,2,2,8.2,2,16s6.2,14,14,14s14-6.2,14-14S23.8,2,16,2z M16,28C9.4,28,4,22.6,4,16S9.4,4,16,4s12,5.4,12,12\tS22.6,28,16,28z"}),React.createElement("polygon",{points:"21.4,23 16,17.6 10.6,23 9,21.4 14.4,16 9,10.6 10.6,9 16,14.4 21.4,9 23,10.6 17.6,16 23,21.4"}),props.children);});var CloseOutline24=/*#__PURE__*/React.forwardRef(function CloseOutline24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.2,2,2,8.2,2,16s6.2,14,14,14s14-6.2,14-14S23.8,2,16,2z M16,28C9.4,28,4,22.6,4,16S9.4,4,16,4s12,5.4,12,12\tS22.6,28,16,28z"}),React.createElement("polygon",{points:"21.4,23 16,17.6 10.6,23 9,21.4 14.4,16 9,10.6 10.6,9 16,14.4 21.4,9 23,10.6 17.6,16 23,21.4"}),props.children);});var CloseOutline20=/*#__PURE__*/React.forwardRef(function CloseOutline20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.2,2,2,8.2,2,16s6.2,14,14,14s14-6.2,14-14S23.8,2,16,2z M16,28C9.4,28,4,22.6,4,16S9.4,4,16,4s12,5.4,12,12\tS22.6,28,16,28z"}),React.createElement("polygon",{points:"21.4,23 16,17.6 10.6,23 9,21.4 14.4,16 9,10.6 10.6,9 16,14.4 21.4,9 23,10.6 17.6,16 23,21.4"}),props.children);});var CloseOutline16=/*#__PURE__*/React.forwardRef(function CloseOutline16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.2,2,2,8.2,2,16s6.2,14,14,14s14-6.2,14-14S23.8,2,16,2z M16,28C9.4,28,4,22.6,4,16S9.4,4,16,4s12,5.4,12,12\tS22.6,28,16,28z"}),React.createElement("polygon",{points:"21.4,23 16,17.6 10.6,23 9,21.4 14.4,16 9,10.6 10.6,9 16,14.4 21.4,9 23,10.6 17.6,16 23,21.4"}),props.children);});var Close32=/*#__PURE__*/React.forwardRef(function Close32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 9.4 22.6 8 16 14.6 9.4 8 8 9.4 14.6 16 8 22.6 9.4 24 16 17.4 22.6 24 24 22.6 17.4 16 24 9.4"}),props.children);});var Close24=/*#__PURE__*/React.forwardRef(function Close24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 9.4 22.6 8 16 14.6 9.4 8 8 9.4 14.6 16 8 22.6 9.4 24 16 17.4 22.6 24 24 22.6 17.4 16 24 9.4"}),props.children);});var Close20=/*#__PURE__*/React.forwardRef(function Close20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 9.4 22.6 8 16 14.6 9.4 8 8 9.4 14.6 16 8 22.6 9.4 24 16 17.4 22.6 24 24 22.6 17.4 16 24 9.4"}),props.children);});var Close16=/*#__PURE__*/React.forwardRef(function Close16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"24 9.4 22.6 8 16 14.6 9.4 8 8 9.4 14.6 16 8 22.6 9.4 24 16 17.4 22.6 24 24 22.6 17.4 16 24 9.4"}),props.children);});var ClosedCaptionAlt32=/*#__PURE__*/React.forwardRef(function ClosedCaptionAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"19",y:"17"}),React.createElement("rect",{width:"6",height:"2",x:"11",y:"17"}),React.createElement("rect",{width:"3",height:"2",x:"6",y:"17"}),React.createElement("rect",{width:"4",height:"2",x:"22",y:"13"}),React.createElement("rect",{width:"7",height:"2",x:"13",y:"13"}),React.createElement("rect",{width:"5",height:"2",x:"6",y:"13"}),React.createElement("path",{d:"M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V8a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,8V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V8A3.9988,3.9988,0,0,1,6,4H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"}),props.children);});var ClosedCaptionAlt24=/*#__PURE__*/React.forwardRef(function ClosedCaptionAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"19",y:"17"}),React.createElement("rect",{width:"6",height:"2",x:"11",y:"17"}),React.createElement("rect",{width:"3",height:"2",x:"6",y:"17"}),React.createElement("rect",{width:"4",height:"2",x:"22",y:"13"}),React.createElement("rect",{width:"7",height:"2",x:"13",y:"13"}),React.createElement("rect",{width:"5",height:"2",x:"6",y:"13"}),React.createElement("path",{d:"M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V8a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,8V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V8A3.9988,3.9988,0,0,1,6,4H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"}),props.children);});var ClosedCaptionAlt20=/*#__PURE__*/React.forwardRef(function ClosedCaptionAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"19",y:"17"}),React.createElement("rect",{width:"6",height:"2",x:"11",y:"17"}),React.createElement("rect",{width:"3",height:"2",x:"6",y:"17"}),React.createElement("rect",{width:"4",height:"2",x:"22",y:"13"}),React.createElement("rect",{width:"7",height:"2",x:"13",y:"13"}),React.createElement("rect",{width:"5",height:"2",x:"6",y:"13"}),React.createElement("path",{d:"M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V8a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,8V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V8A3.9988,3.9988,0,0,1,6,4H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"}),props.children);});var ClosedCaptionAlt16=/*#__PURE__*/React.forwardRef(function ClosedCaptionAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"19",y:"17"}),React.createElement("rect",{width:"6",height:"2",x:"11",y:"17"}),React.createElement("rect",{width:"3",height:"2",x:"6",y:"17"}),React.createElement("rect",{width:"4",height:"2",x:"22",y:"13"}),React.createElement("rect",{width:"7",height:"2",x:"13",y:"13"}),React.createElement("rect",{width:"5",height:"2",x:"6",y:"13"}),React.createElement("path",{d:"M17.7358,30,16,29l4-7h6a1.9966,1.9966,0,0,0,2-2V8a1.9966,1.9966,0,0,0-2-2H6A1.9966,1.9966,0,0,0,4,8V20a1.9966,1.9966,0,0,0,2,2h9v2H6a3.9993,3.9993,0,0,1-4-4V8A3.9988,3.9988,0,0,1,6,4H26a3.9988,3.9988,0,0,1,4,4V20a3.9993,3.9993,0,0,1-4,4H21.1646Z"}),props.children);});var ClosedCaptionFilled32=/*#__PURE__*/React.forwardRef(function ClosedCaptionFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM15,13H10v6h5v2H10a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5Zm10,0H20v6h5v2H20a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5Z"}),props.children);});var ClosedCaptionFilled24=/*#__PURE__*/React.forwardRef(function ClosedCaptionFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM15,13H10v6h5v2H10a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5Zm10,0H20v6h5v2H20a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5Z"}),props.children);});var ClosedCaptionFilled20=/*#__PURE__*/React.forwardRef(function ClosedCaptionFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM15,13H10v6h5v2H10a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5Zm10,0H20v6h5v2H20a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5Z"}),props.children);});var ClosedCaptionFilled16=/*#__PURE__*/React.forwardRef(function ClosedCaptionFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM15,13H10v6h5v2H10a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5Zm10,0H20v6h5v2H20a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5Z"}),props.children);});var ClosedCaption32=/*#__PURE__*/React.forwardRef(function ClosedCaption32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15,21H10a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5v2H10v6h5Z"}),React.createElement("path",{d:"M25,21H20a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5v2H20v6h5Z"}),React.createElement("path",{d:"M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"}),props.children);});var ClosedCaption24=/*#__PURE__*/React.forwardRef(function ClosedCaption24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15,21H10a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5v2H10v6h5Z"}),React.createElement("path",{d:"M25,21H20a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5v2H20v6h5Z"}),React.createElement("path",{d:"M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"}),props.children);});var ClosedCaption20=/*#__PURE__*/React.forwardRef(function ClosedCaption20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15,21H10a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5v2H10v6h5Z"}),React.createElement("path",{d:"M25,21H20a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5v2H20v6h5Z"}),React.createElement("path",{d:"M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"}),props.children);});var ClosedCaption16=/*#__PURE__*/React.forwardRef(function ClosedCaption16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M15,21H10a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5v2H10v6h5Z"}),React.createElement("path",{d:"M25,21H20a2,2,0,0,1-2-2V13a2,2,0,0,1,2-2h5v2H20v6h5Z"}),React.createElement("path",{d:"M28,26H4a2,2,0,0,1-2-2V8A2,2,0,0,1,4,6H28a2,2,0,0,1,2,2V24A2,2,0,0,1,28,26ZM4,8V24H28V8Z"}),props.children);});var CloudDownload32=/*#__PURE__*/React.forwardRef(function CloudDownload32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5,22H23V20h.5a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82a7,7,0,0,0-13.88,0L9,11,8.14,11a4.5,4.5,0,0,0,.36,9H9v2H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22Z"}),React.createElement("polygon",{points:"17 26.17 17 14 15 14 15 26.17 12.41 23.59 11 25 16 30 21 25 19.59 23.59 17 26.17"}),props.children);});var CloudDownload24=/*#__PURE__*/React.forwardRef(function CloudDownload24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5,22H23V20h.5a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82a7,7,0,0,0-13.88,0L9,11,8.14,11a4.5,4.5,0,0,0,.36,9H9v2H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22Z"}),React.createElement("polygon",{points:"17 26.17 17 14 15 14 15 26.17 12.41 23.59 11 25 16 30 21 25 19.59 23.59 17 26.17"}),props.children);});var CloudDownload20=/*#__PURE__*/React.forwardRef(function CloudDownload20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5,22H23V20h.5a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82a7,7,0,0,0-13.88,0L9,11,8.14,11a4.5,4.5,0,0,0,.36,9H9v2H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22Z"}),React.createElement("polygon",{points:"17 26.17 17 14 15 14 15 26.17 12.41 23.59 11 25 16 30 21 25 19.59 23.59 17 26.17"}),props.children);});var CloudDownload16=/*#__PURE__*/React.forwardRef(function CloudDownload16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5,22H23V20h.5a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82a7,7,0,0,0-13.88,0L9,11,8.14,11a4.5,4.5,0,0,0,.36,9H9v2H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22Z"}),React.createElement("polygon",{points:"17 26.17 17 14 15 14 15 26.17 12.41 23.59 11 25 16 30 21 25 19.59 23.59 17 26.17"}),props.children);});var CloudLightning32=/*#__PURE__*/React.forwardRef(function CloudLightning32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61,29.92a1,1,0,0,1-.6-1.07L12.83,17H8a1,1,0,0,1-1-1.23l3-13A1,1,0,0,1,11,2H21a1,1,0,0,1,.78.37,1,1,0,0,1,.2.85L20.25,11H25a1,1,0,0,1,.9.56,1,1,0,0,1-.11,1l-13,17A1,1,0,0,1,12,30,1.09,1.09,0,0,1,11.61,29.92ZM17.75,13l2-9H11.8L9.26,15h5.91L13.58,25.28,23,13Z"}),props.children);});var CloudLightning24=/*#__PURE__*/React.forwardRef(function CloudLightning24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61,29.92a1,1,0,0,1-.6-1.07L12.83,17H8a1,1,0,0,1-1-1.23l3-13A1,1,0,0,1,11,2H21a1,1,0,0,1,.78.37,1,1,0,0,1,.2.85L20.25,11H25a1,1,0,0,1,.9.56,1,1,0,0,1-.11,1l-13,17A1,1,0,0,1,12,30,1.09,1.09,0,0,1,11.61,29.92ZM17.75,13l2-9H11.8L9.26,15h5.91L13.58,25.28,23,13Z"}),props.children);});var CloudLightning20=/*#__PURE__*/React.forwardRef(function CloudLightning20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61,29.92a1,1,0,0,1-.6-1.07L12.83,17H8a1,1,0,0,1-1-1.23l3-13A1,1,0,0,1,11,2H21a1,1,0,0,1,.78.37,1,1,0,0,1,.2.85L20.25,11H25a1,1,0,0,1,.9.56,1,1,0,0,1-.11,1l-13,17A1,1,0,0,1,12,30,1.09,1.09,0,0,1,11.61,29.92ZM17.75,13l2-9H11.8L9.26,15h5.91L13.58,25.28,23,13Z"}),props.children);});var CloudLightning16=/*#__PURE__*/React.forwardRef(function CloudLightning16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61,29.92a1,1,0,0,1-.6-1.07L12.83,17H8a1,1,0,0,1-1-1.23l3-13A1,1,0,0,1,11,2H21a1,1,0,0,1,.78.37,1,1,0,0,1,.2.85L20.25,11H25a1,1,0,0,1,.9.56,1,1,0,0,1-.11,1l-13,17A1,1,0,0,1,12,30,1.09,1.09,0,0,1,11.61,29.92ZM17.75,13l2-9H11.8L9.26,15h5.91L13.58,25.28,23,13Z"}),props.children);});var CloudRain32=/*#__PURE__*/React.forwardRef(function CloudRain32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5,22H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22ZM16,4a7,7,0,0,0-6.94,6.14L9,11,8.14,11a4.5,4.5,0,0,0,.36,9h15a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82A7,7,0,0,0,16,4Z"}),React.createElement("path",{d:"M14,30a.93.93,0,0,1-.45-.11,1,1,0,0,1-.44-1.34l2-4a1,1,0,1,1,1.78.9l-2,4A1,1,0,0,1,14,30Z"}),React.createElement("path",{d:"M20,30a.93.93,0,0,1-.45-.11,1,1,0,0,1-.44-1.34l2-4a1,1,0,1,1,1.78.9l-2,4A1,1,0,0,1,20,30Z"}),React.createElement("path",{d:"M8,30a.93.93,0,0,1-.45-.11,1,1,0,0,1-.44-1.34l2-4a1,1,0,1,1,1.78.9l-2,4A1,1,0,0,1,8,30Z"}),props.children);});var CloudRain24=/*#__PURE__*/React.forwardRef(function CloudRain24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5,22H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22ZM16,4a7,7,0,0,0-6.94,6.14L9,11,8.14,11a4.5,4.5,0,0,0,.36,9h15a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82A7,7,0,0,0,16,4Z"}),React.createElement("path",{d:"M14,30a.93.93,0,0,1-.45-.11,1,1,0,0,1-.44-1.34l2-4a1,1,0,1,1,1.78.9l-2,4A1,1,0,0,1,14,30Z"}),React.createElement("path",{d:"M20,30a.93.93,0,0,1-.45-.11,1,1,0,0,1-.44-1.34l2-4a1,1,0,1,1,1.78.9l-2,4A1,1,0,0,1,20,30Z"}),React.createElement("path",{d:"M8,30a.93.93,0,0,1-.45-.11,1,1,0,0,1-.44-1.34l2-4a1,1,0,1,1,1.78.9l-2,4A1,1,0,0,1,8,30Z"}),props.children);});var CloudRain20=/*#__PURE__*/React.forwardRef(function CloudRain20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5,22H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22ZM16,4a7,7,0,0,0-6.94,6.14L9,11,8.14,11a4.5,4.5,0,0,0,.36,9h15a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82A7,7,0,0,0,16,4Z"}),React.createElement("path",{d:"M14,30a.93.93,0,0,1-.45-.11,1,1,0,0,1-.44-1.34l2-4a1,1,0,1,1,1.78.9l-2,4A1,1,0,0,1,14,30Z"}),React.createElement("path",{d:"M20,30a.93.93,0,0,1-.45-.11,1,1,0,0,1-.44-1.34l2-4a1,1,0,1,1,1.78.9l-2,4A1,1,0,0,1,20,30Z"}),React.createElement("path",{d:"M8,30a.93.93,0,0,1-.45-.11,1,1,0,0,1-.44-1.34l2-4a1,1,0,1,1,1.78.9l-2,4A1,1,0,0,1,8,30Z"}),props.children);});var CloudRain16=/*#__PURE__*/React.forwardRef(function CloudRain16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5,22H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22ZM16,4a7,7,0,0,0-6.94,6.14L9,11,8.14,11a4.5,4.5,0,0,0,.36,9h15a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82A7,7,0,0,0,16,4Z"}),React.createElement("path",{d:"M14,30a.93.93,0,0,1-.45-.11,1,1,0,0,1-.44-1.34l2-4a1,1,0,1,1,1.78.9l-2,4A1,1,0,0,1,14,30Z"}),React.createElement("path",{d:"M20,30a.93.93,0,0,1-.45-.11,1,1,0,0,1-.44-1.34l2-4a1,1,0,1,1,1.78.9l-2,4A1,1,0,0,1,20,30Z"}),React.createElement("path",{d:"M8,30a.93.93,0,0,1-.45-.11,1,1,0,0,1-.44-1.34l2-4a1,1,0,1,1,1.78.9l-2,4A1,1,0,0,1,8,30Z"}),props.children);});var CloudSnow32=/*#__PURE__*/React.forwardRef(function CloudSnow32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5,22H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22ZM16,4a7,7,0,0,0-6.94,6.14L9,11,8.14,11a4.5,4.5,0,0,0,.36,9h15a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82A7,7,0,0,0,16,4Z"}),React.createElement("polygon",{points:"12 25.05 10.95 24 9.5 25.45 8.05 24 7 25.05 8.45 26.5 7 27.95 8.05 29 9.5 27.55 10.95 29 12 27.95 10.55 26.5 12 25.05"}),React.createElement("polygon",{points:"26 25.05 24.95 24 23.5 25.45 22.05 24 21 25.05 22.45 26.5 21 27.95 22.05 29 23.5 27.55 24.95 29 26 27.95 24.55 26.5 26 25.05"}),React.createElement("polygon",{points:"19 27.05 17.95 26 16.5 27.45 15.05 26 14 27.05 15.45 28.5 14 29.95 15.05 31 16.5 29.55 17.95 31 19 29.95 17.55 28.5 19 27.05"}),props.children);});var CloudSnow24=/*#__PURE__*/React.forwardRef(function CloudSnow24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5,22H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22ZM16,4a7,7,0,0,0-6.94,6.14L9,11,8.14,11a4.5,4.5,0,0,0,.36,9h15a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82A7,7,0,0,0,16,4Z"}),React.createElement("polygon",{points:"12 25.05 10.95 24 9.5 25.45 8.05 24 7 25.05 8.45 26.5 7 27.95 8.05 29 9.5 27.55 10.95 29 12 27.95 10.55 26.5 12 25.05"}),React.createElement("polygon",{points:"26 25.05 24.95 24 23.5 25.45 22.05 24 21 25.05 22.45 26.5 21 27.95 22.05 29 23.5 27.55 24.95 29 26 27.95 24.55 26.5 26 25.05"}),React.createElement("polygon",{points:"19 27.05 17.95 26 16.5 27.45 15.05 26 14 27.05 15.45 28.5 14 29.95 15.05 31 16.5 29.55 17.95 31 19 29.95 17.55 28.5 19 27.05"}),props.children);});var CloudSnow20=/*#__PURE__*/React.forwardRef(function CloudSnow20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5,22H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22ZM16,4a7,7,0,0,0-6.94,6.14L9,11,8.14,11a4.5,4.5,0,0,0,.36,9h15a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82A7,7,0,0,0,16,4Z"}),React.createElement("polygon",{points:"12 25.05 10.95 24 9.5 25.45 8.05 24 7 25.05 8.45 26.5 7 27.95 8.05 29 9.5 27.55 10.95 29 12 27.95 10.55 26.5 12 25.05"}),React.createElement("polygon",{points:"26 25.05 24.95 24 23.5 25.45 22.05 24 21 25.05 22.45 26.5 21 27.95 22.05 29 23.5 27.55 24.95 29 26 27.95 24.55 26.5 26 25.05"}),React.createElement("polygon",{points:"19 27.05 17.95 26 16.5 27.45 15.05 26 14 27.05 15.45 28.5 14 29.95 15.05 31 16.5 29.55 17.95 31 19 29.95 17.55 28.5 19 27.05"}),props.children);});var CloudSnow16=/*#__PURE__*/React.forwardRef(function CloudSnow16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.5,22H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22ZM16,4a7,7,0,0,0-6.94,6.14L9,11,8.14,11a4.5,4.5,0,0,0,.36,9h15a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82A7,7,0,0,0,16,4Z"}),React.createElement("polygon",{points:"12 25.05 10.95 24 9.5 25.45 8.05 24 7 25.05 8.45 26.5 7 27.95 8.05 29 9.5 27.55 10.95 29 12 27.95 10.55 26.5 12 25.05"}),React.createElement("polygon",{points:"26 25.05 24.95 24 23.5 25.45 22.05 24 21 25.05 22.45 26.5 21 27.95 22.05 29 23.5 27.55 24.95 29 26 27.95 24.55 26.5 26 25.05"}),React.createElement("polygon",{points:"19 27.05 17.95 26 16.5 27.45 15.05 26 14 27.05 15.45 28.5 14 29.95 15.05 31 16.5 29.55 17.95 31 19 29.95 17.55 28.5 19 27.05"}),props.children);});var CloudUpload32=/*#__PURE__*/React.forwardRef(function CloudUpload32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"11 18 12.41 19.41 15 16.83 15 29 17 29 17 16.83 19.59 19.41 21 18 16 13 11 18"}),React.createElement("path",{d:"M23.5,22H23V20h.5a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82a7,7,0,0,0-13.88,0L9,11,8.14,11a4.5,4.5,0,0,0,.36,9H9v2H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22Z"}),props.children);});var CloudUpload24=/*#__PURE__*/React.forwardRef(function CloudUpload24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"11 18 12.41 19.41 15 16.83 15 29 17 29 17 16.83 19.59 19.41 21 18 16 13 11 18"}),React.createElement("path",{d:"M23.5,22H23V20h.5a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82a7,7,0,0,0-13.88,0L9,11,8.14,11a4.5,4.5,0,0,0,.36,9H9v2H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22Z"}),props.children);});var CloudUpload20=/*#__PURE__*/React.forwardRef(function CloudUpload20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"11 18 12.41 19.41 15 16.83 15 29 17 29 17 16.83 19.59 19.41 21 18 16 13 11 18"}),React.createElement("path",{d:"M23.5,22H23V20h.5a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82a7,7,0,0,0-13.88,0L9,11,8.14,11a4.5,4.5,0,0,0,.36,9H9v2H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22Z"}),props.children);});var CloudUpload16=/*#__PURE__*/React.forwardRef(function CloudUpload16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"11 18 12.41 19.41 15 16.83 15 29 17 29 17 16.83 19.59 19.41 21 18 16 13 11 18"}),React.createElement("path",{d:"M23.5,22H23V20h.5a4.5,4.5,0,0,0,.36-9L23,11l-.1-.82a7,7,0,0,0-13.88,0L9,11,8.14,11a4.5,4.5,0,0,0,.36,9H9v2H8.5A6.5,6.5,0,0,1,7.2,9.14a9,9,0,0,1,17.6,0A6.5,6.5,0,0,1,23.5,22Z"}),props.children);});var CloudApp32=/*#__PURE__*/React.forwardRef(function CloudApp32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.8289,13.1155A10.02,10.02,0,0,0,16,5.0005V7a8.0233,8.0233,0,0,1,7.8649,6.4934l.2591,1.346,1.3488.2441A5.5019,5.5019,0,0,1,24.5076,26H16v2h8.5076a7.5019,7.5019,0,0,0,1.3213-14.8845Z"}),React.createElement("rect",{width:"6",height:"2",x:"8",y:"24"}),React.createElement("rect",{width:"2",height:"2",x:"4",y:"24"}),React.createElement("rect",{width:"8",height:"2",x:"6",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"2",y:"20"}),React.createElement("rect",{width:"6",height:"2",x:"8",y:"16"}),React.createElement("rect",{width:"2",height:"2",x:"4",y:"16"}),React.createElement("rect",{width:"4",height:"2",x:"10",y:"12"}),React.createElement("rect",{width:"2",height:"2",x:"6",y:"12"}),React.createElement("rect",{width:"2",height:"2",x:"12",y:"8"}),props.children);});var CloudApp24=/*#__PURE__*/React.forwardRef(function CloudApp24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.8289,13.1155A10.02,10.02,0,0,0,16,5.0005V7a8.0233,8.0233,0,0,1,7.8649,6.4934l.2591,1.346,1.3488.2441A5.5019,5.5019,0,0,1,24.5076,26H16v2h8.5076a7.5019,7.5019,0,0,0,1.3213-14.8845Z"}),React.createElement("rect",{width:"6",height:"2",x:"8",y:"24"}),React.createElement("rect",{width:"2",height:"2",x:"4",y:"24"}),React.createElement("rect",{width:"8",height:"2",x:"6",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"2",y:"20"}),React.createElement("rect",{width:"6",height:"2",x:"8",y:"16"}),React.createElement("rect",{width:"2",height:"2",x:"4",y:"16"}),React.createElement("rect",{width:"4",height:"2",x:"10",y:"12"}),React.createElement("rect",{width:"2",height:"2",x:"6",y:"12"}),React.createElement("rect",{width:"2",height:"2",x:"12",y:"8"}),props.children);});var CloudApp20=/*#__PURE__*/React.forwardRef(function CloudApp20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.8289,13.1155A10.02,10.02,0,0,0,16,5.0005V7a8.0233,8.0233,0,0,1,7.8649,6.4934l.2591,1.346,1.3488.2441A5.5019,5.5019,0,0,1,24.5076,26H16v2h8.5076a7.5019,7.5019,0,0,0,1.3213-14.8845Z"}),React.createElement("rect",{width:"6",height:"2",x:"8",y:"24"}),React.createElement("rect",{width:"2",height:"2",x:"4",y:"24"}),React.createElement("rect",{width:"8",height:"2",x:"6",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"2",y:"20"}),React.createElement("rect",{width:"6",height:"2",x:"8",y:"16"}),React.createElement("rect",{width:"2",height:"2",x:"4",y:"16"}),React.createElement("rect",{width:"4",height:"2",x:"10",y:"12"}),React.createElement("rect",{width:"2",height:"2",x:"6",y:"12"}),React.createElement("rect",{width:"2",height:"2",x:"12",y:"8"}),props.children);});var CloudApp16=/*#__PURE__*/React.forwardRef(function CloudApp16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.8289,13.1155A10.02,10.02,0,0,0,16,5.0005V7a8.0233,8.0233,0,0,1,7.8649,6.4934l.2591,1.346,1.3488.2441A5.5019,5.5019,0,0,1,24.5076,26H16v2h8.5076a7.5019,7.5019,0,0,0,1.3213-14.8845Z"}),React.createElement("rect",{width:"6",height:"2",x:"8",y:"24"}),React.createElement("rect",{width:"2",height:"2",x:"4",y:"24"}),React.createElement("rect",{width:"8",height:"2",x:"6",y:"20"}),React.createElement("rect",{width:"2",height:"2",x:"2",y:"20"}),React.createElement("rect",{width:"6",height:"2",x:"8",y:"16"}),React.createElement("rect",{width:"2",height:"2",x:"4",y:"16"}),React.createElement("rect",{width:"4",height:"2",x:"10",y:"12"}),React.createElement("rect",{width:"2",height:"2",x:"6",y:"12"}),React.createElement("rect",{width:"2",height:"2",x:"12",y:"8"}),props.children);});var CloudFoundry_132=/*#__PURE__*/React.forwardRef(function CloudFoundry_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,7h0a7.66,7.66,0,0,1,1.51.15,8,8,0,0,1,6.35,6.34l.26,1.35,1.35.24a5.5,5.5,0,0,1-1,10.92H7.5a5.5,5.5,0,0,1-1-10.92l1.34-.24.26-1.35A8,8,0,0,1,16,7m0-2a10,10,0,0,0-9.83,8.12A7.5,7.5,0,0,0,7.49,28h17a7.5,7.5,0,0,0,1.32-14.88,10,10,0,0,0-7.94-7.94A10.27,10.27,0,0,0,16,5Z"}),React.createElement("path",{d:"M14,24H11a2,2,0,0,1-2-2V19a2,2,0,0,1,2-2h3v2H11v3h3Z"}),React.createElement("path",{d:"M21,15V13H19a2,2,0,0,0-2,2v2H16v2h1v5h2V19h2V17H19V15Z"}),props.children);});var CloudFoundry_124=/*#__PURE__*/React.forwardRef(function CloudFoundry_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,7h0a7.66,7.66,0,0,1,1.51.15,8,8,0,0,1,6.35,6.34l.26,1.35,1.35.24a5.5,5.5,0,0,1-1,10.92H7.5a5.5,5.5,0,0,1-1-10.92l1.34-.24.26-1.35A8,8,0,0,1,16,7m0-2a10,10,0,0,0-9.83,8.12A7.5,7.5,0,0,0,7.49,28h17a7.5,7.5,0,0,0,1.32-14.88,10,10,0,0,0-7.94-7.94A10.27,10.27,0,0,0,16,5Z"}),React.createElement("path",{d:"M14,24H11a2,2,0,0,1-2-2V19a2,2,0,0,1,2-2h3v2H11v3h3Z"}),React.createElement("path",{d:"M21,15V13H19a2,2,0,0,0-2,2v2H16v2h1v5h2V19h2V17H19V15Z"}),props.children);});var CloudFoundry_120=/*#__PURE__*/React.forwardRef(function CloudFoundry_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,7h0a7.66,7.66,0,0,1,1.51.15,8,8,0,0,1,6.35,6.34l.26,1.35,1.35.24a5.5,5.5,0,0,1-1,10.92H7.5a5.5,5.5,0,0,1-1-10.92l1.34-.24.26-1.35A8,8,0,0,1,16,7m0-2a10,10,0,0,0-9.83,8.12A7.5,7.5,0,0,0,7.49,28h17a7.5,7.5,0,0,0,1.32-14.88,10,10,0,0,0-7.94-7.94A10.27,10.27,0,0,0,16,5Z"}),React.createElement("path",{d:"M14,24H11a2,2,0,0,1-2-2V19a2,2,0,0,1,2-2h3v2H11v3h3Z"}),React.createElement("path",{d:"M21,15V13H19a2,2,0,0,0-2,2v2H16v2h1v5h2V19h2V17H19V15Z"}),props.children);});var CloudFoundry_116=/*#__PURE__*/React.forwardRef(function CloudFoundry_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,7h0a7.66,7.66,0,0,1,1.51.15,8,8,0,0,1,6.35,6.34l.26,1.35,1.35.24a5.5,5.5,0,0,1-1,10.92H7.5a5.5,5.5,0,0,1-1-10.92l1.34-.24.26-1.35A8,8,0,0,1,16,7m0-2a10,10,0,0,0-9.83,8.12A7.5,7.5,0,0,0,7.49,28h17a7.5,7.5,0,0,0,1.32-14.88,10,10,0,0,0-7.94-7.94A10.27,10.27,0,0,0,16,5Z"}),React.createElement("path",{d:"M14,24H11a2,2,0,0,1-2-2V19a2,2,0,0,1,2-2h3v2H11v3h3Z"}),React.createElement("path",{d:"M21,15V13H19a2,2,0,0,0-2,2v2H16v2h1v5h2V19h2V17H19V15Z"}),props.children);});var CloudFoundry_232=/*#__PURE__*/React.forwardRef(function CloudFoundry_232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"25 11 25 9 17 9 17 23 19 23 19 17 24 17 24 15 19 15 19 11 25 11"}),React.createElement("path",{d:"M15,23H9a2,2,0,0,1-2-2V11A2,2,0,0,1,9,9h6v2H9V21h6Z"}),props.children);});var CloudFoundry_224=/*#__PURE__*/React.forwardRef(function CloudFoundry_224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"25 11 25 9 17 9 17 23 19 23 19 17 24 17 24 15 19 15 19 11 25 11"}),React.createElement("path",{d:"M15,23H9a2,2,0,0,1-2-2V11A2,2,0,0,1,9,9h6v2H9V21h6Z"}),props.children);});var CloudFoundry_220=/*#__PURE__*/React.forwardRef(function CloudFoundry_220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"25 11 25 9 17 9 17 23 19 23 19 17 24 17 24 15 19 15 19 11 25 11"}),React.createElement("path",{d:"M15,23H9a2,2,0,0,1-2-2V11A2,2,0,0,1,9,9h6v2H9V21h6Z"}),props.children);});var CloudFoundry_216=/*#__PURE__*/React.forwardRef(function CloudFoundry_216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"25 11 25 9 17 9 17 23 19 23 19 17 24 17 24 15 19 15 19 11 25 11"}),React.createElement("path",{d:"M15,23H9a2,2,0,0,1-2-2V11A2,2,0,0,1,9,9h6v2H9V21h6Z"}),props.children);});var Cloud32=/*#__PURE__*/React.forwardRef(function Cloud32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,7h0a7.66,7.66,0,0,1,1.51.15,8,8,0,0,1,6.35,6.34l.26,1.35,1.35.24a5.5,5.5,0,0,1-1,10.92H7.5a5.5,5.5,0,0,1-1-10.92l1.34-.24.26-1.35A8,8,0,0,1,16,7m0-2a10,10,0,0,0-9.83,8.12A7.5,7.5,0,0,0,7.49,28h17a7.5,7.5,0,0,0,1.32-14.88,10,10,0,0,0-7.94-7.94A10.27,10.27,0,0,0,16,5Z"}),props.children);});var Cloud24=/*#__PURE__*/React.forwardRef(function Cloud24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,7h0a7.66,7.66,0,0,1,1.51.15,8,8,0,0,1,6.35,6.34l.26,1.35,1.35.24a5.5,5.5,0,0,1-1,10.92H7.5a5.5,5.5,0,0,1-1-10.92l1.34-.24.26-1.35A8,8,0,0,1,16,7m0-2a10,10,0,0,0-9.83,8.12A7.5,7.5,0,0,0,7.49,28h17a7.5,7.5,0,0,0,1.32-14.88,10,10,0,0,0-7.94-7.94A10.27,10.27,0,0,0,16,5Z"}),props.children);});var Cloud20=/*#__PURE__*/React.forwardRef(function Cloud20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,7h0a7.66,7.66,0,0,1,1.51.15,8,8,0,0,1,6.35,6.34l.26,1.35,1.35.24a5.5,5.5,0,0,1-1,10.92H7.5a5.5,5.5,0,0,1-1-10.92l1.34-.24.26-1.35A8,8,0,0,1,16,7m0-2a10,10,0,0,0-9.83,8.12A7.5,7.5,0,0,0,7.49,28h17a7.5,7.5,0,0,0,1.32-14.88,10,10,0,0,0-7.94-7.94A10.27,10.27,0,0,0,16,5Z"}),props.children);});var Cloud16=/*#__PURE__*/React.forwardRef(function Cloud16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,7h0a7.66,7.66,0,0,1,1.51.15,8,8,0,0,1,6.35,6.34l.26,1.35,1.35.24a5.5,5.5,0,0,1-1,10.92H7.5a5.5,5.5,0,0,1-1-10.92l1.34-.24.26-1.35A8,8,0,0,1,16,7m0-2a10,10,0,0,0-9.83,8.12A7.5,7.5,0,0,0,7.49,28h17a7.5,7.5,0,0,0,1.32-14.88,10,10,0,0,0-7.94-7.94A10.27,10.27,0,0,0,16,5Z"}),props.children);});var Cloudy32=/*#__PURE__*/React.forwardRef(function Cloudy32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30.0005,15.5005a6.5324,6.5324,0,0,0-5.1992-6.3638,8.9943,8.9943,0,0,0-17.6006,0,6.5321,6.5321,0,0,0-5.2,6.3638,6.4543,6.4543,0,0,0,1.6887,4.35A5.9829,5.9829,0,0,0,8,30H19a5.9764,5.9764,0,0,0,5.6094-8.1016A6.5051,6.5051,0,0,0,30.0005,15.5005ZM19,28H8a3.9925,3.9925,0,0,1-.6731-7.9292L7.99,19.958l.1458-.6562a5.496,5.496,0,0,1,10.7294,0l.1458.6562.6626.1128A3.9925,3.9925,0,0,1,19,28Zm4.5-8h-.0554a5.9562,5.9562,0,0,0-2.7959-1.7564,7.4952,7.4952,0,0,0-14.2984,0,5.9877,5.9877,0,0,0-1.0315.4073A4.4446,4.4446,0,0,1,4,15.5005a4.5171,4.5171,0,0,1,4.144-4.481l.8155-.0639.0991-.812a6.9938,6.9938,0,0,1,13.8838,0l.0986.812.8154.0639a4.4975,4.4975,0,0,1-.3564,8.981Z"}),props.children);});var Cloudy24=/*#__PURE__*/React.forwardRef(function Cloudy24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30.0005,15.5005a6.5324,6.5324,0,0,0-5.1992-6.3638,8.9943,8.9943,0,0,0-17.6006,0,6.5321,6.5321,0,0,0-5.2,6.3638,6.4543,6.4543,0,0,0,1.6887,4.35A5.9829,5.9829,0,0,0,8,30H19a5.9764,5.9764,0,0,0,5.6094-8.1016A6.5051,6.5051,0,0,0,30.0005,15.5005ZM19,28H8a3.9925,3.9925,0,0,1-.6731-7.9292L7.99,19.958l.1458-.6562a5.496,5.496,0,0,1,10.7294,0l.1458.6562.6626.1128A3.9925,3.9925,0,0,1,19,28Zm4.5-8h-.0554a5.9562,5.9562,0,0,0-2.7959-1.7564,7.4952,7.4952,0,0,0-14.2984,0,5.9877,5.9877,0,0,0-1.0315.4073A4.4446,4.4446,0,0,1,4,15.5005a4.5171,4.5171,0,0,1,4.144-4.481l.8155-.0639.0991-.812a6.9938,6.9938,0,0,1,13.8838,0l.0986.812.8154.0639a4.4975,4.4975,0,0,1-.3564,8.981Z"}),props.children);});var Cloudy20=/*#__PURE__*/React.forwardRef(function Cloudy20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30.0005,15.5005a6.5324,6.5324,0,0,0-5.1992-6.3638,8.9943,8.9943,0,0,0-17.6006,0,6.5321,6.5321,0,0,0-5.2,6.3638,6.4543,6.4543,0,0,0,1.6887,4.35A5.9829,5.9829,0,0,0,8,30H19a5.9764,5.9764,0,0,0,5.6094-8.1016A6.5051,6.5051,0,0,0,30.0005,15.5005ZM19,28H8a3.9925,3.9925,0,0,1-.6731-7.9292L7.99,19.958l.1458-.6562a5.496,5.496,0,0,1,10.7294,0l.1458.6562.6626.1128A3.9925,3.9925,0,0,1,19,28Zm4.5-8h-.0554a5.9562,5.9562,0,0,0-2.7959-1.7564,7.4952,7.4952,0,0,0-14.2984,0,5.9877,5.9877,0,0,0-1.0315.4073A4.4446,4.4446,0,0,1,4,15.5005a4.5171,4.5171,0,0,1,4.144-4.481l.8155-.0639.0991-.812a6.9938,6.9938,0,0,1,13.8838,0l.0986.812.8154.0639a4.4975,4.4975,0,0,1-.3564,8.981Z"}),props.children);});var Cloudy16=/*#__PURE__*/React.forwardRef(function Cloudy16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30.0005,15.5005a6.5324,6.5324,0,0,0-5.1992-6.3638,8.9943,8.9943,0,0,0-17.6006,0,6.5321,6.5321,0,0,0-5.2,6.3638,6.4543,6.4543,0,0,0,1.6887,4.35A5.9829,5.9829,0,0,0,8,30H19a5.9764,5.9764,0,0,0,5.6094-8.1016A6.5051,6.5051,0,0,0,30.0005,15.5005ZM19,28H8a3.9925,3.9925,0,0,1-.6731-7.9292L7.99,19.958l.1458-.6562a5.496,5.496,0,0,1,10.7294,0l.1458.6562.6626.1128A3.9925,3.9925,0,0,1,19,28Zm4.5-8h-.0554a5.9562,5.9562,0,0,0-2.7959-1.7564,7.4952,7.4952,0,0,0-14.2984,0,5.9877,5.9877,0,0,0-1.0315.4073A4.4446,4.4446,0,0,1,4,15.5005a4.5171,4.5171,0,0,1,4.144-4.481l.8155-.0639.0991-.812a6.9938,6.9938,0,0,1,13.8838,0l.0986.812.8154.0639a4.4975,4.4975,0,0,1-.3564,8.981Z"}),props.children);});var Code32=/*#__PURE__*/React.forwardRef(function Code32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"31 16 24 23 22.59 21.59 28.17 16 22.59 10.41 24 9 31 16"}),React.createElement("polygon",{points:"1 16 8 9 9.41 10.41 3.83 16 9.41 21.59 8 23 1 16"}),React.createElement("rect",{width:"20.17",height:"2",x:"5.91",y:"15",transform:"rotate(-75 15.996 16)"}),props.children);});var Code24=/*#__PURE__*/React.forwardRef(function Code24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"31 16 24 23 22.59 21.59 28.17 16 22.59 10.41 24 9 31 16"}),React.createElement("polygon",{points:"1 16 8 9 9.41 10.41 3.83 16 9.41 21.59 8 23 1 16"}),React.createElement("rect",{width:"20.17",height:"2",x:"5.91",y:"15",transform:"rotate(-75 15.996 16)"}),props.children);});var Code20=/*#__PURE__*/React.forwardRef(function Code20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"31 16 24 23 22.59 21.59 28.17 16 22.59 10.41 24 9 31 16"}),React.createElement("polygon",{points:"1 16 8 9 9.41 10.41 3.83 16 9.41 21.59 8 23 1 16"}),React.createElement("rect",{width:"20.17",height:"2",x:"5.91",y:"15",transform:"rotate(-75 15.996 16)"}),props.children);});var Code16=/*#__PURE__*/React.forwardRef(function Code16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"31 16 24 23 22.59 21.59 28.17 16 22.59 10.41 24 9 31 16"}),React.createElement("polygon",{points:"1 16 8 9 9.41 10.41 3.83 16 9.41 21.59 8 23 1 16"}),React.createElement("rect",{width:"20.17",height:"2",x:"5.91",y:"15",transform:"rotate(-75 15.996 16)"}),props.children);});var Cognitive32=/*#__PURE__*/React.forwardRef(function Cognitive32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,13A11,11,0,0,0,19,2H11a9,9,0,0,0-9,9v3a5,5,0,0,0,5,5H8.1A5,5,0,0,0,13,23h1.38l4,7,1.73-1-4-6.89A2,2,0,0,0,14.38,21H13a3,3,0,0,1,0-6h1V13H13a5,5,0,0,0-4.9,4H7a3,3,0,0,1-3-3V12H6A3,3,0,0,0,9,9V8H7V9a1,1,0,0,1-1,1H4.08A7,7,0,0,1,11,4h6V6a1,1,0,0,1-1,1H14V9h2a3,3,0,0,0,3-3V4a9,9,0,0,1,8.05,5H26a3,3,0,0,0-3,3v1h2V12a1,1,0,0,1,1-1h1.77A8.76,8.76,0,0,1,28,13v1a5,5,0,0,1-5,5H20v2h3a7,7,0,0,0,3-.68V21a3,3,0,0,1-3,3H22v2h1a5,5,0,0,0,5-5V18.89A7,7,0,0,0,30,14Z"}),props.children);});var Cognitive24=/*#__PURE__*/React.forwardRef(function Cognitive24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,13A11,11,0,0,0,19,2H11a9,9,0,0,0-9,9v3a5,5,0,0,0,5,5H8.1A5,5,0,0,0,13,23h1.38l4,7,1.73-1-4-6.89A2,2,0,0,0,14.38,21H13a3,3,0,0,1,0-6h1V13H13a5,5,0,0,0-4.9,4H7a3,3,0,0,1-3-3V12H6A3,3,0,0,0,9,9V8H7V9a1,1,0,0,1-1,1H4.08A7,7,0,0,1,11,4h6V6a1,1,0,0,1-1,1H14V9h2a3,3,0,0,0,3-3V4a9,9,0,0,1,8.05,5H26a3,3,0,0,0-3,3v1h2V12a1,1,0,0,1,1-1h1.77A8.76,8.76,0,0,1,28,13v1a5,5,0,0,1-5,5H20v2h3a7,7,0,0,0,3-.68V21a3,3,0,0,1-3,3H22v2h1a5,5,0,0,0,5-5V18.89A7,7,0,0,0,30,14Z"}),props.children);});var Cognitive20=/*#__PURE__*/React.forwardRef(function Cognitive20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,13A11,11,0,0,0,19,2H11a9,9,0,0,0-9,9v3a5,5,0,0,0,5,5H8.1A5,5,0,0,0,13,23h1.38l4,7,1.73-1-4-6.89A2,2,0,0,0,14.38,21H13a3,3,0,0,1,0-6h1V13H13a5,5,0,0,0-4.9,4H7a3,3,0,0,1-3-3V12H6A3,3,0,0,0,9,9V8H7V9a1,1,0,0,1-1,1H4.08A7,7,0,0,1,11,4h6V6a1,1,0,0,1-1,1H14V9h2a3,3,0,0,0,3-3V4a9,9,0,0,1,8.05,5H26a3,3,0,0,0-3,3v1h2V12a1,1,0,0,1,1-1h1.77A8.76,8.76,0,0,1,28,13v1a5,5,0,0,1-5,5H20v2h3a7,7,0,0,0,3-.68V21a3,3,0,0,1-3,3H22v2h1a5,5,0,0,0,5-5V18.89A7,7,0,0,0,30,14Z"}),props.children);});var Cognitive16=/*#__PURE__*/React.forwardRef(function Cognitive16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,13A11,11,0,0,0,19,2H11a9,9,0,0,0-9,9v3a5,5,0,0,0,5,5H8.1A5,5,0,0,0,13,23h1.38l4,7,1.73-1-4-6.89A2,2,0,0,0,14.38,21H13a3,3,0,0,1,0-6h1V13H13a5,5,0,0,0-4.9,4H7a3,3,0,0,1-3-3V12H6A3,3,0,0,0,9,9V8H7V9a1,1,0,0,1-1,1H4.08A7,7,0,0,1,11,4h6V6a1,1,0,0,1-1,1H14V9h2a3,3,0,0,0,3-3V4a9,9,0,0,1,8.05,5H26a3,3,0,0,0-3,3v1h2V12a1,1,0,0,1,1-1h1.77A8.76,8.76,0,0,1,28,13v1a5,5,0,0,1-5,5H20v2h3a7,7,0,0,0,3-.68V21a3,3,0,0,1-3,3H22v2h1a5,5,0,0,0,5-5V18.89A7,7,0,0,0,30,14Z"}),props.children);});var Collaborate32=/*#__PURE__*/React.forwardRef(function Collaborate32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,21V20H4v1a7,7,0,0,0,7,7h3V26H11A5,5,0,0,1,6,21Z"}),React.createElement("path",{d:"M24,11v1h2V11a7,7,0,0,0-7-7H16V6h3A5,5,0,0,1,24,11Z"}),React.createElement("path",{d:"M11,11H5a3,3,0,0,0-3,3v2H4V14a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1v2h2V14A3,3,0,0,0,11,11Z"}),React.createElement("path",{d:"M8,10A4,4,0,1,0,4,6,4,4,0,0,0,8,10ZM8,4A2,2,0,1,1,6,6,2,2,0,0,1,8,4Z"}),React.createElement("path",{d:"M27,25H21a3,3,0,0,0-3,3v2h2V28a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1v2h2V28A3,3,0,0,0,27,25Z"}),React.createElement("path",{d:"M20,20a4,4,0,1,0,4-4A4,4,0,0,0,20,20Zm6,0a2,2,0,1,1-2-2A2,2,0,0,1,26,20Z"}),props.children);});var Collaborate24=/*#__PURE__*/React.forwardRef(function Collaborate24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,21V20H4v1a7,7,0,0,0,7,7h3V26H11A5,5,0,0,1,6,21Z"}),React.createElement("path",{d:"M24,11v1h2V11a7,7,0,0,0-7-7H16V6h3A5,5,0,0,1,24,11Z"}),React.createElement("path",{d:"M11,11H5a3,3,0,0,0-3,3v2H4V14a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1v2h2V14A3,3,0,0,0,11,11Z"}),React.createElement("path",{d:"M8,10A4,4,0,1,0,4,6,4,4,0,0,0,8,10ZM8,4A2,2,0,1,1,6,6,2,2,0,0,1,8,4Z"}),React.createElement("path",{d:"M27,25H21a3,3,0,0,0-3,3v2h2V28a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1v2h2V28A3,3,0,0,0,27,25Z"}),React.createElement("path",{d:"M20,20a4,4,0,1,0,4-4A4,4,0,0,0,20,20Zm6,0a2,2,0,1,1-2-2A2,2,0,0,1,26,20Z"}),props.children);});var Collaborate20=/*#__PURE__*/React.forwardRef(function Collaborate20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,21V20H4v1a7,7,0,0,0,7,7h3V26H11A5,5,0,0,1,6,21Z"}),React.createElement("path",{d:"M24,11v1h2V11a7,7,0,0,0-7-7H16V6h3A5,5,0,0,1,24,11Z"}),React.createElement("path",{d:"M11,11H5a3,3,0,0,0-3,3v2H4V14a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1v2h2V14A3,3,0,0,0,11,11Z"}),React.createElement("path",{d:"M8,10A4,4,0,1,0,4,6,4,4,0,0,0,8,10ZM8,4A2,2,0,1,1,6,6,2,2,0,0,1,8,4Z"}),React.createElement("path",{d:"M27,25H21a3,3,0,0,0-3,3v2h2V28a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1v2h2V28A3,3,0,0,0,27,25Z"}),React.createElement("path",{d:"M20,20a4,4,0,1,0,4-4A4,4,0,0,0,20,20Zm6,0a2,2,0,1,1-2-2A2,2,0,0,1,26,20Z"}),props.children);});var Collaborate16=/*#__PURE__*/React.forwardRef(function Collaborate16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,21V20H4v1a7,7,0,0,0,7,7h3V26H11A5,5,0,0,1,6,21Z"}),React.createElement("path",{d:"M24,11v1h2V11a7,7,0,0,0-7-7H16V6h3A5,5,0,0,1,24,11Z"}),React.createElement("path",{d:"M11,11H5a3,3,0,0,0-3,3v2H4V14a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1v2h2V14A3,3,0,0,0,11,11Z"}),React.createElement("path",{d:"M8,10A4,4,0,1,0,4,6,4,4,0,0,0,8,10ZM8,4A2,2,0,1,1,6,6,2,2,0,0,1,8,4Z"}),React.createElement("path",{d:"M27,25H21a3,3,0,0,0-3,3v2h2V28a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1v2h2V28A3,3,0,0,0,27,25Z"}),React.createElement("path",{d:"M20,20a4,4,0,1,0,4-4A4,4,0,0,0,20,20Zm6,0a2,2,0,1,1-2-2A2,2,0,0,1,26,20Z"}),props.children);});var CollapseAll32=/*#__PURE__*/React.forwardRef(function CollapseAll32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15H28V7H13V5H28a2.0023,2.0023,0,0,1,2,2Z"}),React.createElement("path",{d:"M25,20H23V12H8V10H23a2.0023,2.0023,0,0,1,2,2Z"}),React.createElement("path",{d:"M18,27H4a2.0023,2.0023,0,0,1-2-2V17a2.0023,2.0023,0,0,1,2-2H18a2.0023,2.0023,0,0,1,2,2v8A2.0023,2.0023,0,0,1,18,27ZM4,17v8H18.0012L18,17Z"}),props.children);});var CollapseAll24=/*#__PURE__*/React.forwardRef(function CollapseAll24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15H28V7H13V5H28a2.0023,2.0023,0,0,1,2,2Z"}),React.createElement("path",{d:"M25,20H23V12H8V10H23a2.0023,2.0023,0,0,1,2,2Z"}),React.createElement("path",{d:"M18,27H4a2.0023,2.0023,0,0,1-2-2V17a2.0023,2.0023,0,0,1,2-2H18a2.0023,2.0023,0,0,1,2,2v8A2.0023,2.0023,0,0,1,18,27ZM4,17v8H18.0012L18,17Z"}),props.children);});var CollapseAll20=/*#__PURE__*/React.forwardRef(function CollapseAll20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15H28V7H13V5H28a2.0023,2.0023,0,0,1,2,2Z"}),React.createElement("path",{d:"M25,20H23V12H8V10H23a2.0023,2.0023,0,0,1,2,2Z"}),React.createElement("path",{d:"M18,27H4a2.0023,2.0023,0,0,1-2-2V17a2.0023,2.0023,0,0,1,2-2H18a2.0023,2.0023,0,0,1,2,2v8A2.0023,2.0023,0,0,1,18,27ZM4,17v8H18.0012L18,17Z"}),props.children);});var CollapseAll16=/*#__PURE__*/React.forwardRef(function CollapseAll16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,15H28V7H13V5H28a2.0023,2.0023,0,0,1,2,2Z"}),React.createElement("path",{d:"M25,20H23V12H8V10H23a2.0023,2.0023,0,0,1,2,2Z"}),React.createElement("path",{d:"M18,27H4a2.0023,2.0023,0,0,1-2-2V17a2.0023,2.0023,0,0,1,2-2H18a2.0023,2.0023,0,0,1,2,2v8A2.0023,2.0023,0,0,1,18,27ZM4,17v8H18.0012L18,17Z"}),props.children);});var CollapseCategories32=/*#__PURE__*/React.forwardRef(function CollapseCategories32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"14",height:"2",x:"14",y:"25"}),React.createElement("polygon",{points:"7.17 26 4.59 28.58 6 30 10 26 6 22 4.58 23.41 7.17 26"}),React.createElement("rect",{width:"14",height:"2",x:"14",y:"15"}),React.createElement("polygon",{points:"7.17 16 4.59 18.58 6 20 10 16 6 12 4.58 13.41 7.17 16"}),React.createElement("rect",{width:"14",height:"2",x:"14",y:"5"}),React.createElement("polygon",{points:"7.17 6 4.59 8.58 6 10 10 6 6 2 4.58 3.41 7.17 6"}),props.children);});var CollapseCategories24=/*#__PURE__*/React.forwardRef(function CollapseCategories24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"14",height:"2",x:"14",y:"25"}),React.createElement("polygon",{points:"7.17 26 4.59 28.58 6 30 10 26 6 22 4.58 23.41 7.17 26"}),React.createElement("rect",{width:"14",height:"2",x:"14",y:"15"}),React.createElement("polygon",{points:"7.17 16 4.59 18.58 6 20 10 16 6 12 4.58 13.41 7.17 16"}),React.createElement("rect",{width:"14",height:"2",x:"14",y:"5"}),React.createElement("polygon",{points:"7.17 6 4.59 8.58 6 10 10 6 6 2 4.58 3.41 7.17 6"}),props.children);});var CollapseCategories20=/*#__PURE__*/React.forwardRef(function CollapseCategories20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"14",height:"2",x:"14",y:"25"}),React.createElement("polygon",{points:"7.17 26 4.59 28.58 6 30 10 26 6 22 4.58 23.41 7.17 26"}),React.createElement("rect",{width:"14",height:"2",x:"14",y:"15"}),React.createElement("polygon",{points:"7.17 16 4.59 18.58 6 20 10 16 6 12 4.58 13.41 7.17 16"}),React.createElement("rect",{width:"14",height:"2",x:"14",y:"5"}),React.createElement("polygon",{points:"7.17 6 4.59 8.58 6 10 10 6 6 2 4.58 3.41 7.17 6"}),props.children);});var CollapseCategories16=/*#__PURE__*/React.forwardRef(function CollapseCategories16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"14",height:"2",x:"14",y:"25"}),React.createElement("polygon",{points:"7.17 26 4.59 28.58 6 30 10 26 6 22 4.58 23.41 7.17 26"}),React.createElement("rect",{width:"14",height:"2",x:"14",y:"15"}),React.createElement("polygon",{points:"7.17 16 4.59 18.58 6 20 10 16 6 12 4.58 13.41 7.17 16"}),React.createElement("rect",{width:"14",height:"2",x:"14",y:"5"}),React.createElement("polygon",{points:"7.17 6 4.59 8.58 6 10 10 6 6 2 4.58 3.41 7.17 6"}),props.children);});var ColorPalette32=/*#__PURE__*/React.forwardRef(function ColorPalette32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"10",cy:"12",r:"2"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("circle",{cx:"22",cy:"12",r:"2"}),React.createElement("circle",{cx:"23",cy:"18",r:"2"}),React.createElement("circle",{cx:"19",cy:"23",r:"2"}),React.createElement("path",{d:"M16.54,2A14,14,0,0,0,2,16a4.82,4.82,0,0,0,6.09,4.65l1.12-.31A3,3,0,0,1,13,23.24V27a3,3,0,0,0,3,3A14,14,0,0,0,30,15.46,14.05,14.05,0,0,0,16.54,2Zm8.11,22.31A11.93,11.93,0,0,1,16,28a1,1,0,0,1-1-1V23.24a5,5,0,0,0-5-5,5.07,5.07,0,0,0-1.33.18l-1.12.31A2.82,2.82,0,0,1,4,16,12,12,0,0,1,16.47,4,12.18,12.18,0,0,1,28,15.53,11.89,11.89,0,0,1,24.65,24.32Z"}),props.children);});var ColorPalette24=/*#__PURE__*/React.forwardRef(function ColorPalette24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"10",cy:"12",r:"2"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("circle",{cx:"22",cy:"12",r:"2"}),React.createElement("circle",{cx:"23",cy:"18",r:"2"}),React.createElement("circle",{cx:"19",cy:"23",r:"2"}),React.createElement("path",{d:"M16.54,2A14,14,0,0,0,2,16a4.82,4.82,0,0,0,6.09,4.65l1.12-.31A3,3,0,0,1,13,23.24V27a3,3,0,0,0,3,3A14,14,0,0,0,30,15.46,14.05,14.05,0,0,0,16.54,2Zm8.11,22.31A11.93,11.93,0,0,1,16,28a1,1,0,0,1-1-1V23.24a5,5,0,0,0-5-5,5.07,5.07,0,0,0-1.33.18l-1.12.31A2.82,2.82,0,0,1,4,16,12,12,0,0,1,16.47,4,12.18,12.18,0,0,1,28,15.53,11.89,11.89,0,0,1,24.65,24.32Z"}),props.children);});var ColorPalette20=/*#__PURE__*/React.forwardRef(function ColorPalette20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"10",cy:"12",r:"2"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("circle",{cx:"22",cy:"12",r:"2"}),React.createElement("circle",{cx:"23",cy:"18",r:"2"}),React.createElement("circle",{cx:"19",cy:"23",r:"2"}),React.createElement("path",{d:"M16.54,2A14,14,0,0,0,2,16a4.82,4.82,0,0,0,6.09,4.65l1.12-.31A3,3,0,0,1,13,23.24V27a3,3,0,0,0,3,3A14,14,0,0,0,30,15.46,14.05,14.05,0,0,0,16.54,2Zm8.11,22.31A11.93,11.93,0,0,1,16,28a1,1,0,0,1-1-1V23.24a5,5,0,0,0-5-5,5.07,5.07,0,0,0-1.33.18l-1.12.31A2.82,2.82,0,0,1,4,16,12,12,0,0,1,16.47,4,12.18,12.18,0,0,1,28,15.53,11.89,11.89,0,0,1,24.65,24.32Z"}),props.children);});var ColorPalette16=/*#__PURE__*/React.forwardRef(function ColorPalette16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"10",cy:"12",r:"2"}),React.createElement("circle",{cx:"16",cy:"9",r:"2"}),React.createElement("circle",{cx:"22",cy:"12",r:"2"}),React.createElement("circle",{cx:"23",cy:"18",r:"2"}),React.createElement("circle",{cx:"19",cy:"23",r:"2"}),React.createElement("path",{d:"M16.54,2A14,14,0,0,0,2,16a4.82,4.82,0,0,0,6.09,4.65l1.12-.31A3,3,0,0,1,13,23.24V27a3,3,0,0,0,3,3A14,14,0,0,0,30,15.46,14.05,14.05,0,0,0,16.54,2Zm8.11,22.31A11.93,11.93,0,0,1,16,28a1,1,0,0,1-1-1V23.24a5,5,0,0,0-5-5,5.07,5.07,0,0,0-1.33.18l-1.12.31A2.82,2.82,0,0,1,4,16,12,12,0,0,1,16.47,4,12.18,12.18,0,0,1,28,15.53,11.89,11.89,0,0,1,24.65,24.32Z"}),props.children);});var ColorSwitch32=/*#__PURE__*/React.forwardRef(function ColorSwitch32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2.0025,2.0025,0,0,0,4,6V26a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V6A2.0025,2.0025,0,0,0,26,4ZM6,26,26,6V26Z"}),props.children);});var ColorSwitch24=/*#__PURE__*/React.forwardRef(function ColorSwitch24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2.0025,2.0025,0,0,0,4,6V26a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V6A2.0025,2.0025,0,0,0,26,4ZM6,26,26,6V26Z"}),props.children);});var ColorSwitch20=/*#__PURE__*/React.forwardRef(function ColorSwitch20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2.0025,2.0025,0,0,0,4,6V26a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V6A2.0025,2.0025,0,0,0,26,4ZM6,26,26,6V26Z"}),props.children);});var ColorSwitch16=/*#__PURE__*/React.forwardRef(function ColorSwitch16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,4H6A2.0025,2.0025,0,0,0,4,6V26a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V6A2.0025,2.0025,0,0,0,26,4ZM6,26,26,6V26Z"}),props.children);});var Column32=/*#__PURE__*/React.forwardRef(function Column32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"24",x:"24",y:"4"}),React.createElement("path",{d:"M18,6V26H14V6h4m0-2H14a2,2,0,0,0-2,2V26a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2Z"}),React.createElement("rect",{width:"2",height:"24",x:"6",y:"4"}),props.children);});var Column24=/*#__PURE__*/React.forwardRef(function Column24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"24",x:"24",y:"4"}),React.createElement("path",{d:"M18,6V26H14V6h4m0-2H14a2,2,0,0,0-2,2V26a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2Z"}),React.createElement("rect",{width:"2",height:"24",x:"6",y:"4"}),props.children);});var Column20=/*#__PURE__*/React.forwardRef(function Column20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"24",x:"24",y:"4"}),React.createElement("path",{d:"M18,6V26H14V6h4m0-2H14a2,2,0,0,0-2,2V26a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2Z"}),React.createElement("rect",{width:"2",height:"24",x:"6",y:"4"}),props.children);});var Column16=/*#__PURE__*/React.forwardRef(function Column16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"24",x:"24",y:"4"}),React.createElement("path",{d:"M18,6V26H14V6h4m0-2H14a2,2,0,0,0-2,2V26a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2Z"}),React.createElement("rect",{width:"2",height:"24",x:"6",y:"4"}),props.children);});var Compare32=/*#__PURE__*/React.forwardRef(function Compare32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H18V4a2,2,0,0,0-2-2H4A2,2,0,0,0,2,4V24a2,2,0,0,0,2,2H14v2a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM4,15h6.17L7.59,17.59,9,19l5-5L9,9,7.59,10.41,10.17,13H4V4H16V24H4ZM16,28V26a2,2,0,0,0,2-2V8H28v9H21.83l2.58-2.59L23,13l-5,5,5,5,1.41-1.41L21.83,19H28v9Z"}),props.children);});var Compare24=/*#__PURE__*/React.forwardRef(function Compare24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H18V4a2,2,0,0,0-2-2H4A2,2,0,0,0,2,4V24a2,2,0,0,0,2,2H14v2a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM4,15h6.17L7.59,17.59,9,19l5-5L9,9,7.59,10.41,10.17,13H4V4H16V24H4ZM16,28V26a2,2,0,0,0,2-2V8H28v9H21.83l2.58-2.59L23,13l-5,5,5,5,1.41-1.41L21.83,19H28v9Z"}),props.children);});var Compare20=/*#__PURE__*/React.forwardRef(function Compare20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H18V4a2,2,0,0,0-2-2H4A2,2,0,0,0,2,4V24a2,2,0,0,0,2,2H14v2a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM4,15h6.17L7.59,17.59,9,19l5-5L9,9,7.59,10.41,10.17,13H4V4H16V24H4ZM16,28V26a2,2,0,0,0,2-2V8H28v9H21.83l2.58-2.59L23,13l-5,5,5,5,1.41-1.41L21.83,19H28v9Z"}),props.children);});var Compare16=/*#__PURE__*/React.forwardRef(function Compare16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H18V4a2,2,0,0,0-2-2H4A2,2,0,0,0,2,4V24a2,2,0,0,0,2,2H14v2a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM4,15h6.17L7.59,17.59,9,19l5-5L9,9,7.59,10.41,10.17,13H4V4H16V24H4ZM16,28V26a2,2,0,0,0,2-2V8H28v9H21.83l2.58-2.59L23,13l-5,5,5,5,1.41-1.41L21.83,19H28v9Z"}),props.children);});var Compass32=/*#__PURE__*/React.forwardRef(function Compass32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,4A12,12,0,1,1,4,16,12,12,0,0,1,16,4m0-2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Z"}),React.createElement("path",{d:"M23,10.41,21.59,9l-4.3,4.3a3,3,0,0,0-4,4L9,21.59,10.41,23l4.3-4.3a3,3,0,0,0,4-4ZM17,16a1,1,0,1,1-1-1A1,1,0,0,1,17,16Z"}),React.createElement("circle",{cx:"16",cy:"7.5",r:"1.5"}),props.children);});var Compass24=/*#__PURE__*/React.forwardRef(function Compass24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,4A12,12,0,1,1,4,16,12,12,0,0,1,16,4m0-2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Z"}),React.createElement("path",{d:"M23,10.41,21.59,9l-4.3,4.3a3,3,0,0,0-4,4L9,21.59,10.41,23l4.3-4.3a3,3,0,0,0,4-4ZM17,16a1,1,0,1,1-1-1A1,1,0,0,1,17,16Z"}),React.createElement("circle",{cx:"16",cy:"7.5",r:"1.5"}),props.children);});var Compass20=/*#__PURE__*/React.forwardRef(function Compass20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,4A12,12,0,1,1,4,16,12,12,0,0,1,16,4m0-2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Z"}),React.createElement("path",{d:"M23,10.41,21.59,9l-4.3,4.3a3,3,0,0,0-4,4L9,21.59,10.41,23l4.3-4.3a3,3,0,0,0,4-4ZM17,16a1,1,0,1,1-1-1A1,1,0,0,1,17,16Z"}),React.createElement("circle",{cx:"16",cy:"7.5",r:"1.5"}),props.children);});var Compass16=/*#__PURE__*/React.forwardRef(function Compass16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,4A12,12,0,1,1,4,16,12,12,0,0,1,16,4m0-2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Z"}),React.createElement("path",{d:"M23,10.41,21.59,9l-4.3,4.3a3,3,0,0,0-4,4L9,21.59,10.41,23l4.3-4.3a3,3,0,0,0,4-4ZM17,16a1,1,0,1,1-1-1A1,1,0,0,1,17,16Z"}),React.createElement("circle",{cx:"16",cy:"7.5",r:"1.5"}),props.children);});var ComposerEdit32=/*#__PURE__*/React.forwardRef(function ComposerEdit32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82,10H30V8H25.82a3,3,0,0,0-5.64,0H13V5H5V8H2v2H5v3h8V10h7.18A3,3,0,0,0,22,11.82v7.32A4,4,0,0,0,19.14,22H2v2H19.14a4,4,0,0,0,7.72,0H30V22H26.86A4,4,0,0,0,24,19.14V11.82A3,3,0,0,0,25.82,10ZM11,11H7V7h4ZM25,23a2,2,0,1,1-2-2A2,2,0,0,1,25,23Z"}),props.children);});var ComposerEdit24=/*#__PURE__*/React.forwardRef(function ComposerEdit24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82,10H30V8H25.82a3,3,0,0,0-5.64,0H13V5H5V8H2v2H5v3h8V10h7.18A3,3,0,0,0,22,11.82v7.32A4,4,0,0,0,19.14,22H2v2H19.14a4,4,0,0,0,7.72,0H30V22H26.86A4,4,0,0,0,24,19.14V11.82A3,3,0,0,0,25.82,10ZM11,11H7V7h4ZM25,23a2,2,0,1,1-2-2A2,2,0,0,1,25,23Z"}),props.children);});var ComposerEdit20=/*#__PURE__*/React.forwardRef(function ComposerEdit20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82,10H30V8H25.82a3,3,0,0,0-5.64,0H13V5H5V8H2v2H5v3h8V10h7.18A3,3,0,0,0,22,11.82v7.32A4,4,0,0,0,19.14,22H2v2H19.14a4,4,0,0,0,7.72,0H30V22H26.86A4,4,0,0,0,24,19.14V11.82A3,3,0,0,0,25.82,10ZM11,11H7V7h4ZM25,23a2,2,0,1,1-2-2A2,2,0,0,1,25,23Z"}),props.children);});var ComposerEdit16=/*#__PURE__*/React.forwardRef(function ComposerEdit16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.82,10H30V8H25.82a3,3,0,0,0-5.64,0H13V5H5V8H2v2H5v3h8V10h7.18A3,3,0,0,0,22,11.82v7.32A4,4,0,0,0,19.14,22H2v2H19.14a4,4,0,0,0,7.72,0H30V22H26.86A4,4,0,0,0,24,19.14V11.82A3,3,0,0,0,25.82,10ZM11,11H7V7h4ZM25,23a2,2,0,1,1-2-2A2,2,0,0,1,25,23Z"}),props.children);});var Concept32=/*#__PURE__*/React.forwardRef(function Concept32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20.8851,19.4711a5.9609,5.9609,0,0,0,0-6.9422L23,10.4141l1.293,1.2929a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414l-4-4a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414L21.5859,9l-2.1148,2.1149a5.9609,5.9609,0,0,0-6.9422,0L10,8.5859V2H2v8H8.5859l2.529,2.5289a5.9609,5.9609,0,0,0,0,6.9422L9,21.5859,7.707,20.293a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414l4,4a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414L10.4141,23l2.1148-2.1149a5.9609,5.9609,0,0,0,6.9422,0L22,23.4141V30h8V22H23.4141ZM25,4.4141,27.5859,7,25,9.5859,22.4141,7ZM7,27.5859,4.4141,25,7,22.4141,9.5859,25ZM8,8H4V4H8Zm4,8a4,4,0,1,1,4,4A4.0045,4.0045,0,0,1,12,16Zm12,8h4v4H24Z"}),props.children);});var Concept24=/*#__PURE__*/React.forwardRef(function Concept24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20.8851,19.4711a5.9609,5.9609,0,0,0,0-6.9422L23,10.4141l1.293,1.2929a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414l-4-4a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414L21.5859,9l-2.1148,2.1149a5.9609,5.9609,0,0,0-6.9422,0L10,8.5859V2H2v8H8.5859l2.529,2.5289a5.9609,5.9609,0,0,0,0,6.9422L9,21.5859,7.707,20.293a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414l4,4a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414L10.4141,23l2.1148-2.1149a5.9609,5.9609,0,0,0,6.9422,0L22,23.4141V30h8V22H23.4141ZM25,4.4141,27.5859,7,25,9.5859,22.4141,7ZM7,27.5859,4.4141,25,7,22.4141,9.5859,25ZM8,8H4V4H8Zm4,8a4,4,0,1,1,4,4A4.0045,4.0045,0,0,1,12,16Zm12,8h4v4H24Z"}),props.children);});var Concept20=/*#__PURE__*/React.forwardRef(function Concept20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20.8851,19.4711a5.9609,5.9609,0,0,0,0-6.9422L23,10.4141l1.293,1.2929a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414l-4-4a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414L21.5859,9l-2.1148,2.1149a5.9609,5.9609,0,0,0-6.9422,0L10,8.5859V2H2v8H8.5859l2.529,2.5289a5.9609,5.9609,0,0,0,0,6.9422L9,21.5859,7.707,20.293a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414l4,4a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414L10.4141,23l2.1148-2.1149a5.9609,5.9609,0,0,0,6.9422,0L22,23.4141V30h8V22H23.4141ZM25,4.4141,27.5859,7,25,9.5859,22.4141,7ZM7,27.5859,4.4141,25,7,22.4141,9.5859,25ZM8,8H4V4H8Zm4,8a4,4,0,1,1,4,4A4.0045,4.0045,0,0,1,12,16Zm12,8h4v4H24Z"}),props.children);});var Concept16=/*#__PURE__*/React.forwardRef(function Concept16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20.8851,19.4711a5.9609,5.9609,0,0,0,0-6.9422L23,10.4141l1.293,1.2929a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414l-4-4a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414L21.5859,9l-2.1148,2.1149a5.9609,5.9609,0,0,0-6.9422,0L10,8.5859V2H2v8H8.5859l2.529,2.5289a5.9609,5.9609,0,0,0,0,6.9422L9,21.5859,7.707,20.293a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414l4,4a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414L10.4141,23l2.1148-2.1149a5.9609,5.9609,0,0,0,6.9422,0L22,23.4141V30h8V22H23.4141ZM25,4.4141,27.5859,7,25,9.5859,22.4141,7ZM7,27.5859,4.4141,25,7,22.4141,9.5859,25ZM8,8H4V4H8Zm4,8a4,4,0,1,1,4,4A4.0045,4.0045,0,0,1,12,16Zm12,8h4v4H24Z"}),props.children);});var Connect32=/*#__PURE__*/React.forwardRef(function Connect32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,16a7,7,0,0,0-4.18,1.39L14.6,13.17A6.86,6.86,0,0,0,16,9a7,7,0,1,0-2.81,5.59l4.21,4.22A7,7,0,1,0,23,16ZM4,9a5,5,0,1,1,5,5A5,5,0,0,1,4,9Z",transform:"translate(0 .01)"}),props.children);});var Connect24=/*#__PURE__*/React.forwardRef(function Connect24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,16a7,7,0,0,0-4.18,1.39L14.6,13.17A6.86,6.86,0,0,0,16,9a7,7,0,1,0-2.81,5.59l4.21,4.22A7,7,0,1,0,23,16ZM4,9a5,5,0,1,1,5,5A5,5,0,0,1,4,9Z",transform:"translate(0 .01)"}),props.children);});var Connect20=/*#__PURE__*/React.forwardRef(function Connect20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,16a7,7,0,0,0-4.18,1.39L14.6,13.17A6.86,6.86,0,0,0,16,9a7,7,0,1,0-2.81,5.59l4.21,4.22A7,7,0,1,0,23,16ZM4,9a5,5,0,1,1,5,5A5,5,0,0,1,4,9Z",transform:"translate(0 .01)"}),props.children);});var Connect16=/*#__PURE__*/React.forwardRef(function Connect16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,16a7,7,0,0,0-4.18,1.39L14.6,13.17A6.86,6.86,0,0,0,16,9a7,7,0,1,0-2.81,5.59l4.21,4.22A7,7,0,1,0,23,16ZM4,9a5,5,0,1,1,5,5A5,5,0,0,1,4,9Z",transform:"translate(0 .01)"}),props.children);});var ConnectionSignal32=/*#__PURE__*/React.forwardRef(function ConnectionSignal32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"18",x:"15",y:"12"}),React.createElement("path",{d:"M11.33,18.22a7,7,0,0,1,0-10.44l1.34,1.49a5,5,0,0,0,0,7.46Z"}),React.createElement("path",{d:"M20.67,18.22l-1.34-1.49a5,5,0,0,0,0-7.46l1.34-1.49a7,7,0,0,1,0,10.44Z"}),React.createElement("path",{d:"M8.4,21.8a11,11,0,0,1,0-17.6L9.6,5.8a9,9,0,0,0,0,14.4Z"}),React.createElement("path",{d:"M23.6,21.8l-1.2-1.6a9,9,0,0,0,0-14.4l1.2-1.6a11,11,0,0,1,0,17.6Z"}),props.children);});var ConnectionSignal24=/*#__PURE__*/React.forwardRef(function ConnectionSignal24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"18",x:"15",y:"12"}),React.createElement("path",{d:"M11.33,18.22a7,7,0,0,1,0-10.44l1.34,1.49a5,5,0,0,0,0,7.46Z"}),React.createElement("path",{d:"M20.67,18.22l-1.34-1.49a5,5,0,0,0,0-7.46l1.34-1.49a7,7,0,0,1,0,10.44Z"}),React.createElement("path",{d:"M8.4,21.8a11,11,0,0,1,0-17.6L9.6,5.8a9,9,0,0,0,0,14.4Z"}),React.createElement("path",{d:"M23.6,21.8l-1.2-1.6a9,9,0,0,0,0-14.4l1.2-1.6a11,11,0,0,1,0,17.6Z"}),props.children);});var ConnectionSignal20=/*#__PURE__*/React.forwardRef(function ConnectionSignal20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"18",x:"15",y:"12"}),React.createElement("path",{d:"M11.33,18.22a7,7,0,0,1,0-10.44l1.34,1.49a5,5,0,0,0,0,7.46Z"}),React.createElement("path",{d:"M20.67,18.22l-1.34-1.49a5,5,0,0,0,0-7.46l1.34-1.49a7,7,0,0,1,0,10.44Z"}),React.createElement("path",{d:"M8.4,21.8a11,11,0,0,1,0-17.6L9.6,5.8a9,9,0,0,0,0,14.4Z"}),React.createElement("path",{d:"M23.6,21.8l-1.2-1.6a9,9,0,0,0,0-14.4l1.2-1.6a11,11,0,0,1,0,17.6Z"}),props.children);});var ConnectionSignal16=/*#__PURE__*/React.forwardRef(function ConnectionSignal16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"18",x:"15",y:"12"}),React.createElement("path",{d:"M11.33,18.22a7,7,0,0,1,0-10.44l1.34,1.49a5,5,0,0,0,0,7.46Z"}),React.createElement("path",{d:"M20.67,18.22l-1.34-1.49a5,5,0,0,0,0-7.46l1.34-1.49a7,7,0,0,1,0,10.44Z"}),React.createElement("path",{d:"M8.4,21.8a11,11,0,0,1,0-17.6L9.6,5.8a9,9,0,0,0,0,14.4Z"}),React.createElement("path",{d:"M23.6,21.8l-1.2-1.6a9,9,0,0,0,0-14.4l1.2-1.6a11,11,0,0,1,0,17.6Z"}),props.children);});var ContainerSoftware32=/*#__PURE__*/React.forwardRef(function ContainerSoftware32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,12H20V4h8Zm-6-2h4V6H22Z"}),React.createElement("path",{d:"M17,15V9H9V23H23V15Zm-6-4h4v4H11Zm4,10H11V17h4Zm6,0H17V17h4Z"}),React.createElement("path",{d:"M26,28H6a2.0023,2.0023,0,0,1-2-2V6A2.0023,2.0023,0,0,1,6,4H16V6H6V26H26V16h2V26A2.0023,2.0023,0,0,1,26,28Z"}),props.children);});var ContainerSoftware24=/*#__PURE__*/React.forwardRef(function ContainerSoftware24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,12H20V4h8Zm-6-2h4V6H22Z"}),React.createElement("path",{d:"M17,15V9H9V23H23V15Zm-6-4h4v4H11Zm4,10H11V17h4Zm6,0H17V17h4Z"}),React.createElement("path",{d:"M26,28H6a2.0023,2.0023,0,0,1-2-2V6A2.0023,2.0023,0,0,1,6,4H16V6H6V26H26V16h2V26A2.0023,2.0023,0,0,1,26,28Z"}),props.children);});var ContainerSoftware20=/*#__PURE__*/React.forwardRef(function ContainerSoftware20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,12H20V4h8Zm-6-2h4V6H22Z"}),React.createElement("path",{d:"M17,15V9H9V23H23V15Zm-6-4h4v4H11Zm4,10H11V17h4Zm6,0H17V17h4Z"}),React.createElement("path",{d:"M26,28H6a2.0023,2.0023,0,0,1-2-2V6A2.0023,2.0023,0,0,1,6,4H16V6H6V26H26V16h2V26A2.0023,2.0023,0,0,1,26,28Z"}),props.children);});var ContainerSoftware16=/*#__PURE__*/React.forwardRef(function ContainerSoftware16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,12H20V4h8Zm-6-2h4V6H22Z"}),React.createElement("path",{d:"M17,15V9H9V23H23V15Zm-6-4h4v4H11Zm4,10H11V17h4Zm6,0H17V17h4Z"}),React.createElement("path",{d:"M26,28H6a2.0023,2.0023,0,0,1-2-2V6A2.0023,2.0023,0,0,1,6,4H16V6H6V26H26V16h2V26A2.0023,2.0023,0,0,1,26,28Z"}),props.children);});var Contrast32=/*#__PURE__*/React.forwardRef(function Contrast32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.37,11.84a13.6,13.6,0,0,0-1.06-2.51A14.17,14.17,0,0,0,25.9,6.1a14,14,0,1,0,0,19.8,14.17,14.17,0,0,0,2.41-3.23,13.6,13.6,0,0,0,1.06-2.51,14,14,0,0,0,0-8.32ZM4,16A12,12,0,0,1,16,4V28A12,12,0,0,1,4,16Z"}),props.children);});var Contrast24=/*#__PURE__*/React.forwardRef(function Contrast24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.37,11.84a13.6,13.6,0,0,0-1.06-2.51A14.17,14.17,0,0,0,25.9,6.1a14,14,0,1,0,0,19.8,14.17,14.17,0,0,0,2.41-3.23,13.6,13.6,0,0,0,1.06-2.51,14,14,0,0,0,0-8.32ZM4,16A12,12,0,0,1,16,4V28A12,12,0,0,1,4,16Z"}),props.children);});var Contrast20=/*#__PURE__*/React.forwardRef(function Contrast20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.37,11.84a13.6,13.6,0,0,0-1.06-2.51A14.17,14.17,0,0,0,25.9,6.1a14,14,0,1,0,0,19.8,14.17,14.17,0,0,0,2.41-3.23,13.6,13.6,0,0,0,1.06-2.51,14,14,0,0,0,0-8.32ZM4,16A12,12,0,0,1,16,4V28A12,12,0,0,1,4,16Z"}),props.children);});var Contrast16=/*#__PURE__*/React.forwardRef(function Contrast16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.37,11.84a13.6,13.6,0,0,0-1.06-2.51A14.17,14.17,0,0,0,25.9,6.1a14,14,0,1,0,0,19.8,14.17,14.17,0,0,0,2.41-3.23,13.6,13.6,0,0,0,1.06-2.51,14,14,0,0,0,0-8.32ZM4,16A12,12,0,0,1,16,4V28A12,12,0,0,1,4,16Z"}),props.children);});var CopyFile32=/*#__PURE__*/React.forwardRef(function CopyFile32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.4,14.7l-6.1-6.1C21,8.2,20.5,8,20,8h-8c-1.1,0-2,0.9-2,2v18c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V16.1\tC28,15.6,27.8,15.1,27.4,14.7z M20,10l5.9,6H20V10z M12,28V10h6v6c0,1.1,0.9,2,2,2h6l0,10H12z"}),React.createElement("path",{d:"M6,18H4V4c0-1.1,0.9-2,2-2h14v2H6V18z"}),props.children);});var CopyFile24=/*#__PURE__*/React.forwardRef(function CopyFile24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.4,14.7l-6.1-6.1C21,8.2,20.5,8,20,8h-8c-1.1,0-2,0.9-2,2v18c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V16.1\tC28,15.6,27.8,15.1,27.4,14.7z M20,10l5.9,6H20V10z M12,28V10h6v6c0,1.1,0.9,2,2,2h6l0,10H12z"}),React.createElement("path",{d:"M6,18H4V4c0-1.1,0.9-2,2-2h14v2H6V18z"}),props.children);});var CopyFile20=/*#__PURE__*/React.forwardRef(function CopyFile20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.4,14.7l-6.1-6.1C21,8.2,20.5,8,20,8h-8c-1.1,0-2,0.9-2,2v18c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V16.1\tC28,15.6,27.8,15.1,27.4,14.7z M20,10l5.9,6H20V10z M12,28V10h6v6c0,1.1,0.9,2,2,2h6l0,10H12z"}),React.createElement("path",{d:"M6,18H4V4c0-1.1,0.9-2,2-2h14v2H6V18z"}),props.children);});var CopyFile16=/*#__PURE__*/React.forwardRef(function CopyFile16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.4,14.7l-6.1-6.1C21,8.2,20.5,8,20,8h-8c-1.1,0-2,0.9-2,2v18c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V16.1\tC28,15.6,27.8,15.1,27.4,14.7z M20,10l5.9,6H20V10z M12,28V10h6v6c0,1.1,0.9,2,2,2h6l0,10H12z"}),React.createElement("path",{d:"M6,18H4V4c0-1.1,0.9-2,2-2h14v2H6V18z"}),props.children);});var Copy32=/*#__PURE__*/React.forwardRef(function Copy32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,10V28H10V10H28m0-2H10a2,2,0,0,0-2,2V28a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V10a2,2,0,0,0-2-2Z"}),React.createElement("path",{d:"M4,18H2V4A2,2,0,0,1,4,2H18V4H4Z"}),props.children);});var Copy24=/*#__PURE__*/React.forwardRef(function Copy24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,10V28H10V10H28m0-2H10a2,2,0,0,0-2,2V28a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V10a2,2,0,0,0-2-2Z"}),React.createElement("path",{d:"M4,18H2V4A2,2,0,0,1,4,2H18V4H4Z"}),props.children);});var Copy20=/*#__PURE__*/React.forwardRef(function Copy20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,10V28H10V10H28m0-2H10a2,2,0,0,0-2,2V28a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V10a2,2,0,0,0-2-2Z"}),React.createElement("path",{d:"M4,18H2V4A2,2,0,0,1,4,2H18V4H4Z"}),props.children);});var Copy16=/*#__PURE__*/React.forwardRef(function Copy16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,10V28H10V10H28m0-2H10a2,2,0,0,0-2,2V28a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V10a2,2,0,0,0-2-2Z"}),React.createElement("path",{d:"M4,18H2V4A2,2,0,0,1,4,2H18V4H4Z"}),props.children);});var Corn32=/*#__PURE__*/React.forwardRef(function Corn32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,16c-.3374,0-.67.02-1,.0508V16C22,8.115,19.0435,2,16.5,2S11,8.115,11,16v5H6v3a6.0067,6.0067,0,0,0,6,6h3A11.0125,11.0125,0,0,0,26,19V16ZM13,16h2V14H13.0728a25.8942,25.8942,0,0,1,.5654-4H16V8H14.2c.81-2.4058,1.8149-3.7715,2.3-3.9863.66.2919,2.2842,2.7036,3.0654,6.9863H18v2h1.8442A29.1625,29.1625,0,0,1,20,16v.4263A11.0554,11.0554,0,0,0,13.79,21H13ZM12,28a4.0045,4.0045,0,0,1-4-4V23h4.7639A10.9033,10.9033,0,0,0,12,27Zm12-9a9.01,9.01,0,0,1-9,9H14V27a9.01,9.01,0,0,1,9-9h1Z"}),props.children);});var Corn24=/*#__PURE__*/React.forwardRef(function Corn24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,16c-.3374,0-.67.02-1,.0508V16C22,8.115,19.0435,2,16.5,2S11,8.115,11,16v5H6v3a6.0067,6.0067,0,0,0,6,6h3A11.0125,11.0125,0,0,0,26,19V16ZM13,16h2V14H13.0728a25.8942,25.8942,0,0,1,.5654-4H16V8H14.2c.81-2.4058,1.8149-3.7715,2.3-3.9863.66.2919,2.2842,2.7036,3.0654,6.9863H18v2h1.8442A29.1625,29.1625,0,0,1,20,16v.4263A11.0554,11.0554,0,0,0,13.79,21H13ZM12,28a4.0045,4.0045,0,0,1-4-4V23h4.7639A10.9033,10.9033,0,0,0,12,27Zm12-9a9.01,9.01,0,0,1-9,9H14V27a9.01,9.01,0,0,1,9-9h1Z"}),props.children);});var Corn20=/*#__PURE__*/React.forwardRef(function Corn20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,16c-.3374,0-.67.02-1,.0508V16C22,8.115,19.0435,2,16.5,2S11,8.115,11,16v5H6v3a6.0067,6.0067,0,0,0,6,6h3A11.0125,11.0125,0,0,0,26,19V16ZM13,16h2V14H13.0728a25.8942,25.8942,0,0,1,.5654-4H16V8H14.2c.81-2.4058,1.8149-3.7715,2.3-3.9863.66.2919,2.2842,2.7036,3.0654,6.9863H18v2h1.8442A29.1625,29.1625,0,0,1,20,16v.4263A11.0554,11.0554,0,0,0,13.79,21H13ZM12,28a4.0045,4.0045,0,0,1-4-4V23h4.7639A10.9033,10.9033,0,0,0,12,27Zm12-9a9.01,9.01,0,0,1-9,9H14V27a9.01,9.01,0,0,1,9-9h1Z"}),props.children);});var Corn16=/*#__PURE__*/React.forwardRef(function Corn16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,16c-.3374,0-.67.02-1,.0508V16C22,8.115,19.0435,2,16.5,2S11,8.115,11,16v5H6v3a6.0067,6.0067,0,0,0,6,6h3A11.0125,11.0125,0,0,0,26,19V16ZM13,16h2V14H13.0728a25.8942,25.8942,0,0,1,.5654-4H16V8H14.2c.81-2.4058,1.8149-3.7715,2.3-3.9863.66.2919,2.2842,2.7036,3.0654,6.9863H18v2h1.8442A29.1625,29.1625,0,0,1,20,16v.4263A11.0554,11.0554,0,0,0,13.79,21H13ZM12,28a4.0045,4.0045,0,0,1-4-4V23h4.7639A10.9033,10.9033,0,0,0,12,27Zm12-9a9.01,9.01,0,0,1-9,9H14V27a9.01,9.01,0,0,1,9-9h1Z"}),props.children);});var Corner32=/*#__PURE__*/React.forwardRef(function Corner32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H14V6H6v8H9V28h2V14h3V11H28ZM12,12H8V8h4Z"}),props.children);});var Corner24=/*#__PURE__*/React.forwardRef(function Corner24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H14V6H6v8H9V28h2V14h3V11H28ZM12,12H8V8h4Z"}),props.children);});var Corner20=/*#__PURE__*/React.forwardRef(function Corner20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H14V6H6v8H9V28h2V14h3V11H28ZM12,12H8V8h4Z"}),props.children);});var Corner16=/*#__PURE__*/React.forwardRef(function Corner16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,9H14V6H6v8H9V28h2V14h3V11H28ZM12,12H8V8h4Z"}),props.children);});var Course32=/*#__PURE__*/React.forwardRef(function Course32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,30H8a2.0023,2.0023,0,0,1-2-2V4A2.002,2.002,0,0,1,8,2H24a2.0023,2.0023,0,0,1,2,2V20.6182l-5-2.5-5,2.5V4H8V28H24V24h2v4A2.0027,2.0027,0,0,1,24,30ZM21,15.8818l3,1.5V4H18V17.3818Z"}),props.children);});var Course24=/*#__PURE__*/React.forwardRef(function Course24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,30H8a2.0023,2.0023,0,0,1-2-2V4A2.002,2.002,0,0,1,8,2H24a2.0023,2.0023,0,0,1,2,2V20.6182l-5-2.5-5,2.5V4H8V28H24V24h2v4A2.0027,2.0027,0,0,1,24,30ZM21,15.8818l3,1.5V4H18V17.3818Z"}),props.children);});var Course20=/*#__PURE__*/React.forwardRef(function Course20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,30H8a2.0023,2.0023,0,0,1-2-2V4A2.002,2.002,0,0,1,8,2H24a2.0023,2.0023,0,0,1,2,2V20.6182l-5-2.5-5,2.5V4H8V28H24V24h2v4A2.0027,2.0027,0,0,1,24,30ZM21,15.8818l3,1.5V4H18V17.3818Z"}),props.children);});var Course16=/*#__PURE__*/React.forwardRef(function Course16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,30H8a2.0023,2.0023,0,0,1-2-2V4A2.002,2.002,0,0,1,8,2H24a2.0023,2.0023,0,0,1,2,2V20.6182l-5-2.5-5,2.5V4H8V28H24V24h2v4A2.0027,2.0027,0,0,1,24,30ZM21,15.8818l3,1.5V4H18V17.3818Z"}),props.children);});var Covariate32=/*#__PURE__*/React.forwardRef(function Covariate32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"8",cy:"16",r:"2"}),React.createElement("circle",{cx:"14",cy:"8",r:"2"}),React.createElement("circle",{cx:"28",cy:"12",r:"2"}),React.createElement("circle",{cx:"21",cy:"18",r:"2"}),React.createElement("path",{d:"M30,3.4141,28.5859,2,4,26.5859V2H2V28a2,2,0,0,0,2,2H30V28H5.4141ZM4,28Z"}),props.children);});var Covariate24=/*#__PURE__*/React.forwardRef(function Covariate24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"8",cy:"16",r:"2"}),React.createElement("circle",{cx:"14",cy:"8",r:"2"}),React.createElement("circle",{cx:"28",cy:"12",r:"2"}),React.createElement("circle",{cx:"21",cy:"18",r:"2"}),React.createElement("path",{d:"M30,3.4141,28.5859,2,4,26.5859V2H2V28a2,2,0,0,0,2,2H30V28H5.4141ZM4,28Z"}),props.children);});var Covariate20=/*#__PURE__*/React.forwardRef(function Covariate20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"8",cy:"16",r:"2"}),React.createElement("circle",{cx:"14",cy:"8",r:"2"}),React.createElement("circle",{cx:"28",cy:"12",r:"2"}),React.createElement("circle",{cx:"21",cy:"18",r:"2"}),React.createElement("path",{d:"M30,3.4141,28.5859,2,4,26.5859V2H2V28a2,2,0,0,0,2,2H30V28H5.4141ZM4,28Z"}),props.children);});var Covariate16=/*#__PURE__*/React.forwardRef(function Covariate16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"8",cy:"16",r:"2"}),React.createElement("circle",{cx:"14",cy:"8",r:"2"}),React.createElement("circle",{cx:"28",cy:"12",r:"2"}),React.createElement("circle",{cx:"21",cy:"18",r:"2"}),React.createElement("path",{d:"M30,3.4141,28.5859,2,4,26.5859V2H2V28a2,2,0,0,0,2,2H30V28H5.4141ZM4,28Z"}),props.children);});var Credentials32=/*#__PURE__*/React.forwardRef(function Credentials32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,22a4,4,0,1,0-4-4A4,4,0,0,0,16,22Zm0-6a2,2,0,1,1-2,2A2,2,0,0,1,16,16Z"}),React.createElement("rect",{width:"4",height:"2",x:"14",y:"6"}),React.createElement("path",{d:"M24,2H8A2.002,2.002,0,0,0,6,4V28a2.0023,2.0023,0,0,0,2,2H24a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,24,2ZM20,28H12V26a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1Zm2,0V26a3,3,0,0,0-3-3H13a3,3,0,0,0-3,3v2H8V4H24V28Z"}),props.children);});var Credentials24=/*#__PURE__*/React.forwardRef(function Credentials24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,22a4,4,0,1,0-4-4A4,4,0,0,0,16,22Zm0-6a2,2,0,1,1-2,2A2,2,0,0,1,16,16Z"}),React.createElement("rect",{width:"4",height:"2",x:"14",y:"6"}),React.createElement("path",{d:"M24,2H8A2.002,2.002,0,0,0,6,4V28a2.0023,2.0023,0,0,0,2,2H24a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,24,2ZM20,28H12V26a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1Zm2,0V26a3,3,0,0,0-3-3H13a3,3,0,0,0-3,3v2H8V4H24V28Z"}),props.children);});var Credentials20=/*#__PURE__*/React.forwardRef(function Credentials20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,22a4,4,0,1,0-4-4A4,4,0,0,0,16,22Zm0-6a2,2,0,1,1-2,2A2,2,0,0,1,16,16Z"}),React.createElement("rect",{width:"4",height:"2",x:"14",y:"6"}),React.createElement("path",{d:"M24,2H8A2.002,2.002,0,0,0,6,4V28a2.0023,2.0023,0,0,0,2,2H24a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,24,2ZM20,28H12V26a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1Zm2,0V26a3,3,0,0,0-3-3H13a3,3,0,0,0-3,3v2H8V4H24V28Z"}),props.children);});var Credentials16=/*#__PURE__*/React.forwardRef(function Credentials16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,22a4,4,0,1,0-4-4A4,4,0,0,0,16,22Zm0-6a2,2,0,1,1-2,2A2,2,0,0,1,16,16Z"}),React.createElement("rect",{width:"4",height:"2",x:"14",y:"6"}),React.createElement("path",{d:"M24,2H8A2.002,2.002,0,0,0,6,4V28a2.0023,2.0023,0,0,0,2,2H24a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,24,2ZM20,28H12V26a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1Zm2,0V26a3,3,0,0,0-3-3H13a3,3,0,0,0-3,3v2H8V4H24V28Z"}),props.children);});var Crop32=/*#__PURE__*/React.forwardRef(function Crop32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,20H23V9H12V7H23a2,2,0,0,1,2,2Z"}),React.createElement("path",{d:"M9,23V2H7V7H2V9H7V23a2,2,0,0,0,2,2H23v5h2V25h5V23Z"}),props.children);});var Crop24=/*#__PURE__*/React.forwardRef(function Crop24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,20H23V9H12V7H23a2,2,0,0,1,2,2Z"}),React.createElement("path",{d:"M9,23V2H7V7H2V9H7V23a2,2,0,0,0,2,2H23v5h2V25h5V23Z"}),props.children);});var Crop20=/*#__PURE__*/React.forwardRef(function Crop20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,20H23V9H12V7H23a2,2,0,0,1,2,2Z"}),React.createElement("path",{d:"M9,23V2H7V7H2V9H7V23a2,2,0,0,0,2,2H23v5h2V25h5V23Z"}),props.children);});var Crop16=/*#__PURE__*/React.forwardRef(function Crop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,20H23V9H12V7H23a2,2,0,0,1,2,2Z"}),React.createElement("path",{d:"M9,23V2H7V7H2V9H7V23a2,2,0,0,0,2,2H23v5h2V25h5V23Z"}),props.children);});var Cursor_132=/*#__PURE__*/React.forwardRef(function Cursor_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,28a1,1,0,0,1-.71-.29l-6.13-6.14-3.33,5a1,1,0,0,1-1,.44,1,1,0,0,1-.81-.7l-6-20A1,1,0,0,1,6.29,5l20,6a1,1,0,0,1,.7.81,1,1,0,0,1-.44,1l-5,3.33,6.14,6.13a1,1,0,0,1,0,1.42l-4,4A1,1,0,0,1,23,28Zm0-2.41L25.59,23l-7.16-7.15,5.25-3.5L7.49,7.49l4.86,16.19,3.5-5.25Z"}),props.children);});var Cursor_124=/*#__PURE__*/React.forwardRef(function Cursor_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,28a1,1,0,0,1-.71-.29l-6.13-6.14-3.33,5a1,1,0,0,1-1,.44,1,1,0,0,1-.81-.7l-6-20A1,1,0,0,1,6.29,5l20,6a1,1,0,0,1,.7.81,1,1,0,0,1-.44,1l-5,3.33,6.14,6.13a1,1,0,0,1,0,1.42l-4,4A1,1,0,0,1,23,28Zm0-2.41L25.59,23l-7.16-7.15,5.25-3.5L7.49,7.49l4.86,16.19,3.5-5.25Z"}),props.children);});var Cursor_120=/*#__PURE__*/React.forwardRef(function Cursor_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,28a1,1,0,0,1-.71-.29l-6.13-6.14-3.33,5a1,1,0,0,1-1,.44,1,1,0,0,1-.81-.7l-6-20A1,1,0,0,1,6.29,5l20,6a1,1,0,0,1,.7.81,1,1,0,0,1-.44,1l-5,3.33,6.14,6.13a1,1,0,0,1,0,1.42l-4,4A1,1,0,0,1,23,28Zm0-2.41L25.59,23l-7.16-7.15,5.25-3.5L7.49,7.49l4.86,16.19,3.5-5.25Z"}),props.children);});var Cursor_116=/*#__PURE__*/React.forwardRef(function Cursor_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,28a1,1,0,0,1-.71-.29l-6.13-6.14-3.33,5a1,1,0,0,1-1,.44,1,1,0,0,1-.81-.7l-6-20A1,1,0,0,1,6.29,5l20,6a1,1,0,0,1,.7.81,1,1,0,0,1-.44,1l-5,3.33,6.14,6.13a1,1,0,0,1,0,1.42l-4,4A1,1,0,0,1,23,28Zm0-2.41L25.59,23l-7.16-7.15,5.25-3.5L7.49,7.49l4.86,16.19,3.5-5.25Z"}),props.children);});var Cursor_232=/*#__PURE__*/React.forwardRef(function Cursor_232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.34,12.06l-22-8A1,1,0,0,0,4.06,5.34l8,22A1,1,0,0,0,13,28h0a1,1,0,0,0,.93-.63l3.84-9.6,9.6-3.84a1,1,0,0,0,0-1.87Zm-10.71,4h0l-.4.16-.16.4h0L13,24.2,6.67,6.67,24.2,13Z"}),props.children);});var Cursor_224=/*#__PURE__*/React.forwardRef(function Cursor_224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.34,12.06l-22-8A1,1,0,0,0,4.06,5.34l8,22A1,1,0,0,0,13,28h0a1,1,0,0,0,.93-.63l3.84-9.6,9.6-3.84a1,1,0,0,0,0-1.87Zm-10.71,4h0l-.4.16-.16.4h0L13,24.2,6.67,6.67,24.2,13Z"}),props.children);});var Cursor_220=/*#__PURE__*/React.forwardRef(function Cursor_220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.34,12.06l-22-8A1,1,0,0,0,4.06,5.34l8,22A1,1,0,0,0,13,28h0a1,1,0,0,0,.93-.63l3.84-9.6,9.6-3.84a1,1,0,0,0,0-1.87Zm-10.71,4h0l-.4.16-.16.4h0L13,24.2,6.67,6.67,24.2,13Z"}),props.children);});var Cursor_216=/*#__PURE__*/React.forwardRef(function Cursor_216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27.34,12.06l-22-8A1,1,0,0,0,4.06,5.34l8,22A1,1,0,0,0,13,28h0a1,1,0,0,0,.93-.63l3.84-9.6,9.6-3.84a1,1,0,0,0,0-1.87Zm-10.71,4h0l-.4.16-.16.4h0L13,24.2,6.67,6.67,24.2,13Z"}),props.children);});var Cut32=/*#__PURE__*/React.forwardRef(function Cut32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.5,19.63,20.24,16l6.26-3.63a5,5,0,0,0-1.21-9.2A5.19,5.19,0,0,0,24,3a5,5,0,0,0-4.33,7.53,5,5,0,0,0,2.39,2.1l-3.82,2.21L4,6.6,3,8.34,16.24,16,3,23.68l1,1.74,14.24-8.26,3.82,2.21a5,5,0,0,0-2.39,2.1A5,5,0,0,0,24,29a5.19,5.19,0,0,0,1.29-.17,5,5,0,0,0,1.21-9.2ZM21.4,9.53a3,3,0,0,1,1.1-4.12,3,3,0,0,1,4.1,1.11,3,3,0,0,1-1.1,4.11h0A3,3,0,0,1,21.4,9.53Zm5.2,16a3,3,0,0,1-4.1,1.11,3,3,0,0,1-1.1-4.12,3,3,0,0,1,4.1-1.1h0A3,3,0,0,1,26.6,25.48Z"}),props.children);});var Cut24=/*#__PURE__*/React.forwardRef(function Cut24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.5,19.63,20.24,16l6.26-3.63a5,5,0,0,0-1.21-9.2A5.19,5.19,0,0,0,24,3a5,5,0,0,0-4.33,7.53,5,5,0,0,0,2.39,2.1l-3.82,2.21L4,6.6,3,8.34,16.24,16,3,23.68l1,1.74,14.24-8.26,3.82,2.21a5,5,0,0,0-2.39,2.1A5,5,0,0,0,24,29a5.19,5.19,0,0,0,1.29-.17,5,5,0,0,0,1.21-9.2ZM21.4,9.53a3,3,0,0,1,1.1-4.12,3,3,0,0,1,4.1,1.11,3,3,0,0,1-1.1,4.11h0A3,3,0,0,1,21.4,9.53Zm5.2,16a3,3,0,0,1-4.1,1.11,3,3,0,0,1-1.1-4.12,3,3,0,0,1,4.1-1.1h0A3,3,0,0,1,26.6,25.48Z"}),props.children);});var Cut20=/*#__PURE__*/React.forwardRef(function Cut20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.5,19.63,20.24,16l6.26-3.63a5,5,0,0,0-1.21-9.2A5.19,5.19,0,0,0,24,3a5,5,0,0,0-4.33,7.53,5,5,0,0,0,2.39,2.1l-3.82,2.21L4,6.6,3,8.34,16.24,16,3,23.68l1,1.74,14.24-8.26,3.82,2.21a5,5,0,0,0-2.39,2.1A5,5,0,0,0,24,29a5.19,5.19,0,0,0,1.29-.17,5,5,0,0,0,1.21-9.2ZM21.4,9.53a3,3,0,0,1,1.1-4.12,3,3,0,0,1,4.1,1.11,3,3,0,0,1-1.1,4.11h0A3,3,0,0,1,21.4,9.53Zm5.2,16a3,3,0,0,1-4.1,1.11,3,3,0,0,1-1.1-4.12,3,3,0,0,1,4.1-1.1h0A3,3,0,0,1,26.6,25.48Z"}),props.children);});var Cut16=/*#__PURE__*/React.forwardRef(function Cut16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26.5,19.63,20.24,16l6.26-3.63a5,5,0,0,0-1.21-9.2A5.19,5.19,0,0,0,24,3a5,5,0,0,0-4.33,7.53,5,5,0,0,0,2.39,2.1l-3.82,2.21L4,6.6,3,8.34,16.24,16,3,23.68l1,1.74,14.24-8.26,3.82,2.21a5,5,0,0,0-2.39,2.1A5,5,0,0,0,24,29a5.19,5.19,0,0,0,1.29-.17,5,5,0,0,0,1.21-9.2ZM21.4,9.53a3,3,0,0,1,1.1-4.12,3,3,0,0,1,4.1,1.11,3,3,0,0,1-1.1,4.11h0A3,3,0,0,1,21.4,9.53Zm5.2,16a3,3,0,0,1-4.1,1.11,3,3,0,0,1-1.1-4.12,3,3,0,0,1,4.1-1.1h0A3,3,0,0,1,26.6,25.48Z"}),props.children);});var Cyclist32=/*#__PURE__*/React.forwardRef(function Cyclist32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,30a6,6,0,1,1,6-6A6.0069,6.0069,0,0,1,25,30Zm0-10a4,4,0,1,0,4,4A4.0045,4.0045,0,0,0,25,20Z"}),React.createElement("path",{d:"M7,30a6,6,0,1,1,6-6A6.0069,6.0069,0,0,1,7,30ZM7,20a4,4,0,1,0,4,4A4.0045,4.0045,0,0,0,7,20Z"}),React.createElement("path",{d:"M17,27H15V20.4139L9.5849,15a2.003,2.003,0,0,1,0-2.8292l4.5859-4.5859a2.0024,2.0024,0,0,1,2.8286,0L21.414,12H27v1.9993L20.5853,14l-5-5L11,13.5849l6,6Z"}),React.createElement("path",{d:"M21.5,8A3.5,3.5,0,1,1,25,4.5,3.5042,3.5042,0,0,1,21.5,8Zm0-5A1.5,1.5,0,1,0,23,4.5,1.5017,1.5017,0,0,0,21.5,3Z"}),props.children);});var Cyclist24=/*#__PURE__*/React.forwardRef(function Cyclist24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,30a6,6,0,1,1,6-6A6.0069,6.0069,0,0,1,25,30Zm0-10a4,4,0,1,0,4,4A4.0045,4.0045,0,0,0,25,20Z"}),React.createElement("path",{d:"M7,30a6,6,0,1,1,6-6A6.0069,6.0069,0,0,1,7,30ZM7,20a4,4,0,1,0,4,4A4.0045,4.0045,0,0,0,7,20Z"}),React.createElement("path",{d:"M17,27H15V20.4139L9.5849,15a2.003,2.003,0,0,1,0-2.8292l4.5859-4.5859a2.0024,2.0024,0,0,1,2.8286,0L21.414,12H27v1.9993L20.5853,14l-5-5L11,13.5849l6,6Z"}),React.createElement("path",{d:"M21.5,8A3.5,3.5,0,1,1,25,4.5,3.5042,3.5042,0,0,1,21.5,8Zm0-5A1.5,1.5,0,1,0,23,4.5,1.5017,1.5017,0,0,0,21.5,3Z"}),props.children);});var Cyclist20=/*#__PURE__*/React.forwardRef(function Cyclist20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,30a6,6,0,1,1,6-6A6.0069,6.0069,0,0,1,25,30Zm0-10a4,4,0,1,0,4,4A4.0045,4.0045,0,0,0,25,20Z"}),React.createElement("path",{d:"M7,30a6,6,0,1,1,6-6A6.0069,6.0069,0,0,1,7,30ZM7,20a4,4,0,1,0,4,4A4.0045,4.0045,0,0,0,7,20Z"}),React.createElement("path",{d:"M17,27H15V20.4139L9.5849,15a2.003,2.003,0,0,1,0-2.8292l4.5859-4.5859a2.0024,2.0024,0,0,1,2.8286,0L21.414,12H27v1.9993L20.5853,14l-5-5L11,13.5849l6,6Z"}),React.createElement("path",{d:"M21.5,8A3.5,3.5,0,1,1,25,4.5,3.5042,3.5042,0,0,1,21.5,8Zm0-5A1.5,1.5,0,1,0,23,4.5,1.5017,1.5017,0,0,0,21.5,3Z"}),props.children);});var Cyclist16=/*#__PURE__*/React.forwardRef(function Cyclist16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,30a6,6,0,1,1,6-6A6.0069,6.0069,0,0,1,25,30Zm0-10a4,4,0,1,0,4,4A4.0045,4.0045,0,0,0,25,20Z"}),React.createElement("path",{d:"M7,30a6,6,0,1,1,6-6A6.0069,6.0069,0,0,1,7,30ZM7,20a4,4,0,1,0,4,4A4.0045,4.0045,0,0,0,7,20Z"}),React.createElement("path",{d:"M17,27H15V20.4139L9.5849,15a2.003,2.003,0,0,1,0-2.8292l4.5859-4.5859a2.0024,2.0024,0,0,1,2.8286,0L21.414,12H27v1.9993L20.5853,14l-5-5L11,13.5849l6,6Z"}),React.createElement("path",{d:"M21.5,8A3.5,3.5,0,1,1,25,4.5,3.5042,3.5042,0,0,1,21.5,8Zm0-5A1.5,1.5,0,1,0,23,4.5,1.5017,1.5017,0,0,0,21.5,3Z"}),props.children);});var Dashboard32=/*#__PURE__*/React.forwardRef(function Dashboard32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"5",x:"24",y:"21"}),React.createElement("rect",{width:"2",height:"10",x:"20",y:"16"}),React.createElement("path",{d:"M11,26a5.0059,5.0059,0,0,1-5-5H8a3,3,0,1,0,3-3V16a5,5,0,0,1,0,10Z"}),React.createElement("path",{d:"M28,2H4A2.002,2.002,0,0,0,2,4V28a2.0023,2.0023,0,0,0,2,2H28a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,28,2Zm0,9H14V4H28ZM12,4v7H4V4ZM4,28V13H28.0007l.0013,15Z"}),props.children);});var Dashboard24=/*#__PURE__*/React.forwardRef(function Dashboard24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"5",x:"24",y:"21"}),React.createElement("rect",{width:"2",height:"10",x:"20",y:"16"}),React.createElement("path",{d:"M11,26a5.0059,5.0059,0,0,1-5-5H8a3,3,0,1,0,3-3V16a5,5,0,0,1,0,10Z"}),React.createElement("path",{d:"M28,2H4A2.002,2.002,0,0,0,2,4V28a2.0023,2.0023,0,0,0,2,2H28a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,28,2Zm0,9H14V4H28ZM12,4v7H4V4ZM4,28V13H28.0007l.0013,15Z"}),props.children);});var Dashboard20=/*#__PURE__*/React.forwardRef(function Dashboard20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"5",x:"24",y:"21"}),React.createElement("rect",{width:"2",height:"10",x:"20",y:"16"}),React.createElement("path",{d:"M11,26a5.0059,5.0059,0,0,1-5-5H8a3,3,0,1,0,3-3V16a5,5,0,0,1,0,10Z"}),React.createElement("path",{d:"M28,2H4A2.002,2.002,0,0,0,2,4V28a2.0023,2.0023,0,0,0,2,2H28a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,28,2Zm0,9H14V4H28ZM12,4v7H4V4ZM4,28V13H28.0007l.0013,15Z"}),props.children);});var Dashboard16=/*#__PURE__*/React.forwardRef(function Dashboard16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"5",x:"24",y:"21"}),React.createElement("rect",{width:"2",height:"10",x:"20",y:"16"}),React.createElement("path",{d:"M11,26a5.0059,5.0059,0,0,1-5-5H8a3,3,0,1,0,3-3V16a5,5,0,0,1,0,10Z"}),React.createElement("path",{d:"M28,2H4A2.002,2.002,0,0,0,2,4V28a2.0023,2.0023,0,0,0,2,2H28a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,28,2Zm0,9H14V4H28ZM12,4v7H4V4ZM4,28V13H28.0007l.0013,15Z"}),props.children);});var Data_132=/*#__PURE__*/React.forwardRef(function Data_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"13",height:"2",x:"15",y:"6"}),React.createElement("rect",{width:"13",height:"2",x:"15",y:"24"}),React.createElement("rect",{width:"13",height:"2",x:"4",y:"15"}),React.createElement("path",{d:"M7,11a4,4,0,1,1,4-4A4,4,0,0,1,7,11ZM7,5A2,2,0,1,0,9,7,2,2,0,0,0,7,5Z"}),React.createElement("path",{d:"M7,29a4,4,0,1,1,4-4A4,4,0,0,1,7,29Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,7,23Z"}),React.createElement("path",{d:"M25,20a4,4,0,1,1,4-4A4,4,0,0,1,25,20Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,25,14Z"}),props.children);});var Data_124=/*#__PURE__*/React.forwardRef(function Data_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"13",height:"2",x:"15",y:"6"}),React.createElement("rect",{width:"13",height:"2",x:"15",y:"24"}),React.createElement("rect",{width:"13",height:"2",x:"4",y:"15"}),React.createElement("path",{d:"M7,11a4,4,0,1,1,4-4A4,4,0,0,1,7,11ZM7,5A2,2,0,1,0,9,7,2,2,0,0,0,7,5Z"}),React.createElement("path",{d:"M7,29a4,4,0,1,1,4-4A4,4,0,0,1,7,29Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,7,23Z"}),React.createElement("path",{d:"M25,20a4,4,0,1,1,4-4A4,4,0,0,1,25,20Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,25,14Z"}),props.children);});var Data_120=/*#__PURE__*/React.forwardRef(function Data_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"13",height:"2",x:"15",y:"6"}),React.createElement("rect",{width:"13",height:"2",x:"15",y:"24"}),React.createElement("rect",{width:"13",height:"2",x:"4",y:"15"}),React.createElement("path",{d:"M7,11a4,4,0,1,1,4-4A4,4,0,0,1,7,11ZM7,5A2,2,0,1,0,9,7,2,2,0,0,0,7,5Z"}),React.createElement("path",{d:"M7,29a4,4,0,1,1,4-4A4,4,0,0,1,7,29Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,7,23Z"}),React.createElement("path",{d:"M25,20a4,4,0,1,1,4-4A4,4,0,0,1,25,20Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,25,14Z"}),props.children);});var Data_116=/*#__PURE__*/React.forwardRef(function Data_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"13",height:"2",x:"15",y:"6"}),React.createElement("rect",{width:"13",height:"2",x:"15",y:"24"}),React.createElement("rect",{width:"13",height:"2",x:"4",y:"15"}),React.createElement("path",{d:"M7,11a4,4,0,1,1,4-4A4,4,0,0,1,7,11ZM7,5A2,2,0,1,0,9,7,2,2,0,0,0,7,5Z"}),React.createElement("path",{d:"M7,29a4,4,0,1,1,4-4A4,4,0,0,1,7,29Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,7,23Z"}),React.createElement("path",{d:"M25,20a4,4,0,1,1,4-4A4,4,0,0,1,25,20Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,25,14Z"}),props.children);});var Data_232=/*#__PURE__*/React.forwardRef(function Data_232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"11",height:"2",x:"4",y:"6"}),React.createElement("rect",{width:"10",height:"2",x:"18",y:"6"}),React.createElement("rect",{width:"7",height:"2",x:"21",y:"12"}),React.createElement("rect",{width:"7",height:"2",x:"11",y:"12"}),React.createElement("rect",{width:"4",height:"2",x:"4",y:"12"}),React.createElement("rect",{width:"24",height:"2",x:"4",y:"18"}),React.createElement("rect",{width:"17",height:"2",x:"4",y:"24"}),React.createElement("rect",{width:"4",height:"2",x:"24",y:"24"}),props.children);});var Data_224=/*#__PURE__*/React.forwardRef(function Data_224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"11",height:"2",x:"4",y:"6"}),React.createElement("rect",{width:"10",height:"2",x:"18",y:"6"}),React.createElement("rect",{width:"7",height:"2",x:"21",y:"12"}),React.createElement("rect",{width:"7",height:"2",x:"11",y:"12"}),React.createElement("rect",{width:"4",height:"2",x:"4",y:"12"}),React.createElement("rect",{width:"24",height:"2",x:"4",y:"18"}),React.createElement("rect",{width:"17",height:"2",x:"4",y:"24"}),React.createElement("rect",{width:"4",height:"2",x:"24",y:"24"}),props.children);});var Data_220=/*#__PURE__*/React.forwardRef(function Data_220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"11",height:"2",x:"4",y:"6"}),React.createElement("rect",{width:"10",height:"2",x:"18",y:"6"}),React.createElement("rect",{width:"7",height:"2",x:"21",y:"12"}),React.createElement("rect",{width:"7",height:"2",x:"11",y:"12"}),React.createElement("rect",{width:"4",height:"2",x:"4",y:"12"}),React.createElement("rect",{width:"24",height:"2",x:"4",y:"18"}),React.createElement("rect",{width:"17",height:"2",x:"4",y:"24"}),React.createElement("rect",{width:"4",height:"2",x:"24",y:"24"}),props.children);});var Data_216=/*#__PURE__*/React.forwardRef(function Data_216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"11",height:"2",x:"4",y:"6"}),React.createElement("rect",{width:"10",height:"2",x:"18",y:"6"}),React.createElement("rect",{width:"7",height:"2",x:"21",y:"12"}),React.createElement("rect",{width:"7",height:"2",x:"11",y:"12"}),React.createElement("rect",{width:"4",height:"2",x:"4",y:"12"}),React.createElement("rect",{width:"24",height:"2",x:"4",y:"18"}),React.createElement("rect",{width:"17",height:"2",x:"4",y:"24"}),React.createElement("rect",{width:"4",height:"2",x:"24",y:"24"}),props.children);});var DataBase32=/*#__PURE__*/React.forwardRef(function DataBase32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,3H8A2,2,0,0,0,6,5V27a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V5A2,2,0,0,0,24,3Zm0,2v6H8V5ZM8,19V13H24v6Zm0,8V21H24v6Z"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),props.children);});var DataBase24=/*#__PURE__*/React.forwardRef(function DataBase24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,3H8A2,2,0,0,0,6,5V27a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V5A2,2,0,0,0,24,3Zm0,2v6H8V5ZM8,19V13H24v6Zm0,8V21H24v6Z"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),props.children);});var DataBase20=/*#__PURE__*/React.forwardRef(function DataBase20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,3H8A2,2,0,0,0,6,5V27a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V5A2,2,0,0,0,24,3Zm0,2v6H8V5ZM8,19V13H24v6Zm0,8V21H24v6Z"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),props.children);});var DataBase16=/*#__PURE__*/React.forwardRef(function DataBase16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,3H8A2,2,0,0,0,6,5V27a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V5A2,2,0,0,0,24,3Zm0,2v6H8V5ZM8,19V13H24v6Zm0,8V21H24v6Z"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),props.children);});var DataCheck32=/*#__PURE__*/React.forwardRef(function DataCheck32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 27.18 20.41 24.59 19 26 23 30 30 23 28.59 21.59 23 27.18"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24,3H8A2,2,0,0,0,6,5V27a2,2,0,0,0,2,2h8V27H8V21H26V5A2,2,0,0,0,24,3Zm0,16H8V13H24Zm0-8H8V5H24Z"}),props.children);});var DataCheck24=/*#__PURE__*/React.forwardRef(function DataCheck24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 27.18 20.41 24.59 19 26 23 30 30 23 28.59 21.59 23 27.18"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24,3H8A2,2,0,0,0,6,5V27a2,2,0,0,0,2,2h8V27H8V21H26V5A2,2,0,0,0,24,3Zm0,16H8V13H24Zm0-8H8V5H24Z"}),props.children);});var DataCheck20=/*#__PURE__*/React.forwardRef(function DataCheck20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 27.18 20.41 24.59 19 26 23 30 30 23 28.59 21.59 23 27.18"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24,3H8A2,2,0,0,0,6,5V27a2,2,0,0,0,2,2h8V27H8V21H26V5A2,2,0,0,0,24,3Zm0,16H8V13H24Zm0-8H8V5H24Z"}),props.children);});var DataCheck16=/*#__PURE__*/React.forwardRef(function DataCheck16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"23 27.18 20.41 24.59 19 26 23 30 30 23 28.59 21.59 23 27.18"}),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24,3H8A2,2,0,0,0,6,5V27a2,2,0,0,0,2,2h8V27H8V21H26V5A2,2,0,0,0,24,3Zm0,16H8V13H24Zm0-8H8V5H24Z"}),props.children);});var DataConnected32=/*#__PURE__*/React.forwardRef(function DataConnected32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 30 24 30 24 28 28 28 28 4 24 4 24 2 30 2 30 30"}),React.createElement("path",{d:"M24.91,19.59a4.51,4.51,0,0,0-2.66-3.24,4.55,4.55,0,0,0-3.5,0,4.94,4.94,0,0,0-.64.35L15.3,13.89a4.53,4.53,0,1,0-1.41,1.41l2.81,2.81a4.48,4.48,0,0,0-.61,3.3,4.51,4.51,0,0,0,2.66,3.24,4.55,4.55,0,0,0,3.5,0,4.51,4.51,0,0,0,2.66-3.24,4.65,4.65,0,0,0,0-1.82ZM11.5,14A2.5,2.5,0,1,1,14,11.5,2.5,2.5,0,0,1,11.5,14Z"}),React.createElement("polygon",{points:"8 30 2 30 2 2 8 2 8 4 4 4 4 28 8 28 8 30"}),props.children);});var DataConnected24=/*#__PURE__*/React.forwardRef(function DataConnected24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 30 24 30 24 28 28 28 28 4 24 4 24 2 30 2 30 30"}),React.createElement("path",{d:"M24.91,19.59a4.51,4.51,0,0,0-2.66-3.24,4.55,4.55,0,0,0-3.5,0,4.94,4.94,0,0,0-.64.35L15.3,13.89a4.53,4.53,0,1,0-1.41,1.41l2.81,2.81a4.48,4.48,0,0,0-.61,3.3,4.51,4.51,0,0,0,2.66,3.24,4.55,4.55,0,0,0,3.5,0,4.51,4.51,0,0,0,2.66-3.24,4.65,4.65,0,0,0,0-1.82ZM11.5,14A2.5,2.5,0,1,1,14,11.5,2.5,2.5,0,0,1,11.5,14Z"}),React.createElement("polygon",{points:"8 30 2 30 2 2 8 2 8 4 4 4 4 28 8 28 8 30"}),props.children);});var DataConnected20=/*#__PURE__*/React.forwardRef(function DataConnected20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 30 24 30 24 28 28 28 28 4 24 4 24 2 30 2 30 30"}),React.createElement("path",{d:"M24.91,19.59a4.51,4.51,0,0,0-2.66-3.24,4.55,4.55,0,0,0-3.5,0,4.94,4.94,0,0,0-.64.35L15.3,13.89a4.53,4.53,0,1,0-1.41,1.41l2.81,2.81a4.48,4.48,0,0,0-.61,3.3,4.51,4.51,0,0,0,2.66,3.24,4.55,4.55,0,0,0,3.5,0,4.51,4.51,0,0,0,2.66-3.24,4.65,4.65,0,0,0,0-1.82ZM11.5,14A2.5,2.5,0,1,1,14,11.5,2.5,2.5,0,0,1,11.5,14Z"}),React.createElement("polygon",{points:"8 30 2 30 2 2 8 2 8 4 4 4 4 28 8 28 8 30"}),props.children);});var DataConnected16=/*#__PURE__*/React.forwardRef(function DataConnected16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 30 24 30 24 28 28 28 28 4 24 4 24 2 30 2 30 30"}),React.createElement("path",{d:"M24.91,19.59a4.51,4.51,0,0,0-2.66-3.24,4.55,4.55,0,0,0-3.5,0,4.94,4.94,0,0,0-.64.35L15.3,13.89a4.53,4.53,0,1,0-1.41,1.41l2.81,2.81a4.48,4.48,0,0,0-.61,3.3,4.51,4.51,0,0,0,2.66,3.24,4.55,4.55,0,0,0,3.5,0,4.51,4.51,0,0,0,2.66-3.24,4.65,4.65,0,0,0,0-1.82ZM11.5,14A2.5,2.5,0,1,1,14,11.5,2.5,2.5,0,0,1,11.5,14Z"}),React.createElement("polygon",{points:"8 30 2 30 2 2 8 2 8 4 4 4 4 28 8 28 8 30"}),props.children);});var DataError32=/*#__PURE__*/React.forwardRef(function DataError32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24,3H8A2,2,0,0,0,6,5V27a2,2,0,0,0,2,2h8V27H8V21H26V5A2,2,0,0,0,24,3Zm0,16H8V13H24Zm0-8H8V5H24Z"}),React.createElement("polygon",{points:"29.24 29.58 26.41 26.75 29.24 23.92 27.83 22.51 25 25.33 22.17 22.51 20.76 23.92 23.59 26.75 20.76 29.58 22.17 30.99 25 28.16 27.83 30.99 29.24 29.58"}),props.children);});var DataError24=/*#__PURE__*/React.forwardRef(function DataError24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24,3H8A2,2,0,0,0,6,5V27a2,2,0,0,0,2,2h8V27H8V21H26V5A2,2,0,0,0,24,3Zm0,16H8V13H24Zm0-8H8V5H24Z"}),React.createElement("polygon",{points:"29.24 29.58 26.41 26.75 29.24 23.92 27.83 22.51 25 25.33 22.17 22.51 20.76 23.92 23.59 26.75 20.76 29.58 22.17 30.99 25 28.16 27.83 30.99 29.24 29.58"}),props.children);});var DataError20=/*#__PURE__*/React.forwardRef(function DataError20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24,3H8A2,2,0,0,0,6,5V27a2,2,0,0,0,2,2h8V27H8V21H26V5A2,2,0,0,0,24,3Zm0,16H8V13H24Zm0-8H8V5H24Z"}),React.createElement("polygon",{points:"29.24 29.58 26.41 26.75 29.24 23.92 27.83 22.51 25 25.33 22.17 22.51 20.76 23.92 23.59 26.75 20.76 29.58 22.17 30.99 25 28.16 27.83 30.99 29.24 29.58"}),props.children);});var DataError16=/*#__PURE__*/React.forwardRef(function DataError16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"11",cy:"8",r:"1"}),React.createElement("circle",{cx:"11",cy:"16",r:"1"}),React.createElement("circle",{cx:"11",cy:"24",r:"1"}),React.createElement("path",{d:"M24,3H8A2,2,0,0,0,6,5V27a2,2,0,0,0,2,2h8V27H8V21H26V5A2,2,0,0,0,24,3Zm0,16H8V13H24Zm0-8H8V5H24Z"}),React.createElement("polygon",{points:"29.24 29.58 26.41 26.75 29.24 23.92 27.83 22.51 25 25.33 22.17 22.51 20.76 23.92 23.59 26.75 20.76 29.58 22.17 30.99 25 28.16 27.83 30.99 29.24 29.58"}),props.children);});var DataReference32=/*#__PURE__*/React.forwardRef(function DataReference32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"25 13 25 4 23 4 23 6 20 6 20 8 23 8 23 13 20 13 20 15 28 15 28 13 25 13"}),React.createElement("path",{d:"M8.5,6A3.5,3.5,0,1,1,5,9.5,3.504,3.504,0,0,1,8.5,6m0-2A5.5,5.5,0,1,0,14,9.5,5.5,5.5,0,0,0,8.5,4Z"}),React.createElement("path",{d:"M23.5,20A3.5,3.5,0,1,1,20,23.5,3.504,3.504,0,0,1,23.5,20m0-2A5.5,5.5,0,1,0,29,23.5,5.5,5.5,0,0,0,23.5,18Z"}),React.createElement("polygon",{points:"6 19 6 21 9.586 21 4 26.586 5.414 28 11 22.414 11 26 13 26 13 19 6 19"}),props.children);});var DataReference24=/*#__PURE__*/React.forwardRef(function DataReference24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"25 13 25 4 23 4 23 6 20 6 20 8 23 8 23 13 20 13 20 15 28 15 28 13 25 13"}),React.createElement("path",{d:"M8.5,6A3.5,3.5,0,1,1,5,9.5,3.504,3.504,0,0,1,8.5,6m0-2A5.5,5.5,0,1,0,14,9.5,5.5,5.5,0,0,0,8.5,4Z"}),React.createElement("path",{d:"M23.5,20A3.5,3.5,0,1,1,20,23.5,3.504,3.504,0,0,1,23.5,20m0-2A5.5,5.5,0,1,0,29,23.5,5.5,5.5,0,0,0,23.5,18Z"}),React.createElement("polygon",{points:"6 19 6 21 9.586 21 4 26.586 5.414 28 11 22.414 11 26 13 26 13 19 6 19"}),props.children);});var DataReference20=/*#__PURE__*/React.forwardRef(function DataReference20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"25 13 25 4 23 4 23 6 20 6 20 8 23 8 23 13 20 13 20 15 28 15 28 13 25 13"}),React.createElement("path",{d:"M8.5,6A3.5,3.5,0,1,1,5,9.5,3.504,3.504,0,0,1,8.5,6m0-2A5.5,5.5,0,1,0,14,9.5,5.5,5.5,0,0,0,8.5,4Z"}),React.createElement("path",{d:"M23.5,20A3.5,3.5,0,1,1,20,23.5,3.504,3.504,0,0,1,23.5,20m0-2A5.5,5.5,0,1,0,29,23.5,5.5,5.5,0,0,0,23.5,18Z"}),React.createElement("polygon",{points:"6 19 6 21 9.586 21 4 26.586 5.414 28 11 22.414 11 26 13 26 13 19 6 19"}),props.children);});var DataReference16=/*#__PURE__*/React.forwardRef(function DataReference16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"25 13 25 4 23 4 23 6 20 6 20 8 23 8 23 13 20 13 20 15 28 15 28 13 25 13"}),React.createElement("path",{d:"M8.5,6A3.5,3.5,0,1,1,5,9.5,3.504,3.504,0,0,1,8.5,6m0-2A5.5,5.5,0,1,0,14,9.5,5.5,5.5,0,0,0,8.5,4Z"}),React.createElement("path",{d:"M23.5,20A3.5,3.5,0,1,1,20,23.5,3.504,3.504,0,0,1,23.5,20m0-2A5.5,5.5,0,1,0,29,23.5,5.5,5.5,0,0,0,23.5,18Z"}),React.createElement("polygon",{points:"6 19 6 21 9.586 21 4 26.586 5.414 28 11 22.414 11 26 13 26 13 19 6 19"}),props.children);});var DataSet32=/*#__PURE__*/React.forwardRef(function DataSet32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"25 13 25 4 23 4 23 6 20 6 20 8 23 8 23 13 20 13 20 15 28 15 28 13 25 13"}),React.createElement("path",{d:"M8.5,6A3.5,3.5,0,1,1,5,9.5,3.5,3.5,0,0,1,8.5,6m0-2A5.5,5.5,0,1,0,14,9.5,5.5,5.5,0,0,0,8.5,4Z"}),React.createElement("path",{d:"M8.5,20A3.5,3.5,0,1,1,5,23.5,3.5,3.5,0,0,1,8.5,20m0-2A5.5,5.5,0,1,0,14,23.5,5.5,5.5,0,0,0,8.5,18Z"}),React.createElement("path",{d:"M23.5,20A3.5,3.5,0,1,1,20,23.5,3.5,3.5,0,0,1,23.5,20m0-2A5.5,5.5,0,1,0,29,23.5,5.5,5.5,0,0,0,23.5,18Z"}),props.children);});var DataSet24=/*#__PURE__*/React.forwardRef(function DataSet24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"25 13 25 4 23 4 23 6 20 6 20 8 23 8 23 13 20 13 20 15 28 15 28 13 25 13"}),React.createElement("path",{d:"M8.5,6A3.5,3.5,0,1,1,5,9.5,3.5,3.5,0,0,1,8.5,6m0-2A5.5,5.5,0,1,0,14,9.5,5.5,5.5,0,0,0,8.5,4Z"}),React.createElement("path",{d:"M8.5,20A3.5,3.5,0,1,1,5,23.5,3.5,3.5,0,0,1,8.5,20m0-2A5.5,5.5,0,1,0,14,23.5,5.5,5.5,0,0,0,8.5,18Z"}),React.createElement("path",{d:"M23.5,20A3.5,3.5,0,1,1,20,23.5,3.5,3.5,0,0,1,23.5,20m0-2A5.5,5.5,0,1,0,29,23.5,5.5,5.5,0,0,0,23.5,18Z"}),props.children);});var DataSet20=/*#__PURE__*/React.forwardRef(function DataSet20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"25 13 25 4 23 4 23 6 20 6 20 8 23 8 23 13 20 13 20 15 28 15 28 13 25 13"}),React.createElement("path",{d:"M8.5,6A3.5,3.5,0,1,1,5,9.5,3.5,3.5,0,0,1,8.5,6m0-2A5.5,5.5,0,1,0,14,9.5,5.5,5.5,0,0,0,8.5,4Z"}),React.createElement("path",{d:"M8.5,20A3.5,3.5,0,1,1,5,23.5,3.5,3.5,0,0,1,8.5,20m0-2A5.5,5.5,0,1,0,14,23.5,5.5,5.5,0,0,0,8.5,18Z"}),React.createElement("path",{d:"M23.5,20A3.5,3.5,0,1,1,20,23.5,3.5,3.5,0,0,1,23.5,20m0-2A5.5,5.5,0,1,0,29,23.5,5.5,5.5,0,0,0,23.5,18Z"}),props.children);});var DataSet16=/*#__PURE__*/React.forwardRef(function DataSet16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"25 13 25 4 23 4 23 6 20 6 20 8 23 8 23 13 20 13 20 15 28 15 28 13 25 13"}),React.createElement("path",{d:"M8.5,6A3.5,3.5,0,1,1,5,9.5,3.5,3.5,0,0,1,8.5,6m0-2A5.5,5.5,0,1,0,14,9.5,5.5,5.5,0,0,0,8.5,4Z"}),React.createElement("path",{d:"M8.5,20A3.5,3.5,0,1,1,5,23.5,3.5,3.5,0,0,1,8.5,20m0-2A5.5,5.5,0,1,0,14,23.5,5.5,5.5,0,0,0,8.5,18Z"}),React.createElement("path",{d:"M23.5,20A3.5,3.5,0,1,1,20,23.5,3.5,3.5,0,0,1,23.5,20m0-2A5.5,5.5,0,1,0,29,23.5,5.5,5.5,0,0,0,23.5,18Z"}),props.children);});var DataStructured32=/*#__PURE__*/React.forwardRef(function DataStructured32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"9",cy:"7",r:"1"}),React.createElement("path",{d:"M27,22.14V18a2,2,0,0,0-2-2H17V12h9a2,2,0,0,0,2-2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4v6a2,2,0,0,0,2,2h9v4H7a2,2,0,0,0-2,2v4.14a4,4,0,1,0,2,0V18h8v4H12v8h8V22H17V18h8v4.14a4,4,0,1,0,2,0ZM8,26a2,2,0,1,1-2-2A2,2,0,0,1,8,26Zm10-2v4H14V24ZM6,10V4H26v6ZM26,28a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var DataStructured24=/*#__PURE__*/React.forwardRef(function DataStructured24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"9",cy:"7",r:"1"}),React.createElement("path",{d:"M27,22.14V18a2,2,0,0,0-2-2H17V12h9a2,2,0,0,0,2-2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4v6a2,2,0,0,0,2,2h9v4H7a2,2,0,0,0-2,2v4.14a4,4,0,1,0,2,0V18h8v4H12v8h8V22H17V18h8v4.14a4,4,0,1,0,2,0ZM8,26a2,2,0,1,1-2-2A2,2,0,0,1,8,26Zm10-2v4H14V24ZM6,10V4H26v6ZM26,28a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var DataStructured20=/*#__PURE__*/React.forwardRef(function DataStructured20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"9",cy:"7",r:"1"}),React.createElement("path",{d:"M27,22.14V18a2,2,0,0,0-2-2H17V12h9a2,2,0,0,0,2-2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4v6a2,2,0,0,0,2,2h9v4H7a2,2,0,0,0-2,2v4.14a4,4,0,1,0,2,0V18h8v4H12v8h8V22H17V18h8v4.14a4,4,0,1,0,2,0ZM8,26a2,2,0,1,1-2-2A2,2,0,0,1,8,26Zm10-2v4H14V24ZM6,10V4H26v6ZM26,28a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var DataStructured16=/*#__PURE__*/React.forwardRef(function DataStructured16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"9",cy:"7",r:"1"}),React.createElement("path",{d:"M27,22.14V18a2,2,0,0,0-2-2H17V12h9a2,2,0,0,0,2-2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4v6a2,2,0,0,0,2,2h9v4H7a2,2,0,0,0-2,2v4.14a4,4,0,1,0,2,0V18h8v4H12v8h8V22H17V18h8v4.14a4,4,0,1,0,2,0ZM8,26a2,2,0,1,1-2-2A2,2,0,0,1,8,26Zm10-2v4H14V24ZM6,10V4H26v6ZM26,28a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var DataUnstructured32=/*#__PURE__*/React.forwardRef(function DataUnstructured32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,24a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4A4,4,0,0,0,6,22Z"}),React.createElement("path",{d:"M16,4a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4A4,4,0,0,0,16,2Z"}),React.createElement("path",{d:"M26,4a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4A4,4,0,0,0,26,2Z"}),React.createElement("path",{d:"M18,24v4H14V24h4m2-2H12v8h8Z"}),React.createElement("path",{d:"M27,22.14V17a2,2,0,0,0-2-2H7V10h3V2H2v8H5v5a2,2,0,0,0,2,2H25v5.14a4,4,0,1,0,2,0ZM4,4H8V8H4ZM26,28a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var DataUnstructured24=/*#__PURE__*/React.forwardRef(function DataUnstructured24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,24a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4A4,4,0,0,0,6,22Z"}),React.createElement("path",{d:"M16,4a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4A4,4,0,0,0,16,2Z"}),React.createElement("path",{d:"M26,4a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4A4,4,0,0,0,26,2Z"}),React.createElement("path",{d:"M18,24v4H14V24h4m2-2H12v8h8Z"}),React.createElement("path",{d:"M27,22.14V17a2,2,0,0,0-2-2H7V10h3V2H2v8H5v5a2,2,0,0,0,2,2H25v5.14a4,4,0,1,0,2,0ZM4,4H8V8H4ZM26,28a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var DataUnstructured20=/*#__PURE__*/React.forwardRef(function DataUnstructured20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,24a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4A4,4,0,0,0,6,22Z"}),React.createElement("path",{d:"M16,4a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4A4,4,0,0,0,16,2Z"}),React.createElement("path",{d:"M26,4a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4A4,4,0,0,0,26,2Z"}),React.createElement("path",{d:"M18,24v4H14V24h4m2-2H12v8h8Z"}),React.createElement("path",{d:"M27,22.14V17a2,2,0,0,0-2-2H7V10h3V2H2v8H5v5a2,2,0,0,0,2,2H25v5.14a4,4,0,1,0,2,0ZM4,4H8V8H4ZM26,28a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var DataUnstructured16=/*#__PURE__*/React.forwardRef(function DataUnstructured16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,24a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4A4,4,0,0,0,6,22Z"}),React.createElement("path",{d:"M16,4a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4A4,4,0,0,0,16,2Z"}),React.createElement("path",{d:"M26,4a2,2,0,1,1-2,2,2,2,0,0,1,2-2m0-2a4,4,0,1,0,4,4A4,4,0,0,0,26,2Z"}),React.createElement("path",{d:"M18,24v4H14V24h4m2-2H12v8h8Z"}),React.createElement("path",{d:"M27,22.14V17a2,2,0,0,0-2-2H7V10h3V2H2v8H5v5a2,2,0,0,0,2,2H25v5.14a4,4,0,1,0,2,0ZM4,4H8V8H4ZM26,28a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var DataClass32=/*#__PURE__*/React.forwardRef(function DataClass32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,16a3.9612,3.9612,0,0,0-2.02.5657l-2.8586-2.8585,2.293-2.293a2,2,0,0,0,0-2.8284l-6-6a2,2,0,0,0-2.8284,0l-6,6a2,2,0,0,0,0,2.8284l2.293,2.293L8.02,16.5657A4.043,4.043,0,1,0,9.4343,17.98l2.8585-2.8586,2.293,2.293A1.9773,1.9773,0,0,0,15,17.7233V22H12v8h8V22H17V17.7233a1.9773,1.9773,0,0,0,.4142-.3091l2.293-2.293L22.5657,17.98A3.9885,3.9885,0,1,0,26,16ZM8,20a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,20Zm10,4v4H14V24h4Zm-2-8-6-6,6-6,6,6Zm10,6a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,22Z"}),props.children);});var DataClass24=/*#__PURE__*/React.forwardRef(function DataClass24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,16a3.9612,3.9612,0,0,0-2.02.5657l-2.8586-2.8585,2.293-2.293a2,2,0,0,0,0-2.8284l-6-6a2,2,0,0,0-2.8284,0l-6,6a2,2,0,0,0,0,2.8284l2.293,2.293L8.02,16.5657A4.043,4.043,0,1,0,9.4343,17.98l2.8585-2.8586,2.293,2.293A1.9773,1.9773,0,0,0,15,17.7233V22H12v8h8V22H17V17.7233a1.9773,1.9773,0,0,0,.4142-.3091l2.293-2.293L22.5657,17.98A3.9885,3.9885,0,1,0,26,16ZM8,20a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,20Zm10,4v4H14V24h4Zm-2-8-6-6,6-6,6,6Zm10,6a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,22Z"}),props.children);});var DataClass20=/*#__PURE__*/React.forwardRef(function DataClass20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,16a3.9612,3.9612,0,0,0-2.02.5657l-2.8586-2.8585,2.293-2.293a2,2,0,0,0,0-2.8284l-6-6a2,2,0,0,0-2.8284,0l-6,6a2,2,0,0,0,0,2.8284l2.293,2.293L8.02,16.5657A4.043,4.043,0,1,0,9.4343,17.98l2.8585-2.8586,2.293,2.293A1.9773,1.9773,0,0,0,15,17.7233V22H12v8h8V22H17V17.7233a1.9773,1.9773,0,0,0,.4142-.3091l2.293-2.293L22.5657,17.98A3.9885,3.9885,0,1,0,26,16ZM8,20a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,20Zm10,4v4H14V24h4Zm-2-8-6-6,6-6,6,6Zm10,6a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,22Z"}),props.children);});var DataClass16=/*#__PURE__*/React.forwardRef(function DataClass16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,16a3.9612,3.9612,0,0,0-2.02.5657l-2.8586-2.8585,2.293-2.293a2,2,0,0,0,0-2.8284l-6-6a2,2,0,0,0-2.8284,0l-6,6a2,2,0,0,0,0,2.8284l2.293,2.293L8.02,16.5657A4.043,4.043,0,1,0,9.4343,17.98l2.8585-2.8586,2.293,2.293A1.9773,1.9773,0,0,0,15,17.7233V22H12v8h8V22H17V17.7233a1.9773,1.9773,0,0,0,.4142-.3091l2.293-2.293L22.5657,17.98A3.9885,3.9885,0,1,0,26,16ZM8,20a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,20Zm10,4v4H14V24h4Zm-2-8-6-6,6-6,6,6Zm10,6a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,26,22Z"}),props.children);});var DataRefinery32=/*#__PURE__*/React.forwardRef(function DataRefinery32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7,30a5,5,0,1,1,5-5A5.0059,5.0059,0,0,1,7,30Zm0-8a3,3,0,1,0,3,3A3.0033,3.0033,0,0,0,7,22Z"}),React.createElement("path",{d:"M24,26H14V24H24V17H8a2.0021,2.0021,0,0,1-2-2V8A2.0021,2.0021,0,0,1,8,6H18V8H8v7H24a2.0021,2.0021,0,0,1,2,2v7A2.0021,2.0021,0,0,1,24,26Z"}),React.createElement("path",{d:"M28,12H22a2.0023,2.0023,0,0,1-2-2V4a2.0023,2.0023,0,0,1,2-2h6a2.0023,2.0023,0,0,1,2,2v6A2.0023,2.0023,0,0,1,28,12ZM22,4v6h6V4Z"}),props.children);});var DataRefinery24=/*#__PURE__*/React.forwardRef(function DataRefinery24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7,30a5,5,0,1,1,5-5A5.0059,5.0059,0,0,1,7,30Zm0-8a3,3,0,1,0,3,3A3.0033,3.0033,0,0,0,7,22Z"}),React.createElement("path",{d:"M24,26H14V24H24V17H8a2.0021,2.0021,0,0,1-2-2V8A2.0021,2.0021,0,0,1,8,6H18V8H8v7H24a2.0021,2.0021,0,0,1,2,2v7A2.0021,2.0021,0,0,1,24,26Z"}),React.createElement("path",{d:"M28,12H22a2.0023,2.0023,0,0,1-2-2V4a2.0023,2.0023,0,0,1,2-2h6a2.0023,2.0023,0,0,1,2,2v6A2.0023,2.0023,0,0,1,28,12ZM22,4v6h6V4Z"}),props.children);});var DataRefinery20=/*#__PURE__*/React.forwardRef(function DataRefinery20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7,30a5,5,0,1,1,5-5A5.0059,5.0059,0,0,1,7,30Zm0-8a3,3,0,1,0,3,3A3.0033,3.0033,0,0,0,7,22Z"}),React.createElement("path",{d:"M24,26H14V24H24V17H8a2.0021,2.0021,0,0,1-2-2V8A2.0021,2.0021,0,0,1,8,6H18V8H8v7H24a2.0021,2.0021,0,0,1,2,2v7A2.0021,2.0021,0,0,1,24,26Z"}),React.createElement("path",{d:"M28,12H22a2.0023,2.0023,0,0,1-2-2V4a2.0023,2.0023,0,0,1,2-2h6a2.0023,2.0023,0,0,1,2,2v6A2.0023,2.0023,0,0,1,28,12ZM22,4v6h6V4Z"}),props.children);});var DataRefinery16=/*#__PURE__*/React.forwardRef(function DataRefinery16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7,30a5,5,0,1,1,5-5A5.0059,5.0059,0,0,1,7,30Zm0-8a3,3,0,1,0,3,3A3.0033,3.0033,0,0,0,7,22Z"}),React.createElement("path",{d:"M24,26H14V24H24V17H8a2.0021,2.0021,0,0,1-2-2V8A2.0021,2.0021,0,0,1,8,6H18V8H8v7H24a2.0021,2.0021,0,0,1,2,2v7A2.0021,2.0021,0,0,1,24,26Z"}),React.createElement("path",{d:"M28,12H22a2.0023,2.0023,0,0,1-2-2V4a2.0023,2.0023,0,0,1,2-2h6a2.0023,2.0023,0,0,1,2,2v6A2.0023,2.0023,0,0,1,28,12ZM22,4v6h6V4Z"}),props.children);});var DataShare32=/*#__PURE__*/React.forwardRef(function DataShare32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M5,25V15.8281l-3.5859,3.586L0,18l6-6,6,6-1.4141,1.4141L7,15.8281V25H19v2H7A2.0024,2.0024,0,0,1,5,25Z"}),React.createElement("path",{d:"M24,22h4a2.002,2.002,0,0,1,2,2v4a2.002,2.002,0,0,1-2,2H24a2.002,2.002,0,0,1-2-2V24A2.002,2.002,0,0,1,24,22Zm4,6V24H23.9985L24,28Z"}),React.createElement("path",{d:"M27,6v9.1719l3.5859-3.586L32,13l-6,6-6-6,1.4141-1.4141L25,15.1719V6H13V4H25A2.0024,2.0024,0,0,1,27,6Z"}),React.createElement("rect",{width:"6",height:"2",x:"2",y:"6"}),React.createElement("rect",{width:"8",height:"2",x:"2",y:"2"}),props.children);});var DataShare24=/*#__PURE__*/React.forwardRef(function DataShare24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M5,25V15.8281l-3.5859,3.586L0,18l6-6,6,6-1.4141,1.4141L7,15.8281V25H19v2H7A2.0024,2.0024,0,0,1,5,25Z"}),React.createElement("path",{d:"M24,22h4a2.002,2.002,0,0,1,2,2v4a2.002,2.002,0,0,1-2,2H24a2.002,2.002,0,0,1-2-2V24A2.002,2.002,0,0,1,24,22Zm4,6V24H23.9985L24,28Z"}),React.createElement("path",{d:"M27,6v9.1719l3.5859-3.586L32,13l-6,6-6-6,1.4141-1.4141L25,15.1719V6H13V4H25A2.0024,2.0024,0,0,1,27,6Z"}),React.createElement("rect",{width:"6",height:"2",x:"2",y:"6"}),React.createElement("rect",{width:"8",height:"2",x:"2",y:"2"}),props.children);});var DataShare20=/*#__PURE__*/React.forwardRef(function DataShare20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M5,25V15.8281l-3.5859,3.586L0,18l6-6,6,6-1.4141,1.4141L7,15.8281V25H19v2H7A2.0024,2.0024,0,0,1,5,25Z"}),React.createElement("path",{d:"M24,22h4a2.002,2.002,0,0,1,2,2v4a2.002,2.002,0,0,1-2,2H24a2.002,2.002,0,0,1-2-2V24A2.002,2.002,0,0,1,24,22Zm4,6V24H23.9985L24,28Z"}),React.createElement("path",{d:"M27,6v9.1719l3.5859-3.586L32,13l-6,6-6-6,1.4141-1.4141L25,15.1719V6H13V4H25A2.0024,2.0024,0,0,1,27,6Z"}),React.createElement("rect",{width:"6",height:"2",x:"2",y:"6"}),React.createElement("rect",{width:"8",height:"2",x:"2",y:"2"}),props.children);});var DataShare16=/*#__PURE__*/React.forwardRef(function DataShare16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M5,25V15.8281l-3.5859,3.586L0,18l6-6,6,6-1.4141,1.4141L7,15.8281V25H19v2H7A2.0024,2.0024,0,0,1,5,25Z"}),React.createElement("path",{d:"M24,22h4a2.002,2.002,0,0,1,2,2v4a2.002,2.002,0,0,1-2,2H24a2.002,2.002,0,0,1-2-2V24A2.002,2.002,0,0,1,24,22Zm4,6V24H23.9985L24,28Z"}),React.createElement("path",{d:"M27,6v9.1719l3.5859-3.586L32,13l-6,6-6-6,1.4141-1.4141L25,15.1719V6H13V4H25A2.0024,2.0024,0,0,1,27,6Z"}),React.createElement("rect",{width:"6",height:"2",x:"2",y:"6"}),React.createElement("rect",{width:"8",height:"2",x:"2",y:"2"}),props.children);});var DataTable32=/*#__PURE__*/React.forwardRef(function DataTable32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"2",x:"8",y:"18"}),React.createElement("rect",{width:"4",height:"2",x:"14",y:"18"}),React.createElement("rect",{width:"4",height:"2",x:"8",y:"14"}),React.createElement("rect",{width:"4",height:"2",x:"14",y:"22"}),React.createElement("rect",{width:"4",height:"2",x:"20",y:"14"}),React.createElement("rect",{width:"4",height:"2",x:"20",y:"22"}),React.createElement("path",{d:"M27,3H5A2.0025,2.0025,0,0,0,3,5V27a2.0025,2.0025,0,0,0,2,2H27a2.0025,2.0025,0,0,0,2-2V5A2.0025,2.0025,0,0,0,27,3Zm0,2,0,4H5V5ZM5,27V11H27l0,16Z"}),props.children);});var DataTable24=/*#__PURE__*/React.forwardRef(function DataTable24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"2",x:"8",y:"18"}),React.createElement("rect",{width:"4",height:"2",x:"14",y:"18"}),React.createElement("rect",{width:"4",height:"2",x:"8",y:"14"}),React.createElement("rect",{width:"4",height:"2",x:"14",y:"22"}),React.createElement("rect",{width:"4",height:"2",x:"20",y:"14"}),React.createElement("rect",{width:"4",height:"2",x:"20",y:"22"}),React.createElement("path",{d:"M27,3H5A2.0025,2.0025,0,0,0,3,5V27a2.0025,2.0025,0,0,0,2,2H27a2.0025,2.0025,0,0,0,2-2V5A2.0025,2.0025,0,0,0,27,3Zm0,2,0,4H5V5ZM5,27V11H27l0,16Z"}),props.children);});var DataTable20=/*#__PURE__*/React.forwardRef(function DataTable20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"2",x:"8",y:"18"}),React.createElement("rect",{width:"4",height:"2",x:"14",y:"18"}),React.createElement("rect",{width:"4",height:"2",x:"8",y:"14"}),React.createElement("rect",{width:"4",height:"2",x:"14",y:"22"}),React.createElement("rect",{width:"4",height:"2",x:"20",y:"14"}),React.createElement("rect",{width:"4",height:"2",x:"20",y:"22"}),React.createElement("path",{d:"M27,3H5A2.0025,2.0025,0,0,0,3,5V27a2.0025,2.0025,0,0,0,2,2H27a2.0025,2.0025,0,0,0,2-2V5A2.0025,2.0025,0,0,0,27,3Zm0,2,0,4H5V5ZM5,27V11H27l0,16Z"}),props.children);});var DataTable16=/*#__PURE__*/React.forwardRef(function DataTable16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"2",x:"8",y:"18"}),React.createElement("rect",{width:"4",height:"2",x:"14",y:"18"}),React.createElement("rect",{width:"4",height:"2",x:"8",y:"14"}),React.createElement("rect",{width:"4",height:"2",x:"14",y:"22"}),React.createElement("rect",{width:"4",height:"2",x:"20",y:"14"}),React.createElement("rect",{width:"4",height:"2",x:"20",y:"22"}),React.createElement("path",{d:"M27,3H5A2.0025,2.0025,0,0,0,3,5V27a2.0025,2.0025,0,0,0,2,2H27a2.0025,2.0025,0,0,0,2-2V5A2.0025,2.0025,0,0,0,27,3Zm0,2,0,4H5V5ZM5,27V11H27l0,16Z"}),props.children);});var DataVis_132=/*#__PURE__*/React.forwardRef(function DataVis_132(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,22a3.9553,3.9553,0,0,0-2.0193.5667L20.167,18.7529a4.9654,4.9654,0,0,0,0-5.5058L22.714,10.7A3.0284,3.0284,0,1,0,21.3,9.286l-2.547,2.547a4.9654,4.9654,0,0,0-5.5058,0L9.4332,8.0191A3.9553,3.9553,0,0,0,10,6a4,4,0,1,0-4,4,3.9553,3.9553,0,0,0,2.0191-.5668l3.8139,3.8139a4.9654,4.9654,0,0,0,0,5.5058L8.0192,22.5668A3.9556,3.9556,0,0,0,6,22a4,4,0,1,0,4,4,3.9553,3.9553,0,0,0-.5667-2.0192l3.8138-3.8138A4.9686,4.9686,0,0,0,15,20.8989v3.2848a3,3,0,1,0,2,0V20.8989a4.9686,4.9686,0,0,0,1.7529-.7319l3.8138,3.8137A3.9553,3.9553,0,0,0,22,26a4,4,0,1,0,4-4ZM16,13a3,3,0,1,1-3,3A3.0033,3.0033,0,0,1,16,13ZM4,6A2,2,0,1,1,6,8,2.002,2.002,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,6,28Zm20,0a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,28Z"}),props.children);});var DataVis_124=/*#__PURE__*/React.forwardRef(function DataVis_124(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,22a3.9553,3.9553,0,0,0-2.0193.5667L20.167,18.7529a4.9654,4.9654,0,0,0,0-5.5058L22.714,10.7A3.0284,3.0284,0,1,0,21.3,9.286l-2.547,2.547a4.9654,4.9654,0,0,0-5.5058,0L9.4332,8.0191A3.9553,3.9553,0,0,0,10,6a4,4,0,1,0-4,4,3.9553,3.9553,0,0,0,2.0191-.5668l3.8139,3.8139a4.9654,4.9654,0,0,0,0,5.5058L8.0192,22.5668A3.9556,3.9556,0,0,0,6,22a4,4,0,1,0,4,4,3.9553,3.9553,0,0,0-.5667-2.0192l3.8138-3.8138A4.9686,4.9686,0,0,0,15,20.8989v3.2848a3,3,0,1,0,2,0V20.8989a4.9686,4.9686,0,0,0,1.7529-.7319l3.8138,3.8137A3.9553,3.9553,0,0,0,22,26a4,4,0,1,0,4-4ZM16,13a3,3,0,1,1-3,3A3.0033,3.0033,0,0,1,16,13ZM4,6A2,2,0,1,1,6,8,2.002,2.002,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,6,28Zm20,0a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,28Z"}),props.children);});var DataVis_120=/*#__PURE__*/React.forwardRef(function DataVis_120(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,22a3.9553,3.9553,0,0,0-2.0193.5667L20.167,18.7529a4.9654,4.9654,0,0,0,0-5.5058L22.714,10.7A3.0284,3.0284,0,1,0,21.3,9.286l-2.547,2.547a4.9654,4.9654,0,0,0-5.5058,0L9.4332,8.0191A3.9553,3.9553,0,0,0,10,6a4,4,0,1,0-4,4,3.9553,3.9553,0,0,0,2.0191-.5668l3.8139,3.8139a4.9654,4.9654,0,0,0,0,5.5058L8.0192,22.5668A3.9556,3.9556,0,0,0,6,22a4,4,0,1,0,4,4,3.9553,3.9553,0,0,0-.5667-2.0192l3.8138-3.8138A4.9686,4.9686,0,0,0,15,20.8989v3.2848a3,3,0,1,0,2,0V20.8989a4.9686,4.9686,0,0,0,1.7529-.7319l3.8138,3.8137A3.9553,3.9553,0,0,0,22,26a4,4,0,1,0,4-4ZM16,13a3,3,0,1,1-3,3A3.0033,3.0033,0,0,1,16,13ZM4,6A2,2,0,1,1,6,8,2.002,2.002,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,6,28Zm20,0a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,28Z"}),props.children);});var DataVis_116=/*#__PURE__*/React.forwardRef(function DataVis_116(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,22a3.9553,3.9553,0,0,0-2.0193.5667L20.167,18.7529a4.9654,4.9654,0,0,0,0-5.5058L22.714,10.7A3.0284,3.0284,0,1,0,21.3,9.286l-2.547,2.547a4.9654,4.9654,0,0,0-5.5058,0L9.4332,8.0191A3.9553,3.9553,0,0,0,10,6a4,4,0,1,0-4,4,3.9553,3.9553,0,0,0,2.0191-.5668l3.8139,3.8139a4.9654,4.9654,0,0,0,0,5.5058L8.0192,22.5668A3.9556,3.9556,0,0,0,6,22a4,4,0,1,0,4,4,3.9553,3.9553,0,0,0-.5667-2.0192l3.8138-3.8138A4.9686,4.9686,0,0,0,15,20.8989v3.2848a3,3,0,1,0,2,0V20.8989a4.9686,4.9686,0,0,0,1.7529-.7319l3.8138,3.8137A3.9553,3.9553,0,0,0,22,26a4,4,0,1,0,4-4ZM16,13a3,3,0,1,1-3,3A3.0033,3.0033,0,0,1,16,13ZM4,6A2,2,0,1,1,6,8,2.002,2.002,0,0,1,4,6ZM6,28a2,2,0,1,1,2-2A2.0023,2.0023,0,0,1,6,28Zm20,0a2,2,0,1,1,2-2A2.0027,2.0027,0,0,1,26,28Z"}),props.children);});var DataVis_232=/*#__PURE__*/React.forwardRef(function DataVis_232(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H17a2.002,2.002,0,0,0-2,2v6H4a2.002,2.002,0,0,0-2,2V28a2.0023,2.0023,0,0,0,2,2H15a2.0023,2.0023,0,0,0,2-2V22H28a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,28,2Zm0,2,0,4H17V4ZM15.0009,22H4V18H15ZM17,10H28.0007l.0005,4H17Zm-2,2v4H4V12ZM4,28V24H15.0011l0,4Zm13-8V16H28.0015l0,4Z"}),props.children);});var DataVis_224=/*#__PURE__*/React.forwardRef(function DataVis_224(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H17a2.002,2.002,0,0,0-2,2v6H4a2.002,2.002,0,0,0-2,2V28a2.0023,2.0023,0,0,0,2,2H15a2.0023,2.0023,0,0,0,2-2V22H28a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,28,2Zm0,2,0,4H17V4ZM15.0009,22H4V18H15ZM17,10H28.0007l.0005,4H17Zm-2,2v4H4V12ZM4,28V24H15.0011l0,4Zm13-8V16H28.0015l0,4Z"}),props.children);});var DataVis_220=/*#__PURE__*/React.forwardRef(function DataVis_220(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H17a2.002,2.002,0,0,0-2,2v6H4a2.002,2.002,0,0,0-2,2V28a2.0023,2.0023,0,0,0,2,2H15a2.0023,2.0023,0,0,0,2-2V22H28a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,28,2Zm0,2,0,4H17V4ZM15.0009,22H4V18H15ZM17,10H28.0007l.0005,4H17Zm-2,2v4H4V12ZM4,28V24H15.0011l0,4Zm13-8V16H28.0015l0,4Z"}),props.children);});var DataVis_216=/*#__PURE__*/React.forwardRef(function DataVis_216(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,2H17a2.002,2.002,0,0,0-2,2v6H4a2.002,2.002,0,0,0-2,2V28a2.0023,2.0023,0,0,0,2,2H15a2.0023,2.0023,0,0,0,2-2V22H28a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,28,2Zm0,2,0,4H17V4ZM15.0009,22H4V18H15ZM17,10H28.0007l.0005,4H17Zm-2,2v4H4V12ZM4,28V24H15.0011l0,4Zm13-8V16H28.0015l0,4Z"}),props.children);});var DataVis_332=/*#__PURE__*/React.forwardRef(function DataVis_332(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,3a2.9913,2.9913,0,0,0-2.8163,2H21.858a3.9807,3.9807,0,0,0-7.716,0H9.858A3.9916,3.9916,0,1,0,5,9.858v4.284a3.9807,3.9807,0,0,0,0,7.716v3.3257a3,3,0,1,0,2,0V21.858a3.978,3.978,0,0,0,1.6729-.9034l3.3638,1.6819A2.9635,2.9635,0,0,0,12,23a3.0117,3.0117,0,1,0,.9221-2.1572L9.7744,19.269A3.95,3.95,0,0,0,10,18a3.9963,3.9963,0,0,0-3-3.858V9.858A3.9947,3.9947,0,0,0,9.858,7h4.284a3.9366,3.9366,0,0,0,4.7816,2.8818l1.8118,3.1705a3.0451,3.0451,0,1,0,1.7326-.9987L20.6893,8.941A3.9839,3.9839,0,0,0,21.858,7h3.3257A2.995,2.995,0,1,0,28,3ZM8,18a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,18ZM6,8A2,2,0,1,1,8,6,2.002,2.002,0,0,1,6,8ZM16,6a2,2,0,1,1,2,2A2.002,2.002,0,0,1,16,6Z"}),props.children);});var DataVis_324=/*#__PURE__*/React.forwardRef(function DataVis_324(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,3a2.9913,2.9913,0,0,0-2.8163,2H21.858a3.9807,3.9807,0,0,0-7.716,0H9.858A3.9916,3.9916,0,1,0,5,9.858v4.284a3.9807,3.9807,0,0,0,0,7.716v3.3257a3,3,0,1,0,2,0V21.858a3.978,3.978,0,0,0,1.6729-.9034l3.3638,1.6819A2.9635,2.9635,0,0,0,12,23a3.0117,3.0117,0,1,0,.9221-2.1572L9.7744,19.269A3.95,3.95,0,0,0,10,18a3.9963,3.9963,0,0,0-3-3.858V9.858A3.9947,3.9947,0,0,0,9.858,7h4.284a3.9366,3.9366,0,0,0,4.7816,2.8818l1.8118,3.1705a3.0451,3.0451,0,1,0,1.7326-.9987L20.6893,8.941A3.9839,3.9839,0,0,0,21.858,7h3.3257A2.995,2.995,0,1,0,28,3ZM8,18a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,18ZM6,8A2,2,0,1,1,8,6,2.002,2.002,0,0,1,6,8ZM16,6a2,2,0,1,1,2,2A2.002,2.002,0,0,1,16,6Z"}),props.children);});var DataVis_320=/*#__PURE__*/React.forwardRef(function DataVis_320(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,3a2.9913,2.9913,0,0,0-2.8163,2H21.858a3.9807,3.9807,0,0,0-7.716,0H9.858A3.9916,3.9916,0,1,0,5,9.858v4.284a3.9807,3.9807,0,0,0,0,7.716v3.3257a3,3,0,1,0,2,0V21.858a3.978,3.978,0,0,0,1.6729-.9034l3.3638,1.6819A2.9635,2.9635,0,0,0,12,23a3.0117,3.0117,0,1,0,.9221-2.1572L9.7744,19.269A3.95,3.95,0,0,0,10,18a3.9963,3.9963,0,0,0-3-3.858V9.858A3.9947,3.9947,0,0,0,9.858,7h4.284a3.9366,3.9366,0,0,0,4.7816,2.8818l1.8118,3.1705a3.0451,3.0451,0,1,0,1.7326-.9987L20.6893,8.941A3.9839,3.9839,0,0,0,21.858,7h3.3257A2.995,2.995,0,1,0,28,3ZM8,18a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,18ZM6,8A2,2,0,1,1,8,6,2.002,2.002,0,0,1,6,8ZM16,6a2,2,0,1,1,2,2A2.002,2.002,0,0,1,16,6Z"}),props.children);});var DataVis_316=/*#__PURE__*/React.forwardRef(function DataVis_316(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,3a2.9913,2.9913,0,0,0-2.8163,2H21.858a3.9807,3.9807,0,0,0-7.716,0H9.858A3.9916,3.9916,0,1,0,5,9.858v4.284a3.9807,3.9807,0,0,0,0,7.716v3.3257a3,3,0,1,0,2,0V21.858a3.978,3.978,0,0,0,1.6729-.9034l3.3638,1.6819A2.9635,2.9635,0,0,0,12,23a3.0117,3.0117,0,1,0,.9221-2.1572L9.7744,19.269A3.95,3.95,0,0,0,10,18a3.9963,3.9963,0,0,0-3-3.858V9.858A3.9947,3.9947,0,0,0,9.858,7h4.284a3.9366,3.9366,0,0,0,4.7816,2.8818l1.8118,3.1705a3.0451,3.0451,0,1,0,1.7326-.9987L20.6893,8.941A3.9839,3.9839,0,0,0,21.858,7h3.3257A2.995,2.995,0,1,0,28,3ZM8,18a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,18ZM6,8A2,2,0,1,1,8,6,2.002,2.002,0,0,1,6,8ZM16,6a2,2,0,1,1,2,2A2.002,2.002,0,0,1,16,6Z"}),props.children);});var DataVis_432=/*#__PURE__*/React.forwardRef(function DataVis_432(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,3H5A2.002,2.002,0,0,0,3,5V27a2.0023,2.0023,0,0,0,2,2H27a2.0027,2.0027,0,0,0,2-2V5A2.0023,2.0023,0,0,0,27,3Zm0,6H17V5H27ZM15,27H11V23h4Zm0-6H11V17h4ZM9,21H5V17H9Zm2-6V11H21v4Zm0-6V5h4V9Zm12,2h4l0,4H23ZM9,5V15H5V5ZM5,23H9v4H5Zm12,4V17H27.001l.001,10Z"}),props.children);});var DataVis_424=/*#__PURE__*/React.forwardRef(function DataVis_424(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,3H5A2.002,2.002,0,0,0,3,5V27a2.0023,2.0023,0,0,0,2,2H27a2.0027,2.0027,0,0,0,2-2V5A2.0023,2.0023,0,0,0,27,3Zm0,6H17V5H27ZM15,27H11V23h4Zm0-6H11V17h4ZM9,21H5V17H9Zm2-6V11H21v4Zm0-6V5h4V9Zm12,2h4l0,4H23ZM9,5V15H5V5ZM5,23H9v4H5Zm12,4V17H27.001l.001,10Z"}),props.children);});var DataVis_420=/*#__PURE__*/React.forwardRef(function DataVis_420(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,3H5A2.002,2.002,0,0,0,3,5V27a2.0023,2.0023,0,0,0,2,2H27a2.0027,2.0027,0,0,0,2-2V5A2.0023,2.0023,0,0,0,27,3Zm0,6H17V5H27ZM15,27H11V23h4Zm0-6H11V17h4ZM9,21H5V17H9Zm2-6V11H21v4Zm0-6V5h4V9Zm12,2h4l0,4H23ZM9,5V15H5V5ZM5,23H9v4H5Zm12,4V17H27.001l.001,10Z"}),props.children);});var DataVis_416=/*#__PURE__*/React.forwardRef(function DataVis_416(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,3H5A2.002,2.002,0,0,0,3,5V27a2.0023,2.0023,0,0,0,2,2H27a2.0027,2.0027,0,0,0,2-2V5A2.0023,2.0023,0,0,0,27,3Zm0,6H17V5H27ZM15,27H11V23h4Zm0-6H11V17h4ZM9,21H5V17H9Zm2-6V11H21v4Zm0-6V5h4V9Zm12,2h4l0,4H23ZM9,5V15H5V5ZM5,23H9v4H5Zm12,4V17H27.001l.001,10Z"}),props.children);});var Datastore32=/*#__PURE__*/React.forwardRef(function Datastore32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"23",cy:"23",r:"1"}),React.createElement("rect",{width:"12",height:"2",x:"8",y:"22"}),React.createElement("circle",{cx:"23",cy:"9",r:"1"}),React.createElement("rect",{width:"12",height:"2",x:"8",y:"8"}),React.createElement("path",{d:"M26,14a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2H6A2,2,0,0,0,4,6v6a2,2,0,0,0,2,2H8v4H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V20a2,2,0,0,0-2-2H24V14ZM6,6H26v6H6ZM26,26H6V20H26Zm-4-8H10V14H22Z"}),props.children);});var Datastore24=/*#__PURE__*/React.forwardRef(function Datastore24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"23",cy:"23",r:"1"}),React.createElement("rect",{width:"12",height:"2",x:"8",y:"22"}),React.createElement("circle",{cx:"23",cy:"9",r:"1"}),React.createElement("rect",{width:"12",height:"2",x:"8",y:"8"}),React.createElement("path",{d:"M26,14a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2H6A2,2,0,0,0,4,6v6a2,2,0,0,0,2,2H8v4H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V20a2,2,0,0,0-2-2H24V14ZM6,6H26v6H6ZM26,26H6V20H26Zm-4-8H10V14H22Z"}),props.children);});var Datastore20=/*#__PURE__*/React.forwardRef(function Datastore20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"23",cy:"23",r:"1"}),React.createElement("rect",{width:"12",height:"2",x:"8",y:"22"}),React.createElement("circle",{cx:"23",cy:"9",r:"1"}),React.createElement("rect",{width:"12",height:"2",x:"8",y:"8"}),React.createElement("path",{d:"M26,14a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2H6A2,2,0,0,0,4,6v6a2,2,0,0,0,2,2H8v4H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V20a2,2,0,0,0-2-2H24V14ZM6,6H26v6H6ZM26,26H6V20H26Zm-4-8H10V14H22Z"}),props.children);});var Datastore16=/*#__PURE__*/React.forwardRef(function Datastore16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"23",cy:"23",r:"1"}),React.createElement("rect",{width:"12",height:"2",x:"8",y:"22"}),React.createElement("circle",{cx:"23",cy:"9",r:"1"}),React.createElement("rect",{width:"12",height:"2",x:"8",y:"8"}),React.createElement("path",{d:"M26,14a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2H6A2,2,0,0,0,4,6v6a2,2,0,0,0,2,2H8v4H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V20a2,2,0,0,0-2-2H24V14ZM6,6H26v6H6ZM26,26H6V20H26Zm-4-8H10V14H22Z"}),props.children);});var Debug32=/*#__PURE__*/React.forwardRef(function Debug32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.83,20l.34-2L25,17.15V13c0-.08,0-.15,0-.23l5.06-1.36-.51-1.93-4.83,1.29A9,9,0,0,0,20,5V2H18V4.23a8.81,8.81,0,0,0-4,0V2H12V5a9,9,0,0,0-4.71,5.82L2.46,9.48,2,11.41,7,12.77c0,.08,0,.15,0,.23v4.15L1.84,18l.32,2L7,19.18a8.9,8.9,0,0,0,.82,3.57L3.29,27.29l1.42,1.42,4.19-4.2a9,9,0,0,0,14.2,0l4.19,4.2,1.42-1.42-4.54-4.54A8.9,8.9,0,0,0,25,19.18ZM15,25.92A7,7,0,0,1,9,19V13h6ZM9.29,11a7,7,0,0,1,13.42,0ZM23,19a7,7,0,0,1-6,6.92V13h6Z"}),props.children);});var Debug24=/*#__PURE__*/React.forwardRef(function Debug24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.83,20l.34-2L25,17.15V13c0-.08,0-.15,0-.23l5.06-1.36-.51-1.93-4.83,1.29A9,9,0,0,0,20,5V2H18V4.23a8.81,8.81,0,0,0-4,0V2H12V5a9,9,0,0,0-4.71,5.82L2.46,9.48,2,11.41,7,12.77c0,.08,0,.15,0,.23v4.15L1.84,18l.32,2L7,19.18a8.9,8.9,0,0,0,.82,3.57L3.29,27.29l1.42,1.42,4.19-4.2a9,9,0,0,0,14.2,0l4.19,4.2,1.42-1.42-4.54-4.54A8.9,8.9,0,0,0,25,19.18ZM15,25.92A7,7,0,0,1,9,19V13h6ZM9.29,11a7,7,0,0,1,13.42,0ZM23,19a7,7,0,0,1-6,6.92V13h6Z"}),props.children);});var Debug20=/*#__PURE__*/React.forwardRef(function Debug20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.83,20l.34-2L25,17.15V13c0-.08,0-.15,0-.23l5.06-1.36-.51-1.93-4.83,1.29A9,9,0,0,0,20,5V2H18V4.23a8.81,8.81,0,0,0-4,0V2H12V5a9,9,0,0,0-4.71,5.82L2.46,9.48,2,11.41,7,12.77c0,.08,0,.15,0,.23v4.15L1.84,18l.32,2L7,19.18a8.9,8.9,0,0,0,.82,3.57L3.29,27.29l1.42,1.42,4.19-4.2a9,9,0,0,0,14.2,0l4.19,4.2,1.42-1.42-4.54-4.54A8.9,8.9,0,0,0,25,19.18ZM15,25.92A7,7,0,0,1,9,19V13h6ZM9.29,11a7,7,0,0,1,13.42,0ZM23,19a7,7,0,0,1-6,6.92V13h6Z"}),props.children);});var Debug16=/*#__PURE__*/React.forwardRef(function Debug16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.83,20l.34-2L25,17.15V13c0-.08,0-.15,0-.23l5.06-1.36-.51-1.93-4.83,1.29A9,9,0,0,0,20,5V2H18V4.23a8.81,8.81,0,0,0-4,0V2H12V5a9,9,0,0,0-4.71,5.82L2.46,9.48,2,11.41,7,12.77c0,.08,0,.15,0,.23v4.15L1.84,18l.32,2L7,19.18a8.9,8.9,0,0,0,.82,3.57L3.29,27.29l1.42,1.42,4.19-4.2a9,9,0,0,0,14.2,0l4.19,4.2,1.42-1.42-4.54-4.54A8.9,8.9,0,0,0,25,19.18ZM15,25.92A7,7,0,0,1,9,19V13h6ZM9.29,11a7,7,0,0,1,13.42,0ZM23,19a7,7,0,0,1-6,6.92V13h6Z"}),props.children);});var Delete32=/*#__PURE__*/React.forwardRef(function Delete32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"12",x:"12",y:"12"}),React.createElement("rect",{width:"2",height:"12",x:"18",y:"12"}),React.createElement("path",{d:"M4,6V8H6V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V8h2V6ZM8,28V8H24V28Z"}),React.createElement("rect",{width:"8",height:"2",x:"12",y:"2"}),props.children);});var Delete24=/*#__PURE__*/React.forwardRef(function Delete24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"12",x:"12",y:"12"}),React.createElement("rect",{width:"2",height:"12",x:"18",y:"12"}),React.createElement("path",{d:"M4,6V8H6V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V8h2V6ZM8,28V8H24V28Z"}),React.createElement("rect",{width:"8",height:"2",x:"12",y:"2"}),props.children);});var Delete20=/*#__PURE__*/React.forwardRef(function Delete20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"12",x:"12",y:"12"}),React.createElement("rect",{width:"2",height:"12",x:"18",y:"12"}),React.createElement("path",{d:"M4,6V8H6V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V8h2V6ZM8,28V8H24V28Z"}),React.createElement("rect",{width:"8",height:"2",x:"12",y:"2"}),props.children);});var Delete16=/*#__PURE__*/React.forwardRef(function Delete16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"12",x:"12",y:"12"}),React.createElement("rect",{width:"2",height:"12",x:"18",y:"12"}),React.createElement("path",{d:"M4,6V8H6V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V8h2V6ZM8,28V8H24V28Z"}),React.createElement("rect",{width:"8",height:"2",x:"12",y:"2"}),props.children);});var DeliveryTruck32=/*#__PURE__*/React.forwardRef(function DeliveryTruck32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.92,16.61l-3-7A1,1,0,0,0,26,9H23V7a1,1,0,0,0-1-1H3A1,1,0,0,0,2,7V24a1,1,0,0,0,1,1H5.14a4,4,0,0,0,7.72,0h6.28a4,4,0,0,0,7.72,0H29a1,1,0,0,0,1-1V17A1,1,0,0,0,29.92,16.61ZM23,11h2.34l2.14,5H23ZM9,26a2,2,0,1,1,2-2A2,2,0,0,1,9,26Zm10.14-3H12.86a4,4,0,0,0-7.72,0H4V8H21V20.56A4,4,0,0,0,19.14,23ZM23,26a2,2,0,1,1,2-2A2,2,0,0,1,23,26Zm5-3H26.86A4,4,0,0,0,23,20V18h5Z"}),props.children);});var DeliveryTruck24=/*#__PURE__*/React.forwardRef(function DeliveryTruck24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.92,16.61l-3-7A1,1,0,0,0,26,9H23V7a1,1,0,0,0-1-1H3A1,1,0,0,0,2,7V24a1,1,0,0,0,1,1H5.14a4,4,0,0,0,7.72,0h6.28a4,4,0,0,0,7.72,0H29a1,1,0,0,0,1-1V17A1,1,0,0,0,29.92,16.61ZM23,11h2.34l2.14,5H23ZM9,26a2,2,0,1,1,2-2A2,2,0,0,1,9,26Zm10.14-3H12.86a4,4,0,0,0-7.72,0H4V8H21V20.56A4,4,0,0,0,19.14,23ZM23,26a2,2,0,1,1,2-2A2,2,0,0,1,23,26Zm5-3H26.86A4,4,0,0,0,23,20V18h5Z"}),props.children);});var DeliveryTruck20=/*#__PURE__*/React.forwardRef(function DeliveryTruck20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.92,16.61l-3-7A1,1,0,0,0,26,9H23V7a1,1,0,0,0-1-1H3A1,1,0,0,0,2,7V24a1,1,0,0,0,1,1H5.14a4,4,0,0,0,7.72,0h6.28a4,4,0,0,0,7.72,0H29a1,1,0,0,0,1-1V17A1,1,0,0,0,29.92,16.61ZM23,11h2.34l2.14,5H23ZM9,26a2,2,0,1,1,2-2A2,2,0,0,1,9,26Zm10.14-3H12.86a4,4,0,0,0-7.72,0H4V8H21V20.56A4,4,0,0,0,19.14,23ZM23,26a2,2,0,1,1,2-2A2,2,0,0,1,23,26Zm5-3H26.86A4,4,0,0,0,23,20V18h5Z"}),props.children);});var DeliveryTruck16=/*#__PURE__*/React.forwardRef(function DeliveryTruck16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29.92,16.61l-3-7A1,1,0,0,0,26,9H23V7a1,1,0,0,0-1-1H3A1,1,0,0,0,2,7V24a1,1,0,0,0,1,1H5.14a4,4,0,0,0,7.72,0h6.28a4,4,0,0,0,7.72,0H29a1,1,0,0,0,1-1V17A1,1,0,0,0,29.92,16.61ZM23,11h2.34l2.14,5H23ZM9,26a2,2,0,1,1,2-2A2,2,0,0,1,9,26Zm10.14-3H12.86a4,4,0,0,0-7.72,0H4V8H21V20.56A4,4,0,0,0,19.14,23ZM23,26a2,2,0,1,1,2-2A2,2,0,0,1,23,26Zm5-3H26.86A4,4,0,0,0,23,20V18h5Z"}),props.children);});var Departure32=/*#__PURE__*/React.forwardRef(function Departure32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M13.48,5.15l5.69,8.14.8,1.15,1.35-.36,4.52-1.21a2.13,2.13,0,0,1,1.12,0A1.84,1.84,0,0,1,28.23,14,1.87,1.87,0,0,1,27,16.45l-18.71,5a1.78,1.78,0,0,1-1,0A1.87,1.87,0,0,1,6,20.12l-.25-.93L5,16.38l-.74-2.74,1.44-.39L8,16.35l.81,1.08,1.31-.35,2.8-.75,1.94-.52-.52-1.93L12.08,5.52l1.4-.37M14.16,3a1.06,1.06,0,0,0-.5,0l-3.09.83A1,1,0,0,0,9.89,5l2.5,9.36-2.81.75L6.85,11.5a1,1,0,0,0-.52-.36,1.06,1.06,0,0,0-.5,0L2.72,12A1,1,0,0,0,2,13.16L3,16.9l.75,2.8.25.94a3.87,3.87,0,0,0,2.74,2.74,3.91,3.91,0,0,0,2,0l18.7-5a3.84,3.84,0,0,0,0-7.44,4.27,4.27,0,0,0-2.16,0l-4.51,1.21L14.7,3.41A1,1,0,0,0,14.16,3Z"}),props.children);});var Departure24=/*#__PURE__*/React.forwardRef(function Departure24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M13.48,5.15l5.69,8.14.8,1.15,1.35-.36,4.52-1.21a2.13,2.13,0,0,1,1.12,0A1.84,1.84,0,0,1,28.23,14,1.87,1.87,0,0,1,27,16.45l-18.71,5a1.78,1.78,0,0,1-1,0A1.87,1.87,0,0,1,6,20.12l-.25-.93L5,16.38l-.74-2.74,1.44-.39L8,16.35l.81,1.08,1.31-.35,2.8-.75,1.94-.52-.52-1.93L12.08,5.52l1.4-.37M14.16,3a1.06,1.06,0,0,0-.5,0l-3.09.83A1,1,0,0,0,9.89,5l2.5,9.36-2.81.75L6.85,11.5a1,1,0,0,0-.52-.36,1.06,1.06,0,0,0-.5,0L2.72,12A1,1,0,0,0,2,13.16L3,16.9l.75,2.8.25.94a3.87,3.87,0,0,0,2.74,2.74,3.91,3.91,0,0,0,2,0l18.7-5a3.84,3.84,0,0,0,0-7.44,4.27,4.27,0,0,0-2.16,0l-4.51,1.21L14.7,3.41A1,1,0,0,0,14.16,3Z"}),props.children);});var Departure20=/*#__PURE__*/React.forwardRef(function Departure20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M13.48,5.15l5.69,8.14.8,1.15,1.35-.36,4.52-1.21a2.13,2.13,0,0,1,1.12,0A1.84,1.84,0,0,1,28.23,14,1.87,1.87,0,0,1,27,16.45l-18.71,5a1.78,1.78,0,0,1-1,0A1.87,1.87,0,0,1,6,20.12l-.25-.93L5,16.38l-.74-2.74,1.44-.39L8,16.35l.81,1.08,1.31-.35,2.8-.75,1.94-.52-.52-1.93L12.08,5.52l1.4-.37M14.16,3a1.06,1.06,0,0,0-.5,0l-3.09.83A1,1,0,0,0,9.89,5l2.5,9.36-2.81.75L6.85,11.5a1,1,0,0,0-.52-.36,1.06,1.06,0,0,0-.5,0L2.72,12A1,1,0,0,0,2,13.16L3,16.9l.75,2.8.25.94a3.87,3.87,0,0,0,2.74,2.74,3.91,3.91,0,0,0,2,0l18.7-5a3.84,3.84,0,0,0,0-7.44,4.27,4.27,0,0,0-2.16,0l-4.51,1.21L14.7,3.41A1,1,0,0,0,14.16,3Z"}),props.children);});var Departure16=/*#__PURE__*/React.forwardRef(function Departure16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M13.48,5.15l5.69,8.14.8,1.15,1.35-.36,4.52-1.21a2.13,2.13,0,0,1,1.12,0A1.84,1.84,0,0,1,28.23,14,1.87,1.87,0,0,1,27,16.45l-18.71,5a1.78,1.78,0,0,1-1,0A1.87,1.87,0,0,1,6,20.12l-.25-.93L5,16.38l-.74-2.74,1.44-.39L8,16.35l.81,1.08,1.31-.35,2.8-.75,1.94-.52-.52-1.93L12.08,5.52l1.4-.37M14.16,3a1.06,1.06,0,0,0-.5,0l-3.09.83A1,1,0,0,0,9.89,5l2.5,9.36-2.81.75L6.85,11.5a1,1,0,0,0-.52-.36,1.06,1.06,0,0,0-.5,0L2.72,12A1,1,0,0,0,2,13.16L3,16.9l.75,2.8.25.94a3.87,3.87,0,0,0,2.74,2.74,3.91,3.91,0,0,0,2,0l18.7-5a3.84,3.84,0,0,0,0-7.44,4.27,4.27,0,0,0-2.16,0l-4.51,1.21L14.7,3.41A1,1,0,0,0,14.16,3Z"}),props.children);});var DeployRules32=/*#__PURE__*/React.forwardRef(function DeployRules32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 4 12 10 13.41 11.41 17 7.83 17 20 19 20 19 7.83 22.59 11.41 24 10 18 4"}),React.createElement("rect",{width:"7",height:"2",x:"8",y:"18"}),React.createElement("rect",{width:"16",height:"2",x:"8",y:"22"}),React.createElement("rect",{width:"16",height:"2",x:"8",y:"26"}),props.children);});var DeployRules24=/*#__PURE__*/React.forwardRef(function DeployRules24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 4 12 10 13.41 11.41 17 7.83 17 20 19 20 19 7.83 22.59 11.41 24 10 18 4"}),React.createElement("rect",{width:"7",height:"2",x:"8",y:"18"}),React.createElement("rect",{width:"16",height:"2",x:"8",y:"22"}),React.createElement("rect",{width:"16",height:"2",x:"8",y:"26"}),props.children);});var DeployRules20=/*#__PURE__*/React.forwardRef(function DeployRules20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 4 12 10 13.41 11.41 17 7.83 17 20 19 20 19 7.83 22.59 11.41 24 10 18 4"}),React.createElement("rect",{width:"7",height:"2",x:"8",y:"18"}),React.createElement("rect",{width:"16",height:"2",x:"8",y:"22"}),React.createElement("rect",{width:"16",height:"2",x:"8",y:"26"}),props.children);});var DeployRules16=/*#__PURE__*/React.forwardRef(function DeployRules16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"18 4 12 10 13.41 11.41 17 7.83 17 20 19 20 19 7.83 22.59 11.41 24 10 18 4"}),React.createElement("rect",{width:"7",height:"2",x:"8",y:"18"}),React.createElement("rect",{width:"16",height:"2",x:"8",y:"22"}),React.createElement("rect",{width:"16",height:"2",x:"8",y:"26"}),props.children);});var Deploy32=/*#__PURE__*/React.forwardRef(function Deploy32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"13",cy:"19",r:"3"}),React.createElement("path",{d:"M23,2,17,8l1.4146,1.4024L22,5.8181V19a9,9,0,1,1-15.9956-5.663L4.4507,12.0779A11,11,0,1,0,24,19V5.8152l3.5859,3.5869L29,8Z"}),props.children);});var Deploy24=/*#__PURE__*/React.forwardRef(function Deploy24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"13",cy:"19",r:"3"}),React.createElement("path",{d:"M23,2,17,8l1.4146,1.4024L22,5.8181V19a9,9,0,1,1-15.9956-5.663L4.4507,12.0779A11,11,0,1,0,24,19V5.8152l3.5859,3.5869L29,8Z"}),props.children);});var Deploy20=/*#__PURE__*/React.forwardRef(function Deploy20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"13",cy:"19",r:"3"}),React.createElement("path",{d:"M23,2,17,8l1.4146,1.4024L22,5.8181V19a9,9,0,1,1-15.9956-5.663L4.4507,12.0779A11,11,0,1,0,24,19V5.8152l3.5859,3.5869L29,8Z"}),props.children);});var Deploy16=/*#__PURE__*/React.forwardRef(function Deploy16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"13",cy:"19",r:"3"}),React.createElement("path",{d:"M23,2,17,8l1.4146,1.4024L22,5.8181V19a9,9,0,1,1-15.9956-5.663L4.4507,12.0779A11,11,0,1,0,24,19V5.8152l3.5859,3.5869L29,8Z"}),props.children);});var Development32=/*#__PURE__*/React.forwardRef(function Development32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,4V8H4V4H8M2,2v8h8V2Z"}),React.createElement("path",{d:"M18,7v4H14V7h4M12,5v8h8V5Z"}),React.createElement("path",{d:"M8,16v4H4V16H8M2,14v8h8V14Z"}),React.createElement("path",{d:"M22,10v6H16v6H10v8H30V10Zm-4,8h4v4H18ZM16,28H12V24h4Zm6,0H18V24h4Zm6,0H24V24h4Zm0-6H24V18h4Zm-4-6V12h4v4Z"}),props.children);});var Development24=/*#__PURE__*/React.forwardRef(function Development24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,4V8H4V4H8M2,2v8h8V2Z"}),React.createElement("path",{d:"M18,7v4H14V7h4M12,5v8h8V5Z"}),React.createElement("path",{d:"M8,16v4H4V16H8M2,14v8h8V14Z"}),React.createElement("path",{d:"M22,10v6H16v6H10v8H30V10Zm-4,8h4v4H18ZM16,28H12V24h4Zm6,0H18V24h4Zm6,0H24V24h4Zm0-6H24V18h4Zm-4-6V12h4v4Z"}),props.children);});var Development20=/*#__PURE__*/React.forwardRef(function Development20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,4V8H4V4H8M2,2v8h8V2Z"}),React.createElement("path",{d:"M18,7v4H14V7h4M12,5v8h8V5Z"}),React.createElement("path",{d:"M8,16v4H4V16H8M2,14v8h8V14Z"}),React.createElement("path",{d:"M22,10v6H16v6H10v8H30V10Zm-4,8h4v4H18ZM16,28H12V24h4Zm6,0H18V24h4Zm6,0H24V24h4Zm0-6H24V18h4Zm-4-6V12h4v4Z"}),props.children);});var Development16=/*#__PURE__*/React.forwardRef(function Development16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8,4V8H4V4H8M2,2v8h8V2Z"}),React.createElement("path",{d:"M18,7v4H14V7h4M12,5v8h8V5Z"}),React.createElement("path",{d:"M8,16v4H4V16H8M2,14v8h8V14Z"}),React.createElement("path",{d:"M22,10v6H16v6H10v8H30V10Zm-4,8h4v4H18ZM16,28H12V24h4Zm6,0H18V24h4Zm6,0H24V24h4Zm0-6H24V18h4Zm-4-6V12h4v4Z"}),props.children);});var Devices32=/*#__PURE__*/React.forwardRef(function Devices32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,30H4a2,2,0,0,1-2-2V16a2,2,0,0,1,2-2h6a2,2,0,0,1,2,2V28A2,2,0,0,1,10,30ZM4,16V28h6V16Z"}),React.createElement("path",{d:"M28,4H6A2,2,0,0,0,4,6v6H6V6H28V20H14v2h2v4H14v2h9V26H18V22H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Z"}),props.children);});var Devices24=/*#__PURE__*/React.forwardRef(function Devices24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,30H4a2,2,0,0,1-2-2V16a2,2,0,0,1,2-2h6a2,2,0,0,1,2,2V28A2,2,0,0,1,10,30ZM4,16V28h6V16Z"}),React.createElement("path",{d:"M28,4H6A2,2,0,0,0,4,6v6H6V6H28V20H14v2h2v4H14v2h9V26H18V22H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Z"}),props.children);});var Devices20=/*#__PURE__*/React.forwardRef(function Devices20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,30H4a2,2,0,0,1-2-2V16a2,2,0,0,1,2-2h6a2,2,0,0,1,2,2V28A2,2,0,0,1,10,30ZM4,16V28h6V16Z"}),React.createElement("path",{d:"M28,4H6A2,2,0,0,0,4,6v6H6V6H28V20H14v2h2v4H14v2h9V26H18V22H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Z"}),props.children);});var Devices16=/*#__PURE__*/React.forwardRef(function Devices16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M10,30H4a2,2,0,0,1-2-2V16a2,2,0,0,1,2-2h6a2,2,0,0,1,2,2V28A2,2,0,0,1,10,30ZM4,16V28h6V16Z"}),React.createElement("path",{d:"M28,4H6A2,2,0,0,0,4,6v6H6V6H28V20H14v2h2v4H14v2h9V26H18V22H28a2,2,0,0,0,2-2V6A2,2,0,0,0,28,4Z"}),props.children);});var Diagram32=/*#__PURE__*/React.forwardRef(function Diagram32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,30A11,11,0,0,1,13,8a1,1,0,0,1,1,1v9h9a1,1,0,0,1,1,1A11,11,0,0,1,13,30ZM12,10.06A9,9,0,1,0,21.94,20H14a2,2,0,0,1-2-2Z"}),React.createElement("path",{d:"M28,14H19a2,2,0,0,1-2-2V3a1,1,0,0,1,1-1A11,11,0,0,1,29,13,1,1,0,0,1,28,14Zm-9-2h7.94A9,9,0,0,0,19,4.06Z"}),props.children);});var Diagram24=/*#__PURE__*/React.forwardRef(function Diagram24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,30A11,11,0,0,1,13,8a1,1,0,0,1,1,1v9h9a1,1,0,0,1,1,1A11,11,0,0,1,13,30ZM12,10.06A9,9,0,1,0,21.94,20H14a2,2,0,0,1-2-2Z"}),React.createElement("path",{d:"M28,14H19a2,2,0,0,1-2-2V3a1,1,0,0,1,1-1A11,11,0,0,1,29,13,1,1,0,0,1,28,14Zm-9-2h7.94A9,9,0,0,0,19,4.06Z"}),props.children);});var Diagram20=/*#__PURE__*/React.forwardRef(function Diagram20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,30A11,11,0,0,1,13,8a1,1,0,0,1,1,1v9h9a1,1,0,0,1,1,1A11,11,0,0,1,13,30ZM12,10.06A9,9,0,1,0,21.94,20H14a2,2,0,0,1-2-2Z"}),React.createElement("path",{d:"M28,14H19a2,2,0,0,1-2-2V3a1,1,0,0,1,1-1A11,11,0,0,1,29,13,1,1,0,0,1,28,14Zm-9-2h7.94A9,9,0,0,0,19,4.06Z"}),props.children);});var Diagram16=/*#__PURE__*/React.forwardRef(function Diagram16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M13,30A11,11,0,0,1,13,8a1,1,0,0,1,1,1v9h9a1,1,0,0,1,1,1A11,11,0,0,1,13,30ZM12,10.06A9,9,0,1,0,21.94,20H14a2,2,0,0,1-2-2Z"}),React.createElement("path",{d:"M28,14H19a2,2,0,0,1-2-2V3a1,1,0,0,1,1-1A11,11,0,0,1,29,13,1,1,0,0,1,28,14Zm-9-2h7.94A9,9,0,0,0,19,4.06Z"}),props.children);});var DistributeHorizontalCenter32=/*#__PURE__*/React.forwardRef(function DistributeHorizontalCenter32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,10H23V2H21v8H20a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2h1v8h2V22h1a2.0023,2.0023,0,0,0,2-2V12A2.0023,2.0023,0,0,0,24,10Zm0,10H20V12h4Z"}),React.createElement("path",{d:"M12,6H11V2H9V6H8A2.0023,2.0023,0,0,0,6,8V24a2.0023,2.0023,0,0,0,2,2H9v4h2V26h1a2.0023,2.0023,0,0,0,2-2V8A2.0023,2.0023,0,0,0,12,6Zm0,18H8V8h4Z"}),props.children);});var DistributeHorizontalCenter24=/*#__PURE__*/React.forwardRef(function DistributeHorizontalCenter24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,10H23V2H21v8H20a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2h1v8h2V22h1a2.0023,2.0023,0,0,0,2-2V12A2.0023,2.0023,0,0,0,24,10Zm0,10H20V12h4Z"}),React.createElement("path",{d:"M12,6H11V2H9V6H8A2.0023,2.0023,0,0,0,6,8V24a2.0023,2.0023,0,0,0,2,2H9v4h2V26h1a2.0023,2.0023,0,0,0,2-2V8A2.0023,2.0023,0,0,0,12,6Zm0,18H8V8h4Z"}),props.children);});var DistributeHorizontalCenter20=/*#__PURE__*/React.forwardRef(function DistributeHorizontalCenter20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,10H23V2H21v8H20a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2h1v8h2V22h1a2.0023,2.0023,0,0,0,2-2V12A2.0023,2.0023,0,0,0,24,10Zm0,10H20V12h4Z"}),React.createElement("path",{d:"M12,6H11V2H9V6H8A2.0023,2.0023,0,0,0,6,8V24a2.0023,2.0023,0,0,0,2,2H9v4h2V26h1a2.0023,2.0023,0,0,0,2-2V8A2.0023,2.0023,0,0,0,12,6Zm0,18H8V8h4Z"}),props.children);});var DistributeHorizontalCenter16=/*#__PURE__*/React.forwardRef(function DistributeHorizontalCenter16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,10H23V2H21v8H20a2.0023,2.0023,0,0,0-2,2v8a2.0023,2.0023,0,0,0,2,2h1v8h2V22h1a2.0023,2.0023,0,0,0,2-2V12A2.0023,2.0023,0,0,0,24,10Zm0,10H20V12h4Z"}),React.createElement("path",{d:"M12,6H11V2H9V6H8A2.0023,2.0023,0,0,0,6,8V24a2.0023,2.0023,0,0,0,2,2H9v4h2V26h1a2.0023,2.0023,0,0,0,2-2V8A2.0023,2.0023,0,0,0,12,6Zm0,18H8V8h4Z"}),props.children);});var DistributeHorizontalLeft32=/*#__PURE__*/React.forwardRef(function DistributeHorizontalLeft32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,22H24a2.0021,2.0021,0,0,1-2-2V12a2.0021,2.0021,0,0,1,2-2h4a2.0021,2.0021,0,0,1,2,2v8A2.0021,2.0021,0,0,1,28,22ZM24,12v8h4V12Z"}),React.createElement("rect",{width:"2",height:"28",x:"18",y:"2"}),React.createElement("path",{d:"M12,26H8a2.0021,2.0021,0,0,1-2-2V8A2.0021,2.0021,0,0,1,8,6h4a2.0021,2.0021,0,0,1,2,2V24A2.0021,2.0021,0,0,1,12,26ZM8,8V24h4V8Z"}),React.createElement("rect",{width:"2",height:"28",x:"2",y:"2"}),props.children);});var DistributeHorizontalLeft24=/*#__PURE__*/React.forwardRef(function DistributeHorizontalLeft24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,22H24a2.0021,2.0021,0,0,1-2-2V12a2.0021,2.0021,0,0,1,2-2h4a2.0021,2.0021,0,0,1,2,2v8A2.0021,2.0021,0,0,1,28,22ZM24,12v8h4V12Z"}),React.createElement("rect",{width:"2",height:"28",x:"18",y:"2"}),React.createElement("path",{d:"M12,26H8a2.0021,2.0021,0,0,1-2-2V8A2.0021,2.0021,0,0,1,8,6h4a2.0021,2.0021,0,0,1,2,2V24A2.0021,2.0021,0,0,1,12,26ZM8,8V24h4V8Z"}),React.createElement("rect",{width:"2",height:"28",x:"2",y:"2"}),props.children);});var DistributeHorizontalLeft20=/*#__PURE__*/React.forwardRef(function DistributeHorizontalLeft20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,22H24a2.0021,2.0021,0,0,1-2-2V12a2.0021,2.0021,0,0,1,2-2h4a2.0021,2.0021,0,0,1,2,2v8A2.0021,2.0021,0,0,1,28,22ZM24,12v8h4V12Z"}),React.createElement("rect",{width:"2",height:"28",x:"18",y:"2"}),React.createElement("path",{d:"M12,26H8a2.0021,2.0021,0,0,1-2-2V8A2.0021,2.0021,0,0,1,8,6h4a2.0021,2.0021,0,0,1,2,2V24A2.0021,2.0021,0,0,1,12,26ZM8,8V24h4V8Z"}),React.createElement("rect",{width:"2",height:"28",x:"2",y:"2"}),props.children);});var DistributeHorizontalLeft16=/*#__PURE__*/React.forwardRef(function DistributeHorizontalLeft16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,22H24a2.0021,2.0021,0,0,1-2-2V12a2.0021,2.0021,0,0,1,2-2h4a2.0021,2.0021,0,0,1,2,2v8A2.0021,2.0021,0,0,1,28,22ZM24,12v8h4V12Z"}),React.createElement("rect",{width:"2",height:"28",x:"18",y:"2"}),React.createElement("path",{d:"M12,26H8a2.0021,2.0021,0,0,1-2-2V8A2.0021,2.0021,0,0,1,8,6h4a2.0021,2.0021,0,0,1,2,2V24A2.0021,2.0021,0,0,1,12,26ZM8,8V24h4V8Z"}),React.createElement("rect",{width:"2",height:"28",x:"2",y:"2"}),props.children);});var DistributeHorizontalRight32=/*#__PURE__*/React.forwardRef(function DistributeHorizontalRight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"28",x:"28",y:"2"}),React.createElement("path",{d:"M24,22H20a2.0021,2.0021,0,0,1-2-2V12a2.0021,2.0021,0,0,1,2-2h4a2.0021,2.0021,0,0,1,2,2v8A2.0021,2.0021,0,0,1,24,22ZM20,12h-.0015L20,20h4V12Z"}),React.createElement("rect",{width:"2",height:"28",x:"12",y:"2"}),React.createElement("path",{d:"M8,26H4a2.0021,2.0021,0,0,1-2-2V8A2.0021,2.0021,0,0,1,4,6H8a2.0021,2.0021,0,0,1,2,2V24A2.0021,2.0021,0,0,1,8,26ZM4,8H3.9985L4,24H8V8Z"}),props.children);});var DistributeHorizontalRight24=/*#__PURE__*/React.forwardRef(function DistributeHorizontalRight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"28",x:"28",y:"2"}),React.createElement("path",{d:"M24,22H20a2.0021,2.0021,0,0,1-2-2V12a2.0021,2.0021,0,0,1,2-2h4a2.0021,2.0021,0,0,1,2,2v8A2.0021,2.0021,0,0,1,24,22ZM20,12h-.0015L20,20h4V12Z"}),React.createElement("rect",{width:"2",height:"28",x:"12",y:"2"}),React.createElement("path",{d:"M8,26H4a2.0021,2.0021,0,0,1-2-2V8A2.0021,2.0021,0,0,1,4,6H8a2.0021,2.0021,0,0,1,2,2V24A2.0021,2.0021,0,0,1,8,26ZM4,8H3.9985L4,24H8V8Z"}),props.children);});var DistributeHorizontalRight20=/*#__PURE__*/React.forwardRef(function DistributeHorizontalRight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"28",x:"28",y:"2"}),React.createElement("path",{d:"M24,22H20a2.0021,2.0021,0,0,1-2-2V12a2.0021,2.0021,0,0,1,2-2h4a2.0021,2.0021,0,0,1,2,2v8A2.0021,2.0021,0,0,1,24,22ZM20,12h-.0015L20,20h4V12Z"}),React.createElement("rect",{width:"2",height:"28",x:"12",y:"2"}),React.createElement("path",{d:"M8,26H4a2.0021,2.0021,0,0,1-2-2V8A2.0021,2.0021,0,0,1,4,6H8a2.0021,2.0021,0,0,1,2,2V24A2.0021,2.0021,0,0,1,8,26ZM4,8H3.9985L4,24H8V8Z"}),props.children);});var DistributeHorizontalRight16=/*#__PURE__*/React.forwardRef(function DistributeHorizontalRight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"28",x:"28",y:"2"}),React.createElement("path",{d:"M24,22H20a2.0021,2.0021,0,0,1-2-2V12a2.0021,2.0021,0,0,1,2-2h4a2.0021,2.0021,0,0,1,2,2v8A2.0021,2.0021,0,0,1,24,22ZM20,12h-.0015L20,20h4V12Z"}),React.createElement("rect",{width:"2",height:"28",x:"12",y:"2"}),React.createElement("path",{d:"M8,26H4a2.0021,2.0021,0,0,1-2-2V8A2.0021,2.0021,0,0,1,4,6H8a2.0021,2.0021,0,0,1,2,2V24A2.0021,2.0021,0,0,1,8,26ZM4,8H3.9985L4,24H8V8Z"}),props.children);});var DistributeVerticalBottom32=/*#__PURE__*/React.forwardRef(function DistributeVerticalBottom32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M24,26H8a2.0021,2.0021,0,0,1-2-2V20a2.0021,2.0021,0,0,1,2-2H24a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,24,26Zm0-6.0012L8,20v4H24Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"12"}),React.createElement("path",{d:"M20,10H12a2.0021,2.0021,0,0,1-2-2V4a2.0021,2.0021,0,0,1,2-2h8a2.0021,2.0021,0,0,1,2,2V8A2.0021,2.0021,0,0,1,20,10Zm0-6.0012L12,4V8h8Z"}),props.children);});var DistributeVerticalBottom24=/*#__PURE__*/React.forwardRef(function DistributeVerticalBottom24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M24,26H8a2.0021,2.0021,0,0,1-2-2V20a2.0021,2.0021,0,0,1,2-2H24a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,24,26Zm0-6.0012L8,20v4H24Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"12"}),React.createElement("path",{d:"M20,10H12a2.0021,2.0021,0,0,1-2-2V4a2.0021,2.0021,0,0,1,2-2h8a2.0021,2.0021,0,0,1,2,2V8A2.0021,2.0021,0,0,1,20,10Zm0-6.0012L12,4V8h8Z"}),props.children);});var DistributeVerticalBottom20=/*#__PURE__*/React.forwardRef(function DistributeVerticalBottom20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M24,26H8a2.0021,2.0021,0,0,1-2-2V20a2.0021,2.0021,0,0,1,2-2H24a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,24,26Zm0-6.0012L8,20v4H24Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"12"}),React.createElement("path",{d:"M20,10H12a2.0021,2.0021,0,0,1-2-2V4a2.0021,2.0021,0,0,1,2-2h8a2.0021,2.0021,0,0,1,2,2V8A2.0021,2.0021,0,0,1,20,10Zm0-6.0012L12,4V8h8Z"}),props.children);});var DistributeVerticalBottom16=/*#__PURE__*/React.forwardRef(function DistributeVerticalBottom16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M24,26H8a2.0021,2.0021,0,0,1-2-2V20a2.0021,2.0021,0,0,1,2-2H24a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,24,26Zm0-6.0012L8,20v4H24Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"12"}),React.createElement("path",{d:"M20,10H12a2.0021,2.0021,0,0,1-2-2V4a2.0021,2.0021,0,0,1,2-2h8a2.0021,2.0021,0,0,1,2,2V8A2.0021,2.0021,0,0,1,20,10Zm0-6.0012L12,4V8h8Z"}),props.children);});var DistributeVerticalCenter32=/*#__PURE__*/React.forwardRef(function DistributeVerticalCenter32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,21H26V20a2.0023,2.0023,0,0,0-2-2H8a2.0023,2.0023,0,0,0-2,2v1H2v2H6v1a2.0023,2.0023,0,0,0,2,2H24a2.0023,2.0023,0,0,0,2-2V23h4Zm-6,3H8V20l16-.001Z"}),React.createElement("path",{d:"M30,9H22V8a2.0023,2.0023,0,0,0-2-2H12a2.0023,2.0023,0,0,0-2,2V9H2v2h8v1a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V11h8ZM20,12H12V8l8-.001Z"}),props.children);});var DistributeVerticalCenter24=/*#__PURE__*/React.forwardRef(function DistributeVerticalCenter24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,21H26V20a2.0023,2.0023,0,0,0-2-2H8a2.0023,2.0023,0,0,0-2,2v1H2v2H6v1a2.0023,2.0023,0,0,0,2,2H24a2.0023,2.0023,0,0,0,2-2V23h4Zm-6,3H8V20l16-.001Z"}),React.createElement("path",{d:"M30,9H22V8a2.0023,2.0023,0,0,0-2-2H12a2.0023,2.0023,0,0,0-2,2V9H2v2h8v1a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V11h8ZM20,12H12V8l8-.001Z"}),props.children);});var DistributeVerticalCenter20=/*#__PURE__*/React.forwardRef(function DistributeVerticalCenter20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,21H26V20a2.0023,2.0023,0,0,0-2-2H8a2.0023,2.0023,0,0,0-2,2v1H2v2H6v1a2.0023,2.0023,0,0,0,2,2H24a2.0023,2.0023,0,0,0,2-2V23h4Zm-6,3H8V20l16-.001Z"}),React.createElement("path",{d:"M30,9H22V8a2.0023,2.0023,0,0,0-2-2H12a2.0023,2.0023,0,0,0-2,2V9H2v2h8v1a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V11h8ZM20,12H12V8l8-.001Z"}),props.children);});var DistributeVerticalCenter16=/*#__PURE__*/React.forwardRef(function DistributeVerticalCenter16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,21H26V20a2.0023,2.0023,0,0,0-2-2H8a2.0023,2.0023,0,0,0-2,2v1H2v2H6v1a2.0023,2.0023,0,0,0,2,2H24a2.0023,2.0023,0,0,0,2-2V23h4Zm-6,3H8V20l16-.001Z"}),React.createElement("path",{d:"M30,9H22V8a2.0023,2.0023,0,0,0-2-2H12a2.0023,2.0023,0,0,0-2,2V9H2v2h8v1a2.0023,2.0023,0,0,0,2,2h8a2.0023,2.0023,0,0,0,2-2V11h8ZM20,12H12V8l8-.001Z"}),props.children);});var DistributeVerticalTop32=/*#__PURE__*/React.forwardRef(function DistributeVerticalTop32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,30H8a2.0021,2.0021,0,0,1-2-2V24a2.0021,2.0021,0,0,1,2-2H24a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,24,30ZM8,24v4H24V24Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"18"}),React.createElement("path",{d:"M20,14H12a2.0021,2.0021,0,0,1-2-2V8a2.0021,2.0021,0,0,1,2-2h8a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,20,14ZM12,8v4h8V8Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"2"}),props.children);});var DistributeVerticalTop24=/*#__PURE__*/React.forwardRef(function DistributeVerticalTop24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,30H8a2.0021,2.0021,0,0,1-2-2V24a2.0021,2.0021,0,0,1,2-2H24a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,24,30ZM8,24v4H24V24Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"18"}),React.createElement("path",{d:"M20,14H12a2.0021,2.0021,0,0,1-2-2V8a2.0021,2.0021,0,0,1,2-2h8a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,20,14ZM12,8v4h8V8Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"2"}),props.children);});var DistributeVerticalTop20=/*#__PURE__*/React.forwardRef(function DistributeVerticalTop20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,30H8a2.0021,2.0021,0,0,1-2-2V24a2.0021,2.0021,0,0,1,2-2H24a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,24,30ZM8,24v4H24V24Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"18"}),React.createElement("path",{d:"M20,14H12a2.0021,2.0021,0,0,1-2-2V8a2.0021,2.0021,0,0,1,2-2h8a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,20,14ZM12,8v4h8V8Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"2"}),props.children);});var DistributeVerticalTop16=/*#__PURE__*/React.forwardRef(function DistributeVerticalTop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,30H8a2.0021,2.0021,0,0,1-2-2V24a2.0021,2.0021,0,0,1,2-2H24a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,24,30ZM8,24v4H24V24Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"18"}),React.createElement("path",{d:"M20,14H12a2.0021,2.0021,0,0,1-2-2V8a2.0021,2.0021,0,0,1,2-2h8a2.0021,2.0021,0,0,1,2,2v4A2.0021,2.0021,0,0,1,20,14ZM12,8v4h8V8Z"}),React.createElement("rect",{width:"28",height:"2",x:"2",y:"2"}),props.children);});var DocumentAdd32=/*#__PURE__*/React.forwardRef(function DocumentAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.91.91,0,0,0,18,2H8A2,2,0,0,0,6,4V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V10A.91.91,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2,2,0,0,0,2,2h6Z"}),React.createElement("polygon",{points:"21 19 17 19 17 15 15 15 15 19 11 19 11 21 15 21 15 25 17 25 17 21 21 21 21 19"}),props.children);});var DocumentAdd24=/*#__PURE__*/React.forwardRef(function DocumentAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.91.91,0,0,0,18,2H8A2,2,0,0,0,6,4V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V10A.91.91,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2,2,0,0,0,2,2h6Z"}),React.createElement("polygon",{points:"21 19 17 19 17 15 15 15 15 19 11 19 11 21 15 21 15 25 17 25 17 21 21 21 21 19"}),props.children);});var DocumentAdd20=/*#__PURE__*/React.forwardRef(function DocumentAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.91.91,0,0,0,18,2H8A2,2,0,0,0,6,4V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V10A.91.91,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2,2,0,0,0,2,2h6Z"}),React.createElement("polygon",{points:"21 19 17 19 17 15 15 15 15 19 11 19 11 21 15 21 15 25 17 25 17 21 21 21 21 19"}),props.children);});var DocumentAdd16=/*#__PURE__*/React.forwardRef(function DocumentAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.91.91,0,0,0,18,2H8A2,2,0,0,0,6,4V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V10A.91.91,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2,2,0,0,0,2,2h6Z"}),React.createElement("polygon",{points:"21 19 17 19 17 15 15 15 15 19 11 19 11 21 15 21 15 25 17 25 17 21 21 21 21 19"}),props.children);});var DocumentBlank32=/*#__PURE__*/React.forwardRef(function DocumentBlank32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.9078.9078,0,0,0,18,2H8A2.0059,2.0059,0,0,0,6,4V28a2.0059,2.0059,0,0,0,2,2H24a2.0059,2.0059,0,0,0,2-2V10A.9078.9078,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2.0059,2.0059,0,0,0,2,2h6Z"}),props.children);});var DocumentBlank24=/*#__PURE__*/React.forwardRef(function DocumentBlank24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.9078.9078,0,0,0,18,2H8A2.0059,2.0059,0,0,0,6,4V28a2.0059,2.0059,0,0,0,2,2H24a2.0059,2.0059,0,0,0,2-2V10A.9078.9078,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2.0059,2.0059,0,0,0,2,2h6Z"}),props.children);});var DocumentBlank20=/*#__PURE__*/React.forwardRef(function DocumentBlank20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.9078.9078,0,0,0,18,2H8A2.0059,2.0059,0,0,0,6,4V28a2.0059,2.0059,0,0,0,2,2H24a2.0059,2.0059,0,0,0,2-2V10A.9078.9078,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2.0059,2.0059,0,0,0,2,2h6Z"}),props.children);});var DocumentBlank16=/*#__PURE__*/React.forwardRef(function DocumentBlank16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.9078.9078,0,0,0,18,2H8A2.0059,2.0059,0,0,0,6,4V28a2.0059,2.0059,0,0,0,2,2H24a2.0059,2.0059,0,0,0,2-2V10A.9078.9078,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2.0059,2.0059,0,0,0,2,2h6Z"}),props.children);});var DocumentDownload32=/*#__PURE__*/React.forwardRef(function DocumentDownload32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 25 28.586 23.586 26 26.172 26 18 24 18 24 26.172 21.414 23.586 20 25 25 30 30 25"}),React.createElement("path",{d:"M18,28H8V4h8v6a2.0058,2.0058,0,0,0,2,2h6v3l2,0V10a.9092.9092,0,0,0-.3-.7l-7-7A.9087.9087,0,0,0,18,2H8A2.0058,2.0058,0,0,0,6,4V28a2.0058,2.0058,0,0,0,2,2H18ZM18,4.4,23.6,10H18Z"}),props.children);});var DocumentDownload24=/*#__PURE__*/React.forwardRef(function DocumentDownload24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 25 28.586 23.586 26 26.172 26 18 24 18 24 26.172 21.414 23.586 20 25 25 30 30 25"}),React.createElement("path",{d:"M18,28H8V4h8v6a2.0058,2.0058,0,0,0,2,2h6v3l2,0V10a.9092.9092,0,0,0-.3-.7l-7-7A.9087.9087,0,0,0,18,2H8A2.0058,2.0058,0,0,0,6,4V28a2.0058,2.0058,0,0,0,2,2H18ZM18,4.4,23.6,10H18Z"}),props.children);});var DocumentDownload20=/*#__PURE__*/React.forwardRef(function DocumentDownload20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 25 28.586 23.586 26 26.172 26 18 24 18 24 26.172 21.414 23.586 20 25 25 30 30 25"}),React.createElement("path",{d:"M18,28H8V4h8v6a2.0058,2.0058,0,0,0,2,2h6v3l2,0V10a.9092.9092,0,0,0-.3-.7l-7-7A.9087.9087,0,0,0,18,2H8A2.0058,2.0058,0,0,0,6,4V28a2.0058,2.0058,0,0,0,2,2H18ZM18,4.4,23.6,10H18Z"}),props.children);});var DocumentDownload16=/*#__PURE__*/React.forwardRef(function DocumentDownload16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 25 28.586 23.586 26 26.172 26 18 24 18 24 26.172 21.414 23.586 20 25 25 30 30 25"}),React.createElement("path",{d:"M18,28H8V4h8v6a2.0058,2.0058,0,0,0,2,2h6v3l2,0V10a.9092.9092,0,0,0-.3-.7l-7-7A.9087.9087,0,0,0,18,2H8A2.0058,2.0058,0,0,0,6,4V28a2.0058,2.0058,0,0,0,2,2H18ZM18,4.4,23.6,10H18Z"}),props.children);});var DocumentExport32=/*#__PURE__*/React.forwardRef(function DocumentExport32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"13 21 26.17 21 23.59 23.59 25 25 30 20 25 15 23.59 16.41 26.17 19 13 19 13 21"}),React.createElement("path",{d:"M22,14V10a1,1,0,0,0-.29-.71l-7-7A1,1,0,0,0,14,2H4A2,2,0,0,0,2,4V28a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V26H20v2H4V4h8v6a2,2,0,0,0,2,2h6v2Zm-8-4V4.41L19.59,10Z"}),props.children);});var DocumentExport24=/*#__PURE__*/React.forwardRef(function DocumentExport24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"13 21 26.17 21 23.59 23.59 25 25 30 20 25 15 23.59 16.41 26.17 19 13 19 13 21"}),React.createElement("path",{d:"M22,14V10a1,1,0,0,0-.29-.71l-7-7A1,1,0,0,0,14,2H4A2,2,0,0,0,2,4V28a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V26H20v2H4V4h8v6a2,2,0,0,0,2,2h6v2Zm-8-4V4.41L19.59,10Z"}),props.children);});var DocumentExport20=/*#__PURE__*/React.forwardRef(function DocumentExport20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"13 21 26.17 21 23.59 23.59 25 25 30 20 25 15 23.59 16.41 26.17 19 13 19 13 21"}),React.createElement("path",{d:"M22,14V10a1,1,0,0,0-.29-.71l-7-7A1,1,0,0,0,14,2H4A2,2,0,0,0,2,4V28a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V26H20v2H4V4h8v6a2,2,0,0,0,2,2h6v2Zm-8-4V4.41L19.59,10Z"}),props.children);});var DocumentExport16=/*#__PURE__*/React.forwardRef(function DocumentExport16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"13 21 26.17 21 23.59 23.59 25 25 30 20 25 15 23.59 16.41 26.17 19 13 19 13 21"}),React.createElement("path",{d:"M22,14V10a1,1,0,0,0-.29-.71l-7-7A1,1,0,0,0,14,2H4A2,2,0,0,0,2,4V28a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V26H20v2H4V4h8v6a2,2,0,0,0,2,2h6v2Zm-8-4V4.41L19.59,10Z"}),props.children);});var DocumentImport32=/*#__PURE__*/React.forwardRef(function DocumentImport32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 19 14.83 19 17.41 16.41 16 15 11 20 16 25 17.41 23.59 14.83 21 28 21 28 19"}),React.createElement("path",{d:"M24,14V10a1,1,0,0,0-.29-.71l-7-7A1,1,0,0,0,16,2H6A2,2,0,0,0,4,4V28a2,2,0,0,0,2,2H22a2,2,0,0,0,2-2V26H22v2H6V4h8v6a2,2,0,0,0,2,2h6v2Zm-8-4V4.41L21.59,10Z"}),props.children);});var DocumentImport24=/*#__PURE__*/React.forwardRef(function DocumentImport24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 19 14.83 19 17.41 16.41 16 15 11 20 16 25 17.41 23.59 14.83 21 28 21 28 19"}),React.createElement("path",{d:"M24,14V10a1,1,0,0,0-.29-.71l-7-7A1,1,0,0,0,16,2H6A2,2,0,0,0,4,4V28a2,2,0,0,0,2,2H22a2,2,0,0,0,2-2V26H22v2H6V4h8v6a2,2,0,0,0,2,2h6v2Zm-8-4V4.41L21.59,10Z"}),props.children);});var DocumentImport20=/*#__PURE__*/React.forwardRef(function DocumentImport20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 19 14.83 19 17.41 16.41 16 15 11 20 16 25 17.41 23.59 14.83 21 28 21 28 19"}),React.createElement("path",{d:"M24,14V10a1,1,0,0,0-.29-.71l-7-7A1,1,0,0,0,16,2H6A2,2,0,0,0,4,4V28a2,2,0,0,0,2,2H22a2,2,0,0,0,2-2V26H22v2H6V4h8v6a2,2,0,0,0,2,2h6v2Zm-8-4V4.41L21.59,10Z"}),props.children);});var DocumentImport16=/*#__PURE__*/React.forwardRef(function DocumentImport16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"28 19 14.83 19 17.41 16.41 16 15 11 20 16 25 17.41 23.59 14.83 21 28 21 28 19"}),React.createElement("path",{d:"M24,14V10a1,1,0,0,0-.29-.71l-7-7A1,1,0,0,0,16,2H6A2,2,0,0,0,4,4V28a2,2,0,0,0,2,2H22a2,2,0,0,0,2-2V26H22v2H6V4h8v6a2,2,0,0,0,2,2h6v2Zm-8-4V4.41L21.59,10Z"}),props.children);});var DocumentPdf32=/*#__PURE__*/React.forwardRef(function DocumentPdf32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 18 30 16 24 16 24 26 26 26 26 22 29 22 29 20 26 20 26 18 30 18"}),React.createElement("path",{d:"M19,26H15V16h4a3.0033,3.0033,0,0,1,3,3v4A3.0033,3.0033,0,0,1,19,26Zm-2-2h2a1.0011,1.0011,0,0,0,1-1V19a1.0011,1.0011,0,0,0-1-1H17Z"}),React.createElement("path",{d:"M11,16H6V26H8V23h3a2.0027,2.0027,0,0,0,2-2V18A2.0023,2.0023,0,0,0,11,16ZM8,21V18h3l.001,3Z"}),React.createElement("path",{d:"M22,14V10a.9092.9092,0,0,0-.3-.7l-7-7A.9087.9087,0,0,0,14,2H4A2.0059,2.0059,0,0,0,2,4V28a2,2,0,0,0,2,2H20V28H4V4h8v6a2.0059,2.0059,0,0,0,2,2h6v2Zm-8-4V4.4L19.6,10Z"}),props.children);});var DocumentPdf24=/*#__PURE__*/React.forwardRef(function DocumentPdf24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 18 30 16 24 16 24 26 26 26 26 22 29 22 29 20 26 20 26 18 30 18"}),React.createElement("path",{d:"M19,26H15V16h4a3.0033,3.0033,0,0,1,3,3v4A3.0033,3.0033,0,0,1,19,26Zm-2-2h2a1.0011,1.0011,0,0,0,1-1V19a1.0011,1.0011,0,0,0-1-1H17Z"}),React.createElement("path",{d:"M11,16H6V26H8V23h3a2.0027,2.0027,0,0,0,2-2V18A2.0023,2.0023,0,0,0,11,16ZM8,21V18h3l.001,3Z"}),React.createElement("path",{d:"M22,14V10a.9092.9092,0,0,0-.3-.7l-7-7A.9087.9087,0,0,0,14,2H4A2.0059,2.0059,0,0,0,2,4V28a2,2,0,0,0,2,2H20V28H4V4h8v6a2.0059,2.0059,0,0,0,2,2h6v2Zm-8-4V4.4L19.6,10Z"}),props.children);});var DocumentPdf20=/*#__PURE__*/React.forwardRef(function DocumentPdf20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 18 30 16 24 16 24 26 26 26 26 22 29 22 29 20 26 20 26 18 30 18"}),React.createElement("path",{d:"M19,26H15V16h4a3.0033,3.0033,0,0,1,3,3v4A3.0033,3.0033,0,0,1,19,26Zm-2-2h2a1.0011,1.0011,0,0,0,1-1V19a1.0011,1.0011,0,0,0-1-1H17Z"}),React.createElement("path",{d:"M11,16H6V26H8V23h3a2.0027,2.0027,0,0,0,2-2V18A2.0023,2.0023,0,0,0,11,16ZM8,21V18h3l.001,3Z"}),React.createElement("path",{d:"M22,14V10a.9092.9092,0,0,0-.3-.7l-7-7A.9087.9087,0,0,0,14,2H4A2.0059,2.0059,0,0,0,2,4V28a2,2,0,0,0,2,2H20V28H4V4h8v6a2.0059,2.0059,0,0,0,2,2h6v2Zm-8-4V4.4L19.6,10Z"}),props.children);});var DocumentPdf16=/*#__PURE__*/React.forwardRef(function DocumentPdf16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 18 30 16 24 16 24 26 26 26 26 22 29 22 29 20 26 20 26 18 30 18"}),React.createElement("path",{d:"M19,26H15V16h4a3.0033,3.0033,0,0,1,3,3v4A3.0033,3.0033,0,0,1,19,26Zm-2-2h2a1.0011,1.0011,0,0,0,1-1V19a1.0011,1.0011,0,0,0-1-1H17Z"}),React.createElement("path",{d:"M11,16H6V26H8V23h3a2.0027,2.0027,0,0,0,2-2V18A2.0023,2.0023,0,0,0,11,16ZM8,21V18h3l.001,3Z"}),React.createElement("path",{d:"M22,14V10a.9092.9092,0,0,0-.3-.7l-7-7A.9087.9087,0,0,0,14,2H4A2.0059,2.0059,0,0,0,2,4V28a2,2,0,0,0,2,2H20V28H4V4h8v6a2.0059,2.0059,0,0,0,2,2h6v2Zm-8-4V4.4L19.6,10Z"}),props.children);});var DocumentSubtract32=/*#__PURE__*/React.forwardRef(function DocumentSubtract32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.91.91,0,0,0,18,2H8A2,2,0,0,0,6,4V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V10A.91.91,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2,2,0,0,0,2,2h6Z"}),React.createElement("rect",{width:"10",height:"2",x:"11",y:"19"}),props.children);});var DocumentSubtract24=/*#__PURE__*/React.forwardRef(function DocumentSubtract24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.91.91,0,0,0,18,2H8A2,2,0,0,0,6,4V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V10A.91.91,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2,2,0,0,0,2,2h6Z"}),React.createElement("rect",{width:"10",height:"2",x:"11",y:"19"}),props.children);});var DocumentSubtract20=/*#__PURE__*/React.forwardRef(function DocumentSubtract20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.91.91,0,0,0,18,2H8A2,2,0,0,0,6,4V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V10A.91.91,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2,2,0,0,0,2,2h6Z"}),React.createElement("rect",{width:"10",height:"2",x:"11",y:"19"}),props.children);});var DocumentSubtract16=/*#__PURE__*/React.forwardRef(function DocumentSubtract16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.91.91,0,0,0,18,2H8A2,2,0,0,0,6,4V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V10A.91.91,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2,2,0,0,0,2,2h6Z"}),React.createElement("rect",{width:"10",height:"2",x:"11",y:"19"}),props.children);});var DocumentTasks32=/*#__PURE__*/React.forwardRef(function DocumentTasks32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.91.91,0,0,0,18,2H8A2,2,0,0,0,6,4V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V10A.91.91,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2,2,0,0,0,2,2h6Z"}),React.createElement("polygon",{points:"14 22.18 11.41 19.59 10 21 14 25 22 17 20.59 15.59 14 22.18"}),props.children);});var DocumentTasks24=/*#__PURE__*/React.forwardRef(function DocumentTasks24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.91.91,0,0,0,18,2H8A2,2,0,0,0,6,4V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V10A.91.91,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2,2,0,0,0,2,2h6Z"}),React.createElement("polygon",{points:"14 22.18 11.41 19.59 10 21 14 25 22 17 20.59 15.59 14 22.18"}),props.children);});var DocumentTasks20=/*#__PURE__*/React.forwardRef(function DocumentTasks20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.91.91,0,0,0,18,2H8A2,2,0,0,0,6,4V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V10A.91.91,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2,2,0,0,0,2,2h6Z"}),React.createElement("polygon",{points:"14 22.18 11.41 19.59 10 21 14 25 22 17 20.59 15.59 14 22.18"}),props.children);});var DocumentTasks16=/*#__PURE__*/React.forwardRef(function DocumentTasks16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7A.91.91,0,0,0,18,2H8A2,2,0,0,0,6,4V28a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2V10A.91.91,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2,2,0,0,0,2,2h6Z"}),React.createElement("polygon",{points:"14 22.18 11.41 19.59 10 21 14 25 22 17 20.59 15.59 14 22.18"}),props.children);});var DocumentView32=/*#__PURE__*/React.forwardRef(function DocumentView32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"22",cy:"24",r:"2"}),React.createElement("path",{fill:"none",d:"M22,28a4,4,0,1,1,4-4A4.0039,4.0039,0,0,1,22,28Zm0-6a2,2,0,1,0,2,2A2.0027,2.0027,0,0,0,22,22Z"}),React.createElement("path",{d:"M29.7769,23.4785A8.64,8.64,0,0,0,22,18a8.64,8.64,0,0,0-7.7769,5.4785L14,24l.2231.5215A8.64,8.64,0,0,0,22,30a8.64,8.64,0,0,0,7.7769-5.4785L30,24ZM22,28a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,22,28Z"}),React.createElement("path",{d:"M12,28H8V4h8v6a2.0058,2.0058,0,0,0,2,2h6v4h2V10a.9092.9092,0,0,0-.3-.7l-7-7A.9087.9087,0,0,0,18,2H8A2.0058,2.0058,0,0,0,6,4V28a2.0058,2.0058,0,0,0,2,2h4ZM18,4.4,23.6,10H18Z"}),props.children);});var DocumentView24=/*#__PURE__*/React.forwardRef(function DocumentView24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"22",cy:"24",r:"2"}),React.createElement("path",{fill:"none",d:"M22,28a4,4,0,1,1,4-4A4.0039,4.0039,0,0,1,22,28Zm0-6a2,2,0,1,0,2,2A2.0027,2.0027,0,0,0,22,22Z"}),React.createElement("path",{d:"M29.7769,23.4785A8.64,8.64,0,0,0,22,18a8.64,8.64,0,0,0-7.7769,5.4785L14,24l.2231.5215A8.64,8.64,0,0,0,22,30a8.64,8.64,0,0,0,7.7769-5.4785L30,24ZM22,28a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,22,28Z"}),React.createElement("path",{d:"M12,28H8V4h8v6a2.0058,2.0058,0,0,0,2,2h6v4h2V10a.9092.9092,0,0,0-.3-.7l-7-7A.9087.9087,0,0,0,18,2H8A2.0058,2.0058,0,0,0,6,4V28a2.0058,2.0058,0,0,0,2,2h4ZM18,4.4,23.6,10H18Z"}),props.children);});var DocumentView20=/*#__PURE__*/React.forwardRef(function DocumentView20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"22",cy:"24",r:"2"}),React.createElement("path",{fill:"none",d:"M22,28a4,4,0,1,1,4-4A4.0039,4.0039,0,0,1,22,28Zm0-6a2,2,0,1,0,2,2A2.0027,2.0027,0,0,0,22,22Z"}),React.createElement("path",{d:"M29.7769,23.4785A8.64,8.64,0,0,0,22,18a8.64,8.64,0,0,0-7.7769,5.4785L14,24l.2231.5215A8.64,8.64,0,0,0,22,30a8.64,8.64,0,0,0,7.7769-5.4785L30,24ZM22,28a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,22,28Z"}),React.createElement("path",{d:"M12,28H8V4h8v6a2.0058,2.0058,0,0,0,2,2h6v4h2V10a.9092.9092,0,0,0-.3-.7l-7-7A.9087.9087,0,0,0,18,2H8A2.0058,2.0058,0,0,0,6,4V28a2.0058,2.0058,0,0,0,2,2h4ZM18,4.4,23.6,10H18Z"}),props.children);});var DocumentView16=/*#__PURE__*/React.forwardRef(function DocumentView16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"22",cy:"24",r:"2"}),React.createElement("path",{fill:"none",d:"M22,28a4,4,0,1,1,4-4A4.0039,4.0039,0,0,1,22,28Zm0-6a2,2,0,1,0,2,2A2.0027,2.0027,0,0,0,22,22Z"}),React.createElement("path",{d:"M29.7769,23.4785A8.64,8.64,0,0,0,22,18a8.64,8.64,0,0,0-7.7769,5.4785L14,24l.2231.5215A8.64,8.64,0,0,0,22,30a8.64,8.64,0,0,0,7.7769-5.4785L30,24ZM22,28a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,22,28Z"}),React.createElement("path",{d:"M12,28H8V4h8v6a2.0058,2.0058,0,0,0,2,2h6v4h2V10a.9092.9092,0,0,0-.3-.7l-7-7A.9087.9087,0,0,0,18,2H8A2.0058,2.0058,0,0,0,6,4V28a2.0058,2.0058,0,0,0,2,2h4ZM18,4.4,23.6,10H18Z"}),props.children);});var DocumentSentiment32=/*#__PURE__*/React.forwardRef(function DocumentSentiment32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18.303,16a2.6616,2.6616,0,0,0-1.9079.8058l-.3932.4054-.397-.4054a2.6615,2.6615,0,0,0-3.8157,0,2.7992,2.7992,0,0,0,0,3.8964L16.0019,25l4.2089-4.2978a2.7992,2.7992,0,0,0,0-3.8964A2.6616,2.6616,0,0,0,18.303,16Z"}),React.createElement("path",{d:"M25.7,9.3l-7-7A.9078.9078,0,0,0,18,2H8A2.0059,2.0059,0,0,0,6,4V28a2.0059,2.0059,0,0,0,2,2H24a2.0059,2.0059,0,0,0,2-2V10A.9078.9078,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2.0059,2.0059,0,0,0,2,2h6Z"}),props.children);});var DocumentSentiment24=/*#__PURE__*/React.forwardRef(function DocumentSentiment24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18.303,16a2.6616,2.6616,0,0,0-1.9079.8058l-.3932.4054-.397-.4054a2.6615,2.6615,0,0,0-3.8157,0,2.7992,2.7992,0,0,0,0,3.8964L16.0019,25l4.2089-4.2978a2.7992,2.7992,0,0,0,0-3.8964A2.6616,2.6616,0,0,0,18.303,16Z"}),React.createElement("path",{d:"M25.7,9.3l-7-7A.9078.9078,0,0,0,18,2H8A2.0059,2.0059,0,0,0,6,4V28a2.0059,2.0059,0,0,0,2,2H24a2.0059,2.0059,0,0,0,2-2V10A.9078.9078,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2.0059,2.0059,0,0,0,2,2h6Z"}),props.children);});var DocumentSentiment20=/*#__PURE__*/React.forwardRef(function DocumentSentiment20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18.303,16a2.6616,2.6616,0,0,0-1.9079.8058l-.3932.4054-.397-.4054a2.6615,2.6615,0,0,0-3.8157,0,2.7992,2.7992,0,0,0,0,3.8964L16.0019,25l4.2089-4.2978a2.7992,2.7992,0,0,0,0-3.8964A2.6616,2.6616,0,0,0,18.303,16Z"}),React.createElement("path",{d:"M25.7,9.3l-7-7A.9078.9078,0,0,0,18,2H8A2.0059,2.0059,0,0,0,6,4V28a2.0059,2.0059,0,0,0,2,2H24a2.0059,2.0059,0,0,0,2-2V10A.9078.9078,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2.0059,2.0059,0,0,0,2,2h6Z"}),props.children);});var DocumentSentiment16=/*#__PURE__*/React.forwardRef(function DocumentSentiment16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18.303,16a2.6616,2.6616,0,0,0-1.9079.8058l-.3932.4054-.397-.4054a2.6615,2.6615,0,0,0-3.8157,0,2.7992,2.7992,0,0,0,0,3.8964L16.0019,25l4.2089-4.2978a2.7992,2.7992,0,0,0,0-3.8964A2.6616,2.6616,0,0,0,18.303,16Z"}),React.createElement("path",{d:"M25.7,9.3l-7-7A.9078.9078,0,0,0,18,2H8A2.0059,2.0059,0,0,0,6,4V28a2.0059,2.0059,0,0,0,2,2H24a2.0059,2.0059,0,0,0,2-2V10A.9078.9078,0,0,0,25.7,9.3ZM18,4.4,23.6,10H18ZM24,28H8V4h8v6a2.0059,2.0059,0,0,0,2,2h6Z"}),props.children);});var Document32=/*#__PURE__*/React.forwardRef(function Document32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7C18.5,2.1,18.3,2,18,2H8C6.9,2,6,2.9,6,4v24c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V10C26,9.7,25.9,9.5,25.7,9.3\tz M18,4.4l5.6,5.6H18V4.4z M24,28H8V4h8v6c0,1.1,0.9,2,2,2h6V28z"}),React.createElement("rect",{width:"12",height:"2",x:"10",y:"22"}),React.createElement("rect",{width:"12",height:"2",x:"10",y:"16"}),props.children);});var Document24=/*#__PURE__*/React.forwardRef(function Document24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7C18.5,2.1,18.3,2,18,2H8C6.9,2,6,2.9,6,4v24c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V10C26,9.7,25.9,9.5,25.7,9.3\tz M18,4.4l5.6,5.6H18V4.4z M24,28H8V4h8v6c0,1.1,0.9,2,2,2h6V28z"}),React.createElement("rect",{width:"12",height:"2",x:"10",y:"22"}),React.createElement("rect",{width:"12",height:"2",x:"10",y:"16"}),props.children);});var Document20=/*#__PURE__*/React.forwardRef(function Document20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7C18.5,2.1,18.3,2,18,2H8C6.9,2,6,2.9,6,4v24c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V10C26,9.7,25.9,9.5,25.7,9.3\tz M18,4.4l5.6,5.6H18V4.4z M24,28H8V4h8v6c0,1.1,0.9,2,2,2h6V28z"}),React.createElement("rect",{width:"12",height:"2",x:"10",y:"22"}),React.createElement("rect",{width:"12",height:"2",x:"10",y:"16"}),props.children);});var Document16=/*#__PURE__*/React.forwardRef(function Document16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25.7,9.3l-7-7C18.5,2.1,18.3,2,18,2H8C6.9,2,6,2.9,6,4v24c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V10C26,9.7,25.9,9.5,25.7,9.3\tz M18,4.4l5.6,5.6H18V4.4z M24,28H8V4h8v6c0,1.1,0.9,2,2,2h6V28z"}),React.createElement("rect",{width:"12",height:"2",x:"10",y:"22"}),React.createElement("rect",{width:"12",height:"2",x:"10",y:"16"}),props.children);});var DotMark32=/*#__PURE__*/React.forwardRef(function DotMark32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"16",r:"8"}),props.children);});var DotMark24=/*#__PURE__*/React.forwardRef(function DotMark24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"16",r:"8"}),props.children);});var DotMark20=/*#__PURE__*/React.forwardRef(function DotMark20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"16",r:"8"}),props.children);});var DotMark16=/*#__PURE__*/React.forwardRef(function DotMark16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"16",cy:"16",r:"8"}),props.children);});var DoubleInteger32=/*#__PURE__*/React.forwardRef(function DoubleInteger32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17,8V6H13V2H11V6H8V2H6V6H2V8H6v3H2v2H6v4H8V13h3v4h2V13h4V11H13V8Zm-6,3H8V8h3Z"}),React.createElement("path",{d:"M30,21V19H26V15H24v4H21V15H19v4H15v2h4v3H15v2h4v4h2V26h3v4h2V26h4V24H26V21Zm-6,3H21V21h3Z"}),props.children);});var DoubleInteger24=/*#__PURE__*/React.forwardRef(function DoubleInteger24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17,8V6H13V2H11V6H8V2H6V6H2V8H6v3H2v2H6v4H8V13h3v4h2V13h4V11H13V8Zm-6,3H8V8h3Z"}),React.createElement("path",{d:"M30,21V19H26V15H24v4H21V15H19v4H15v2h4v3H15v2h4v4h2V26h3v4h2V26h4V24H26V21Zm-6,3H21V21h3Z"}),props.children);});var DoubleInteger20=/*#__PURE__*/React.forwardRef(function DoubleInteger20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17,8V6H13V2H11V6H8V2H6V6H2V8H6v3H2v2H6v4H8V13h3v4h2V13h4V11H13V8Zm-6,3H8V8h3Z"}),React.createElement("path",{d:"M30,21V19H26V15H24v4H21V15H19v4H15v2h4v3H15v2h4v4h2V26h3v4h2V26h4V24H26V21Zm-6,3H21V21h3Z"}),props.children);});var DoubleInteger16=/*#__PURE__*/React.forwardRef(function DoubleInteger16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M17,8V6H13V2H11V6H8V2H6V6H2V8H6v3H2v2H6v4H8V13h3v4h2V13h4V11H13V8Zm-6,3H8V8h3Z"}),React.createElement("path",{d:"M30,21V19H26V15H24v4H21V15H19v4H15v2h4v3H15v2h4v4h2V26h3v4h2V26h4V24H26V21Zm-6,3H21V21h3Z"}),props.children);});var DownToBottom32=/*#__PURE__*/React.forwardRef(function DownToBottom32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,18 6,8 7.4,6.6 16,15.2 24.6,6.6 26,8"}),React.createElement("rect",{width:"24",height:"2",x:"4",y:"22"}),props.children);});var DownToBottom24=/*#__PURE__*/React.forwardRef(function DownToBottom24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,18 6,8 7.4,6.6 16,15.2 24.6,6.6 26,8"}),React.createElement("rect",{width:"24",height:"2",x:"4",y:"22"}),props.children);});var DownToBottom20=/*#__PURE__*/React.forwardRef(function DownToBottom20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,18 6,8 7.4,6.6 16,15.2 24.6,6.6 26,8"}),React.createElement("rect",{width:"24",height:"2",x:"4",y:"22"}),props.children);});var DownToBottom16=/*#__PURE__*/React.forwardRef(function DownToBottom16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"16,18 6,8 7.4,6.6 16,15.2 24.6,6.6 26,8"}),React.createElement("rect",{width:"24",height:"2",x:"4",y:"22"}),props.children);});var Download32=/*#__PURE__*/React.forwardRef(function Download32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"26 15 24.59 13.59 17 21.17 17 2 15 2 15 21.17 7.41 13.59 6 15 16 25 26 15"}),React.createElement("path",{d:"M26,24v4H6V24H4v4H4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2h0V24Z"}),props.children);});var Download24=/*#__PURE__*/React.forwardRef(function Download24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"26 15 24.59 13.59 17 21.17 17 2 15 2 15 21.17 7.41 13.59 6 15 16 25 26 15"}),React.createElement("path",{d:"M26,24v4H6V24H4v4H4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2h0V24Z"}),props.children);});var Download20=/*#__PURE__*/React.forwardRef(function Download20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"26 15 24.59 13.59 17 21.17 17 2 15 2 15 21.17 7.41 13.59 6 15 16 25 26 15"}),React.createElement("path",{d:"M26,24v4H6V24H4v4H4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2h0V24Z"}),props.children);});var DragHorizontal32=/*#__PURE__*/React.forwardRef(function DragHorizontal32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12 4 12 15 5.83 15 8.41 12.41 7 11 2 16 7 21 8.41 19.59 5.83 17 12 17 12 28 14 28 14 4 12 4"}),React.createElement("polygon",{points:"25 11 23.59 12.41 26.17 15 20 15 20 4 18 4 18 28 20 28 20 17 26.17 17 23.59 19.59 25 21 30 16 25 11"}),props.children);});var DragHorizontal24=/*#__PURE__*/React.forwardRef(function DragHorizontal24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12 4 12 15 5.83 15 8.41 12.41 7 11 2 16 7 21 8.41 19.59 5.83 17 12 17 12 28 14 28 14 4 12 4"}),React.createElement("polygon",{points:"25 11 23.59 12.41 26.17 15 20 15 20 4 18 4 18 28 20 28 20 17 26.17 17 23.59 19.59 25 21 30 16 25 11"}),props.children);});var DragHorizontal20=/*#__PURE__*/React.forwardRef(function DragHorizontal20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12 4 12 15 5.83 15 8.41 12.41 7 11 2 16 7 21 8.41 19.59 5.83 17 12 17 12 28 14 28 14 4 12 4"}),React.createElement("polygon",{points:"25 11 23.59 12.41 26.17 15 20 15 20 4 18 4 18 28 20 28 20 17 26.17 17 23.59 19.59 25 21 30 16 25 11"}),props.children);});var DragHorizontal16=/*#__PURE__*/React.forwardRef(function DragHorizontal16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"12 4 12 15 5.83 15 8.41 12.41 7 11 2 16 7 21 8.41 19.59 5.83 17 12 17 12 28 14 28 14 4 12 4"}),React.createElement("polygon",{points:"25 11 23.59 12.41 26.17 15 20 15 20 4 18 4 18 28 20 28 20 17 26.17 17 23.59 19.59 25 21 30 16 25 11"}),props.children);});var DragVertical32=/*#__PURE__*/React.forwardRef(function DragVertical32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"4 20 15 20 15 26.17 12.41 23.59 11 25 16 30 21 25 19.59 23.59 17 26.17 17 20 28 20 28 18 4 18 4 20"}),React.createElement("polygon",{points:"11 7 12.41 8.41 15 5.83 15 12 4 12 4 14 28 14 28 12 17 12 17 5.83 19.59 8.41 21 7 16 2 11 7"}),props.children);});var DragVertical24=/*#__PURE__*/React.forwardRef(function DragVertical24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"4 20 15 20 15 26.17 12.41 23.59 11 25 16 30 21 25 19.59 23.59 17 26.17 17 20 28 20 28 18 4 18 4 20"}),React.createElement("polygon",{points:"11 7 12.41 8.41 15 5.83 15 12 4 12 4 14 28 14 28 12 17 12 17 5.83 19.59 8.41 21 7 16 2 11 7"}),props.children);});var DragVertical20=/*#__PURE__*/React.forwardRef(function DragVertical20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"4 20 15 20 15 26.17 12.41 23.59 11 25 16 30 21 25 19.59 23.59 17 26.17 17 20 28 20 28 18 4 18 4 20"}),React.createElement("polygon",{points:"11 7 12.41 8.41 15 5.83 15 12 4 12 4 14 28 14 28 12 17 12 17 5.83 19.59 8.41 21 7 16 2 11 7"}),props.children);});var DragVertical16=/*#__PURE__*/React.forwardRef(function DragVertical16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"4 20 15 20 15 26.17 12.41 23.59 11 25 16 30 21 25 19.59 23.59 17 26.17 17 20 28 20 28 18 4 18 4 20"}),React.createElement("polygon",{points:"11 7 12.41 8.41 15 5.83 15 12 4 12 4 14 28 14 28 12 17 12 17 5.83 19.59 8.41 21 7 16 2 11 7"}),props.children);});var Draggable32=/*#__PURE__*/React.forwardRef(function Draggable32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"4",x:"10",y:"6"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"6"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"22"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"22"}),props.children);});var Draggable24=/*#__PURE__*/React.forwardRef(function Draggable24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"4",x:"10",y:"6"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"6"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"22"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"22"}),props.children);});var Draggable20=/*#__PURE__*/React.forwardRef(function Draggable20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"4",x:"10",y:"6"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"6"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"22"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"22"}),props.children);});var Draggable16=/*#__PURE__*/React.forwardRef(function Draggable16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"4",height:"4",x:"10",y:"6"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"6"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"14"}),React.createElement("rect",{width:"4",height:"4",x:"10",y:"22"}),React.createElement("rect",{width:"4",height:"4",x:"18",y:"22"}),props.children);});var Draw32=/*#__PURE__*/React.forwardRef(function Draw32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19.14,28a3.42,3.42,0,0,1-2.42-5.85L21.86,17a1.42,1.42,0,1,0-2-2L13,21.85a3.5,3.5,0,0,1-4.85,0,3.43,3.43,0,0,1,0-4.84l8.58-8.58a1.42,1.42,0,1,0-2-2L6.41,14.7,5,13.3,13.29,5a3.43,3.43,0,0,1,4.84,4.85L9.56,18.42a1.42,1.42,0,0,0,0,2,1.45,1.45,0,0,0,2,0l6.86-6.86a3.43,3.43,0,1,1,4.85,4.84l-5.15,5.15a1.42,1.42,0,0,0,2,2l4.44-4.43L26,22.56,21.56,27A3.38,3.38,0,0,1,19.14,28Z"}),props.children);});var Draw24=/*#__PURE__*/React.forwardRef(function Draw24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19.14,28a3.42,3.42,0,0,1-2.42-5.85L21.86,17a1.42,1.42,0,1,0-2-2L13,21.85a3.5,3.5,0,0,1-4.85,0,3.43,3.43,0,0,1,0-4.84l8.58-8.58a1.42,1.42,0,1,0-2-2L6.41,14.7,5,13.3,13.29,5a3.43,3.43,0,0,1,4.84,4.85L9.56,18.42a1.42,1.42,0,0,0,0,2,1.45,1.45,0,0,0,2,0l6.86-6.86a3.43,3.43,0,1,1,4.85,4.84l-5.15,5.15a1.42,1.42,0,0,0,2,2l4.44-4.43L26,22.56,21.56,27A3.38,3.38,0,0,1,19.14,28Z"}),props.children);});var Draw20=/*#__PURE__*/React.forwardRef(function Draw20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19.14,28a3.42,3.42,0,0,1-2.42-5.85L21.86,17a1.42,1.42,0,1,0-2-2L13,21.85a3.5,3.5,0,0,1-4.85,0,3.43,3.43,0,0,1,0-4.84l8.58-8.58a1.42,1.42,0,1,0-2-2L6.41,14.7,5,13.3,13.29,5a3.43,3.43,0,0,1,4.84,4.85L9.56,18.42a1.42,1.42,0,0,0,0,2,1.45,1.45,0,0,0,2,0l6.86-6.86a3.43,3.43,0,1,1,4.85,4.84l-5.15,5.15a1.42,1.42,0,0,0,2,2l4.44-4.43L26,22.56,21.56,27A3.38,3.38,0,0,1,19.14,28Z"}),props.children);});var Draw16=/*#__PURE__*/React.forwardRef(function Draw16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19.14,28a3.42,3.42,0,0,1-2.42-5.85L21.86,17a1.42,1.42,0,1,0-2-2L13,21.85a3.5,3.5,0,0,1-4.85,0,3.43,3.43,0,0,1,0-4.84l8.58-8.58a1.42,1.42,0,1,0-2-2L6.41,14.7,5,13.3,13.29,5a3.43,3.43,0,0,1,4.84,4.85L9.56,18.42a1.42,1.42,0,0,0,0,2,1.45,1.45,0,0,0,2,0l6.86-6.86a3.43,3.43,0,1,1,4.85,4.84l-5.15,5.15a1.42,1.42,0,0,0,2,2l4.44-4.43L26,22.56,21.56,27A3.38,3.38,0,0,1,19.14,28Z"}),props.children);});var DropPhotoFilled32=/*#__PURE__*/React.forwardRef(function DropPhotoFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"19",cy:"22",r:"2"}),React.createElement("path",{d:"M27,16H23.7207l-.5439-1.6328A1.9983,1.9983,0,0,0,21.2793,13H16.7207a1.9981,1.9981,0,0,0-1.8975,1.3677L14.2793,16H11a2.0023,2.0023,0,0,0-2,2v9a2.0023,2.0023,0,0,0,2,2H27a2.0023,2.0023,0,0,0,2-2V18A2.0023,2.0023,0,0,0,27,16ZM19,26a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,26Z"}),React.createElement("path",{fill:"none",d:"M19,26a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,26Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,19,20Z","data-icon-path":"inner-path"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"23",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"19",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"11",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"7",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"15"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"19"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"27"}),props.children);});var DropPhotoFilled24=/*#__PURE__*/React.forwardRef(function DropPhotoFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"19",cy:"22",r:"2"}),React.createElement("path",{d:"M27,16H23.7207l-.5439-1.6328A1.9983,1.9983,0,0,0,21.2793,13H16.7207a1.9981,1.9981,0,0,0-1.8975,1.3677L14.2793,16H11a2.0023,2.0023,0,0,0-2,2v9a2.0023,2.0023,0,0,0,2,2H27a2.0023,2.0023,0,0,0,2-2V18A2.0023,2.0023,0,0,0,27,16ZM19,26a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,26Z"}),React.createElement("path",{fill:"none",d:"M19,26a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,26Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,19,20Z","data-icon-path":"inner-path"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"23",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"19",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"11",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"7",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"15"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"19"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"27"}),props.children);});var DropPhotoFilled20=/*#__PURE__*/React.forwardRef(function DropPhotoFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"19",cy:"22",r:"2"}),React.createElement("path",{d:"M27,16H23.7207l-.5439-1.6328A1.9983,1.9983,0,0,0,21.2793,13H16.7207a1.9981,1.9981,0,0,0-1.8975,1.3677L14.2793,16H11a2.0023,2.0023,0,0,0-2,2v9a2.0023,2.0023,0,0,0,2,2H27a2.0023,2.0023,0,0,0,2-2V18A2.0023,2.0023,0,0,0,27,16ZM19,26a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,26Z"}),React.createElement("path",{fill:"none",d:"M19,26a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,26Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,19,20Z","data-icon-path":"inner-path"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"23",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"19",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"11",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"7",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"15"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"19"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"27"}),props.children);});var DropPhotoFilled16=/*#__PURE__*/React.forwardRef(function DropPhotoFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"19",cy:"22",r:"2"}),React.createElement("path",{d:"M27,16H23.7207l-.5439-1.6328A1.9983,1.9983,0,0,0,21.2793,13H16.7207a1.9981,1.9981,0,0,0-1.8975,1.3677L14.2793,16H11a2.0023,2.0023,0,0,0-2,2v9a2.0023,2.0023,0,0,0,2,2H27a2.0023,2.0023,0,0,0,2-2V18A2.0023,2.0023,0,0,0,27,16ZM19,26a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,26Z"}),React.createElement("path",{fill:"none",d:"M19,26a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,26Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,19,20Z","data-icon-path":"inner-path"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"23",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"19",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"11",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"7",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"15"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"19"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"27"}),props.children);});var DropPhoto32=/*#__PURE__*/React.forwardRef(function DropPhoto32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,26a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,26Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,19,20Z"}),React.createElement("path",{d:"M27,29H11a2,2,0,0,1-2-2V18a2,2,0,0,1,2-2h3.2793l.5441-1.6324A2,2,0,0,1,16.7208,13h4.5584a2,2,0,0,1,1.8974,1.3676L23.7207,16H27a2,2,0,0,1,2,2v9A2,2,0,0,1,27,29ZM11,27H27V18H22.2792l-1-3H16.7207l-1,3H11Z"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"23",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"19",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"11",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"7",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"15"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"19"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"27"}),props.children);});var DropPhoto24=/*#__PURE__*/React.forwardRef(function DropPhoto24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,26a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,26Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,19,20Z"}),React.createElement("path",{d:"M27,29H11a2,2,0,0,1-2-2V18a2,2,0,0,1,2-2h3.2793l.5441-1.6324A2,2,0,0,1,16.7208,13h4.5584a2,2,0,0,1,1.8974,1.3676L23.7207,16H27a2,2,0,0,1,2,2v9A2,2,0,0,1,27,29ZM11,27H27V18H22.2792l-1-3H16.7207l-1,3H11Z"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"23",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"19",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"11",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"7",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"15"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"19"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"27"}),props.children);});var DropPhoto20=/*#__PURE__*/React.forwardRef(function DropPhoto20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,26a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,26Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,19,20Z"}),React.createElement("path",{d:"M27,29H11a2,2,0,0,1-2-2V18a2,2,0,0,1,2-2h3.2793l.5441-1.6324A2,2,0,0,1,16.7208,13h4.5584a2,2,0,0,1,1.8974,1.3676L23.7207,16H27a2,2,0,0,1,2,2v9A2,2,0,0,1,27,29ZM11,27H27V18H22.2792l-1-3H16.7207l-1,3H11Z"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"23",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"19",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"11",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"7",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"15"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"19"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"27"}),props.children);});var DropPhoto16=/*#__PURE__*/React.forwardRef(function DropPhoto16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,26a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,19,26Zm0-6a2,2,0,1,0,2,2A2.0021,2.0021,0,0,0,19,20Z"}),React.createElement("path",{d:"M27,29H11a2,2,0,0,1-2-2V18a2,2,0,0,1,2-2h3.2793l.5441-1.6324A2,2,0,0,1,16.7208,13h4.5584a2,2,0,0,1,1.8974,1.3676L23.7207,16H27a2,2,0,0,1,2,2v9A2,2,0,0,1,27,29ZM11,27H27V18H22.2792l-1-3H16.7207l-1,3H11Z"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"27",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"23",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"19",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"15",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"11",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"7",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"3"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"7"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"11"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"15"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"19"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"23"}),React.createElement("rect",{width:"2",height:"2",x:"3",y:"27"}),props.children);});var EarthAmericasFilled32=/*#__PURE__*/React.forwardRef(function EarthAmericasFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4,16a11.915,11.915,0,0,1,.7-4H10l5,4-2.8,3.6929A1,1,0,0,0,12.293,21L15,24v3.9492A12.01,12.01,0,0,1,4,16ZM21.4348,26.6846l2.5457-7.6992A1,1,0,0,0,23.614,18L15,11l2-2h5.2793a1,1,0,0,0,.9487-.6836L23.7234,6.83a11.9742,11.9742,0,0,1-2.2886,19.855Z"}),props.children);});var EarthAmericasFilled24=/*#__PURE__*/React.forwardRef(function EarthAmericasFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4,16a11.915,11.915,0,0,1,.7-4H10l5,4-2.8,3.6929A1,1,0,0,0,12.293,21L15,24v3.9492A12.01,12.01,0,0,1,4,16ZM21.4348,26.6846l2.5457-7.6992A1,1,0,0,0,23.614,18L15,11l2-2h5.2793a1,1,0,0,0,.9487-.6836L23.7234,6.83a11.9742,11.9742,0,0,1-2.2886,19.855Z"}),props.children);});var EarthAmericasFilled20=/*#__PURE__*/React.forwardRef(function EarthAmericasFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4,16a11.915,11.915,0,0,1,.7-4H10l5,4-2.8,3.6929A1,1,0,0,0,12.293,21L15,24v3.9492A12.01,12.01,0,0,1,4,16ZM21.4348,26.6846l2.5457-7.6992A1,1,0,0,0,23.614,18L15,11l2-2h5.2793a1,1,0,0,0,.9487-.6836L23.7234,6.83a11.9742,11.9742,0,0,1-2.2886,19.855Z"}),props.children);});var EarthAmericasFilled16=/*#__PURE__*/React.forwardRef(function EarthAmericasFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4,16a11.915,11.915,0,0,1,.7-4H10l5,4-2.8,3.6929A1,1,0,0,0,12.293,21L15,24v3.9492A12.01,12.01,0,0,1,4,16ZM21.4348,26.6846l2.5457-7.6992A1,1,0,0,0,23.614,18L15,11l2-2h5.2793a1,1,0,0,0,.9487-.6836L23.7234,6.83a11.9742,11.9742,0,0,1-2.2886,19.855Z"}),props.children);});var EarthAmericas32=/*#__PURE__*/React.forwardRef(function EarthAmericas32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,16a14.0313,14.0313,0,1,0-7.14,12.1914l.1165.0254.0249-.1113A13.9983,13.9983,0,0,0,30,16ZM4,16a11.9369,11.9369,0,0,1,.395-3H8.6382L13.63,17.16l-1.9092,2.5459a2.0088,2.0088,0,0,0,.1855,2.6142L14,24.4141v3.4052A12.0093,12.0093,0,0,1,4,16Zm9.32,4.9062L16.37,16.84,9.3618,11H5.1055A11.9619,11.9619,0,0,1,22.8838,6.1865L22.2793,8H16.5859L13.543,11.043l9.3535,8.3134L21.248,26.7749A11.9034,11.9034,0,0,1,16,28V23.5859Zm10.315,4.3443,1.2133-5.46a2.0007,2.0007,0,0,0-.6235-1.9277L16.457,10.957,17.4141,10h4.8652a1.9981,1.9981,0,0,0,1.8975-1.3677l.3532-1.06a11.9777,11.9777,0,0,1-.8947,17.6782Z"}),props.children);});var EarthAmericas24=/*#__PURE__*/React.forwardRef(function EarthAmericas24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,16a14.0313,14.0313,0,1,0-7.14,12.1914l.1165.0254.0249-.1113A13.9983,13.9983,0,0,0,30,16ZM4,16a11.9369,11.9369,0,0,1,.395-3H8.6382L13.63,17.16l-1.9092,2.5459a2.0088,2.0088,0,0,0,.1855,2.6142L14,24.4141v3.4052A12.0093,12.0093,0,0,1,4,16Zm9.32,4.9062L16.37,16.84,9.3618,11H5.1055A11.9619,11.9619,0,0,1,22.8838,6.1865L22.2793,8H16.5859L13.543,11.043l9.3535,8.3134L21.248,26.7749A11.9034,11.9034,0,0,1,16,28V23.5859Zm10.315,4.3443,1.2133-5.46a2.0007,2.0007,0,0,0-.6235-1.9277L16.457,10.957,17.4141,10h4.8652a1.9981,1.9981,0,0,0,1.8975-1.3677l.3532-1.06a11.9777,11.9777,0,0,1-.8947,17.6782Z"}),props.children);});var EarthAmericas20=/*#__PURE__*/React.forwardRef(function EarthAmericas20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,16a14.0313,14.0313,0,1,0-7.14,12.1914l.1165.0254.0249-.1113A13.9983,13.9983,0,0,0,30,16ZM4,16a11.9369,11.9369,0,0,1,.395-3H8.6382L13.63,17.16l-1.9092,2.5459a2.0088,2.0088,0,0,0,.1855,2.6142L14,24.4141v3.4052A12.0093,12.0093,0,0,1,4,16Zm9.32,4.9062L16.37,16.84,9.3618,11H5.1055A11.9619,11.9619,0,0,1,22.8838,6.1865L22.2793,8H16.5859L13.543,11.043l9.3535,8.3134L21.248,26.7749A11.9034,11.9034,0,0,1,16,28V23.5859Zm10.315,4.3443,1.2133-5.46a2.0007,2.0007,0,0,0-.6235-1.9277L16.457,10.957,17.4141,10h4.8652a1.9981,1.9981,0,0,0,1.8975-1.3677l.3532-1.06a11.9777,11.9777,0,0,1-.8947,17.6782Z"}),props.children);});var EarthAmericas16=/*#__PURE__*/React.forwardRef(function EarthAmericas16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,16a14.0313,14.0313,0,1,0-7.14,12.1914l.1165.0254.0249-.1113A13.9983,13.9983,0,0,0,30,16ZM4,16a11.9369,11.9369,0,0,1,.395-3H8.6382L13.63,17.16l-1.9092,2.5459a2.0088,2.0088,0,0,0,.1855,2.6142L14,24.4141v3.4052A12.0093,12.0093,0,0,1,4,16Zm9.32,4.9062L16.37,16.84,9.3618,11H5.1055A11.9619,11.9619,0,0,1,22.8838,6.1865L22.2793,8H16.5859L13.543,11.043l9.3535,8.3134L21.248,26.7749A11.9034,11.9034,0,0,1,16,28V23.5859Zm10.315,4.3443,1.2133-5.46a2.0007,2.0007,0,0,0-.6235-1.9277L16.457,10.957,17.4141,10h4.8652a1.9981,1.9981,0,0,0,1.8975-1.3677l.3532-1.06a11.9777,11.9777,0,0,1-.8947,17.6782Z"}),props.children);});var EarthEuropeAfricaFilled32=/*#__PURE__*/React.forwardRef(function EarthEuropeAfricaFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4,16A11.9814,11.9814,0,0,1,9,6.2734V9a1,1,0,0,0,1,1h3.3821a1,1,0,0,0,.8943-.5527L15,8h4v6H13.2361a1.0006,1.0006,0,0,0-.4473.1055L9.5527,15.7236A1,1,0,0,0,9,16.6182v3.7046a1,1,0,0,0,.6287.9287L14,23l.8235,4.94A12.0152,12.0152,0,0,1,4,16ZM22,26.376V23l1.7546-2.6318a1.0012,1.0012,0,0,0,.1382-.7974L23,16V13h4.605A11.901,11.901,0,0,1,22,26.376Z"}),props.children);});var EarthEuropeAfricaFilled24=/*#__PURE__*/React.forwardRef(function EarthEuropeAfricaFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4,16A11.9814,11.9814,0,0,1,9,6.2734V9a1,1,0,0,0,1,1h3.3821a1,1,0,0,0,.8943-.5527L15,8h4v6H13.2361a1.0006,1.0006,0,0,0-.4473.1055L9.5527,15.7236A1,1,0,0,0,9,16.6182v3.7046a1,1,0,0,0,.6287.9287L14,23l.8235,4.94A12.0152,12.0152,0,0,1,4,16ZM22,26.376V23l1.7546-2.6318a1.0012,1.0012,0,0,0,.1382-.7974L23,16V13h4.605A11.901,11.901,0,0,1,22,26.376Z"}),props.children);});var EarthEuropeAfricaFilled20=/*#__PURE__*/React.forwardRef(function EarthEuropeAfricaFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4,16A11.9814,11.9814,0,0,1,9,6.2734V9a1,1,0,0,0,1,1h3.3821a1,1,0,0,0,.8943-.5527L15,8h4v6H13.2361a1.0006,1.0006,0,0,0-.4473.1055L9.5527,15.7236A1,1,0,0,0,9,16.6182v3.7046a1,1,0,0,0,.6287.9287L14,23l.8235,4.94A12.0152,12.0152,0,0,1,4,16ZM22,26.376V23l1.7546-2.6318a1.0012,1.0012,0,0,0,.1382-.7974L23,16V13h4.605A11.901,11.901,0,0,1,22,26.376Z"}),props.children);});var EarthEuropeAfricaFilled16=/*#__PURE__*/React.forwardRef(function EarthEuropeAfricaFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4,16A11.9814,11.9814,0,0,1,9,6.2734V9a1,1,0,0,0,1,1h3.3821a1,1,0,0,0,.8943-.5527L15,8h4v6H13.2361a1.0006,1.0006,0,0,0-.4473.1055L9.5527,15.7236A1,1,0,0,0,9,16.6182v3.7046a1,1,0,0,0,.6287.9287L14,23l.8235,4.94A12.0152,12.0152,0,0,1,4,16ZM22,26.376V23l1.7546-2.6318a1.0012,1.0012,0,0,0,.1382-.7974L23,16V13h4.605A11.901,11.901,0,0,1,22,26.376Z"}),props.children);});var EarthEuropeAfrica32=/*#__PURE__*/React.forwardRef(function EarthEuropeAfrica32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4,16A11.96,11.96,0,0,1,8,7.0811V9a2,2,0,0,0,2,2h3.3818a2,2,0,0,0,1.7893-1.106L15.6182,9H18v4H13.2354a2,2,0,0,0-.8936.2109L9.1055,14.8291A2,2,0,0,0,8,16.6177v3.7055A2,2,0,0,0,9.2573,22.18l3.8487,1.54.6779,4.0664A12.0135,12.0135,0,0,1,4,16ZM15.8457,27.9922,14.894,22.28,10,20.3232v-3.705L13.2358,15H20V7H14.3818l-1,2H10V5.6235A11.9578,11.9578,0,0,1,27.3,12H22v4l.9224,3.8135L21,22.6973v4.1972A11.9083,11.9083,0,0,1,16,28C15.948,28,15.8977,27.9927,15.8457,27.9922ZM23,25.7266V23.3027l1.5859-2.3789a2.0027,2.0027,0,0,0,.2769-1.5957L24,15.877V14h3.8193A11.8409,11.8409,0,0,1,23,25.7266Z"}),props.children);});var EarthEuropeAfrica24=/*#__PURE__*/React.forwardRef(function EarthEuropeAfrica24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4,16A11.96,11.96,0,0,1,8,7.0811V9a2,2,0,0,0,2,2h3.3818a2,2,0,0,0,1.7893-1.106L15.6182,9H18v4H13.2354a2,2,0,0,0-.8936.2109L9.1055,14.8291A2,2,0,0,0,8,16.6177v3.7055A2,2,0,0,0,9.2573,22.18l3.8487,1.54.6779,4.0664A12.0135,12.0135,0,0,1,4,16ZM15.8457,27.9922,14.894,22.28,10,20.3232v-3.705L13.2358,15H20V7H14.3818l-1,2H10V5.6235A11.9578,11.9578,0,0,1,27.3,12H22v4l.9224,3.8135L21,22.6973v4.1972A11.9083,11.9083,0,0,1,16,28C15.948,28,15.8977,27.9927,15.8457,27.9922ZM23,25.7266V23.3027l1.5859-2.3789a2.0027,2.0027,0,0,0,.2769-1.5957L24,15.877V14h3.8193A11.8409,11.8409,0,0,1,23,25.7266Z"}),props.children);});var EarthEuropeAfrica20=/*#__PURE__*/React.forwardRef(function EarthEuropeAfrica20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4,16A11.96,11.96,0,0,1,8,7.0811V9a2,2,0,0,0,2,2h3.3818a2,2,0,0,0,1.7893-1.106L15.6182,9H18v4H13.2354a2,2,0,0,0-.8936.2109L9.1055,14.8291A2,2,0,0,0,8,16.6177v3.7055A2,2,0,0,0,9.2573,22.18l3.8487,1.54.6779,4.0664A12.0135,12.0135,0,0,1,4,16ZM15.8457,27.9922,14.894,22.28,10,20.3232v-3.705L13.2358,15H20V7H14.3818l-1,2H10V5.6235A11.9578,11.9578,0,0,1,27.3,12H22v4l.9224,3.8135L21,22.6973v4.1972A11.9083,11.9083,0,0,1,16,28C15.948,28,15.8977,27.9927,15.8457,27.9922ZM23,25.7266V23.3027l1.5859-2.3789a2.0027,2.0027,0,0,0,.2769-1.5957L24,15.877V14h3.8193A11.8409,11.8409,0,0,1,23,25.7266Z"}),props.children);});var EarthEuropeAfrica16=/*#__PURE__*/React.forwardRef(function EarthEuropeAfrica16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4,16A11.96,11.96,0,0,1,8,7.0811V9a2,2,0,0,0,2,2h3.3818a2,2,0,0,0,1.7893-1.106L15.6182,9H18v4H13.2354a2,2,0,0,0-.8936.2109L9.1055,14.8291A2,2,0,0,0,8,16.6177v3.7055A2,2,0,0,0,9.2573,22.18l3.8487,1.54.6779,4.0664A12.0135,12.0135,0,0,1,4,16ZM15.8457,27.9922,14.894,22.28,10,20.3232v-3.705L13.2358,15H20V7H14.3818l-1,2H10V5.6235A11.9578,11.9578,0,0,1,27.3,12H22v4l.9224,3.8135L21,22.6973v4.1972A11.9083,11.9083,0,0,1,16,28C15.948,28,15.8977,27.9927,15.8457,27.9922ZM23,25.7266V23.3027l1.5859-2.3789a2.0027,2.0027,0,0,0,.2769-1.5957L24,15.877V14h3.8193A11.8409,11.8409,0,0,1,23,25.7266Z"}),props.children);});var EarthFilled32=/*#__PURE__*/React.forwardRef(function EarthFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4.02,16.394l1.3384.4458L7,19.3027v1.2831a1,1,0,0,0,.2929.7071L10,24v2.3765A11.9941,11.9941,0,0,1,4.02,16.394ZM16,28a11.9682,11.9682,0,0,1-2.5718-.2847L14,26l1.8046-4.5116a1,1,0,0,0-.0964-.9261l-1.4113-2.117A1,1,0,0,0,13.4648,18h-4.93L7.2866,16.1274,9.4141,14H11v2h2V13.2656l3.8682-6.7695-1.7364-.9922L14.2769,7H11.5352l-1.086-1.6289A11.861,11.861,0,0,1,20,4.7V8a1,1,0,0,0,1,1h1.4648a1,1,0,0,0,.8321-.4453l.8769-1.3154A12.0331,12.0331,0,0,1,26.8945,11H22.82a1,1,0,0,0-.9806.8039l-.7221,4.4708a1,1,0,0,0,.54,1.0539L25,19l.6851,4.0557A11.9793,11.9793,0,0,1,16,28Z"}),props.children);});var EarthFilled24=/*#__PURE__*/React.forwardRef(function EarthFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4.02,16.394l1.3384.4458L7,19.3027v1.2831a1,1,0,0,0,.2929.7071L10,24v2.3765A11.9941,11.9941,0,0,1,4.02,16.394ZM16,28a11.9682,11.9682,0,0,1-2.5718-.2847L14,26l1.8046-4.5116a1,1,0,0,0-.0964-.9261l-1.4113-2.117A1,1,0,0,0,13.4648,18h-4.93L7.2866,16.1274,9.4141,14H11v2h2V13.2656l3.8682-6.7695-1.7364-.9922L14.2769,7H11.5352l-1.086-1.6289A11.861,11.861,0,0,1,20,4.7V8a1,1,0,0,0,1,1h1.4648a1,1,0,0,0,.8321-.4453l.8769-1.3154A12.0331,12.0331,0,0,1,26.8945,11H22.82a1,1,0,0,0-.9806.8039l-.7221,4.4708a1,1,0,0,0,.54,1.0539L25,19l.6851,4.0557A11.9793,11.9793,0,0,1,16,28Z"}),props.children);});var EarthFilled20=/*#__PURE__*/React.forwardRef(function EarthFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4.02,16.394l1.3384.4458L7,19.3027v1.2831a1,1,0,0,0,.2929.7071L10,24v2.3765A11.9941,11.9941,0,0,1,4.02,16.394ZM16,28a11.9682,11.9682,0,0,1-2.5718-.2847L14,26l1.8046-4.5116a1,1,0,0,0-.0964-.9261l-1.4113-2.117A1,1,0,0,0,13.4648,18h-4.93L7.2866,16.1274,9.4141,14H11v2h2V13.2656l3.8682-6.7695-1.7364-.9922L14.2769,7H11.5352l-1.086-1.6289A11.861,11.861,0,0,1,20,4.7V8a1,1,0,0,0,1,1h1.4648a1,1,0,0,0,.8321-.4453l.8769-1.3154A12.0331,12.0331,0,0,1,26.8945,11H22.82a1,1,0,0,0-.9806.8039l-.7221,4.4708a1,1,0,0,0,.54,1.0539L25,19l.6851,4.0557A11.9793,11.9793,0,0,1,16,28Z"}),props.children);});var EarthFilled16=/*#__PURE__*/React.forwardRef(function EarthFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4.02,16.394l1.3384.4458L7,19.3027v1.2831a1,1,0,0,0,.2929.7071L10,24v2.3765A11.9941,11.9941,0,0,1,4.02,16.394ZM16,28a11.9682,11.9682,0,0,1-2.5718-.2847L14,26l1.8046-4.5116a1,1,0,0,0-.0964-.9261l-1.4113-2.117A1,1,0,0,0,13.4648,18h-4.93L7.2866,16.1274,9.4141,14H11v2h2V13.2656l3.8682-6.7695-1.7364-.9922L14.2769,7H11.5352l-1.086-1.6289A11.861,11.861,0,0,1,20,4.7V8a1,1,0,0,0,1,1h1.4648a1,1,0,0,0,.8321-.4453l.8769-1.3154A12.0331,12.0331,0,0,1,26.8945,11H22.82a1,1,0,0,0-.9806.8039l-.7221,4.4708a1,1,0,0,0,.54,1.0539L25,19l.6851,4.0557A11.9793,11.9793,0,0,1,16,28Z"}),props.children);});var EarthSoutheastAsiaFilled32=/*#__PURE__*/React.forwardRef(function EarthSoutheastAsiaFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"2",x:"17",y:"22"}),React.createElement("rect",{width:"2",height:"2",x:"17",y:"18"}),React.createElement("rect",{width:"3",height:"2",x:"14",y:"24"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4.7,20H6l4.1772,2.6a1,1,0,0,0,1.36-.2939l1.0078-1.5118a1,1,0,0,0-.125-1.2617L10,17.1118,11,14h5.323a1,1,0,0,0,.9285-.6284L18.8333,9.417a1,1,0,0,0-.034-.8189L16.5129,4.0259A11.9652,11.9652,0,0,1,26.3762,22H23a1,1,0,0,0-1,1v3.3765A11.9578,11.9578,0,0,1,4.7,20Z"}),props.children);});var EarthSoutheastAsiaFilled24=/*#__PURE__*/React.forwardRef(function EarthSoutheastAsiaFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"2",x:"17",y:"22"}),React.createElement("rect",{width:"2",height:"2",x:"17",y:"18"}),React.createElement("rect",{width:"3",height:"2",x:"14",y:"24"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4.7,20H6l4.1772,2.6a1,1,0,0,0,1.36-.2939l1.0078-1.5118a1,1,0,0,0-.125-1.2617L10,17.1118,11,14h5.323a1,1,0,0,0,.9285-.6284L18.8333,9.417a1,1,0,0,0-.034-.8189L16.5129,4.0259A11.9652,11.9652,0,0,1,26.3762,22H23a1,1,0,0,0-1,1v3.3765A11.9578,11.9578,0,0,1,4.7,20Z"}),props.children);});var EarthSoutheastAsiaFilled20=/*#__PURE__*/React.forwardRef(function EarthSoutheastAsiaFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"2",x:"17",y:"22"}),React.createElement("rect",{width:"2",height:"2",x:"17",y:"18"}),React.createElement("rect",{width:"3",height:"2",x:"14",y:"24"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4.7,20H6l4.1772,2.6a1,1,0,0,0,1.36-.2939l1.0078-1.5118a1,1,0,0,0-.125-1.2617L10,17.1118,11,14h5.323a1,1,0,0,0,.9285-.6284L18.8333,9.417a1,1,0,0,0-.034-.8189L16.5129,4.0259A11.9652,11.9652,0,0,1,26.3762,22H23a1,1,0,0,0-1,1v3.3765A11.9578,11.9578,0,0,1,4.7,20Z"}),props.children);});var EarthSoutheastAsiaFilled16=/*#__PURE__*/React.forwardRef(function EarthSoutheastAsiaFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"2",x:"17",y:"22"}),React.createElement("rect",{width:"2",height:"2",x:"17",y:"18"}),React.createElement("rect",{width:"3",height:"2",x:"14",y:"24"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2ZM4.7,20H6l4.1772,2.6a1,1,0,0,0,1.36-.2939l1.0078-1.5118a1,1,0,0,0-.125-1.2617L10,17.1118,11,14h5.323a1,1,0,0,0,.9285-.6284L18.8333,9.417a1,1,0,0,0-.034-.8189L16.5129,4.0259A11.9652,11.9652,0,0,1,26.3762,22H23a1,1,0,0,0-1,1v3.3765A11.9578,11.9578,0,0,1,4.7,20Z"}),props.children);});var EarthSoutheastAsia32=/*#__PURE__*/React.forwardRef(function EarthSoutheastAsia32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"3",height:"2",x:"14",y:"24"}),React.createElement("rect",{width:"2",height:"2",x:"17",y:"22"}),React.createElement("rect",{width:"2",height:"2",x:"17",y:"18"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2Zm-.603,2.03,2.5073,5.0156L16.3228,13H10.271l-1.41,4.3872,2.8521,2.8521L10.7056,21.751,6.2856,19H4.395A11.9363,11.9363,0,0,1,15.397,4.03ZM5.1055,21h.6089l3.9345,2.4487A1.9912,1.9912,0,0,0,12.37,22.86l1.0078-1.5118a2.005,2.005,0,0,0-.25-2.5234l-1.9887-1.9888L11.729,15h4.5938A1.9906,1.9906,0,0,0,18.18,13.7427L19.7612,9.79a2.0019,2.0019,0,0,0-.0674-1.6382L17.6843,4.1323A11.9592,11.9592,0,0,1,26.8945,21H23a2.0023,2.0023,0,0,0-2,2v3.8945A11.9477,11.9477,0,0,1,5.1055,21ZM23,25.7266V23h2.7268A12.0762,12.0762,0,0,1,23,25.7266Z"}),props.children);});var EarthSoutheastAsia24=/*#__PURE__*/React.forwardRef(function EarthSoutheastAsia24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"3",height:"2",x:"14",y:"24"}),React.createElement("rect",{width:"2",height:"2",x:"17",y:"22"}),React.createElement("rect",{width:"2",height:"2",x:"17",y:"18"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2Zm-.603,2.03,2.5073,5.0156L16.3228,13H10.271l-1.41,4.3872,2.8521,2.8521L10.7056,21.751,6.2856,19H4.395A11.9363,11.9363,0,0,1,15.397,4.03ZM5.1055,21h.6089l3.9345,2.4487A1.9912,1.9912,0,0,0,12.37,22.86l1.0078-1.5118a2.005,2.005,0,0,0-.25-2.5234l-1.9887-1.9888L11.729,15h4.5938A1.9906,1.9906,0,0,0,18.18,13.7427L19.7612,9.79a2.0019,2.0019,0,0,0-.0674-1.6382L17.6843,4.1323A11.9592,11.9592,0,0,1,26.8945,21H23a2.0023,2.0023,0,0,0-2,2v3.8945A11.9477,11.9477,0,0,1,5.1055,21ZM23,25.7266V23h2.7268A12.0762,12.0762,0,0,1,23,25.7266Z"}),props.children);});var EarthSoutheastAsia20=/*#__PURE__*/React.forwardRef(function EarthSoutheastAsia20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"3",height:"2",x:"14",y:"24"}),React.createElement("rect",{width:"2",height:"2",x:"17",y:"22"}),React.createElement("rect",{width:"2",height:"2",x:"17",y:"18"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2Zm-.603,2.03,2.5073,5.0156L16.3228,13H10.271l-1.41,4.3872,2.8521,2.8521L10.7056,21.751,6.2856,19H4.395A11.9363,11.9363,0,0,1,15.397,4.03ZM5.1055,21h.6089l3.9345,2.4487A1.9912,1.9912,0,0,0,12.37,22.86l1.0078-1.5118a2.005,2.005,0,0,0-.25-2.5234l-1.9887-1.9888L11.729,15h4.5938A1.9906,1.9906,0,0,0,18.18,13.7427L19.7612,9.79a2.0019,2.0019,0,0,0-.0674-1.6382L17.6843,4.1323A11.9592,11.9592,0,0,1,26.8945,21H23a2.0023,2.0023,0,0,0-2,2v3.8945A11.9477,11.9477,0,0,1,5.1055,21ZM23,25.7266V23h2.7268A12.0762,12.0762,0,0,1,23,25.7266Z"}),props.children);});var EarthSoutheastAsia16=/*#__PURE__*/React.forwardRef(function EarthSoutheastAsia16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"3",height:"2",x:"14",y:"24"}),React.createElement("rect",{width:"2",height:"2",x:"17",y:"22"}),React.createElement("rect",{width:"2",height:"2",x:"17",y:"18"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2Zm-.603,2.03,2.5073,5.0156L16.3228,13H10.271l-1.41,4.3872,2.8521,2.8521L10.7056,21.751,6.2856,19H4.395A11.9363,11.9363,0,0,1,15.397,4.03ZM5.1055,21h.6089l3.9345,2.4487A1.9912,1.9912,0,0,0,12.37,22.86l1.0078-1.5118a2.005,2.005,0,0,0-.25-2.5234l-1.9887-1.9888L11.729,15h4.5938A1.9906,1.9906,0,0,0,18.18,13.7427L19.7612,9.79a2.0019,2.0019,0,0,0-.0674-1.6382L17.6843,4.1323A11.9592,11.9592,0,0,1,26.8945,21H23a2.0023,2.0023,0,0,0-2,2v3.8945A11.9477,11.9477,0,0,1,5.1055,21ZM23,25.7266V23h2.7268A12.0762,12.0762,0,0,1,23,25.7266Z"}),props.children);});var Earth32=/*#__PURE__*/React.forwardRef(function Earth32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2Zm5,3.1055a12.0136,12.0136,0,0,1,2.9158,1.8994L23.5034,8H21ZM13.3784,27.7026A11.9761,11.9761,0,0,1,8.1157,6.9761L9.4648,9h3.3423l-1.5,4H7.2793L5.8967,17.1475,8.4648,21h5l1.4319,2.1475ZM16,28c-.2034,0-.4016-.02-.6025-.03l1.3967-4.19a1.9876,1.9876,0,0,0-.2334-1.7412l-1.4319-2.1475A1.9962,1.9962,0,0,0,13.4648,19h-3.93L8.1033,16.8525,8.7207,15H11v2h2V14.1812l2.9363-7.83-1.8726-.7022L13.5571,7H10.5352L9.728,5.7891A11.7941,11.7941,0,0,1,19,4.395V8a2.0025,2.0025,0,0,0,2,2h2.5857A1.9865,1.9865,0,0,0,25,9.4141l.1406-.1407.2818-.68A11.9813,11.9813,0,0,1,27.3,12H22.5986a1.9927,1.9927,0,0,0-1.9719,1.665L20.03,17.1064a1.99,1.99,0,0,0,.991,2.086l2.1647,1.4638,1.4585,3.646A11.9577,11.9577,0,0,1,16,28Zm8.8145-8.6563L22.1,17.5088l-.1-.06L22.5986,14h5.2207a11.743,11.743,0,0,1-1.7441,8.4951Z"}),props.children);});var Earth24=/*#__PURE__*/React.forwardRef(function Earth24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2Zm5,3.1055a12.0136,12.0136,0,0,1,2.9158,1.8994L23.5034,8H21ZM13.3784,27.7026A11.9761,11.9761,0,0,1,8.1157,6.9761L9.4648,9h3.3423l-1.5,4H7.2793L5.8967,17.1475,8.4648,21h5l1.4319,2.1475ZM16,28c-.2034,0-.4016-.02-.6025-.03l1.3967-4.19a1.9876,1.9876,0,0,0-.2334-1.7412l-1.4319-2.1475A1.9962,1.9962,0,0,0,13.4648,19h-3.93L8.1033,16.8525,8.7207,15H11v2h2V14.1812l2.9363-7.83-1.8726-.7022L13.5571,7H10.5352L9.728,5.7891A11.7941,11.7941,0,0,1,19,4.395V8a2.0025,2.0025,0,0,0,2,2h2.5857A1.9865,1.9865,0,0,0,25,9.4141l.1406-.1407.2818-.68A11.9813,11.9813,0,0,1,27.3,12H22.5986a1.9927,1.9927,0,0,0-1.9719,1.665L20.03,17.1064a1.99,1.99,0,0,0,.991,2.086l2.1647,1.4638,1.4585,3.646A11.9577,11.9577,0,0,1,16,28Zm8.8145-8.6563L22.1,17.5088l-.1-.06L22.5986,14h5.2207a11.743,11.743,0,0,1-1.7441,8.4951Z"}),props.children);});var Earth20=/*#__PURE__*/React.forwardRef(function Earth20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2Zm5,3.1055a12.0136,12.0136,0,0,1,2.9158,1.8994L23.5034,8H21ZM13.3784,27.7026A11.9761,11.9761,0,0,1,8.1157,6.9761L9.4648,9h3.3423l-1.5,4H7.2793L5.8967,17.1475,8.4648,21h5l1.4319,2.1475ZM16,28c-.2034,0-.4016-.02-.6025-.03l1.3967-4.19a1.9876,1.9876,0,0,0-.2334-1.7412l-1.4319-2.1475A1.9962,1.9962,0,0,0,13.4648,19h-3.93L8.1033,16.8525,8.7207,15H11v2h2V14.1812l2.9363-7.83-1.8726-.7022L13.5571,7H10.5352L9.728,5.7891A11.7941,11.7941,0,0,1,19,4.395V8a2.0025,2.0025,0,0,0,2,2h2.5857A1.9865,1.9865,0,0,0,25,9.4141l.1406-.1407.2818-.68A11.9813,11.9813,0,0,1,27.3,12H22.5986a1.9927,1.9927,0,0,0-1.9719,1.665L20.03,17.1064a1.99,1.99,0,0,0,.991,2.086l2.1647,1.4638,1.4585,3.646A11.9577,11.9577,0,0,1,16,28Zm8.8145-8.6563L22.1,17.5088l-.1-.06L22.5986,14h5.2207a11.743,11.743,0,0,1-1.7441,8.4951Z"}),props.children);});var Earth16=/*#__PURE__*/React.forwardRef(function Earth16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14.0158,14.0158,0,0,0,16,2Zm5,3.1055a12.0136,12.0136,0,0,1,2.9158,1.8994L23.5034,8H21ZM13.3784,27.7026A11.9761,11.9761,0,0,1,8.1157,6.9761L9.4648,9h3.3423l-1.5,4H7.2793L5.8967,17.1475,8.4648,21h5l1.4319,2.1475ZM16,28c-.2034,0-.4016-.02-.6025-.03l1.3967-4.19a1.9876,1.9876,0,0,0-.2334-1.7412l-1.4319-2.1475A1.9962,1.9962,0,0,0,13.4648,19h-3.93L8.1033,16.8525,8.7207,15H11v2h2V14.1812l2.9363-7.83-1.8726-.7022L13.5571,7H10.5352L9.728,5.7891A11.7941,11.7941,0,0,1,19,4.395V8a2.0025,2.0025,0,0,0,2,2h2.5857A1.9865,1.9865,0,0,0,25,9.4141l.1406-.1407.2818-.68A11.9813,11.9813,0,0,1,27.3,12H22.5986a1.9927,1.9927,0,0,0-1.9719,1.665L20.03,17.1064a1.99,1.99,0,0,0,.991,2.086l2.1647,1.4638,1.4585,3.646A11.9577,11.9577,0,0,1,16,28Zm8.8145-8.6563L22.1,17.5088l-.1-.06L22.5986,14h5.2207a11.743,11.743,0,0,1-1.7441,8.4951Z"}),props.children);});var EditOff32=/*#__PURE__*/React.forwardRef(function EditOff32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,28.6L3.4,2L2,3.4l10.1,10.1L4,21.6V28h6.4l8.1-8.1L28.6,30L30,28.6z M9.6,26H6v-3.6l7.5-7.5l3.6,3.6L9.6,26z"}),React.createElement("path",{d:"M29.4,6.2L29.4,6.2l-3.6-3.6c-0.8-0.8-2-0.8-2.8,0l0,0l0,0l-8,8l1.4,1.4L20,8.4l3.6,3.6L20,15.6l1.4,1.4l8-8\tC30.2,8.2,30.2,7,29.4,6.2L29.4,6.2z M25,10.6L21.4,7l3-3L28,7.6L25,10.6z"}),props.children);});var EditOff24=/*#__PURE__*/React.forwardRef(function EditOff24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,28.6L3.4,2L2,3.4l10.1,10.1L4,21.6V28h6.4l8.1-8.1L28.6,30L30,28.6z M9.6,26H6v-3.6l7.5-7.5l3.6,3.6L9.6,26z"}),React.createElement("path",{d:"M29.4,6.2L29.4,6.2l-3.6-3.6c-0.8-0.8-2-0.8-2.8,0l0,0l0,0l-8,8l1.4,1.4L20,8.4l3.6,3.6L20,15.6l1.4,1.4l8-8\tC30.2,8.2,30.2,7,29.4,6.2L29.4,6.2z M25,10.6L21.4,7l3-3L28,7.6L25,10.6z"}),props.children);});var EditOff20=/*#__PURE__*/React.forwardRef(function EditOff20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,28.6L3.4,2L2,3.4l10.1,10.1L4,21.6V28h6.4l8.1-8.1L28.6,30L30,28.6z M9.6,26H6v-3.6l7.5-7.5l3.6,3.6L9.6,26z"}),React.createElement("path",{d:"M29.4,6.2L29.4,6.2l-3.6-3.6c-0.8-0.8-2-0.8-2.8,0l0,0l0,0l-8,8l1.4,1.4L20,8.4l3.6,3.6L20,15.6l1.4,1.4l8-8\tC30.2,8.2,30.2,7,29.4,6.2L29.4,6.2z M25,10.6L21.4,7l3-3L28,7.6L25,10.6z"}),props.children);});var EditOff16=/*#__PURE__*/React.forwardRef(function EditOff16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,28.6L3.4,2L2,3.4l10.1,10.1L4,21.6V28h6.4l8.1-8.1L28.6,30L30,28.6z M9.6,26H6v-3.6l7.5-7.5l3.6,3.6L9.6,26z"}),React.createElement("path",{d:"M29.4,6.2L29.4,6.2l-3.6-3.6c-0.8-0.8-2-0.8-2.8,0l0,0l0,0l-8,8l1.4,1.4L20,8.4l3.6,3.6L20,15.6l1.4,1.4l8-8\tC30.2,8.2,30.2,7,29.4,6.2L29.4,6.2z M25,10.6L21.4,7l3-3L28,7.6L25,10.6z"}),props.children);});var Edit32=/*#__PURE__*/React.forwardRef(function Edit32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"26"}),React.createElement("path",{d:"M25.4,9c0.8-0.8,0.8-2,0-2.8c0,0,0,0,0,0l-3.6-3.6c-0.8-0.8-2-0.8-2.8,0c0,0,0,0,0,0l-15,15V24h6.4L25.4,9z M20.4,4L24,7.6\tl-3,3L17.4,7L20.4,4z M6,22v-3.6l10-10l3.6,3.6l-10,10H6z"}),props.children);});var Edit24=/*#__PURE__*/React.forwardRef(function Edit24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"26"}),React.createElement("path",{d:"M25.4,9c0.8-0.8,0.8-2,0-2.8c0,0,0,0,0,0l-3.6-3.6c-0.8-0.8-2-0.8-2.8,0c0,0,0,0,0,0l-15,15V24h6.4L25.4,9z M20.4,4L24,7.6\tl-3,3L17.4,7L20.4,4z M6,22v-3.6l10-10l3.6,3.6l-10,10H6z"}),props.children);});var Edit20=/*#__PURE__*/React.forwardRef(function Edit20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"26"}),React.createElement("path",{d:"M25.4,9c0.8-0.8,0.8-2,0-2.8c0,0,0,0,0,0l-3.6-3.6c-0.8-0.8-2-0.8-2.8,0c0,0,0,0,0,0l-15,15V24h6.4L25.4,9z M20.4,4L24,7.6\tl-3,3L17.4,7L20.4,4z M6,22v-3.6l10-10l3.6,3.6l-10,10H6z"}),props.children);});var Edit16=/*#__PURE__*/React.forwardRef(function Edit16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"26"}),React.createElement("path",{d:"M25.4,9c0.8-0.8,0.8-2,0-2.8c0,0,0,0,0,0l-3.6-3.6c-0.8-0.8-2-0.8-2.8,0c0,0,0,0,0,0l-15,15V24h6.4L25.4,9z M20.4,4L24,7.6\tl-3,3L17.4,7L20.4,4z M6,22v-3.6l10-10l3.6,3.6l-10,10H6z"}),props.children);});var EdtLoop32=/*#__PURE__*/React.forwardRef(function EdtLoop32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.625,22.5875a6.1287,6.1287,0,0,1-4.5-1.9l-3.1-3.2-3.1,3.2a6.4582,6.4582,0,0,1-9.1,0,7.028,7.028,0,0,1-1.8-4.7,6.6547,6.6547,0,0,1,1.9-4.7,6.3375,6.3375,0,0,1,9,0l3.1,3.2,3.1-3.2a6.3375,6.3375,0,0,1,9,0,6.8282,6.8282,0,0,1,0,9.4A6.5418,6.5418,0,0,1,23.625,22.5875Zm-6.2-6.6,3.1,3.3a4.4061,4.4061,0,0,0,6.2,0,4.9077,4.9077,0,0,0,0-6.6,4.4061,4.4061,0,0,0-6.2,0Zm-9-4.6a4.1582,4.1582,0,0,0-3.1,1.3,4.8385,4.8385,0,0,0,0,6.6,4.4061,4.4061,0,0,0,6.2,0l3.1-3.3-3.1-3.3A4.7706,4.7706,0,0,0,8.425,11.3875Z"}),props.children);});var EdtLoop24=/*#__PURE__*/React.forwardRef(function EdtLoop24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.625,22.5875a6.1287,6.1287,0,0,1-4.5-1.9l-3.1-3.2-3.1,3.2a6.4582,6.4582,0,0,1-9.1,0,7.028,7.028,0,0,1-1.8-4.7,6.6547,6.6547,0,0,1,1.9-4.7,6.3375,6.3375,0,0,1,9,0l3.1,3.2,3.1-3.2a6.3375,6.3375,0,0,1,9,0,6.8282,6.8282,0,0,1,0,9.4A6.5418,6.5418,0,0,1,23.625,22.5875Zm-6.2-6.6,3.1,3.3a4.4061,4.4061,0,0,0,6.2,0,4.9077,4.9077,0,0,0,0-6.6,4.4061,4.4061,0,0,0-6.2,0Zm-9-4.6a4.1582,4.1582,0,0,0-3.1,1.3,4.8385,4.8385,0,0,0,0,6.6,4.4061,4.4061,0,0,0,6.2,0l3.1-3.3-3.1-3.3A4.7706,4.7706,0,0,0,8.425,11.3875Z"}),props.children);});var EdtLoop20=/*#__PURE__*/React.forwardRef(function EdtLoop20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.625,22.5875a6.1287,6.1287,0,0,1-4.5-1.9l-3.1-3.2-3.1,3.2a6.4582,6.4582,0,0,1-9.1,0,7.028,7.028,0,0,1-1.8-4.7,6.6547,6.6547,0,0,1,1.9-4.7,6.3375,6.3375,0,0,1,9,0l3.1,3.2,3.1-3.2a6.3375,6.3375,0,0,1,9,0,6.8282,6.8282,0,0,1,0,9.4A6.5418,6.5418,0,0,1,23.625,22.5875Zm-6.2-6.6,3.1,3.3a4.4061,4.4061,0,0,0,6.2,0,4.9077,4.9077,0,0,0,0-6.6,4.4061,4.4061,0,0,0-6.2,0Zm-9-4.6a4.1582,4.1582,0,0,0-3.1,1.3,4.8385,4.8385,0,0,0,0,6.6,4.4061,4.4061,0,0,0,6.2,0l3.1-3.3-3.1-3.3A4.7706,4.7706,0,0,0,8.425,11.3875Z"}),props.children);});var EdtLoop16=/*#__PURE__*/React.forwardRef(function EdtLoop16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23.625,22.5875a6.1287,6.1287,0,0,1-4.5-1.9l-3.1-3.2-3.1,3.2a6.4582,6.4582,0,0,1-9.1,0,7.028,7.028,0,0,1-1.8-4.7,6.6547,6.6547,0,0,1,1.9-4.7,6.3375,6.3375,0,0,1,9,0l3.1,3.2,3.1-3.2a6.3375,6.3375,0,0,1,9,0,6.8282,6.8282,0,0,1,0,9.4A6.5418,6.5418,0,0,1,23.625,22.5875Zm-6.2-6.6,3.1,3.3a4.4061,4.4061,0,0,0,6.2,0,4.9077,4.9077,0,0,0,0-6.6,4.4061,4.4061,0,0,0-6.2,0Zm-9-4.6a4.1582,4.1582,0,0,0-3.1,1.3,4.8385,4.8385,0,0,0,0,6.6,4.4061,4.4061,0,0,0,6.2,0l3.1-3.3-3.1-3.3A4.7706,4.7706,0,0,0,8.425,11.3875Z"}),props.children);});var Education32=/*#__PURE__*/React.forwardRef(function Education32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,30H24V27a5.0059,5.0059,0,0,0-5-5H13a5.0059,5.0059,0,0,0-5,5v3H6V27a7.0082,7.0082,0,0,1,7-7h6a7.0082,7.0082,0,0,1,7,7Z"}),React.createElement("path",{d:"M5,6A1,1,0,0,0,4,7v9H6V7A1,1,0,0,0,5,6Z"}),React.createElement("path",{d:"M4,2V4H9v7a7,7,0,0,0,14,0V4h5V2Zm7,2H21V7H11Zm5,12a5,5,0,0,1-5-5V9H21v2A5,5,0,0,1,16,16Z"}),props.children);});var Education24=/*#__PURE__*/React.forwardRef(function Education24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,30H24V27a5.0059,5.0059,0,0,0-5-5H13a5.0059,5.0059,0,0,0-5,5v3H6V27a7.0082,7.0082,0,0,1,7-7h6a7.0082,7.0082,0,0,1,7,7Z"}),React.createElement("path",{d:"M5,6A1,1,0,0,0,4,7v9H6V7A1,1,0,0,0,5,6Z"}),React.createElement("path",{d:"M4,2V4H9v7a7,7,0,0,0,14,0V4h5V2Zm7,2H21V7H11Zm5,12a5,5,0,0,1-5-5V9H21v2A5,5,0,0,1,16,16Z"}),props.children);});var Education20=/*#__PURE__*/React.forwardRef(function Education20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,30H24V27a5.0059,5.0059,0,0,0-5-5H13a5.0059,5.0059,0,0,0-5,5v3H6V27a7.0082,7.0082,0,0,1,7-7h6a7.0082,7.0082,0,0,1,7,7Z"}),React.createElement("path",{d:"M5,6A1,1,0,0,0,4,7v9H6V7A1,1,0,0,0,5,6Z"}),React.createElement("path",{d:"M4,2V4H9v7a7,7,0,0,0,14,0V4h5V2Zm7,2H21V7H11Zm5,12a5,5,0,0,1-5-5V9H21v2A5,5,0,0,1,16,16Z"}),props.children);});var Education16=/*#__PURE__*/React.forwardRef(function Education16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,30H24V27a5.0059,5.0059,0,0,0-5-5H13a5.0059,5.0059,0,0,0-5,5v3H6V27a7.0082,7.0082,0,0,1,7-7h6a7.0082,7.0082,0,0,1,7,7Z"}),React.createElement("path",{d:"M5,6A1,1,0,0,0,4,7v9H6V7A1,1,0,0,0,5,6Z"}),React.createElement("path",{d:"M4,2V4H9v7a7,7,0,0,0,14,0V4h5V2Zm7,2H21V7H11Zm5,12a5,5,0,0,1-5-5V9H21v2A5,5,0,0,1,16,16Z"}),props.children);});var EmailNew32=/*#__PURE__*/React.forwardRef(function EmailNew32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,24H4L3.9966,8.9062l11.4341,7.9161a1.0008,1.0008,0,0,0,1.1386,0L28,8.9087,28,18h2V8a2.0027,2.0027,0,0,0-2-2H4A2.0023,2.0023,0,0,0,2,8V24a2.0027,2.0027,0,0,0,2,2H19ZM25.7986,8,16,14.7837,6.2014,8Z"}),React.createElement("circle",{cx:"26",cy:"24",r:"4"}),props.children);});var EmailNew24=/*#__PURE__*/React.forwardRef(function EmailNew24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,24H4L3.9966,8.9062l11.4341,7.9161a1.0008,1.0008,0,0,0,1.1386,0L28,8.9087,28,18h2V8a2.0027,2.0027,0,0,0-2-2H4A2.0023,2.0023,0,0,0,2,8V24a2.0027,2.0027,0,0,0,2,2H19ZM25.7986,8,16,14.7837,6.2014,8Z"}),React.createElement("circle",{cx:"26",cy:"24",r:"4"}),props.children);});var EmailNew20=/*#__PURE__*/React.forwardRef(function EmailNew20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,24H4L3.9966,8.9062l11.4341,7.9161a1.0008,1.0008,0,0,0,1.1386,0L28,8.9087,28,18h2V8a2.0027,2.0027,0,0,0-2-2H4A2.0023,2.0023,0,0,0,2,8V24a2.0027,2.0027,0,0,0,2,2H19ZM25.7986,8,16,14.7837,6.2014,8Z"}),React.createElement("circle",{cx:"26",cy:"24",r:"4"}),props.children);});var EmailNew16=/*#__PURE__*/React.forwardRef(function EmailNew16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,24H4L3.9966,8.9062l11.4341,7.9161a1.0008,1.0008,0,0,0,1.1386,0L28,8.9087,28,18h2V8a2.0027,2.0027,0,0,0-2-2H4A2.0023,2.0023,0,0,0,2,8V24a2.0027,2.0027,0,0,0,2,2H19ZM25.7986,8,16,14.7837,6.2014,8Z"}),React.createElement("circle",{cx:"26",cy:"24",r:"4"}),props.children);});var Email32=/*#__PURE__*/React.forwardRef(function Email32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM25.8,8,16,14.78,6.2,8ZM4,24V8.91l11.43,7.91a1,1,0,0,0,1.14,0L28,8.91V24Z"}),props.children);});var Email24=/*#__PURE__*/React.forwardRef(function Email24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM25.8,8,16,14.78,6.2,8ZM4,24V8.91l11.43,7.91a1,1,0,0,0,1.14,0L28,8.91V24Z"}),props.children);});var Email20=/*#__PURE__*/React.forwardRef(function Email20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM25.8,8,16,14.78,6.2,8ZM4,24V8.91l11.43,7.91a1,1,0,0,0,1.14,0L28,8.91V24Z"}),props.children);});var Email16=/*#__PURE__*/React.forwardRef(function Email16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H4A2,2,0,0,0,2,8V24a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V8A2,2,0,0,0,28,6ZM25.8,8,16,14.78,6.2,8ZM4,24V8.91l11.43,7.91a1,1,0,0,0,1.14,0L28,8.91V24Z"}),props.children);});var Enterprise32=/*#__PURE__*/React.forwardRef(function Enterprise32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4",x:"8",y:"8"}),React.createElement("rect",{width:"2",height:"4",x:"8",y:"14"}),React.createElement("rect",{width:"2",height:"4",x:"14",y:"8"}),React.createElement("rect",{width:"2",height:"4",x:"14",y:"14"}),React.createElement("rect",{width:"2",height:"4",x:"8",y:"20"}),React.createElement("rect",{width:"2",height:"4",x:"14",y:"20"}),React.createElement("path",{d:"M30,14a2,2,0,0,0-2-2H22V4a2,2,0,0,0-2-2H4A2,2,0,0,0,2,4V30H30ZM4,4H20V28H4ZM22,28V14h6V28Z"}),props.children);});var Enterprise24=/*#__PURE__*/React.forwardRef(function Enterprise24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4",x:"8",y:"8"}),React.createElement("rect",{width:"2",height:"4",x:"8",y:"14"}),React.createElement("rect",{width:"2",height:"4",x:"14",y:"8"}),React.createElement("rect",{width:"2",height:"4",x:"14",y:"14"}),React.createElement("rect",{width:"2",height:"4",x:"8",y:"20"}),React.createElement("rect",{width:"2",height:"4",x:"14",y:"20"}),React.createElement("path",{d:"M30,14a2,2,0,0,0-2-2H22V4a2,2,0,0,0-2-2H4A2,2,0,0,0,2,4V30H30ZM4,4H20V28H4ZM22,28V14h6V28Z"}),props.children);});var Enterprise20=/*#__PURE__*/React.forwardRef(function Enterprise20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4",x:"8",y:"8"}),React.createElement("rect",{width:"2",height:"4",x:"8",y:"14"}),React.createElement("rect",{width:"2",height:"4",x:"14",y:"8"}),React.createElement("rect",{width:"2",height:"4",x:"14",y:"14"}),React.createElement("rect",{width:"2",height:"4",x:"8",y:"20"}),React.createElement("rect",{width:"2",height:"4",x:"14",y:"20"}),React.createElement("path",{d:"M30,14a2,2,0,0,0-2-2H22V4a2,2,0,0,0-2-2H4A2,2,0,0,0,2,4V30H30ZM4,4H20V28H4ZM22,28V14h6V28Z"}),props.children);});var Enterprise16=/*#__PURE__*/React.forwardRef(function Enterprise16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"4",x:"8",y:"8"}),React.createElement("rect",{width:"2",height:"4",x:"8",y:"14"}),React.createElement("rect",{width:"2",height:"4",x:"14",y:"8"}),React.createElement("rect",{width:"2",height:"4",x:"14",y:"14"}),React.createElement("rect",{width:"2",height:"4",x:"8",y:"20"}),React.createElement("rect",{width:"2",height:"4",x:"14",y:"20"}),React.createElement("path",{d:"M30,14a2,2,0,0,0-2-2H22V4a2,2,0,0,0-2-2H4A2,2,0,0,0,2,4V30H30ZM4,4H20V28H4ZM22,28V14h6V28Z"}),props.children);});var Erase32=/*#__PURE__*/React.forwardRef(function Erase32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"23",height:"2",x:"7",y:"27"}),React.createElement("path",{d:"M27.38,10.51,19.45,2.59a2,2,0,0,0-2.83,0l-14,14a2,2,0,0,0,0,2.83L7.13,24h9.59L27.38,13.34A2,2,0,0,0,27.38,10.51ZM15.89,22H8L4,18l6.31-6.31,7.93,7.92Zm3.76-3.76-7.92-7.93L18,4,26,11.93Z"}),props.children);});var Erase24=/*#__PURE__*/React.forwardRef(function Erase24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"23",height:"2",x:"7",y:"27"}),React.createElement("path",{d:"M27.38,10.51,19.45,2.59a2,2,0,0,0-2.83,0l-14,14a2,2,0,0,0,0,2.83L7.13,24h9.59L27.38,13.34A2,2,0,0,0,27.38,10.51ZM15.89,22H8L4,18l6.31-6.31,7.93,7.92Zm3.76-3.76-7.92-7.93L18,4,26,11.93Z"}),props.children);});var Erase20=/*#__PURE__*/React.forwardRef(function Erase20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"23",height:"2",x:"7",y:"27"}),React.createElement("path",{d:"M27.38,10.51,19.45,2.59a2,2,0,0,0-2.83,0l-14,14a2,2,0,0,0,0,2.83L7.13,24h9.59L27.38,13.34A2,2,0,0,0,27.38,10.51ZM15.89,22H8L4,18l6.31-6.31,7.93,7.92Zm3.76-3.76-7.92-7.93L18,4,26,11.93Z"}),props.children);});var Erase16=/*#__PURE__*/React.forwardRef(function Erase16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"23",height:"2",x:"7",y:"27"}),React.createElement("path",{d:"M27.38,10.51,19.45,2.59a2,2,0,0,0-2.83,0l-14,14a2,2,0,0,0,0,2.83L7.13,24h9.59L27.38,13.34A2,2,0,0,0,27.38,10.51ZM15.89,22H8L4,18l6.31-6.31,7.93,7.92Zm3.76-3.76-7.92-7.93L18,4,26,11.93Z"}),props.children);});var ErrorFilled32=/*#__PURE__*/React.forwardRef(function ErrorFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.2,2,2,8.2,2,16s6.2,14,14,14s14-6.2,14-14S23.8,2,16,2z M21.4,23L9,10.6L10.6,9L23,21.4L21.4,23z"}),React.createElement("path",{fill:"none",d:"M21.4,23L9,10.6L10.6,9L23,21.4L21.4,23z","data-icon-path":"inner-path",opacity:"0"}),props.children);});var ErrorOutline32=/*#__PURE__*/React.forwardRef(function ErrorOutline32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.2,2,2,8.2,2,16s6.2,14,14,14s14-6.2,14-14S23.8,2,16,2z M16,28C9.4,28,4,22.6,4,16S9.4,4,16,4s12,5.4,12,12\tS22.6,28,16,28z"}),React.createElement("rect",{width:"2.2",height:"17.6",x:"14.8",y:"7.3",transform:"rotate(-45.001 15.929 16.071)"}),props.children);});var ErrorOutline24=/*#__PURE__*/React.forwardRef(function ErrorOutline24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.2,2,2,8.2,2,16s6.2,14,14,14s14-6.2,14-14S23.8,2,16,2z M16,28C9.4,28,4,22.6,4,16S9.4,4,16,4s12,5.4,12,12\tS22.6,28,16,28z"}),React.createElement("rect",{width:"2.2",height:"17.6",x:"14.8",y:"7.3",transform:"rotate(-45.001 15.929 16.071)"}),props.children);});var ErrorOutline20=/*#__PURE__*/React.forwardRef(function ErrorOutline20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2C8.2,2,2,8.2,2,16s6.2,14,14,14s14-6.2,14-14S23.8,2,16,2z M16,28C9.4,28,4,22.6,4,16S9.4,4,16,4s12,5.4,12,12\tS22.6,28,16,28z"}),React.createElement("rect",{width:"2.2",height:"17.6",x:"14.8",y:"7.3",transform:"rotate(-45.001 15.929 16.071)"}),props.children);});var Error32=/*#__PURE__*/React.forwardRef(function Error32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2,16H2A14,14,0,1,0,16,2,14,14,0,0,0,2,16Zm23.15,7.75L8.25,6.85a12,12,0,0,1,16.9,16.9ZM8.24,25.16A12,12,0,0,1,6.84,8.27L23.73,25.16a12,12,0,0,1-15.49,0Z"}),props.children);});var Error24=/*#__PURE__*/React.forwardRef(function Error24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2,16H2A14,14,0,1,0,16,2,14,14,0,0,0,2,16Zm23.15,7.75L8.25,6.85a12,12,0,0,1,16.9,16.9ZM8.24,25.16A12,12,0,0,1,6.84,8.27L23.73,25.16a12,12,0,0,1-15.49,0Z"}),props.children);});var Error20=/*#__PURE__*/React.forwardRef(function Error20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2,16H2A14,14,0,1,0,16,2,14,14,0,0,0,2,16Zm23.15,7.75L8.25,6.85a12,12,0,0,1,16.9,16.9ZM8.24,25.16A12,12,0,0,1,6.84,8.27L23.73,25.16a12,12,0,0,1-15.49,0Z"}),props.children);});var Error16=/*#__PURE__*/React.forwardRef(function Error16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M2,16H2A14,14,0,1,0,16,2,14,14,0,0,0,2,16Zm23.15,7.75L8.25,6.85a12,12,0,0,1,16.9,16.9ZM8.24,25.16A12,12,0,0,1,6.84,8.27L23.73,25.16a12,12,0,0,1-15.49,0Z"}),props.children);});var EventSchedule32=/*#__PURE__*/React.forwardRef(function EventSchedule32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21,30a8,8,0,1,1,8-8A8,8,0,0,1,21,30Zm0-14a6,6,0,1,0,6,6A6,6,0,0,0,21,16Z"}),React.createElement("polygon",{points:"22.59 25 20 22.41 20 18 22 18 22 21.59 24 23.59 22.59 25"}),React.createElement("path",{d:"M28,6a2,2,0,0,0-2-2H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h4V26H6V6h4V8h2V6h8V8h2V6h4v6h2Z"}),props.children);});var EventSchedule24=/*#__PURE__*/React.forwardRef(function EventSchedule24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21,30a8,8,0,1,1,8-8A8,8,0,0,1,21,30Zm0-14a6,6,0,1,0,6,6A6,6,0,0,0,21,16Z"}),React.createElement("polygon",{points:"22.59 25 20 22.41 20 18 22 18 22 21.59 24 23.59 22.59 25"}),React.createElement("path",{d:"M28,6a2,2,0,0,0-2-2H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h4V26H6V6h4V8h2V6h8V8h2V6h4v6h2Z"}),props.children);});var EventSchedule20=/*#__PURE__*/React.forwardRef(function EventSchedule20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21,30a8,8,0,1,1,8-8A8,8,0,0,1,21,30Zm0-14a6,6,0,1,0,6,6A6,6,0,0,0,21,16Z"}),React.createElement("polygon",{points:"22.59 25 20 22.41 20 18 22 18 22 21.59 24 23.59 22.59 25"}),React.createElement("path",{d:"M28,6a2,2,0,0,0-2-2H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h4V26H6V6h4V8h2V6h8V8h2V6h4v6h2Z"}),props.children);});var EventSchedule16=/*#__PURE__*/React.forwardRef(function EventSchedule16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M21,30a8,8,0,1,1,8-8A8,8,0,0,1,21,30Zm0-14a6,6,0,1,0,6,6A6,6,0,0,0,21,16Z"}),React.createElement("polygon",{points:"22.59 25 20 22.41 20 18 22 18 22 21.59 24 23.59 22.59 25"}),React.createElement("path",{d:"M28,6a2,2,0,0,0-2-2H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h4V26H6V6h4V8h2V6h8V8h2V6h4v6h2Z"}),props.children);});var Event32=/*#__PURE__*/React.forwardRef(function Event32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6a2,2,0,0,0-2-2H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h4V26H6V6h4V8h2V6h8V8h2V6h4v6h2Z"}),React.createElement("polygon",{points:"21 15 23.549 19.938 29 20.729 25 24.573 26 30 21 27.438 16 30 17 24.573 13 20.729 18.6 19.938 21 15"}),props.children);});var Event24=/*#__PURE__*/React.forwardRef(function Event24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6a2,2,0,0,0-2-2H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h4V26H6V6h4V8h2V6h8V8h2V6h4v6h2Z"}),React.createElement("polygon",{points:"21 15 23.549 19.938 29 20.729 25 24.573 26 30 21 27.438 16 30 17 24.573 13 20.729 18.6 19.938 21 15"}),props.children);});var Event20=/*#__PURE__*/React.forwardRef(function Event20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6a2,2,0,0,0-2-2H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h4V26H6V6h4V8h2V6h8V8h2V6h4v6h2Z"}),React.createElement("polygon",{points:"21 15 23.549 19.938 29 20.729 25 24.573 26 30 21 27.438 16 30 17 24.573 13 20.729 18.6 19.938 21 15"}),props.children);});var Event16=/*#__PURE__*/React.forwardRef(function Event16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6a2,2,0,0,0-2-2H22V2H20V4H12V2H10V4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2h4V26H6V6h4V8h2V6h8V8h2V6h4v6h2Z"}),React.createElement("polygon",{points:"21 15 23.549 19.938 29 20.729 25 24.573 26 30 21 27.438 16 30 17 24.573 13 20.729 18.6 19.938 21 15"}),props.children);});var EventsAlt32=/*#__PURE__*/React.forwardRef(function EventsAlt32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,31h2V29a1.0006,1.0006,0,0,1,1-1h6a1.0006,1.0006,0,0,1,1,1v2h2V29a3.0033,3.0033,0,0,0-3-3H21a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M24,25a4,4,0,1,1,4-4A4.0039,4.0039,0,0,1,24,25Zm0-6a2,2,0,1,0,2,2A2.0027,2.0027,0,0,0,24,19Z"}),React.createElement("path",{d:"M2,31H4V29a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1v2h2V29a3.0033,3.0033,0,0,0-3-3H5a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M8,25a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,8,25Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,8,19Z"}),React.createElement("path",{d:"M18,16h2V14a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1v2h2V14a3.0033,3.0033,0,0,0-3-3H21a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M24,10a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,24,10Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,24,4Z"}),React.createElement("path",{d:"M2,16H4V14a1.0013,1.0013,0,0,1,1-1h6a1.0013,1.0013,0,0,1,1,1v2h2V14a3.0033,3.0033,0,0,0-3-3H5a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M8,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,8,10ZM8,4a2,2,0,1,0,2,2A2.002,2.002,0,0,0,8,4Z"}),props.children);});var EventsAlt24=/*#__PURE__*/React.forwardRef(function EventsAlt24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,31h2V29a1.0006,1.0006,0,0,1,1-1h6a1.0006,1.0006,0,0,1,1,1v2h2V29a3.0033,3.0033,0,0,0-3-3H21a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M24,25a4,4,0,1,1,4-4A4.0039,4.0039,0,0,1,24,25Zm0-6a2,2,0,1,0,2,2A2.0027,2.0027,0,0,0,24,19Z"}),React.createElement("path",{d:"M2,31H4V29a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1v2h2V29a3.0033,3.0033,0,0,0-3-3H5a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M8,25a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,8,25Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,8,19Z"}),React.createElement("path",{d:"M18,16h2V14a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1v2h2V14a3.0033,3.0033,0,0,0-3-3H21a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M24,10a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,24,10Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,24,4Z"}),React.createElement("path",{d:"M2,16H4V14a1.0013,1.0013,0,0,1,1-1h6a1.0013,1.0013,0,0,1,1,1v2h2V14a3.0033,3.0033,0,0,0-3-3H5a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M8,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,8,10ZM8,4a2,2,0,1,0,2,2A2.002,2.002,0,0,0,8,4Z"}),props.children);});var EventsAlt20=/*#__PURE__*/React.forwardRef(function EventsAlt20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,31h2V29a1.0006,1.0006,0,0,1,1-1h6a1.0006,1.0006,0,0,1,1,1v2h2V29a3.0033,3.0033,0,0,0-3-3H21a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M24,25a4,4,0,1,1,4-4A4.0039,4.0039,0,0,1,24,25Zm0-6a2,2,0,1,0,2,2A2.0027,2.0027,0,0,0,24,19Z"}),React.createElement("path",{d:"M2,31H4V29a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1v2h2V29a3.0033,3.0033,0,0,0-3-3H5a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M8,25a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,8,25Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,8,19Z"}),React.createElement("path",{d:"M18,16h2V14a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1v2h2V14a3.0033,3.0033,0,0,0-3-3H21a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M24,10a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,24,10Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,24,4Z"}),React.createElement("path",{d:"M2,16H4V14a1.0013,1.0013,0,0,1,1-1h6a1.0013,1.0013,0,0,1,1,1v2h2V14a3.0033,3.0033,0,0,0-3-3H5a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M8,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,8,10ZM8,4a2,2,0,1,0,2,2A2.002,2.002,0,0,0,8,4Z"}),props.children);});var EventsAlt16=/*#__PURE__*/React.forwardRef(function EventsAlt16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,31h2V29a1.0006,1.0006,0,0,1,1-1h6a1.0006,1.0006,0,0,1,1,1v2h2V29a3.0033,3.0033,0,0,0-3-3H21a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M24,25a4,4,0,1,1,4-4A4.0039,4.0039,0,0,1,24,25Zm0-6a2,2,0,1,0,2,2A2.0027,2.0027,0,0,0,24,19Z"}),React.createElement("path",{d:"M2,31H4V29a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1v2h2V29a3.0033,3.0033,0,0,0-3-3H5a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M8,25a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,8,25Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,8,19Z"}),React.createElement("path",{d:"M18,16h2V14a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1v2h2V14a3.0033,3.0033,0,0,0-3-3H21a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M24,10a4,4,0,1,1,4-4A4.0042,4.0042,0,0,1,24,10Zm0-6a2,2,0,1,0,2,2A2.0023,2.0023,0,0,0,24,4Z"}),React.createElement("path",{d:"M2,16H4V14a1.0013,1.0013,0,0,1,1-1h6a1.0013,1.0013,0,0,1,1,1v2h2V14a3.0033,3.0033,0,0,0-3-3H5a3.0033,3.0033,0,0,0-3,3Z"}),React.createElement("path",{d:"M8,10a4,4,0,1,1,4-4A4.0045,4.0045,0,0,1,8,10ZM8,4a2,2,0,1,0,2,2A2.002,2.002,0,0,0,8,4Z"}),props.children);});var Events32=/*#__PURE__*/React.forwardRef(function Events32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,14H24v2h2a3.0033,3.0033,0,0,1,3,3v4h2V19A5.0058,5.0058,0,0,0,26,14Z"}),React.createElement("path",{d:"M24,4a3,3,0,1,1-3,3,3,3,0,0,1,3-3m0-2a5,5,0,1,0,5,5A5,5,0,0,0,24,2Z"}),React.createElement("path",{d:"M23,30H21V28a3.0033,3.0033,0,0,0-3-3H14a3.0033,3.0033,0,0,0-3,3v2H9V28a5.0059,5.0059,0,0,1,5-5h4a5.0059,5.0059,0,0,1,5,5Z"}),React.createElement("path",{d:"M16,13a3,3,0,1,1-3,3,3,3,0,0,1,3-3m0-2a5,5,0,1,0,5,5A5,5,0,0,0,16,11Z"}),React.createElement("path",{d:"M8,14H6a5.0059,5.0059,0,0,0-5,5v4H3V19a3.0033,3.0033,0,0,1,3-3H8Z"}),React.createElement("path",{d:"M8,4A3,3,0,1,1,5,7,3,3,0,0,1,8,4M8,2a5,5,0,1,0,5,5A5,5,0,0,0,8,2Z"}),props.children);});var Events24=/*#__PURE__*/React.forwardRef(function Events24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,14H24v2h2a3.0033,3.0033,0,0,1,3,3v4h2V19A5.0058,5.0058,0,0,0,26,14Z"}),React.createElement("path",{d:"M24,4a3,3,0,1,1-3,3,3,3,0,0,1,3-3m0-2a5,5,0,1,0,5,5A5,5,0,0,0,24,2Z"}),React.createElement("path",{d:"M23,30H21V28a3.0033,3.0033,0,0,0-3-3H14a3.0033,3.0033,0,0,0-3,3v2H9V28a5.0059,5.0059,0,0,1,5-5h4a5.0059,5.0059,0,0,1,5,5Z"}),React.createElement("path",{d:"M16,13a3,3,0,1,1-3,3,3,3,0,0,1,3-3m0-2a5,5,0,1,0,5,5A5,5,0,0,0,16,11Z"}),React.createElement("path",{d:"M8,14H6a5.0059,5.0059,0,0,0-5,5v4H3V19a3.0033,3.0033,0,0,1,3-3H8Z"}),React.createElement("path",{d:"M8,4A3,3,0,1,1,5,7,3,3,0,0,1,8,4M8,2a5,5,0,1,0,5,5A5,5,0,0,0,8,2Z"}),props.children);});var Events20=/*#__PURE__*/React.forwardRef(function Events20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,14H24v2h2a3.0033,3.0033,0,0,1,3,3v4h2V19A5.0058,5.0058,0,0,0,26,14Z"}),React.createElement("path",{d:"M24,4a3,3,0,1,1-3,3,3,3,0,0,1,3-3m0-2a5,5,0,1,0,5,5A5,5,0,0,0,24,2Z"}),React.createElement("path",{d:"M23,30H21V28a3.0033,3.0033,0,0,0-3-3H14a3.0033,3.0033,0,0,0-3,3v2H9V28a5.0059,5.0059,0,0,1,5-5h4a5.0059,5.0059,0,0,1,5,5Z"}),React.createElement("path",{d:"M16,13a3,3,0,1,1-3,3,3,3,0,0,1,3-3m0-2a5,5,0,1,0,5,5A5,5,0,0,0,16,11Z"}),React.createElement("path",{d:"M8,14H6a5.0059,5.0059,0,0,0-5,5v4H3V19a3.0033,3.0033,0,0,1,3-3H8Z"}),React.createElement("path",{d:"M8,4A3,3,0,1,1,5,7,3,3,0,0,1,8,4M8,2a5,5,0,1,0,5,5A5,5,0,0,0,8,2Z"}),props.children);});var Events16=/*#__PURE__*/React.forwardRef(function Events16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,14H24v2h2a3.0033,3.0033,0,0,1,3,3v4h2V19A5.0058,5.0058,0,0,0,26,14Z"}),React.createElement("path",{d:"M24,4a3,3,0,1,1-3,3,3,3,0,0,1,3-3m0-2a5,5,0,1,0,5,5A5,5,0,0,0,24,2Z"}),React.createElement("path",{d:"M23,30H21V28a3.0033,3.0033,0,0,0-3-3H14a3.0033,3.0033,0,0,0-3,3v2H9V28a5.0059,5.0059,0,0,1,5-5h4a5.0059,5.0059,0,0,1,5,5Z"}),React.createElement("path",{d:"M16,13a3,3,0,1,1-3,3,3,3,0,0,1,3-3m0-2a5,5,0,1,0,5,5A5,5,0,0,0,16,11Z"}),React.createElement("path",{d:"M8,14H6a5.0059,5.0059,0,0,0-5,5v4H3V19a3.0033,3.0033,0,0,1,3-3H8Z"}),React.createElement("path",{d:"M8,4A3,3,0,1,1,5,7,3,3,0,0,1,8,4M8,2a5,5,0,1,0,5,5A5,5,0,0,0,8,2Z"}),props.children);});var ExamMode32=/*#__PURE__*/React.forwardRef(function ExamMode32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,23v3H7V16.83l3.59,3.58L12,19,6,13,0,19l1.41,1.41L5,16.83V26a2,2,0,0,0,2,2H25a2,2,0,0,0,2-2V23Z"}),React.createElement("path",{d:"M27,7v9.17l3.59-3.58L32,14l-6,6-6-6,1.41-1.41L25,16.17V7H13V5H25A2,2,0,0,1,27,7Z"}),React.createElement("path",{d:"M8,10H4A2,2,0,0,1,2,8V4A2,2,0,0,1,4,2H8a2,2,0,0,1,2,2V8A2,2,0,0,1,8,10ZM4,4V8H8V4Z"}),props.children);});var ExamMode24=/*#__PURE__*/React.forwardRef(function ExamMode24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,23v3H7V16.83l3.59,3.58L12,19,6,13,0,19l1.41,1.41L5,16.83V26a2,2,0,0,0,2,2H25a2,2,0,0,0,2-2V23Z"}),React.createElement("path",{d:"M27,7v9.17l3.59-3.58L32,14l-6,6-6-6,1.41-1.41L25,16.17V7H13V5H25A2,2,0,0,1,27,7Z"}),React.createElement("path",{d:"M8,10H4A2,2,0,0,1,2,8V4A2,2,0,0,1,4,2H8a2,2,0,0,1,2,2V8A2,2,0,0,1,8,10ZM4,4V8H8V4Z"}),props.children);});var ExamMode20=/*#__PURE__*/React.forwardRef(function ExamMode20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,23v3H7V16.83l3.59,3.58L12,19,6,13,0,19l1.41,1.41L5,16.83V26a2,2,0,0,0,2,2H25a2,2,0,0,0,2-2V23Z"}),React.createElement("path",{d:"M27,7v9.17l3.59-3.58L32,14l-6,6-6-6,1.41-1.41L25,16.17V7H13V5H25A2,2,0,0,1,27,7Z"}),React.createElement("path",{d:"M8,10H4A2,2,0,0,1,2,8V4A2,2,0,0,1,4,2H8a2,2,0,0,1,2,2V8A2,2,0,0,1,8,10ZM4,4V8H8V4Z"}),props.children);});var ExamMode16=/*#__PURE__*/React.forwardRef(function ExamMode16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,23v3H7V16.83l3.59,3.58L12,19,6,13,0,19l1.41,1.41L5,16.83V26a2,2,0,0,0,2,2H25a2,2,0,0,0,2-2V23Z"}),React.createElement("path",{d:"M27,7v9.17l3.59-3.58L32,14l-6,6-6-6,1.41-1.41L25,16.17V7H13V5H25A2,2,0,0,1,27,7Z"}),React.createElement("path",{d:"M8,10H4A2,2,0,0,1,2,8V4A2,2,0,0,1,4,2H8a2,2,0,0,1,2,2V8A2,2,0,0,1,8,10ZM4,4V8H8V4Z"}),props.children);});var Exit32=/*#__PURE__*/React.forwardRef(function Exit32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"24",x:"26",y:"4"}),React.createElement("polygon",{points:"11.414 20.586 7.828 17 22 17 22 15 7.828 15 11.414 11.414 10 10 4 16 10 22 11.414 20.586"}),props.children);});var Exit24=/*#__PURE__*/React.forwardRef(function Exit24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"24",x:"26",y:"4"}),React.createElement("polygon",{points:"11.414 20.586 7.828 17 22 17 22 15 7.828 15 11.414 11.414 10 10 4 16 10 22 11.414 20.586"}),props.children);});var Exit20=/*#__PURE__*/React.forwardRef(function Exit20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"24",x:"26",y:"4"}),React.createElement("polygon",{points:"11.414 20.586 7.828 17 22 17 22 15 7.828 15 11.414 11.414 10 10 4 16 10 22 11.414 20.586"}),props.children);});var Exit16=/*#__PURE__*/React.forwardRef(function Exit16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"2",height:"24",x:"26",y:"4"}),React.createElement("polygon",{points:"11.414 20.586 7.828 17 22 17 22 15 7.828 15 11.414 11.414 10 10 4 16 10 22 11.414 20.586"}),props.children);});var ExpandAll32=/*#__PURE__*/React.forwardRef(function ExpandAll32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,10H26a2.0025,2.0025,0,0,0,2-2V4a2.0025,2.0025,0,0,0-2-2H12a2.0025,2.0025,0,0,0-2,2V5H6V2H4V25a2.0025,2.0025,0,0,0,2,2h4v1a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V24a2.0025,2.0025,0,0,0-2-2H12a2.0025,2.0025,0,0,0-2,2v1H6V17h4v1a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V14a2.0025,2.0025,0,0,0-2-2H12a2.0025,2.0025,0,0,0-2,2v1H6V7h4V8A2.0025,2.0025,0,0,0,12,10Zm0-6H26l.0012,4H12Zm0,20H26l.0012,4H12Zm0-10H26l.0012,4H12Z"}),props.children);});var ExpandAll24=/*#__PURE__*/React.forwardRef(function ExpandAll24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,10H26a2.0025,2.0025,0,0,0,2-2V4a2.0025,2.0025,0,0,0-2-2H12a2.0025,2.0025,0,0,0-2,2V5H6V2H4V25a2.0025,2.0025,0,0,0,2,2h4v1a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V24a2.0025,2.0025,0,0,0-2-2H12a2.0025,2.0025,0,0,0-2,2v1H6V17h4v1a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V14a2.0025,2.0025,0,0,0-2-2H12a2.0025,2.0025,0,0,0-2,2v1H6V7h4V8A2.0025,2.0025,0,0,0,12,10Zm0-6H26l.0012,4H12Zm0,20H26l.0012,4H12Zm0-10H26l.0012,4H12Z"}),props.children);});var ExpandAll20=/*#__PURE__*/React.forwardRef(function ExpandAll20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,10H26a2.0025,2.0025,0,0,0,2-2V4a2.0025,2.0025,0,0,0-2-2H12a2.0025,2.0025,0,0,0-2,2V5H6V2H4V25a2.0025,2.0025,0,0,0,2,2h4v1a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V24a2.0025,2.0025,0,0,0-2-2H12a2.0025,2.0025,0,0,0-2,2v1H6V17h4v1a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V14a2.0025,2.0025,0,0,0-2-2H12a2.0025,2.0025,0,0,0-2,2v1H6V7h4V8A2.0025,2.0025,0,0,0,12,10Zm0-6H26l.0012,4H12Zm0,20H26l.0012,4H12Zm0-10H26l.0012,4H12Z"}),props.children);});var ExpandAll16=/*#__PURE__*/React.forwardRef(function ExpandAll16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,10H26a2.0025,2.0025,0,0,0,2-2V4a2.0025,2.0025,0,0,0-2-2H12a2.0025,2.0025,0,0,0-2,2V5H6V2H4V25a2.0025,2.0025,0,0,0,2,2h4v1a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V24a2.0025,2.0025,0,0,0-2-2H12a2.0025,2.0025,0,0,0-2,2v1H6V17h4v1a2.0025,2.0025,0,0,0,2,2H26a2.0025,2.0025,0,0,0,2-2V14a2.0025,2.0025,0,0,0-2-2H12a2.0025,2.0025,0,0,0-2,2v1H6V7h4V8A2.0025,2.0025,0,0,0,12,10Zm0-6H26l.0012,4H12Zm0,20H26l.0012,4H12Zm0-10H26l.0012,4H12Z"}),props.children);});var ExpandCategories32=/*#__PURE__*/React.forwardRef(function ExpandCategories32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"20",y:"26"}),React.createElement("rect",{width:"8",height:"2",x:"20",y:"18"}),React.createElement("rect",{width:"10",height:"2",x:"20",y:"10"}),React.createElement("rect",{width:"2",height:"24",x:"15",y:"4"}),React.createElement("polygon",{points:"10.586 3.959 7 7.249 3.412 3.958 2 5.373 7 10 12 5.373 10.586 3.959"}),props.children);});var ExpandCategories24=/*#__PURE__*/React.forwardRef(function ExpandCategories24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"20",y:"26"}),React.createElement("rect",{width:"8",height:"2",x:"20",y:"18"}),React.createElement("rect",{width:"10",height:"2",x:"20",y:"10"}),React.createElement("rect",{width:"2",height:"24",x:"15",y:"4"}),React.createElement("polygon",{points:"10.586 3.959 7 7.249 3.412 3.958 2 5.373 7 10 12 5.373 10.586 3.959"}),props.children);});var ExpandCategories20=/*#__PURE__*/React.forwardRef(function ExpandCategories20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"20",y:"26"}),React.createElement("rect",{width:"8",height:"2",x:"20",y:"18"}),React.createElement("rect",{width:"10",height:"2",x:"20",y:"10"}),React.createElement("rect",{width:"2",height:"24",x:"15",y:"4"}),React.createElement("polygon",{points:"10.586 3.959 7 7.249 3.412 3.958 2 5.373 7 10 12 5.373 10.586 3.959"}),props.children);});var ExpandCategories16=/*#__PURE__*/React.forwardRef(function ExpandCategories16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"6",height:"2",x:"20",y:"26"}),React.createElement("rect",{width:"8",height:"2",x:"20",y:"18"}),React.createElement("rect",{width:"10",height:"2",x:"20",y:"10"}),React.createElement("rect",{width:"2",height:"24",x:"15",y:"4"}),React.createElement("polygon",{points:"10.586 3.959 7 7.249 3.412 3.958 2 5.373 7 10 12 5.373 10.586 3.959"}),props.children);});var Export32=/*#__PURE__*/React.forwardRef(function Export32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,24v4H6V24H4v4H4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2h0V24Z"}),React.createElement("polygon",{points:"6 12 7.41 13.4 15 5.83 15 25 17 25 17 5.83 24.59 13.4 26 12 16 2 6 12"}),props.children);});var Export24=/*#__PURE__*/React.forwardRef(function Export24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,24v4H6V24H4v4H4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2h0V24Z"}),React.createElement("polygon",{points:"6 12 7.41 13.4 15 5.83 15 25 17 25 17 5.83 24.59 13.4 26 12 16 2 6 12"}),props.children);});var Export20=/*#__PURE__*/React.forwardRef(function Export20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,24v4H6V24H4v4H4a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2h0V24Z"}),React.createElement("polygon",{points:"6 12 7.41 13.4 15 5.83 15 25 17 25 17 5.83 24.59 13.4 26 12 16 2 6 12"}),props.children);});var Eyedropper32=/*#__PURE__*/React.forwardRef(function Eyedropper32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"3",height:"3",x:"2",y:"27"}),React.createElement("path",{d:"M29.71,7.29l-5-5a1,1,0,0,0-1.41,0h0L20,5.59l-1.29-1.3L17.29,5.71,18.59,7,8.29,17.29A1,1,0,0,0,8,18v1.59l-2.71,2.7a1,1,0,0,0,0,1.41h0l3,3a1,1,0,0,0,1.41,0h0L12.41,24H14a1,1,0,0,0,.71-.29L25,13.41l1.29,1.3,1.42-1.42L26.41,12l3.3-3.29a1,1,0,0,0,0-1.41ZM13.59,22h-2L9,24.59,7.41,23,10,20.41v-2l10-10L23.59,12ZM25,10.59,21.41,7,24,4.41,27.59,8Z"}),props.children);});var Eyedropper24=/*#__PURE__*/React.forwardRef(function Eyedropper24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"3",height:"3",x:"2",y:"27"}),React.createElement("path",{d:"M29.71,7.29l-5-5a1,1,0,0,0-1.41,0h0L20,5.59l-1.29-1.3L17.29,5.71,18.59,7,8.29,17.29A1,1,0,0,0,8,18v1.59l-2.71,2.7a1,1,0,0,0,0,1.41h0l3,3a1,1,0,0,0,1.41,0h0L12.41,24H14a1,1,0,0,0,.71-.29L25,13.41l1.29,1.3,1.42-1.42L26.41,12l3.3-3.29a1,1,0,0,0,0-1.41ZM13.59,22h-2L9,24.59,7.41,23,10,20.41v-2l10-10L23.59,12ZM25,10.59,21.41,7,24,4.41,27.59,8Z"}),props.children);});var Eyedropper20=/*#__PURE__*/React.forwardRef(function Eyedropper20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"3",height:"3",x:"2",y:"27"}),React.createElement("path",{d:"M29.71,7.29l-5-5a1,1,0,0,0-1.41,0h0L20,5.59l-1.29-1.3L17.29,5.71,18.59,7,8.29,17.29A1,1,0,0,0,8,18v1.59l-2.71,2.7a1,1,0,0,0,0,1.41h0l3,3a1,1,0,0,0,1.41,0h0L12.41,24H14a1,1,0,0,0,.71-.29L25,13.41l1.29,1.3,1.42-1.42L26.41,12l3.3-3.29a1,1,0,0,0,0-1.41ZM13.59,22h-2L9,24.59,7.41,23,10,20.41v-2l10-10L23.59,12ZM25,10.59,21.41,7,24,4.41,27.59,8Z"}),props.children);});var Eyedropper16=/*#__PURE__*/React.forwardRef(function Eyedropper16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"3",height:"3",x:"2",y:"27"}),React.createElement("path",{d:"M29.71,7.29l-5-5a1,1,0,0,0-1.41,0h0L20,5.59l-1.29-1.3L17.29,5.71,18.59,7,8.29,17.29A1,1,0,0,0,8,18v1.59l-2.71,2.7a1,1,0,0,0,0,1.41h0l3,3a1,1,0,0,0,1.41,0h0L12.41,24H14a1,1,0,0,0,.71-.29L25,13.41l1.29,1.3,1.42-1.42L26.41,12l3.3-3.29a1,1,0,0,0,0-1.41ZM13.59,22h-2L9,24.59,7.41,23,10,20.41v-2l10-10L23.59,12ZM25,10.59,21.41,7,24,4.41,27.59,8Z"}),props.children);});var FaceActivatedAdd32=/*#__PURE__*/React.forwardRef(function FaceActivatedAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 4 26 4 26 0 24 0 24 4 20 4 20 6 24 6 24 10 26 10 26 6 30 6 30 4"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M9,20a8.13,8.13,0,0,0,14,0Z"}),React.createElement("path",{d:"M27.82,14A12,12,0,1,1,16,4V2A14,14,0,1,0,30,16a14.71,14.71,0,0,0-.16-2Z"}),props.children);});var FaceActivatedAdd24=/*#__PURE__*/React.forwardRef(function FaceActivatedAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 4 26 4 26 0 24 0 24 4 20 4 20 6 24 6 24 10 26 10 26 6 30 6 30 4"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M9,20a8.13,8.13,0,0,0,14,0Z"}),React.createElement("path",{d:"M27.82,14A12,12,0,1,1,16,4V2A14,14,0,1,0,30,16a14.71,14.71,0,0,0-.16-2Z"}),props.children);});var FaceActivatedAdd20=/*#__PURE__*/React.forwardRef(function FaceActivatedAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 4 26 4 26 0 24 0 24 4 20 4 20 6 24 6 24 10 26 10 26 6 30 6 30 4"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M9,20a8.13,8.13,0,0,0,14,0Z"}),React.createElement("path",{d:"M27.82,14A12,12,0,1,1,16,4V2A14,14,0,1,0,30,16a14.71,14.71,0,0,0-.16-2Z"}),props.children);});var FaceActivatedAdd16=/*#__PURE__*/React.forwardRef(function FaceActivatedAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"30 4 26 4 26 0 24 0 24 4 20 4 20 6 24 6 24 10 26 10 26 6 30 6 30 4"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M9,20a8.13,8.13,0,0,0,14,0Z"}),React.createElement("path",{d:"M27.82,14A12,12,0,1,1,16,4V2A14,14,0,1,0,30,16a14.71,14.71,0,0,0-.16-2Z"}),props.children);});var FaceActivatedFilled32=/*#__PURE__*/React.forwardRef(function FaceActivatedFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm-4.5,9A2.5,2.5,0,1,1,9,13.5,2.48,2.48,0,0,1,11.5,11ZM16,24a8.11,8.11,0,0,1-7-4H23A8.11,8.11,0,0,1,16,24Zm4.5-8A2.5,2.5,0,1,1,23,13.5,2.48,2.48,0,0,1,20.5,16Z"}),props.children);});var FaceActivatedFilled24=/*#__PURE__*/React.forwardRef(function FaceActivatedFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm-4.5,9A2.5,2.5,0,1,1,9,13.5,2.48,2.48,0,0,1,11.5,11ZM16,24a8.11,8.11,0,0,1-7-4H23A8.11,8.11,0,0,1,16,24Zm4.5-8A2.5,2.5,0,1,1,23,13.5,2.48,2.48,0,0,1,20.5,16Z"}),props.children);});var FaceActivatedFilled20=/*#__PURE__*/React.forwardRef(function FaceActivatedFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm-4.5,9A2.5,2.5,0,1,1,9,13.5,2.48,2.48,0,0,1,11.5,11ZM16,24a8.11,8.11,0,0,1-7-4H23A8.11,8.11,0,0,1,16,24Zm4.5-8A2.5,2.5,0,1,1,23,13.5,2.48,2.48,0,0,1,20.5,16Z"}),props.children);});var FaceActivatedFilled16=/*#__PURE__*/React.forwardRef(function FaceActivatedFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm-4.5,9A2.5,2.5,0,1,1,9,13.5,2.48,2.48,0,0,1,11.5,11ZM16,24a8.11,8.11,0,0,1-7-4H23A8.11,8.11,0,0,1,16,24Zm4.5-8A2.5,2.5,0,1,1,23,13.5,2.48,2.48,0,0,1,20.5,16Z"}),props.children);});var FaceActivated32=/*#__PURE__*/React.forwardRef(function FaceActivated32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M9,20a8.13,8.13,0,0,0,14,0Z"}),props.children);});var FaceActivated24=/*#__PURE__*/React.forwardRef(function FaceActivated24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M9,20a8.13,8.13,0,0,0,14,0Z"}),props.children);});var FaceActivated20=/*#__PURE__*/React.forwardRef(function FaceActivated20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M9,20a8.13,8.13,0,0,0,14,0Z"}),props.children);});var FaceActivated16=/*#__PURE__*/React.forwardRef(function FaceActivated16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M9,20a8.13,8.13,0,0,0,14,0Z"}),props.children);});var FaceAdd32=/*#__PURE__*/React.forwardRef(function FaceAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,22a6,6,0,0,1-5.14-2.92l-1.71,1a8,8,0,0,0,13.7,0l-1.71-1A6,6,0,0,1,16,22Z"}),React.createElement("polygon",{points:"30 4 26 4 26 0 24 0 24 4 20 4 20 6 24 6 24 10 26 10 26 6 30 6 30 4"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M27.61,13A12.33,12.33,0,0,1,28,16,12,12,0,1,1,16,4V2A14,14,0,1,0,29.67,13Z"}),props.children);});var FaceAdd24=/*#__PURE__*/React.forwardRef(function FaceAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,22a6,6,0,0,1-5.14-2.92l-1.71,1a8,8,0,0,0,13.7,0l-1.71-1A6,6,0,0,1,16,22Z"}),React.createElement("polygon",{points:"30 4 26 4 26 0 24 0 24 4 20 4 20 6 24 6 24 10 26 10 26 6 30 6 30 4"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M27.61,13A12.33,12.33,0,0,1,28,16,12,12,0,1,1,16,4V2A14,14,0,1,0,29.67,13Z"}),props.children);});var FaceAdd20=/*#__PURE__*/React.forwardRef(function FaceAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,22a6,6,0,0,1-5.14-2.92l-1.71,1a8,8,0,0,0,13.7,0l-1.71-1A6,6,0,0,1,16,22Z"}),React.createElement("polygon",{points:"30 4 26 4 26 0 24 0 24 4 20 4 20 6 24 6 24 10 26 10 26 6 30 6 30 4"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M27.61,13A12.33,12.33,0,0,1,28,16,12,12,0,1,1,16,4V2A14,14,0,1,0,29.67,13Z"}),props.children);});var FaceAdd16=/*#__PURE__*/React.forwardRef(function FaceAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,22a6,6,0,0,1-5.14-2.92l-1.71,1a8,8,0,0,0,13.7,0l-1.71-1A6,6,0,0,1,16,22Z"}),React.createElement("polygon",{points:"30 4 26 4 26 0 24 0 24 4 20 4 20 6 24 6 24 10 26 10 26 6 30 6 30 4"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M27.61,13A12.33,12.33,0,0,1,28,16,12,12,0,1,1,16,4V2A14,14,0,1,0,29.67,13Z"}),props.children);});var FaceCool32=/*#__PURE__*/React.forwardRef(function FaceCool32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,24a8,8,0,0,0,6.85-3.89l-1.71-1a6,6,0,0,1-10.28,0l-1.71,1A8,8,0,0,0,16,24Z"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,10.89,7H25a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1H5.11A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4,16a11.86,11.86,0,0,1,.4-3H7v2a2,2,0,0,0,2,2h3.31a2,2,0,0,0,2-1.67L14.83,12h2.34l.55,3.33a2,2,0,0,0,2,1.67H23a2,2,0,0,0,2-2V13h2.6a11.86,11.86,0,0,1,.4,3A12,12,0,0,1,16,28Z"}),props.children);});var FaceCool24=/*#__PURE__*/React.forwardRef(function FaceCool24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,24a8,8,0,0,0,6.85-3.89l-1.71-1a6,6,0,0,1-10.28,0l-1.71,1A8,8,0,0,0,16,24Z"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,10.89,7H25a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1H5.11A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4,16a11.86,11.86,0,0,1,.4-3H7v2a2,2,0,0,0,2,2h3.31a2,2,0,0,0,2-1.67L14.83,12h2.34l.55,3.33a2,2,0,0,0,2,1.67H23a2,2,0,0,0,2-2V13h2.6a11.86,11.86,0,0,1,.4,3A12,12,0,0,1,16,28Z"}),props.children);});var FaceCool20=/*#__PURE__*/React.forwardRef(function FaceCool20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,24a8,8,0,0,0,6.85-3.89l-1.71-1a6,6,0,0,1-10.28,0l-1.71,1A8,8,0,0,0,16,24Z"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,10.89,7H25a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1H5.11A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4,16a11.86,11.86,0,0,1,.4-3H7v2a2,2,0,0,0,2,2h3.31a2,2,0,0,0,2-1.67L14.83,12h2.34l.55,3.33a2,2,0,0,0,2,1.67H23a2,2,0,0,0,2-2V13h2.6a11.86,11.86,0,0,1,.4,3A12,12,0,0,1,16,28Z"}),props.children);});var FaceCool16=/*#__PURE__*/React.forwardRef(function FaceCool16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,24a8,8,0,0,0,6.85-3.89l-1.71-1a6,6,0,0,1-10.28,0l-1.71,1A8,8,0,0,0,16,24Z"}),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,2a12,12,0,0,1,10.89,7H25a1,1,0,0,0-1-1H8a1,1,0,0,0-1,1H5.11A12,12,0,0,1,16,4Zm0,24A12,12,0,0,1,4,16a11.86,11.86,0,0,1,.4-3H7v2a2,2,0,0,0,2,2h3.31a2,2,0,0,0,2-1.67L14.83,12h2.34l.55,3.33a2,2,0,0,0,2,1.67H23a2,2,0,0,0,2-2V13h2.6a11.86,11.86,0,0,1,.4,3A12,12,0,0,1,16,28Z"}),props.children);});var FaceDissatisfiedFilled32=/*#__PURE__*/React.forwardRef(function FaceDissatisfiedFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm-4.5,9h0A2.5,2.5,0,1,1,9,13.5,2.48,2.48,0,0,1,11.54,11Zm9.64,12.92a6,6,0,0,0-10.28,0l-1.71-1a8,8,0,0,1,13.7,0ZM20.5,16a2.5,2.5,0,0,1,0-5h0a2.5,2.5,0,0,1,0,5Z"}),props.children);});var FaceDissatisfiedFilled24=/*#__PURE__*/React.forwardRef(function FaceDissatisfiedFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm-4.5,9h0A2.5,2.5,0,1,1,9,13.5,2.48,2.48,0,0,1,11.54,11Zm9.64,12.92a6,6,0,0,0-10.28,0l-1.71-1a8,8,0,0,1,13.7,0ZM20.5,16a2.5,2.5,0,0,1,0-5h0a2.5,2.5,0,0,1,0,5Z"}),props.children);});var FaceDissatisfiedFilled20=/*#__PURE__*/React.forwardRef(function FaceDissatisfiedFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm-4.5,9h0A2.5,2.5,0,1,1,9,13.5,2.48,2.48,0,0,1,11.54,11Zm9.64,12.92a6,6,0,0,0-10.28,0l-1.71-1a8,8,0,0,1,13.7,0ZM20.5,16a2.5,2.5,0,0,1,0-5h0a2.5,2.5,0,0,1,0,5Z"}),props.children);});var FaceDissatisfiedFilled16=/*#__PURE__*/React.forwardRef(function FaceDissatisfiedFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm-4.5,9h0A2.5,2.5,0,1,1,9,13.5,2.48,2.48,0,0,1,11.54,11Zm9.64,12.92a6,6,0,0,0-10.28,0l-1.71-1a8,8,0,0,1,13.7,0ZM20.5,16a2.5,2.5,0,0,1,0-5h0a2.5,2.5,0,0,1,0,5Z"}),props.children);});var FaceDissatisfied32=/*#__PURE__*/React.forwardRef(function FaceDissatisfied32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.5,2.5,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.5,2.5,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M16,19a8,8,0,0,0-6.85,3.89l1.71,1a6,6,0,0,1,10.28,0l1.71-1A8,8,0,0,0,16,19Z"}),props.children);});var FaceDissatisfied24=/*#__PURE__*/React.forwardRef(function FaceDissatisfied24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.5,2.5,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.5,2.5,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M16,19a8,8,0,0,0-6.85,3.89l1.71,1a6,6,0,0,1,10.28,0l1.71-1A8,8,0,0,0,16,19Z"}),props.children);});var FaceDissatisfied20=/*#__PURE__*/React.forwardRef(function FaceDissatisfied20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.5,2.5,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.5,2.5,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M16,19a8,8,0,0,0-6.85,3.89l1.71,1a6,6,0,0,1,10.28,0l1.71-1A8,8,0,0,0,16,19Z"}),props.children);});var FaceDissatisfied16=/*#__PURE__*/React.forwardRef(function FaceDissatisfied16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.5,2.5,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.5,2.5,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M16,19a8,8,0,0,0-6.85,3.89l1.71,1a6,6,0,0,1,10.28,0l1.71-1A8,8,0,0,0,16,19Z"}),props.children);});var FaceDizzyFilled32=/*#__PURE__*/React.forwardRef(function FaceDizzyFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM9,16.41,7.59,15l2-2-2-2L9,9.59l2,2,2-2L14.41,11l-2,2,2,2L13,16.41l-2-2ZM16,25a3,3,0,1,1,3-3A3,3,0,0,1,16,25Zm8.41-10L23,16.41l-2-2-2,2L17.59,15l2-2-2-2L19,9.59l2,2,2-2L24.41,11l-2,2Z"}),props.children);});var FaceDizzyFilled24=/*#__PURE__*/React.forwardRef(function FaceDizzyFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM9,16.41,7.59,15l2-2-2-2L9,9.59l2,2,2-2L14.41,11l-2,2,2,2L13,16.41l-2-2ZM16,25a3,3,0,1,1,3-3A3,3,0,0,1,16,25Zm8.41-10L23,16.41l-2-2-2,2L17.59,15l2-2-2-2L19,9.59l2,2,2-2L24.41,11l-2,2Z"}),props.children);});var FaceDizzyFilled20=/*#__PURE__*/React.forwardRef(function FaceDizzyFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM9,16.41,7.59,15l2-2-2-2L9,9.59l2,2,2-2L14.41,11l-2,2,2,2L13,16.41l-2-2ZM16,25a3,3,0,1,1,3-3A3,3,0,0,1,16,25Zm8.41-10L23,16.41l-2-2-2,2L17.59,15l2-2-2-2L19,9.59l2,2,2-2L24.41,11l-2,2Z"}),props.children);});var FaceDizzyFilled16=/*#__PURE__*/React.forwardRef(function FaceDizzyFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM9,16.41,7.59,15l2-2-2-2L9,9.59l2,2,2-2L14.41,11l-2,2,2,2L13,16.41l-2-2ZM16,25a3,3,0,1,1,3-3A3,3,0,0,1,16,25Zm8.41-10L23,16.41l-2-2-2,2L17.59,15l2-2-2-2L19,9.59l2,2,2-2L24.41,11l-2,2Z"}),props.children);});var FaceDizzy32=/*#__PURE__*/React.forwardRef(function FaceDizzy32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("polygon",{points:"24.41 11 23 9.59 21 11.59 19 9.59 17.59 11 19.59 13 17.59 15 19 16.41 21 14.41 23 16.41 24.41 15 22.41 13 24.41 11"}),React.createElement("polygon",{points:"14.41 11 13 9.59 11 11.59 9 9.59 7.59 11 9.59 13 7.59 15 9 16.41 11 14.41 13 16.41 14.41 15 12.41 13 14.41 11"}),React.createElement("path",{d:"M16,19a3,3,0,1,0,3,3,3,3,0,0,0-3-3Z"}),props.children);});var FaceDizzy24=/*#__PURE__*/React.forwardRef(function FaceDizzy24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("polygon",{points:"24.41 11 23 9.59 21 11.59 19 9.59 17.59 11 19.59 13 17.59 15 19 16.41 21 14.41 23 16.41 24.41 15 22.41 13 24.41 11"}),React.createElement("polygon",{points:"14.41 11 13 9.59 11 11.59 9 9.59 7.59 11 9.59 13 7.59 15 9 16.41 11 14.41 13 16.41 14.41 15 12.41 13 14.41 11"}),React.createElement("path",{d:"M16,19a3,3,0,1,0,3,3,3,3,0,0,0-3-3Z"}),props.children);});var FaceDizzy20=/*#__PURE__*/React.forwardRef(function FaceDizzy20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("polygon",{points:"24.41 11 23 9.59 21 11.59 19 9.59 17.59 11 19.59 13 17.59 15 19 16.41 21 14.41 23 16.41 24.41 15 22.41 13 24.41 11"}),React.createElement("polygon",{points:"14.41 11 13 9.59 11 11.59 9 9.59 7.59 11 9.59 13 7.59 15 9 16.41 11 14.41 13 16.41 14.41 15 12.41 13 14.41 11"}),React.createElement("path",{d:"M16,19a3,3,0,1,0,3,3,3,3,0,0,0-3-3Z"}),props.children);});var FaceDizzy16=/*#__PURE__*/React.forwardRef(function FaceDizzy16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("polygon",{points:"24.41 11 23 9.59 21 11.59 19 9.59 17.59 11 19.59 13 17.59 15 19 16.41 21 14.41 23 16.41 24.41 15 22.41 13 24.41 11"}),React.createElement("polygon",{points:"14.41 11 13 9.59 11 11.59 9 9.59 7.59 11 9.59 13 7.59 15 9 16.41 11 14.41 13 16.41 14.41 15 12.41 13 14.41 11"}),React.createElement("path",{d:"M16,19a3,3,0,1,0,3,3,3,3,0,0,0-3-3Z"}),props.children);});var FaceNeutralFilled32=/*#__PURE__*/React.forwardRef(function FaceNeutralFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM9,13.5A2.5,2.5,0,1,1,11.5,16,2.5,2.5,0,0,1,9,13.5ZM22,22H10V20H22Zm-1.5-6A2.5,2.5,0,1,1,23,13.5,2.5,2.5,0,0,1,20.5,16Z"}),props.children);});var FaceNeutralFilled24=/*#__PURE__*/React.forwardRef(function FaceNeutralFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM9,13.5A2.5,2.5,0,1,1,11.5,16,2.5,2.5,0,0,1,9,13.5ZM22,22H10V20H22Zm-1.5-6A2.5,2.5,0,1,1,23,13.5,2.5,2.5,0,0,1,20.5,16Z"}),props.children);});var FaceNeutralFilled20=/*#__PURE__*/React.forwardRef(function FaceNeutralFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM9,13.5A2.5,2.5,0,1,1,11.5,16,2.5,2.5,0,0,1,9,13.5ZM22,22H10V20H22Zm-1.5-6A2.5,2.5,0,1,1,23,13.5,2.5,2.5,0,0,1,20.5,16Z"}),props.children);});var FaceNeutralFilled16=/*#__PURE__*/React.forwardRef(function FaceNeutralFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM9,13.5A2.5,2.5,0,1,1,11.5,16,2.5,2.5,0,0,1,9,13.5ZM22,22H10V20H22Zm-1.5-6A2.5,2.5,0,1,1,23,13.5,2.5,2.5,0,0,1,20.5,16Z"}),props.children);});var FaceNeutral32=/*#__PURE__*/React.forwardRef(function FaceNeutral32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.5,2.5,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.5,2.5,0,0,0,20.5,11Z"}),React.createElement("rect",{width:"12",height:"2",x:"10",y:"20"}),props.children);});var FaceNeutral24=/*#__PURE__*/React.forwardRef(function FaceNeutral24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.5,2.5,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.5,2.5,0,0,0,20.5,11Z"}),React.createElement("rect",{width:"12",height:"2",x:"10",y:"20"}),props.children);});var FaceNeutral20=/*#__PURE__*/React.forwardRef(function FaceNeutral20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.5,2.5,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.5,2.5,0,0,0,20.5,11Z"}),React.createElement("rect",{width:"12",height:"2",x:"10",y:"20"}),props.children);});var FaceNeutral16=/*#__PURE__*/React.forwardRef(function FaceNeutral16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.5,2.5,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.5,2.5,0,0,0,20.5,11Z"}),React.createElement("rect",{width:"12",height:"2",x:"10",y:"20"}),props.children);});var FacePendingFilled32=/*#__PURE__*/React.forwardRef(function FacePendingFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM11.5,16A2.5,2.5,0,1,1,14,13.5,2.48,2.48,0,0,1,11.5,16Zm9,0A2.5,2.5,0,1,1,23,13.5,2.48,2.48,0,0,1,20.5,16Z"}),props.children);});var FacePendingFilled24=/*#__PURE__*/React.forwardRef(function FacePendingFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM11.5,16A2.5,2.5,0,1,1,14,13.5,2.48,2.48,0,0,1,11.5,16Zm9,0A2.5,2.5,0,1,1,23,13.5,2.48,2.48,0,0,1,20.5,16Z"}),props.children);});var FacePendingFilled20=/*#__PURE__*/React.forwardRef(function FacePendingFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM11.5,16A2.5,2.5,0,1,1,14,13.5,2.48,2.48,0,0,1,11.5,16Zm9,0A2.5,2.5,0,1,1,23,13.5,2.48,2.48,0,0,1,20.5,16Z"}),props.children);});var FacePendingFilled16=/*#__PURE__*/React.forwardRef(function FacePendingFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM11.5,16A2.5,2.5,0,1,1,14,13.5,2.48,2.48,0,0,1,11.5,16Zm9,0A2.5,2.5,0,1,1,23,13.5,2.48,2.48,0,0,1,20.5,16Z"}),props.children);});var FacePending32=/*#__PURE__*/React.forwardRef(function FacePending32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),props.children);});var FacePending24=/*#__PURE__*/React.forwardRef(function FacePending24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),props.children);});var FacePending20=/*#__PURE__*/React.forwardRef(function FacePending20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),props.children);});var FacePending16=/*#__PURE__*/React.forwardRef(function FacePending16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),props.children);});var FaceSatisfiedFilled32=/*#__PURE__*/React.forwardRef(function FaceSatisfiedFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm-4.5,9A2.5,2.5,0,1,1,9,13.5,2.48,2.48,0,0,1,11.5,11ZM16,24a8,8,0,0,1-6.85-3.89l1.71-1a6,6,0,0,0,10.28,0l1.71,1A8,8,0,0,1,16,24Zm4.5-8A2.5,2.5,0,1,1,23,13.5,2.48,2.48,0,0,1,20.5,16Z"}),props.children);});var FaceSatisfiedFilled24=/*#__PURE__*/React.forwardRef(function FaceSatisfiedFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm-4.5,9A2.5,2.5,0,1,1,9,13.5,2.48,2.48,0,0,1,11.5,11ZM16,24a8,8,0,0,1-6.85-3.89l1.71-1a6,6,0,0,0,10.28,0l1.71,1A8,8,0,0,1,16,24Zm4.5-8A2.5,2.5,0,1,1,23,13.5,2.48,2.48,0,0,1,20.5,16Z"}),props.children);});var FaceSatisfiedFilled20=/*#__PURE__*/React.forwardRef(function FaceSatisfiedFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm-4.5,9A2.5,2.5,0,1,1,9,13.5,2.48,2.48,0,0,1,11.5,11ZM16,24a8,8,0,0,1-6.85-3.89l1.71-1a6,6,0,0,0,10.28,0l1.71,1A8,8,0,0,1,16,24Zm4.5-8A2.5,2.5,0,1,1,23,13.5,2.48,2.48,0,0,1,20.5,16Z"}),props.children);});var FaceSatisfiedFilled16=/*#__PURE__*/React.forwardRef(function FaceSatisfiedFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm-4.5,9A2.5,2.5,0,1,1,9,13.5,2.48,2.48,0,0,1,11.5,11ZM16,24a8,8,0,0,1-6.85-3.89l1.71-1a6,6,0,0,0,10.28,0l1.71,1A8,8,0,0,1,16,24Zm4.5-8A2.5,2.5,0,1,1,23,13.5,2.48,2.48,0,0,1,20.5,16Z"}),props.children);});var FaceSatisfied32=/*#__PURE__*/React.forwardRef(function FaceSatisfied32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M16,24a8,8,0,0,0,6.85-3.89l-1.71-1a6,6,0,0,1-10.28,0l-1.71,1A8,8,0,0,0,16,24Z"}),props.children);});var FaceSatisfied24=/*#__PURE__*/React.forwardRef(function FaceSatisfied24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M16,24a8,8,0,0,0,6.85-3.89l-1.71-1a6,6,0,0,1-10.28,0l-1.71,1A8,8,0,0,0,16,24Z"}),props.children);});var FaceSatisfied20=/*#__PURE__*/React.forwardRef(function FaceSatisfied20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M16,24a8,8,0,0,0,6.85-3.89l-1.71-1a6,6,0,0,1-10.28,0l-1.71,1A8,8,0,0,0,16,24Z"}),props.children);});var FaceSatisfied16=/*#__PURE__*/React.forwardRef(function FaceSatisfied16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M11.5,11A2.5,2.5,0,1,0,14,13.5,2.48,2.48,0,0,0,11.5,11Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.48,2.48,0,0,0,20.5,11Z"}),React.createElement("path",{d:"M16,24a8,8,0,0,0,6.85-3.89l-1.71-1a6,6,0,0,1-10.28,0l-1.71,1A8,8,0,0,0,16,24Z"}),props.children);});var FaceWinkFilled32=/*#__PURE__*/React.forwardRef(function FaceWinkFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM8,13h6v2H8Zm8,11a8,8,0,0,1-6.85-3.89l1.71-1a6,6,0,0,0,10.28,0l1.71,1A8,8,0,0,1,16,24Zm4.5-8a2.5,2.5,0,0,1,0-5h0a2.5,2.5,0,0,1,0,5Z"}),props.children);});var FaceWinkFilled24=/*#__PURE__*/React.forwardRef(function FaceWinkFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM8,13h6v2H8Zm8,11a8,8,0,0,1-6.85-3.89l1.71-1a6,6,0,0,0,10.28,0l1.71,1A8,8,0,0,1,16,24Zm4.5-8a2.5,2.5,0,0,1,0-5h0a2.5,2.5,0,0,1,0,5Z"}),props.children);});var FaceWinkFilled20=/*#__PURE__*/React.forwardRef(function FaceWinkFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM8,13h6v2H8Zm8,11a8,8,0,0,1-6.85-3.89l1.71-1a6,6,0,0,0,10.28,0l1.71,1A8,8,0,0,1,16,24Zm4.5-8a2.5,2.5,0,0,1,0-5h0a2.5,2.5,0,0,1,0,5Z"}),props.children);});var FaceWinkFilled16=/*#__PURE__*/React.forwardRef(function FaceWinkFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2ZM8,13h6v2H8Zm8,11a8,8,0,0,1-6.85-3.89l1.71-1a6,6,0,0,0,10.28,0l1.71,1A8,8,0,0,1,16,24Zm4.5-8a2.5,2.5,0,0,1,0-5h0a2.5,2.5,0,0,1,0,5Z"}),props.children);});var FaceWink32=/*#__PURE__*/React.forwardRef(function FaceWink32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.5,2.5,0,0,0,20.5,11Z"}),React.createElement("rect",{width:"6",height:"2",x:"8",y:"13"}),React.createElement("path",{d:"M16,24a8,8,0,0,0,6.85-3.89l-1.71-1a6,6,0,0,1-10.28,0l-1.71,1A8,8,0,0,0,16,24Z"}),props.children);});var FaceWink24=/*#__PURE__*/React.forwardRef(function FaceWink24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.5,2.5,0,0,0,20.5,11Z"}),React.createElement("rect",{width:"6",height:"2",x:"8",y:"13"}),React.createElement("path",{d:"M16,24a8,8,0,0,0,6.85-3.89l-1.71-1a6,6,0,0,1-10.28,0l-1.71,1A8,8,0,0,0,16,24Z"}),props.children);});var FaceWink20=/*#__PURE__*/React.forwardRef(function FaceWink20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.5,2.5,0,0,0,20.5,11Z"}),React.createElement("rect",{width:"6",height:"2",x:"8",y:"13"}),React.createElement("path",{d:"M16,24a8,8,0,0,0,6.85-3.89l-1.71-1a6,6,0,0,1-10.28,0l-1.71,1A8,8,0,0,0,16,24Z"}),props.children);});var FaceWink16=/*#__PURE__*/React.forwardRef(function FaceWink16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("path",{d:"M20.5,11A2.5,2.5,0,1,0,23,13.5,2.5,2.5,0,0,0,20.5,11Z"}),React.createElement("rect",{width:"6",height:"2",x:"8",y:"13"}),React.createElement("path",{d:"M16,24a8,8,0,0,0,6.85-3.89l-1.71-1a6,6,0,0,1-10.28,0l-1.71,1A8,8,0,0,0,16,24Z"}),props.children);});var Factor32=/*#__PURE__*/React.forwardRef(function Factor32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,28V9H24V4h2V2H20V4h2V9H19V28H15V16H12V11h2V9H8v2h2v5H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V18h4Zm8-17h4V28H21Z"}),props.children);});var Factor24=/*#__PURE__*/React.forwardRef(function Factor24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,28V9H24V4h2V2H20V4h2V9H19V28H15V16H12V11h2V9H8v2h2v5H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V18h4Zm8-17h4V28H21Z"}),props.children);});var Factor20=/*#__PURE__*/React.forwardRef(function Factor20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,28V9H24V4h2V2H20V4h2V9H19V28H15V16H12V11h2V9H8v2h2v5H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V18h4Zm8-17h4V28H21Z"}),props.children);});var Factor16=/*#__PURE__*/React.forwardRef(function Factor16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,28V9H24V4h2V2H20V4h2V9H19V28H15V16H12V11h2V9H8v2h2v5H7V28H4V2H2V28a2,2,0,0,0,2,2H30V28ZM13,28H9V18h4Zm8-17h4V28H21Z"}),props.children);});var Fade32=/*#__PURE__*/React.forwardRef(function Fade32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.24,25.14,7,26.67a13.79,13.79,0,0,0,4.18,2.44l.69-1.87A12,12,0,0,1,8.24,25.14Z"}),React.createElement("path",{d:"M4.19,18l-2,.41A14.09,14.09,0,0,0,3.86,23L5.59,22A12.44,12.44,0,0,1,4.19,18Z"}),React.createElement("path",{d:"M11.82,4.76l-.69-1.87A13.79,13.79,0,0,0,7,5.33L8.24,6.86A12,12,0,0,1,11.82,4.76Z"}),React.createElement("path",{d:"M5.59,10,3.86,9a14.37,14.37,0,0,0-1.64,4.59l2,.34A12.05,12.05,0,0,1,5.59,10Z"}),React.createElement("path",{d:"M16,2V4a12,12,0,0,1,0,24v2A14,14,0,0,0,16,2Z"}),props.children);});var Fade24=/*#__PURE__*/React.forwardRef(function Fade24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.24,25.14,7,26.67a13.79,13.79,0,0,0,4.18,2.44l.69-1.87A12,12,0,0,1,8.24,25.14Z"}),React.createElement("path",{d:"M4.19,18l-2,.41A14.09,14.09,0,0,0,3.86,23L5.59,22A12.44,12.44,0,0,1,4.19,18Z"}),React.createElement("path",{d:"M11.82,4.76l-.69-1.87A13.79,13.79,0,0,0,7,5.33L8.24,6.86A12,12,0,0,1,11.82,4.76Z"}),React.createElement("path",{d:"M5.59,10,3.86,9a14.37,14.37,0,0,0-1.64,4.59l2,.34A12.05,12.05,0,0,1,5.59,10Z"}),React.createElement("path",{d:"M16,2V4a12,12,0,0,1,0,24v2A14,14,0,0,0,16,2Z"}),props.children);});var Fade20=/*#__PURE__*/React.forwardRef(function Fade20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.24,25.14,7,26.67a13.79,13.79,0,0,0,4.18,2.44l.69-1.87A12,12,0,0,1,8.24,25.14Z"}),React.createElement("path",{d:"M4.19,18l-2,.41A14.09,14.09,0,0,0,3.86,23L5.59,22A12.44,12.44,0,0,1,4.19,18Z"}),React.createElement("path",{d:"M11.82,4.76l-.69-1.87A13.79,13.79,0,0,0,7,5.33L8.24,6.86A12,12,0,0,1,11.82,4.76Z"}),React.createElement("path",{d:"M5.59,10,3.86,9a14.37,14.37,0,0,0-1.64,4.59l2,.34A12.05,12.05,0,0,1,5.59,10Z"}),React.createElement("path",{d:"M16,2V4a12,12,0,0,1,0,24v2A14,14,0,0,0,16,2Z"}),props.children);});var FavoriteFilled32=/*#__PURE__*/React.forwardRef(function FavoriteFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.5,4c-2,0-3.9,0.8-5.3,2.2L16,7.4l-1.1-1.1C12,3.3,7.2,3.3,4.3,6.2c0,0-0.1,0.1-0.1,0.1c-3,3-3,7.8,0,10.8L16,29\tl11.8-11.9c3-3,3-7.8,0-10.8C26.4,4.8,24.5,4,22.5,4z"}),props.children);});var FavoriteFilled24=/*#__PURE__*/React.forwardRef(function FavoriteFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.5,4c-2,0-3.9,0.8-5.3,2.2L16,7.4l-1.1-1.1C12,3.3,7.2,3.3,4.3,6.2c0,0-0.1,0.1-0.1,0.1c-3,3-3,7.8,0,10.8L16,29\tl11.8-11.9c3-3,3-7.8,0-10.8C26.4,4.8,24.5,4,22.5,4z"}),props.children);});var FavoriteFilled20=/*#__PURE__*/React.forwardRef(function FavoriteFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.5,4c-2,0-3.9,0.8-5.3,2.2L16,7.4l-1.1-1.1C12,3.3,7.2,3.3,4.3,6.2c0,0-0.1,0.1-0.1,0.1c-3,3-3,7.8,0,10.8L16,29\tl11.8-11.9c3-3,3-7.8,0-10.8C26.4,4.8,24.5,4,22.5,4z"}),props.children);});var FavoriteFilled16=/*#__PURE__*/React.forwardRef(function FavoriteFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.5,4c-2,0-3.9,0.8-5.3,2.2L16,7.4l-1.1-1.1C12,3.3,7.2,3.3,4.3,6.2c0,0-0.1,0.1-0.1,0.1c-3,3-3,7.8,0,10.8L16,29\tl11.8-11.9c3-3,3-7.8,0-10.8C26.4,4.8,24.5,4,22.5,4z"}),props.children);});var Favorite32=/*#__PURE__*/React.forwardRef(function Favorite32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.45,6a5.47,5.47,0,0,1,3.91,1.64,5.7,5.7,0,0,1,0,8L16,26.13,5.64,15.64a5.7,5.7,0,0,1,0-8,5.48,5.48,0,0,1,7.82,0L16,10.24l2.53-2.58A5.44,5.44,0,0,1,22.45,6m0-2a7.47,7.47,0,0,0-5.34,2.24L16,7.36,14.89,6.24a7.49,7.49,0,0,0-10.68,0,7.72,7.72,0,0,0,0,10.82L16,29,27.79,17.06a7.72,7.72,0,0,0,0-10.82A7.49,7.49,0,0,0,22.45,4Z"}),props.children);});var Favorite24=/*#__PURE__*/React.forwardRef(function Favorite24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.45,6a5.47,5.47,0,0,1,3.91,1.64,5.7,5.7,0,0,1,0,8L16,26.13,5.64,15.64a5.7,5.7,0,0,1,0-8,5.48,5.48,0,0,1,7.82,0L16,10.24l2.53-2.58A5.44,5.44,0,0,1,22.45,6m0-2a7.47,7.47,0,0,0-5.34,2.24L16,7.36,14.89,6.24a7.49,7.49,0,0,0-10.68,0,7.72,7.72,0,0,0,0,10.82L16,29,27.79,17.06a7.72,7.72,0,0,0,0-10.82A7.49,7.49,0,0,0,22.45,4Z"}),props.children);});var Favorite20=/*#__PURE__*/React.forwardRef(function Favorite20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.45,6a5.47,5.47,0,0,1,3.91,1.64,5.7,5.7,0,0,1,0,8L16,26.13,5.64,15.64a5.7,5.7,0,0,1,0-8,5.48,5.48,0,0,1,7.82,0L16,10.24l2.53-2.58A5.44,5.44,0,0,1,22.45,6m0-2a7.47,7.47,0,0,0-5.34,2.24L16,7.36,14.89,6.24a7.49,7.49,0,0,0-10.68,0,7.72,7.72,0,0,0,0,10.82L16,29,27.79,17.06a7.72,7.72,0,0,0,0-10.82A7.49,7.49,0,0,0,22.45,4Z"}),props.children);});var Favorite16=/*#__PURE__*/React.forwardRef(function Favorite16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M22.45,6a5.47,5.47,0,0,1,3.91,1.64,5.7,5.7,0,0,1,0,8L16,26.13,5.64,15.64a5.7,5.7,0,0,1,0-8,5.48,5.48,0,0,1,7.82,0L16,10.24l2.53-2.58A5.44,5.44,0,0,1,22.45,6m0-2a7.47,7.47,0,0,0-5.34,2.24L16,7.36,14.89,6.24a7.49,7.49,0,0,0-10.68,0,7.72,7.72,0,0,0,0,10.82L16,29,27.79,17.06a7.72,7.72,0,0,0,0-10.82A7.49,7.49,0,0,0,22.45,4Z"}),props.children);});var FetchUploadCloud32=/*#__PURE__*/React.forwardRef(function FetchUploadCloud32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,13l-5,5,1.41,1.41L15,16.83V28H6v2h9a2,2,0,0,0,2-2V16.83l2.59,2.58L21,18Z"}),React.createElement("path",{d:"M23.5,22H23V20h.5a4.4975,4.4975,0,0,0,.3564-8.981l-.8154-.0639-.0986-.812a6.9938,6.9938,0,0,0-13.8838,0l-.0991.812-.8155.0639A4.4975,4.4975,0,0,0,8.5,20H9v2H8.5A6.4973,6.4973,0,0,1,7.2,9.1362a8.9943,8.9943,0,0,1,17.6006,0A6.4974,6.4974,0,0,1,23.5,22Z"}),props.children);});var FetchUploadCloud24=/*#__PURE__*/React.forwardRef(function FetchUploadCloud24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,13l-5,5,1.41,1.41L15,16.83V28H6v2h9a2,2,0,0,0,2-2V16.83l2.59,2.58L21,18Z"}),React.createElement("path",{d:"M23.5,22H23V20h.5a4.4975,4.4975,0,0,0,.3564-8.981l-.8154-.0639-.0986-.812a6.9938,6.9938,0,0,0-13.8838,0l-.0991.812-.8155.0639A4.4975,4.4975,0,0,0,8.5,20H9v2H8.5A6.4973,6.4973,0,0,1,7.2,9.1362a8.9943,8.9943,0,0,1,17.6006,0A6.4974,6.4974,0,0,1,23.5,22Z"}),props.children);});var FetchUploadCloud20=/*#__PURE__*/React.forwardRef(function FetchUploadCloud20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,13l-5,5,1.41,1.41L15,16.83V28H6v2h9a2,2,0,0,0,2-2V16.83l2.59,2.58L21,18Z"}),React.createElement("path",{d:"M23.5,22H23V20h.5a4.4975,4.4975,0,0,0,.3564-8.981l-.8154-.0639-.0986-.812a6.9938,6.9938,0,0,0-13.8838,0l-.0991.812-.8155.0639A4.4975,4.4975,0,0,0,8.5,20H9v2H8.5A6.4973,6.4973,0,0,1,7.2,9.1362a8.9943,8.9943,0,0,1,17.6006,0A6.4974,6.4974,0,0,1,23.5,22Z"}),props.children);});var FetchUploadCloud16=/*#__PURE__*/React.forwardRef(function FetchUploadCloud16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,13l-5,5,1.41,1.41L15,16.83V28H6v2h9a2,2,0,0,0,2-2V16.83l2.59,2.58L21,18Z"}),React.createElement("path",{d:"M23.5,22H23V20h.5a4.4975,4.4975,0,0,0,.3564-8.981l-.8154-.0639-.0986-.812a6.9938,6.9938,0,0,0-13.8838,0l-.0991.812-.8155.0639A4.4975,4.4975,0,0,0,8.5,20H9v2H8.5A6.4973,6.4973,0,0,1,7.2,9.1362a8.9943,8.9943,0,0,1,17.6006,0A6.4974,6.4974,0,0,1,23.5,22Z"}),props.children);});var FetchUpload32=/*#__PURE__*/React.forwardRef(function FetchUpload32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,7,6,17l1.41,1.41L15,10.83V28H2v2H15a2,2,0,0,0,2-2V10.83l7.59,7.58L26,17Z"}),React.createElement("path",{d:"M6,8V4H26V8h2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4V8Z"}),props.children);});var FetchUpload24=/*#__PURE__*/React.forwardRef(function FetchUpload24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,7,6,17l1.41,1.41L15,10.83V28H2v2H15a2,2,0,0,0,2-2V10.83l7.59,7.58L26,17Z"}),React.createElement("path",{d:"M6,8V4H26V8h2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4V8Z"}),props.children);});var FetchUpload20=/*#__PURE__*/React.forwardRef(function FetchUpload20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,7,6,17l1.41,1.41L15,10.83V28H2v2H15a2,2,0,0,0,2-2V10.83l7.59,7.58L26,17Z"}),React.createElement("path",{d:"M6,8V4H26V8h2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4V8Z"}),props.children);});var FetchUpload16=/*#__PURE__*/React.forwardRef(function FetchUpload16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,7,6,17l1.41,1.41L15,10.83V28H2v2H15a2,2,0,0,0,2-2V10.83l7.59,7.58L26,17Z"}),React.createElement("path",{d:"M6,8V4H26V8h2V4a2,2,0,0,0-2-2H6A2,2,0,0,0,4,4V8Z"}),props.children);});var FilterEdit32=/*#__PURE__*/React.forwardRef(function FilterEdit32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,6H4V9.17l7.41,7.42.59.58V26h4V24h2v2a2,2,0,0,1-2,2H12a2,2,0,0,1-2-2V18L2.59,10.59A2,2,0,0,1,2,9.17V6A2,2,0,0,1,4,4H26Z"}),React.createElement("path",{d:"M29.71,11.29l-3-3a1,1,0,0,0-1.42,0L16,17.59V22h4.41l9.3-9.29A1,1,0,0,0,29.71,11.29ZM19.59,20H18V18.41l5-5L24.59,15ZM26,13.59,24.41,12,26,10.41,27.59,12Z"}),props.children);});var FilterEdit24=/*#__PURE__*/React.forwardRef(function FilterEdit24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,6H4V9.17l7.41,7.42.59.58V26h4V24h2v2a2,2,0,0,1-2,2H12a2,2,0,0,1-2-2V18L2.59,10.59A2,2,0,0,1,2,9.17V6A2,2,0,0,1,4,4H26Z"}),React.createElement("path",{d:"M29.71,11.29l-3-3a1,1,0,0,0-1.42,0L16,17.59V22h4.41l9.3-9.29A1,1,0,0,0,29.71,11.29ZM19.59,20H18V18.41l5-5L24.59,15ZM26,13.59,24.41,12,26,10.41,27.59,12Z"}),props.children);});var FilterEdit20=/*#__PURE__*/React.forwardRef(function FilterEdit20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,6H4V9.17l7.41,7.42.59.58V26h4V24h2v2a2,2,0,0,1-2,2H12a2,2,0,0,1-2-2V18L2.59,10.59A2,2,0,0,1,2,9.17V6A2,2,0,0,1,4,4H26Z"}),React.createElement("path",{d:"M29.71,11.29l-3-3a1,1,0,0,0-1.42,0L16,17.59V22h4.41l9.3-9.29A1,1,0,0,0,29.71,11.29ZM19.59,20H18V18.41l5-5L24.59,15ZM26,13.59,24.41,12,26,10.41,27.59,12Z"}),props.children);});var FilterEdit16=/*#__PURE__*/React.forwardRef(function FilterEdit16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,6H4V9.17l7.41,7.42.59.58V26h4V24h2v2a2,2,0,0,1-2,2H12a2,2,0,0,1-2-2V18L2.59,10.59A2,2,0,0,1,2,9.17V6A2,2,0,0,1,4,4H26Z"}),React.createElement("path",{d:"M29.71,11.29l-3-3a1,1,0,0,0-1.42,0L16,17.59V22h4.41l9.3-9.29A1,1,0,0,0,29.71,11.29ZM19.59,20H18V18.41l5-5L24.59,15ZM26,13.59,24.41,12,26,10.41,27.59,12Z"}),props.children);});var Filter32=/*#__PURE__*/React.forwardRef(function Filter32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,28H14a2,2,0,0,1-2-2V18.41L4.59,11A2,2,0,0,1,4,9.59V6A2,2,0,0,1,6,4H26a2,2,0,0,1,2,2V9.59A2,2,0,0,1,27.41,11L20,18.41V26A2,2,0,0,1,18,28ZM6,6V9.59l8,8V26h4V17.59l8-8V6Z"}),props.children);});var Filter24=/*#__PURE__*/React.forwardRef(function Filter24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,28H14a2,2,0,0,1-2-2V18.41L4.59,11A2,2,0,0,1,4,9.59V6A2,2,0,0,1,6,4H26a2,2,0,0,1,2,2V9.59A2,2,0,0,1,27.41,11L20,18.41V26A2,2,0,0,1,18,28ZM6,6V9.59l8,8V26h4V17.59l8-8V6Z"}),props.children);});var Filter20=/*#__PURE__*/React.forwardRef(function Filter20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,28H14a2,2,0,0,1-2-2V18.41L4.59,11A2,2,0,0,1,4,9.59V6A2,2,0,0,1,6,4H26a2,2,0,0,1,2,2V9.59A2,2,0,0,1,27.41,11L20,18.41V26A2,2,0,0,1,18,28ZM6,6V9.59l8,8V26h4V17.59l8-8V6Z"}),props.children);});var Filter16=/*#__PURE__*/React.forwardRef(function Filter16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,28H14a2,2,0,0,1-2-2V18.41L4.59,11A2,2,0,0,1,4,9.59V6A2,2,0,0,1,6,4H26a2,2,0,0,1,2,2V9.59A2,2,0,0,1,27.41,11L20,18.41V26A2,2,0,0,1,18,28ZM6,6V9.59l8,8V26h4V17.59l8-8V6Z"}),props.children);});var Finance32=/*#__PURE__*/React.forwardRef(function Finance32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M27,11a1,1,0,0,0,1-1V7a1,1,0,0,0-.66-.94l-11-4a1,1,0,0,0-.68,0l-11,4A1,1,0,0,0,4,7v3a1,1,0,0,0,1,1H6V24H4v2H28V24H26V11ZM6,7.7,16,4.06,26,7.7V9H6ZM18,24H14V11h4ZM8,11h4V24H8ZM24,24H20V11h4Z"}),props.children);});var Finance24=/*#__PURE__*/React.forwardRef(function Finance24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M27,11a1,1,0,0,0,1-1V7a1,1,0,0,0-.66-.94l-11-4a1,1,0,0,0-.68,0l-11,4A1,1,0,0,0,4,7v3a1,1,0,0,0,1,1H6V24H4v2H28V24H26V11ZM6,7.7,16,4.06,26,7.7V9H6ZM18,24H14V11h4ZM8,11h4V24H8ZM24,24H20V11h4Z"}),props.children);});var Finance20=/*#__PURE__*/React.forwardRef(function Finance20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M27,11a1,1,0,0,0,1-1V7a1,1,0,0,0-.66-.94l-11-4a1,1,0,0,0-.68,0l-11,4A1,1,0,0,0,4,7v3a1,1,0,0,0,1,1H6V24H4v2H28V24H26V11ZM6,7.7,16,4.06,26,7.7V9H6ZM18,24H14V11h4ZM8,11h4V24H8ZM24,24H20V11h4Z"}),props.children);});var Finance16=/*#__PURE__*/React.forwardRef(function Finance16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"28",height:"2",x:"2",y:"28"}),React.createElement("path",{d:"M27,11a1,1,0,0,0,1-1V7a1,1,0,0,0-.66-.94l-11-4a1,1,0,0,0-.68,0l-11,4A1,1,0,0,0,4,7v3a1,1,0,0,0,1,1H6V24H4v2H28V24H26V11ZM6,7.7,16,4.06,26,7.7V9H6ZM18,24H14V11h4ZM8,11h4V24H8ZM24,24H20V11h4Z"}),props.children);});var FingerprintRecognition32=/*#__PURE__*/React.forwardRef(function FingerprintRecognition32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7,5.21a.77.77,0,0,1-.46-1.38A15.46,15.46,0,0,1,16,1c2.66,0,6.48.45,9.5,2.62a.77.77,0,0,1,.18,1.07.78.78,0,0,1-1.08.17A15,15,0,0,0,16,2.53,14,14,0,0,0,7.5,5.05.74.74,0,0,1,7,5.21Z"}),React.createElement("path",{d:"M28.23,12.26a.78.78,0,0,1-.63-.33C25.87,9.49,22.78,6.24,16,6.24a14,14,0,0,0-11.63,5.7.77.77,0,0,1-1.07.17A.76.76,0,0,1,3.15,11,15.54,15.54,0,0,1,16,4.71c5.61,0,9.81,2.08,12.84,6.34a.77.77,0,0,1-.19,1.07A.79.79,0,0,1,28.23,12.26Z"}),React.createElement("path",{d:"M12.28,31a.78.78,0,0,1-.72-.49.75.75,0,0,1,.44-1c4.37-1.68,7-5.12,7-9.21a2.8,2.8,0,0,0-3-3c-1.86,0-2.76,1-3,3.35a4.27,4.27,0,0,1-4.52,3.83,4.27,4.27,0,0,1-4.32-4.59A11.71,11.71,0,0,1,16,8.39a12,12,0,0,1,12,11.93,18.66,18.66,0,0,1-1.39,6.5.78.78,0,0,1-1,.41.76.76,0,0,1-.41-1,17.25,17.25,0,0,0,1.27-5.91A10.45,10.45,0,0,0,16,9.92a10.18,10.18,0,0,0-10.38,10,2.77,2.77,0,0,0,2.79,3.06,2.74,2.74,0,0,0,3-2.48c.36-3.11,1.89-4.69,4.56-4.69a4.31,4.31,0,0,1,4.52,4.56c0,4.74-3,8.72-8,10.63A.92.92,0,0,1,12.28,31Z"}),React.createElement("path",{d:"M19.77,30.28a.81.81,0,0,1-.52-.2.76.76,0,0,1,0-1.08,12.63,12.63,0,0,0,3.54-8.68c0-1.56-.48-6.65-6.7-6.65a6.83,6.83,0,0,0-4.94,1.87A6.17,6.17,0,0,0,9.32,20a.77.77,0,0,1-.77.76h0A.76.76,0,0,1,7.78,20,7.73,7.73,0,0,1,10,14.46a8.34,8.34,0,0,1,6-2.32c6.08,0,8.24,4.4,8.24,8.18A14.09,14.09,0,0,1,20.34,30,.75.75,0,0,1,19.77,30.28Z"}),React.createElement("path",{d:"M8.66,27.74a14.14,14.14,0,0,1-1.56-.09.76.76,0,1,1,.17-1.52c2.49.28,4.45-.16,5.84-1.32a6.37,6.37,0,0,0,2.12-4.53.75.75,0,0,1,.82-.71.78.78,0,0,1,.72.81A7.89,7.89,0,0,1,14.09,26,8.2,8.2,0,0,1,8.66,27.74Z"}),props.children);});var FingerprintRecognition24=/*#__PURE__*/React.forwardRef(function FingerprintRecognition24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7,5.21a.77.77,0,0,1-.46-1.38A15.46,15.46,0,0,1,16,1c2.66,0,6.48.45,9.5,2.62a.77.77,0,0,1,.18,1.07.78.78,0,0,1-1.08.17A15,15,0,0,0,16,2.53,14,14,0,0,0,7.5,5.05.74.74,0,0,1,7,5.21Z"}),React.createElement("path",{d:"M28.23,12.26a.78.78,0,0,1-.63-.33C25.87,9.49,22.78,6.24,16,6.24a14,14,0,0,0-11.63,5.7.77.77,0,0,1-1.07.17A.76.76,0,0,1,3.15,11,15.54,15.54,0,0,1,16,4.71c5.61,0,9.81,2.08,12.84,6.34a.77.77,0,0,1-.19,1.07A.79.79,0,0,1,28.23,12.26Z"}),React.createElement("path",{d:"M12.28,31a.78.78,0,0,1-.72-.49.75.75,0,0,1,.44-1c4.37-1.68,7-5.12,7-9.21a2.8,2.8,0,0,0-3-3c-1.86,0-2.76,1-3,3.35a4.27,4.27,0,0,1-4.52,3.83,4.27,4.27,0,0,1-4.32-4.59A11.71,11.71,0,0,1,16,8.39a12,12,0,0,1,12,11.93,18.66,18.66,0,0,1-1.39,6.5.78.78,0,0,1-1,.41.76.76,0,0,1-.41-1,17.25,17.25,0,0,0,1.27-5.91A10.45,10.45,0,0,0,16,9.92a10.18,10.18,0,0,0-10.38,10,2.77,2.77,0,0,0,2.79,3.06,2.74,2.74,0,0,0,3-2.48c.36-3.11,1.89-4.69,4.56-4.69a4.31,4.31,0,0,1,4.52,4.56c0,4.74-3,8.72-8,10.63A.92.92,0,0,1,12.28,31Z"}),React.createElement("path",{d:"M19.77,30.28a.81.81,0,0,1-.52-.2.76.76,0,0,1,0-1.08,12.63,12.63,0,0,0,3.54-8.68c0-1.56-.48-6.65-6.7-6.65a6.83,6.83,0,0,0-4.94,1.87A6.17,6.17,0,0,0,9.32,20a.77.77,0,0,1-.77.76h0A.76.76,0,0,1,7.78,20,7.73,7.73,0,0,1,10,14.46a8.34,8.34,0,0,1,6-2.32c6.08,0,8.24,4.4,8.24,8.18A14.09,14.09,0,0,1,20.34,30,.75.75,0,0,1,19.77,30.28Z"}),React.createElement("path",{d:"M8.66,27.74a14.14,14.14,0,0,1-1.56-.09.76.76,0,1,1,.17-1.52c2.49.28,4.45-.16,5.84-1.32a6.37,6.37,0,0,0,2.12-4.53.75.75,0,0,1,.82-.71.78.78,0,0,1,.72.81A7.89,7.89,0,0,1,14.09,26,8.2,8.2,0,0,1,8.66,27.74Z"}),props.children);});var FingerprintRecognition20=/*#__PURE__*/React.forwardRef(function FingerprintRecognition20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7,5.21a.77.77,0,0,1-.46-1.38A15.46,15.46,0,0,1,16,1c2.66,0,6.48.45,9.5,2.62a.77.77,0,0,1,.18,1.07.78.78,0,0,1-1.08.17A15,15,0,0,0,16,2.53,14,14,0,0,0,7.5,5.05.74.74,0,0,1,7,5.21Z"}),React.createElement("path",{d:"M28.23,12.26a.78.78,0,0,1-.63-.33C25.87,9.49,22.78,6.24,16,6.24a14,14,0,0,0-11.63,5.7.77.77,0,0,1-1.07.17A.76.76,0,0,1,3.15,11,15.54,15.54,0,0,1,16,4.71c5.61,0,9.81,2.08,12.84,6.34a.77.77,0,0,1-.19,1.07A.79.79,0,0,1,28.23,12.26Z"}),React.createElement("path",{d:"M12.28,31a.78.78,0,0,1-.72-.49.75.75,0,0,1,.44-1c4.37-1.68,7-5.12,7-9.21a2.8,2.8,0,0,0-3-3c-1.86,0-2.76,1-3,3.35a4.27,4.27,0,0,1-4.52,3.83,4.27,4.27,0,0,1-4.32-4.59A11.71,11.71,0,0,1,16,8.39a12,12,0,0,1,12,11.93,18.66,18.66,0,0,1-1.39,6.5.78.78,0,0,1-1,.41.76.76,0,0,1-.41-1,17.25,17.25,0,0,0,1.27-5.91A10.45,10.45,0,0,0,16,9.92a10.18,10.18,0,0,0-10.38,10,2.77,2.77,0,0,0,2.79,3.06,2.74,2.74,0,0,0,3-2.48c.36-3.11,1.89-4.69,4.56-4.69a4.31,4.31,0,0,1,4.52,4.56c0,4.74-3,8.72-8,10.63A.92.92,0,0,1,12.28,31Z"}),React.createElement("path",{d:"M19.77,30.28a.81.81,0,0,1-.52-.2.76.76,0,0,1,0-1.08,12.63,12.63,0,0,0,3.54-8.68c0-1.56-.48-6.65-6.7-6.65a6.83,6.83,0,0,0-4.94,1.87A6.17,6.17,0,0,0,9.32,20a.77.77,0,0,1-.77.76h0A.76.76,0,0,1,7.78,20,7.73,7.73,0,0,1,10,14.46a8.34,8.34,0,0,1,6-2.32c6.08,0,8.24,4.4,8.24,8.18A14.09,14.09,0,0,1,20.34,30,.75.75,0,0,1,19.77,30.28Z"}),React.createElement("path",{d:"M8.66,27.74a14.14,14.14,0,0,1-1.56-.09.76.76,0,1,1,.17-1.52c2.49.28,4.45-.16,5.84-1.32a6.37,6.37,0,0,0,2.12-4.53.75.75,0,0,1,.82-.71.78.78,0,0,1,.72.81A7.89,7.89,0,0,1,14.09,26,8.2,8.2,0,0,1,8.66,27.74Z"}),props.children);});var FingerprintRecognition16=/*#__PURE__*/React.forwardRef(function FingerprintRecognition16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7,5.21a.77.77,0,0,1-.46-1.38A15.46,15.46,0,0,1,16,1c2.66,0,6.48.45,9.5,2.62a.77.77,0,0,1,.18,1.07.78.78,0,0,1-1.08.17A15,15,0,0,0,16,2.53,14,14,0,0,0,7.5,5.05.74.74,0,0,1,7,5.21Z"}),React.createElement("path",{d:"M28.23,12.26a.78.78,0,0,1-.63-.33C25.87,9.49,22.78,6.24,16,6.24a14,14,0,0,0-11.63,5.7.77.77,0,0,1-1.07.17A.76.76,0,0,1,3.15,11,15.54,15.54,0,0,1,16,4.71c5.61,0,9.81,2.08,12.84,6.34a.77.77,0,0,1-.19,1.07A.79.79,0,0,1,28.23,12.26Z"}),React.createElement("path",{d:"M12.28,31a.78.78,0,0,1-.72-.49.75.75,0,0,1,.44-1c4.37-1.68,7-5.12,7-9.21a2.8,2.8,0,0,0-3-3c-1.86,0-2.76,1-3,3.35a4.27,4.27,0,0,1-4.52,3.83,4.27,4.27,0,0,1-4.32-4.59A11.71,11.71,0,0,1,16,8.39a12,12,0,0,1,12,11.93,18.66,18.66,0,0,1-1.39,6.5.78.78,0,0,1-1,.41.76.76,0,0,1-.41-1,17.25,17.25,0,0,0,1.27-5.91A10.45,10.45,0,0,0,16,9.92a10.18,10.18,0,0,0-10.38,10,2.77,2.77,0,0,0,2.79,3.06,2.74,2.74,0,0,0,3-2.48c.36-3.11,1.89-4.69,4.56-4.69a4.31,4.31,0,0,1,4.52,4.56c0,4.74-3,8.72-8,10.63A.92.92,0,0,1,12.28,31Z"}),React.createElement("path",{d:"M19.77,30.28a.81.81,0,0,1-.52-.2.76.76,0,0,1,0-1.08,12.63,12.63,0,0,0,3.54-8.68c0-1.56-.48-6.65-6.7-6.65a6.83,6.83,0,0,0-4.94,1.87A6.17,6.17,0,0,0,9.32,20a.77.77,0,0,1-.77.76h0A.76.76,0,0,1,7.78,20,7.73,7.73,0,0,1,10,14.46a8.34,8.34,0,0,1,6-2.32c6.08,0,8.24,4.4,8.24,8.18A14.09,14.09,0,0,1,20.34,30,.75.75,0,0,1,19.77,30.28Z"}),React.createElement("path",{d:"M8.66,27.74a14.14,14.14,0,0,1-1.56-.09.76.76,0,1,1,.17-1.52c2.49.28,4.45-.16,5.84-1.32a6.37,6.37,0,0,0,2.12-4.53.75.75,0,0,1,.82-.71.78.78,0,0,1,.72.81A7.89,7.89,0,0,1,14.09,26,8.2,8.2,0,0,1,8.66,27.74Z"}),props.children);});var FishMultiple32=/*#__PURE__*/React.forwardRef(function FishMultiple32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,14a12.9845,12.9845,0,0,0-3.8286-9.2427L24.4143,3,23,4.4138l1.7573,1.7574a11.0713,11.0713,0,0,1,0,15.6572L22,24.5857,23.4143,26l2.7571-2.7573A12.9845,12.9845,0,0,0,30,14Z"}),React.createElement("circle",{cx:"17",cy:"11",r:"1"}),React.createElement("path",{d:"M22,14a12.9845,12.9845,0,0,0-3.8286-9.2427L16.4143,3,15,4.4138l1.7573,1.7574a11.0713,11.0713,0,0,1,0,15.6572L14,24.5857,15.4143,26l2.7571-2.7573A12.9845,12.9845,0,0,0,22,14Z"}),React.createElement("circle",{cx:"25",cy:"11",r:"1"}),React.createElement("circle",{cx:"9",cy:"11",r:"1"}),React.createElement("path",{d:"M9.4141,24l.7573-.7573a13.0708,13.0708,0,0,0,0-18.4854L8,2.5857,5.8286,4.7571a13.0708,13.0708,0,0,0,0,18.4854L6.5859,24,2.293,28.2928A1,1,0,0,0,3,30H13a1,1,0,0,0,.707-1.707ZM4,14A10.9988,10.9988,0,0,1,7.2427,6.1712L8,5.4138l.7573.7574a11.0713,11.0713,0,0,1,0,15.6572L8,22.5857l-.7573-.7573A10.9988,10.9988,0,0,1,4,14ZM5.4141,28,8,25.4138,10.5859,28Z"}),props.children);});var FishMultiple24=/*#__PURE__*/React.forwardRef(function FishMultiple24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,14a12.9845,12.9845,0,0,0-3.8286-9.2427L24.4143,3,23,4.4138l1.7573,1.7574a11.0713,11.0713,0,0,1,0,15.6572L22,24.5857,23.4143,26l2.7571-2.7573A12.9845,12.9845,0,0,0,30,14Z"}),React.createElement("circle",{cx:"17",cy:"11",r:"1"}),React.createElement("path",{d:"M22,14a12.9845,12.9845,0,0,0-3.8286-9.2427L16.4143,3,15,4.4138l1.7573,1.7574a11.0713,11.0713,0,0,1,0,15.6572L14,24.5857,15.4143,26l2.7571-2.7573A12.9845,12.9845,0,0,0,22,14Z"}),React.createElement("circle",{cx:"25",cy:"11",r:"1"}),React.createElement("circle",{cx:"9",cy:"11",r:"1"}),React.createElement("path",{d:"M9.4141,24l.7573-.7573a13.0708,13.0708,0,0,0,0-18.4854L8,2.5857,5.8286,4.7571a13.0708,13.0708,0,0,0,0,18.4854L6.5859,24,2.293,28.2928A1,1,0,0,0,3,30H13a1,1,0,0,0,.707-1.707ZM4,14A10.9988,10.9988,0,0,1,7.2427,6.1712L8,5.4138l.7573.7574a11.0713,11.0713,0,0,1,0,15.6572L8,22.5857l-.7573-.7573A10.9988,10.9988,0,0,1,4,14ZM5.4141,28,8,25.4138,10.5859,28Z"}),props.children);});var FishMultiple20=/*#__PURE__*/React.forwardRef(function FishMultiple20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,14a12.9845,12.9845,0,0,0-3.8286-9.2427L24.4143,3,23,4.4138l1.7573,1.7574a11.0713,11.0713,0,0,1,0,15.6572L22,24.5857,23.4143,26l2.7571-2.7573A12.9845,12.9845,0,0,0,30,14Z"}),React.createElement("circle",{cx:"17",cy:"11",r:"1"}),React.createElement("path",{d:"M22,14a12.9845,12.9845,0,0,0-3.8286-9.2427L16.4143,3,15,4.4138l1.7573,1.7574a11.0713,11.0713,0,0,1,0,15.6572L14,24.5857,15.4143,26l2.7571-2.7573A12.9845,12.9845,0,0,0,22,14Z"}),React.createElement("circle",{cx:"25",cy:"11",r:"1"}),React.createElement("circle",{cx:"9",cy:"11",r:"1"}),React.createElement("path",{d:"M9.4141,24l.7573-.7573a13.0708,13.0708,0,0,0,0-18.4854L8,2.5857,5.8286,4.7571a13.0708,13.0708,0,0,0,0,18.4854L6.5859,24,2.293,28.2928A1,1,0,0,0,3,30H13a1,1,0,0,0,.707-1.707ZM4,14A10.9988,10.9988,0,0,1,7.2427,6.1712L8,5.4138l.7573.7574a11.0713,11.0713,0,0,1,0,15.6572L8,22.5857l-.7573-.7573A10.9988,10.9988,0,0,1,4,14ZM5.4141,28,8,25.4138,10.5859,28Z"}),props.children);});var FishMultiple16=/*#__PURE__*/React.forwardRef(function FishMultiple16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,14a12.9845,12.9845,0,0,0-3.8286-9.2427L24.4143,3,23,4.4138l1.7573,1.7574a11.0713,11.0713,0,0,1,0,15.6572L22,24.5857,23.4143,26l2.7571-2.7573A12.9845,12.9845,0,0,0,30,14Z"}),React.createElement("circle",{cx:"17",cy:"11",r:"1"}),React.createElement("path",{d:"M22,14a12.9845,12.9845,0,0,0-3.8286-9.2427L16.4143,3,15,4.4138l1.7573,1.7574a11.0713,11.0713,0,0,1,0,15.6572L14,24.5857,15.4143,26l2.7571-2.7573A12.9845,12.9845,0,0,0,22,14Z"}),React.createElement("circle",{cx:"25",cy:"11",r:"1"}),React.createElement("circle",{cx:"9",cy:"11",r:"1"}),React.createElement("path",{d:"M9.4141,24l.7573-.7573a13.0708,13.0708,0,0,0,0-18.4854L8,2.5857,5.8286,4.7571a13.0708,13.0708,0,0,0,0,18.4854L6.5859,24,2.293,28.2928A1,1,0,0,0,3,30H13a1,1,0,0,0,.707-1.707ZM4,14A10.9988,10.9988,0,0,1,7.2427,6.1712L8,5.4138l.7573.7574a11.0713,11.0713,0,0,1,0,15.6572L8,22.5857l-.7573-.7573A10.9988,10.9988,0,0,1,4,14ZM5.4141,28,8,25.4138,10.5859,28Z"}),props.children);});var Fish32=/*#__PURE__*/React.forwardRef(function Fish32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"24",cy:"7",r:"1"}),React.createElement("path",{d:"M26,2A16.0183,16.0183,0,0,0,10,18v2H3a1,1,0,0,0-.707,1.707l8,8A1,1,0,0,0,12,29V22h2A16.0183,16.0183,0,0,0,30,6V2ZM10,26.5857,5.4141,22H10ZM12,20V18a13.9394,13.9394,0,0,1,3.908-9.6777l7.77,7.7695A13.94,13.94,0,0,1,14,20ZM28,6a13.9163,13.9163,0,0,1-2.98,8.6055L17.3945,6.98A13.9163,13.9163,0,0,1,26,4h2Z"}),props.children);});var Fish24=/*#__PURE__*/React.forwardRef(function Fish24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"24",cy:"7",r:"1"}),React.createElement("path",{d:"M26,2A16.0183,16.0183,0,0,0,10,18v2H3a1,1,0,0,0-.707,1.707l8,8A1,1,0,0,0,12,29V22h2A16.0183,16.0183,0,0,0,30,6V2ZM10,26.5857,5.4141,22H10ZM12,20V18a13.9394,13.9394,0,0,1,3.908-9.6777l7.77,7.7695A13.94,13.94,0,0,1,14,20ZM28,6a13.9163,13.9163,0,0,1-2.98,8.6055L17.3945,6.98A13.9163,13.9163,0,0,1,26,4h2Z"}),props.children);});var Fish20=/*#__PURE__*/React.forwardRef(function Fish20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"24",cy:"7",r:"1"}),React.createElement("path",{d:"M26,2A16.0183,16.0183,0,0,0,10,18v2H3a1,1,0,0,0-.707,1.707l8,8A1,1,0,0,0,12,29V22h2A16.0183,16.0183,0,0,0,30,6V2ZM10,26.5857,5.4141,22H10ZM12,20V18a13.9394,13.9394,0,0,1,3.908-9.6777l7.77,7.7695A13.94,13.94,0,0,1,14,20ZM28,6a13.9163,13.9163,0,0,1-2.98,8.6055L17.3945,6.98A13.9163,13.9163,0,0,1,26,4h2Z"}),props.children);});var Fish16=/*#__PURE__*/React.forwardRef(function Fish16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"24",cy:"7",r:"1"}),React.createElement("path",{d:"M26,2A16.0183,16.0183,0,0,0,10,18v2H3a1,1,0,0,0-.707,1.707l8,8A1,1,0,0,0,12,29V22h2A16.0183,16.0183,0,0,0,30,6V2ZM10,26.5857,5.4141,22H10ZM12,20V18a13.9394,13.9394,0,0,1,3.908-9.6777l7.77,7.7695A13.94,13.94,0,0,1,14,20ZM28,6a13.9163,13.9163,0,0,1-2.98,8.6055L17.3945,6.98A13.9163,13.9163,0,0,1,26,4h2Z"}),props.children);});var FitToScreen32=/*#__PURE__*/React.forwardRef(function FitToScreen32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 16 24 16 24 8 16 8 16 10 22 10 22 16"}),React.createElement("polygon",{points:"8 24 16 24 16 22 10 22 10 16 8 16 8 24"}),React.createElement("path",{d:"M26,28H6a2.0023,2.0023,0,0,1-2-2V6A2.0023,2.0023,0,0,1,6,4H26a2.0023,2.0023,0,0,1,2,2V26A2.0023,2.0023,0,0,1,26,28ZM6,6V26H26.0012L26,6Z"}),props.children);});var FitToScreen24=/*#__PURE__*/React.forwardRef(function FitToScreen24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 16 24 16 24 8 16 8 16 10 22 10 22 16"}),React.createElement("polygon",{points:"8 24 16 24 16 22 10 22 10 16 8 16 8 24"}),React.createElement("path",{d:"M26,28H6a2.0023,2.0023,0,0,1-2-2V6A2.0023,2.0023,0,0,1,6,4H26a2.0023,2.0023,0,0,1,2,2V26A2.0023,2.0023,0,0,1,26,28ZM6,6V26H26.0012L26,6Z"}),props.children);});var FitToScreen20=/*#__PURE__*/React.forwardRef(function FitToScreen20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 16 24 16 24 8 16 8 16 10 22 10 22 16"}),React.createElement("polygon",{points:"8 24 16 24 16 22 10 22 10 16 8 16 8 24"}),React.createElement("path",{d:"M26,28H6a2.0023,2.0023,0,0,1-2-2V6A2.0023,2.0023,0,0,1,6,4H26a2.0023,2.0023,0,0,1,2,2V26A2.0023,2.0023,0,0,1,26,28ZM6,6V26H26.0012L26,6Z"}),props.children);});var FitToScreen16=/*#__PURE__*/React.forwardRef(function FitToScreen16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"22 16 24 16 24 8 16 8 16 10 22 10 22 16"}),React.createElement("polygon",{points:"8 24 16 24 16 22 10 22 10 16 8 16 8 24"}),React.createElement("path",{d:"M26,28H6a2.0023,2.0023,0,0,1-2-2V6A2.0023,2.0023,0,0,1,6,4H26a2.0023,2.0023,0,0,1,2,2V26A2.0023,2.0023,0,0,1,26,28ZM6,6V26H26.0012L26,6Z"}),props.children);});var Flag32=/*#__PURE__*/React.forwardRef(function Flag32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,30H4V2H28l-5.8,9L28,20H6ZM6,18H24.33L19.8,11l4.53-7H6Z"}),props.children);});var Flag24=/*#__PURE__*/React.forwardRef(function Flag24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,30H4V2H28l-5.8,9L28,20H6ZM6,18H24.33L19.8,11l4.53-7H6Z"}),props.children);});var Flag20=/*#__PURE__*/React.forwardRef(function Flag20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,30H4V2H28l-5.8,9L28,20H6ZM6,18H24.33L19.8,11l4.53-7H6Z"}),props.children);});var Flag16=/*#__PURE__*/React.forwardRef(function Flag16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M6,30H4V2H28l-5.8,9L28,20H6ZM6,18H24.33L19.8,11l4.53-7H6Z"}),props.children);});var FlaggingTaxi32=/*#__PURE__*/React.forwardRef(function FlaggingTaxi32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.7976,2,20.3555,8.6641A2.9941,2.9941,0,0,1,17.8594,10H12a3.0033,3.0033,0,0,0-3,3v6a2.0023,2.0023,0,0,0,2,2v7a2.0023,2.0023,0,0,0,2,2h4a2.0023,2.0023,0,0,0,2-2V16H17V28H13V19H11V13a1.0009,1.0009,0,0,1,1-1h5.8594a4.9881,4.9881,0,0,0,4.16-2.2266l4.4422-6.664Z"}),React.createElement("path",{d:"M11,5a4,4,0,1,1,4,4A4.0042,4.0042,0,0,1,11,5Zm2,0a2,2,0,1,0,2-2A2.0023,2.0023,0,0,0,13,5Z"}),props.children);});var FlaggingTaxi24=/*#__PURE__*/React.forwardRef(function FlaggingTaxi24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.7976,2,20.3555,8.6641A2.9941,2.9941,0,0,1,17.8594,10H12a3.0033,3.0033,0,0,0-3,3v6a2.0023,2.0023,0,0,0,2,2v7a2.0023,2.0023,0,0,0,2,2h4a2.0023,2.0023,0,0,0,2-2V16H17V28H13V19H11V13a1.0009,1.0009,0,0,1,1-1h5.8594a4.9881,4.9881,0,0,0,4.16-2.2266l4.4422-6.664Z"}),React.createElement("path",{d:"M11,5a4,4,0,1,1,4,4A4.0042,4.0042,0,0,1,11,5Zm2,0a2,2,0,1,0,2-2A2.0023,2.0023,0,0,0,13,5Z"}),props.children);});var FlaggingTaxi20=/*#__PURE__*/React.forwardRef(function FlaggingTaxi20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.7976,2,20.3555,8.6641A2.9941,2.9941,0,0,1,17.8594,10H12a3.0033,3.0033,0,0,0-3,3v6a2.0023,2.0023,0,0,0,2,2v7a2.0023,2.0023,0,0,0,2,2h4a2.0023,2.0023,0,0,0,2-2V16H17V28H13V19H11V13a1.0009,1.0009,0,0,1,1-1h5.8594a4.9881,4.9881,0,0,0,4.16-2.2266l4.4422-6.664Z"}),React.createElement("path",{d:"M11,5a4,4,0,1,1,4,4A4.0042,4.0042,0,0,1,11,5Zm2,0a2,2,0,1,0,2-2A2.0023,2.0023,0,0,0,13,5Z"}),props.children);});var FlaggingTaxi16=/*#__PURE__*/React.forwardRef(function FlaggingTaxi16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.7976,2,20.3555,8.6641A2.9941,2.9941,0,0,1,17.8594,10H12a3.0033,3.0033,0,0,0-3,3v6a2.0023,2.0023,0,0,0,2,2v7a2.0023,2.0023,0,0,0,2,2h4a2.0023,2.0023,0,0,0,2-2V16H17V28H13V19H11V13a1.0009,1.0009,0,0,1,1-1h5.8594a4.9881,4.9881,0,0,0,4.16-2.2266l4.4422-6.664Z"}),React.createElement("path",{d:"M11,5a4,4,0,1,1,4,4A4.0042,4.0042,0,0,1,11,5Zm2,0a2,2,0,1,0,2-2A2.0023,2.0023,0,0,0,13,5Z"}),props.children);});var FlashFilled32=/*#__PURE__*/React.forwardRef(function FlashFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61,29.92a1,1,0,0,1-.6-1.07L12.83,17H8a1,1,0,0,1-1-1.23l3-13A1,1,0,0,1,11,2H21a1,1,0,0,1,.78.37,1,1,0,0,1,.2.85L20.25,11H25a1,1,0,0,1,.9.56,1,1,0,0,1-.11,1l-13,17A1,1,0,0,1,12,30,1.09,1.09,0,0,1,11.61,29.92Z"}),props.children);});var FlashFilled24=/*#__PURE__*/React.forwardRef(function FlashFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61,29.92a1,1,0,0,1-.6-1.07L12.83,17H8a1,1,0,0,1-1-1.23l3-13A1,1,0,0,1,11,2H21a1,1,0,0,1,.78.37,1,1,0,0,1,.2.85L20.25,11H25a1,1,0,0,1,.9.56,1,1,0,0,1-.11,1l-13,17A1,1,0,0,1,12,30,1.09,1.09,0,0,1,11.61,29.92Z"}),props.children);});var FlashFilled20=/*#__PURE__*/React.forwardRef(function FlashFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61,29.92a1,1,0,0,1-.6-1.07L12.83,17H8a1,1,0,0,1-1-1.23l3-13A1,1,0,0,1,11,2H21a1,1,0,0,1,.78.37,1,1,0,0,1,.2.85L20.25,11H25a1,1,0,0,1,.9.56,1,1,0,0,1-.11,1l-13,17A1,1,0,0,1,12,30,1.09,1.09,0,0,1,11.61,29.92Z"}),props.children);});var FlashFilled16=/*#__PURE__*/React.forwardRef(function FlashFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61,29.92a1,1,0,0,1-.6-1.07L12.83,17H8a1,1,0,0,1-1-1.23l3-13A1,1,0,0,1,11,2H21a1,1,0,0,1,.78.37,1,1,0,0,1,.2.85L20.25,11H25a1,1,0,0,1,.9.56,1,1,0,0,1-.11,1l-13,17A1,1,0,0,1,12,30,1.09,1.09,0,0,1,11.61,29.92Z"}),props.children);});var FlashOffFilled32=/*#__PURE__*/React.forwardRef(function FlashOffFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,28.59,3.41,2,2,3.41,8.4,9.82,7,15.77A1,1,0,0,0,8,17h4.83L11,28.85a1,1,0,0,0,.6,1.07A1.09,1.09,0,0,0,12,30a1,1,0,0,0,.79-.39l6.68-8.73L28.59,30Z"}),React.createElement("path",{d:"M22.53,16.87l3.26-4.26a1,1,0,0,0,.11-1A1,1,0,0,0,25,11H20.25L22,3.22a1,1,0,0,0-.2-.85A1,1,0,0,0,21,2H11a1,1,0,0,0-1,.77l-.3,1.3Z"}),props.children);});var FlashOffFilled24=/*#__PURE__*/React.forwardRef(function FlashOffFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,28.59,3.41,2,2,3.41,8.4,9.82,7,15.77A1,1,0,0,0,8,17h4.83L11,28.85a1,1,0,0,0,.6,1.07A1.09,1.09,0,0,0,12,30a1,1,0,0,0,.79-.39l6.68-8.73L28.59,30Z"}),React.createElement("path",{d:"M22.53,16.87l3.26-4.26a1,1,0,0,0,.11-1A1,1,0,0,0,25,11H20.25L22,3.22a1,1,0,0,0-.2-.85A1,1,0,0,0,21,2H11a1,1,0,0,0-1,.77l-.3,1.3Z"}),props.children);});var FlashOffFilled20=/*#__PURE__*/React.forwardRef(function FlashOffFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,28.59,3.41,2,2,3.41,8.4,9.82,7,15.77A1,1,0,0,0,8,17h4.83L11,28.85a1,1,0,0,0,.6,1.07A1.09,1.09,0,0,0,12,30a1,1,0,0,0,.79-.39l6.68-8.73L28.59,30Z"}),React.createElement("path",{d:"M22.53,16.87l3.26-4.26a1,1,0,0,0,.11-1A1,1,0,0,0,25,11H20.25L22,3.22a1,1,0,0,0-.2-.85A1,1,0,0,0,21,2H11a1,1,0,0,0-1,.77l-.3,1.3Z"}),props.children);});var FlashOffFilled16=/*#__PURE__*/React.forwardRef(function FlashOffFilled16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M30,28.59,3.41,2,2,3.41,8.4,9.82,7,15.77A1,1,0,0,0,8,17h4.83L11,28.85a1,1,0,0,0,.6,1.07A1.09,1.09,0,0,0,12,30a1,1,0,0,0,.79-.39l6.68-8.73L28.59,30Z"}),React.createElement("path",{d:"M22.53,16.87l3.26-4.26a1,1,0,0,0,.11-1A1,1,0,0,0,25,11H20.25L22,3.22a1,1,0,0,0-.2-.85A1,1,0,0,0,21,2H11a1,1,0,0,0-1,.77l-.3,1.3Z"}),props.children);});var FlashOff32=/*#__PURE__*/React.forwardRef(function FlashOff32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.13,6.89,11.8,4h8l-2,9H23l-2.49,3.25,1.43,1.43,3.87-5.07a1,1,0,0,0,.11-1A1,1,0,0,0,25,11H20.25L22,3.22a1,1,0,0,0-.2-.85A1,1,0,0,0,21,2H11a1,1,0,0,0-1,.77L9.46,5.22Z"}),React.createElement("path",{d:"M30,28.59l-9.31-9.31h0l-1.42-1.43h0L10.6,9.19h0L8.93,7.52h0L3.41,2,2,3.41,8.4,9.82,7,15.77A1,1,0,0,0,8,17h4.83L11,28.85a1,1,0,0,0,.6,1.07A1.09,1.09,0,0,0,12,30a1,1,0,0,0,.79-.39l6.68-8.73L28.59,30ZM9.26,15l.81-3.52L13.59,15Zm4.32,10.28L15,16.37,18,19.45Z"}),props.children);});var FlashOff24=/*#__PURE__*/React.forwardRef(function FlashOff24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.13,6.89,11.8,4h8l-2,9H23l-2.49,3.25,1.43,1.43,3.87-5.07a1,1,0,0,0,.11-1A1,1,0,0,0,25,11H20.25L22,3.22a1,1,0,0,0-.2-.85A1,1,0,0,0,21,2H11a1,1,0,0,0-1,.77L9.46,5.22Z"}),React.createElement("path",{d:"M30,28.59l-9.31-9.31h0l-1.42-1.43h0L10.6,9.19h0L8.93,7.52h0L3.41,2,2,3.41,8.4,9.82,7,15.77A1,1,0,0,0,8,17h4.83L11,28.85a1,1,0,0,0,.6,1.07A1.09,1.09,0,0,0,12,30a1,1,0,0,0,.79-.39l6.68-8.73L28.59,30ZM9.26,15l.81-3.52L13.59,15Zm4.32,10.28L15,16.37,18,19.45Z"}),props.children);});var FlashOff20=/*#__PURE__*/React.forwardRef(function FlashOff20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.13,6.89,11.8,4h8l-2,9H23l-2.49,3.25,1.43,1.43,3.87-5.07a1,1,0,0,0,.11-1A1,1,0,0,0,25,11H20.25L22,3.22a1,1,0,0,0-.2-.85A1,1,0,0,0,21,2H11a1,1,0,0,0-1,.77L9.46,5.22Z"}),React.createElement("path",{d:"M30,28.59l-9.31-9.31h0l-1.42-1.43h0L10.6,9.19h0L8.93,7.52h0L3.41,2,2,3.41,8.4,9.82,7,15.77A1,1,0,0,0,8,17h4.83L11,28.85a1,1,0,0,0,.6,1.07A1.09,1.09,0,0,0,12,30a1,1,0,0,0,.79-.39l6.68-8.73L28.59,30ZM9.26,15l.81-3.52L13.59,15Zm4.32,10.28L15,16.37,18,19.45Z"}),props.children);});var FlashOff16=/*#__PURE__*/React.forwardRef(function FlashOff16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.13,6.89,11.8,4h8l-2,9H23l-2.49,3.25,1.43,1.43,3.87-5.07a1,1,0,0,0,.11-1A1,1,0,0,0,25,11H20.25L22,3.22a1,1,0,0,0-.2-.85A1,1,0,0,0,21,2H11a1,1,0,0,0-1,.77L9.46,5.22Z"}),React.createElement("path",{d:"M30,28.59l-9.31-9.31h0l-1.42-1.43h0L10.6,9.19h0L8.93,7.52h0L3.41,2,2,3.41,8.4,9.82,7,15.77A1,1,0,0,0,8,17h4.83L11,28.85a1,1,0,0,0,.6,1.07A1.09,1.09,0,0,0,12,30a1,1,0,0,0,.79-.39l6.68-8.73L28.59,30ZM9.26,15l.81-3.52L13.59,15Zm4.32,10.28L15,16.37,18,19.45Z"}),props.children);});var Flash32=/*#__PURE__*/React.forwardRef(function Flash32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61,29.92a1,1,0,0,1-.6-1.07L12.83,17H8a1,1,0,0,1-1-1.23l3-13A1,1,0,0,1,11,2H21a1,1,0,0,1,.78.37,1,1,0,0,1,.2.85L20.25,11H25a1,1,0,0,1,.9.56,1,1,0,0,1-.11,1l-13,17A1,1,0,0,1,12,30,1.09,1.09,0,0,1,11.61,29.92ZM17.75,13l2-9H11.8L9.26,15h5.91L13.58,25.28,23,13Z"}),props.children);});var Flash24=/*#__PURE__*/React.forwardRef(function Flash24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61,29.92a1,1,0,0,1-.6-1.07L12.83,17H8a1,1,0,0,1-1-1.23l3-13A1,1,0,0,1,11,2H21a1,1,0,0,1,.78.37,1,1,0,0,1,.2.85L20.25,11H25a1,1,0,0,1,.9.56,1,1,0,0,1-.11,1l-13,17A1,1,0,0,1,12,30,1.09,1.09,0,0,1,11.61,29.92ZM17.75,13l2-9H11.8L9.26,15h5.91L13.58,25.28,23,13Z"}),props.children);});var Flash20=/*#__PURE__*/React.forwardRef(function Flash20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61,29.92a1,1,0,0,1-.6-1.07L12.83,17H8a1,1,0,0,1-1-1.23l3-13A1,1,0,0,1,11,2H21a1,1,0,0,1,.78.37,1,1,0,0,1,.2.85L20.25,11H25a1,1,0,0,1,.9.56,1,1,0,0,1-.11,1l-13,17A1,1,0,0,1,12,30,1.09,1.09,0,0,1,11.61,29.92ZM17.75,13l2-9H11.8L9.26,15h5.91L13.58,25.28,23,13Z"}),props.children);});var Flash16=/*#__PURE__*/React.forwardRef(function Flash16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.61,29.92a1,1,0,0,1-.6-1.07L12.83,17H8a1,1,0,0,1-1-1.23l3-13A1,1,0,0,1,11,2H21a1,1,0,0,1,.78.37,1,1,0,0,1,.2.85L20.25,11H25a1,1,0,0,1,.9.56,1,1,0,0,1-.11,1l-13,17A1,1,0,0,1,12,30,1.09,1.09,0,0,1,11.61,29.92ZM17.75,13l2-9H11.8L9.26,15h5.91L13.58,25.28,23,13Z"}),props.children);});var FlowData32=/*#__PURE__*/React.forwardRef(function FlowData32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,23H11.86a4.17,4.17,0,0,0-.43-1L22,11.43A3.86,3.86,0,0,0,24,12a4,4,0,1,0-3.86-5H11.86a4,4,0,1,0,0,2h8.28a4.17,4.17,0,0,0,.43,1L10,20.57A3.86,3.86,0,0,0,8,20a4,4,0,1,0,3.86,5H20v3h8V20H20ZM8,10a2,2,0,1,1,2-2A2,2,0,0,1,8,10ZM24,6a2,2,0,1,1-2,2A2,2,0,0,1,24,6ZM8,26a2,2,0,1,1,2-2A2,2,0,0,1,8,26Zm14-4h4v4H22Z"}),props.children);});var FlowData24=/*#__PURE__*/React.forwardRef(function FlowData24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,23H11.86a4.17,4.17,0,0,0-.43-1L22,11.43A3.86,3.86,0,0,0,24,12a4,4,0,1,0-3.86-5H11.86a4,4,0,1,0,0,2h8.28a4.17,4.17,0,0,0,.43,1L10,20.57A3.86,3.86,0,0,0,8,20a4,4,0,1,0,3.86,5H20v3h8V20H20ZM8,10a2,2,0,1,1,2-2A2,2,0,0,1,8,10ZM24,6a2,2,0,1,1-2,2A2,2,0,0,1,24,6ZM8,26a2,2,0,1,1,2-2A2,2,0,0,1,8,26Zm14-4h4v4H22Z"}),props.children);});var FlowData20=/*#__PURE__*/React.forwardRef(function FlowData20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,23H11.86a4.17,4.17,0,0,0-.43-1L22,11.43A3.86,3.86,0,0,0,24,12a4,4,0,1,0-3.86-5H11.86a4,4,0,1,0,0,2h8.28a4.17,4.17,0,0,0,.43,1L10,20.57A3.86,3.86,0,0,0,8,20a4,4,0,1,0,3.86,5H20v3h8V20H20ZM8,10a2,2,0,1,1,2-2A2,2,0,0,1,8,10ZM24,6a2,2,0,1,1-2,2A2,2,0,0,1,24,6ZM8,26a2,2,0,1,1,2-2A2,2,0,0,1,8,26Zm14-4h4v4H22Z"}),props.children);});var FlowData16=/*#__PURE__*/React.forwardRef(function FlowData16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,23H11.86a4.17,4.17,0,0,0-.43-1L22,11.43A3.86,3.86,0,0,0,24,12a4,4,0,1,0-3.86-5H11.86a4,4,0,1,0,0,2h8.28a4.17,4.17,0,0,0,.43,1L10,20.57A3.86,3.86,0,0,0,8,20a4,4,0,1,0,3.86,5H20v3h8V20H20ZM8,10a2,2,0,1,1,2-2A2,2,0,0,1,8,10ZM24,6a2,2,0,1,1-2,2A2,2,0,0,1,24,6ZM8,26a2,2,0,1,1,2-2A2,2,0,0,1,8,26Zm14-4h4v4H22Z"}),props.children);});var FlowStream32=/*#__PURE__*/React.forwardRef(function FlowStream32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,24H11.86a4.17,4.17,0,0,0-.43-1L22,12.43A3.86,3.86,0,0,0,24,13a4,4,0,1,0-3.86-5H14v2h6.14a4.17,4.17,0,0,0,.43,1L10,21.57A3.86,3.86,0,0,0,8,21a4,4,0,1,0,3.86,5H20v3h8V21H20ZM24,7a2,2,0,1,1-2,2A2,2,0,0,1,24,7ZM8,27a2,2,0,1,1,2-2A2,2,0,0,1,8,27Zm14-4h4v4H22Z"}),React.createElement("path",{d:"M7.05,15.75a9,9,0,0,1,0-13.5l1.32,1.5a7,7,0,0,0,0,10.5Z"}),React.createElement("path",{d:"M9.69,12.75a5,5,0,0,1,0-7.5L11,6.75a3,3,0,0,0,0,4.5Z"}),props.children);});var FlowStream24=/*#__PURE__*/React.forwardRef(function FlowStream24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,24H11.86a4.17,4.17,0,0,0-.43-1L22,12.43A3.86,3.86,0,0,0,24,13a4,4,0,1,0-3.86-5H14v2h6.14a4.17,4.17,0,0,0,.43,1L10,21.57A3.86,3.86,0,0,0,8,21a4,4,0,1,0,3.86,5H20v3h8V21H20ZM24,7a2,2,0,1,1-2,2A2,2,0,0,1,24,7ZM8,27a2,2,0,1,1,2-2A2,2,0,0,1,8,27Zm14-4h4v4H22Z"}),React.createElement("path",{d:"M7.05,15.75a9,9,0,0,1,0-13.5l1.32,1.5a7,7,0,0,0,0,10.5Z"}),React.createElement("path",{d:"M9.69,12.75a5,5,0,0,1,0-7.5L11,6.75a3,3,0,0,0,0,4.5Z"}),props.children);});var FlowStream20=/*#__PURE__*/React.forwardRef(function FlowStream20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,24H11.86a4.17,4.17,0,0,0-.43-1L22,12.43A3.86,3.86,0,0,0,24,13a4,4,0,1,0-3.86-5H14v2h6.14a4.17,4.17,0,0,0,.43,1L10,21.57A3.86,3.86,0,0,0,8,21a4,4,0,1,0,3.86,5H20v3h8V21H20ZM24,7a2,2,0,1,1-2,2A2,2,0,0,1,24,7ZM8,27a2,2,0,1,1,2-2A2,2,0,0,1,8,27Zm14-4h4v4H22Z"}),React.createElement("path",{d:"M7.05,15.75a9,9,0,0,1,0-13.5l1.32,1.5a7,7,0,0,0,0,10.5Z"}),React.createElement("path",{d:"M9.69,12.75a5,5,0,0,1,0-7.5L11,6.75a3,3,0,0,0,0,4.5Z"}),props.children);});var FlowStream16=/*#__PURE__*/React.forwardRef(function FlowStream16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M20,24H11.86a4.17,4.17,0,0,0-.43-1L22,12.43A3.86,3.86,0,0,0,24,13a4,4,0,1,0-3.86-5H14v2h6.14a4.17,4.17,0,0,0,.43,1L10,21.57A3.86,3.86,0,0,0,8,21a4,4,0,1,0,3.86,5H20v3h8V21H20ZM24,7a2,2,0,1,1-2,2A2,2,0,0,1,24,7ZM8,27a2,2,0,1,1,2-2A2,2,0,0,1,8,27Zm14-4h4v4H22Z"}),React.createElement("path",{d:"M7.05,15.75a9,9,0,0,1,0-13.5l1.32,1.5a7,7,0,0,0,0,10.5Z"}),React.createElement("path",{d:"M9.69,12.75a5,5,0,0,1,0-7.5L11,6.75a3,3,0,0,0,0,4.5Z"}),props.children);});var Flow32=/*#__PURE__*/React.forwardRef(function Flow32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,22.14V17a2,2,0,0,0-2-2H17V9.86a4,4,0,1,0-2,0V15H7a2,2,0,0,0-2,2v5.14a4,4,0,1,0,2,0V17H25v5.14a4,4,0,1,0,2,0ZM8,26a2,2,0,1,1-2-2A2,2,0,0,1,8,26ZM14,6a2,2,0,1,1,2,2A2,2,0,0,1,14,6ZM26,28a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var Flow24=/*#__PURE__*/React.forwardRef(function Flow24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,22.14V17a2,2,0,0,0-2-2H17V9.86a4,4,0,1,0-2,0V15H7a2,2,0,0,0-2,2v5.14a4,4,0,1,0,2,0V17H25v5.14a4,4,0,1,0,2,0ZM8,26a2,2,0,1,1-2-2A2,2,0,0,1,8,26ZM14,6a2,2,0,1,1,2,2A2,2,0,0,1,14,6ZM26,28a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var Flow20=/*#__PURE__*/React.forwardRef(function Flow20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,22.14V17a2,2,0,0,0-2-2H17V9.86a4,4,0,1,0-2,0V15H7a2,2,0,0,0-2,2v5.14a4,4,0,1,0,2,0V17H25v5.14a4,4,0,1,0,2,0ZM8,26a2,2,0,1,1-2-2A2,2,0,0,1,8,26ZM14,6a2,2,0,1,1,2,2A2,2,0,0,1,14,6ZM26,28a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var Flow16=/*#__PURE__*/React.forwardRef(function Flow16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,22.14V17a2,2,0,0,0-2-2H17V9.86a4,4,0,1,0-2,0V15H7a2,2,0,0,0-2,2v5.14a4,4,0,1,0,2,0V17H25v5.14a4,4,0,1,0,2,0ZM8,26a2,2,0,1,1-2-2A2,2,0,0,1,8,26ZM14,6a2,2,0,1,1,2,2A2,2,0,0,1,14,6ZM26,28a2,2,0,1,1,2-2A2,2,0,0,1,26,28Z"}),props.children);});var Fog32=/*#__PURE__*/React.forwardRef(function Fog32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.8008,11.1382a8.9938,8.9938,0,0,0-17.6006,0A6.533,6.533,0,0,0,2,17.5H2V19a1,1,0,0,0,1,1H15a1,1,0,0,0,0-2H4v-.4966H4a4.5176,4.5176,0,0,1,4.144-4.4819l.8155-.064.0991-.812a6.9936,6.9936,0,0,1,13.8838,0l.0986.812.8154.064A4.4962,4.4962,0,0,1,23.5,22H7a1,1,0,0,0,0,2H23.5a6.4963,6.4963,0,0,0,1.3008-12.8618Z"}),React.createElement("rect",{width:"18",height:"2",x:"2",y:"26",rx:"1"}),props.children);});var Fog24=/*#__PURE__*/React.forwardRef(function Fog24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.8008,11.1382a8.9938,8.9938,0,0,0-17.6006,0A6.533,6.533,0,0,0,2,17.5H2V19a1,1,0,0,0,1,1H15a1,1,0,0,0,0-2H4v-.4966H4a4.5176,4.5176,0,0,1,4.144-4.4819l.8155-.064.0991-.812a6.9936,6.9936,0,0,1,13.8838,0l.0986.812.8154.064A4.4962,4.4962,0,0,1,23.5,22H7a1,1,0,0,0,0,2H23.5a6.4963,6.4963,0,0,0,1.3008-12.8618Z"}),React.createElement("rect",{width:"18",height:"2",x:"2",y:"26",rx:"1"}),props.children);});var Fog20=/*#__PURE__*/React.forwardRef(function Fog20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.8008,11.1382a8.9938,8.9938,0,0,0-17.6006,0A6.533,6.533,0,0,0,2,17.5H2V19a1,1,0,0,0,1,1H15a1,1,0,0,0,0-2H4v-.4966H4a4.5176,4.5176,0,0,1,4.144-4.4819l.8155-.064.0991-.812a6.9936,6.9936,0,0,1,13.8838,0l.0986.812.8154.064A4.4962,4.4962,0,0,1,23.5,22H7a1,1,0,0,0,0,2H23.5a6.4963,6.4963,0,0,0,1.3008-12.8618Z"}),React.createElement("rect",{width:"18",height:"2",x:"2",y:"26",rx:"1"}),props.children);});var Fog16=/*#__PURE__*/React.forwardRef(function Fog16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24.8008,11.1382a8.9938,8.9938,0,0,0-17.6006,0A6.533,6.533,0,0,0,2,17.5H2V19a1,1,0,0,0,1,1H15a1,1,0,0,0,0-2H4v-.4966H4a4.5176,4.5176,0,0,1,4.144-4.4819l.8155-.064.0991-.812a6.9936,6.9936,0,0,1,13.8838,0l.0986.812.8154.064A4.4962,4.4962,0,0,1,23.5,22H7a1,1,0,0,0,0,2H23.5a6.4963,6.4963,0,0,0,1.3008-12.8618Z"}),React.createElement("rect",{width:"18",height:"2",x:"2",y:"26",rx:"1"}),props.children);});var FolderAdd32=/*#__PURE__*/React.forwardRef(function FolderAdd32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"26,20 24,20 24,24 20,24 20,26 24,26 24,30 26,30 26,26 30,26 30,24 26,24"}),React.createElement("path",{d:"M28,8H16l-3.4-3.4C12.2,4.2,11.7,4,11.2,4H4C2.9,4,2,4.9,2,6v20c0,1.1,0.9,2,2,2h14v-2H4V6h7.2l3.4,3.4l0.6,0.6H28v8h2v-8\tC30,8.9,29.1,8,28,8z"}),props.children);});var FolderAdd24=/*#__PURE__*/React.forwardRef(function FolderAdd24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"26,20 24,20 24,24 20,24 20,26 24,26 24,30 26,30 26,26 30,26 30,24 26,24"}),React.createElement("path",{d:"M28,8H16l-3.4-3.4C12.2,4.2,11.7,4,11.2,4H4C2.9,4,2,4.9,2,6v20c0,1.1,0.9,2,2,2h14v-2H4V6h7.2l3.4,3.4l0.6,0.6H28v8h2v-8\tC30,8.9,29.1,8,28,8z"}),props.children);});var FolderAdd20=/*#__PURE__*/React.forwardRef(function FolderAdd20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"26,20 24,20 24,24 20,24 20,26 24,26 24,30 26,30 26,26 30,26 30,24 26,24"}),React.createElement("path",{d:"M28,8H16l-3.4-3.4C12.2,4.2,11.7,4,11.2,4H4C2.9,4,2,4.9,2,6v20c0,1.1,0.9,2,2,2h14v-2H4V6h7.2l3.4,3.4l0.6,0.6H28v8h2v-8\tC30,8.9,29.1,8,28,8z"}),props.children);});var FolderAdd16=/*#__PURE__*/React.forwardRef(function FolderAdd16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("polygon",{points:"26,20 24,20 24,24 20,24 20,26 24,26 24,30 26,30 26,26 30,26 30,24 26,24"}),React.createElement("path",{d:"M28,8H16l-3.4-3.4C12.2,4.2,11.7,4,11.2,4H4C2.9,4,2,4.9,2,6v20c0,1.1,0.9,2,2,2h14v-2H4V6h7.2l3.4,3.4l0.6,0.6H28v8h2v-8\tC30,8.9,29.1,8,28,8z"}),props.children);});var FolderDetails32=/*#__PURE__*/React.forwardRef(function FolderDetails32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"14",height:"2",x:"16",y:"20"}),React.createElement("rect",{width:"14",height:"2",x:"16",y:"24"}),React.createElement("rect",{width:"7",height:"2",x:"16",y:"28"}),React.createElement("path",{d:"M14,26H4V6h7.17l3.42,3.41.58.59H28v8h2V10a2,2,0,0,0-2-2H16L12.59,4.59A2,2,0,0,0,11.17,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H14Z"}),props.children);});var FolderDetails24=/*#__PURE__*/React.forwardRef(function FolderDetails24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"14",height:"2",x:"16",y:"20"}),React.createElement("rect",{width:"14",height:"2",x:"16",y:"24"}),React.createElement("rect",{width:"7",height:"2",x:"16",y:"28"}),React.createElement("path",{d:"M14,26H4V6h7.17l3.42,3.41.58.59H28v8h2V10a2,2,0,0,0-2-2H16L12.59,4.59A2,2,0,0,0,11.17,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H14Z"}),props.children);});var FolderDetails20=/*#__PURE__*/React.forwardRef(function FolderDetails20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"14",height:"2",x:"16",y:"20"}),React.createElement("rect",{width:"14",height:"2",x:"16",y:"24"}),React.createElement("rect",{width:"7",height:"2",x:"16",y:"28"}),React.createElement("path",{d:"M14,26H4V6h7.17l3.42,3.41.58.59H28v8h2V10a2,2,0,0,0-2-2H16L12.59,4.59A2,2,0,0,0,11.17,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H14Z"}),props.children);});var FolderDetails16=/*#__PURE__*/React.forwardRef(function FolderDetails16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("rect",{width:"14",height:"2",x:"16",y:"20"}),React.createElement("rect",{width:"14",height:"2",x:"16",y:"24"}),React.createElement("rect",{width:"7",height:"2",x:"16",y:"28"}),React.createElement("path",{d:"M14,26H4V6h7.17l3.42,3.41.58.59H28v8h2V10a2,2,0,0,0-2-2H16L12.59,4.59A2,2,0,0,0,11.17,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H14Z"}),props.children);});var FolderOff32=/*#__PURE__*/React.forwardRef(function FolderOff32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,8H25.4141L30,3.4141,28.5859,2,2,28.5859,3.4141,30l2-2H28a2,2,0,0,0,2-2V10A2,2,0,0,0,28,8Zm0,18H7.4141l16-16H28Z"}),React.createElement("path",{d:"M4,6h7.1716l3.4141,3.4141L15.1716,10H18V8H16L12.5859,4.5859A2.0007,2.0007,0,0,0,11.1716,4H4A2,2,0,0,0,2,6V24H4Z"}),props.children);});var FolderOff24=/*#__PURE__*/React.forwardRef(function FolderOff24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,8H25.4141L30,3.4141,28.5859,2,2,28.5859,3.4141,30l2-2H28a2,2,0,0,0,2-2V10A2,2,0,0,0,28,8Zm0,18H7.4141l16-16H28Z"}),React.createElement("path",{d:"M4,6h7.1716l3.4141,3.4141L15.1716,10H18V8H16L12.5859,4.5859A2.0007,2.0007,0,0,0,11.1716,4H4A2,2,0,0,0,2,6V24H4Z"}),props.children);});var FolderOff20=/*#__PURE__*/React.forwardRef(function FolderOff20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,8H25.4141L30,3.4141,28.5859,2,2,28.5859,3.4141,30l2-2H28a2,2,0,0,0,2-2V10A2,2,0,0,0,28,8Zm0,18H7.4141l16-16H28Z"}),React.createElement("path",{d:"M4,6h7.1716l3.4141,3.4141L15.1716,10H18V8H16L12.5859,4.5859A2.0007,2.0007,0,0,0,11.1716,4H4A2,2,0,0,0,2,6V24H4Z"}),props.children);});var FolderOff16=/*#__PURE__*/React.forwardRef(function FolderOff16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,8H25.4141L30,3.4141,28.5859,2,2,28.5859,3.4141,30l2-2H28a2,2,0,0,0,2-2V10A2,2,0,0,0,28,8Zm0,18H7.4141l16-16H28Z"}),React.createElement("path",{d:"M4,6h7.1716l3.4141,3.4141L15.1716,10H18V8H16L12.5859,4.5859A2.0007,2.0007,0,0,0,11.1716,4H4A2,2,0,0,0,2,6V24H4Z"}),props.children);});var FolderShared32=/*#__PURE__*/React.forwardRef(function FolderShared32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,8H16L12.59,4.59A2,2,0,0,0,11.17,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V10A2,2,0,0,0,28,8ZM22,26H14V25a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1Zm6,0H24V25a3,3,0,0,0-3-3H15a3,3,0,0,0-3,3v1H4V6h7.17l3.42,3.41.58.59H28Z"}),React.createElement("path",{d:"M14,17a4,4,0,1,0,4-4A4,4,0,0,0,14,17Zm4-2a2,2,0,1,1-2,2A2,2,0,0,1,18,15Z"}),props.children);});var FolderShared24=/*#__PURE__*/React.forwardRef(function FolderShared24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,8H16L12.59,4.59A2,2,0,0,0,11.17,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V10A2,2,0,0,0,28,8ZM22,26H14V25a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1Zm6,0H24V25a3,3,0,0,0-3-3H15a3,3,0,0,0-3,3v1H4V6h7.17l3.42,3.41.58.59H28Z"}),React.createElement("path",{d:"M14,17a4,4,0,1,0,4-4A4,4,0,0,0,14,17Zm4-2a2,2,0,1,1-2,2A2,2,0,0,1,18,15Z"}),props.children);});var FolderShared20=/*#__PURE__*/React.forwardRef(function FolderShared20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,8H16L12.59,4.59A2,2,0,0,0,11.17,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V10A2,2,0,0,0,28,8ZM22,26H14V25a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1Zm6,0H24V25a3,3,0,0,0-3-3H15a3,3,0,0,0-3,3v1H4V6h7.17l3.42,3.41.58.59H28Z"}),React.createElement("path",{d:"M14,17a4,4,0,1,0,4-4A4,4,0,0,0,14,17Zm4-2a2,2,0,1,1-2,2A2,2,0,0,1,18,15Z"}),props.children);});var FolderShared16=/*#__PURE__*/React.forwardRef(function FolderShared16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,8H16L12.59,4.59A2,2,0,0,0,11.17,4H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V10A2,2,0,0,0,28,8ZM22,26H14V25a1,1,0,0,1,1-1h6a1,1,0,0,1,1,1Zm6,0H24V25a3,3,0,0,0-3-3H15a3,3,0,0,0-3,3v1H4V6h7.17l3.42,3.41.58.59H28Z"}),React.createElement("path",{d:"M14,17a4,4,0,1,0,4-4A4,4,0,0,0,14,17Zm4-2a2,2,0,1,1-2,2A2,2,0,0,1,18,15Z"}),props.children);});var Folder32=/*#__PURE__*/React.forwardRef(function Folder32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.17,6l3.42,3.41.58.59H28V26H4V6h7.17m0-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V10a2,2,0,0,0-2-2H16L12.59,4.59A2,2,0,0,0,11.17,4Z"}),props.children);});var Folder24=/*#__PURE__*/React.forwardRef(function Folder24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.17,6l3.42,3.41.58.59H28V26H4V6h7.17m0-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V10a2,2,0,0,0-2-2H16L12.59,4.59A2,2,0,0,0,11.17,4Z"}),props.children);});var Folder20=/*#__PURE__*/React.forwardRef(function Folder20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.17,6l3.42,3.41.58.59H28V26H4V6h7.17m0-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V10a2,2,0,0,0-2-2H16L12.59,4.59A2,2,0,0,0,11.17,4Z"}),props.children);});var Folder16=/*#__PURE__*/React.forwardRef(function Folder16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M11.17,6l3.42,3.41.58.59H28V26H4V6h7.17m0-2H4A2,2,0,0,0,2,6V26a2,2,0,0,0,2,2H28a2,2,0,0,0,2-2V10a2,2,0,0,0-2-2H16L12.59,4.59A2,2,0,0,0,11.17,4Z"}),props.children);});var Folders32=/*#__PURE__*/React.forwardRef(function Folders32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,28H6a2.0021,2.0021,0,0,1-2-2V11A2.0021,2.0021,0,0,1,6,9h5.6665a2.0119,2.0119,0,0,1,1.2007.4L16.3335,12H26a2.0021,2.0021,0,0,1,2,2V26A2.0021,2.0021,0,0,1,26,28ZM11.6665,11H5.9985L6,26H26V14H15.6665Z"}),React.createElement("path",{d:"M28,9H17.6665l-4-3H6V4h7.6665a2.0119,2.0119,0,0,1,1.2007.4L18.3335,7H28Z"}),props.children);});var Folders24=/*#__PURE__*/React.forwardRef(function Folders24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,28H6a2.0021,2.0021,0,0,1-2-2V11A2.0021,2.0021,0,0,1,6,9h5.6665a2.0119,2.0119,0,0,1,1.2007.4L16.3335,12H26a2.0021,2.0021,0,0,1,2,2V26A2.0021,2.0021,0,0,1,26,28ZM11.6665,11H5.9985L6,26H26V14H15.6665Z"}),React.createElement("path",{d:"M28,9H17.6665l-4-3H6V4h7.6665a2.0119,2.0119,0,0,1,1.2007.4L18.3335,7H28Z"}),props.children);});var Folders20=/*#__PURE__*/React.forwardRef(function Folders20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,28H6a2.0021,2.0021,0,0,1-2-2V11A2.0021,2.0021,0,0,1,6,9h5.6665a2.0119,2.0119,0,0,1,1.2007.4L16.3335,12H26a2.0021,2.0021,0,0,1,2,2V26A2.0021,2.0021,0,0,1,26,28ZM11.6665,11H5.9985L6,26H26V14H15.6665Z"}),React.createElement("path",{d:"M28,9H17.6665l-4-3H6V4h7.6665a2.0119,2.0119,0,0,1,1.2007.4L18.3335,7H28Z"}),props.children);});var Folders16=/*#__PURE__*/React.forwardRef(function Folders16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,28H6a2.0021,2.0021,0,0,1-2-2V11A2.0021,2.0021,0,0,1,6,9h5.6665a2.0119,2.0119,0,0,1,1.2007.4L16.3335,12H26a2.0021,2.0021,0,0,1,2,2V26A2.0021,2.0021,0,0,1,26,28ZM11.6665,11H5.9985L6,26H26V14H15.6665Z"}),React.createElement("path",{d:"M28,9H17.6665l-4-3H6V4h7.6665a2.0119,2.0119,0,0,1,1.2007.4L18.3335,7H28Z"}),props.children);});var Fork32=/*#__PURE__*/React.forwardRef(function Fork32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18a3.9962,3.9962,0,0,0-3.8579,3H17V11h5.1421a4,4,0,1,0,0-2H17a2.002,2.002,0,0,0-2,2v4H9.8579a4,4,0,1,0,0,2H15v4a2.002,2.002,0,0,0,2,2h5.1421A3.9934,3.9934,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.002,2.002,0,0,1,26,8ZM6,18a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,18Zm20,6a2,2,0,1,1,2-2A2.002,2.002,0,0,1,26,24Z"}),props.children);});var Fork24=/*#__PURE__*/React.forwardRef(function Fork24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18a3.9962,3.9962,0,0,0-3.8579,3H17V11h5.1421a4,4,0,1,0,0-2H17a2.002,2.002,0,0,0-2,2v4H9.8579a4,4,0,1,0,0,2H15v4a2.002,2.002,0,0,0,2,2h5.1421A3.9934,3.9934,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.002,2.002,0,0,1,26,8ZM6,18a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,18Zm20,6a2,2,0,1,1,2-2A2.002,2.002,0,0,1,26,24Z"}),props.children);});var Fork20=/*#__PURE__*/React.forwardRef(function Fork20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18a3.9962,3.9962,0,0,0-3.8579,3H17V11h5.1421a4,4,0,1,0,0-2H17a2.002,2.002,0,0,0-2,2v4H9.8579a4,4,0,1,0,0,2H15v4a2.002,2.002,0,0,0,2,2h5.1421A3.9934,3.9934,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.002,2.002,0,0,1,26,8ZM6,18a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,18Zm20,6a2,2,0,1,1,2-2A2.002,2.002,0,0,1,26,24Z"}),props.children);});var Fork16=/*#__PURE__*/React.forwardRef(function Fork16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18a3.9962,3.9962,0,0,0-3.8579,3H17V11h5.1421a4,4,0,1,0,0-2H17a2.002,2.002,0,0,0-2,2v4H9.8579a4,4,0,1,0,0,2H15v4a2.002,2.002,0,0,0,2,2h5.1421A3.9934,3.9934,0,1,0,26,18ZM26,8a2,2,0,1,1-2,2A2.002,2.002,0,0,1,26,8ZM6,18a2,2,0,1,1,2-2A2.002,2.002,0,0,1,6,18Zm20,6a2,2,0,1,1,2-2A2.002,2.002,0,0,1,26,24Z"}),props.children);});var Forum32=/*#__PURE__*/React.forwardRef(function Forum32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H8C6.8,6,6,6.8,6,8v14c0,1.2,0.8,2,2,2h8v-2H8V8h20v14h-7.2L16,28.8l1.6,1.2l4.2-6H28c1.2,0,2-0.8,2-2V8\tC30,6.8,29.2,6,28,6z"}),React.createElement("path",{d:"M4,18H2V5c0-1.7,1.3-3,3-3h13v2H5C4.4,4,4,4.4,4,5V18z"}),props.children);});var Forum24=/*#__PURE__*/React.forwardRef(function Forum24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H8C6.8,6,6,6.8,6,8v14c0,1.2,0.8,2,2,2h8v-2H8V8h20v14h-7.2L16,28.8l1.6,1.2l4.2-6H28c1.2,0,2-0.8,2-2V8\tC30,6.8,29.2,6,28,6z"}),React.createElement("path",{d:"M4,18H2V5c0-1.7,1.3-3,3-3h13v2H5C4.4,4,4,4.4,4,5V18z"}),props.children);});var Forum20=/*#__PURE__*/React.forwardRef(function Forum20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H8C6.8,6,6,6.8,6,8v14c0,1.2,0.8,2,2,2h8v-2H8V8h20v14h-7.2L16,28.8l1.6,1.2l4.2-6H28c1.2,0,2-0.8,2-2V8\tC30,6.8,29.2,6,28,6z"}),React.createElement("path",{d:"M4,18H2V5c0-1.7,1.3-3,3-3h13v2H5C4.4,4,4,4.4,4,5V18z"}),props.children);});var Forum16=/*#__PURE__*/React.forwardRef(function Forum16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,6H8C6.8,6,6,6.8,6,8v14c0,1.2,0.8,2,2,2h8v-2H8V8h20v14h-7.2L16,28.8l1.6,1.2l4.2-6H28c1.2,0,2-0.8,2-2V8\tC30,6.8,29.2,6,28,6z"}),React.createElement("path",{d:"M4,18H2V5c0-1.7,1.3-3,3-3h13v2H5C4.4,4,4,4.4,4,5V18z"}),props.children);});var Forward_1032=/*#__PURE__*/React.forwardRef(function Forward_1032(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18A10,10,0,1,1,16,8h4v5l6-6L20,1V6H16A12,12,0,1,0,28,18Z"}),React.createElement("path",{d:"M19.63,22.13a2.84,2.84,0,0,1-1.28-.27,2.44,2.44,0,0,1-.89-.77,3.57,3.57,0,0,1-.52-1.25,7.69,7.69,0,0,1-.17-1.68,7.83,7.83,0,0,1,.17-1.68,3.65,3.65,0,0,1,.52-1.25,2.44,2.44,0,0,1,.89-.77,2.84,2.84,0,0,1,1.28-.27,2.44,2.44,0,0,1,2.16,1,5.23,5.23,0,0,1,.7,2.93,5.23,5.23,0,0,1-.7,2.93A2.44,2.44,0,0,1,19.63,22.13Zm0-1.22a1.07,1.07,0,0,0,1-.55A3.38,3.38,0,0,0,21,18.85V17.47a3.31,3.31,0,0,0-.29-1.5,1.23,1.23,0,0,0-2.06,0,3.31,3.31,0,0,0-.29,1.5v1.38a3.38,3.38,0,0,0,.29,1.51A1.06,1.06,0,0,0,19.63,20.91Z"}),React.createElement("path",{d:"M10.63,22V20.82h2V15.63l-1.86,1-.55-1.06,2.32-1.3H14v6.5h1.78V22Z"}),props.children);});var Forward_1024=/*#__PURE__*/React.forwardRef(function Forward_1024(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18A10,10,0,1,1,16,8h4v5l6-6L20,1V6H16A12,12,0,1,0,28,18Z"}),React.createElement("path",{d:"M19.63,22.13a2.84,2.84,0,0,1-1.28-.27,2.44,2.44,0,0,1-.89-.77,3.57,3.57,0,0,1-.52-1.25,7.69,7.69,0,0,1-.17-1.68,7.83,7.83,0,0,1,.17-1.68,3.65,3.65,0,0,1,.52-1.25,2.44,2.44,0,0,1,.89-.77,2.84,2.84,0,0,1,1.28-.27,2.44,2.44,0,0,1,2.16,1,5.23,5.23,0,0,1,.7,2.93,5.23,5.23,0,0,1-.7,2.93A2.44,2.44,0,0,1,19.63,22.13Zm0-1.22a1.07,1.07,0,0,0,1-.55A3.38,3.38,0,0,0,21,18.85V17.47a3.31,3.31,0,0,0-.29-1.5,1.23,1.23,0,0,0-2.06,0,3.31,3.31,0,0,0-.29,1.5v1.38a3.38,3.38,0,0,0,.29,1.51A1.06,1.06,0,0,0,19.63,20.91Z"}),React.createElement("path",{d:"M10.63,22V20.82h2V15.63l-1.86,1-.55-1.06,2.32-1.3H14v6.5h1.78V22Z"}),props.children);});var Forward_1020=/*#__PURE__*/React.forwardRef(function Forward_1020(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18A10,10,0,1,1,16,8h4v5l6-6L20,1V6H16A12,12,0,1,0,28,18Z"}),React.createElement("path",{d:"M19.63,22.13a2.84,2.84,0,0,1-1.28-.27,2.44,2.44,0,0,1-.89-.77,3.57,3.57,0,0,1-.52-1.25,7.69,7.69,0,0,1-.17-1.68,7.83,7.83,0,0,1,.17-1.68,3.65,3.65,0,0,1,.52-1.25,2.44,2.44,0,0,1,.89-.77,2.84,2.84,0,0,1,1.28-.27,2.44,2.44,0,0,1,2.16,1,5.23,5.23,0,0,1,.7,2.93,5.23,5.23,0,0,1-.7,2.93A2.44,2.44,0,0,1,19.63,22.13Zm0-1.22a1.07,1.07,0,0,0,1-.55A3.38,3.38,0,0,0,21,18.85V17.47a3.31,3.31,0,0,0-.29-1.5,1.23,1.23,0,0,0-2.06,0,3.31,3.31,0,0,0-.29,1.5v1.38a3.38,3.38,0,0,0,.29,1.51A1.06,1.06,0,0,0,19.63,20.91Z"}),React.createElement("path",{d:"M10.63,22V20.82h2V15.63l-1.86,1-.55-1.06,2.32-1.3H14v6.5h1.78V22Z"}),props.children);});var Forward_1016=/*#__PURE__*/React.forwardRef(function Forward_1016(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18A10,10,0,1,1,16,8h4v5l6-6L20,1V6H16A12,12,0,1,0,28,18Z"}),React.createElement("path",{d:"M19.63,22.13a2.84,2.84,0,0,1-1.28-.27,2.44,2.44,0,0,1-.89-.77,3.57,3.57,0,0,1-.52-1.25,7.69,7.69,0,0,1-.17-1.68,7.83,7.83,0,0,1,.17-1.68,3.65,3.65,0,0,1,.52-1.25,2.44,2.44,0,0,1,.89-.77,2.84,2.84,0,0,1,1.28-.27,2.44,2.44,0,0,1,2.16,1,5.23,5.23,0,0,1,.7,2.93,5.23,5.23,0,0,1-.7,2.93A2.44,2.44,0,0,1,19.63,22.13Zm0-1.22a1.07,1.07,0,0,0,1-.55A3.38,3.38,0,0,0,21,18.85V17.47a3.31,3.31,0,0,0-.29-1.5,1.23,1.23,0,0,0-2.06,0,3.31,3.31,0,0,0-.29,1.5v1.38a3.38,3.38,0,0,0,.29,1.51A1.06,1.06,0,0,0,19.63,20.91Z"}),React.createElement("path",{d:"M10.63,22V20.82h2V15.63l-1.86,1-.55-1.06,2.32-1.3H14v6.5h1.78V22Z"}),props.children);});var Forward_3032=/*#__PURE__*/React.forwardRef(function Forward_3032(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18A10,10,0,1,1,16,8h4v5l6-6L20,1V6H16A12,12,0,1,0,28,18Z"}),React.createElement("path",{d:"M19.64,22.13a2.81,2.81,0,0,1-1.28-.27,2.36,2.36,0,0,1-.89-.77A3.39,3.39,0,0,1,17,19.84a7.12,7.12,0,0,1-.17-1.68A7.24,7.24,0,0,1,17,16.48a3.46,3.46,0,0,1,.52-1.25,2.36,2.36,0,0,1,.89-.77,2.81,2.81,0,0,1,1.28-.27,2.44,2.44,0,0,1,2.16,1,5.31,5.31,0,0,1,.7,2.93,5.31,5.31,0,0,1-.7,2.93A2.44,2.44,0,0,1,19.64,22.13Zm0-1.22a1,1,0,0,0,1-.55,3.24,3.24,0,0,0,.3-1.51V17.47a3.17,3.17,0,0,0-.3-1.5,1.22,1.22,0,0,0-2.05,0,3.18,3.18,0,0,0-.29,1.5v1.38a3.25,3.25,0,0,0,.29,1.51A1,1,0,0,0,19.64,20.91Z"}),React.createElement("path",{d:"M12.62,17.42a1.46,1.46,0,0,0,1-.27.84.84,0,0,0,.31-.68v-.08a.94.94,0,0,0-.3-.74,1.2,1.2,0,0,0-.83-.27,1.65,1.65,0,0,0-.89.24,2.1,2.1,0,0,0-.68.68l-.93-.83a5.37,5.37,0,0,1,.44-.51,2.7,2.7,0,0,1,.54-.4,2.55,2.55,0,0,1,.7-.27,3.25,3.25,0,0,1,.87-.1,3.94,3.94,0,0,1,1.06.14,2.33,2.33,0,0,1,.82.4,1.91,1.91,0,0,1,.54.63,1.87,1.87,0,0,1,.18.83,2,2,0,0,1-.11.67,1.82,1.82,0,0,1-.32.52,1.79,1.79,0,0,1-.47.36,2.27,2.27,0,0,1-.57.2V18a2.34,2.34,0,0,1,.63.21,1.7,1.7,0,0,1,.51.38,1.89,1.89,0,0,1,.34.55,2.07,2.07,0,0,1,.12.73,2,2,0,0,1-.2.92,2,2,0,0,1-.58.72,2.66,2.66,0,0,1-.89.45,3.76,3.76,0,0,1-1.15.16,4.1,4.1,0,0,1-1-.11A3.1,3.1,0,0,1,11,21.7a2.76,2.76,0,0,1-.56-.45A4.22,4.22,0,0,1,10,20.7l1.07-.81a3.07,3.07,0,0,0,.28.42,1.94,1.94,0,0,0,.36.34,1.57,1.57,0,0,0,.45.22,2,2,0,0,0,.57.07,1.45,1.45,0,0,0,1-.3,1.12,1.12,0,0,0,.34-.85v-.08a1,1,0,0,0-.37-.8,1.78,1.78,0,0,0-1.06-.28h-.76V17.42Z"}),props.children);});var Forward_3024=/*#__PURE__*/React.forwardRef(function Forward_3024(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18A10,10,0,1,1,16,8h4v5l6-6L20,1V6H16A12,12,0,1,0,28,18Z"}),React.createElement("path",{d:"M19.64,22.13a2.81,2.81,0,0,1-1.28-.27,2.36,2.36,0,0,1-.89-.77A3.39,3.39,0,0,1,17,19.84a7.12,7.12,0,0,1-.17-1.68A7.24,7.24,0,0,1,17,16.48a3.46,3.46,0,0,1,.52-1.25,2.36,2.36,0,0,1,.89-.77,2.81,2.81,0,0,1,1.28-.27,2.44,2.44,0,0,1,2.16,1,5.31,5.31,0,0,1,.7,2.93,5.31,5.31,0,0,1-.7,2.93A2.44,2.44,0,0,1,19.64,22.13Zm0-1.22a1,1,0,0,0,1-.55,3.24,3.24,0,0,0,.3-1.51V17.47a3.17,3.17,0,0,0-.3-1.5,1.22,1.22,0,0,0-2.05,0,3.18,3.18,0,0,0-.29,1.5v1.38a3.25,3.25,0,0,0,.29,1.51A1,1,0,0,0,19.64,20.91Z"}),React.createElement("path",{d:"M12.62,17.42a1.46,1.46,0,0,0,1-.27.84.84,0,0,0,.31-.68v-.08a.94.94,0,0,0-.3-.74,1.2,1.2,0,0,0-.83-.27,1.65,1.65,0,0,0-.89.24,2.1,2.1,0,0,0-.68.68l-.93-.83a5.37,5.37,0,0,1,.44-.51,2.7,2.7,0,0,1,.54-.4,2.55,2.55,0,0,1,.7-.27,3.25,3.25,0,0,1,.87-.1,3.94,3.94,0,0,1,1.06.14,2.33,2.33,0,0,1,.82.4,1.91,1.91,0,0,1,.54.63,1.87,1.87,0,0,1,.18.83,2,2,0,0,1-.11.67,1.82,1.82,0,0,1-.32.52,1.79,1.79,0,0,1-.47.36,2.27,2.27,0,0,1-.57.2V18a2.34,2.34,0,0,1,.63.21,1.7,1.7,0,0,1,.51.38,1.89,1.89,0,0,1,.34.55,2.07,2.07,0,0,1,.12.73,2,2,0,0,1-.2.92,2,2,0,0,1-.58.72,2.66,2.66,0,0,1-.89.45,3.76,3.76,0,0,1-1.15.16,4.1,4.1,0,0,1-1-.11A3.1,3.1,0,0,1,11,21.7a2.76,2.76,0,0,1-.56-.45A4.22,4.22,0,0,1,10,20.7l1.07-.81a3.07,3.07,0,0,0,.28.42,1.94,1.94,0,0,0,.36.34,1.57,1.57,0,0,0,.45.22,2,2,0,0,0,.57.07,1.45,1.45,0,0,0,1-.3,1.12,1.12,0,0,0,.34-.85v-.08a1,1,0,0,0-.37-.8,1.78,1.78,0,0,0-1.06-.28h-.76V17.42Z"}),props.children);});var Forward_3020=/*#__PURE__*/React.forwardRef(function Forward_3020(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18A10,10,0,1,1,16,8h4v5l6-6L20,1V6H16A12,12,0,1,0,28,18Z"}),React.createElement("path",{d:"M19.64,22.13a2.81,2.81,0,0,1-1.28-.27,2.36,2.36,0,0,1-.89-.77A3.39,3.39,0,0,1,17,19.84a7.12,7.12,0,0,1-.17-1.68A7.24,7.24,0,0,1,17,16.48a3.46,3.46,0,0,1,.52-1.25,2.36,2.36,0,0,1,.89-.77,2.81,2.81,0,0,1,1.28-.27,2.44,2.44,0,0,1,2.16,1,5.31,5.31,0,0,1,.7,2.93,5.31,5.31,0,0,1-.7,2.93A2.44,2.44,0,0,1,19.64,22.13Zm0-1.22a1,1,0,0,0,1-.55,3.24,3.24,0,0,0,.3-1.51V17.47a3.17,3.17,0,0,0-.3-1.5,1.22,1.22,0,0,0-2.05,0,3.18,3.18,0,0,0-.29,1.5v1.38a3.25,3.25,0,0,0,.29,1.51A1,1,0,0,0,19.64,20.91Z"}),React.createElement("path",{d:"M12.62,17.42a1.46,1.46,0,0,0,1-.27.84.84,0,0,0,.31-.68v-.08a.94.94,0,0,0-.3-.74,1.2,1.2,0,0,0-.83-.27,1.65,1.65,0,0,0-.89.24,2.1,2.1,0,0,0-.68.68l-.93-.83a5.37,5.37,0,0,1,.44-.51,2.7,2.7,0,0,1,.54-.4,2.55,2.55,0,0,1,.7-.27,3.25,3.25,0,0,1,.87-.1,3.94,3.94,0,0,1,1.06.14,2.33,2.33,0,0,1,.82.4,1.91,1.91,0,0,1,.54.63,1.87,1.87,0,0,1,.18.83,2,2,0,0,1-.11.67,1.82,1.82,0,0,1-.32.52,1.79,1.79,0,0,1-.47.36,2.27,2.27,0,0,1-.57.2V18a2.34,2.34,0,0,1,.63.21,1.7,1.7,0,0,1,.51.38,1.89,1.89,0,0,1,.34.55,2.07,2.07,0,0,1,.12.73,2,2,0,0,1-.2.92,2,2,0,0,1-.58.72,2.66,2.66,0,0,1-.89.45,3.76,3.76,0,0,1-1.15.16,4.1,4.1,0,0,1-1-.11A3.1,3.1,0,0,1,11,21.7a2.76,2.76,0,0,1-.56-.45A4.22,4.22,0,0,1,10,20.7l1.07-.81a3.07,3.07,0,0,0,.28.42,1.94,1.94,0,0,0,.36.34,1.57,1.57,0,0,0,.45.22,2,2,0,0,0,.57.07,1.45,1.45,0,0,0,1-.3,1.12,1.12,0,0,0,.34-.85v-.08a1,1,0,0,0-.37-.8,1.78,1.78,0,0,0-1.06-.28h-.76V17.42Z"}),props.children);});var Forward_3016=/*#__PURE__*/React.forwardRef(function Forward_3016(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18A10,10,0,1,1,16,8h4v5l6-6L20,1V6H16A12,12,0,1,0,28,18Z"}),React.createElement("path",{d:"M19.64,22.13a2.81,2.81,0,0,1-1.28-.27,2.36,2.36,0,0,1-.89-.77A3.39,3.39,0,0,1,17,19.84a7.12,7.12,0,0,1-.17-1.68A7.24,7.24,0,0,1,17,16.48a3.46,3.46,0,0,1,.52-1.25,2.36,2.36,0,0,1,.89-.77,2.81,2.81,0,0,1,1.28-.27,2.44,2.44,0,0,1,2.16,1,5.31,5.31,0,0,1,.7,2.93,5.31,5.31,0,0,1-.7,2.93A2.44,2.44,0,0,1,19.64,22.13Zm0-1.22a1,1,0,0,0,1-.55,3.24,3.24,0,0,0,.3-1.51V17.47a3.17,3.17,0,0,0-.3-1.5,1.22,1.22,0,0,0-2.05,0,3.18,3.18,0,0,0-.29,1.5v1.38a3.25,3.25,0,0,0,.29,1.51A1,1,0,0,0,19.64,20.91Z"}),React.createElement("path",{d:"M12.62,17.42a1.46,1.46,0,0,0,1-.27.84.84,0,0,0,.31-.68v-.08a.94.94,0,0,0-.3-.74,1.2,1.2,0,0,0-.83-.27,1.65,1.65,0,0,0-.89.24,2.1,2.1,0,0,0-.68.68l-.93-.83a5.37,5.37,0,0,1,.44-.51,2.7,2.7,0,0,1,.54-.4,2.55,2.55,0,0,1,.7-.27,3.25,3.25,0,0,1,.87-.1,3.94,3.94,0,0,1,1.06.14,2.33,2.33,0,0,1,.82.4,1.91,1.91,0,0,1,.54.63,1.87,1.87,0,0,1,.18.83,2,2,0,0,1-.11.67,1.82,1.82,0,0,1-.32.52,1.79,1.79,0,0,1-.47.36,2.27,2.27,0,0,1-.57.2V18a2.34,2.34,0,0,1,.63.21,1.7,1.7,0,0,1,.51.38,1.89,1.89,0,0,1,.34.55,2.07,2.07,0,0,1,.12.73,2,2,0,0,1-.2.92,2,2,0,0,1-.58.72,2.66,2.66,0,0,1-.89.45,3.76,3.76,0,0,1-1.15.16,4.1,4.1,0,0,1-1-.11A3.1,3.1,0,0,1,11,21.7a2.76,2.76,0,0,1-.56-.45A4.22,4.22,0,0,1,10,20.7l1.07-.81a3.07,3.07,0,0,0,.28.42,1.94,1.94,0,0,0,.36.34,1.57,1.57,0,0,0,.45.22,2,2,0,0,0,.57.07,1.45,1.45,0,0,0,1-.3,1.12,1.12,0,0,0,.34-.85v-.08a1,1,0,0,0-.37-.8,1.78,1.78,0,0,0-1.06-.28h-.76V17.42Z"}),props.children);});var Forward_532=/*#__PURE__*/React.forwardRef(function Forward_532(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18A10,10,0,1,1,16,8h4v5l6-6L20,1V6H16A12,12,0,1,0,28,18Z"}),React.createElement("path",{d:"M18.58,15.58H15.13L15,18.15H15a4.83,4.83,0,0,1,.26-.45,1.59,1.59,0,0,1,.33-.35,1.53,1.53,0,0,1,.44-.23,2,2,0,0,1,.6-.08,2.54,2.54,0,0,1,.92.16,2.06,2.06,0,0,1,.74.48,2.28,2.28,0,0,1,.5.77,2.73,2.73,0,0,1,.18,1,2.87,2.87,0,0,1-.19,1.07,2.36,2.36,0,0,1-.55.84,2.44,2.44,0,0,1-.89.55,3.23,3.23,0,0,1-1.21.2,3.79,3.79,0,0,1-.94-.11,3,3,0,0,1-.74-.32,2.45,2.45,0,0,1-.55-.45,4.13,4.13,0,0,1-.41-.55l1.06-.81.27.41a1.82,1.82,0,0,0,.34.34,1.59,1.59,0,0,0,.43.22,1.52,1.52,0,0,0,.55.08,1.29,1.29,0,0,0,1-.36,1.41,1.41,0,0,0,.33-1V19.5a1.18,1.18,0,0,0-1.28-1.27,1.44,1.44,0,0,0-.77.18,1.94,1.94,0,0,0-.48.39l-1.19-.17.29-4.31h4.52Z"}),props.children);});var Forward_524=/*#__PURE__*/React.forwardRef(function Forward_524(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18A10,10,0,1,1,16,8h4v5l6-6L20,1V6H16A12,12,0,1,0,28,18Z"}),React.createElement("path",{d:"M18.58,15.58H15.13L15,18.15H15a4.83,4.83,0,0,1,.26-.45,1.59,1.59,0,0,1,.33-.35,1.53,1.53,0,0,1,.44-.23,2,2,0,0,1,.6-.08,2.54,2.54,0,0,1,.92.16,2.06,2.06,0,0,1,.74.48,2.28,2.28,0,0,1,.5.77,2.73,2.73,0,0,1,.18,1,2.87,2.87,0,0,1-.19,1.07,2.36,2.36,0,0,1-.55.84,2.44,2.44,0,0,1-.89.55,3.23,3.23,0,0,1-1.21.2,3.79,3.79,0,0,1-.94-.11,3,3,0,0,1-.74-.32,2.45,2.45,0,0,1-.55-.45,4.13,4.13,0,0,1-.41-.55l1.06-.81.27.41a1.82,1.82,0,0,0,.34.34,1.59,1.59,0,0,0,.43.22,1.52,1.52,0,0,0,.55.08,1.29,1.29,0,0,0,1-.36,1.41,1.41,0,0,0,.33-1V19.5a1.18,1.18,0,0,0-1.28-1.27,1.44,1.44,0,0,0-.77.18,1.94,1.94,0,0,0-.48.39l-1.19-.17.29-4.31h4.52Z"}),props.children);});var Forward_520=/*#__PURE__*/React.forwardRef(function Forward_520(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18A10,10,0,1,1,16,8h4v5l6-6L20,1V6H16A12,12,0,1,0,28,18Z"}),React.createElement("path",{d:"M18.58,15.58H15.13L15,18.15H15a4.83,4.83,0,0,1,.26-.45,1.59,1.59,0,0,1,.33-.35,1.53,1.53,0,0,1,.44-.23,2,2,0,0,1,.6-.08,2.54,2.54,0,0,1,.92.16,2.06,2.06,0,0,1,.74.48,2.28,2.28,0,0,1,.5.77,2.73,2.73,0,0,1,.18,1,2.87,2.87,0,0,1-.19,1.07,2.36,2.36,0,0,1-.55.84,2.44,2.44,0,0,1-.89.55,3.23,3.23,0,0,1-1.21.2,3.79,3.79,0,0,1-.94-.11,3,3,0,0,1-.74-.32,2.45,2.45,0,0,1-.55-.45,4.13,4.13,0,0,1-.41-.55l1.06-.81.27.41a1.82,1.82,0,0,0,.34.34,1.59,1.59,0,0,0,.43.22,1.52,1.52,0,0,0,.55.08,1.29,1.29,0,0,0,1-.36,1.41,1.41,0,0,0,.33-1V19.5a1.18,1.18,0,0,0-1.28-1.27,1.44,1.44,0,0,0-.77.18,1.94,1.94,0,0,0-.48.39l-1.19-.17.29-4.31h4.52Z"}),props.children);});var Forward_516=/*#__PURE__*/React.forwardRef(function Forward_516(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,18A10,10,0,1,1,16,8h4v5l6-6L20,1V6H16A12,12,0,1,0,28,18Z"}),React.createElement("path",{d:"M18.58,15.58H15.13L15,18.15H15a4.83,4.83,0,0,1,.26-.45,1.59,1.59,0,0,1,.33-.35,1.53,1.53,0,0,1,.44-.23,2,2,0,0,1,.6-.08,2.54,2.54,0,0,1,.92.16,2.06,2.06,0,0,1,.74.48,2.28,2.28,0,0,1,.5.77,2.73,2.73,0,0,1,.18,1,2.87,2.87,0,0,1-.19,1.07,2.36,2.36,0,0,1-.55.84,2.44,2.44,0,0,1-.89.55,3.23,3.23,0,0,1-1.21.2,3.79,3.79,0,0,1-.94-.11,3,3,0,0,1-.74-.32,2.45,2.45,0,0,1-.55-.45,4.13,4.13,0,0,1-.41-.55l1.06-.81.27.41a1.82,1.82,0,0,0,.34.34,1.59,1.59,0,0,0,.43.22,1.52,1.52,0,0,0,.55.08,1.29,1.29,0,0,0,1-.36,1.41,1.41,0,0,0,.33-1V19.5a1.18,1.18,0,0,0-1.28-1.27,1.44,1.44,0,0,0-.77.18,1.94,1.94,0,0,0-.48.39l-1.19-.17.29-4.31h4.52Z"}),props.children);});var FruitBowl32=/*#__PURE__*/React.forwardRef(function FruitBowl32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,15a6.0025,6.0025,0,0,0-3.1067-5.2529A3.9792,3.9792,0,0,0,24,7H22a2.0023,2.0023,0,0,1-2,2,6.004,6.004,0,0,0-5.9946,5.8921A7.0005,7.0005,0,0,1,12,10,3.9961,3.9961,0,0,0,9,6.1419V4H7V6.1419A3.9961,3.9961,0,0,0,4,10v5H2v1a14,14,0,0,0,28,0V15Zm-6-4a4.0045,4.0045,0,0,1,4,4H16A4.0045,4.0045,0,0,1,20,11ZM6,10a2,2,0,1,1,4,0,8.991,8.991,0,0,0,1.5322,5H6ZM16,28A12.0166,12.0166,0,0,1,4.0415,17h23.917A12.0166,12.0166,0,0,1,16,28Z"}),props.children);});var FruitBowl24=/*#__PURE__*/React.forwardRef(function FruitBowl24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,15a6.0025,6.0025,0,0,0-3.1067-5.2529A3.9792,3.9792,0,0,0,24,7H22a2.0023,2.0023,0,0,1-2,2,6.004,6.004,0,0,0-5.9946,5.8921A7.0005,7.0005,0,0,1,12,10,3.9961,3.9961,0,0,0,9,6.1419V4H7V6.1419A3.9961,3.9961,0,0,0,4,10v5H2v1a14,14,0,0,0,28,0V15Zm-6-4a4.0045,4.0045,0,0,1,4,4H16A4.0045,4.0045,0,0,1,20,11ZM6,10a2,2,0,1,1,4,0,8.991,8.991,0,0,0,1.5322,5H6ZM16,28A12.0166,12.0166,0,0,1,4.0415,17h23.917A12.0166,12.0166,0,0,1,16,28Z"}),props.children);});var FruitBowl20=/*#__PURE__*/React.forwardRef(function FruitBowl20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,15a6.0025,6.0025,0,0,0-3.1067-5.2529A3.9792,3.9792,0,0,0,24,7H22a2.0023,2.0023,0,0,1-2,2,6.004,6.004,0,0,0-5.9946,5.8921A7.0005,7.0005,0,0,1,12,10,3.9961,3.9961,0,0,0,9,6.1419V4H7V6.1419A3.9961,3.9961,0,0,0,4,10v5H2v1a14,14,0,0,0,28,0V15Zm-6-4a4.0045,4.0045,0,0,1,4,4H16A4.0045,4.0045,0,0,1,20,11ZM6,10a2,2,0,1,1,4,0,8.991,8.991,0,0,0,1.5322,5H6ZM16,28A12.0166,12.0166,0,0,1,4.0415,17h23.917A12.0166,12.0166,0,0,1,16,28Z"}),props.children);});var FruitBowl16=/*#__PURE__*/React.forwardRef(function FruitBowl16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,15a6.0025,6.0025,0,0,0-3.1067-5.2529A3.9792,3.9792,0,0,0,24,7H22a2.0023,2.0023,0,0,1-2,2,6.004,6.004,0,0,0-5.9946,5.8921A7.0005,7.0005,0,0,1,12,10,3.9961,3.9961,0,0,0,9,6.1419V4H7V6.1419A3.9961,3.9961,0,0,0,4,10v5H2v1a14,14,0,0,0,28,0V15Zm-6-4a4.0045,4.0045,0,0,1,4,4H16A4.0045,4.0045,0,0,1,20,11ZM6,10a2,2,0,1,1,4,0,8.991,8.991,0,0,0,1.5322,5H6ZM16,28A12.0166,12.0166,0,0,1,4.0415,17h23.917A12.0166,12.0166,0,0,1,16,28Z"}),props.children);});var Function32=/*#__PURE__*/React.forwardRef(function Function32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.5,30a2.5,2.5,0,0,1,0-5c.63-.07,2.35-1.53,2.49-7.22l-1.78-.45a2.92,2.92,0,0,1,0-5.66L11,11.21C11.55,4,19.32,2,23.5,2a2.5,2.5,0,0,1,0,5c-.08,0-2.23.15-2.48,4.22l1.77.45a2.92,2.92,0,0,1,0,5.66L21,17.79C20.49,29.86,8.62,30,8.5,30Zm15-26C23.07,4,13,4.11,13,12v.78l-3.3.83a.92.92,0,0,0,0,1.78l3.3.83V17c0,9.72-4,10-4.5,10a.5.5,0,0,0,0,1C8.93,28,19,27.83,19,17v-.78l3.3-.83a.92.92,0,0,0,0-1.78L19,12.78V12c0-6.92,4.46-7,4.5-7a.5.5,0,0,0,0-1Z"}),React.createElement("path",{d:"M4.15,23.46A14,14,0,0,1,10.61,3.08l.77,1.84A12,12,0,0,0,5.85,22.4Z"}),React.createElement("path",{d:"M21.39,28.92l-.77-1.84A12,12,0,0,0,26.11,9.54L27.8,8.46a14,14,0,0,1-6.41,20.46Z"}),props.children);});var Function24=/*#__PURE__*/React.forwardRef(function Function24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.5,30a2.5,2.5,0,0,1,0-5c.63-.07,2.35-1.53,2.49-7.22l-1.78-.45a2.92,2.92,0,0,1,0-5.66L11,11.21C11.55,4,19.32,2,23.5,2a2.5,2.5,0,0,1,0,5c-.08,0-2.23.15-2.48,4.22l1.77.45a2.92,2.92,0,0,1,0,5.66L21,17.79C20.49,29.86,8.62,30,8.5,30Zm15-26C23.07,4,13,4.11,13,12v.78l-3.3.83a.92.92,0,0,0,0,1.78l3.3.83V17c0,9.72-4,10-4.5,10a.5.5,0,0,0,0,1C8.93,28,19,27.83,19,17v-.78l3.3-.83a.92.92,0,0,0,0-1.78L19,12.78V12c0-6.92,4.46-7,4.5-7a.5.5,0,0,0,0-1Z"}),React.createElement("path",{d:"M4.15,23.46A14,14,0,0,1,10.61,3.08l.77,1.84A12,12,0,0,0,5.85,22.4Z"}),React.createElement("path",{d:"M21.39,28.92l-.77-1.84A12,12,0,0,0,26.11,9.54L27.8,8.46a14,14,0,0,1-6.41,20.46Z"}),props.children);});var Function20=/*#__PURE__*/React.forwardRef(function Function20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.5,30a2.5,2.5,0,0,1,0-5c.63-.07,2.35-1.53,2.49-7.22l-1.78-.45a2.92,2.92,0,0,1,0-5.66L11,11.21C11.55,4,19.32,2,23.5,2a2.5,2.5,0,0,1,0,5c-.08,0-2.23.15-2.48,4.22l1.77.45a2.92,2.92,0,0,1,0,5.66L21,17.79C20.49,29.86,8.62,30,8.5,30Zm15-26C23.07,4,13,4.11,13,12v.78l-3.3.83a.92.92,0,0,0,0,1.78l3.3.83V17c0,9.72-4,10-4.5,10a.5.5,0,0,0,0,1C8.93,28,19,27.83,19,17v-.78l3.3-.83a.92.92,0,0,0,0-1.78L19,12.78V12c0-6.92,4.46-7,4.5-7a.5.5,0,0,0,0-1Z"}),React.createElement("path",{d:"M4.15,23.46A14,14,0,0,1,10.61,3.08l.77,1.84A12,12,0,0,0,5.85,22.4Z"}),React.createElement("path",{d:"M21.39,28.92l-.77-1.84A12,12,0,0,0,26.11,9.54L27.8,8.46a14,14,0,0,1-6.41,20.46Z"}),props.children);});var Function16=/*#__PURE__*/React.forwardRef(function Function16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M8.5,30a2.5,2.5,0,0,1,0-5c.63-.07,2.35-1.53,2.49-7.22l-1.78-.45a2.92,2.92,0,0,1,0-5.66L11,11.21C11.55,4,19.32,2,23.5,2a2.5,2.5,0,0,1,0,5c-.08,0-2.23.15-2.48,4.22l1.77.45a2.92,2.92,0,0,1,0,5.66L21,17.79C20.49,29.86,8.62,30,8.5,30Zm15-26C23.07,4,13,4.11,13,12v.78l-3.3.83a.92.92,0,0,0,0,1.78l3.3.83V17c0,9.72-4,10-4.5,10a.5.5,0,0,0,0,1C8.93,28,19,27.83,19,17v-.78l3.3-.83a.92.92,0,0,0,0-1.78L19,12.78V12c0-6.92,4.46-7,4.5-7a.5.5,0,0,0,0-1Z"}),React.createElement("path",{d:"M4.15,23.46A14,14,0,0,1,10.61,3.08l.77,1.84A12,12,0,0,0,5.85,22.4Z"}),React.createElement("path",{d:"M21.39,28.92l-.77-1.84A12,12,0,0,0,26.11,9.54L27.8,8.46a14,14,0,0,1-6.41,20.46Z"}),props.children);});var GameConsole32=/*#__PURE__*/React.forwardRef(function GameConsole32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51,26a5.48,5.48,0,0,1-1.44-.19A5.6,5.6,0,0,1,2.19,19l2.33-8.84A5.54,5.54,0,0,1,7.11,6.73a5.43,5.43,0,0,1,4.15-.54A5.52,5.52,0,0,1,14.7,9h2.6a5.49,5.49,0,0,1,3.44-2.81,5.43,5.43,0,0,1,4.15.54,5.57,5.57,0,0,1,2.59,3.41L29.81,19a5.6,5.6,0,0,1-3.89,6.83,5.43,5.43,0,0,1-4.15-.54,5.54,5.54,0,0,1-2.59-3.41L19,21H13l-.23.86a5.54,5.54,0,0,1-2.59,3.41A5.46,5.46,0,0,1,7.51,26ZM9.83,8a3.49,3.49,0,0,0-1.72.46,3.6,3.6,0,0,0-1.66,2.19L4.12,19.49A3.6,3.6,0,0,0,6.6,23.88a3.43,3.43,0,0,0,2.62-.34,3.54,3.54,0,0,0,1.66-2.19L11.5,19h9l.61,2.35a3.58,3.58,0,0,0,1.66,2.19,3.46,3.46,0,0,0,2.63.34,3.58,3.58,0,0,0,2.47-4.39l-2.33-8.84a3.55,3.55,0,0,0-1.65-2.19,3.46,3.46,0,0,0-2.63-.34,3.55,3.55,0,0,0-2.37,2.22l-.24.66h-5.3l-.24-.66a3.56,3.56,0,0,0-2.38-2.22A3.48,3.48,0,0,0,9.83,8Z"}),React.createElement("path",{d:"M10,16a2,2,0,1,1,2-2A2,2,0,0,1,10,16Zm0-2Z"}),React.createElement("circle",{cx:"22",cy:"12",r:"1"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"20",cy:"14",r:"1"}),React.createElement("circle",{cx:"24",cy:"14",r:"1"}),props.children);});var GameConsole24=/*#__PURE__*/React.forwardRef(function GameConsole24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51,26a5.48,5.48,0,0,1-1.44-.19A5.6,5.6,0,0,1,2.19,19l2.33-8.84A5.54,5.54,0,0,1,7.11,6.73a5.43,5.43,0,0,1,4.15-.54A5.52,5.52,0,0,1,14.7,9h2.6a5.49,5.49,0,0,1,3.44-2.81,5.43,5.43,0,0,1,4.15.54,5.57,5.57,0,0,1,2.59,3.41L29.81,19a5.6,5.6,0,0,1-3.89,6.83,5.43,5.43,0,0,1-4.15-.54,5.54,5.54,0,0,1-2.59-3.41L19,21H13l-.23.86a5.54,5.54,0,0,1-2.59,3.41A5.46,5.46,0,0,1,7.51,26ZM9.83,8a3.49,3.49,0,0,0-1.72.46,3.6,3.6,0,0,0-1.66,2.19L4.12,19.49A3.6,3.6,0,0,0,6.6,23.88a3.43,3.43,0,0,0,2.62-.34,3.54,3.54,0,0,0,1.66-2.19L11.5,19h9l.61,2.35a3.58,3.58,0,0,0,1.66,2.19,3.46,3.46,0,0,0,2.63.34,3.58,3.58,0,0,0,2.47-4.39l-2.33-8.84a3.55,3.55,0,0,0-1.65-2.19,3.46,3.46,0,0,0-2.63-.34,3.55,3.55,0,0,0-2.37,2.22l-.24.66h-5.3l-.24-.66a3.56,3.56,0,0,0-2.38-2.22A3.48,3.48,0,0,0,9.83,8Z"}),React.createElement("path",{d:"M10,16a2,2,0,1,1,2-2A2,2,0,0,1,10,16Zm0-2Z"}),React.createElement("circle",{cx:"22",cy:"12",r:"1"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"20",cy:"14",r:"1"}),React.createElement("circle",{cx:"24",cy:"14",r:"1"}),props.children);});var GameConsole20=/*#__PURE__*/React.forwardRef(function GameConsole20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51,26a5.48,5.48,0,0,1-1.44-.19A5.6,5.6,0,0,1,2.19,19l2.33-8.84A5.54,5.54,0,0,1,7.11,6.73a5.43,5.43,0,0,1,4.15-.54A5.52,5.52,0,0,1,14.7,9h2.6a5.49,5.49,0,0,1,3.44-2.81,5.43,5.43,0,0,1,4.15.54,5.57,5.57,0,0,1,2.59,3.41L29.81,19a5.6,5.6,0,0,1-3.89,6.83,5.43,5.43,0,0,1-4.15-.54,5.54,5.54,0,0,1-2.59-3.41L19,21H13l-.23.86a5.54,5.54,0,0,1-2.59,3.41A5.46,5.46,0,0,1,7.51,26ZM9.83,8a3.49,3.49,0,0,0-1.72.46,3.6,3.6,0,0,0-1.66,2.19L4.12,19.49A3.6,3.6,0,0,0,6.6,23.88a3.43,3.43,0,0,0,2.62-.34,3.54,3.54,0,0,0,1.66-2.19L11.5,19h9l.61,2.35a3.58,3.58,0,0,0,1.66,2.19,3.46,3.46,0,0,0,2.63.34,3.58,3.58,0,0,0,2.47-4.39l-2.33-8.84a3.55,3.55,0,0,0-1.65-2.19,3.46,3.46,0,0,0-2.63-.34,3.55,3.55,0,0,0-2.37,2.22l-.24.66h-5.3l-.24-.66a3.56,3.56,0,0,0-2.38-2.22A3.48,3.48,0,0,0,9.83,8Z"}),React.createElement("path",{d:"M10,16a2,2,0,1,1,2-2A2,2,0,0,1,10,16Zm0-2Z"}),React.createElement("circle",{cx:"22",cy:"12",r:"1"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"20",cy:"14",r:"1"}),React.createElement("circle",{cx:"24",cy:"14",r:"1"}),props.children);});var GameConsole16=/*#__PURE__*/React.forwardRef(function GameConsole16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51,26a5.48,5.48,0,0,1-1.44-.19A5.6,5.6,0,0,1,2.19,19l2.33-8.84A5.54,5.54,0,0,1,7.11,6.73a5.43,5.43,0,0,1,4.15-.54A5.52,5.52,0,0,1,14.7,9h2.6a5.49,5.49,0,0,1,3.44-2.81,5.43,5.43,0,0,1,4.15.54,5.57,5.57,0,0,1,2.59,3.41L29.81,19a5.6,5.6,0,0,1-3.89,6.83,5.43,5.43,0,0,1-4.15-.54,5.54,5.54,0,0,1-2.59-3.41L19,21H13l-.23.86a5.54,5.54,0,0,1-2.59,3.41A5.46,5.46,0,0,1,7.51,26ZM9.83,8a3.49,3.49,0,0,0-1.72.46,3.6,3.6,0,0,0-1.66,2.19L4.12,19.49A3.6,3.6,0,0,0,6.6,23.88a3.43,3.43,0,0,0,2.62-.34,3.54,3.54,0,0,0,1.66-2.19L11.5,19h9l.61,2.35a3.58,3.58,0,0,0,1.66,2.19,3.46,3.46,0,0,0,2.63.34,3.58,3.58,0,0,0,2.47-4.39l-2.33-8.84a3.55,3.55,0,0,0-1.65-2.19,3.46,3.46,0,0,0-2.63-.34,3.55,3.55,0,0,0-2.37,2.22l-.24.66h-5.3l-.24-.66a3.56,3.56,0,0,0-2.38-2.22A3.48,3.48,0,0,0,9.83,8Z"}),React.createElement("path",{d:"M10,16a2,2,0,1,1,2-2A2,2,0,0,1,10,16Zm0-2Z"}),React.createElement("circle",{cx:"22",cy:"12",r:"1"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"20",cy:"14",r:"1"}),React.createElement("circle",{cx:"24",cy:"14",r:"1"}),props.children);});var GameWireless32=/*#__PURE__*/React.forwardRef(function GameWireless32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51,30a5.48,5.48,0,0,1-1.44-.19A5.6,5.6,0,0,1,2.19,23l2.33-8.84a5.54,5.54,0,0,1,2.59-3.41,5.43,5.43,0,0,1,4.15-.54A5.52,5.52,0,0,1,14.7,13h2.6a5.49,5.49,0,0,1,3.44-2.81,5.43,5.43,0,0,1,4.15.54,5.55,5.55,0,0,1,2.59,3.41L29.81,23a5.6,5.6,0,0,1-3.89,6.83,5.43,5.43,0,0,1-4.15-.54,5.54,5.54,0,0,1-2.59-3.41L19,25H13l-.23.86a5.54,5.54,0,0,1-2.59,3.41A5.46,5.46,0,0,1,7.51,30ZM9.83,12a3.49,3.49,0,0,0-1.72.46,3.58,3.58,0,0,0-1.66,2.19L4.12,23.49A3.6,3.6,0,0,0,6.6,27.88a3.43,3.43,0,0,0,2.62-.34,3.57,3.57,0,0,0,1.66-2.19L11.5,23h9l.61,2.35a3.6,3.6,0,0,0,1.66,2.19,3.46,3.46,0,0,0,2.63.34,3.58,3.58,0,0,0,2.47-4.39l-2.33-8.84a3.53,3.53,0,0,0-1.65-2.19,3.46,3.46,0,0,0-2.63-.34,3.55,3.55,0,0,0-2.37,2.22l-.24.66h-5.3l-.24-.66a3.56,3.56,0,0,0-2.38-2.22A3.48,3.48,0,0,0,9.83,12Z"}),React.createElement("path",{d:"M10,20a2,2,0,1,1,2-2A2,2,0,0,1,10,20Zm0-2Z"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"22",cy:"20",r:"1"}),React.createElement("circle",{cx:"20",cy:"18",r:"1"}),React.createElement("circle",{cx:"24",cy:"18",r:"1"}),React.createElement("path",{d:"M13.75,9l-1.5-1.33a5,5,0,0,1,7.5,0L18.25,9a3,3,0,0,0-4.5,0Z"}),React.createElement("path",{d:"M21.25,6.37a7,7,0,0,0-10.5,0L9.25,5.05a9,9,0,0,1,13.5,0Z"}),props.children);});var GameWireless24=/*#__PURE__*/React.forwardRef(function GameWireless24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51,30a5.48,5.48,0,0,1-1.44-.19A5.6,5.6,0,0,1,2.19,23l2.33-8.84a5.54,5.54,0,0,1,2.59-3.41,5.43,5.43,0,0,1,4.15-.54A5.52,5.52,0,0,1,14.7,13h2.6a5.49,5.49,0,0,1,3.44-2.81,5.43,5.43,0,0,1,4.15.54,5.55,5.55,0,0,1,2.59,3.41L29.81,23a5.6,5.6,0,0,1-3.89,6.83,5.43,5.43,0,0,1-4.15-.54,5.54,5.54,0,0,1-2.59-3.41L19,25H13l-.23.86a5.54,5.54,0,0,1-2.59,3.41A5.46,5.46,0,0,1,7.51,30ZM9.83,12a3.49,3.49,0,0,0-1.72.46,3.58,3.58,0,0,0-1.66,2.19L4.12,23.49A3.6,3.6,0,0,0,6.6,27.88a3.43,3.43,0,0,0,2.62-.34,3.57,3.57,0,0,0,1.66-2.19L11.5,23h9l.61,2.35a3.6,3.6,0,0,0,1.66,2.19,3.46,3.46,0,0,0,2.63.34,3.58,3.58,0,0,0,2.47-4.39l-2.33-8.84a3.53,3.53,0,0,0-1.65-2.19,3.46,3.46,0,0,0-2.63-.34,3.55,3.55,0,0,0-2.37,2.22l-.24.66h-5.3l-.24-.66a3.56,3.56,0,0,0-2.38-2.22A3.48,3.48,0,0,0,9.83,12Z"}),React.createElement("path",{d:"M10,20a2,2,0,1,1,2-2A2,2,0,0,1,10,20Zm0-2Z"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"22",cy:"20",r:"1"}),React.createElement("circle",{cx:"20",cy:"18",r:"1"}),React.createElement("circle",{cx:"24",cy:"18",r:"1"}),React.createElement("path",{d:"M13.75,9l-1.5-1.33a5,5,0,0,1,7.5,0L18.25,9a3,3,0,0,0-4.5,0Z"}),React.createElement("path",{d:"M21.25,6.37a7,7,0,0,0-10.5,0L9.25,5.05a9,9,0,0,1,13.5,0Z"}),props.children);});var GameWireless20=/*#__PURE__*/React.forwardRef(function GameWireless20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51,30a5.48,5.48,0,0,1-1.44-.19A5.6,5.6,0,0,1,2.19,23l2.33-8.84a5.54,5.54,0,0,1,2.59-3.41,5.43,5.43,0,0,1,4.15-.54A5.52,5.52,0,0,1,14.7,13h2.6a5.49,5.49,0,0,1,3.44-2.81,5.43,5.43,0,0,1,4.15.54,5.55,5.55,0,0,1,2.59,3.41L29.81,23a5.6,5.6,0,0,1-3.89,6.83,5.43,5.43,0,0,1-4.15-.54,5.54,5.54,0,0,1-2.59-3.41L19,25H13l-.23.86a5.54,5.54,0,0,1-2.59,3.41A5.46,5.46,0,0,1,7.51,30ZM9.83,12a3.49,3.49,0,0,0-1.72.46,3.58,3.58,0,0,0-1.66,2.19L4.12,23.49A3.6,3.6,0,0,0,6.6,27.88a3.43,3.43,0,0,0,2.62-.34,3.57,3.57,0,0,0,1.66-2.19L11.5,23h9l.61,2.35a3.6,3.6,0,0,0,1.66,2.19,3.46,3.46,0,0,0,2.63.34,3.58,3.58,0,0,0,2.47-4.39l-2.33-8.84a3.53,3.53,0,0,0-1.65-2.19,3.46,3.46,0,0,0-2.63-.34,3.55,3.55,0,0,0-2.37,2.22l-.24.66h-5.3l-.24-.66a3.56,3.56,0,0,0-2.38-2.22A3.48,3.48,0,0,0,9.83,12Z"}),React.createElement("path",{d:"M10,20a2,2,0,1,1,2-2A2,2,0,0,1,10,20Zm0-2Z"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"22",cy:"20",r:"1"}),React.createElement("circle",{cx:"20",cy:"18",r:"1"}),React.createElement("circle",{cx:"24",cy:"18",r:"1"}),React.createElement("path",{d:"M13.75,9l-1.5-1.33a5,5,0,0,1,7.5,0L18.25,9a3,3,0,0,0-4.5,0Z"}),React.createElement("path",{d:"M21.25,6.37a7,7,0,0,0-10.5,0L9.25,5.05a9,9,0,0,1,13.5,0Z"}),props.children);});var GameWireless16=/*#__PURE__*/React.forwardRef(function GameWireless16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M7.51,30a5.48,5.48,0,0,1-1.44-.19A5.6,5.6,0,0,1,2.19,23l2.33-8.84a5.54,5.54,0,0,1,2.59-3.41,5.43,5.43,0,0,1,4.15-.54A5.52,5.52,0,0,1,14.7,13h2.6a5.49,5.49,0,0,1,3.44-2.81,5.43,5.43,0,0,1,4.15.54,5.55,5.55,0,0,1,2.59,3.41L29.81,23a5.6,5.6,0,0,1-3.89,6.83,5.43,5.43,0,0,1-4.15-.54,5.54,5.54,0,0,1-2.59-3.41L19,25H13l-.23.86a5.54,5.54,0,0,1-2.59,3.41A5.46,5.46,0,0,1,7.51,30ZM9.83,12a3.49,3.49,0,0,0-1.72.46,3.58,3.58,0,0,0-1.66,2.19L4.12,23.49A3.6,3.6,0,0,0,6.6,27.88a3.43,3.43,0,0,0,2.62-.34,3.57,3.57,0,0,0,1.66-2.19L11.5,23h9l.61,2.35a3.6,3.6,0,0,0,1.66,2.19,3.46,3.46,0,0,0,2.63.34,3.58,3.58,0,0,0,2.47-4.39l-2.33-8.84a3.53,3.53,0,0,0-1.65-2.19,3.46,3.46,0,0,0-2.63-.34,3.55,3.55,0,0,0-2.37,2.22l-.24.66h-5.3l-.24-.66a3.56,3.56,0,0,0-2.38-2.22A3.48,3.48,0,0,0,9.83,12Z"}),React.createElement("path",{d:"M10,20a2,2,0,1,1,2-2A2,2,0,0,1,10,20Zm0-2Z"}),React.createElement("circle",{cx:"22",cy:"16",r:"1"}),React.createElement("circle",{cx:"22",cy:"20",r:"1"}),React.createElement("circle",{cx:"20",cy:"18",r:"1"}),React.createElement("circle",{cx:"24",cy:"18",r:"1"}),React.createElement("path",{d:"M13.75,9l-1.5-1.33a5,5,0,0,1,7.5,0L18.25,9a3,3,0,0,0-4.5,0Z"}),React.createElement("path",{d:"M21.25,6.37a7,7,0,0,0-10.5,0L9.25,5.05a9,9,0,0,1,13.5,0Z"}),props.children);});var Gamification32=/*#__PURE__*/React.forwardRef(function Gamification32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,23h-.1315l.9635-1.4453A1.0008,1.0008,0,0,0,24,21V12.0005c0-9.8858-7.92-10-8-10A1,1,0,0,0,15,3l-.0005,2H14a.9956.9956,0,0,0-.581.1865l-7,5a1,1,0,0,0-.3676,1.13l1,3a.9976.9976,0,0,0,1.09.6733l4.87-.6958L9.1519,20.47a1,1,0,0,0,.0161,1.085L10.1315,23H10a3.0033,3.0033,0,0,0-3,3v4H26V26A3.0033,3.0033,0,0,0,23,23Zm-7.1519-9.47a1,1,0,0,0-.99-1.52l-6.1738.8819-.5025-1.5078L14.32,7.0005H15.999a1,1,0,0,0,1-.9995L17,4.1289C18.5013,4.4636,21.2167,5.67,21.86,10H19v2h3v2H19v2h3v2H19v2h3v.6973L20.4648,23h-7.93L11.19,20.9824ZM24,28H9V26a1.0009,1.0009,0,0,1,1-1H23a1.0006,1.0006,0,0,1,1,1Z"}),props.children);});var Gamification24=/*#__PURE__*/React.forwardRef(function Gamification24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,23h-.1315l.9635-1.4453A1.0008,1.0008,0,0,0,24,21V12.0005c0-9.8858-7.92-10-8-10A1,1,0,0,0,15,3l-.0005,2H14a.9956.9956,0,0,0-.581.1865l-7,5a1,1,0,0,0-.3676,1.13l1,3a.9976.9976,0,0,0,1.09.6733l4.87-.6958L9.1519,20.47a1,1,0,0,0,.0161,1.085L10.1315,23H10a3.0033,3.0033,0,0,0-3,3v4H26V26A3.0033,3.0033,0,0,0,23,23Zm-7.1519-9.47a1,1,0,0,0-.99-1.52l-6.1738.8819-.5025-1.5078L14.32,7.0005H15.999a1,1,0,0,0,1-.9995L17,4.1289C18.5013,4.4636,21.2167,5.67,21.86,10H19v2h3v2H19v2h3v2H19v2h3v.6973L20.4648,23h-7.93L11.19,20.9824ZM24,28H9V26a1.0009,1.0009,0,0,1,1-1H23a1.0006,1.0006,0,0,1,1,1Z"}),props.children);});var Gamification20=/*#__PURE__*/React.forwardRef(function Gamification20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,23h-.1315l.9635-1.4453A1.0008,1.0008,0,0,0,24,21V12.0005c0-9.8858-7.92-10-8-10A1,1,0,0,0,15,3l-.0005,2H14a.9956.9956,0,0,0-.581.1865l-7,5a1,1,0,0,0-.3676,1.13l1,3a.9976.9976,0,0,0,1.09.6733l4.87-.6958L9.1519,20.47a1,1,0,0,0,.0161,1.085L10.1315,23H10a3.0033,3.0033,0,0,0-3,3v4H26V26A3.0033,3.0033,0,0,0,23,23Zm-7.1519-9.47a1,1,0,0,0-.99-1.52l-6.1738.8819-.5025-1.5078L14.32,7.0005H15.999a1,1,0,0,0,1-.9995L17,4.1289C18.5013,4.4636,21.2167,5.67,21.86,10H19v2h3v2H19v2h3v2H19v2h3v.6973L20.4648,23h-7.93L11.19,20.9824ZM24,28H9V26a1.0009,1.0009,0,0,1,1-1H23a1.0006,1.0006,0,0,1,1,1Z"}),props.children);});var Gamification16=/*#__PURE__*/React.forwardRef(function Gamification16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M23,23h-.1315l.9635-1.4453A1.0008,1.0008,0,0,0,24,21V12.0005c0-9.8858-7.92-10-8-10A1,1,0,0,0,15,3l-.0005,2H14a.9956.9956,0,0,0-.581.1865l-7,5a1,1,0,0,0-.3676,1.13l1,3a.9976.9976,0,0,0,1.09.6733l4.87-.6958L9.1519,20.47a1,1,0,0,0,.0161,1.085L10.1315,23H10a3.0033,3.0033,0,0,0-3,3v4H26V26A3.0033,3.0033,0,0,0,23,23Zm-7.1519-9.47a1,1,0,0,0-.99-1.52l-6.1738.8819-.5025-1.5078L14.32,7.0005H15.999a1,1,0,0,0,1-.9995L17,4.1289C18.5013,4.4636,21.2167,5.67,21.86,10H19v2h3v2H19v2h3v2H19v2h3v.6973L20.4648,23h-7.93L11.19,20.9824ZM24,28H9V26a1.0009,1.0009,0,0,1,1-1H23a1.0006,1.0006,0,0,1,1,1Z"}),props.children);});var GeneratePdf32=/*#__PURE__*/React.forwardRef(function GeneratePdf32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24v4H8V24H6v4H6a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2h0V24Z"}),React.createElement("polygon",{points:"21 21 19.586 19.586 17 22.172 17 14 15 14 15 22.172 12.414 19.586 11 21 16 26 21 21"}),React.createElement("polygon",{points:"28 4 28 2 22 2 22 12 24 12 24 8 27 8 27 6 24 6 24 4 28 4"}),React.createElement("path",{d:"M17,12H13V2h4a3.0033,3.0033,0,0,1,3,3V9A3.0033,3.0033,0,0,1,17,12Zm-2-2h2a1.0011,1.0011,0,0,0,1-1V5a1.0011,1.0011,0,0,0-1-1H15Z"}),React.createElement("path",{d:"M9,2H4V12H6V9H9a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,9,2ZM6,7V4H9l.001,3Z"}),props.children);});var GeneratePdf24=/*#__PURE__*/React.forwardRef(function GeneratePdf24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24v4H8V24H6v4H6a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2h0V24Z"}),React.createElement("polygon",{points:"21 21 19.586 19.586 17 22.172 17 14 15 14 15 22.172 12.414 19.586 11 21 16 26 21 21"}),React.createElement("polygon",{points:"28 4 28 2 22 2 22 12 24 12 24 8 27 8 27 6 24 6 24 4 28 4"}),React.createElement("path",{d:"M17,12H13V2h4a3.0033,3.0033,0,0,1,3,3V9A3.0033,3.0033,0,0,1,17,12Zm-2-2h2a1.0011,1.0011,0,0,0,1-1V5a1.0011,1.0011,0,0,0-1-1H15Z"}),React.createElement("path",{d:"M9,2H4V12H6V9H9a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,9,2ZM6,7V4H9l.001,3Z"}),props.children);});var GeneratePdf20=/*#__PURE__*/React.forwardRef(function GeneratePdf20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24v4H8V24H6v4H6a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2h0V24Z"}),React.createElement("polygon",{points:"21 21 19.586 19.586 17 22.172 17 14 15 14 15 22.172 12.414 19.586 11 21 16 26 21 21"}),React.createElement("polygon",{points:"28 4 28 2 22 2 22 12 24 12 24 8 27 8 27 6 24 6 24 4 28 4"}),React.createElement("path",{d:"M17,12H13V2h4a3.0033,3.0033,0,0,1,3,3V9A3.0033,3.0033,0,0,1,17,12Zm-2-2h2a1.0011,1.0011,0,0,0,1-1V5a1.0011,1.0011,0,0,0-1-1H15Z"}),React.createElement("path",{d:"M9,2H4V12H6V9H9a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,9,2ZM6,7V4H9l.001,3Z"}),props.children);});var GeneratePdf16=/*#__PURE__*/React.forwardRef(function GeneratePdf16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M24,24v4H8V24H6v4H6a2,2,0,0,0,2,2H24a2,2,0,0,0,2-2h0V24Z"}),React.createElement("polygon",{points:"21 21 19.586 19.586 17 22.172 17 14 15 14 15 22.172 12.414 19.586 11 21 16 26 21 21"}),React.createElement("polygon",{points:"28 4 28 2 22 2 22 12 24 12 24 8 27 8 27 6 24 6 24 4 28 4"}),React.createElement("path",{d:"M17,12H13V2h4a3.0033,3.0033,0,0,1,3,3V9A3.0033,3.0033,0,0,1,17,12Zm-2-2h2a1.0011,1.0011,0,0,0,1-1V5a1.0011,1.0011,0,0,0-1-1H15Z"}),React.createElement("path",{d:"M9,2H4V12H6V9H9a2.0027,2.0027,0,0,0,2-2V4A2.0023,2.0023,0,0,0,9,2ZM6,7V4H9l.001,3Z"}),props.children);});var Gift32=/*#__PURE__*/React.forwardRef(function Gift32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,10H23.2383A4.4867,4.4867,0,0,0,16,4.7065,4.4873,4.4873,0,0,0,8.7617,10H6a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2V28a2.0025,2.0025,0,0,0,2,2H24a2.0025,2.0025,0,0,0,2-2V18a2.0025,2.0025,0,0,0,2-2V12A2.0025,2.0025,0,0,0,26,10ZM17,7.5A2.5,2.5,0,1,1,19.5,10H17ZM12.5,5A2.503,2.503,0,0,1,15,7.5V10H12.5a2.5,2.5,0,0,1,0-5ZM6,12h9v4H6Zm2,6h7V28H8ZM24.0012,28H17V18h7ZM17,16V12h9l.0012,4Z"}),props.children);});var Gift24=/*#__PURE__*/React.forwardRef(function Gift24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,10H23.2383A4.4867,4.4867,0,0,0,16,4.7065,4.4873,4.4873,0,0,0,8.7617,10H6a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2V28a2.0025,2.0025,0,0,0,2,2H24a2.0025,2.0025,0,0,0,2-2V18a2.0025,2.0025,0,0,0,2-2V12A2.0025,2.0025,0,0,0,26,10ZM17,7.5A2.5,2.5,0,1,1,19.5,10H17ZM12.5,5A2.503,2.503,0,0,1,15,7.5V10H12.5a2.5,2.5,0,0,1,0-5ZM6,12h9v4H6Zm2,6h7V28H8ZM24.0012,28H17V18h7ZM17,16V12h9l.0012,4Z"}),props.children);});var Gift20=/*#__PURE__*/React.forwardRef(function Gift20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,10H23.2383A4.4867,4.4867,0,0,0,16,4.7065,4.4873,4.4873,0,0,0,8.7617,10H6a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2V28a2.0025,2.0025,0,0,0,2,2H24a2.0025,2.0025,0,0,0,2-2V18a2.0025,2.0025,0,0,0,2-2V12A2.0025,2.0025,0,0,0,26,10ZM17,7.5A2.5,2.5,0,1,1,19.5,10H17ZM12.5,5A2.503,2.503,0,0,1,15,7.5V10H12.5a2.5,2.5,0,0,1,0-5ZM6,12h9v4H6Zm2,6h7V28H8ZM24.0012,28H17V18h7ZM17,16V12h9l.0012,4Z"}),props.children);});var Gift16=/*#__PURE__*/React.forwardRef(function Gift16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M26,10H23.2383A4.4867,4.4867,0,0,0,16,4.7065,4.4873,4.4873,0,0,0,8.7617,10H6a2.0025,2.0025,0,0,0-2,2v4a2.0025,2.0025,0,0,0,2,2V28a2.0025,2.0025,0,0,0,2,2H24a2.0025,2.0025,0,0,0,2-2V18a2.0025,2.0025,0,0,0,2-2V12A2.0025,2.0025,0,0,0,26,10ZM17,7.5A2.5,2.5,0,1,1,19.5,10H17ZM12.5,5A2.503,2.503,0,0,1,15,7.5V10H12.5a2.5,2.5,0,0,1,0-5ZM6,12h9v4H6Zm2,6h7V28H8ZM24.0012,28H17V18h7ZM17,16V12h9l.0012,4Z"}),props.children);});var Globe32=/*#__PURE__*/React.forwardRef(function Globe32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14,4a7,7,0,1,1-7,7,7,7,0,0,1,7-7m0-2a9,9,0,1,0,9,9A9,9,0,0,0,14,2Z"}),React.createElement("path",{d:"M28,11a13.92,13.92,0,0,0-4.11-9.89L22.48,2.52a12,12,0,0,1-16.92,17l0,0L4.11,20.89A13.92,13.92,0,0,0,14,25v3H10v2H20V28H16V24.84A14,14,0,0,0,28,11Z"}),props.children);});var Globe24=/*#__PURE__*/React.forwardRef(function Globe24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14,4a7,7,0,1,1-7,7,7,7,0,0,1,7-7m0-2a9,9,0,1,0,9,9A9,9,0,0,0,14,2Z"}),React.createElement("path",{d:"M28,11a13.92,13.92,0,0,0-4.11-9.89L22.48,2.52a12,12,0,0,1-16.92,17l0,0L4.11,20.89A13.92,13.92,0,0,0,14,25v3H10v2H20V28H16V24.84A14,14,0,0,0,28,11Z"}),props.children);});var Globe20=/*#__PURE__*/React.forwardRef(function Globe20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14,4a7,7,0,1,1-7,7,7,7,0,0,1,7-7m0-2a9,9,0,1,0,9,9A9,9,0,0,0,14,2Z"}),React.createElement("path",{d:"M28,11a13.92,13.92,0,0,0-4.11-9.89L22.48,2.52a12,12,0,0,1-16.92,17l0,0L4.11,20.89A13.92,13.92,0,0,0,14,25v3H10v2H20V28H16V24.84A14,14,0,0,0,28,11Z"}),props.children);});var Globe16=/*#__PURE__*/React.forwardRef(function Globe16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M14,4a7,7,0,1,1-7,7,7,7,0,0,1,7-7m0-2a9,9,0,1,0,9,9A9,9,0,0,0,14,2Z"}),React.createElement("path",{d:"M28,11a13.92,13.92,0,0,0-4.11-9.89L22.48,2.52a12,12,0,0,1-16.92,17l0,0L4.11,20.89A13.92,13.92,0,0,0,14,25v3H10v2H20V28H16V24.84A14,14,0,0,0,28,11Z"}),props.children);});var GraphicalDataFlow32=/*#__PURE__*/React.forwardRef(function GraphicalDataFlow32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,30H22a2.0023,2.0023,0,0,1-2-2V22a2.0023,2.0023,0,0,1,2-2h6a2.0023,2.0023,0,0,1,2,2v6A2.0023,2.0023,0,0,1,28,30Zm-6-8h-.0012L22,28h6V22Z"}),React.createElement("path",{d:"M18,26H12a3.0033,3.0033,0,0,1-3-3V19h2v4a1.001,1.001,0,0,0,1,1h6Z"}),React.createElement("path",{d:"M26,18H24V15a1.001,1.001,0,0,0-1-1H18V12h5a3.0033,3.0033,0,0,1,3,3Z"}),React.createElement("path",{d:"M15,18a.9986.9986,0,0,1-.4971-.1323L10,15.2886,5.4968,17.8677a1,1,0,0,1-1.4712-1.0938l1.0618-4.572L2.269,9.1824a1,1,0,0,1,.5662-1.6687l4.2-.7019L9.1006,2.5627a1,1,0,0,1,1.7881-.0214l2.2046,4.271,4.0764.7021a1,1,0,0,1,.5613,1.668l-2.8184,3.02,1.0613,4.5718A1,1,0,0,1,15,18Zm-5-5s.343.18.4971.2686l3.01,1.7241-.7837-3.3763,2.282-2.4453-3.2331-.5569-1.7456-3.382L8.3829,8.6144l-3.3809.565,2.2745,2.437-.7841,3.3763,3.0105-1.7241C9.657,13.18,10,13,10,13Z"}),props.children);});var GraphicalDataFlow24=/*#__PURE__*/React.forwardRef(function GraphicalDataFlow24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,30H22a2.0023,2.0023,0,0,1-2-2V22a2.0023,2.0023,0,0,1,2-2h6a2.0023,2.0023,0,0,1,2,2v6A2.0023,2.0023,0,0,1,28,30Zm-6-8h-.0012L22,28h6V22Z"}),React.createElement("path",{d:"M18,26H12a3.0033,3.0033,0,0,1-3-3V19h2v4a1.001,1.001,0,0,0,1,1h6Z"}),React.createElement("path",{d:"M26,18H24V15a1.001,1.001,0,0,0-1-1H18V12h5a3.0033,3.0033,0,0,1,3,3Z"}),React.createElement("path",{d:"M15,18a.9986.9986,0,0,1-.4971-.1323L10,15.2886,5.4968,17.8677a1,1,0,0,1-1.4712-1.0938l1.0618-4.572L2.269,9.1824a1,1,0,0,1,.5662-1.6687l4.2-.7019L9.1006,2.5627a1,1,0,0,1,1.7881-.0214l2.2046,4.271,4.0764.7021a1,1,0,0,1,.5613,1.668l-2.8184,3.02,1.0613,4.5718A1,1,0,0,1,15,18Zm-5-5s.343.18.4971.2686l3.01,1.7241-.7837-3.3763,2.282-2.4453-3.2331-.5569-1.7456-3.382L8.3829,8.6144l-3.3809.565,2.2745,2.437-.7841,3.3763,3.0105-1.7241C9.657,13.18,10,13,10,13Z"}),props.children);});var GraphicalDataFlow20=/*#__PURE__*/React.forwardRef(function GraphicalDataFlow20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,30H22a2.0023,2.0023,0,0,1-2-2V22a2.0023,2.0023,0,0,1,2-2h6a2.0023,2.0023,0,0,1,2,2v6A2.0023,2.0023,0,0,1,28,30Zm-6-8h-.0012L22,28h6V22Z"}),React.createElement("path",{d:"M18,26H12a3.0033,3.0033,0,0,1-3-3V19h2v4a1.001,1.001,0,0,0,1,1h6Z"}),React.createElement("path",{d:"M26,18H24V15a1.001,1.001,0,0,0-1-1H18V12h5a3.0033,3.0033,0,0,1,3,3Z"}),React.createElement("path",{d:"M15,18a.9986.9986,0,0,1-.4971-.1323L10,15.2886,5.4968,17.8677a1,1,0,0,1-1.4712-1.0938l1.0618-4.572L2.269,9.1824a1,1,0,0,1,.5662-1.6687l4.2-.7019L9.1006,2.5627a1,1,0,0,1,1.7881-.0214l2.2046,4.271,4.0764.7021a1,1,0,0,1,.5613,1.668l-2.8184,3.02,1.0613,4.5718A1,1,0,0,1,15,18Zm-5-5s.343.18.4971.2686l3.01,1.7241-.7837-3.3763,2.282-2.4453-3.2331-.5569-1.7456-3.382L8.3829,8.6144l-3.3809.565,2.2745,2.437-.7841,3.3763,3.0105-1.7241C9.657,13.18,10,13,10,13Z"}),props.children);});var GraphicalDataFlow16=/*#__PURE__*/React.forwardRef(function GraphicalDataFlow16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,30H22a2.0023,2.0023,0,0,1-2-2V22a2.0023,2.0023,0,0,1,2-2h6a2.0023,2.0023,0,0,1,2,2v6A2.0023,2.0023,0,0,1,28,30Zm-6-8h-.0012L22,28h6V22Z"}),React.createElement("path",{d:"M18,26H12a3.0033,3.0033,0,0,1-3-3V19h2v4a1.001,1.001,0,0,0,1,1h6Z"}),React.createElement("path",{d:"M26,18H24V15a1.001,1.001,0,0,0-1-1H18V12h5a3.0033,3.0033,0,0,1,3,3Z"}),React.createElement("path",{d:"M15,18a.9986.9986,0,0,1-.4971-.1323L10,15.2886,5.4968,17.8677a1,1,0,0,1-1.4712-1.0938l1.0618-4.572L2.269,9.1824a1,1,0,0,1,.5662-1.6687l4.2-.7019L9.1006,2.5627a1,1,0,0,1,1.7881-.0214l2.2046,4.271,4.0764.7021a1,1,0,0,1,.5613,1.668l-2.8184,3.02,1.0613,4.5718A1,1,0,0,1,15,18Zm-5-5s.343.18.4971.2686l3.01,1.7241-.7837-3.3763,2.282-2.4453-3.2331-.5569-1.7456-3.382L8.3829,8.6144l-3.3809.565,2.2745,2.437-.7841,3.3763,3.0105-1.7241C9.657,13.18,10,13,10,13Z"}),props.children);});var Grid32=/*#__PURE__*/React.forwardRef(function Grid32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,4H6A2,2,0,0,0,4,6v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V6A2,2,0,0,0,12,4Zm0,8H6V6h6Z"}),React.createElement("path",{d:"M26,4H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4Zm0,8H20V6h6Z"}),React.createElement("path",{d:"M12,18H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V20A2,2,0,0,0,12,18Zm0,8H6V20h6Z"}),React.createElement("path",{d:"M26,18H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V20A2,2,0,0,0,26,18Zm0,8H20V20h6Z"}),props.children);});var Grid24=/*#__PURE__*/React.forwardRef(function Grid24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,4H6A2,2,0,0,0,4,6v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V6A2,2,0,0,0,12,4Zm0,8H6V6h6Z"}),React.createElement("path",{d:"M26,4H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4Zm0,8H20V6h6Z"}),React.createElement("path",{d:"M12,18H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V20A2,2,0,0,0,12,18Zm0,8H6V20h6Z"}),React.createElement("path",{d:"M26,18H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V20A2,2,0,0,0,26,18Zm0,8H20V20h6Z"}),props.children);});var Grid20=/*#__PURE__*/React.forwardRef(function Grid20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,4H6A2,2,0,0,0,4,6v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V6A2,2,0,0,0,12,4Zm0,8H6V6h6Z"}),React.createElement("path",{d:"M26,4H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4Zm0,8H20V6h6Z"}),React.createElement("path",{d:"M12,18H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V20A2,2,0,0,0,12,18Zm0,8H6V20h6Z"}),React.createElement("path",{d:"M26,18H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V20A2,2,0,0,0,26,18Zm0,8H20V20h6Z"}),props.children);});var Grid16=/*#__PURE__*/React.forwardRef(function Grid16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M12,4H6A2,2,0,0,0,4,6v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V6A2,2,0,0,0,12,4Zm0,8H6V6h6Z"}),React.createElement("path",{d:"M26,4H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4Zm0,8H20V6h6Z"}),React.createElement("path",{d:"M12,18H6a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V20A2,2,0,0,0,12,18Zm0,8H6V20h6Z"}),React.createElement("path",{d:"M26,18H20a2,2,0,0,0-2,2v6a2,2,0,0,0,2,2h6a2,2,0,0,0,2-2V20A2,2,0,0,0,26,18Zm0,8H20V20h6Z"}),props.children);});var Group32=/*#__PURE__*/React.forwardRef(function Group32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31,30H29V27a3,3,0,0,0-3-3H22a3,3,0,0,0-3,3v3H17V27a5,5,0,0,1,5-5h4a5,5,0,0,1,5,5Z"}),React.createElement("path",{d:"M24,12a3,3,0,1,1-3,3,3,3,0,0,1,3-3m0-2a5,5,0,1,0,5,5A5,5,0,0,0,24,10Z"}),React.createElement("path",{d:"M15,22H13V19a3,3,0,0,0-3-3H6a3,3,0,0,0-3,3v3H1V19a5,5,0,0,1,5-5h4a5,5,0,0,1,5,5Z"}),React.createElement("path",{d:"M8,4A3,3,0,1,1,5,7,3,3,0,0,1,8,4M8,2a5,5,0,1,0,5,5A5,5,0,0,0,8,2Z"}),props.children);});var Group24=/*#__PURE__*/React.forwardRef(function Group24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31,30H29V27a3,3,0,0,0-3-3H22a3,3,0,0,0-3,3v3H17V27a5,5,0,0,1,5-5h4a5,5,0,0,1,5,5Z"}),React.createElement("path",{d:"M24,12a3,3,0,1,1-3,3,3,3,0,0,1,3-3m0-2a5,5,0,1,0,5,5A5,5,0,0,0,24,10Z"}),React.createElement("path",{d:"M15,22H13V19a3,3,0,0,0-3-3H6a3,3,0,0,0-3,3v3H1V19a5,5,0,0,1,5-5h4a5,5,0,0,1,5,5Z"}),React.createElement("path",{d:"M8,4A3,3,0,1,1,5,7,3,3,0,0,1,8,4M8,2a5,5,0,1,0,5,5A5,5,0,0,0,8,2Z"}),props.children);});var Group20=/*#__PURE__*/React.forwardRef(function Group20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31,30H29V27a3,3,0,0,0-3-3H22a3,3,0,0,0-3,3v3H17V27a5,5,0,0,1,5-5h4a5,5,0,0,1,5,5Z"}),React.createElement("path",{d:"M24,12a3,3,0,1,1-3,3,3,3,0,0,1,3-3m0-2a5,5,0,1,0,5,5A5,5,0,0,0,24,10Z"}),React.createElement("path",{d:"M15,22H13V19a3,3,0,0,0-3-3H6a3,3,0,0,0-3,3v3H1V19a5,5,0,0,1,5-5h4a5,5,0,0,1,5,5Z"}),React.createElement("path",{d:"M8,4A3,3,0,1,1,5,7,3,3,0,0,1,8,4M8,2a5,5,0,1,0,5,5A5,5,0,0,0,8,2Z"}),props.children);});var Group16=/*#__PURE__*/React.forwardRef(function Group16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M31,30H29V27a3,3,0,0,0-3-3H22a3,3,0,0,0-3,3v3H17V27a5,5,0,0,1,5-5h4a5,5,0,0,1,5,5Z"}),React.createElement("path",{d:"M24,12a3,3,0,1,1-3,3,3,3,0,0,1,3-3m0-2a5,5,0,1,0,5,5A5,5,0,0,0,24,10Z"}),React.createElement("path",{d:"M15,22H13V19a3,3,0,0,0-3-3H6a3,3,0,0,0-3,3v3H1V19a5,5,0,0,1,5-5h4a5,5,0,0,1,5,5Z"}),React.createElement("path",{d:"M8,4A3,3,0,1,1,5,7,3,3,0,0,1,8,4M8,2a5,5,0,1,0,5,5A5,5,0,0,0,8,2Z"}),props.children);});var Hail32=/*#__PURE__*/React.forwardRef(function Hail32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"21.5",cy:"29.5",r:"1.5"}),React.createElement("circle",{cx:"24.5",cy:"25.5",r:"1.5"}),React.createElement("circle",{cx:"7.5",cy:"25.5",r:"1.5"}),React.createElement("circle",{cx:"4.5",cy:"29.5",r:"1.5"}),React.createElement("circle",{cx:"10.499",cy:"29.5",r:"1.5"}),React.createElement("polygon",{points:"15.868 30.496 14.132 29.504 17.276 24 11.277 24 16.132 15.504 17.868 16.496 14.723 22 20.724 22 15.868 30.496"}),React.createElement("path",{d:"M23.5,22H23V20h.5a4.4975,4.4975,0,0,0,.3564-8.981l-.8154-.0639-.0986-.812a6.9938,6.9938,0,0,0-13.8838,0l-.0991.812-.8155.0639A4.4975,4.4975,0,0,0,8.5,20H9v2H8.5A6.4973,6.4973,0,0,1,7.2,9.1362a8.9943,8.9943,0,0,1,17.6006,0A6.4974,6.4974,0,0,1,23.5,22Z"}),props.children);});var Hail24=/*#__PURE__*/React.forwardRef(function Hail24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"21.5",cy:"29.5",r:"1.5"}),React.createElement("circle",{cx:"24.5",cy:"25.5",r:"1.5"}),React.createElement("circle",{cx:"7.5",cy:"25.5",r:"1.5"}),React.createElement("circle",{cx:"4.5",cy:"29.5",r:"1.5"}),React.createElement("circle",{cx:"10.499",cy:"29.5",r:"1.5"}),React.createElement("polygon",{points:"15.868 30.496 14.132 29.504 17.276 24 11.277 24 16.132 15.504 17.868 16.496 14.723 22 20.724 22 15.868 30.496"}),React.createElement("path",{d:"M23.5,22H23V20h.5a4.4975,4.4975,0,0,0,.3564-8.981l-.8154-.0639-.0986-.812a6.9938,6.9938,0,0,0-13.8838,0l-.0991.812-.8155.0639A4.4975,4.4975,0,0,0,8.5,20H9v2H8.5A6.4973,6.4973,0,0,1,7.2,9.1362a8.9943,8.9943,0,0,1,17.6006,0A6.4974,6.4974,0,0,1,23.5,22Z"}),props.children);});var Hail20=/*#__PURE__*/React.forwardRef(function Hail20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"21.5",cy:"29.5",r:"1.5"}),React.createElement("circle",{cx:"24.5",cy:"25.5",r:"1.5"}),React.createElement("circle",{cx:"7.5",cy:"25.5",r:"1.5"}),React.createElement("circle",{cx:"4.5",cy:"29.5",r:"1.5"}),React.createElement("circle",{cx:"10.499",cy:"29.5",r:"1.5"}),React.createElement("polygon",{points:"15.868 30.496 14.132 29.504 17.276 24 11.277 24 16.132 15.504 17.868 16.496 14.723 22 20.724 22 15.868 30.496"}),React.createElement("path",{d:"M23.5,22H23V20h.5a4.4975,4.4975,0,0,0,.3564-8.981l-.8154-.0639-.0986-.812a6.9938,6.9938,0,0,0-13.8838,0l-.0991.812-.8155.0639A4.4975,4.4975,0,0,0,8.5,20H9v2H8.5A6.4973,6.4973,0,0,1,7.2,9.1362a8.9943,8.9943,0,0,1,17.6006,0A6.4974,6.4974,0,0,1,23.5,22Z"}),props.children);});var Hail16=/*#__PURE__*/React.forwardRef(function Hail16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("circle",{cx:"21.5",cy:"29.5",r:"1.5"}),React.createElement("circle",{cx:"24.5",cy:"25.5",r:"1.5"}),React.createElement("circle",{cx:"7.5",cy:"25.5",r:"1.5"}),React.createElement("circle",{cx:"4.5",cy:"29.5",r:"1.5"}),React.createElement("circle",{cx:"10.499",cy:"29.5",r:"1.5"}),React.createElement("polygon",{points:"15.868 30.496 14.132 29.504 17.276 24 11.277 24 16.132 15.504 17.868 16.496 14.723 22 20.724 22 15.868 30.496"}),React.createElement("path",{d:"M23.5,22H23V20h.5a4.4975,4.4975,0,0,0,.3564-8.981l-.8154-.0639-.0986-.812a6.9938,6.9938,0,0,0-13.8838,0l-.0991.812-.8155.0639A4.4975,4.4975,0,0,0,8.5,20H9v2H8.5A6.4973,6.4973,0,0,1,7.2,9.1362a8.9943,8.9943,0,0,1,17.6006,0A6.4974,6.4974,0,0,1,23.5,22Z"}),props.children);});var Hashtag32=/*#__PURE__*/React.forwardRef(function Hashtag32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,12V10H22V4H20v6H12V4H10v6H4v2h6v8H4v2h6v6h2V22h8v6h2V22h6V20H22V12Zm-8,8H12V12h8Z"}),props.children);});var Hashtag24=/*#__PURE__*/React.forwardRef(function Hashtag24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,12V10H22V4H20v6H12V4H10v6H4v2h6v8H4v2h6v6h2V22h8v6h2V22h6V20H22V12Zm-8,8H12V12h8Z"}),props.children);});var Hashtag20=/*#__PURE__*/React.forwardRef(function Hashtag20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,12V10H22V4H20v6H12V4H10v6H4v2h6v8H4v2h6v6h2V22h8v6h2V22h6V20H22V12Zm-8,8H12V12h8Z"}),props.children);});var Hashtag16=/*#__PURE__*/React.forwardRef(function Hashtag16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M28,12V10H22V4H20v6H12V4H10v6H4v2h6v8H4v2h6v6h2V22h8v6h2V22h6V20H22V12Zm-8,8H12V12h8Z"}),props.children);});var HazeNight32=/*#__PURE__*/React.forwardRef(function HazeNight32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,22H13a1,1,0,0,0,0,2h9.6772a11.0991,11.0991,0,0,1-7.5561,2.9976c-.1384,0-.2783.0048-.4177,0a11.0945,11.0945,0,0,1-3.201-21.584,15.1528,15.1528,0,0,0-.0488,6.5869h2.0457a13.15,13.15,0,0,1,.39-7.6206A1.015,1.015,0,0,0,12.98,3a.9825.9825,0,0,0-.1746.0156A13.0958,13.0958,0,0,0,14.63,28.9971c.164.0063.3281,0,.4907,0A13.04,13.04,0,0,0,25.3779,24H29a1,1,0,0,0,0-2Z"}),React.createElement("path",{d:"M27,20H17a1,1,0,0,1,0-2H27a1,1,0,0,1,0,2Z"}),React.createElement("path",{d:"M25,16H13a1,1,0,0,1,0-2H25a1,1,0,0,1,0,2Z"}),props.children);});var HazeNight24=/*#__PURE__*/React.forwardRef(function HazeNight24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,22H13a1,1,0,0,0,0,2h9.6772a11.0991,11.0991,0,0,1-7.5561,2.9976c-.1384,0-.2783.0048-.4177,0a11.0945,11.0945,0,0,1-3.201-21.584,15.1528,15.1528,0,0,0-.0488,6.5869h2.0457a13.15,13.15,0,0,1,.39-7.6206A1.015,1.015,0,0,0,12.98,3a.9825.9825,0,0,0-.1746.0156A13.0958,13.0958,0,0,0,14.63,28.9971c.164.0063.3281,0,.4907,0A13.04,13.04,0,0,0,25.3779,24H29a1,1,0,0,0,0-2Z"}),React.createElement("path",{d:"M27,20H17a1,1,0,0,1,0-2H27a1,1,0,0,1,0,2Z"}),React.createElement("path",{d:"M25,16H13a1,1,0,0,1,0-2H25a1,1,0,0,1,0,2Z"}),props.children);});var HazeNight20=/*#__PURE__*/React.forwardRef(function HazeNight20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,22H13a1,1,0,0,0,0,2h9.6772a11.0991,11.0991,0,0,1-7.5561,2.9976c-.1384,0-.2783.0048-.4177,0a11.0945,11.0945,0,0,1-3.201-21.584,15.1528,15.1528,0,0,0-.0488,6.5869h2.0457a13.15,13.15,0,0,1,.39-7.6206A1.015,1.015,0,0,0,12.98,3a.9825.9825,0,0,0-.1746.0156A13.0958,13.0958,0,0,0,14.63,28.9971c.164.0063.3281,0,.4907,0A13.04,13.04,0,0,0,25.3779,24H29a1,1,0,0,0,0-2Z"}),React.createElement("path",{d:"M27,20H17a1,1,0,0,1,0-2H27a1,1,0,0,1,0,2Z"}),React.createElement("path",{d:"M25,16H13a1,1,0,0,1,0-2H25a1,1,0,0,1,0,2Z"}),props.children);});var HazeNight16=/*#__PURE__*/React.forwardRef(function HazeNight16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M29,22H13a1,1,0,0,0,0,2h9.6772a11.0991,11.0991,0,0,1-7.5561,2.9976c-.1384,0-.2783.0048-.4177,0a11.0945,11.0945,0,0,1-3.201-21.584,15.1528,15.1528,0,0,0-.0488,6.5869h2.0457a13.15,13.15,0,0,1,.39-7.6206A1.015,1.015,0,0,0,12.98,3a.9825.9825,0,0,0-.1746.0156A13.0958,13.0958,0,0,0,14.63,28.9971c.164.0063.3281,0,.4907,0A13.04,13.04,0,0,0,25.3779,24H29a1,1,0,0,0,0-2Z"}),React.createElement("path",{d:"M27,20H17a1,1,0,0,1,0-2H27a1,1,0,0,1,0,2Z"}),React.createElement("path",{d:"M25,16H13a1,1,0,0,1,0-2H25a1,1,0,0,1,0,2Z"}),props.children);});var Haze32=/*#__PURE__*/React.forwardRef(function Haze32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,28H3a1,1,0,0,1,0-2H19a1,1,0,0,1,0,2Z"}),React.createElement("path",{d:"M15,20H3a1,1,0,0,1,0-2H15a1,1,0,0,1,0,2Z"}),React.createElement("rect",{width:"4",height:"2",x:"24.5",y:"23.5",transform:"rotate(45 26.5 24.5)"}),React.createElement("rect",{width:"4",height:"2",x:"28",y:"15"}),React.createElement("rect",{width:"4",height:"2",x:"24.5",y:"6.5",transform:"rotate(-45 26.5 7.5)"}),React.createElement("rect",{width:"2",height:"4",x:"17",y:"2"}),React.createElement("rect",{width:"4",height:"2",x:"7.5",y:"6.5",transform:"rotate(-135 9.5 7.5)"}),React.createElement("path",{d:"M18,8a8.0092,8.0092,0,0,0-8,8h2a6,6,0,1,1,6,6H7a1,1,0,0,0,0,2H18A8,8,0,0,0,18,8Z"}),props.children);});var Haze24=/*#__PURE__*/React.forwardRef(function Haze24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,28H3a1,1,0,0,1,0-2H19a1,1,0,0,1,0,2Z"}),React.createElement("path",{d:"M15,20H3a1,1,0,0,1,0-2H15a1,1,0,0,1,0,2Z"}),React.createElement("rect",{width:"4",height:"2",x:"24.5",y:"23.5",transform:"rotate(45 26.5 24.5)"}),React.createElement("rect",{width:"4",height:"2",x:"28",y:"15"}),React.createElement("rect",{width:"4",height:"2",x:"24.5",y:"6.5",transform:"rotate(-45 26.5 7.5)"}),React.createElement("rect",{width:"2",height:"4",x:"17",y:"2"}),React.createElement("rect",{width:"4",height:"2",x:"7.5",y:"6.5",transform:"rotate(-135 9.5 7.5)"}),React.createElement("path",{d:"M18,8a8.0092,8.0092,0,0,0-8,8h2a6,6,0,1,1,6,6H7a1,1,0,0,0,0,2H18A8,8,0,0,0,18,8Z"}),props.children);});var Haze20=/*#__PURE__*/React.forwardRef(function Haze20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,28H3a1,1,0,0,1,0-2H19a1,1,0,0,1,0,2Z"}),React.createElement("path",{d:"M15,20H3a1,1,0,0,1,0-2H15a1,1,0,0,1,0,2Z"}),React.createElement("rect",{width:"4",height:"2",x:"24.5",y:"23.5",transform:"rotate(45 26.5 24.5)"}),React.createElement("rect",{width:"4",height:"2",x:"28",y:"15"}),React.createElement("rect",{width:"4",height:"2",x:"24.5",y:"6.5",transform:"rotate(-45 26.5 7.5)"}),React.createElement("rect",{width:"2",height:"4",x:"17",y:"2"}),React.createElement("rect",{width:"4",height:"2",x:"7.5",y:"6.5",transform:"rotate(-135 9.5 7.5)"}),React.createElement("path",{d:"M18,8a8.0092,8.0092,0,0,0-8,8h2a6,6,0,1,1,6,6H7a1,1,0,0,0,0,2H18A8,8,0,0,0,18,8Z"}),props.children);});var Haze16=/*#__PURE__*/React.forwardRef(function Haze16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,28H3a1,1,0,0,1,0-2H19a1,1,0,0,1,0,2Z"}),React.createElement("path",{d:"M15,20H3a1,1,0,0,1,0-2H15a1,1,0,0,1,0,2Z"}),React.createElement("rect",{width:"4",height:"2",x:"24.5",y:"23.5",transform:"rotate(45 26.5 24.5)"}),React.createElement("rect",{width:"4",height:"2",x:"28",y:"15"}),React.createElement("rect",{width:"4",height:"2",x:"24.5",y:"6.5",transform:"rotate(-45 26.5 7.5)"}),React.createElement("rect",{width:"2",height:"4",x:"17",y:"2"}),React.createElement("rect",{width:"4",height:"2",x:"7.5",y:"6.5",transform:"rotate(-135 9.5 7.5)"}),React.createElement("path",{d:"M18,8a8.0092,8.0092,0,0,0-8,8h2a6,6,0,1,1,6,6H7a1,1,0,0,0,0,2H18A8,8,0,0,0,18,8Z"}),props.children);});var Headphones32=/*#__PURE__*/React.forwardRef(function Headphones32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,16V15A9,9,0,0,0,7,15v1A5,5,0,0,0,7,26H9V15a7,7,0,0,1,14,0V26h2a5,5,0,0,0,0-10ZM4,21a3,3,0,0,1,3-3v6A3,3,0,0,1,4,21Zm21,3V18a3,3,0,0,1,0,6Z"}),props.children);});var Headphones24=/*#__PURE__*/React.forwardRef(function Headphones24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,16V15A9,9,0,0,0,7,15v1A5,5,0,0,0,7,26H9V15a7,7,0,0,1,14,0V26h2a5,5,0,0,0,0-10ZM4,21a3,3,0,0,1,3-3v6A3,3,0,0,1,4,21Zm21,3V18a3,3,0,0,1,0,6Z"}),props.children);});var Headphones20=/*#__PURE__*/React.forwardRef(function Headphones20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,16V15A9,9,0,0,0,7,15v1A5,5,0,0,0,7,26H9V15a7,7,0,0,1,14,0V26h2a5,5,0,0,0,0-10ZM4,21a3,3,0,0,1,3-3v6A3,3,0,0,1,4,21Zm21,3V18a3,3,0,0,1,0,6Z"}),props.children);});var Headphones16=/*#__PURE__*/React.forwardRef(function Headphones16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,16V15A9,9,0,0,0,7,15v1A5,5,0,0,0,7,26H9V15a7,7,0,0,1,14,0V26h2a5,5,0,0,0,0-10ZM4,21a3,3,0,0,1,3-3v6A3,3,0,0,1,4,21Zm21,3V18a3,3,0,0,1,0,6Z"}),props.children);});var Headset32=/*#__PURE__*/React.forwardRef(function Headset32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,10h-.06A9,9,0,0,0,7.06,10H7A5,5,0,0,0,7,20H9V11a7,7,0,0,1,14,0V21a4,4,0,0,1-3.17,3.91,4,4,0,1,0,.05,2A6,6,0,0,0,25,21V20a5,5,0,0,0,0-10ZM4,15a3,3,0,0,1,3-3v6A3,3,0,0,1,4,15ZM16,28a2,2,0,1,1,2-2A2,2,0,0,1,16,28Zm9-10V12a3,3,0,0,1,0,6Z"}),props.children);});var Headset24=/*#__PURE__*/React.forwardRef(function Headset24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,10h-.06A9,9,0,0,0,7.06,10H7A5,5,0,0,0,7,20H9V11a7,7,0,0,1,14,0V21a4,4,0,0,1-3.17,3.91,4,4,0,1,0,.05,2A6,6,0,0,0,25,21V20a5,5,0,0,0,0-10ZM4,15a3,3,0,0,1,3-3v6A3,3,0,0,1,4,15ZM16,28a2,2,0,1,1,2-2A2,2,0,0,1,16,28Zm9-10V12a3,3,0,0,1,0,6Z"}),props.children);});var Headset20=/*#__PURE__*/React.forwardRef(function Headset20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,10h-.06A9,9,0,0,0,7.06,10H7A5,5,0,0,0,7,20H9V11a7,7,0,0,1,14,0V21a4,4,0,0,1-3.17,3.91,4,4,0,1,0,.05,2A6,6,0,0,0,25,21V20a5,5,0,0,0,0-10ZM4,15a3,3,0,0,1,3-3v6A3,3,0,0,1,4,15ZM16,28a2,2,0,1,1,2-2A2,2,0,0,1,16,28Zm9-10V12a3,3,0,0,1,0,6Z"}),props.children);});var Headset16=/*#__PURE__*/React.forwardRef(function Headset16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M25,10h-.06A9,9,0,0,0,7.06,10H7A5,5,0,0,0,7,20H9V11a7,7,0,0,1,14,0V21a4,4,0,0,1-3.17,3.91,4,4,0,1,0,.05,2A6,6,0,0,0,25,21V20a5,5,0,0,0,0-10ZM4,15a3,3,0,0,1,3-3v6A3,3,0,0,1,4,15ZM16,28a2,2,0,1,1,2-2A2,2,0,0,1,16,28Zm9-10V12a3,3,0,0,1,0,6Z"}),props.children);});var HealthCross32=/*#__PURE__*/React.forwardRef(function HealthCross32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,28H13a2.0023,2.0023,0,0,1-2-2V21H6a2.0023,2.0023,0,0,1-2-2V13a2.002,2.002,0,0,1,2-2h5V6a2.002,2.002,0,0,1,2-2h6a2.0023,2.0023,0,0,1,2,2v5h5a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H21v5A2.0027,2.0027,0,0,1,19,28ZM6,13v6h7v7h6V19h7V13H19V6H13v7Z"}),props.children);});var HealthCross24=/*#__PURE__*/React.forwardRef(function HealthCross24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,28H13a2.0023,2.0023,0,0,1-2-2V21H6a2.0023,2.0023,0,0,1-2-2V13a2.002,2.002,0,0,1,2-2h5V6a2.002,2.002,0,0,1,2-2h6a2.0023,2.0023,0,0,1,2,2v5h5a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H21v5A2.0027,2.0027,0,0,1,19,28ZM6,13v6h7v7h6V19h7V13H19V6H13v7Z"}),props.children);});var HealthCross20=/*#__PURE__*/React.forwardRef(function HealthCross20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,28H13a2.0023,2.0023,0,0,1-2-2V21H6a2.0023,2.0023,0,0,1-2-2V13a2.002,2.002,0,0,1,2-2h5V6a2.002,2.002,0,0,1,2-2h6a2.0023,2.0023,0,0,1,2,2v5h5a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H21v5A2.0027,2.0027,0,0,1,19,28ZM6,13v6h7v7h6V19h7V13H19V6H13v7Z"}),props.children);});var HealthCross16=/*#__PURE__*/React.forwardRef(function HealthCross16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M19,28H13a2.0023,2.0023,0,0,1-2-2V21H6a2.0023,2.0023,0,0,1-2-2V13a2.002,2.002,0,0,1,2-2h5V6a2.002,2.002,0,0,1,2-2h6a2.0023,2.0023,0,0,1,2,2v5h5a2.0023,2.0023,0,0,1,2,2v6a2.0027,2.0027,0,0,1-2,2H21v5A2.0027,2.0027,0,0,1,19,28ZM6,13v6h7v7h6V19h7V13H19V6H13v7Z"}),props.children);});var Hearing32=/*#__PURE__*/React.forwardRef(function Hearing32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,30V28A10.0114,10.0114,0,0,0,28,18h2A12.0134,12.0134,0,0,1,18,30Z"}),React.createElement("path",{d:"M18,26V24a6.0066,6.0066,0,0,0,6-6h2A8.0092,8.0092,0,0,1,18,26Z"}),React.createElement("path",{d:"M18,22V20a2.0023,2.0023,0,0,0,2-2h2A4.0042,4.0042,0,0,1,18,22Z"}),React.createElement("path",{d:"M10,2a9.01,9.01,0,0,0-9,9H3a7,7,0,0,1,14,0,7.09,7.09,0,0,1-3.501,6.1348L13,17.4229v3.0732a2.9354,2.9354,0,0,1-.9009,2.1514,4.1824,4.1824,0,0,1-4.6318,1.03A4.0918,4.0918,0,0,1,5,20H3a6.1156,6.1156,0,0,0,3.6694,5.5117,5.7822,5.7822,0,0,0,2.3145.4863A6.5854,6.5854,0,0,0,13.4624,24.11,4.94,4.94,0,0,0,15,20.4961V18.5537A9.1077,9.1077,0,0,0,19,11,9.01,9.01,0,0,0,10,2Z"}),React.createElement("path",{d:"M9.28,8.0825A3.0061,3.0061,0,0,1,13,11h2a4.9786,4.9786,0,0,0-1.8843-3.9111A5.0414,5.0414,0,0,0,8.835,6.1323,4.95,4.95,0,0,0,5.1323,9.835,5.0318,5.0318,0,0,0,7.436,15.2935,3.0777,3.0777,0,0,1,9,17.9229V20h2V17.9229a5.0608,5.0608,0,0,0-2.5371-4.3458A3.0016,3.0016,0,0,1,9.28,8.0825Z"}),props.children);});var Hearing24=/*#__PURE__*/React.forwardRef(function Hearing24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,30V28A10.0114,10.0114,0,0,0,28,18h2A12.0134,12.0134,0,0,1,18,30Z"}),React.createElement("path",{d:"M18,26V24a6.0066,6.0066,0,0,0,6-6h2A8.0092,8.0092,0,0,1,18,26Z"}),React.createElement("path",{d:"M18,22V20a2.0023,2.0023,0,0,0,2-2h2A4.0042,4.0042,0,0,1,18,22Z"}),React.createElement("path",{d:"M10,2a9.01,9.01,0,0,0-9,9H3a7,7,0,0,1,14,0,7.09,7.09,0,0,1-3.501,6.1348L13,17.4229v3.0732a2.9354,2.9354,0,0,1-.9009,2.1514,4.1824,4.1824,0,0,1-4.6318,1.03A4.0918,4.0918,0,0,1,5,20H3a6.1156,6.1156,0,0,0,3.6694,5.5117,5.7822,5.7822,0,0,0,2.3145.4863A6.5854,6.5854,0,0,0,13.4624,24.11,4.94,4.94,0,0,0,15,20.4961V18.5537A9.1077,9.1077,0,0,0,19,11,9.01,9.01,0,0,0,10,2Z"}),React.createElement("path",{d:"M9.28,8.0825A3.0061,3.0061,0,0,1,13,11h2a4.9786,4.9786,0,0,0-1.8843-3.9111A5.0414,5.0414,0,0,0,8.835,6.1323,4.95,4.95,0,0,0,5.1323,9.835,5.0318,5.0318,0,0,0,7.436,15.2935,3.0777,3.0777,0,0,1,9,17.9229V20h2V17.9229a5.0608,5.0608,0,0,0-2.5371-4.3458A3.0016,3.0016,0,0,1,9.28,8.0825Z"}),props.children);});var Hearing20=/*#__PURE__*/React.forwardRef(function Hearing20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,30V28A10.0114,10.0114,0,0,0,28,18h2A12.0134,12.0134,0,0,1,18,30Z"}),React.createElement("path",{d:"M18,26V24a6.0066,6.0066,0,0,0,6-6h2A8.0092,8.0092,0,0,1,18,26Z"}),React.createElement("path",{d:"M18,22V20a2.0023,2.0023,0,0,0,2-2h2A4.0042,4.0042,0,0,1,18,22Z"}),React.createElement("path",{d:"M10,2a9.01,9.01,0,0,0-9,9H3a7,7,0,0,1,14,0,7.09,7.09,0,0,1-3.501,6.1348L13,17.4229v3.0732a2.9354,2.9354,0,0,1-.9009,2.1514,4.1824,4.1824,0,0,1-4.6318,1.03A4.0918,4.0918,0,0,1,5,20H3a6.1156,6.1156,0,0,0,3.6694,5.5117,5.7822,5.7822,0,0,0,2.3145.4863A6.5854,6.5854,0,0,0,13.4624,24.11,4.94,4.94,0,0,0,15,20.4961V18.5537A9.1077,9.1077,0,0,0,19,11,9.01,9.01,0,0,0,10,2Z"}),React.createElement("path",{d:"M9.28,8.0825A3.0061,3.0061,0,0,1,13,11h2a4.9786,4.9786,0,0,0-1.8843-3.9111A5.0414,5.0414,0,0,0,8.835,6.1323,4.95,4.95,0,0,0,5.1323,9.835,5.0318,5.0318,0,0,0,7.436,15.2935,3.0777,3.0777,0,0,1,9,17.9229V20h2V17.9229a5.0608,5.0608,0,0,0-2.5371-4.3458A3.0016,3.0016,0,0,1,9.28,8.0825Z"}),props.children);});var Hearing16=/*#__PURE__*/React.forwardRef(function Hearing16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M18,30V28A10.0114,10.0114,0,0,0,28,18h2A12.0134,12.0134,0,0,1,18,30Z"}),React.createElement("path",{d:"M18,26V24a6.0066,6.0066,0,0,0,6-6h2A8.0092,8.0092,0,0,1,18,26Z"}),React.createElement("path",{d:"M18,22V20a2.0023,2.0023,0,0,0,2-2h2A4.0042,4.0042,0,0,1,18,22Z"}),React.createElement("path",{d:"M10,2a9.01,9.01,0,0,0-9,9H3a7,7,0,0,1,14,0,7.09,7.09,0,0,1-3.501,6.1348L13,17.4229v3.0732a2.9354,2.9354,0,0,1-.9009,2.1514,4.1824,4.1824,0,0,1-4.6318,1.03A4.0918,4.0918,0,0,1,5,20H3a6.1156,6.1156,0,0,0,3.6694,5.5117,5.7822,5.7822,0,0,0,2.3145.4863A6.5854,6.5854,0,0,0,13.4624,24.11,4.94,4.94,0,0,0,15,20.4961V18.5537A9.1077,9.1077,0,0,0,19,11,9.01,9.01,0,0,0,10,2Z"}),React.createElement("path",{d:"M9.28,8.0825A3.0061,3.0061,0,0,1,13,11h2a4.9786,4.9786,0,0,0-1.8843-3.9111A5.0414,5.0414,0,0,0,8.835,6.1323,4.95,4.95,0,0,0,5.1323,9.835,5.0318,5.0318,0,0,0,7.436,15.2935,3.0777,3.0777,0,0,1,9,17.9229V20h2V17.9229a5.0608,5.0608,0,0,0-2.5371-4.3458A3.0016,3.0016,0,0,1,9.28,8.0825Z"}),props.children);});var HelpFilled32=/*#__PURE__*/React.forwardRef(function HelpFilled32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,23a1.5,1.5,0,1,1,1.5-1.5A1.5,1.5,0,0,1,16,25Zm1.14-7.75v2.5H14.89V15H17a2.38,2.38,0,0,0,0-4.75h-1.5a2.38,2.38,0,0,0-2.38,2.37v.64H10.89v-.64A4.63,4.63,0,0,1,15.52,8H17a4.63,4.63,0,0,1,.12,9.25Z"}),props.children);});var HelpFilled24=/*#__PURE__*/React.forwardRef(function HelpFilled24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,23a1.5,1.5,0,1,1,1.5-1.5A1.5,1.5,0,0,1,16,25Zm1.14-7.75v2.5H14.89V15H17a2.38,2.38,0,0,0,0-4.75h-1.5a2.38,2.38,0,0,0-2.38,2.37v.64H10.89v-.64A4.63,4.63,0,0,1,15.52,8H17a4.63,4.63,0,0,1,.12,9.25Z"}),props.children);});var HelpFilled20=/*#__PURE__*/React.forwardRef(function HelpFilled20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,23a1.5,1.5,0,1,1,1.5-1.5A1.5,1.5,0,0,1,16,25Zm1.14-7.75v2.5H14.89V15H17a2.38,2.38,0,0,0,0-4.75h-1.5a2.38,2.38,0,0,0-2.38,2.37v.64H10.89v-.64A4.63,4.63,0,0,1,15.52,8H17a4.63,4.63,0,0,1,.12,9.25Z"}),props.children);});var HelpDesk32=/*#__PURE__*/React.forwardRef(function HelpDesk32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,10H21a3.0033,3.0033,0,0,0-3,3v6a2.0023,2.0023,0,0,0,2,2v7a2.0023,2.0023,0,0,0,2,2h4a2.0023,2.0023,0,0,0,2-2V21a2.0023,2.0023,0,0,0,2-2V13A3.0033,3.0033,0,0,0,27,10Zm1,9H26v9H22V19H20V13a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1Z"}),React.createElement("path",{d:"M20,5a4,4,0,1,1,4,4A4.0042,4.0042,0,0,1,20,5Zm2,0a2,2,0,1,0,2-2A2.0023,2.0023,0,0,0,22,5Z"}),React.createElement("path",{d:"M14,16V13a3.0033,3.0033,0,0,0-3-3H5a3.0033,3.0033,0,0,0-3,3v3H0v2H16V16ZM4,13a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1v3H4Z"}),React.createElement("path",{d:"M4,5A4,4,0,1,1,8,9,4.0042,4.0042,0,0,1,4,5ZM6,5A2,2,0,1,0,8,3,2.0023,2.0023,0,0,0,6,5Z"}),props.children);});var HelpDesk24=/*#__PURE__*/React.forwardRef(function HelpDesk24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,10H21a3.0033,3.0033,0,0,0-3,3v6a2.0023,2.0023,0,0,0,2,2v7a2.0023,2.0023,0,0,0,2,2h4a2.0023,2.0023,0,0,0,2-2V21a2.0023,2.0023,0,0,0,2-2V13A3.0033,3.0033,0,0,0,27,10Zm1,9H26v9H22V19H20V13a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1Z"}),React.createElement("path",{d:"M20,5a4,4,0,1,1,4,4A4.0042,4.0042,0,0,1,20,5Zm2,0a2,2,0,1,0,2-2A2.0023,2.0023,0,0,0,22,5Z"}),React.createElement("path",{d:"M14,16V13a3.0033,3.0033,0,0,0-3-3H5a3.0033,3.0033,0,0,0-3,3v3H0v2H16V16ZM4,13a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1v3H4Z"}),React.createElement("path",{d:"M4,5A4,4,0,1,1,8,9,4.0042,4.0042,0,0,1,4,5ZM6,5A2,2,0,1,0,8,3,2.0023,2.0023,0,0,0,6,5Z"}),props.children);});var HelpDesk20=/*#__PURE__*/React.forwardRef(function HelpDesk20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,10H21a3.0033,3.0033,0,0,0-3,3v6a2.0023,2.0023,0,0,0,2,2v7a2.0023,2.0023,0,0,0,2,2h4a2.0023,2.0023,0,0,0,2-2V21a2.0023,2.0023,0,0,0,2-2V13A3.0033,3.0033,0,0,0,27,10Zm1,9H26v9H22V19H20V13a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1Z"}),React.createElement("path",{d:"M20,5a4,4,0,1,1,4,4A4.0042,4.0042,0,0,1,20,5Zm2,0a2,2,0,1,0,2-2A2.0023,2.0023,0,0,0,22,5Z"}),React.createElement("path",{d:"M14,16V13a3.0033,3.0033,0,0,0-3-3H5a3.0033,3.0033,0,0,0-3,3v3H0v2H16V16ZM4,13a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1v3H4Z"}),React.createElement("path",{d:"M4,5A4,4,0,1,1,8,9,4.0042,4.0042,0,0,1,4,5ZM6,5A2,2,0,1,0,8,3,2.0023,2.0023,0,0,0,6,5Z"}),props.children);});var HelpDesk16=/*#__PURE__*/React.forwardRef(function HelpDesk16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M27,10H21a3.0033,3.0033,0,0,0-3,3v6a2.0023,2.0023,0,0,0,2,2v7a2.0023,2.0023,0,0,0,2,2h4a2.0023,2.0023,0,0,0,2-2V21a2.0023,2.0023,0,0,0,2-2V13A3.0033,3.0033,0,0,0,27,10Zm1,9H26v9H22V19H20V13a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1Z"}),React.createElement("path",{d:"M20,5a4,4,0,1,1,4,4A4.0042,4.0042,0,0,1,20,5Zm2,0a2,2,0,1,0,2-2A2.0023,2.0023,0,0,0,22,5Z"}),React.createElement("path",{d:"M14,16V13a3.0033,3.0033,0,0,0-3-3H5a3.0033,3.0033,0,0,0-3,3v3H0v2H16V16ZM4,13a1.0009,1.0009,0,0,1,1-1h6a1.0009,1.0009,0,0,1,1,1v3H4Z"}),React.createElement("path",{d:"M4,5A4,4,0,1,1,8,9,4.0042,4.0042,0,0,1,4,5ZM6,5A2,2,0,1,0,8,3,2.0023,2.0023,0,0,0,6,5Z"}),props.children);});var Help32=/*#__PURE__*/React.forwardRef(function Help32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("circle",{cx:"16",cy:"23.5",r:"1.5"}),React.createElement("path",{d:"M17,8H15.5A4.49,4.49,0,0,0,11,12.5V13h2v-.5A2.5,2.5,0,0,1,15.5,10H17a2.5,2.5,0,0,1,0,5H15v4.5h2V17a4.5,4.5,0,0,0,0-9Z"}),props.children);});var Help24=/*#__PURE__*/React.forwardRef(function Help24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("circle",{cx:"16",cy:"23.5",r:"1.5"}),React.createElement("path",{d:"M17,8H15.5A4.49,4.49,0,0,0,11,12.5V13h2v-.5A2.5,2.5,0,0,1,15.5,10H17a2.5,2.5,0,0,1,0,5H15v4.5h2V17a4.5,4.5,0,0,0,0-9Z"}),props.children);});var Help20=/*#__PURE__*/React.forwardRef(function Help20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z"}),React.createElement("circle",{cx:"16",cy:"23.5",r:"1.5"}),React.createElement("path",{d:"M17,8H15.5A4.49,4.49,0,0,0,11,12.5V13h2v-.5A2.5,2.5,0,0,1,15.5,10H17a2.5,2.5,0,0,1,0,5H15v4.5h2V17a4.5,4.5,0,0,0,0-9Z"}),props.children);});var Home32=/*#__PURE__*/React.forwardRef(function Home32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.61,2.21a1,1,0,0,0-1.24,0L1,13.42,2.24,15,4,13.62V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V13.63L29.76,15,31,13.43ZM18,26H14V18h4Zm2,0h0V18a2,2,0,0,0-2-2H14a2,2,0,0,0-2,2v8H6V12.06L16,4.27l10,7.8V26Z"}),props.children);});var Home24=/*#__PURE__*/React.forwardRef(function Home24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.61,2.21a1,1,0,0,0-1.24,0L1,13.42,2.24,15,4,13.62V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V13.63L29.76,15,31,13.43ZM18,26H14V18h4Zm2,0h0V18a2,2,0,0,0-2-2H14a2,2,0,0,0-2,2v8H6V12.06L16,4.27l10,7.8V26Z"}),props.children);});var Home20=/*#__PURE__*/React.forwardRef(function Home20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.61,2.21a1,1,0,0,0-1.24,0L1,13.42,2.24,15,4,13.62V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V13.63L29.76,15,31,13.43ZM18,26H14V18h4Zm2,0h0V18a2,2,0,0,0-2-2H14a2,2,0,0,0-2,2v8H6V12.06L16,4.27l10,7.8V26Z"}),props.children);});var Home16=/*#__PURE__*/React.forwardRef(function Home16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M16.61,2.21a1,1,0,0,0-1.24,0L1,13.42,2.24,15,4,13.62V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V13.63L29.76,15,31,13.43ZM18,26H14V18h4Zm2,0h0V18a2,2,0,0,0-2-2H14a2,2,0,0,0-2,2v8H6V12.06L16,4.27l10,7.8V26Z"}),props.children);});var Hotel32=/*#__PURE__*/React.forwardRef(function Hotel32(props,ref){return React.createElement(Icon,_extends({width:32,height:32,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.5,15A1.5,1.5,0,1,1,8,16.5,1.5,1.5,0,0,1,9.5,15m0-2A3.5,3.5,0,1,0,13,16.5,3.5,3.5,0,0,0,9.5,13Z"}),React.createElement("path",{d:"M25,14H17a2,2,0,0,0-2,2v6H4V10.6L16,4.14l12.53,6.74.94-1.76-13-7a1,1,0,0,0-.94,0l-13,7A1,1,0,0,0,2,10V30H4V24H28v6h2V19A5,5,0,0,0,25,14Zm-8,8V16h8a3,3,0,0,1,3,3v3Z"}),props.children);});var Hotel24=/*#__PURE__*/React.forwardRef(function Hotel24(props,ref){return React.createElement(Icon,_extends({width:24,height:24,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.5,15A1.5,1.5,0,1,1,8,16.5,1.5,1.5,0,0,1,9.5,15m0-2A3.5,3.5,0,1,0,13,16.5,3.5,3.5,0,0,0,9.5,13Z"}),React.createElement("path",{d:"M25,14H17a2,2,0,0,0-2,2v6H4V10.6L16,4.14l12.53,6.74.94-1.76-13-7a1,1,0,0,0-.94,0l-13,7A1,1,0,0,0,2,10V30H4V24H28v6h2V19A5,5,0,0,0,25,14Zm-8,8V16h8a3,3,0,0,1,3,3v3Z"}),props.children);});var Hotel20=/*#__PURE__*/React.forwardRef(function Hotel20(props,ref){return React.createElement(Icon,_extends({width:20,height:20,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.5,15A1.5,1.5,0,1,1,8,16.5,1.5,1.5,0,0,1,9.5,15m0-2A3.5,3.5,0,1,0,13,16.5,3.5,3.5,0,0,0,9.5,13Z"}),React.createElement("path",{d:"M25,14H17a2,2,0,0,0-2,2v6H4V10.6L16,4.14l12.53,6.74.94-1.76-13-7a1,1,0,0,0-.94,0l-13,7A1,1,0,0,0,2,10V30H4V24H28v6h2V19A5,5,0,0,0,25,14Zm-8,8V16h8a3,3,0,0,1,3,3v3Z"}),props.children);});var Hotel16=/*#__PURE__*/React.forwardRef(function Hotel16(props,ref){return React.createElement(Icon,_extends({width:16,height:16,viewBox:"0 0 32 32",ref:ref},props),React.createElement("path",{d:"M9.5,15A1.5,1.5,0,1,1,8,16.5,1.5,1.5,0,0,1,9.5,15m0-2A3.5,3.5,0,1,0,13,16.5,3.5,3.5,0,0,0,9.5,13Z"}),React.createElement("path",{d:"M25,14H17a2,2,0,0,0-2,2v6H4V10.6L16,4.14l12.53,6.74.94-1.76-13-7a1,1,0,0,0-.94,0l-13,7A1,1,0,0,0,2