export { CapabilityRegistration as Registration } from '../models/plugin';
export declare enum Media {
    Unknown = 0,
    Headless = 1,
    Electron = 2,
    Browser = 3
}
interface CredentialsMap {
    [key: string]: any;
}
export declare const setMedia: (media: Media) => void;
export declare const getMedia: () => Media;
export declare const isHeadless: () => boolean;
export declare const inElectron: () => boolean;
export declare const inBrowser: () => boolean;
export declare const hasProxy: () => boolean;
export declare const assertHasProxy: () => void;
export declare const setHasAuth: (provider: string, creds: object) => void;
export declare const getAuth: (provider: string) => any;
export declare const getAuthValue: (provider: string, key: string) => any;
export declare const getValidCredentials: () => CredentialsMap;
export declare const setValidCredentials: (creds: CredentialsMap) => void;
export declare const hasAuth: (provider: string) => boolean;
export declare const hasLocalAccess: () => boolean;
export declare const assertLocalAccess: () => void;
