import { CommandHandler, CommandOverrideHandler, CommandRegistrar, CommandTree, CommandTreeResolution, CatchAllOffer, Command, CommandOptions, KResponse, ParsedOptions } from '../models/command';
import { ExecOptions } from '../models/execOptions';
import { PluginResolver } from '../plugins/resolver';
export declare const setPluginResolver: (_: PluginResolver) => void;
export declare const read: <T extends import("../models/entity").Entity<any, import("..").Row, import("..").ResourceWithMetadata<any>>, O extends ParsedOptions>(root: CommandTree, argv: string[], noRetry: boolean, execOptions: ExecOptions, tryCatchalls?: boolean) => Promise<CommandTreeResolution<T, O>>;
export declare class ImplForPlugins implements CommandRegistrar {
    protected readonly plugin: string;
    constructor(plugin: string);
    catchall<T extends KResponse, O extends ParsedOptions>(offer: CatchAllOffer, handler: CommandHandler<T, O>, prio?: number, options?: CommandOptions): number;
    listen<T extends KResponse, O extends ParsedOptions>(route: string, handler: CommandHandler<T, O>, options?: CommandOptions): Command<T, O>;
    synonym<T extends KResponse, O extends ParsedOptions>(route: string, handler: CommandHandler<T, O>, master: Command<T, O>, options: CommandOptions): void;
    subtree<T extends KResponse, O extends ParsedOptions>(route: string, options: CommandOptions): Command<T, O>;
    subtreeSynonym<T extends KResponse, O extends ParsedOptions>(route: string, master: Command<T, O>, options?: CommandOptions): void;
    override<T extends KResponse, O extends ParsedOptions>(route: string, fromPlugin: string, overrideHandler: CommandOverrideHandler<T, O>, options?: CommandOptions): Promise<Command<T, O>>;
    find<T extends KResponse, O extends ParsedOptions>(route: string, fromPlugin?: string, noOverride?: boolean): Promise<Command<T, O>>;
}
export declare function proxy(plugin: string): CommandRegistrar;
