export { hasProxy, getValidCredentials, inBrowser, inElectron, isHeadless, assertLocalAccess, assertHasProxy, setHasAuth, getAuthValue } from './core/capabilities';
export { CapabilityRegistration } from './models/plugin';
export { CommandOptions, CommandLine, Evaluator, ExecType, KResponse, ParsedOptions, EvaluatorArgs as Arguments, Event, CommandRegistrar as Registrar } from './models/command';
export { optionsToString as unparse } from './core/utility';
export { MixedResponse, RawResponse, ResourceModification, isMetadataBearingByReference as isResourceByReference } from './models/entity';
export { isCommandHandlerWithEvents } from './models/command';
export { ExecOptions, withLanguage } from './models/execOptions';
export { Streamable } from './models/streamable';
export { CustomSpec as CustomResponse } from './webapp/views/sidecar-core';
export { EditorProvider, registerEditor } from './webapp/views/registrar/editors';
export { CodedError } from './models/errors';
export { isUsageError, UsageError, UsageModel, UsageRow } from './core/usage-error';
export { default as eventBus } from './core/events';
export { fromMap as i18nFromMap, default as i18n } from './util/i18n';
export { injectCSS, injectScript, loadHTML } from './webapp/util/inject';
export { MetadataBearing as ResourceWithMetadata } from './models/entity';
export { Watchable, Watcher, WatchPusher } from './core/jobs/watchable';
export { Abortable } from './core/jobs/job';
import { Tab } from './webapp/tab';
export declare function History(tab: Tab): Promise<import("./models/history").HistoryModel>;
export { prettyPrintTime } from './webapp/util/time';
export { default as stripAnsi } from './webapp/util/strip-ansi';
export { default as prettyPrintAnsi } from './webapp/util/pretty-print';
export declare function AsciiFormatters(): Promise<{
    formatUsage: (command: string, str: string, options?: import("./webapp/util/ascii-to-usage").Options) => import("./core/usage-error").UsageError;
    preprocessTable: (raw: string[]) => Promise<{
        rows?: import("./webapp/util/ascii-to-table").Pair[][];
        trailingString?: string;
    }[]>;
    formatTable: (entityType: string, lines: import("./webapp/util/ascii-to-table").Pair[][]) => import("./webapp/models/table").Table<import("./webapp/models/table").Row>;
}>;
export { SidecarMode as Mode } from './webapp/bottom-stripe';
export { SidecarModeFilter as ModeFilter, ModeRegistration, registerModeWhen, registerSidecarMode as registerMode } from './webapp/views/registrar/modes';
export { BadgeRegistration, registerSidecarBadge as registerBadge } from './webapp/views/registrar/badges';
export { Badge, BadgeSpec } from './webapp/views/badge';
export { PluginRegistration, PreloadRegistration, PreloadRegistrar } from './models/plugin';
export { split, _split, Split } from './repl/split';
export { ReplEval, DirectReplEval } from './repl/types';
export { default as encodeComponent } from './repl/encode';
export { getImpl as getReplImpl, exec as internalBeCarefulExec, pexec as internalBeCarefulPExec, setEvaluatorImpl } from './repl/exec';
export { isVisible as isSidecarVisible, isFullscreen as isSidecarFullscreen, hide as hideSidecar, show as showSidecar, toggleMaximization, clearSelection, currentSelection } from './webapp/views/sidecar-visibility';
export { SidecarState, getSidecarState } from './webapp/views/sidecar-state';
export { clearSelection as closeAllViews } from './webapp/views/sidecar-visibility';
export { default as sidecarSelector } from './webapp/views/sidecar-selector';
export { Tab, getTabFromTarget, getCurrentTab, getTabId, sameTab } from './webapp/tab';
export { default as TabState } from './models/tab-state';
export { default as Theme } from './webapp/themes/Theme';
export { findByName as findThemeByName } from './webapp/themes/find';
export { getDefault as getDefaultTheme } from './webapp/themes/default';
export { switchTo as switchToTheme, getPersistedThemeChoice, resetToDefault as resetToDefaultTheme } from './webapp/themes/persistence';
export { getPrompt, getCurrentPrompt, getCurrentPromptLeft, getBlockOfPrompt, setUsingCustomPrompt, unsetUsingCustomPrompt } from './webapp/prompt';
export { getCurrentBlock, getCurrentProcessingBlock, resetCount, setCustomCaret } from './webapp/block';
export { setStatus, Status } from './webapp/status';
export { listen as internalBeCarefulListen } from './webapp/listen';
export { disableInputQueueing, pasteQueuedInput } from './webapp/queueing';
export { clearPendingTextSelection, setPendingTextSelection, clearTextSelection } from './webapp/text-selection';
export { isPopup } from './webapp/popup-core';
export { removeAllDomChildren as empty } from './webapp/util/dom';
export { default as Presentation } from './webapp/views/presentation';
export { Button, Mode as MultiModalMode, MultiModalResponse } from './models/mmr/types';
export { ToolbarTextImpl as ToolbarText } from './webapp/views/toolbar-text';
export { partial as partialInput, isUsingCustomPrompt } from './webapp/prompt';
export { scrollIntoView } from './webapp/scroll';
export { default as doCancel } from './webapp/cancel';
export { default as ElementMimic } from './util/element-mimic';
export { keys as KeyCodes, isCursorMovement } from './webapp/keys';
export { buttonExists as topTabButtonExists, addIcon as topTabAddIcon, removeIcon as topTabRemoveIcon } from './webapp/views/top-tabs';
export { prompt } from './webapp/prompt-for-input';
export { commandsOffered as commandsOfferedByPlugin, userHome as pluginUserHome } from './api/plugins';
export { inBottomInputMode, userDataDir, uiThemes } from './core/settings';
export { default as Store } from './models/store';
export { default as SymbolTable } from './core/symbol-table';
export { TableStyle, Table, Row, Cell, isTable } from './webapp/models/table';
export { findFileWithViewer, findFile, isSpecialDirectory, addPath as augmentModuleLoadPath } from './core/find-file';
export { expandHomeDir } from './util/home';
export { flatten } from './core/utility';
export { promiseEach } from './util/async';
export { tellMain } from './webapp/electron-events';
export { main } from './main/main';
export { default as boot } from './webapp/bootstrap/boot';
export { TextWithIcon as StatusTextWithIcon, StatusStripeController } from './webapp/status-stripe';
