"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('core/main/headless-support');
debug('loading');
const readline_1 = require("readline");
exports.streamTo = () => __awaiter(void 0, void 0, void 0, function* () {
    const { print } = yield Promise.resolve().then(() => require('./headless-pretty-print'));
    return (response, killLine) => {
        debug('streaming response', killLine);
        if (killLine) {
            readline_1.clearLine(process.stdout, 0);
            readline_1.cursorTo(process.stdout, 0, null);
        }
        print(response);
        if (!killLine) {
            process.stdout.write('\n');
        }
        return Promise.resolve();
    };
});
//# sourceMappingURL=headless-support.js.map