import { Table, Row } from '../webapp/models/table';
import { CustomSpec } from '../webapp/views/sidecar';
import { ToolbarText } from '../webapp/views/toolbar-text';
import { UsageModel } from '../core/usage-error';
import { MultiModalResponse } from './mmr/types';
export interface MessageBearingEntity {
    message: string;
}
export declare function isMessageBearingEntity(entity: Entity): entity is MessageBearingEntity;
interface MetadataNamedResource {
    kind?: string;
    metadata?: {
        name: string;
        namespace?: string;
        generation?: string;
        creationTimestamp?: string;
    };
}
export interface MetadataBearing<Content = void> extends MetadataNamedResource {
    apiVersion?: string;
    version?: string;
    prettyName?: string;
    nameHash?: string;
    onclick?: {
        name?: string;
        nameHash?: string;
        namespace?: string;
    };
    content?: Content;
    contentType?: string;
    toolbarText?: ToolbarText;
}
export declare function isMetadataBearing(spec: MetadataBearing | Entity): spec is MetadataBearing;
export interface WithDisplayName extends MetadataBearing {
    spec: {
        displayName: string;
    };
}
export declare function hasDisplayName(resource: MetadataBearing): resource is WithDisplayName;
export interface MetadataBearingByReference<Content = void> extends CustomSpec<Content> {
    resource: MetadataBearing<Content>;
}
export declare function isMetadataBearingByReference(spec: MetadataBearing | MetadataBearingByReference | Entity): spec is MetadataBearingByReference;
export declare type SimpleEntity = boolean | string | number | HTMLElement | MessageBearingEntity | Error;
export declare type MixedResponsePart = string | Table | HTMLElement;
export declare type MixedResponse = MixedResponsePart[];
export declare function isMixedResponse(response: Entity): response is MixedResponse;
export interface LowLevelLoop {
    mode: 'prompt';
}
export declare function isLowLevelLoop(entity: Entity): entity is LowLevelLoop;
declare type Complete<T> = {
    [P in keyof Required<T>]: Pick<T, P> extends Required<Pick<T, P>> ? T[P] : (T[P] | undefined);
};
export declare type ResourceModification = Complete<MetadataNamedResource> & {
    verb: 'delete';
};
export declare function isResourceModification(entity: Entity): entity is ResourceModification;
export declare type RawContent = any;
export interface RawResponse<Content extends RawContent> {
    mode: 'raw';
    content: Content;
}
export declare function isRawResponse<Content extends RawContent>(entity: Entity<Content>): entity is RawResponse<Content>;
export declare type Entity<Content = void, RowType extends Row = Row, Meta extends MetadataBearing<Content> = MetadataBearing<Content>> = SimpleEntity | Table<RowType> | ResourceModification | CustomSpec | MixedResponse | MultiModalResponse | LowLevelLoop | UsageModel | Meta | RawResponse<Content>;
export {};
