"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const command_1 = require("./command");
function hasLanguage(execOptions) {
    return execOptions.language !== undefined;
}
exports.hasLanguage = hasLanguage;
function withLanguage(execOptions) {
    if (hasLanguage(execOptions)) {
        return execOptions;
    }
    else {
        return Object.assign({}, execOptions, { language: typeof navigator !== 'undefined' && navigator.language });
    }
}
exports.withLanguage = withLanguage;
class DefaultExecOptions {
    constructor(type = command_1.ExecType.TopLevel) {
        this.type = type;
        this.language = typeof navigator !== 'undefined' && navigator.language;
    }
}
exports.DefaultExecOptions = DefaultExecOptions;
class DefaultExecOptionsForTab extends DefaultExecOptions {
    constructor(tab) {
        super();
        this.tab = tab;
    }
}
exports.DefaultExecOptionsForTab = DefaultExecOptionsForTab;
//# sourceMappingURL=execOptions.js.map