"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const table_1 = require("../../webapp/models/table");
const custom_content_1 = require("../../webapp/views/custom-content");
const types_1 = require("../../util/types");
function isScalarContent(entity) {
    const content = entity.content;
    return (content !== undefined &&
        (typeof content === 'string' || table_1.isTable(content) || types_1.isHTML(content) || custom_content_1.isCustomSpec(content)));
}
exports.isScalarContent = isScalarContent;
function isSupportedContentType(contentType) {
    return (contentType === 'yaml' || contentType === 'text/markdown' || contentType === 'text/html' || contentType === 'json');
}
function isStringWithOptionalContentType(entity) {
    const str = entity;
    return (str && typeof str.content === 'string' && (str.contentType === undefined || typeof str.contentType === 'string'));
}
exports.isStringWithOptionalContentType = isStringWithOptionalContentType;
function isFunctionContent(content) {
    const func = content;
    return !!func && !!func.content && typeof func.content === 'function';
}
exports.isFunctionContent = isFunctionContent;
function isCommandStringContent(content) {
    const command = content;
    return (!!command &&
        typeof command.contentFrom === 'string' &&
        (command.contentType === undefined || isSupportedContentType(command.contentType)));
}
exports.isCommandStringContent = isCommandStringContent;
function hasContent(resource) {
    return Object.prototype.hasOwnProperty.call(resource, 'content') || isCommandStringContent(resource);
}
exports.hasContent = hasContent;
//# sourceMappingURL=content-types.js.map