import { Tab } from '../../webapp/tab';
import { Content } from './content-types';
import { MetadataBearing } from '../entity';
import { ParsedOptions } from '../command';
import { SelectionController, SidecarMode } from '../../webapp/bottom-stripe';
export declare type MultiModalResponse<Resource = MetadataBearing> = Resource & View<Resource>;
interface View<Resource extends MetadataBearing> {
    modes: Mode<Resource>[];
    buttons?: Button<Resource>[];
    defaultMode?: string;
}
export declare type Mode<T = MetadataBearing> = Label & ModeTraits & VisibilityTraits & Content<T>;
export interface ModeTraits {
    defaultMode?: boolean;
    order?: number;
    priority?: number;
}
export declare type DrilldownButton<T = MetadataBearing> = Label & ModeTraits & VisibilityTraits & {
    command: string | ((tab: Tab, resource: T, args: {
        argvNoOptions: string[];
        parsedOptions: ParsedOptions;
    }) => string);
    confirm?: boolean;
    kind: 'drilldown';
};
export declare type ViewButton<T = MetadataBearing> = Label & ModeTraits & VisibilityTraits & {
    kind: 'view';
    command: (tab: Tab, resource: T, args: {
        argvNoOptions: string[];
        parsedOptions: ParsedOptions;
    }) => void;
};
export declare function isViewButton<T = MetadataBearing>(button: Button<T>): button is ViewButton<T>;
export declare type Button<T = MetadataBearing> = DrilldownButton<T> | ViewButton<T>;
export declare function isButton<T extends MetadataBearing>(mode: Button<T> | Content<T> | SidecarMode): mode is Button<T>;
export interface Label {
    mode: string;
    label?: string;
    balloon?: string;
    balloonLength?: string;
    fontawesome?: string;
    labelBelow?: string;
}
export interface VisibilityTraits {
    visibleWhen?: string;
    selected?: boolean;
    selectionController?: SelectionController;
}
export {};
