"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const capabilities_1 = require("../core/capabilities");
const prompt_1 = require("../webapp/prompt");
const settings_1 = require("../core/settings");
const limits_json_1 = require("@kui-shell/client/config.d/limits.json");
const debug = debug_1.default('core/models/TabState');
class TabState {
    constructor() {
        this._ageCounter = 0;
        this._currentBottomInputValue = '';
    }
    get env() {
        return this._env;
    }
    get cwd() {
        return this._cwd;
    }
    get currentBottomInputValue() {
        return this._currentBottomInputValue;
    }
    capture() {
        this._env = Object.assign({}, process.env);
        this._cwd = capabilities_1.inBrowser() ? process.env.PWD : process.cwd().slice(0);
        if (settings_1.inBottomInputMode) {
            this._currentBottomInputValue = prompt_1.getCurrentPrompt().value;
        }
        debug('captured tab state', this.cwd);
    }
    get jobs() {
        return !this._jobs ? 0 : this._jobs.filter(_ => _ !== undefined).length;
    }
    abortOldestJob() {
        const oldestSlot = this._age.reduce((minAgeIdx, age, idx, ages) => {
            if (minAgeIdx === -1) {
                return idx;
            }
            else if (ages[minAgeIdx] > age) {
                return idx;
            }
            else {
                return minAgeIdx;
            }
        }, -1);
        this._jobs[oldestSlot].abort();
        return oldestSlot;
    }
    findFreeJobSlot() {
        const idx = this._jobs.findIndex(_ => _ === undefined);
        if (idx === -1) {
            return this.abortOldestJob();
        }
        else {
            return idx;
        }
    }
    captureJob(job) {
        if (!this._jobs) {
            const maxJobs = limits_json_1.maxWatchersPerTab;
            this._jobs = new Array(maxJobs);
            this._age = new Array(maxJobs);
        }
        const slot = this.findFreeJobSlot();
        this._jobs[slot] = job;
        this._age[slot] = this._ageCounter++;
    }
    abortAllJobs() {
        if (this._jobs) {
            this._jobs.forEach((job, idx) => {
                this.abortAt(idx);
            });
        }
    }
    abortAt(idx) {
        this._jobs[idx].abort();
        this.clearAt(idx);
    }
    clearAt(idx) {
        this._jobs[idx] = undefined;
        this._age[idx] = undefined;
    }
    restore() {
        process.env = this._env;
        if (capabilities_1.inBrowser()) {
            debug('changing cwd', process.env.PWD, this._cwd);
            process.env.PWD = this._cwd;
        }
        else {
            debug('changing cwd', process.cwd(), this._cwd);
            process.chdir(this._cwd);
        }
        if (settings_1.inBottomInputMode) {
            prompt_1.getCurrentPrompt().value = this.currentBottomInputValue;
        }
    }
}
exports.default = TabState;
//# sourceMappingURL=tab-state.js.map