"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('core/plugins');
debug('loading');
const preloader_1 = require("./preloader");
const resolver_1 = require("./resolver");
const prescan_1 = require("./prescan");
const userdata_1 = require("../core/userdata");
const capabilities_1 = require("../core/capabilities");
const command_tree_1 = require("../core/command-tree");
debug('modules loaded');
exports.pluginRoot = '../../../../plugins';
exports.registrar = {};
let basePrescan;
let prescan;
function prescanModel() {
    if (!prescan) {
        return require('@kui-shell/prescan.json');
    }
    return prescan;
}
exports.prescanModel = prescanModel;
function _useUpdatedUserPrescan(userPrescan) {
    debug('useUpdatedUserPrescan', userPrescan, basePrescan);
    prescan = prescan_1.unify(basePrescan, userPrescan);
    command_tree_1.setPluginResolver(resolver_1.makeResolver(prescan, exports.registrar));
}
exports._useUpdatedUserPrescan = _useUpdatedUserPrescan;
exports.preload = () => {
    preloader_1.default(prescan);
};
function userInstalledHome() {
    return __awaiter(this, void 0, void 0, function* () {
        const { join } = yield Promise.resolve().then(() => require('path'));
        const rootDir = userdata_1.userDataDir();
        return join(rootDir, 'plugins');
    });
}
exports.userInstalledHome = userInstalledHome;
exports.init = () => __awaiter(void 0, void 0, void 0, function* () {
    debug('init');
    if (prescan) {
        return false;
    }
    try {
        prescan = (yield Promise.resolve().then(() => require('@kui-shell/prescan.json')));
        basePrescan = prescan;
        debug('pre-installed prescan loaded');
    }
    catch (err) {
        console.error('prescanned does not exist or is not valid JSON', err);
    }
    if (capabilities_1.isHeadless() && prescan) {
        try {
            const [{ existsSync }, { join }] = yield Promise.all([Promise.resolve().then(() => require('fs')), Promise.resolve().then(() => require('path'))]);
            const userPath = join(yield userInstalledHome(), 'node_modules/@kui-shell/prescan.json');
            if (existsSync(userPath)) {
                const userInstalledPrescan = (yield Promise.resolve().then(() => require(userPath)));
                prescan = prescan_1.unify(prescan, userInstalledPrescan);
            }
            debug('user-installed prescan loaded', prescan);
        }
        catch (err) {
            console.error('error loading user-installed prescan', err);
        }
    }
    command_tree_1.setPluginResolver(resolver_1.makeResolver(prescan, exports.registrar));
    debug('init done');
    return true;
});
debug('done loading');
//# sourceMappingURL=plugins.js.map