"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const path_1 = require("./path");
const command_tree_1 = require("../core/command-tree");
const capabilities_1 = require("../core/capabilities");
const debug = debug_1.default('core/plugins/resolver');
const prequire = (route, prescan, registrar, options) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        if (!Object.prototype.hasOwnProperty.call(registrar, route)) {
            registrar[route] = new Promise((resolve, reject) => __awaiter(void 0, void 0, void 0, function* () {
                const module = prescan.flat.find(_ => _.route === route);
                if (module) {
                    try {
                        const registrationRef = module.path.charAt(0) === '/'
                            ? yield Promise.resolve().then(() => require(module.path))
                            : capabilities_1.isHeadless()
                                ? yield Promise.resolve().then(() => require(path_1.mainPath(module.path)))
                                : yield Promise.resolve().then(() => require('@kui-shell/plugin-' + path_1.webpackPath(module.route) + '/mdist/plugin'));
                        const registration = registrationRef.default || registrationRef;
                        const combinedOptions = Object.assign({ usage: prescan.usage, docs: prescan.docs }, options);
                        resolve(registration(command_tree_1.proxy(route), combinedOptions));
                    }
                    catch (err) {
                        console.error(`prequire error ${route}`, err);
                        reject(err);
                    }
                }
                else {
                    reject(new Error(`Internal error: plugin ${route} not found`));
                }
            }));
        }
    }
    catch (err) {
        debug('prequire failure', route);
        console.error(err);
    }
    return registrar[route];
});
exports.makeResolver = (prescan, registrar) => {
    const isResolved = {};
    const resolveOne = (plugin) => __awaiter(void 0, void 0, void 0, function* () {
        try {
            if (!plugin) {
                return;
            }
            else if (!isResolved[plugin]) {
                isResolved[plugin] = new Promise((resolve, reject) => __awaiter(void 0, void 0, void 0, function* () {
                    try {
                        const prereqs = prescan.topological[plugin];
                        if (prereqs) {
                            yield Promise.all(prereqs.map(route => prequire(route, prescan, registrar)));
                        }
                        const loadedPlugin = prequire(plugin, prescan, registrar);
                        resolve(loadedPlugin);
                    }
                    catch (err) {
                        console.error(`Error resolving plugin ${plugin}`, err);
                        reject(err);
                    }
                }));
            }
            return isResolved[plugin];
        }
        finally {
        }
    });
    const resolver = {
        isOverridden: (route) => prescan.overrides[route] !== undefined,
        isAlpha: (route, plugin) => prescan.overrides[route] === undefined || prescan.overrides[route] === plugin,
        resolveOne,
        disambiguate: (command) => {
            return prescan.disambiguator[command];
        },
        disambiguatePartial: (partial) => {
            const matches = [];
            if (prescan.disambiguator) {
                for (const command in prescan.disambiguator) {
                    if (command.indexOf(partial) === 0) {
                        matches.push(command);
                    }
                }
            }
            return matches;
        },
        resolve: (command, { subtree = false, tryCatchalls = true } = {}) => __awaiter(void 0, void 0, void 0, function* () {
            let plugin;
            let matchLen;
            for (const route in prescan.commandToPlugin) {
                if (route === command) {
                    plugin = prescan.commandToPlugin[route];
                    break;
                }
                else if (subtree ? route.indexOf(command) === 0 : command.indexOf(`${route}/`) === 0) {
                    if (!matchLen || route.length > matchLen) {
                        plugin = prescan.commandToPlugin[route];
                        matchLen = route.length;
                    }
                }
            }
            if (plugin) {
                yield resolveOne(plugin);
            }
            else if (prescan.catchalls.length > 0 && tryCatchalls) {
                yield Promise.all(prescan.catchalls.map(_ => resolveOne(_.plugin))).catch(err => {
                    console.error('There seems to be an inconsistency in the prescan model versus the current state of the filesystem: the prescan model refers to a catchall that cannot currently be found', err);
                });
            }
        })
    };
    return resolver;
};
//# sourceMappingURL=resolver.js.map