import { Executor, ReplEval } from './types';
import { EvaluatorArgs } from '../models/command';
import REPL from '../models/repl';
import { RawResponse, MixedResponse } from '../models/entity';
import { ExecOptions } from '../models/execOptions';
import { CodedError } from '../models/errors';
import { UsageModel } from '../core/usage-error';
import { Tab } from '../webapp/tab';
export declare const setEvaluatorImpl: (impl: ReplEval) => void;
declare type OopsHandler = (block: HTMLElement, nextBlock: HTMLElement) => (err: Error) => void;
export declare const installOopsHandler: (fn: OopsHandler) => void;
export declare const exec: (commandUntrimmed: string, execOptions?: ExecOptions) => Promise<string | number | boolean | HTMLElement | import("../models/entity").MessageBearingEntity | Error | import("../models/entity").ResourceModification | import("../webapp/views/sidecar-core").CustomSpec<void> | MixedResponse | import("..").MultiModalResponse<import("../models/entity").MetadataBearing<void>> | import("../models/entity").LowLevelLoop | UsageModel | import("..").Table<import("..").Row> | import("../models/entity").MetadataBearing<any> | RawResponse<any> | CodedError<number>>;
export declare const doEval: ({ block, prompt }?: {
    block?: import("../webapp/models/block").Block;
    prompt?: import("../webapp/prompt").Prompt;
}) => Promise<string | number | boolean | HTMLElement | import("../models/entity").MessageBearingEntity | Error | import("../models/entity").ResourceModification | import("../webapp/views/sidecar-core").CustomSpec<void> | MixedResponse | import("..").MultiModalResponse<import("../models/entity").MetadataBearing<void>> | import("../models/entity").LowLevelLoop | UsageModel | import("..").Table<import("..").Row> | import("../models/entity").MetadataBearing<any> | RawResponse<any> | CodedError<number>>;
export declare const qexec: <T extends import("../models/entity").Entity<any, import("..").Row, import("../models/entity").MetadataBearing<any>>>(command: string, block?: boolean | HTMLElement, contextChangeOK?: boolean, execOptions?: ExecOptions, nextBlock?: HTMLElement) => Promise<T>;
export declare const qfexec: (command: string, block?: HTMLElement, nextBlock?: HTMLElement, execOptions?: ExecOptions) => Promise<any>;
export declare const rexec: <Raw extends any>(command: string, execOptions?: ExecOptions) => Promise<RawResponse<Raw>>;
export declare const pexec: <T extends import("../models/entity").Entity<any, import("..").Row, import("../models/entity").MetadataBearing<any>>>(command: string, execOptions?: ExecOptions) => Promise<T>;
export declare const click: (command: string | (() => Promise<string>), evt: MouseEvent) => Promise<void>;
export declare const setExecutorImpl: (impl: Executor) => void;
export declare function semicolonInvoke(opts: EvaluatorArgs): Promise<MixedResponse>;
export declare function getImpl(tab: Tab): REPL;
export {};
