import { CodedError } from '../models/errors';
import { ExecOptions } from '../models/execOptions';
import { Evaluator, EvaluatorArgs, KResponse, ParsedOptions } from '../models/command';
export interface Executor {
    name: string;
    exec<T extends KResponse, O extends ParsedOptions>(commandUntrimmed: string, execOptions: ExecOptions): Promise<T | CodedError<number> | HTMLElement>;
}
export interface ReplEval {
    name: string;
    apply<T extends KResponse, O extends ParsedOptions>(commandUntrimmed: string, execOptions: ExecOptions, evaluator: Evaluator<T, O>, args: EvaluatorArgs<O>): T | Promise<T>;
}
export declare class DirectReplEval implements ReplEval {
    name: string;
    apply<T extends KResponse, O extends ParsedOptions>(commandUntrimmed: string, execOptions: ExecOptions, evaluator: Evaluator<T, O>, args: EvaluatorArgs<O>): T | Promise<T>;
}
