"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("../../core/events");
const nope = (event) => {
    event.preventDefault();
    return false;
};
const disableDragAndDrop = () => {
    document.addEventListener('dragover', nope, false);
    document.addEventListener('drop', nope, false);
};
function setDefaultCommandContext() {
    return __awaiter(this, void 0, void 0, function* () {
        const { extractSearchKey } = yield Promise.resolve().then(() => require('../util/search'));
        const contextString = process.env.KUI_CONTEXT ||
            (typeof window !== 'undefined' && window.location && window.location.search && extractSearchKey('command-context'));
        if (contextString) {
            try {
                const context = JSON.parse(contextString);
                const { setDefaultCommandContext: setDefault } = yield Promise.resolve().then(() => require('../../commands/context'));
                setDefault(context);
                return;
            }
            catch (err) {
                console.error('Error parsing KUI_CONTEXT', err);
            }
        }
    });
}
function inBrowser() {
    return document.body.classList.contains('not-electron');
}
exports.init = () => __awaiter(void 0, void 0, void 0, function* () {
    const waitForThese = [];
    events_1.default.emit('/window/init');
    disableDragAndDrop();
    waitForThese.push(setDefaultCommandContext());
    window.addEventListener('beforeunload', () => {
        events_1.default.emit('/window/reload');
    });
    waitForThese.push(Promise.resolve().then(() => require('../themes/init')).then(_ => _.default()));
    yield Promise.all(waitForThese);
    if (!inBrowser()) {
        yield Promise.resolve().then(() => require('./init-electron')).then(_ => _.init());
    }
});
exports.preinit = () => __awaiter(void 0, void 0, void 0, function* () {
    let prefs = {};
    document.body.classList.add(`os-${process.platform}`);
    if (!inBrowser()) {
        prefs = yield Promise.resolve().then(() => require('./init-electron')).then(_ => _.preinit());
    }
    return prefs;
});
//# sourceMappingURL=init.js.map