"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('webapp/electron-events');
debug('loading');
const capabilities_1 = require("../core/capabilities");
const listenForRemoteEvents = (ipcRenderer) => {
    debug('listenForRemoteEvents');
    if (capabilities_1.inElectron() && ipcRenderer) {
        ipcRenderer.on('/repl/pexec', (event, { command }) => __awaiter(void 0, void 0, void 0, function* () {
            debug('remote pexec', command);
            const { pexec } = yield Promise.resolve().then(() => require('../repl/exec'));
            return pexec(command);
        }));
        ipcRenderer.on('/repl/qexec', (event, { command }) => __awaiter(void 0, void 0, void 0, function* () {
            debug('remote qexec', command);
            const { qexec } = yield Promise.resolve().then(() => require('../repl/exec'));
            return qexec(command);
        }));
    }
};
const initializeIPC = () => __awaiter(void 0, void 0, void 0, function* () {
    debug('initializeIPC');
    const electron = yield Promise.resolve().then(() => require('electron'));
    const ipcRenderer = electron.ipcRenderer;
    capabilities_1.setMedia(capabilities_1.Media.Electron);
    return { ipcRenderer };
});
exports.tellMain = (message, channel) => new Promise((resolve, reject) => __awaiter(void 0, void 0, void 0, function* () {
    const electron = yield Promise.resolve().then(() => require('electron'));
    const ipcRenderer = electron.ipcRenderer;
    ipcRenderer[channel === 'asynchronous-message' ? 'send' : 'sendSync'](channel || 'synchronous-message', typeof message === 'string' ? JSON.stringify({ operation: message }) : JSON.stringify(message));
    if (channel === 'asynchronous-message') {
        console.log('listening');
        ipcRenderer.on('asynchronous-reply', (event, response) => {
            console.log('got response', response);
            if (response === 'true') {
                resolve(true);
            }
            else {
                reject(response);
            }
        });
    }
    else {
        resolve(true);
    }
}));
exports.init = (prefs = {}) => {
    return initializeIPC().then(({ ipcRenderer }) => {
        listenForRemoteEvents(ipcRenderer);
    });
};
//# sourceMappingURL=electron-events.js.map