"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const tab_1 = require("./tab");
const prompt_1 = require("./prompt");
exports.doPaste = (text, tab = tab_1.getCurrentTab()) => {
    const lines = text.split(/[\n\r]/);
    const pasteLooper = (idx) => __awaiter(void 0, void 0, void 0, function* () {
        if (idx === lines.length) {
            return Promise.resolve();
        }
        else if (idx <= lines.length - 2) {
            const prompt = prompt_1.getCurrentPrompt(tab);
            const { pexec } = yield Promise.resolve().then(() => require('../repl/exec'));
            yield pexec(prompt.value + lines[idx]);
            pasteLooper(idx + 1);
        }
        else {
            const prompt = prompt_1.getCurrentPrompt(tab);
            const newCaretPosition = prompt.selectionStart + lines[idx].length;
            prompt.value =
                prompt.value.substring(0, prompt.selectionStart) + lines[idx] + prompt.value.substring(prompt.selectionEnd);
            prompt.setSelectionRange(newCaretPosition, newCaretPosition);
            return Promise.resolve();
        }
    });
    return pasteLooper(0);
};
exports.paste = (event) => {
    const text = event.clipboardData.getData('text');
    if (text) {
        event.preventDefault();
        return exports.doPaste(text);
    }
};
//# sourceMappingURL=paste.js.map