"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('webapp/popup');
debug('loading');
const tab_1 = require("./tab");
const dom_1 = require("./util/dom");
const presentation_1 = require("./views/presentation");
const sidecar_present_1 = require("./views/sidecar-present");
exports.renderPopupContent = (command, container, execOptions, entity = {}) => __awaiter(void 0, void 0, void 0, function* () {
    const { prettyType: _prettyType, modes = [], badges = [], controlHeaders = false, presentation = presentation_1.default.SidecarFullscreenForPopups } = entity;
    const prettyType = !_prettyType || _prettyType === 'custom' ? process.env.KUI_DEFAULT_PRETTY_TYPE || command : _prettyType;
    debug('renderPopupContent', command, entity, prettyType);
    const { prettyPrintTime } = yield Promise.resolve().then(() => require('./util/time'));
    const subtext = document.createElement('div');
    subtext.appendChild(document.createTextNode('Last updated '));
    const date = document.createElement('strong');
    const now = new Date();
    date.appendChild(prettyPrintTime(now));
    subtext.appendChild(date);
    const millisPerDay = 24 * 60 * 60 * 1000;
    const midnight = new Date(now.getFullYear(), now.getMonth(), now.getDate(), 0, 0, 0, 0);
    const millisSinceMidnight = now.getTime() - midnight.getTime();
    const millisTillMidnight = millisPerDay - millisSinceMidnight;
    const updateLastUpdateDate = () => {
        dom_1.removeAllDomChildren(date);
        date.appendChild(prettyPrintTime(now));
    };
    const updateLastUpdateDateFirstTime = () => {
        updateLastUpdateDate();
        setInterval(updateLastUpdateDate, millisPerDay);
    };
    setTimeout(updateLastUpdateDateFirstTime, millisTillMidnight);
    if (container) {
        if (container.parentNode.classList.contains('result-as-multi-table')) {
            ;
            container.parentNode.parentNode.classList.add('overflow-auto');
        }
        const custom = {
            type: 'custom',
            metadata: {
                name: command
            },
            isREPL: true,
            presentation,
            prettyType,
            subtext,
            modes,
            badges,
            controlHeaders,
            content: container.parentNode.parentNode
        };
        const { showCustom } = yield Promise.resolve().then(() => require('./views/sidecar'));
        showCustom(tab_1.getCurrentTab(), Object.assign({}, custom, entity, { prettyType }), execOptions);
    }
});
exports.createPopupContentContainer = (css = [], presentation) => {
    const container = document.createElement('div');
    container.classList.add('padding-content');
    const scrollRegion = document.createElement('div');
    scrollRegion.classList.add('repl-block');
    css.forEach(_ => scrollRegion.classList.add(_));
    container.appendChild(scrollRegion);
    if (presentation || presentation === 0) {
        sidecar_present_1.default(tab_1.getCurrentTab(), presentation);
    }
    const resultDom = document.createElement('div');
    resultDom.classList.add('repl-result');
    scrollRegion.appendChild(resultDom);
    return resultDom;
};
//# sourceMappingURL=popup.js.map