"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('webapp/cli/prompt-for-input');
debug('loading');
const keys_1 = require("./keys");
const oops_1 = require("./oops");
const listen_1 = require("./listen");
const prompt_1 = require("./prompt");
const status_1 = require("./status");
const block_1 = require("./block");
const print_1 = require("./print");
function isRequestingReprompt(spec) {
    return spec.reprompt;
}
exports.prompt = (msg, block, nextBlock, tab, options, completion) => {
    debug('prompt', options);
    const selection = block.querySelector('.repl-selection');
    const promptDom = prompt_1.getPrompt(block);
    const resultDom = block.querySelector('.repl-result');
    const currentSelection = selection.innerText;
    const currentType = promptDom.getAttribute('type');
    const currentInput = promptDom.value;
    const currentPlaceholder = promptDom.getAttribute('placeholder');
    listen_1.listen(promptDom);
    block.className = `${block.getAttribute('data-base-class')} repl-active`;
    selection.innerText = '';
    promptDom.readOnly = false;
    promptDom.value = '';
    promptDom.setAttribute('placeholder', options.placeholder || `Enter your ${msg}`);
    if (options.onpaste === 'capture') {
        debug('setting up for paste capture');
        const textarea = document.createElement('textarea');
        textarea.style.opacity = '0%';
        textarea.style.position = 'absolute';
        textarea.style.left = '-1000px';
        textarea.style.top = '-1000px';
        document.body.appendChild(textarea);
        textarea.focus();
        promptDom.onpaste = () => true;
        const currentGlobalHandler = document.body.onpaste;
        document.body.onpaste = () => true;
        textarea.onkeypress = event => {
            const char = event.keyCode;
            if (char === keys_1.keys.ENTER) {
                block.completion(textarea.value);
            }
        };
        textarea.onpaste = event => {
            const text = event.clipboardData.getData('text');
            debug('capturing paste for repl.prompt', text);
            block.completion(text);
            document.body.removeChild(textarea);
            document.body.onpaste = currentGlobalHandler;
            event.stopPropagation();
            return false;
        };
    }
    else if (typeof options.paste === 'function') {
        promptDom.onpaste = options.paste;
    }
    if (options.type) {
        promptDom.setAttribute('type', options.type);
    }
    const restorePrompt = (err) => {
        status_1.setStatus(block, "valid-response");
        selection.innerText = currentSelection;
        promptDom.value = currentInput;
        promptDom.setAttribute('type', currentType);
        if (currentPlaceholder) {
            promptDom.setAttribute('placeholder', currentPlaceholder);
        }
        else {
            promptDom.removeAttribute('placeholder');
        }
        if (err) {
            console.error(err);
        }
    };
    block.restorePrompt = restorePrompt;
    block.completion = (value) => {
        block.className = `${block.getAttribute('data-base-class')} processing`;
        listen_1.unlisten(promptDom);
        const completer = completion(Object.assign({}, options, { field: value }));
        if (isRequestingReprompt(completer)) {
            restorePrompt();
            return exports.prompt(msg, block, nextBlock, tab, completer, completer.completion);
        }
        else {
            completer
                .then(response => {
                return print_1.printResults(block, nextBlock, tab, resultDom)(response);
            })
                .then(() => undefined)
                .then(restorePrompt)
                .then(block_1.installBlock(block.parentNode, block, nextBlock))
                .catch((err) => {
                restorePrompt();
                oops_1.oops('', block, nextBlock)(err);
            });
        }
    };
    return { mode: 'prompt' };
};
//# sourceMappingURL=prompt-for-input.js.map