"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function isScrollIntoViewable(element) {
    return Object.prototype.hasOwnProperty.call(element, 'scrollIntoViewIfNeeded');
}
exports.scrollIntoView = (opts) => {
    const { when = 305, which = '.repl-active', element = document.querySelector(`tab.visible .repl ${which}`), center = undefined, how = 'scrollIntoViewIfNeeded' } = opts || {};
    const scroll = () => {
        if (element) {
            if (how === 'scrollIntoViewIfNeeded' && isScrollIntoViewable(element)) {
                ;
                element.scrollIntoViewIfNeeded(!!center);
            }
            else {
                element.scrollIntoView(center || { block: 'end', inline: 'end' });
            }
        }
    };
    if (when === 0) {
        scroll();
    }
    else {
        return setTimeout(scroll, when);
    }
};
//# sourceMappingURL=scroll.js.map