"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('webapp/cli/status');
debug('loading');
const prompt_1 = require("./prompt");
const scroll_1 = require("./scroll");
const queueing_1 = require("./queueing");
const tab_1 = require("./tab");
const dom_1 = require("./util/dom");
const capabilities_1 = require("../core/capabilities");
const settings_1 = require("../core/settings");
exports.setStatus = (block, status) => {
    if (block) {
        block.classList.remove("processing");
        block.classList.remove("repl-active");
        block.classList.remove("valid-response");
        block.classList.remove("error");
        block.classList.add(status);
        if (status === "processing") {
            queueing_1.startInputQueueing(tab_1.getTabFromTarget(block));
            if (!capabilities_1.isHeadless()) {
                const spinner = dom_1.element('.repl-result-spinner', block);
                scroll_1.scrollIntoView({ when: 0, element: spinner });
            }
        }
        else if (status === "repl-active") {
            prompt_1.getPrompt(block).value = '';
        }
        if (status !== "repl-active" && settings_1.inBottomInputMode) {
            const prompt = prompt_1.getPrompt(block);
            if (!prompt.value) {
                prompt.value = prompt_1.getBottomPrompt().value;
            }
        }
        dom_1.element('.repl-prompt-timestamp', block).innerText = new Date().toLocaleTimeString();
        dom_1.element('.kui--repl-prompt-buttons--screenshot', block).onclick = (event) => __awaiter(void 0, void 0, void 0, function* () {
            event.stopPropagation();
            const N = parseInt(block.getAttribute('data-input-count'), 10) + 1;
            const { qexec } = yield Promise.resolve().then(() => require('../repl/exec'));
            debug(`capturing screenshot for block ${N}`);
            qexec(`screenshot --nth ${N}`, undefined, undefined, {
                rethrowErrors: true,
                reportErrors: true
            });
        });
    }
};
//# sourceMappingURL=status.js.map