"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.clearTextSelection = () => {
    try {
        window.getSelection().removeAllRanges();
    }
    catch (err) {
        console.error('unable to clear text selection', err);
    }
};
let pendingTextSelection;
exports.clearPendingTextSelection = () => {
    pendingTextSelection = undefined;
};
exports.setPendingTextSelection = (str) => {
    pendingTextSelection = str;
    if (!document.oncopy) {
        document.addEventListener('select', () => {
            pendingTextSelection = undefined;
        });
        document.addEventListener('copy', (evt) => {
            if (pendingTextSelection) {
                evt.clipboardData.setData('text', pendingTextSelection);
                evt.preventDefault();
            }
        });
    }
};
//# sourceMappingURL=text-selection.js.map