"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const path_1 = require("path");
const client_json_1 = require("@kui-shell/client/config.d/client.json");
const events_1 = require("../../core/events");
const i18n_1 = require("../../util/i18n");
const path_2 = require("../../plugins/path");
const inject_1 = require("../util/inject");
const userdata_1 = require("../../core/userdata");
const find_1 = require("./find");
const default_1 = require("./default");
const strings = i18n_1.default('core');
const debug = debug_1.default('core/webapp/themes/persistence');
const persistedThemePreferenceKey = 'kui.theme.current';
exports.getPersistedThemeChoice = () => {
    return userdata_1.getPreference(persistedThemePreferenceKey);
};
function getCssFilepath(addon, plugin, apiVersion) {
    const base = path_1.dirname(require.resolve('@kui-shell/prescan.json'));
    if (!apiVersion || apiVersion === 'v1') {
        return path_1.join(base, 'build', client_json_1.cssHome, addon);
    }
    else {
        return path_1.join(base, plugin, 'web/css', addon);
    }
}
const getCss = (addon, addonKey, plugin, apiVersion) => __awaiter(void 0, void 0, void 0, function* () {
    if (!apiVersion || apiVersion === 'v1') {
        return {
            key: addonKey,
            path: path_1.join(client_json_1.cssHome, addon)
        };
    }
    else {
        return {
            key: addonKey,
            css: (yield Promise.resolve().then(() => require('@kui-shell/plugin-' + path_2.webpackPath(plugin) + '/web/css/' + addon.replace(/\.css$/, '') + '.css'))).default
        };
    }
});
function id(theme) {
    return `kui-theme-css-${theme.replace(/\s/g, '_')}`;
}
exports.switchTo = (theme, webContents, saveNotNeeded = false) => __awaiter(void 0, void 0, void 0, function* () {
    const themeWithPlugin = yield find_1.default(theme);
    if (!themeWithPlugin) {
        debug('could not find theme', theme);
        const error = new Error(strings('theme.unknown'));
        error.code = 404;
        throw error;
    }
    const { theme: themeModel, plugin } = themeWithPlugin;
    debug('switching to theme', theme);
    const { apiVersion } = themeModel;
    const addons = typeof themeModel.css === 'string' ? [themeModel.css] : themeModel.css;
    const themeKey = id(theme);
    if (!webContents) {
        const previousTheme = document.body.getAttribute('kui-theme');
        if (previousTheme) {
            const previous = yield find_1.default(previousTheme);
            if (previous) {
                const { theme: previousThemeModel } = previous;
                const previousKey = id(previousTheme);
                const previousNumAddons = typeof previousThemeModel.css === 'string' ? 1 : previousThemeModel.css.length;
                for (let idx = 0; idx < previousNumAddons; idx++) {
                    const addonKey = `${previousKey}-${idx}`;
                    yield inject_1.uninjectCSS({ key: addonKey });
                }
                if (previousThemeModel.attrs) {
                    previousThemeModel.attrs.forEach(attr => document.body.classList.remove(attr));
                }
            }
        }
    }
    try {
        yield Promise.all(addons.map((addon, idx) => __awaiter(void 0, void 0, void 0, function* () {
            debug('injecting theme addon', addon);
            const addonKey = `${themeKey}-${idx}`;
            if (webContents) {
                const { readFile } = yield Promise.resolve().then(() => require('fs-extra'));
                const pathToThemeCss = getCssFilepath(addon, plugin, apiVersion);
                const css = (yield readFile(pathToThemeCss)).toString();
                debug('using electron to pre-inject CSS before the application loads, from the main process');
                return webContents.insertCSS(css);
            }
            else {
                debug('injecting CSS', addon, plugin, apiVersion);
                return inject_1.injectCSS(yield getCss(addon, addonKey, plugin, apiVersion));
            }
        })));
    }
    catch (err) {
        debug('error loading theme');
        console.error(err);
        throw err;
    }
    if (!saveNotNeeded) {
        yield userdata_1.setPreference(persistedThemePreferenceKey, theme);
    }
    if (webContents) {
        let script = `
document.body.setAttribute('kui-theme', '${theme}');
document.body.setAttribute('kui-theme-key', '${themeKey}');
document.body.setAttribute('kui-theme-style', '${themeModel.style}');`;
        if (themeModel.attrs) {
            themeModel.attrs.forEach(attr => {
                script = `${script}document.body.classList.add('${attr}')`;
            });
        }
        webContents.executeJavaScript(script);
    }
    else {
        document.body.setAttribute('kui-theme', theme);
        document.body.setAttribute('kui-theme-key', themeKey);
        document.body.setAttribute('kui-theme-style', themeModel.style);
        if (themeModel.attrs) {
            themeModel.attrs.forEach(attr => document.body.classList.add(attr));
        }
        setTimeout(() => events_1.default.emit('/theme/change', { theme }));
    }
});
exports.switchToPersistedThemeChoice = (webContents, isDarkMode = false) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const theme = yield exports.getPersistedThemeChoice();
        if (theme) {
            debug('switching to persisted theme choice');
            try {
                yield exports.switchTo(theme, webContents, true);
            }
            catch (err) {
                debug('error switching to persisted theme choice, using default');
                yield exports.switchTo(yield default_1.default(isDarkMode), webContents, true);
            }
        }
        else {
            debug('no persisted theme choice');
            yield exports.switchTo(yield default_1.default(), webContents, true);
        }
    }
    catch (err) {
        console.error('cannot find a theme', err);
    }
});
exports.resetToDefault = () => __awaiter(void 0, void 0, void 0, function* () {
    debug('reset');
    yield userdata_1.clearPreference(persistedThemePreferenceKey);
    yield exports.switchTo(yield default_1.default());
    return true;
});
//# sourceMappingURL=persistence.js.map