"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sidecar_core_1 = require("./sidecar-core");
const dom_1 = require("../util/dom");
function getBadgesDomContainer(sidecar) {
    const badgesDomContainer = sidecar.querySelector('.header-right-bits .custom-header-content');
    let badgesDom = badgesDomContainer.querySelector('.badges');
    if (!badgesDom) {
        badgesDom = document.createElement('span');
        badgesDom.classList.add('badges');
        badgesDomContainer.appendChild(badgesDom);
    }
    else {
        dom_1.removeAllDomChildren(badgesDom);
    }
    return { badgesDomContainer, badgesDom };
}
exports.getBadgesDomContainer = getBadgesDomContainer;
class DefaultBadgeOptions {
    constructor(tab) {
        const { badgesDom } = getBadgesDomContainer(sidecar_core_1.getSidecar(tab));
        this.badgesDom = badgesDom;
    }
}
exports.DefaultBadgeOptions = DefaultBadgeOptions;
function isHTMLImage(img) {
    return img.alt !== undefined;
}
exports.addBadge = (tab, badgeText, { css, onclick, badgesDom = new DefaultBadgeOptions(tab).badgesDom } = new DefaultBadgeOptions(tab)) => {
    const badge = document.createElement('badge');
    badgesDom.appendChild(badge);
    if (typeof badgeText === 'string') {
        badge.innerText = badgeText;
    }
    else if (badgeText instanceof Element) {
        badge.appendChild(badgeText);
        badge.classList.add('badge-as-image');
    }
    else {
        if (badgeText.image) {
            if (isHTMLImage(badgeText.image)) {
                badgeText.image.alt = badgeText.title;
            }
            badge.appendChild(badgeText.image);
            badge.classList.add('badge-as-image');
        }
        else if (badgeText.fontawesome) {
            const awesome = document.createElement('i');
            awesome.className = badgeText.fontawesome;
            badge.classList.add('badge-as-fontawesome');
            badge.appendChild(awesome);
        }
        else {
            badge.innerText = badgeText.title;
            if (badgeText.css) {
                badge.classList.add(badgeText.css);
            }
        }
        if (badgeText.onclick) {
            badge.classList.add('clickable');
            badge.onclick = badgeText.onclick;
        }
    }
    if (css) {
        badge.classList.add(css);
    }
    if (onclick) {
        badge.classList.add('clickable');
        badge.onclick = onclick;
    }
    return badge;
};
exports.clearBadges = (tab) => {
    const sidecar = sidecar_core_1.getSidecar(tab);
    const header = sidecar.querySelector('.sidecar-header');
    dom_1.removeAllDomChildren(header.querySelector('.badges'));
};
function hasBadge(tab, cls) {
    const sidecar = sidecar_core_1.getSidecar(tab);
    const header = sidecar.querySelector('.sidecar-header');
    return !!header.querySelector(`.badges ${cls}`);
}
exports.hasBadge = hasBadge;
//# sourceMappingURL=badge.js.map