"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const debug = debug_1.default('webapp/views/sidecar-init');
const keys_1 = require("../keys");
const popup_core_1 = require("../popup-core");
const tab_1 = require("../tab");
const scroll_1 = require("../scroll");
const sidecar_selector_1 = require("./sidecar-selector");
const events_1 = require("../../core/events");
const sidecar_visibility_1 = require("./sidecar-visibility");
const registerWindowButtonsListeners = (tab) => {
    sidecar_selector_1.default(tab, '.toggle-sidecar-maximization-button').onclick = () => {
        debug('toggle sidecar maximization');
        sidecar_visibility_1.toggleMaximization(tab, 'user');
    };
    sidecar_selector_1.default(tab, '.toggle-sidecar-button').onclick = () => {
        debug('toggle sidecar visibility');
        sidecar_visibility_1.toggle(tab);
    };
    sidecar_selector_1.default(tab, '.sidecar-bottom-stripe-quit').onclick = () => {
        try {
            if (popup_core_1.isPopup()) {
                debug('quit button click');
                window.close();
            }
            else {
                debug('close sidecar button click');
                sidecar_visibility_1.clearSelection(tab);
            }
        }
        catch (err) {
            console.error('error handling quit button click', err);
        }
    };
};
exports.default = () => __awaiter(void 0, void 0, void 0, function* () {
    document.addEventListener('keydown', (event) => __awaiter(void 0, void 0, void 0, function* () {
        if (event.keyCode === keys_1.keys.LEFT_ARROW && (event.ctrlKey || (process.platform === 'darwin' && event.metaKey))) {
            const { css: bottomStripeCSS } = yield Promise.resolve().then(() => require('../bottom-stripe'));
            const tab = tab_1.getTabFromTarget(event.srcElement);
            const back = bottomStripeCSS.backButton(tab);
            const clickEvent = document.createEvent('Events');
            clickEvent.initEvent('click', true, false);
            back.dispatchEvent(clickEvent);
        }
    }));
    document.addEventListener('keyup', (evt) => {
        if (document.activeElement &&
            !(document.activeElement === document.body ||
                document.activeElement.classList.contains('inputarea') ||
                document.activeElement.classList.contains('repl-input-element'))) {
            return;
        }
        if (evt.keyCode === keys_1.keys.ESCAPE) {
            if (!popup_core_1.isPopup()) {
                const tab = tab_1.getTabFromTarget(evt.srcElement);
                const closeButton = sidecar_selector_1.default(tab, '.sidecar-bottom-stripe-close');
                if (sidecar_visibility_1.isVisible(tab)) {
                    closeButton.classList.add('hover');
                    setTimeout(() => closeButton.classList.remove('hover'), 500);
                }
                sidecar_visibility_1.toggle(tab);
                scroll_1.scrollIntoView();
            }
        }
    });
    registerWindowButtonsListeners(tab_1.getCurrentTab());
    events_1.default.on('/tab/new', (tab) => {
        registerWindowButtonsListeners(tab);
    });
});
//# sourceMappingURL=sidecar-init.js.map