"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sidecar_core_1 = require("./sidecar-core");
var SidecarState;
(function (SidecarState) {
    SidecarState[SidecarState["NotShown"] = 0] = "NotShown";
    SidecarState[SidecarState["Minimized"] = 1] = "Minimized";
    SidecarState[SidecarState["Open"] = 2] = "Open";
    SidecarState[SidecarState["FullScreen"] = 3] = "FullScreen";
})(SidecarState = exports.SidecarState || (exports.SidecarState = {}));
exports.getSidecarState = (tab) => {
    const sidecar = sidecar_core_1.getSidecar(tab);
    if (tab.classList.contains('sidecar-full-screen')) {
        return SidecarState.FullScreen;
    }
    else if (sidecar.classList.contains('visible')) {
        return SidecarState.Open;
    }
    else if (sidecar.classList.contains('minimized')) {
        return SidecarState.Minimized;
    }
    else {
        return SidecarState.NotShown;
    }
};
//# sourceMappingURL=sidecar-state.js.map