import { Sidecar, getSidecar, CustomSpec, CustomContent } from './sidecar-core';
export { Sidecar, getSidecar, CustomSpec, CustomContent };
import { BadgeSpec, Badge, BadgeOptions } from './badge';
export { BadgeSpec, Badge, BadgeOptions };
import { Tab } from '../tab';
import { ShowOptions } from './show-options';
import { ToolbarText } from './toolbar-text';
import Presentation from './presentation';
import { MetadataBearing, MetadataBearingByReference, isMetadataBearingByReference, Entity } from '../../models/entity';
import { ParsedOptions } from '../../models/command';
import { ExecOptions } from '../../models/execOptions';
export { MetadataBearingByReference };
export { isMetadataBearingByReference };
export declare const maybeHideEntity: (tab: Tab, entity: Entity<void, import("../..").Row, MetadataBearing<void>>) => boolean;
export declare const getActiveView: (tab: Tab) => Element;
export declare const addVersionBadge: (tab: Tab, entity: MetadataBearing<void> | CustomSpec<void>, { clear, badgesDom }?: {
    clear?: boolean;
    badgesDom?: HTMLElement;
}) => void;
export declare const addSidecarHeaderIconText: (viewName: string, sidecar: HTMLElement) => void;
export declare const getEnclosingTab: (sidecar: Sidecar) => Tab;
export declare const addNameToSidecarHeader: (sidecar: Sidecar, name: string | Element, packageName?: string, onclick?: () => void, viewName?: string, subtext?: string | HTMLElement | ToolbarText | Promise<string> | Promise<HTMLElement>, entity?: MetadataBearing<void> | MetadataBearingByReference<void> | CustomSpec<void>) => Promise<Element>;
export declare const showCustom: (tab: Tab, custom: CustomSpec<void>, options?: ExecOptions, argvNoOptions?: string[], parsedOptions?: ParsedOptions, resultDom?: Element) => Promise<Presentation>;
export declare type ISidecarViewHandler = (tab: Tab, entity: Object, sidecar: Element, options: ShowOptions) => void;
export declare const registerEntityView: (kind: string, handler: ISidecarViewHandler) => void;
export declare const insertCustomContent: (tab: Tab, view: HTMLElement) => void;
