/*
 * Copyright 2019 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
// Capabilities
export { hasProxy, getValidCredentials, inBrowser, inElectron, isHeadless, assertLocalAccess, assertHasProxy, setHasAuth, getAuthValue } from './core/capabilities';
// Commands
export { ExecType } from './models/command';
export { optionsToString as unparse } from './core/utility';
export { isMetadataBearingByReference as isResourceByReference } from './models/entity';
export { isCommandHandlerWithEvents } from './models/command';
export { withLanguage } from './models/execOptions';
// Editor registration
export { registerEditor } from './webapp/views/registrar/editors';
export { isUsageError, UsageError } from './core/usage-error';
// eventBus
export { default as eventBus } from './core/events';
// i18n
export { fromMap as i18nFromMap, default as i18n } from './util/i18n';
// content injection
export { injectCSS, injectScript, loadHTML } from './webapp/util/inject';
// eslint-disable-next-line @typescript-eslint/no-unused-vars
export function History(tab) {
    return __awaiter(this, void 0, void 0, function* () {
        const model = (yield import('./models/history')).default;
        return model;
    });
}
// pretty printing
export { prettyPrintTime } from './webapp/util/time';
export { default as stripAnsi } from './webapp/util/strip-ansi';
export { default as prettyPrintAnsi } from './webapp/util/pretty-print';
export function AsciiFormatters() {
    return __awaiter(this, void 0, void 0, function* () {
        const [{ formatUsage }, { preprocessTable, formatTable }] = yield Promise.all([
            import(/* webpackMode: "lazy" */ './webapp/util/ascii-to-usage'),
            import(/* webpackMode: "lazy" */ './webapp/util/ascii-to-table')
        ]);
        return { formatUsage, preprocessTable, formatTable };
    });
}
export { registerModeWhen, registerSidecarMode as registerMode } from './webapp/views/registrar/modes';
export { registerSidecarBadge as registerBadge } from './webapp/views/registrar/badges';
// REPL utils
export { split, _split } from './repl/split';
export { DirectReplEval } from './repl/types';
export { default as encodeComponent } from './repl/encode';
export { getImpl as getReplImpl, exec as internalBeCarefulExec, pexec as internalBeCarefulPExec, setEvaluatorImpl } from './repl/exec';
// Selection
export { 
/** @deprecated */ isVisible as isSidecarVisible, 
/** @deprecated */ isFullscreen as isSidecarFullscreen, 
/** @deprecated */ hide as hideSidecar, 
/** @deprecated */ show as showSidecar, 
/** @deprecated */ toggleMaximization, clearSelection, currentSelection } from './webapp/views/sidecar-visibility';
export { /** @deprecated */ SidecarState, /** @deprecated */ getSidecarState } from './webapp/views/sidecar-state';
export { clearSelection as closeAllViews } from './webapp/views/sidecar-visibility';
export { /** @deprecated */ default as sidecarSelector } from './webapp/views/sidecar-selector';
// Tabs
export { getTabFromTarget, getCurrentTab, getTabId, sameTab } from './webapp/tab';
export { default as TabState } from './models/tab-state';
export { findByName as findThemeByName } from './webapp/themes/find';
export { getDefault as getDefaultTheme } from './webapp/themes/default';
export { switchTo as switchToTheme, getPersistedThemeChoice, resetToDefault as resetToDefaultTheme } from './webapp/themes/persistence';
// CLI
export { getPrompt, getCurrentPrompt, getCurrentPromptLeft, getBlockOfPrompt, setUsingCustomPrompt, unsetUsingCustomPrompt } from './webapp/prompt';
export { getCurrentBlock, getCurrentProcessingBlock, resetCount, setCustomCaret } from './webapp/block';
export { setStatus } from './webapp/status';
export { listen as internalBeCarefulListen } from './webapp/listen';
export { disableInputQueueing, pasteQueuedInput } from './webapp/queueing';
export { clearPendingTextSelection, setPendingTextSelection, clearTextSelection } from './webapp/text-selection';
// generic UI
export { isPopup } from './webapp/popup-core';
export { removeAllDomChildren as empty } from './webapp/util/dom';
export { default as Presentation } from './webapp/views/presentation';
export { ToolbarTextImpl as ToolbarText } from './webapp/views/toolbar-text';
// low-level UI
export { partial as partialInput, isUsingCustomPrompt } from './webapp/prompt';
export { scrollIntoView } from './webapp/scroll';
export { default as doCancel } from './webapp/cancel';
export { default as ElementMimic } from './util/element-mimic';
export { keys as KeyCodes, isCursorMovement } from './webapp/keys';
export { buttonExists as topTabButtonExists, addIcon as topTabAddIcon, removeIcon as topTabRemoveIcon } from './webapp/views/top-tabs';
// Prompt
export { prompt } from './webapp/prompt-for-input';
// Plugins
export { commandsOffered as commandsOfferedByPlugin, userHome as pluginUserHome } from './api/plugins';
// Settings
export { inBottomInputMode, userDataDir, uiThemes } from './core/settings';
// Storage for user data
export { default as Store } from './models/store';
// SymbolTable
export { default as SymbolTable } from './core/symbol-table';
// Tables
export { TableStyle, Table, Row, Cell, isTable } from './webapp/models/table';
// Util
export { findFileWithViewer, findFile, isSpecialDirectory, addPath as augmentModuleLoadPath } from './core/find-file';
export { expandHomeDir } from './util/home';
export { flatten } from './core/utility';
export { promiseEach } from './util/async';
// Electron
export { tellMain } from './webapp/electron-events';
// main
export { main } from './main/main';
export { default as boot } from './webapp/bootstrap/boot';
//# sourceMappingURL=index.js.map