import { SidecarMode } from './bottom-stripe';
import { Badge } from './views/badge';
import Presentation from './views/presentation';
import Formattable from './views/formattable';
import { ExecOptions } from '../models/execOptions';
export interface PopupEntity {
    prettyType?: string;
    modes?: SidecarMode[];
    badges?: Badge[];
    controlHeaders?: boolean | string[];
    presentation?: Presentation;
    subtext?: Formattable;
}
/**
 * Render popup content in the given container
 *
 */
export declare const renderPopupContent: (command: string, container: Element, execOptions: ExecOptions, entity?: PopupEntity) => Promise<void>;
/** create a popup content container */
export declare const createPopupContentContainer: (css?: string[], presentation?: Presentation) => HTMLElement;
