import { Tab } from './tab';
import { Block } from './models/block';
import { Entity } from '../models/entity';
declare type PromptCompleter = RepromptSpec | Promise<Entity>;
interface RepromptSpec {
    completion?: PromptCompletionHandler;
    onpaste?: string;
    placeholder?: string;
    reprompt?: boolean;
}
interface PromptCompletionData {
    field: string;
}
export declare type PromptCompletionHandler = (data: PromptCompletionData) => PromptCompleter;
interface PromptOptions {
    dangerous?: boolean;
    placeholder?: string;
    onpaste?: string;
    paste?: (evt: ClipboardEvent) => void;
    type?: string;
}
/**
 * Prompt the user for information
 *
 */
export declare const prompt: (msg: string, block: Block, nextBlock: HTMLElement, tab: Tab, options: PromptOptions, completion: PromptCompletionHandler) => {
    mode: "prompt";
};
export {};
