import { Tab } from './tab';
import { ExecOptions } from '../models/execOptions';
export interface Prompt extends HTMLInputElement {
    execOptions?: ExecOptions;
}
export declare const getBlockOfPrompt: (prompt: HTMLInputElement) => HTMLElement;
export declare const getPrompt: (block: HTMLElement) => Prompt;
export declare const getBottomPrompt: () => HTMLInputElement;
export declare const getInitialPrompt: (tab: Tab) => HTMLInputElement;
export declare const getCurrentPrompt: (tab?: Tab) => Prompt;
export declare const getPromptFromTarget: (target: EventTarget) => HTMLInputElement;
export declare const getPromptLeft: (block: Element) => Element;
export declare const getCurrentPromptLeft: (tab: Tab) => Element;
export declare function installContext(block: HTMLElement): void;
/**
 * Has a plugin taken ownership of the prompt?
 *
 */
export declare function isUsingCustomPrompt(prompt: HTMLInputElement): boolean;
/**
 * Paste a command, but do not eval it
 *
 */
export declare const partial: (cmd: string, execOptions?: ExecOptions) => void;
/**
 * A plugin temporary wishes to manage the prompt, e.g. reverse-i-search
 *
 */
export declare function setUsingCustomPrompt(block: HTMLElement): void;
/**
 * A plugin temporary wishes to relinquish management of the prompt
 *
 */
export declare function unsetUsingCustomPrompt(block: HTMLElement): void;
