/*
 * Copyright 2017-19 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Clear current text selection
 *
 */
export const clearTextSelection = () => {
    try {
        window.getSelection().removeAllRanges();
    }
    catch (err) {
        console.error('unable to clear text selection', err);
    }
};
/**
 * Allow for plugins to self-manage text selection
 *
 */
let pendingTextSelection;
export const clearPendingTextSelection = () => {
    pendingTextSelection = undefined;
};
export const setPendingTextSelection = (str) => {
    pendingTextSelection = str;
    if (!document.oncopy) {
        document.addEventListener('select', () => {
            pendingTextSelection = undefined;
        });
        document.addEventListener('copy', (evt) => {
            if (pendingTextSelection) {
                evt.clipboardData.setData('text', pendingTextSelection);
                evt.preventDefault();
            }
        });
    }
};
//# sourceMappingURL=text-selection.js.map