interface StylesheetDirect {
    css: string;
    key: string;
}
interface StylesheetFile {
    path: string;
    key: string;
}
declare type StylesheetSpec = StylesheetDirect | StylesheetFile | string;
/**
 * Inject a stylesheet
 *
 */
export declare const injectCSS: (file: StylesheetSpec) => void;
/**
 * Remove a stylesheet
 *
 */
export declare const uninjectCSS: ({ key }: {
    key: string;
}) => void;
/**
 * Inject a script
 *
 */
export declare const injectScript: (url: string | {
    key: string;
    src: string;
}) => Promise<void>;
/**
 * Inject HTML stored in the given local file
 *
 */
export declare const loadHTML: (file: any) => Promise<string>;
export {};
