/*
 * Copyright 2017-19 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { getSidecar } from './sidecar-core';
import { removeAllDomChildren } from '../util/dom';
/**
 * Return the DOM elements housing the sidecar badges
 *
 */
export function getBadgesDomContainer(sidecar) {
    const badgesDomContainer = sidecar.querySelector('.header-right-bits .custom-header-content');
    let badgesDom = badgesDomContainer.querySelector('.badges');
    if (!badgesDom) {
        badgesDom = document.createElement('span');
        badgesDom.classList.add('badges');
        badgesDomContainer.appendChild(badgesDom);
    }
    else {
        removeAllDomChildren(badgesDom);
    }
    return { badgesDomContainer, badgesDom };
}
export class DefaultBadgeOptions {
    constructor(tab) {
        const { badgesDom } = getBadgesDomContainer(getSidecar(tab));
        this.badgesDom = badgesDom;
    }
}
function isHTMLImage(img) {
    return img.alt !== undefined;
}
export const addBadge = (tab, badgeText, { css, onclick, badgesDom = new DefaultBadgeOptions(tab).badgesDom } = new DefaultBadgeOptions(tab)) => {
    // debug('addBadge', badgeText, badgesDom)
    const badge = document.createElement('badge');
    badgesDom.appendChild(badge);
    if (typeof badgeText === 'string') {
        badge.innerText = badgeText;
    }
    else if (badgeText instanceof Element) {
        badge.appendChild(badgeText);
        badge.classList.add('badge-as-image');
    }
    else {
        // otherwise, badge is an IBadgeSpec
        if (badgeText.image) {
            // badge is an HTMLImageElement
            if (isHTMLImage(badgeText.image)) {
                badgeText.image.alt = badgeText.title;
            }
            badge.appendChild(badgeText.image);
            badge.classList.add('badge-as-image');
        }
        else if (badgeText.fontawesome) {
            // badge is a named fontawesome icon
            const awesome = document.createElement('i');
            awesome.className = badgeText.fontawesome;
            badge.classList.add('badge-as-fontawesome');
            badge.appendChild(awesome);
        }
        else {
            badge.innerText = badgeText.title;
            if (badgeText.css) {
                badge.classList.add(badgeText.css);
            }
        }
        if (badgeText.onclick) {
            badge.classList.add('clickable');
            badge.onclick = badgeText.onclick;
        }
    }
    if (css) {
        badge.classList.add(css);
    }
    if (onclick) {
        badge.classList.add('clickable');
        badge.onclick = onclick;
    }
    return badge;
};
export const clearBadges = (tab) => {
    const sidecar = getSidecar(tab);
    const header = sidecar.querySelector('.sidecar-header');
    removeAllDomChildren(header.querySelector('.badges'));
};
export function hasBadge(tab, cls) {
    const sidecar = getSidecar(tab);
    const header = sidecar.querySelector('.sidecar-header');
    return !!header.querySelector(`.badges ${cls}`);
}
//# sourceMappingURL=badge.js.map