import { Tab } from '../../tab';
import { SidecarModeFilter } from './modes';
import { MetadataBearing } from '../../../models/entity';
import { BadgeSpec, BadgeOptions } from '../badge';
/**
 * Interpretation: if the resource passes the given "when" filter,
 * then add the given sidecar badge
 *
 */
export interface BadgeRegistration<Resource extends MetadataBearing> {
    when: SidecarModeFilter<Resource>;
    badge: BadgeSpec | ((resource: Resource, tab: Tab) => BadgeSpec);
}
/**
 * Register a new badge
 *
 */
export declare function registerSidecarBadge<Resource extends MetadataBearing>(registration: BadgeRegistration<Resource>): void;
export default registerSidecarBadge;
/**
 * Add all registered badges that are relevant to the given resource
 *
 */
export declare function apply<Resource extends MetadataBearing>(tab: Tab, entity: {
    resource: Resource;
}, badgeOptions: BadgeOptions): void;
