/*
 * Copyright 2017-19 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Text to be displayed in the sidecar toolbar
 *
 */
import * as Marked from 'marked';
import { element } from '../util/dom';
export class ToolbarTextImpl {
    // eslint doesn't recognize the typescript constructor-settor syntax
    // eslint-disable-next-line no-useless-constructor
    constructor(type, text) {
        this.type = type;
        this.text = text;
    }
    attach(owner) {
        this._container = element('.sidecar-bottom-stripe-toolbar .sidecar-toolbar-text', owner);
        return this;
    }
    refresh() {
        if (this._container) {
            const content = element('.sidecar-toolbar-text-content', this._container);
            if (typeof this.text === 'string') {
                content.innerHTML = Marked(this.text);
            }
            else {
                content.appendChild(this.text);
            }
            this._container.setAttribute('data-type', this.type);
        }
    }
}
export function isToolbarText(subtext) {
    const spec = subtext;
    return spec && spec.type !== undefined && spec.text !== undefined;
}
export function isRefreshableToolbarText(ttext) {
    const refreshable = ttext;
    return refreshable.attach !== undefined && refreshable.refresh !== undefined;
}
//# sourceMappingURL=toolbar-text.js.map