/// <reference types="node" />
import { Server } from 'https';
import { Channel } from './channel';
import { Registrar } from '@kui-shell/core';
export declare type ExitHandler = (exitCode: number) => void;
interface Session {
    uid: number;
    gid: number;
    token: string;
}
export interface SessionCookie {
    key: string;
    session: Session;
}
export declare const disableBashSessions: () => Promise<ExitHandler>;
declare type Shell = {
    shellExe: string;
    shellOpts: string[];
};
export declare const getLoginShell: () => Promise<Shell>;
export declare function setShellAliases(aliases: Record<string, string>): void;
export declare const onConnection: (exitNow: ExitHandler, uid?: number, gid?: number) => (ws: Channel) => Promise<void>;
export declare const main: (N: string, server?: Server, preexistingPort?: number, expectedCookie?: SessionCookie) => Promise<number | {
    wss: Server;
    port: number;
}>;
declare const _default: (commandTree: Registrar) => void;
export default _default;
