"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const core_1 = require("@kui-shell/core");
const style_json_1 = require("@kui-shell/client/config.d/style.json");
const proxy_json_1 = require("@kui-shell/client/config.d/proxy.json");
const channel_1 = require("./channel");
const ui_1 = require("./ui");
const strings = core_1.i18n('plugin-bash-like');
const debug = debug_1.default('plugins/bash-like/pty/session');
function getChannelForTab(tab) {
    return tab['ws'];
}
exports.getChannelForTab = getChannelForTab;
function getSessionForTab(tab) {
    return __awaiter(this, void 0, void 0, function* () {
        if (tab['_kui_session'] === undefined && core_1.inElectron()) {
            const channel = new channel_1.InProcessChannel();
            yield channel.init();
            tab['_kui_session'] = Promise.resolve(channel);
            return tab['_kui_session'];
        }
        else {
            return tab['_kui_session'];
        }
    });
}
exports.getSessionForTab = getSessionForTab;
function pollUntilOnline(tab, block) {
    const sessionInitialization = new Promise(resolve => {
        let placeholderChanged = false;
        let previousText;
        const once = (iter = 0) => {
            debug('trying to establish session', tab);
            if (!block) {
                block = core_1.getCurrentBlock(tab) || core_1.getCurrentProcessingBlock(tab);
                const prompt = core_1.getPrompt(block);
                prompt.readOnly = true;
                prompt.placeholder = strings('Please wait while we connect to your cloud');
                placeholderChanged = true;
                previousText = prompt.value;
                prompt.value = '';
                core_1.setStatus(block, "processing");
            }
            return tab.REPL.qexec('echo initializing session', block, undefined, {
                tab,
                quiet: true,
                noHistory: true,
                replSilence: true,
                rethrowErrors: true,
                echo: false
            })
                .then(() => {
                try {
                    ui_1.setOnline();
                    if (placeholderChanged) {
                        const prompt = core_1.getPrompt(block);
                        prompt.readOnly = false;
                        prompt.placeholder = style_json_1.promptPlaceholder || '';
                        core_1.setStatus(block, "repl-active");
                        if (previousText) {
                            prompt.value = previousText;
                            previousText = undefined;
                        }
                        prompt.focus();
                    }
                }
                catch (err) {
                    console.error('error updating UI to indicate that we are online', err);
                }
                resolve(getChannelForTab(tab));
            })
                .catch(error => {
                const err = error;
                if (err.code !== 503) {
                    console.error('error establishing session', err.code, err.statusCode, err);
                }
                ui_1.setOffline();
                setTimeout(() => once(iter + 1), iter < 10 ? 2000 : iter < 100 ? 4000 : 10000);
                return strings('Could not establish a new session');
            });
        };
        once();
    });
    tab['_kui_session'] = sessionInitialization;
    return sessionInitialization;
}
exports.pollUntilOnline = pollUntilOnline;
function newSessionForTab(tab) {
    tab['_kui_session'] = new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
        try {
            const block = core_1.getCurrentBlock(tab);
            const prompt = core_1.getCurrentPrompt(tab);
            prompt.readOnly = true;
            let placeholderChanged = false;
            const sessionInitialization = pollUntilOnline(tab, block);
            const placeholderAsync = setTimeout(() => {
                prompt.placeholder = strings('Please wait while we connect to your cloud');
                core_1.setStatus(block, "processing");
                placeholderChanged = true;
            }, proxy_json_1.millisBeforeProxyConnectionWarning);
            yield sessionInitialization;
            clearTimeout(placeholderAsync);
            prompt.readOnly = false;
            if (placeholderChanged) {
                core_1.setStatus(block, "repl-active");
                prompt.placeholder = style_json_1.promptPlaceholder || '';
                yield tab.REPL.pexec('ready', { tab });
            }
            tab.classList.add('kui--session-init-done');
            resolve(getChannelForTab(tab));
        }
        catch (err) {
            reject(err);
        }
    }));
}
function registerCommands(commandTree) {
    commandTree.listen('/ready', ({ REPL }) => {
        const message = document.createElement('pre');
        message.appendChild(document.createTextNode(strings('Successfully connected to your cloud. For next steps, try this command: ')));
        const clicky = document.createElement('span');
        clicky.className = 'clickable clickable-blatant';
        clicky.innerText = 'getting started';
        clicky.onclick = () => REPL.pexec('getting started');
        message.appendChild(clicky);
        return message;
    }, { inBrowserOk: true, noAuthOk: true, hidden: true });
}
exports.registerCommands = registerCommands;
function init() {
    return __awaiter(this, void 0, void 0, function* () {
        if (core_1.inBrowser() && proxy_json_1.proxyServer.enabled !== false) {
            debug('initializing pty sessions');
            const { eventBus } = yield Promise.resolve().then(() => require('@kui-shell/core'));
            eventBus.on('/tab/new', (tab) => {
                newSessionForTab(tab);
            });
            eventBus.on('/tab/close', (tab) => __awaiter(this, void 0, void 0, function* () {
                try {
                    debug('closing session for tab');
                    getChannelForTab(tab).close();
                }
                catch (err) {
                    console.error('error terminating session for closed tab', err);
                }
            }));
        }
    });
}
exports.init = init;
//# sourceMappingURL=session.js.map