"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = require("debug");
const core_1 = require("@kui-shell/core");
const debug = debug_1.default('plugins/bash-like/pty/ui');
const buttonDesignation = 'kui--plugin-bash-like--pty-offline-indicator';
function presentation() {
    if (core_1.topTabButtonExists(buttonDesignation)) {
        return 'offline';
    }
    else {
        return 'online';
    }
}
function setOffline() {
    if (presentation() === 'online') {
        debug('setOffline');
        const tmp = document.createElement('span');
        tmp.innerHTML =
            '<svg focusable="false" preserveAspectRatio="xMidYMid meet" style="will-change: transform;" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 32 32" aria-hidden="true"><path d="M30 28.59L3.41 2 2 3.41l6.4 6.41L7 15.77A1 1 0 0 0 8 17h4.83L11 28.85a1 1 0 0 0 .6 1.07 1.09 1.09 0 0 0 .4.08 1 1 0 0 0 .79-.39l6.68-8.73L28.59 30zm-7.47-11.72l3.26-4.26a1 1 0 0 0 .11-1A1 1 0 0 0 25 11h-4.75L22 3.22a1 1 0 0 0-.2-.85A1 1 0 0 0 21 2H11a1 1 0 0 0-1 .77l-.3 1.3z"></path></svg>';
        const offlineIcon = tmp.querySelector('svg');
        core_1.topTabAddIcon(offlineIcon, buttonDesignation).classList.add('red-text');
    }
}
exports.setOffline = setOffline;
function setOnline() {
    debug('setOnline');
    core_1.topTabRemoveIcon(buttonDesignation);
}
exports.setOnline = setOnline;
//# sourceMappingURL=ui.js.map