"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const core_1 = require("@kui-shell/core");
const fstat = ({ argvNoOptions, parsedOptions }) => {
    return new Promise((resolve, reject) => {
        const filepath = argvNoOptions[1];
        const { resolved: fullpath, viewer = 'open' } = core_1.findFileWithViewer(core_1.expandHomeDir(filepath));
        const prettyFullPath = fullpath.replace(new RegExp(`^${process.env.HOME}`), '~');
        fs_1.stat(fullpath, (err, stats) => {
            if (err) {
                if (err.code === 'ENOENT') {
                    const error = new Error(err.message);
                    error.stack = err.stack;
                    error.code = 404;
                    reject(error);
                }
                else {
                    reject(err);
                }
            }
            else if (stats.isDirectory() || !parsedOptions['with-data']) {
                resolve({
                    mode: 'raw',
                    content: {
                        viewer,
                        filepath,
                        fullpath: prettyFullPath,
                        isDirectory: stats.isDirectory()
                    }
                });
            }
            else {
                fs_1.readFile(fullpath, (err, data) => {
                    if (err) {
                        reject(err);
                    }
                    else {
                        resolve({
                            mode: 'raw',
                            content: {
                                viewer,
                                filepath,
                                fullpath: prettyFullPath,
                                data: data.toString(),
                                isDirectory: false
                            }
                        });
                    }
                });
            }
        });
    });
};
exports.default = (commandTree) => {
    commandTree.listen('/fstat', fstat, {
        hidden: true,
        requiresLocal: true
    });
};
//# sourceMappingURL=fstat.js.map